<?php

declare(strict_types=1);

/*
 * This file is part of Contao.
 *
 * (c) Leo Feyer
 *
 * @license LGPL-3.0-or-later
 */

namespace Contao\CoreBundle\Migration\Version413;

use Contao\CoreBundle\Migration\AbstractMigration;
use Contao\CoreBundle\Migration\MigrationResult;
use Doctrine\DBAL\Connection;

/**
 * @internal
 */
class PlayerColorMigration extends AbstractMigration
{
    private Connection $connection;

    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    public function shouldRun(): bool
    {
        $schemaManager = $this->connection->createSchemaManager();

        if (!$schemaManager->tablesExist(['tl_content'])) {
            return false;
        }

        $columns = $schemaManager->listTableColumns('tl_content');

        if (!isset($columns['playercolor'])) {
            return false;
        }

        return (bool) $this->connection->fetchOne('SELECT TRUE from tl_content WHERE LENGTH(playerColor) > 6');
    }

    public function run(): MigrationResult
    {
        $this->connection->executeQuery("UPDATE tl_content SET playerColor = '' WHERE LENGTH(playerColor) > 6");

        return $this->createResult(true);
    }
}
