<?php

error_reporting(-1);

if (function_exists('ini_set')) {
    @ini_set('display_errors', 1);
    @ini_set('display_startup_errors', 1);
    @ini_set('opcache.enable_cli', '0');

    if (isset($_GET['opcache_reset']) && $_GET['opcache_reset'] === md5(Phar::running(false))) {
        $GLOBALS['opcacheEnabled'] = @ini_get('opcache.enable');
    } else {
        $GLOBALS['opcacheEnabled'] = @ini_set('opcache.enable', '0');
    }
}

if (PHP_VERSION_ID < 50509) {
    die('You are using PHP '.PHP_VERSION." but you need least PHP 5.5.9 to run the Contao Manager.\n");
}

if (!extension_loaded('Phar')) {
    echo 'PHP\'s phar extension is missing. Contao Manager requires it to run. Enable the extension or recompile php without --disable-phar then try again.' . PHP_EOL;
    exit(1);
}

if (('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) && isset($_SERVER['argv'][1]) && 'test' === $_SERVER['argv'][1]) {
    die(json_encode(['version' => PHP_VERSION, 'version_id' => PHP_VERSION_ID, 'sapi' => PHP_SAPI]));
}

if (PHP_VERSION_ID < 80100) {
    Phar::mapPhar('contao-manager.phar');
    @include 'phar://contao-manager.phar/downgrade.php';
    die('<script>setTimeout(function() { window.location.reload(true) }, 1000)</script>');
}

if (function_exists('date_default_timezone_set') && function_exists('date_default_timezone_get')) {
    date_default_timezone_set(@date_default_timezone_get());
}

if ('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) {
    Phar::mapPhar('contao-manager.phar');
    require 'phar://contao-manager.phar/api/console';
} else {
    function rewrites()
    {
        // The function argument is unreliable across servers, Nginx for example is always empty
        list(,$url) = explode(basename(__FILE__), $_SERVER['REQUEST_URI'], 2);

        if (strpos($url, '..')) {
            return false;
        }

        if ('' === $url) {
            header('Location: /'.basename(__FILE__).'/');
            exit;
        }

        if (0 === strpos($url, '/api/')) {
            return '/dist/api.php'.$url;
        }

        if (!empty($url) && is_file('phar://'.__FILE__.'/dist'.$url)) {
            return '/dist'.$url;
        }

        return '/dist/index.html';
    }

    Phar::webPhar(
        null,
        'index.html',
        null,
        array(
            'log' => 'text/plain',
            'txt' => 'text/plain',
            'php' => Phar::PHP, // parse as PHP
            'css' => 'text/css',
            'gif' => 'image/gif',
            'html' => 'text/html',
            'ico' => 'image/x-ico',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'js' => 'application/x-javascript',
            'png' => 'image/png',
            'svg' => 'image/svg+xml',
            'json' => 'application/json'
        ),
        'rewrites'
    );
}

__HALT_COMPILER(); ?>
                  .box/bin/check-requirements.php  Ng  ^ʨ         .box/.requirements.php:  Ng:  *ä         .box/vendor/autoload.php   Ng   s      ,   .box/vendor/composer/autoload_namespaces.php   Ng   t!פ         .box/vendor/composer/LICENSE.  Ng.         $   .box/vendor/composer/ClassLoader.php>  Ng>  5Ky      &   .box/vendor/composer/autoload_psr4.php6  Ng6   0Ӥ      *   .box/vendor/composer/autoload_classmap.php,
  Ng,
  ӽǤ      (   .box/vendor/composer/autoload_static.phpK  NgK  ?      &   .box/vendor/composer/autoload_real.php   Ng   yi\      .   .box/vendor/composer/semver/src/Comparator.phpu  Ngu  	74      *   .box/vendor/composer/semver/src/Semver.php  Ng  ׯ      1   .box/vendor/composer/semver/src/VersionParser.php9  Ng9  Wz      B   .box/vendor/composer/semver/src/Constraint/ConstraintInterface.php  Ng  wQ      >   .box/vendor/composer/semver/src/Constraint/MultiConstraint.php~  Ng~  5[e      9   .box/vendor/composer/semver/src/Constraint/Constraint.php'&  Ng'&  `         .box/src/Terminal.php
  Ng
  %V         .box/src/IO.php   Ng   [l%      !   .box/src/IsExtensionFulfilled.phpv  Ngv  '0Ҥ         .box/src/Checker.php  Ng  )W>      "   .box/src/IsPhpVersionFulfilled.php  Ng  !83      "   .box/src/RequirementCollection.php  Ng  Wb?         .box/src/Printer.php  Ng  )8AV         .box/src/IsFulfilled.phpv   Ngv   %*H         .box/src/Requirement.phpm  Ngm  B         LICENSE  Ng  p         dist/index.htmlH'  NgH'  Oj         dist/api.php--  Ng  L|R         dist/css/367.25211792.cssl  Ngl  A         dist/css/522.44f2aba0.cssO  NgO  o         dist/css/101.93b3a21a.css0  Ng0  	G         dist/css/909.2589534e.css  Ng           dist/css/app.4499f9f0.css  Ng  d֤         dist/css/826.11002f25.css  Ng  +         dist/css/335.c4dd1cd6.css8?  Ng8?           dist/css/904.3a60e65a.css  Ng  i_Ӥ      #   dist/css/chunk-vendors.4e650cae.csss  Ngs   -         dist/css/716.e18cb2b2.css  Ng  26&         dist/js/120.ad9ecc53.jsp  Ngp           dist/js/523.14592c65.js  Ng  3         dist/js/904.700bee3e.js  Ng  e         dist/js/669.deb99932.jsz  Ngz  YH         dist/js/335.36b98a5b.js  Ng  .֡         dist/js/60.15d99754.jsI"  NgI"  H[         dist/js/706.92fdcdbe.js  Ng  N         dist/js/518.16da88f4.jsk  Ngk  BZf         dist/js/851.cca0da18.jsE  NgE  >C         dist/js/909.c6e108d0.js  Ng  kؤ         dist/js/553.852786ac.js$  Ng$  [웤         dist/js/142.5a4db656.jsM  NgM  b         dist/js/44.03c4709c.js  Ng  3|         dist/js/953.cfd6dc8d.js.  Ng.           dist/js/958.7fdd57a1.jsS  NgS  CIsƤ         dist/js/542.a77d6afc.js  Ng           dist/js/164.8ff4e0cc.jsH  NgH  AJ         dist/js/606.aef917ea.js  Ng  WW.         dist/js/180.25fde044.js  Ng  o         dist/js/874.cb764366.js  Ng  h[         dist/js/748.1113c4dd.js  Ng  ec         dist/js/551.2f231c49.jsf  Ngf           dist/js/367.e90b0889.jsr
  Ngr
  Ʊt         dist/js/52.53a6eeda.js  Ng  yW         dist/js/954.1768db0c.jsA  NgA  XM         dist/js/28.ceef267d.jsw  Ngw  Ig0         dist/js/219.c00b841d.js
  Ng
  C
F         dist/js/522.708d4dad.jsQ  NgQ  5-         dist/js/721.92ab0b05.js  Ng  ƿ         dist/js/581.34ad7ec7.js  Ng  4         dist/js/139.52c8c876.jsU  NgU  x0L6         dist/js/194.1e21e427.js  Ng  ИU         dist/js/540.49057a93.js  Ng  /6<         dist/js/560.56a43728.js  Ng  s         dist/js/554.9db876b8.js  Ng  6Au!         dist/js/643.8cfe4f9d.jsš  Ngš  ƛ         dist/js/826.8e921839.jsV-  NgV-  @b         dist/js/477.7f48000c.jsǦ  NgǦ  ?EW         dist/js/557.9a8ca5d7.js  Ng  =]ɤ         dist/js/140.9f138779.js=  Ng=  3N         dist/js/710.aa0213da.js| Ng| gǘk         dist/js/486.dbfe136b.js  Ng  !      !   dist/js/chunk-vendors.752082b1.jsE NgE z.         dist/js/715.8105845a.js  Ng  u         dist/js/716.193b4a3c.js
  Ng
  4>7         dist/js/app.6815cc76.js[ Ng[ m7         dist/js/769.46cebc27.js  Ng  	9         dist/js/638.d7640601.js  Ng  z      !   dist/img/button-show.2336e1d9.svgS  NgS  U         dist/img/warning.9a7cd776.svg   Ng   fh         dist/img/logo.d9707286.svg  Ng  ;w          dist/img/button-add.759df12e.svg   Ng   O
         dist/img/favers.056e2836.svgH  NgH  y,ͤ      #   dist/img/server-config.1a2d0888.svgg  Ngg  RN      %   dist/img/button-database.5282fc7e.svg   Ng   P      "   dist/img/symfony-logo.5c162c73.svg
  Ng
  Os@      !   dist/img/button-link.dd42e161.svg   Ng   ֖>      (   dist/img/button-maintenance.93830369.svgE  NgE  O      $   dist/img/create-project.b22522ee.svg   Ng   ʅ      )   dist/img/button-incompatible.3eb2b686.svg  Ng  /$      #   dist/img/document-root.0e6dd2e4.svg   Ng   D      '   dist/img/search-by-algolia.72f0ac9a.svg  Ng           dist/img/boot.92149bf5.svg   Ng   So      #   dist/img/button-search.44ce1d4b.svgL  NgL  w         dist/img/oauth.1243e742.svg.  Ng.  @
         dist/img/private.a1c65662.svg  Ng  _50w      %   dist/img/button-download.e1ba6f25.svg1  Ng1  O#         dist/img/person.00d78897.svg   Ng   w*      )   dist/img/widget-checkbox--on.8b830157.svg   Ng   #;      !   dist/img/button-lock.98988f08.svgc  Ngc  5=6z      "   dist/img/button-check.7a3b5ada.svg   Ng   ]R         dist/img/user.129e863d.svg   Ng   cǤ         dist/img/offline.0c23d1ce.svg  Ng  У-      $   dist/img/button-passkey.3806f98a.svg=  Ng=  }      (   dist/img/symfony-logo--dark.ea265042.svg  Ng  溤      #   dist/img/private--dark.41b90022.svg  Ng  b      &   dist/img/button-cloud-off.dd8ba18e.svg  Ng  ܡ<      "   dist/img/button-power.298a8072.svg6  Ng6  Kb      %   dist/img/downloads--dark.034bf7a3.svg-  Ng-  	Ǥ      "   dist/img/button-trash.855f57fa.svgt  Ngt  2}          dist/img/link-blank.eb57b3fa.svg   Ng   f^      &   dist/img/button-clipboard.9ef63d39.svgJ  NgJ  v,N      '   dist/img/widget-radio--off.4e93f443.svg  Ng           dist/img/task.e9e5333f.svg{  Ng{  Jl      #   dist/img/button-update.ad79c617.svg\  Ng\  Į         dist/img/hint.ba2ac97e.svg!  Ng!        !   dist/img/button-hide.d23f6533.svg  Ng  m3(         dist/img/database.7f0a8c49.svg  Ng  <	         dist/img/updated.3b47bebb.svgH  NgH  ʦ      $   dist/img/language--dark.a24e849e.svgx  Ngx  G7?      !   dist/img/button-save.3b5224de.svg  Ng           dist/img/lock.3c42a55f.svgf  Ngf  gG      $   dist/img/button-details.8ce780e9.svg  Ng  `         dist/img/downloads.c1db2a9e.svg0  Ng0  ¤      "   dist/img/color_scheme.d527d153.svg   Ng   t         dist/img/recovery.70ee118a.svg   Ng   OTM`      #   dist/img/button-upload.ca8e9cfc.svg3  Ng3  0U      !   dist/img/button-edit.40a4be06.svg  Ng  !.      &   dist/img/link-blank--dark.07eeaee6.svg   Ng   B|         dist/img/funding.cf78a0a0.svgJ  NgJ  `1_      #   dist/img/button-unlock.51b76e07.svgi  Ngi  
         dist/img/php-logo.7376e212.svg	  Ng	  k9q      #   dist/img/updated--dark.c21fdd5b.svgE  NgE  Ey      "   dist/img/button-cloud.bc42f267.svg  Ng  I[      "   dist/img/favers--dark.4765f7d4.svgE  NgE        !   dist/img/button-more.e3eb2622.svg  Ng  v         dist/img/language.582b2920.svg{  Ng{  tW      &   dist/img/widget-radio--on.181461b6.svg:  Ng:  j
M      $   dist/img/button-console.05dcdfc4.svg   Ng   >y      (   dist/img/color_scheme--dark.ef0f0aed.svg:  Ng:  <      !   dist/img/button-gear.a2dc1f09.svg  Ng  0         dist/img/sad.c7de6e95.svg5  Ng5  h          dist/img/button-run.b6310c5a.svg  Ng           dist/img/close.8b27dbcb.svg   Ng   e      "   dist/img/link-funding.b25cd92d.svg  Ng  PԤ      *   dist/img/widget-checkbox--off.73856538.svg   Ng   ~      (   dist/icons/task-active/favicon-16x16.png3  Ng3  K       "   dist/icons/task-active/favicon.ico:  Ng:  8      (   dist/icons/task-active/favicon-32x32.pngF  NgF  )fx      '   dist/icons/task-error/favicon-16x16.png;  Ng;        !   dist/icons/task-error/favicon.ico:  Ng:  u      '   dist/icons/task-error/favicon-32x32.pngB  NgB        )   dist/icons/task-success/favicon-16x16.pngU  NgU  {ؤ      #   dist/icons/task-success/favicon.ico:  Ng:  TIm      )   dist/icons/task-success/favicon-32x32.pngq  Ngq  ?.         dist/api.php  Ng  C¾         dist/assets/favicon-16x16.png  Ng           dist/assets/mstile-310x310.png%  Ng%  xH      &   dist/assets/android-chrome-384x384.png%  Ng%  1|&      3   dist/assets/apple-touch-startup-image-1125x2436.png  Ng  5      2   dist/assets/apple-touch-startup-image-1792x828.png  Ng  8Q      2   dist/assets/apple-touch-startup-image-1334x750.png}y  Ng}y  Դ         dist/assets/mstile-144x144.png  Ng        3   dist/assets/apple-touch-startup-image-1290x2796.pngu  Ngu  ^v         dist/assets/favicon.ico  Ng  }*~      (   dist/assets/apple-touch-icon-120x120.png
  Ng
        3   dist/assets/apple-touch-startup-image-2732x2048.png Ng .uE      &   dist/assets/android-chrome-192x192.png3  Ng3  '\          dist/assets/apple-touch-icon.png  Ng  :5      3   dist/assets/apple-touch-startup-image-1242x2688.png&  Ng&  :Pg      &   dist/assets/android-chrome-256x256.pngh  Ngh  j't      3   dist/assets/apple-touch-startup-image-2436x1125.png  Ng  5x         dist/assets/mstile-70x70.png  Ng  eݺ=      2   dist/assets/apple-touch-startup-image-640x1136.pngP  NgP  n      3   dist/assets/apple-touch-startup-image-1170x2532.png@  Ng@  ˨      *   dist/assets/apple-touch-icon-1024x1024.pngr|  Ngr|  T      (   dist/assets/apple-touch-icon-152x152.png  Ng  o      3   dist/assets/apple-touch-startup-image-1620x2160.pngb  Ngb  RE      3   dist/assets/apple-touch-startup-image-1668x2388.png  Ng  I      2   dist/assets/apple-touch-startup-image-828x1792.pngv  Ngv  >H      3   dist/assets/apple-touch-startup-image-2048x1536.pngn Ngn xEy      (   dist/assets/apple-touch-icon-180x180.png  Ng  :5      (   dist/assets/yandex-browser-manifest.json   Ng   p#Ȥ      3   dist/assets/apple-touch-startup-image-1640x2160.pngv  Ngv  <o      3   dist/assets/apple-touch-startup-image-2224x1668.png+ Ng+       3   dist/assets/apple-touch-startup-image-1179x2556.pngZ  NgZ           dist/assets/favicon-48x48.png  Ng  .i         dist/assets/mstile-310x150.png  Ng  ƒܤ      3   dist/assets/apple-touch-startup-image-1242x2208.pngٸ  Ngٸ  &Nf      (   dist/assets/apple-touch-icon-114x114.pngR	  NgR	  M      &   dist/assets/apple-touch-icon-76x76.png)  Ng)  b      &   dist/assets/android-chrome-512x512.pngL6  NgL6  x9      3   dist/assets/apple-touch-startup-image-2556x1179.png  Ng  jW      2   dist/assets/apple-touch-startup-image-1136x640.pngd  Ngd  %¤      3   dist/assets/apple-touch-startup-image-2532x1170.png  Ng  Ҫ      3   dist/assets/apple-touch-startup-image-2208x1242.png  Ng  PQ      3   dist/assets/apple-touch-startup-image-1488x2266.pngb  Ngb  Wzۤ      &   dist/assets/apple-touch-icon-57x57.png  Ng  1@      2   dist/assets/apple-touch-startup-image-750x1334.pnga  Nga  ΃      3   dist/assets/apple-touch-startup-image-2266x1488.pngP NgP aФ      ,   dist/assets/apple-touch-icon-precomposed.png  Ng  :5      3   dist/assets/apple-touch-startup-image-2160x1620.png" Ng" A'      3   dist/assets/apple-touch-startup-image-1284x2778.pngh  Ngh  eX:      3   dist/assets/apple-touch-startup-image-1668x2224.pngl  Ngl  N      3   dist/assets/apple-touch-startup-image-2688x1242.png  Ng  v      &   dist/assets/apple-touch-icon-72x72.png  Ng  ^F W      3   dist/assets/apple-touch-startup-image-2778x1284.png  Ng   Z      3   dist/assets/apple-touch-startup-image-1536x2048.pngW  NgW  q)ݤ      3   dist/assets/apple-touch-startup-image-2388x1668.png1 Ng1 [3j         dist/assets/mstile-150x150.png  Ng  	          dist/assets/manifest.webmanifest  Ng  `l      3   dist/assets/apple-touch-startup-image-2796x1290.png  Ng  3ق      $   dist/assets/android-chrome-36x36.png+  Ng+        $   dist/assets/android-chrome-96x96.png  Ng  l@w      (   dist/assets/apple-touch-icon-167x167.png
  Ng
  dP      $   dist/assets/android-chrome-72x72.png  Ng  hQ\      &   dist/assets/apple-touch-icon-60x60.png  Ng        3   dist/assets/apple-touch-startup-image-2160x1640.pngV& NgV& 7E      3   dist/assets/apple-touch-startup-image-2048x2732.pngDE NgDE bpF      (   dist/assets/apple-touch-icon-144x144.png	  Ng	  Np      $   dist/assets/yandex-browser-50x50.pngX  NgX  X         dist/assets/browserconfig.xmlr  Ngr  v,      $   dist/assets/android-chrome-48x48.png  Ng  .i         dist/assets/favicon-32x32.png  Ng  ɹ      &   dist/assets/android-chrome-144x144.png  Ng        %   api/HttpKernel/ApiProblemResponse.php	  Ng	        
   api/console--A  NgA  C~Ƥ         api/Config/UploadsConfig.php9  Ng9  Bɤ         api/Config/UserConfig.php%  Ng%  bf         api/Config/ManagerConfig.php9  Ng9  v         api/Config/AbstractConfig.phpk  Ngk  L@         api/Config/ComposerConfig.php  Ng  5[
         api/Config/PartialConfig.php  Ng  +tŅ         api/Config/AuthConfig.php  Ng  $Ĥ      *   api/Security/PasswordlessAuthenticator.php
  Ng
  E&      &   api/Security/WebauthnAuthenticator.phpr)  Ngr)  If      #   api/Security/TokenAuthenticator.php  Ng  <U7         api/Security/UserProvider.php  Ng  &N}         api/Security/User.php/
  Ng/
  [      !   api/Security/JwtAuthenticator.php	  Ng	  %Ȥ      -   api/Security/AbstractBrowserAuthenticator.php  Ng  ,         api/Security/TotpBadge.php;  Ng;  lz      #   api/Security/LoginAuthenticator.php  Ng  b         api/Security/JwtManager.php  Ng        .   api/TaskOperation/Composer/RemoveOperation.php  Ng  '}٤      2   api/TaskOperation/Composer/ClearCacheOperation.php  Ng  [Ǥ      4   api/TaskOperation/Composer/DumpAutoloadOperation.php  Ng        /   api/TaskOperation/Composer/InstallOperation.php  Ng  Y      .   api/TaskOperation/Composer/UpdateOperation.php  Ng        /   api/TaskOperation/Composer/RequireOperation.php9  Ng9  z]3      5   api/TaskOperation/Composer/CreateProjectOperation.php  Ng  2F=      -   api/TaskOperation/Composer/CloudOperation.php2  Ng2        8   api/TaskOperation/Filesystem/InstallUploadsOperation.php  Ng  *դ      6   api/TaskOperation/Filesystem/RemoveVendorOperation.php  Ng  Nx      7   api/TaskOperation/Filesystem/RemoveUploadsOperation.php  Ng        5   api/TaskOperation/Filesystem/RemoveCacheOperation.php  Ng  (٤      1   api/TaskOperation/Manager/SelfUpdateOperation.php  Ng  3:      -   api/TaskOperation/AbstractInlineOperation.php
  Ng
  \.      1   api/TaskOperation/SponsoredOperationInterface.php"  Ng"  :      #   api/TaskOperation/ConsoleOutput.php?  Ng?  Tv      .   api/TaskOperation/AbstractProcessOperation.php  Ng  ]v      5   api/TaskOperation/Contao/MaintenanceModeOperation.phps  Ngs  m6ͤ      2   api/TaskOperation/Contao/BackupCreateOperation.php<  Ng<  w      1   api/TaskOperation/Contao/CacheWarmupOperation.phpX  NgX  hzۤ      2   api/TaskOperation/Contao/CreateContaoOperation.php  Ng  
l      3   api/TaskOperation/Contao/BackupRestoreOperation.php{  Ng{  n<!      0   api/TaskOperation/Contao/CacheClearOperation.phpo  Ngo  n      ,   api/TaskOperation/TaskOperationInterface.php  Ng  6         api/Composer/CloudResolver.phpM  NgM  ~2         api/Composer/CloudChanges.phpe  Nge  #l֤         api/Composer/CloudJob.php	  Ng	  yP         api/Composer/CloudException.php  Ng  ߬         api/Composer/Environment.php"  Ng"        2   api/Resources/cache/url_generating_routes.php.meta!  Ng!  ua¤      @   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php  Ng        %   api/Resources/cache/serialization.phpx   Ngx   [J      E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.lock    Ng              E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.metar Ngr HB      -   api/Resources/cache/url_generating_routes.phpv  Ngv  w      +   api/Resources/cache/url_matching_routes.php5  Ng5  v݈      0   api/Resources/cache/url_matching_routes.php.meta!  Ng!  ua¤      T   api/Resources/cache/ContainerGBSLLhw/getSecurity_Firewall_Map_Context_ApiService.php^
  Ng^
  Ȥ      W   api/Resources/cache/ContainerGBSLLhw/getContainer_GetRoutingConditionServiceService.php  Ng        F   api/Resources/cache/ContainerGBSLLhw/getComposerController2Service.php  Ng  !I      N   api/Resources/cache/ContainerGBSLLhw/getSecurity_UserCheckerLocatorService.php  Ng  ,<5      N   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_SecretsListService.php  Ng  x      P   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_SecretsRemoveService.php  Ng  $      C   api/Resources/cache/ContainerGBSLLhw/getGraphicsLibCheckService.php  Ng  *q      C   api/Resources/cache/ContainerGBSLLhw/getPhpCliControllerService.php  Ng  ͼFG      Y   api/Resources/cache/ContainerGBSLLhw/getSecurity_Authenticator_ManagersLocatorService.php  Ng  ݔu5      D   api/Resources/cache/ContainerGBSLLhw/getTaskDeleteCommandService.php  Ng  Ղ      `   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_SecretsEncryptFromLocal_LazyService.php~  Ng~  Ř      G   api/Resources/cache/ContainerGBSLLhw/getConstraintControllerService.php  Ng  )      V   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_BackedEnumResolverService.php  Ng  Џ      4   api/Resources/cache/ContainerGBSLLhw/removed-ids.phpϧ  Ngϧ  $      G   api/Resources/cache/ContainerGBSLLhw/getProcessRunnerCommandService.php/  Ng/  җ      C   api/Resources/cache/ContainerGBSLLhw/getJwtAuthenticatorService.php  Ng  g      C   api/Resources/cache/ContainerGBSLLhw/getContaoControllerService.php?  Ng?  :u      E   api/Resources/cache/ContainerGBSLLhw/getSecurity_AccessMapService.php*  Ng*  u&      H   api/Resources/cache/ContainerGBSLLhw/getIntegrityCheckFactoryService.php?  Ng?  !m      Q   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_ContainerDebugService.php)  Ng)  =[      W   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_ContainerDebug_LazyService.php(  Ng(  P      H   api/Resources/cache/ContainerGBSLLhw/getWebauthnAuthenticatorService.php	  Ng	        F   api/Resources/cache/ContainerGBSLLhw/getJwtCookieControllerService.php:  Ng:  T       E   api/Resources/cache/ContainerGBSLLhw/getRouter_CacheWarmerService.phpu  Ngu  ?lR      D   api/Resources/cache/ContainerGBSLLhw/getBackupRestoreTaskService.phpL  NgL  4      H   api/Resources/cache/ContainerGBSLLhw/getConsole_CommandLoaderService.phpN'  NgN'  2y      <   api/Resources/cache/ContainerGBSLLhw/getCache_AppService.phpb  Ngb         M   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_SecretsSetService.php  Ng  ޙ      T   api/Resources/cache/ContainerGBSLLhw/getSecurity_Command_UserPasswordHashService.php  Ng  4o      H   api/Resources/cache/ContainerGBSLLhw/getConsoleProcessFactoryService.phpd  Ngd  P      \   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_ConfigDumpReference_LazyService.php^  Ng^  NW      C   api/Resources/cache/ContainerGBSLLhw/getCache_AppClearerService.php  Ng  5      A   api/Resources/cache/ContainerGBSLLhw/getUserControllerService.php  Ng  lȤ      N   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_RouterDebugService.php  Ng  Ge      Q   api/Resources/cache/ContainerGBSLLhw/Contao_ManagerApi_ApiKernelProdContainer.phpa  Nga  aO[      W   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_CachePoolPrune_LazyService.php  Ng  e      D   api/Resources/cache/ContainerGBSLLhw/getTaskUpdateCommandService.php  Ng  r      A   api/Resources/cache/ContainerGBSLLhw/getTaskControllerService.php  Ng  .      L   api/Resources/cache/ContainerGBSLLhw/getMaintenanceModeControllerService.php  Ng  N0,      A   api/Resources/cache/ContainerGBSLLhw/getFileControllerService.php  Ng  V      J   api/Resources/cache/ContainerGBSLLhw/get_ServiceLocator_Y_Xs7MwService.phpT  NgT  	      A   api/Resources/cache/ContainerGBSLLhw/getRouting_LoaderService.phpN
  NgN
  w_      >   api/Resources/cache/ContainerGBSLLhw/getEnvironmentService.php  Ng  zy      T   api/Resources/cache/ContainerGBSLLhw/getSecurity_Listener_UserChecker_ApiService.php  Ng  Ϛ      C   api/Resources/cache/ContainerGBSLLhw/getServicesResetterService.php~  Ng~  8      e   api/Resources/cache/ContainerGBSLLhw/getCache_SecurityIsGrantedAttributeExpressionLanguageService.php  Ng  3oƤ      D   api/Resources/cache/ContainerGBSLLhw/getOpcacheControllerService.php  Ng  	      P   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_AssetsInstallService.php  Ng  t      Q   api/Resources/cache/ContainerGBSLLhw/getSerializer_Mapping_CacheWarmerService.php  Ng  ;Ƥ      E   api/Resources/cache/ContainerGBSLLhw/getLoginAuthenticatorService.php  Ng  -g1      O   api/Resources/cache/ContainerGBSLLhw/getSecurity_EventDispatcher_ApiService.php&  Ng&  9      ?   api/Resources/cache/ContainerGBSLLhw/getCache_SystemService.php  Ng  PG      A   api/Resources/cache/ContainerGBSLLhw/getMonolog_LoggerService.php  Ng  ݤ      X   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_CachePoolDelete_LazyService.php+  Ng+  Hb      J   api/Resources/cache/ContainerGBSLLhw/getMonolog_Logger_SecurityService.php  Ng  ꁤ      @   api/Resources/cache/ContainerGBSLLhw/getUpdateCommandService.php  Ng  F 
      Q   api/Resources/cache/ContainerGBSLLhw/getDebug_ErrorHandlerConfiguratorService.php\  Ng\  &0\      I   api/Resources/cache/ContainerGBSLLhw/getTaskDeleteCommand_LazyService.php  Ng  \D      U   api/Resources/cache/ContainerGBSLLhw/getSecurity_Access_AuthenticatedVoterService.phpL  NgL  	~d      ?   api/Resources/cache/ContainerGBSLLhw/getProcessCheckService.php
  Ng
        D   api/Resources/cache/ContainerGBSLLhw/getSessionControllerService.php  Ng  H      V   api/Resources/cache/ContainerGBSLLhw/getSecurity_Listener_PasswordMigratingService.php$  Ng$  N      A   api/Resources/cache/ContainerGBSLLhw/getSelfUpdateTaskService.php*  Ng*  Ȼ      X   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_SerializerDebug_LazyService.php  Ng        F   api/Resources/cache/ContainerGBSLLhw/getCache_GlobalClearerService.phpn  Ngn  %0      >   api/Resources/cache/ContainerGBSLLhw/getTaskManagerService.php  Ng        H   api/Resources/cache/ContainerGBSLLhw/getConsole_ErrorListenerService.php  Ng  :
      K   api/Resources/cache/ContainerGBSLLhw/getUploadPackagesControllerService.php  Ng  n?櫤      <   api/Resources/cache/ContainerGBSLLhw/getContaoApiService.php^  Ng^  
      C   api/Resources/cache/ContainerGBSLLhw/getMemoryLimitCheckService.php  Ng  ؔ      W   api/Resources/cache/ContainerGBSLLhw/get_Security_Command_DebugFirewall_LazyService.php+  Ng+        B   api/Resources/cache/ContainerGBSLLhw/getSysTempDirCheckService.php  Ng        V   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_SecretsRemove_LazyService.php  Ng  |r      _   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_QueryParameterValueResolverService.php  Ng        I   api/Resources/cache/ContainerGBSLLhw/getTaskUpdateCommand_LazyService.php  Ng  fw      C   api/Resources/cache/ContainerGBSLLhw/getConfigControllerService.php  Ng  ֓:      =   api/Resources/cache/ContainerGBSLLhw/getSelfUpdateService.php  Ng  @[v      C   api/Resources/cache/ContainerGBSLLhw/getTaskAbortCommandService.php  Ng  Xk      @   api/Resources/cache/ContainerGBSLLhw/getCloudResolverService.php  Ng  Q      ^   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_SecretsDecryptToLocal_LazyService.php|  Ng|  %      F   api/Resources/cache/ContainerGBSLLhw/getAccessKeyControllerService.php:  Ng:  WΤ      S   api/Resources/cache/ContainerGBSLLhw/getPropertyInfo_SerializerExtractorService.php$  Ng$  ֞̐      ?   api/Resources/cache/ContainerGBSLLhw/getUserProviderService.php  Ng  yP      C   api/Resources/cache/ContainerGBSLLhw/getPhpWebControllerService.phpJ  NgJ  ¿S      D   api/Resources/cache/ContainerGBSLLhw/getAboutCommand_LazyService.php  Ng  cj      P   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_ContainerLintService.php<  Ng<  nФ      N   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_About_LazyService.php  Ng  ~Oʤ      T   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_RouterMatch_LazyService.php  Ng  HRP      =   api/Resources/cache/ContainerGBSLLhw/getTranslatorService.php  Ng  s'      G   api/Resources/cache/ContainerGBSLLhw/getSelfUpdateControllerService.php  Ng  lG      K   api/Resources/cache/ContainerGBSLLhw/getSecurity_ChannelListenerService.php  Ng  N      L   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_VariadicService.php  Ng  43      D   api/Resources/cache/ContainerGBSLLhw/getManagerControllerService.php7  Ng7  9      C   api/Resources/cache/ContainerGBSLLhw/getBackupControllerService.php  Ng  4E      B   api/Resources/cache/ContainerGBSLLhw/getSecurity_HelperService.php;  Ng;  էJ      Q   api/Resources/cache/ContainerGBSLLhw/getSecurity_Listener_UserProviderService.php  Ng  K1S      Q   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_YamlLint_LazyService.php  Ng  )+      @   api/Resources/cache/ContainerGBSLLhw/getSecrets_VaultService.phpE  NgE  )>      V   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_ConfigDumpReferenceService.phpN  NgN  W      N   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_CacheWarmupService.phpS  NgS  "wI      U   api/Resources/cache/ContainerGBSLLhw/getSecurity_Access_RoleHierarchyVoterService.php*  Ng*  Wl      T   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_RequestAttributeService.php  Ng  ~j      C   api/Resources/cache/ContainerGBSLLhw/getBackupCreateTaskService.phpG  NgG  D      L   api/Resources/cache/ContainerGBSLLhw/getProcessRunnerCommand_LazyService.php  Ng  4#)      R   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_CachePoolDeleteService.phpt  Ngt  v{      B   api/Resources/cache/ContainerGBSLLhw/getCloudControllerService.phpm  Ngm  Ҥ      <   api/Resources/cache/ContainerGBSLLhw/getSetupTaskService.phpX  NgX  N      S   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_SecretsSet_LazyService.php  Ng  BB      E   api/Resources/cache/ContainerGBSLLhw/getTemplateControllerService.php  Ng  Gq      Z   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_CachePoolInvalidateTagsService.php  Ng  L      ]   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_EventDispatcherDebug_LazyService.phpg  Ngg  8¼      V   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_CachePoolList_LazyService.php  Ng  @lƤ      W   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_EventDispatcherDebugService.php  Ng  blǤ      K   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_ServiceService.php  Ng  	      `   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_CachePoolInvalidateTags_LazyService.php  Ng  z9
      T   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_CacheWarmup_LazyService.php  Ng  l      F   api/Resources/cache/ContainerGBSLLhw/getCache_SystemClearerService.php  Ng  F      J   api/Resources/cache/ContainerGBSLLhw/get_ServiceLocator_BvkMlPlService.phpP  NgP  g      G   api/Resources/cache/ContainerGBSLLhw/getMonolog_Logger_TasksService.php  Ng  ]J      F   api/Resources/cache/ContainerGBSLLhw/getAdminUserControllerService.phpB  NgB  D*      H   api/Resources/cache/ContainerGBSLLhw/getIntegrityCheckCommandService.php  Ng  {ۭ      V   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_AssetsInstall_LazyService.php)  Ng)  q      [   api/Resources/cache/ContainerGBSLLhw/getSecurity_Firewall_EventDispatcherLocatorService.php  Ng  9ʤ      R   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_SerializerDebugService.php  Ng  7'/      E   api/Resources/cache/ContainerGBSLLhw/getPhpExtensionsCheckService.php(  Ng(  ؿ      K   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_DefaultService.php  Ng  M3h      A   api/Resources/cache/ContainerGBSLLhw/getAuthControllerService.php  Ng  ס      L   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_DatetimeService.php  Ng        G   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_UidService.php  Ng  ?tl      L   api/Resources/cache/ContainerGBSLLhw/getInstallToolLockControllerService.php  Ng  	O      E   api/Resources/cache/ContainerGBSLLhw/getUpdateCommand_LazyService.php  Ng  T~2      E   api/Resources/cache/ContainerGBSLLhw/getComposerControllerService.php>  Ng>  ֤      K   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_SessionService.php  Ng  צp      >   api/Resources/cache/ContainerGBSLLhw/getCacheWarmerService.php  Ng  1)      E   api/Resources/cache/ContainerGBSLLhw/getRedirectControllerService.php  Ng  P      @   api/Resources/cache/ContainerGBSLLhw/getUploadsConfigService.php  Ng  H
      N   api/Resources/cache/ContainerGBSLLhw/getDatabaseMigrationControllerService.php=  Ng=   I֤      K   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_YamlLintService.php	  Ng	  }b      G   api/Resources/cache/ContainerGBSLLhw/getConfigBuilder_WarmerService.php  Ng  )Ƥ      L   api/Resources/cache/ContainerGBSLLhw/getPasswordlessAuthenticatorService.php  Ng  =a+      A   api/Resources/cache/ContainerGBSLLhw/getClearCacheTaskService.phpE  NgE  ^X       H   api/Resources/cache/ContainerGBSLLhw/getRootPackageControllerService.phpQ  NgQ  (L      E   api/Resources/cache/ContainerGBSLLhw/getCache_App_TaggableService.php  Ng  &Ƥ      @   api/Resources/cache/ContainerGBSLLhw/getContaoConsoleService.php  Ng  0ä      @   api/Resources/cache/ContainerGBSLLhw/getManagerConfigService.php  Ng  灤      M   api/Resources/cache/ContainerGBSLLhw/getSecurity_UserValueResolverService.php  Ng  :      X   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_DebugAutowiring_LazyService.php8  Ng8  w啙      Q   api/Resources/cache/ContainerGBSLLhw/getSecurity_Command_DebugFirewallService.php  Ng  v      b   api/Resources/cache/ContainerGBSLLhw/getSecurity_Listener_CheckAuthenticatorCredentialsService.phpH  NgH  p_e      W   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_CachePoolClear_LazyService.php  Ng  ̤      M   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_CacheClearService.php  Ng        D   api/Resources/cache/ContainerGBSLLhw/getPhpinfoControllerService.php  Ng        P   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_CachePoolListService.php  Ng  ׭      U   api/Resources/cache/ContainerGBSLLhw/getSecurity_Authenticator_Manager_ApiService.php  Ng  !      E   api/Resources/cache/ContainerGBSLLhw/getAllowUrlFopenCheckService.php(  Ng(  ńI      C   api/Resources/cache/ContainerGBSLLhw/getRebuildCacheTaskService.phpp  Ngp  c      V   api/Resources/cache/ContainerGBSLLhw/getSecurity_Firewall_Authenticator_ApiService.php  Ng  "      [   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_SecretsGenerateKey_LazyService.phpE  NgE  1.      T   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_RouterDebug_LazyService.php  Ng  9      Q   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_CachePoolClearService.php_  Ng_  a      @   api/Resources/cache/ContainerGBSLLhw/getLogControllerService.php*  Ng*  ;=v      L   api/Resources/cache/ContainerGBSLLhw/getContainer_EnvVarProcessorService.php,  Ng,  Z_      U   api/Resources/cache/ContainerGBSLLhw/getSecurity_Listener_Api_UserProviderService.php!  Ng!  o      >   api/Resources/cache/ContainerGBSLLhw/getInstallTaskService.php#  Ng#  ~ˤ      T   api/Resources/cache/ContainerGBSLLhw/getContainer_EnvVarProcessorsLocatorService.php
  Ng
  Y      D   api/Resources/cache/ContainerGBSLLhw/getExceptionListenerService.php  Ng  u      ?   api/Resources/cache/ContainerGBSLLhw/getSymlinkCheckService.php  Ng  &      :   api/Resources/cache/ContainerGBSLLhw/getRequestService.php  Ng  b      ?   api/Resources/cache/ContainerGBSLLhw/getSessionCheckService.php
  Ng
  (N      L   api/Resources/cache/ContainerGBSLLhw/getMissingPackagesControllerService.phpe  Nge  5      U   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_SecretsGenerateKeyService.php8  Ng8  [      =   api/Resources/cache/ContainerGBSLLhw/getUpdateTaskService.php  Ng  E[I      T   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_SecretsList_LazyService.php  Ng  2QA      A   api/Resources/cache/ContainerGBSLLhw/getComposerConfigService.php   Ng   aJФ      Z   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_SecretsEncryptFromLocalService.php`  Ng`  r85      J   api/Resources/cache/ContainerGBSLLhw/getSecurity_AccessListenerService.php  Ng  I6դ      Q   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_CachePoolPruneService.php  Ng  8y      Z   api/Resources/cache/ContainerGBSLLhw/get_Security_Command_UserPasswordHash_LazyService.php6  Ng6  3%~      N   api/Resources/cache/ContainerGBSLLhw/getSecurity_RouteLoader_LogoutService.php  Ng  J      T   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_ConfigDebug_LazyService.php  Ng  a      E   api/Resources/cache/ContainerGBSLLhw/getDatabaseControllerService.php  Ng  Ȥ      X   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_SecretsDecryptToLocalService.phpd  Ngd  {      J   api/Resources/cache/ContainerGBSLLhw/getLocalPackagesControllerService.php[  Ng[  )n      ?   api/Resources/cache/ContainerGBSLLhw/getAboutCommandService.php  Ng  BfJ      H   api/Resources/cache/ContainerGBSLLhw/getTaskAbortCommand_LazyService.php  Ng  .O      V   api/Resources/cache/ContainerGBSLLhw/getSecurity_SecurityTokenValueResolverService.php@  Ng@  몠M      E   api/Resources/cache/ContainerGBSLLhw/getTokenAuthenticatorService.php  Ng  gCƤ      R   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_DebugAutowiringService.php  Ng  &p      =   api/Resources/cache/ContainerGBSLLhw/getServerInfoService.php  Ng  	      N   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_RouterMatchService.php  Ng  k      M   api/Resources/cache/ContainerGBSLLhw/getIntegrityCheckCommand_LazyService.php  Ng  q      J   api/Resources/cache/ContainerGBSLLhw/get_ServiceLocator_AH5O6SdService.phph  Ngh  1c      B   api/Resources/cache/ContainerGBSLLhw/getErrorControllerService.php  Ng  y      J   api/Resources/cache/ContainerGBSLLhw/get_ServiceLocator_EZsc_DOService.phpb  Ngb  i      S   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_CacheClear_LazyService.php  Ng  -\'      K   api/Resources/cache/ContainerGBSLLhw/getArgumentResolver_RequestService.php  Ng  -      P   api/Resources/cache/ContainerGBSLLhw/RequestPayloadValueResolverGhost8d82153.phpp  Ngp        H   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_AboutService.php  Ng  զ}x      C   api/Resources/cache/ContainerGBSLLhw/getDumpAutoloadTaskService.phpO  NgO  ux      V   api/Resources/cache/ContainerGBSLLhw/get_Console_Command_ContainerLint_LazyService.php8  Ng8  qA      N   api/Resources/cache/ContainerGBSLLhw/getConsole_Command_ConfigDebugService.php  Ng  y      H   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.preload.phptu  Ngtu  9ܤ      @   api/Resources/cache/Symfony/Config/Framework/HttpCacheConfig.php#  Ng#  
1      F   api/Resources/cache/Symfony/Config/Framework/Webhook/RoutingConfig.phpv  Ngv  j3      <   api/Resources/cache/Symfony/Config/Framework/CacheConfig.php$  Ng$  "      @   api/Resources/cache/Symfony/Config/Framework/FragmentsConfig.php
  Ng
  	[b      J   api/Resources/cache/Symfony/Config/Framework/Form/CsrfProtectionConfig.php  Ng  7eG      P   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptionsConfig.phpxE  NgxE  ^Me      i   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailed/HttpCodeConfig.php  Ng        d   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/PeerFingerprintConfig.php
  Ng
  E      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailedConfig.php  Ng  #      N   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig.php4S  Ng4S  S¤      e   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailed/HttpCodeConfig.php  Ng  ,@Ϥ      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/PeerFingerprintConfig.php	  Ng	   !j      \   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailedConfig.php  Ng  =q      I   api/Resources/cache/Symfony/Config/Framework/Serializer/MappingConfig.phpF  NgF  $v      A   api/Resources/cache/Symfony/Config/Framework/ValidationConfig.php(  Ng(  >Ť      B   api/Resources/cache/Symfony/Config/Framework/RateLimiterConfig.php	  Ng	        U   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig/RateConfig.phpm  Ngm  $S      J   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig.php  Ng  9§      A   api/Resources/cache/Symfony/Config/Framework/Cache/PoolConfig.php  Ng  -.-      A   api/Resources/cache/Symfony/Config/Framework/SerializerConfig.php  Ng  2*      E   api/Resources/cache/Symfony/Config/Framework/CsrfProtectionConfig.php7  Ng7  g	      =   api/Resources/cache/Symfony/Config/Framework/AssetsConfig.php+  Ng+  (      N   api/Resources/cache/Symfony/Config/Framework/Notifier/AdminRecipientConfig.phpZ  NgZ  ¾      @   api/Resources/cache/Symfony/Config/Framework/MessengerConfig.phpe*  Nge*  ]      >   api/Resources/cache/Symfony/Config/Framework/WebhookConfig.php  Ng  &J      =   api/Resources/cache/Symfony/Config/Framework/RouterConfig.php  Ng  ^      A   api/Resources/cache/Symfony/Config/Framework/TranslatorConfig.php"  Ng"  f      @   api/Resources/cache/Symfony/Config/Framework/WorkflowsConfig.php  Ng  
      J   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig.php~+  Ng~+  7      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/AuditTrailConfig.phpN  NgN  VN      ]   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/MarkingStoreConfig.php	  Ng	  h4      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/TransitionConfig.php]  Ng]  Eg :      V   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/PlaceConfig.php  Ng  i:      :   api/Resources/cache/Symfony/Config/Framework/EsiConfig.php-  Ng-  5      >   api/Resources/cache/Symfony/Config/Framework/WebLinkConfig.php1  Ng1        F   api/Resources/cache/Symfony/Config/Framework/Mailer/EnvelopeConfig.php  Ng  R      D   api/Resources/cache/Symfony/Config/Framework/Mailer/HeaderConfig.php,  Ng,  lu      :   api/Resources/cache/Symfony/Config/Framework/SsiConfig.php-  Ng-  (      T   api/Resources/cache/Symfony/Config/Framework/Translator/PseudoLocalizationConfig.php  Ng  |Њ      J   api/Resources/cache/Symfony/Config/Framework/Translator/ProviderConfig.php
  Ng
  ܤ      ?   api/Resources/cache/Symfony/Config/Framework/ProfilerConfig.php  Ng  pé      @   api/Resources/cache/Symfony/Config/Framework/SemaphoreConfig.php  Ng  R8      >   api/Resources/cache/Symfony/Config/Framework/SecretsConfig.php  Ng  |1      E   api/Resources/cache/Symfony/Config/Framework/PropertyAccessConfig.php  Ng  S(      J   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig.php  Ng  	      ]   api/Resources/cache/Symfony/Config/Framework/Messenger/Serializer/SymfonySerializerConfig.php  Ng  +]      K   api/Resources/cache/Symfony/Config/Framework/Messenger/SerializerConfig.php  Ng  Ot      ^   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig/RetryStrategyConfig.php?  Ng?  [T      H   api/Resources/cache/Symfony/Config/Framework/Messenger/RoutingConfig.php]  Ng]  zT      U   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/MiddlewareConfig.php  Ng  i      \   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/DefaultMiddlewareConfig.php
  Ng
  Ԥ      D   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig.php  Ng        C   api/Resources/cache/Symfony/Config/Framework/PropertyInfoConfig.php5  Ng5        =   api/Resources/cache/Symfony/Config/Framework/MailerConfig.php2  Ng2        :   api/Resources/cache/Symfony/Config/Framework/UidConfig.php  Ng  ե      B   api/Resources/cache/Symfony/Config/Framework/RemoteeventConfig.php5  Ng5  `      B   api/Resources/cache/Symfony/Config/Framework/AssetMapperConfig.phpY(  NgY(  Pm      D   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizerConfig.php*
  Ng*
  
?      @   api/Resources/cache/Symfony/Config/Framework/ExceptionConfig.phpO  NgO        >   api/Resources/cache/Symfony/Config/Framework/SessionConfig.php`2  Ng`2        N   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizer/SanitizerConfig.php9  Ng9  ,      A   api/Resources/cache/Symfony/Config/Framework/HttpClientConfig.phpm  Ngm        @   api/Resources/cache/Symfony/Config/Framework/PhpErrorsConfig.php  Ng  .m      ?   api/Resources/cache/Symfony/Config/Framework/NotifierConfig.phpS  NgS  6S2      >   api/Resources/cache/Symfony/Config/Framework/RequestConfig.phpg  Ngg  Ϊ      B   api/Resources/cache/Symfony/Config/Framework/AnnotationsConfig.php  Ng  c:Ĥ      E   api/Resources/cache/Symfony/Config/Framework/Assets/PackageConfig.php!  Ng!  `      X   api/Resources/cache/Symfony/Config/Framework/Validation/NotCompromisedPasswordConfig.php9  Ng9  r9`      I   api/Resources/cache/Symfony/Config/Framework/Validation/MappingConfig.phpF  NgF  Һ      M   api/Resources/cache/Symfony/Config/Framework/Validation/AutoMappingConfig.phpn  Ngn  }      ;   api/Resources/cache/Symfony/Config/Framework/LockConfig.php  Ng  $      @   api/Resources/cache/Symfony/Config/Framework/SchedulerConfig.php3  Ng3        ;   api/Resources/cache/Symfony/Config/Framework/FormConfig.php
  Ng
  ܥ;      P   api/Resources/cache/Symfony/Config/Security/ProviderConfig/Memory/UserConfig.php  Ng  K      I   api/Resources/cache/Symfony/Config/Security/ProviderConfig/LdapConfig.php  Ng  OK      K   api/Resources/cache/Symfony/Config/Security/ProviderConfig/MemoryConfig.phpO  NgO  >]      J   api/Resources/cache/Symfony/Config/Security/ProviderConfig/ChainConfig.php  Ng  y4      D   api/Resources/cache/Symfony/Config/Security/PasswordHasherConfig.php  Ng  j{쾤      >   api/Resources/cache/Symfony/Config/Security/ProviderConfig.php  Ng  73      >   api/Resources/cache/Symfony/Config/Security/FirewallConfig.php&n  Ng&n        P   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessTokenConfig.php  Ng  ?3      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMeConfig.php1  Ng1  ڊ      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginConfig.phpA  NgA  ǌ       R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginLdapConfig.php,*  Ng,*  Ex      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicConfig.php  Ng  j      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandlerConfig.php  Ng  J      j   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcUserInfoConfig.php
  Ng
  
      b   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcConfig.php  Ng  .}e      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginConfig.php  Ng  \      X   api/Resources/cache/Symfony/Config/Security/FirewallConfig/Logout/DeleteCookieConfig.php  Ng  8x      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/SwitchUserConfig.php  Ng  j a      T   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginThrottlingConfig.php
  Ng
  >      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginLinkConfig.php3  Ng3  ~1      f   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProvider/DoctrineConfig.php  Ng  =      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProviderConfig.php
  Ng
        R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginLdapConfig.phpNN  NgNN  jN      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicLdapConfig.php  Ng  B      I   api/Resources/cache/Symfony/Config/Security/FirewallConfig/X509Config.php  Ng  I      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RemoteUserConfig.php  Ng  U8      K   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LogoutConfig.php#  Ng#        K   api/Resources/cache/Symfony/Config/Security/AccessDecisionManagerConfig.php  Ng  O^      C   api/Resources/cache/Symfony/Config/Security/AccessControlConfig.php  Ng  XAL      5   api/Resources/cache/Symfony/Config/SecurityConfig.php
1  Ng
1  Y~      4   api/Resources/cache/Symfony/Config/MonologConfig.php  Ng  FF      <   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig.php* Ng* Ռ      V   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ProcessPsr3MessagesConfig.php
  Ng
  U      L   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PublisherConfig.php"  Ng"  -      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/RedisConfig.php  Ng  ע      P   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ElasticsearchConfig.php  Ng  !a      Q   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/EmailPrototypeConfig.phpZ  NgZ  q:_      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/MongoConfig.php  Ng  =o      R   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/VerbosityLevelsConfig.php  Ng  =1ޤ      I   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PredisConfig.php:  Ng:  f ɤ      S   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ExcludedHttpCodeConfig.php~  Ng~  4:T      K   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ChannelsConfig.php  Ng  у      6   api/Resources/cache/Symfony/Config/FrameworkConfig.php' Ng' oA      #   api/Resources/cache/annotations.map  Ng  r'      "   api/Resources/config/services.yamlx
  Ngx
  K~I      $   api/Resources/config/config_dev.yaml  Ng        %   api/Resources/config/config_prod.yaml   Ng   H          api/Resources/config/config.yaml*  Ng*  "H         api/Resources/i18n/cs.ymll  Ngl  z         api/Resources/i18n/br.yml  Ng           api/Resources/i18n/es.yml  Ng  k3?         api/Resources/i18n/pt.yml  Ng  DM̤         api/Resources/i18n/de.yml  Ng  |E         api/Resources/i18n/it.yml  Ng  k6         api/Resources/i18n/pl.yml  Ng  Oy         api/Resources/i18n/fa.yml;	  Ng;	  1,         api/Resources/i18n/sv.yml  Ng  9詤         api/Resources/i18n/en.yml!  Ng!  s         api/Resources/i18n/ja.ymlX  NgX  d         api/Resources/i18n/ru.ymlh  Ngh  
V         api/Resources/i18n/sr.yml  Ng  "\         api/Resources/i18n/fr.yml  Ng  0         api/Resources/i18n/lv.ymlx  Ngx  M         api/Resources/i18n/tr.yml8  Ng8  Ey         api/Resources/i18n/nl.yml  Ng   U         api/Resources/i18n/zh.yml
  Ng
  ;Ϥ         api/ApiApplication.php  Ng  -r      #   api/Tests/Composer/CloudJobTest.php  Ng  !L      '   api/Tests/Controller/LogPatternTest.php0  Ng0  Ly      !   api/Controller/FileController.phpU  NgU  _ќ      !   api/Controller/UserController.php>  Ng>  Տ"          api/Controller/LogController.php  Ng  '%      (   api/Controller/Config/AuthController.phpg  Ngg  rI6      2   api/Controller/Config/AbstractConfigController.php  Ng  <V      ,   api/Controller/Config/ComposerController.php  Ng  gƤ      +   api/Controller/Config/ManagerController.php  Ng  ݤ      !   api/Controller/TaskController.php`
  Ng`
  aчG      *   api/Controller/Server/PhpWebController.phpD  NgD  1eŤ      *   api/Controller/Server/ContaoController.php"  Ng"  ͚v      ,   api/Controller/Server/DatabaseController.php2
  Ng2
  W?      -   api/Controller/Server/AdminUserController.php
  Ng
  DV      +   api/Controller/Server/PhpinfoController.phpr  Ngr  %E      +   api/Controller/Server/OpcacheController.php  Ng  "      *   api/Controller/Server/ConfigController.php  Ng  $      ,   api/Controller/Server/ComposerController.php  Ng  G6      *   api/Controller/Server/PhpCliController.php  Ng  K|Q      .   api/Controller/Server/SelfUpdateController.php  Ng  $w      $   api/Controller/SessionController.phps  Ngs  YK~      5   api/Controller/Packages/MissingPackagesController.php
  Ng
  2c      4   api/Controller/Packages/UploadPackagesController.php'  Ng'  +T      1   api/Controller/Packages/RootPackageController.php'  Ng'  &H)      +   api/Controller/Packages/CloudController.phpf  Ngf  Vu      3   api/Controller/Packages/LocalPackagesController.phpN  NgN        '   api/Controller/ConstraintController.phpY  NgY  kۤ      3   api/Controller/Contao/InstallToolLockController.php3  Ng3  AÖ      5   api/Controller/Contao/DatabaseMigrationController.php%  Ng%  Zb      -   api/Controller/Contao/AccessKeyController.php0  Ng0  I>      *   api/Controller/Contao/BackupController.php,  Ng,  >]6      3   api/Controller/Contao/MaintenanceModeController.php  Ng  $iW      -   api/Controller/Contao/JwtCookieController.php  Ng  bˤ         api/ApiKernel.php=&  Ng=&  [          api/System/ServerInfo.phpq  Ngq  ƾq         api/System/Request.php[  Ng[  y9[<         api/System/SelfUpdate.phpD  NgD  qׂ         api/Task/TaskStatus.php5  Ng5        &   api/Task/Composer/DumpAutoloadTask.php  Ng  Wj      $   api/Task/Composer/ClearCacheTask.php  Ng        #   api/Task/Manager/SelfUpdateTask.php  Ng  @?&         api/Task/AbstractTask.php  Ng  ߪO         api/Task/Packages/SetupTask.php
  Ng
  3P          api/Task/Packages/UpdateTask.phpi(  Ngi(  <      !   api/Task/Packages/InstallTask.php  Ng  }Kݤ      *   api/Task/Packages/AbstractPackagesTask.php}  Ng}  N(      $   api/Task/Contao/BackupCreateTask.php  Ng  E      %   api/Task/Contao/BackupRestoreTask.php  Ng  UF      $   api/Task/Contao/RebuildCacheTask.php  Ng  lK         api/Task/TaskManager.php  Ng  +         api/Task/TaskInterface.php  Ng  r         api/Task/TaskConfig.php	  Ng	  /ʤ      %   api/Command/IntegrityCheckCommand.php	  Ng	           api/Command/UpdateCommand.php  Ng  %          api/Command/TaskAbortCommand.phpJ  NgJ  {P峤      !   api/Command/TaskUpdateCommand.phpz  Ngz  k      $   api/Command/ProcessRunnerCommand.phpy  Ngy  `݃y         api/Command/AboutCommand.php  Ng  pSe      !   api/Command/TaskDeleteCommand.phpa  Nga  
W         api/I18n/Translator.php
  Ng
  q
      %   api/Exception/ApiProblemException.php5  Ng5  W{       (   api/Exception/ProcessOutputException.php  Ng  o      &   api/Exception/InvalidTotpException.php  Ng  ʤ      &   api/Exception/InvalidJsonException.php
  Ng
  8Y      "   api/Exception/RequestException.php  Ng  Ű      )   api/IntegrityCheck/AllowUrlFopenCheck.php%  Ng%  z2Ť      '   api/IntegrityCheck/GraphicsLibCheck.php  Ng  kp¤         api/IntegrityCheck/ZipCheck.php  Ng  k"      &   api/IntegrityCheck/SysTempDirCheck.php  Ng  Ƥ      .   api/IntegrityCheck/IntegrityCheckInterface.php~  Ng~        #   api/IntegrityCheck/ProcessCheck.php  Ng  \.sg      #   api/IntegrityCheck/SymlinkCheck.php  Ng  ;W      #   api/IntegrityCheck/SessionCheck.php  Ng  ˭K      '   api/IntegrityCheck/MemoryLimitCheck.phpK  NgK  ^      )   api/IntegrityCheck/PhpExtensionsCheck.php  Ng  	:      -   api/IntegrityCheck/AbstractIntegrityCheck.php  Ng        ,   api/IntegrityCheck/IntegrityCheckFactory.php  Ng  R,         api/Process/ContaoApi.phpF  NgF  B      !   api/Process/ProcessController.php  Ng  ٧e      %   api/Process/Forker/AbstractForker.php
  Ng
  ȮH      &   api/Process/Forker/ForkerInterface.phpn  Ngn  |5oq      #   api/Process/Forker/DisownForker.php  Ng  w4h      "   api/Process/Forker/NohupForker.php  Ng  ZA      )   api/Process/Forker/WindowsStartForker.php  Ng  a\"      #   api/Process/Forker/InlineForker.php  Ng  Ѷ#         api/Process/Utf8Process.php  Ng  x         api/Process/ProcessRunner.php  Ng  |E         api/Process/AbstractProcess.php  Ng  6?=         api/Process/ContaoConsole.php   Ng   v)1      #   api/Process/PhpExecutableFinder.php  Ng  r      %   api/Process/ConsoleProcessFactory.php  Ng  k         api/console8  Ng8  i.      $   api/EventListener/LocaleListener.php.  Ng.        '   api/EventListener/ExceptionListener.php~
  Ng~
  
      &   api/EventListener/SecurityListener.php  Ng  O      '   api/EventListener/CheckTotpListener.php  Ng  5%T      )   api/EventListener/JsonRequestListener.phpM  NgM  ä      
   downgrade.php0  Ng0  8-ˤ      $   vendor/seld/phar-utils/composer.lock/  Ng/  cւ(         vendor/seld/phar-utils/LICENSE"  Ng"  ?e          vendor/seld/phar-utils/README.mde  Nge  :N      $   vendor/seld/phar-utils/composer.json;  Ng;  =      %   vendor/seld/phar-utils/src/Linter.php
  Ng
  #:	      )   vendor/seld/phar-utils/src/Timestamps.phpk  Ngk  F         vendor/seld/jsonlint/LICENSE"  Ng"  asy      !   vendor/seld/jsonlint/bin/jsonlint  Ng   
      !   vendor/seld/jsonlint/CHANGELOG.md	  Ng	  ݣʤ         vendor/seld/jsonlint/README.md
  Ng
  f      "   vendor/seld/jsonlint/composer.jsonU  NgU  TR      @   vendor/seld/jsonlint/src/Seld/JsonLint/DuplicateKeyException.php  Ng  ArQ      ;   vendor/seld/jsonlint/src/Seld/JsonLint/ParsingException.php  Ng  m2;      0   vendor/seld/jsonlint/src/Seld/JsonLint/Lexer.php"  Ng"  ;      4   vendor/seld/jsonlint/src/Seld/JsonLint/Undefined.php*  Ng*        5   vendor/seld/jsonlint/src/Seld/JsonLint/JsonParser.php,_  Ng,_  v      "   vendor/seld/signal-handler/LICENSE"  Ng"  ?e      (   vendor/seld/signal-handler/composer.json  Ng  c      0   vendor/seld/signal-handler/src/SignalHandler.phpO  NgO  ,C         vendor/autoload.php  Ng  yDw      $   vendor/phpstan/phpdoc-parser/LICENSEQ  NgQ  w      &   vendor/phpstan/phpdoc-parser/README.md  Ng  0h      )   vendor/phpstan/phpdoc-parser/UPGRADING.md#  Ng#  &~g      *   vendor/phpstan/phpdoc-parser/composer.json  Ng  R	      0   vendor/phpstan/phpdoc-parser/src/Lexer/Lexer.php  Ng  &eo      5   vendor/phpstan/phpdoc-parser/src/Printer/DiffElem.php  Ng  
      3   vendor/phpstan/phpdoc-parser/src/Printer/Differ.phpj  Ngj  yT      4   vendor/phpstan/phpdoc-parser/src/Printer/Printer.phpG  NgG  |"&v      ;   vendor/phpstan/phpdoc-parser/src/Parser/ParserException.php	  Ng	  2Ф      8   vendor/phpstan/phpdoc-parser/src/Parser/PhpDocParser.phpޭ  Ngޭ   a      ;   vendor/phpstan/phpdoc-parser/src/Parser/ConstExprParser.php!  Ng!  HH      ;   vendor/phpstan/phpdoc-parser/src/Parser/StringUnescaper.php\
  Ng\
  k'#      6   vendor/phpstan/phpdoc-parser/src/Parser/TypeParser.php_  Ng_  YeG      9   vendor/phpstan/phpdoc-parser/src/Parser/TokenIterator.php8)  Ng8)  \j      1   vendor/phpstan/phpdoc-parser/src/ParserConfig.php`  Ng`  Kä      V   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PureUnlessCallableIsImpureTagValueNode.php  Ng  ;      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MixinTagValueNode.php  Ng  0      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TemplateTagValueNode.php  Ng        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagValueNode.php:  Ng:  
f      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ThrowsTagValueNode.php  Ng  }      U   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamLaterInvokedCallableTagValueNode.php  Ng  OS^      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagValueNode.php   Ng   ck      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagPropertyValueNode.php  Ng  -      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireImplementsTagValueNode.php  Ng  Z3      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ImplementsTagValueNode.php  Ng  ^Ĥ      >   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTextNode.php  Ng  h%      :   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocNode.phpI)  NgI)        L   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamClosureThisTagValueNode.php-  Ng-  =H      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/GenericTagValueNode.php  Ng  ~T      E   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasTagValueNode.phpc  Ngc        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ReturnTagValueNode.php  Ng  ^T      @   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/UsesTagValueNode.php  Ng  Z!K      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueParameterNode.php4  Ng4  ܤ      I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArgument.php  Ng  =      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineAnnotation.php  Ng  ;k      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineTagValueNode.php  Ng  j$Ѥ      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArrayItem.php  Ng  K      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArray.php  Ng  (Ҥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/InvalidTagValueNode.php  Ng  ^ߤ      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/VarTagValueNode.phpL  NgL  KHx      =   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagNode.php  Ng  ɿ      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamOutTagValueNode.php%  Ng%        I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypelessParamTagValueNode.php  Ng  m#w      H   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagMethodValueNode.php  Ng  {֤      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasImportTagValueNode.php  Ng  jW      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PropertyTagValueNode.php   Ng   7b!      [   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamImmediatelyInvokedCallableTagValueNode.php  Ng  'D      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocChildNode.php   Ng   )5Q      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ExtendsTagValueNode.php  Ng  ݤ      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamTagValueNode.phpU  NgU  ~,      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueNode.php  Ng  7Ǥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/SelfOutTagValueNode.php  Ng  L~      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/DeprecatedTagValueNode.php  Ng  K]C      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireExtendsTagValueNode.php  Ng  >      A   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstFetchNode.php  Ng  "iT      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayNode.phpF  NgF  Y7      @   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNode.php   Ng         F   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprStringNode.php  Ng  &m      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprTrueNode.php5  Ng5  #6      G   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprIntegerNode.php  Ng  80      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFalseNode.php7  Ng7  c󷯤      I   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayItemNode.php  Ng  ۋ      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNullNode.php5  Ng5  "      N   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/DoctrineConstExprStringNode.phpt  Ngt  <      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFloatNode.php  Ng  Gʤ      4   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor.php
  Ng
  һc      C   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor/CloningVisitor.php  Ng        2   vendor/phpstan/phpdoc-parser/src/Ast/Attribute.phpp  Ngp  B      -   vendor/phpstan/phpdoc-parser/src/Ast/Node.php  Ng  I       ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/UnionTypeNode.php  Ng  '¤      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/IntersectionTypeNode.php
  Ng
  m      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/IdentifierTypeNode.php  Ng  z21      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeItemNode.php  Ng  o=      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConstTypeNode.php  Ng  V0	      G   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeParameterNode.php  Ng        >   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeNode.phpz  Ngz  z"      6   vendor/phpstan/phpdoc-parser/src/Ast/Type/TypeNode.php   Ng   9      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeItemNode.php  Ng  [Z      :   vendor/phpstan/phpdoc-parser/src/Ast/Type/ThisTypeNode.php'  Ng'  |      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeNode.phpR  NgR  7Nf      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/InvalidTypeNode.phpg  Ngg  L      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/OffsetAccessTypeNode.php  Ng  4      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeNode.php  Ng  Rפ      H   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeUnsealedTypeNode.php  Ng  t       M   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeForParameterNode.php  Ng  +$      >   vendor/phpstan/phpdoc-parser/src/Ast/Type/NullableTypeNode.php  Ng  qo      <   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeNode.php  Ng  \鿤      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/GenericTypeNode.php.  Ng.  3      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayTypeNode.phpi  Ngi  <p      <   vendor/phpstan/phpdoc-parser/src/Ast/AbstractNodeVisitor.php  Ng  }$      0   vendor/phpstan/phpdoc-parser/src/Ast/Comment.php  Ng  c軤      7   vendor/phpstan/phpdoc-parser/src/Ast/NodeAttributes.php+  Ng+        6   vendor/phpstan/phpdoc-parser/src/Ast/NodeTraverser.php*  Ng*           vendor/lcobucci/clock/LICENSE.  Ng.  >z      #   vendor/lcobucci/clock/renovate.json   Ng   ]G(      #   vendor/lcobucci/clock/composer.json,  Ng,  ;      #   vendor/lcobucci/clock/src/Clock.php   Ng   *	      )   vendor/lcobucci/clock/src/FrozenClock.php*  Ng*  8o      )   vendor/lcobucci/clock/src/SystemClock.php  Ng            vendor/bin/yaml-lint
  Ng
  8<h      "   vendor/bin/patch-type-declarations`
  Ng`
  +դ         vendor/bin/validate-json0
  Ng0
  ̤         vendor/bin/composer	
  Ng	
  k?ۤ         vendor/bin/var-dump-server?
  Ng?
  &j         vendor/bin/jsonlint  Ng  X      $   vendor/web-auth/webauthn-lib/LICENSE1  Ng1  2      *   vendor/web-auth/webauthn-lib/composer.json	  Ng	  =K      <   vendor/web-auth/webauthn-lib/src/FakeCredentialGenerator.php1  Ng1  cF,Ȥ      1   vendor/web-auth/webauthn-lib/src/StringStream.php'  Ng'  K1ۤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAlgorithm.php$  Ng$  $      D   vendor/web-auth/webauthn-lib/src/CeremonyStep/TopOriginValidator.php   Ng   Q      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserHandle.php  Ng         P   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckHasAttestedCredentialData.phpC  NgC  $Q      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManager.php  Ng  \TP      G   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserVerification.php3  Ng3  PX,      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAllowedCredentialList.php  Ng        C   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCredentialId.php  Ng  \	      W   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAttestationFormatIsKnownAndValid.phpH  NgH  $@s      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckSignature.php  Ng  !Ǥ      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/HostTopOriginValidator.php
  Ng
  #o      K   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckRelyingPartyIdIdHash.php
  Ng
  Oû      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckBackupBitsAreConsistent.php  Ng  a      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserWasPresent.php  Ng  w      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckClientDataCollectorType.php  Ng  =&      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckChallenge.php  Ng  g      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStep.php  Ng  ujv      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCounter.php  Ng  ʤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckTopOrigin.php  Ng  "      =   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckOrigin.php  Ng  Ť      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckExtensions.phpt  Ngt  =      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckMetadataStatement.php	   Ng	   `      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManagerFactory.php  Ng  ^fr      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialUserEntity.php  Ng  yP      7   vendor/web-auth/webauthn-lib/src/CertificateToolbox.php  Ng  µ      V   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensions.php  Ng  ;k      [   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputCheckerHandler.php}  Ng}  %}h      b   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientInputs.php  Ng  `i      R   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputError.php  Ng  H'      U   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtension.php  Ng  R      T   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputChecker.php   Ng   DA      c   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputs.php  Ng  
QT      i   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputsLoader.php  Ng  D+      e   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidSafetyNetAttestationStatementSupport.php66  Ng66  v      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/FidoU2FAttestationStatementSupport.phpZ  NgZ  T      Z   vendor/web-auth/webauthn-lib/src/AttestationStatement/AppleAttestationStatementSupport.phpR  NgR  9      Y   vendor/web-auth/webauthn-lib/src/AttestationStatement/NoneAttestationStatementSupport.phpz  Ngz  |       U   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupport.php  Ng  0Hä      Q   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObjectLoader.php  Ng  a      [   vendor/web-auth/webauthn-lib/src/AttestationStatement/PackedAttestationStatementSupport.php+  Ng+  ɯ      K   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObject.php  Ng  _f      _   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidKeyAttestationStatementSupport.phpM"  NgM"  O~O      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupportManager.php  Ng  o      X   vendor/web-auth/webauthn-lib/src/AttestationStatement/TPMAttestationStatementSupport.php=  Ng=  $3Y      N   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatement.php  Ng  *      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialLoader.php  Ng  x&      B   vendor/web-auth/webauthn-lib/src/SimpleFakeCredentialGenerator.php  Ng  Aݤ      >   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBinding.php  Ng  jhդ      H   vendor/web-auth/webauthn-lib/src/TokenBinding/SecTokenBindingHandler.php  Ng        K   vendor/web-auth/webauthn-lib/src/TokenBinding/IgnoreTokenBindingHandler.php  Ng  ɗCڤ      Q   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingNotSupportedHandler.php  Ng  W      E   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingHandler.phph  Ngh        <   vendor/web-auth/webauthn-lib/src/Util/CoseSignatureFixer.php`  Ng`  _nW      0   vendor/web-auth/webauthn-lib/src/Util/Base64.phps  Ngs  ݤ      ;   vendor/web-auth/webauthn-lib/src/AttestedCredentialData.php
  Ng
  sr      /   vendor/web-auth/webauthn-lib/src/Credential.php  Ng  h      N   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponseValidator.phpd2  Ngd2  s      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialParameters.php	  Ng	  #8r      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptor.php 
  Ng 
  9\o      @   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRpEntity.phpX  NgX  {B      E   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponse.php  Ng  J      ?   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialOptions.php  Ng  ^9      6   vendor/web-auth/webauthn-lib/src/AuthenticatorData.phpo
  Ngo
  Wo      L   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptorCollection.php  Ng  
?Ҥ      :   vendor/web-auth/webauthn-lib/src/AuthenticatorResponse.php  Ng  J      L   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponseValidator.php0  Ng0  Dߤ      C   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponse.php=  Ng=  Ȫ       W   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/PhpCertificateChainChecker.php  Ng  {Ϥ      T   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/CertificateChainChecker.php  Ng  2Ƥ      F   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRequestOptions.php.  Ng.  Dg      <   vendor/web-auth/webauthn-lib/src/AuthenticatorDataLoader.php  Ng  Lڤ      H   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSourceRepository.php   Ng   z      >   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPathLoader.php  Ng  @b      B   vendor/web-auth/webauthn-lib/src/TrustPath/EcdaaKeyIdTrustPath.php  Ng  ,q      8   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPath.php  Ng  "ߣ      =   vendor/web-auth/webauthn-lib/src/TrustPath/EmptyTrustPath.php  Ng  b_      C   vendor/web-auth/webauthn-lib/src/TrustPath/CertificateTrustPath.php  Ng  A#      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialEntity.php  Ng         L   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollector.phpA  NgA  У      S   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollectorManager.php  Ng  [6      X   vendor/web-auth/webauthn-lib/src/ClientDataCollector/WebauthnAuthenticationCollector.php  Ng  =m      D   vendor/web-auth/webauthn-lib/src/Counter/ThrowExceptionIfInvalid.phpw  Ngw  <Sڤ      ;   vendor/web-auth/webauthn-lib/src/Counter/CounterChecker.php  Ng        V   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionsDenormalizer.php	  Ng	  Jo0Ӥ      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationStatementDenormalizer.php  Ng        S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionNormalizer.php  Ng  9A      G   vendor/web-auth/webauthn-lib/src/Denormalizer/TrustPathDenormalizer.php  Ng        Q   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDenormalizer.php  Ng  ژؤ      K   vendor/web-auth/webauthn-lib/src/Denormalizer/WebauthnSerializerFactory.phpF
  NgF
  y      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/CollectedClientDataDenormalizer.php  Ng  ߺ䥤      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialParametersDenormalizer.php  Ng  1      ^   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAttestationResponseDenormalizer.php:  Ng:  .֤      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestedCredentialDataNormalizer.phpj  Ngj  !wJ      Y   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDescriptorNormalizer.phpy  Ngy  薆      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorDataDenormalizer.php  Ng  IV      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationObjectDenormalizer.php|  Ng|  =G      W   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialSourceDenormalizer.php  Ng  h2eԤ      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialUserEntityDenormalizer.php  Ng  Wݤ      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/ExtensionDescriptorDenormalizer.php(  Ng(  PwФ      _   vendor/web-auth/webauthn-lib/src/Denormalizer/VerificationMethodANDCombinationsDenormalizer.php  Ng  Eڵ      \   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAssertionResponseDenormalizer.php  Ng  s2P      S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorResponseDenormalizer.php  Ng  Wi      X   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialOptionsDenormalizer.php  Ng  w~      8   vendor/web-auth/webauthn-lib/src/PublicKeyCredential.php  Ng        D   vendor/web-auth/webauthn-lib/src/MetadataService/Psr18HttpClient.phpf  Ngf  	\      K   vendor/web-auth/webauthn-lib/src/MetadataService/StatusReportRepository.php3  Ng3  |`4&      _   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateChainValidator.phpT  NgT  Ѓv      X   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateToolbox.php  Ng  W֮y      b   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/PhpCertificateChainValidator.php'  Ng'  K%C      ?   vendor/web-auth/webauthn-lib/src/MetadataService/CanLogData.php   Ng   .j       P   vendor/web-auth/webauthn-lib/src/MetadataService/MetadataStatementRepository.php  Ng  8T      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/ExtensionDescriptor.php  Ng  I      U   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/CodeAccuracyDescriptor.php	  Ng	  P2      X   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/PatternAccuracyDescriptor.php	  Ng	  7\      P   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/MetadataStatement.phpQ  NgQ  02      S   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorGetInfo.php  Ng  ;T      `   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodANDCombinations.php  Ng  J      T   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricStatusReport.php  Ng  t%{      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorStatus.php  Ng  IJ>      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AbstractDescriptor.phpC  NgC  e0@      O   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/EcdaaTrustAnchor.php0
  Ng0
  Ҩ      K   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/StatusReport.php7  Ng7  P	      [   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodDescriptor.php!  Ng!   +9      V   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AlternativeDescriptions.php+  Ng+  c      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricAccuracyDescriptor.php	  Ng	  nX}}      F   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/Version.phpV	  NgV	        N   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RgbPaletteEntry.php\	  Ng\	  Pnu      M   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RogueListEntry.php  Ng  x"#      b   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/DisplayPNGCharacteristicsDescriptor.php  Ng  ꠼      @   vendor/web-auth/webauthn-lib/src/MetadataService/ValueFilter.phpo  Ngo  jPOϤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/ExtensionDescriptorDenormalizer.php  Ng  Ћz      d   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/MetadataStatementSerializerFactory.php  Ng  yx      a   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FidoAllianceCompliantMetadataService.php'  Ng'  +X5դ      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/JsonMetadataService.php	  Ng	  K      R   vendor/web-auth/webauthn-lib/src/MetadataService/Service/StringMetadataService.php  Ng  :)Ĥ      U   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayloadEntry.php  Ng  7      [   vendor/web-auth/webauthn-lib/src/MetadataService/Service/DistantResourceMetadataService.php  Ng  fB      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayload.php  Ng  4n      L   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataService.php  Ng        Y   vendor/web-auth/webauthn-lib/src/MetadataService/Service/LocalResourceMetadataService.php

  Ng

  i      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/ChainedMetadataServices.php  Ng        Z   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FolderResourceMetadataService.php
  Ng
  -NZ      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/InMemoryMetadataService.phpA  NgA  T      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/InvalidCertificateException.php  Ng  z]      W   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataServiceException.php  Ng  Y1ص      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/ExpiredCertificateException.php  Ng  g/      S   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateException.phpq  Ngq  h      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MissingMetadataStatementException.php  Ng  m %      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/RevokedCertificateException.php  Ng  /      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementLoadingException.php  Ng  /V      Y   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementException.php  Ng  c       X   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateChainException.php  Ng  ]ཤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateRevocationListException.php  Ng  [      L   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CanDispatchEvents.phpU  NgU  x      H   vendor/web-auth/webauthn-lib/src/MetadataService/Event/WebauthnEvent.phpA  NgA  o      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/BeforeCertificateChainValidation.php  Ng  <s
      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationFailed.php  Ng  @2      ^   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationSucceeded.php  Ng  
$      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Event/MetadataStatementFound.phpp  Ngp  3	      N   vendor/web-auth/webauthn-lib/src/MetadataService/Event/NullEventDispatcher.phpa  Nga  D
      C   vendor/web-auth/webauthn-lib/src/AuthenticatorSelectionCriteria.phpH   NgH   EѤ      X   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementVerificationException.phpn  Ngn  66      J   vendor/web-auth/webauthn-lib/src/Exception/InvalidCertificateException.php  Ng  ,s      S   vendor/web-auth/webauthn-lib/src/Exception/InvalidAttestationStatementException.php  Ng        G   vendor/web-auth/webauthn-lib/src/Exception/MetadataServiceException.php1  Ng1  \	      O   vendor/web-auth/webauthn-lib/src/Exception/AuthenticationExtensionException.php:  Ng:  CVs      @   vendor/web-auth/webauthn-lib/src/Exception/WebauthnException.php*  Ng*  m2      H   vendor/web-auth/webauthn-lib/src/Exception/InvalidTrustPathException.php3  Ng3  ".      Y   vendor/web-auth/webauthn-lib/src/Exception/AuthenticatorResponseVerificationException.php>  Ng>  
      J   vendor/web-auth/webauthn-lib/src/Exception/ExpiredCertificateException.php  Ng  p      J   vendor/web-auth/webauthn-lib/src/Exception/UnsupportedFeatureException.php5  Ng5  G      C   vendor/web-auth/webauthn-lib/src/Exception/CertificateException.phpO  NgO  Zl      P   vendor/web-auth/webauthn-lib/src/Exception/MissingMetadataStatementException.php;  Ng;  )<Ԥ      J   vendor/web-auth/webauthn-lib/src/Exception/RevokedCertificateException.php   Ng   cO      L   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementException.php   Ng   n      P   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementLoadingException.phpz  Ngz  $BC      ?   vendor/web-auth/webauthn-lib/src/Exception/CounterException.phpL  NgL        I   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementException.php   Ng   ng      H   vendor/web-auth/webauthn-lib/src/Exception/CertificateChainException.php  Ng  [4ۤ      S   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementLoadingException.php  Ng        C   vendor/web-auth/webauthn-lib/src/Exception/InvalidDataException.php  Ng  ޘ+      Q   vendor/web-auth/webauthn-lib/src/Exception/CertificateRevocationListException.php  Ng  q9      I   vendor/web-auth/webauthn-lib/src/Exception/InvalidUserHandleException.phpe  Nge  |      1   vendor/web-auth/webauthn-lib/src/U2FPublicKey.php  Ng  T      <   vendor/web-auth/webauthn-lib/src/Event/CanDispatchEvents.php  Ng  ':      c   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationSucceededEvent.php7  Ng7  \Z      8   vendor/web-auth/webauthn-lib/src/Event/WebauthnEvent.phpg   Ngg   >G      B   vendor/web-auth/webauthn-lib/src/Event/AttestationObjectLoaded.php  Ng  ob      a   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationSucceededEvent.php  Ng         ^   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationFailedEvent.php  Ng  o~֤      K   vendor/web-auth/webauthn-lib/src/Event/BeforeCertificateChainValidation.phpX  NgX  /      K   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationFailed.phpX  NgX  p      N   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationSucceeded.php[  Ng[  (ɤ      A   vendor/web-auth/webauthn-lib/src/Event/MetadataStatementFound.php  Ng  
      >   vendor/web-auth/webauthn-lib/src/Event/NullEventDispatcher.php8  Ng8  }o      `   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationFailedEvent.php  Ng  <?      E   vendor/web-auth/webauthn-lib/src/Event/AttestationStatementLoaded.php  Ng  |7      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSource.php"  Ng"  Ik      G   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialCreationOptions.phpo)  Ngo)  í      8   vendor/web-auth/webauthn-lib/src/CollectedClientData.phpr  Ngr  +Ĥ          vendor/web-auth/cose-lib/LICENSE,  Ng,  C      "   vendor/web-auth/cose-lib/README.md  Ng  Ŭ      &   vendor/web-auth/cose-lib/composer.json  Ng  B:+j      $   vendor/web-auth/cose-lib/SECURITY.md  Ng  Y{      %   vendor/web-auth/cose-lib/src/Hash.php  Ng  8pȤ      (   vendor/web-auth/cose-lib/src/Key/Key.php	  Ng	  o      +   vendor/web-auth/cose-lib/src/Key/RsaKey.php
  Ng
  ZΤ      1   vendor/web-auth/cose-lib/src/Key/SymmetricKey.php  Ng  f      +   vendor/web-auth/cose-lib/src/Key/Ec2Key.php  Ng  ʤ      +   vendor/web-auth/cose-lib/src/Key/OkpKey.php
  Ng
  ?      9   vendor/web-auth/cose-lib/src/Algorithm/ManagerFactory.php  Ng  E      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256.php  Ng  U0      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECDSA.php  Ng  Af      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES384.php  Ng  "8      F   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECSignature.php  Ng  3y      A   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256K.php  Ng  8      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES512.php  Ng  ˤ      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS1.php  Ng  ]2      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RSA.php  Ng  #2      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS384.php  Ng  
f¤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS256.php  Ng  掤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS384.php  Ng  {      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS256.php  Ng        >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS512.php  Ng  *(z      ?   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PSSRSA.php\  Ng\  i"      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS512.php  Ng  kJ      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed512.php  Ng  ƩK      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/EdDSA.php  Ng  ~e0      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed256.php  Ng  Xy      B   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed25519.php@  Ng@  	      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/Signature.phpV  NgV  ;      4   vendor/web-auth/cose-lib/src/Algorithm/Algorithm.php   Ng   =
h      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS512.php  Ng  4X e      3   vendor/web-auth/cose-lib/src/Algorithm/Mac/Hmac.php  Ng  Jd      2   vendor/web-auth/cose-lib/src/Algorithm/Mac/Mac.phpJ  NgJ  l'      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS384.php  Ng  5YF      ?   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256Truncated64.php  Ng  y      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256.php  Ng        2   vendor/web-auth/cose-lib/src/Algorithm/Manager.php  Ng  ,      +   vendor/web-auth/cose-lib/src/BigInteger.php  Ng  Yy      +   vendor/web-auth/cose-lib/src/Algorithms.phpX  NgX  S@      '   vendor/composer/autoload_namespaces.php   Ng   /t      &   vendor/composer/xdebug-handler/LICENSE)  Ng)  #;^      +   vendor/composer/xdebug-handler/CHANGELOG.md  Ng  !YsK      (   vendor/composer/xdebug-handler/README.md4  Ng4  S%      ,   vendor/composer/xdebug-handler/composer.jsony  Ngy  -      0   vendor/composer/xdebug-handler/src/PhpConfig.php  Ng  ]      -   vendor/composer/xdebug-handler/src/Status.phpz  Ngz  "      4   vendor/composer/xdebug-handler/src/XdebugHandler.phpKV  NgKV  Eb      .   vendor/composer/xdebug-handler/src/Process.phpH  NgH  G      +   vendor/composer/class-map-generator/LICENSE  Ng  DӤ      -   vendor/composer/class-map-generator/README.mdN  NgN  K(      1   vendor/composer/class-map-generator/composer.json  Ng  |(~      =   vendor/composer/class-map-generator/src/ClassMapGenerator.phpk6  Ngk6  2Bgn      :   vendor/composer/class-map-generator/src/PhpFileCleaner.php?  Ng?  s      4   vendor/composer/class-map-generator/src/FileList.phpc  Ngc  r5      9   vendor/composer/class-map-generator/src/PhpFileParser.php  Ng  8C      4   vendor/composer/class-map-generator/src/ClassMap.php  Ng           vendor/composer/LICENSE.  Ng.            vendor/composer/ClassLoader.php?  Ng?  2@u      +   vendor/composer/composer/phpstan/rules.neon  Ng  ~d      1   vendor/composer/composer/res/composer-schema.json  Ng  -Zy       6   vendor/composer/composer/res/composer-lock-schema.json
  Ng
  rf      <   vendor/composer/composer/res/composer-repository-schema.json   Ng   븂      &   vendor/composer/composer/composer.lockK NgK R          vendor/composer/composer/LICENSE,  Ng,  Vg      %   vendor/composer/composer/bin/composer  Ng  -0~      $   vendor/composer/composer/bin/compile  Ng  \0      &   vendor/composer/composer/composer.json  Ng  Sv'      S   vendor/composer/composer/src/Composer/PHPStan/RuleReasonDataReturnTypeExtension.php
  Ng
  
      K   vendor/composer/composer/src/Composer/PHPStan/ConfigReturnTypeExtension.phpL"  NgL"  W      1   vendor/composer/composer/src/Composer/Factory.php  Ng  z0      H   vendor/composer/composer/src/Composer/Repository/RepositoryInterface.php  Ng  й      R   vendor/composer/composer/src/Composer/Repository/InstalledFilesystemRepository.php  Ng  J=      F   vendor/composer/composer/src/Composer/Repository/PackageRepository.phpl  Ngl  +Z%      H   vendor/composer/composer/src/Composer/Repository/LockArrayRepository.php  Ng  Ȥ      G   vendor/composer/composer/src/Composer/Repository/PlatformRepository.php  Ng  ,+      F   vendor/composer/composer/src/Composer/Repository/RepositoryFactory.php$   Ng$   8l      Q   vendor/composer/composer/src/Composer/Repository/InstalledRepositoryInterface.php  Ng  +      P   vendor/composer/composer/src/Composer/Repository/WritableRepositoryInterface.php@  Ng@  ek      D   vendor/composer/composer/src/Composer/Repository/RepositoryUtils.php
  Ng
        P   vendor/composer/composer/src/Composer/Repository/RepositorySecurityException.php  Ng  l	Ф      H   vendor/composer/composer/src/Composer/Repository/CompositeRepository.php  Ng  $	)      D   vendor/composer/composer/src/Composer/Repository/ArrayRepository.phpw(  Ngw(  x)      L   vendor/composer/composer/src/Composer/Repository/WritableArrayRepository.php	  Ng	  X      B   vendor/composer/composer/src/Composer/Repository/VcsRepository.phpR  NgR  Bq      G   vendor/composer/composer/src/Composer/Repository/ComposerRepository.php1 Ng1 h)      C   vendor/composer/composer/src/Composer/Repository/PearRepository.php`  Ng`        B   vendor/composer/composer/src/Composer/Repository/RepositorySet.phpA  NgA  _O      G   vendor/composer/composer/src/Composer/Repository/ArtifactRepository.php  Ng  e      J   vendor/composer/composer/src/Composer/Repository/RootPackageRepository.php:  Ng:  V>      F   vendor/composer/composer/src/Composer/Repository/RepositoryManager.php  Ng  nH      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitHubDriver.phpZ  NgZ  U s      B   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriver.php  Ng  rO      B   vendor/composer/composer/src/Composer/Repository/Vcs/SvnDriver.php3  Ng3  ʍE      A   vendor/composer/composer/src/Composer/Repository/Vcs/HgDriver.php6  Ng6         G   vendor/composer/composer/src/Composer/Repository/Vcs/PerforceDriver.php  Ng  %6ɤ      K   vendor/composer/composer/src/Composer/Repository/Vcs/GitBitbucketDriver.php8  Ng8  Mn      B   vendor/composer/composer/src/Composer/Repository/Vcs/GitDriver.php!  Ng!  Zf      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitLabDriver.php4R  Ng4R  \6L      K   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriverInterface.php
  Ng
  O
4ۤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/FossilDriver.php\  Ng\  b:      C   vendor/composer/composer/src/Composer/Repository/PathRepository.phpK"  NgK"  -Ƥ      J   vendor/composer/composer/src/Composer/Repository/VersionCacheInterface.phpd  Ngd  ~      K   vendor/composer/composer/src/Composer/Repository/CanonicalPackagesTrait.php  Ng  =      E   vendor/composer/composer/src/Composer/Repository/FilterRepository.php  Ng  X      H   vendor/composer/composer/src/Composer/Repository/InstalledRepository.phpI3  NgI3  ̤      N   vendor/composer/composer/src/Composer/Repository/AdvisoryProviderInterface.php  Ng  XD@      I   vendor/composer/composer/src/Composer/Repository/FilesystemRepository.php??  Ng??  W      M   vendor/composer/composer/src/Composer/Repository/InstalledArrayRepository.php  Ng  f~      T   vendor/composer/composer/src/Composer/Repository/ConfigurableRepositoryInterface.php  Ng  F*'      O   vendor/composer/composer/src/Composer/Repository/InvalidRepositoryException.php  Ng  f=      <   vendor/composer/composer/src/Composer/Util/PackageSorter.phpN  NgN  8
      >   vendor/composer/composer/src/Composer/Util/ConfigValidator.php[$  Ng[$   zf      2   vendor/composer/composer/src/Composer/Util/Git.phpqi  Ngqi        2   vendor/composer/composer/src/Composer/Util/Svn.php&  Ng&  sH      =   vendor/composer/composer/src/Composer/Util/NoProxyPattern.php)  Ng)  x      =   vendor/composer/composer/src/Composer/Util/ComposerMirror.phpW	  NgW	  ~w      :   vendor/composer/composer/src/Composer/Util/PackageInfo.phpA  NgA  #R      9   vendor/composer/composer/src/Composer/Util/AuthHelper.php8  Ng8        2   vendor/composer/composer/src/Composer/Util/Zip.phpR
  NgR
  Aä      7   vendor/composer/composer/src/Composer/Util/Silencer.php/  Ng/  <      9   vendor/composer/composer/src/Composer/Util/Filesystem.phpd{  Ngd{  d}`      2   vendor/composer/composer/src/Composer/Util/Tar.php  Ng  
Ǥ      5   vendor/composer/composer/src/Composer/Util/GitHub.php!  Ng!  j\	v      5   vendor/composer/composer/src/Composer/Util/GitLab.php/  Ng/  |!      8   vendor/composer/composer/src/Composer/Util/Bitbucket.php9&  Ng9&  	ǽ      =   vendor/composer/composer/src/Composer/Util/HttpDownloader.php)H  Ng)H  s%G      8   vendor/composer/composer/src/Composer/Util/IniHelper.phpm  Ngm  7r      7   vendor/composer/composer/src/Composer/Util/Platform.php*  Ng*  hP      C   vendor/composer/composer/src/Composer/Util/StreamContextFactory.php"  Ng"  ?x      8   vendor/composer/composer/src/Composer/Util/TlsHelper.php  Ng  5FϤ      2   vendor/composer/composer/src/Composer/Util/Url.php  Ng  ʉ٤      7   vendor/composer/composer/src/Composer/Util/Perforce.php2L  Ng2L  
Ǥ      @   vendor/composer/composer/src/Composer/Util/Http/ProxyManager.php  Ng  ewY      <   vendor/composer/composer/src/Composer/Util/Http/Response.phpa  Nga  ^      @   vendor/composer/composer/src/Composer/Util/Http/RequestProxy.php  Ng  Mg      B   vendor/composer/composer/src/Composer/Util/Http/CurlDownloader.phpy  Ngy  'B      @   vendor/composer/composer/src/Composer/Util/Http/CurlResponse.php  Ng  1'ɤ      =   vendor/composer/composer/src/Composer/Util/Http/ProxyItem.php  Ng  =eY      ?   vendor/composer/composer/src/Composer/Util/MetadataMinifier.php  Ng  #`      >   vendor/composer/composer/src/Composer/Util/ProcessExecutor.phpE  NgE  5U      1   vendor/composer/composer/src/Composer/Util/Hg.php  Ng  Q5      ?   vendor/composer/composer/src/Composer/Util/RemoteFilesystem.php?l  Ng?l  q'      ;   vendor/composer/composer/src/Composer/Util/ErrorHandler.php,
  Ng,
  JC      9   vendor/composer/composer/src/Composer/Util/SyncHelper.php
  Ng
  ެpQ      3   vendor/composer/composer/src/Composer/Util/Loop.php2  Ng2        A   vendor/composer/composer/src/Composer/Config/JsonConfigSource.phpv)  Ngv)        F   vendor/composer/composer/src/Composer/Config/ConfigSourceInterface.phpf  Ngf  (פ      =   vendor/composer/composer/src/Composer/SelfUpdate/Versions.php  Ng  .]!      9   vendor/composer/composer/src/Composer/SelfUpdate/Keys.php  Ng  -*      /   vendor/composer/composer/src/Composer/Cache.php+  Ng+  @U      ?   vendor/composer/composer/src/Composer/EventDispatcher/Event.php  Ng  ~ k      R   vendor/composer/composer/src/Composer/EventDispatcher/ScriptExecutionException.php  Ng  ;;      I   vendor/composer/composer/src/Composer/EventDispatcher/EventDispatcher.php4  Ng4  Dפ      R   vendor/composer/composer/src/Composer/EventDispatcher/EventSubscriberInterface.phpu  Ngu  h_}      9   vendor/composer/composer/src/Composer/PartialComposer.php'
  Ng'
  c      :   vendor/composer/composer/src/Composer/Platform/Runtime.php
	  Ng
	  :K(      ?   vendor/composer/composer/src/Composer/Platform/HhvmDetector.php  Ng  H껥      :   vendor/composer/composer/src/Composer/Platform/Version.php
  Ng
  \      5   vendor/composer/composer/src/Composer/IO/BufferIO.php  Ng  '˄      6   vendor/composer/composer/src/Composer/IO/ConsoleIO.phpK)  NgK)  51      3   vendor/composer/composer/src/Composer/IO/BaseIO.phpX#  NgX#        3   vendor/composer/composer/src/Composer/IO/NullIO.php	  Ng	  {      8   vendor/composer/composer/src/Composer/IO/IOInterface.phpZ   NgZ   
      =   vendor/composer/composer/src/Composer/Plugin/PluginEvents.phpe  Nge  1+ˤ      C   vendor/composer/composer/src/Composer/Plugin/PreCommandRunEvent.php2  Ng2  :q@      K   vendor/composer/composer/src/Composer/Plugin/Capability/CommandProvider.php  Ng  d,      F   vendor/composer/composer/src/Composer/Plugin/Capability/Capability.php  Ng  Lk      G   vendor/composer/composer/src/Composer/Plugin/PluginBlockedException.php  Ng  Nu      =   vendor/composer/composer/src/Composer/Plugin/CommandEvent.phpy  Ngy  /      @   vendor/composer/composer/src/Composer/Plugin/PluginInterface.php?  Ng?  #?"      >   vendor/composer/composer/src/Composer/Plugin/PluginManager.phpP  NgP  .r      E   vendor/composer/composer/src/Composer/Plugin/PreFileDownloadEvent.php9  Ng9        F   vendor/composer/composer/src/Composer/Plugin/PostFileDownloadEvent.php
  Ng
        8   vendor/composer/composer/src/Composer/Plugin/Capable.php  Ng  u      C   vendor/composer/composer/src/Composer/Plugin/PrePoolCreateEvent.php  Ng  H      B   vendor/composer/composer/src/Composer/Downloader/RarDownloader.php	  Ng	  "Ĥ      R   vendor/composer/composer/src/Composer/Downloader/VcsCapableDownloaderInterface.phpC  NgC  H      B   vendor/composer/composer/src/Composer/Downloader/VcsDownloader.php4  Ng4  \4=      H   vendor/composer/composer/src/Composer/Downloader/FilesystemException.php  Ng  J      D   vendor/composer/composer/src/Composer/Downloader/DownloadManager.phpR<  NgR<  H      B   vendor/composer/composer/src/Composer/Downloader/TarDownloader.php  Ng  K7J      E   vendor/composer/composer/src/Composer/Downloader/FossilDownloader.php  Ng  WΤ      Q   vendor/composer/composer/src/Composer/Downloader/MaxFileSizeExceededException.php  Ng  `ܤ      H   vendor/composer/composer/src/Composer/Downloader/DownloaderInterface.php  Ng  x      A   vendor/composer/composer/src/Composer/Downloader/XzDownloader.phpQ  NgQ  aYŤ      A   vendor/composer/composer/src/Composer/Downloader/HgDownloader.php  Ng  p      B   vendor/composer/composer/src/Composer/Downloader/SvnDownloader.php"  Ng"  rv      C   vendor/composer/composer/src/Composer/Downloader/FileDownloader.phpCS  NgCS  R      J   vendor/composer/composer/src/Composer/Downloader/ChangeReportInterface.php'  Ng'  }s$      G   vendor/composer/composer/src/Composer/Downloader/TransportException.php  Ng  ʤ      F   vendor/composer/composer/src/Composer/Downloader/ArchiveDownloader.php!  Ng!  {Z      L   vendor/composer/composer/src/Composer/Downloader/DvcsDownloaderInterface.php6  Ng6  1N}      C   vendor/composer/composer/src/Composer/Downloader/PharDownloader.php  Ng  /&֤      C   vendor/composer/composer/src/Composer/Downloader/PathDownloader.php6  Ng6  ,_      G   vendor/composer/composer/src/Composer/Downloader/PerforceDownloader.php
  Ng
  R.      B   vendor/composer/composer/src/Composer/Downloader/GitDownloader.phpa  Nga  5Ȥ      B   vendor/composer/composer/src/Composer/Downloader/ZipDownloader.phpL9  NgL9  0      C   vendor/composer/composer/src/Composer/Downloader/GzipDownloader.php  Ng  S      0   vendor/composer/composer/src/Composer/Config.phpCa  NgCa  ~s      6   vendor/composer/composer/src/Composer/Script/Event.php  Ng  D]      =   vendor/composer/composer/src/Composer/Script/ScriptEvents.php  Ng  KGꮤ      M   vendor/composer/composer/src/Composer/Question/StrictConfirmationQuestion.php  Ng  `a      2   vendor/composer/composer/src/Composer/Composer.php  Ng  o]Ƥ      F   vendor/composer/composer/src/Composer/Json/JsonValidationException.phpl  Ngl  exˤ      <   vendor/composer/composer/src/Composer/Json/JsonFormatter.phpe  Nge        7   vendor/composer/composer/src/Composer/Json/JsonFile.php3  Ng3  N      >   vendor/composer/composer/src/Composer/Json/JsonManipulator.php8S  Ng8S  WT      ;   vendor/composer/composer/src/Composer/InstalledVersions.phpIB  NgIB   "      W   vendor/composer/composer/src/Composer/DependencyResolver/Operation/InstallOperation.phpz  Ngz  =~i      b   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasInstalledOperation.phpx  Ngx  nҤ      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/OperationInterface.php  Ng  }|(̤      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UpdateOperation.phpw  Ngw  c;      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/SolverOperation.php  Ng  Iw      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UninstallOperation.phpb  Ngb  &Yl      d   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasUninstalledOperation.php~  Ng~        H   vendor/composer/composer/src/Composer/DependencyResolver/Transaction.php8  Ng8  |Ԥ      L   vendor/composer/composer/src/Composer/DependencyResolver/PolicyInterface.php  Ng         Q   vendor/composer/composer/src/Composer/DependencyResolver/LocalRepoTransaction.php(  Ng(  tʺ      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchGraph.phpA  NgA  >      H   vendor/composer/composer/src/Composer/DependencyResolver/GenericRule.php  Ng  >>MV      L   vendor/composer/composer/src/Composer/DependencyResolver/LockTransaction.php  Ng  h      C   vendor/composer/composer/src/Composer/DependencyResolver/Solver.phph  Ngh  s      A   vendor/composer/composer/src/Composer/DependencyResolver/Rule.phpN  NgN  d ۤ      J   vendor/composer/composer/src/Composer/DependencyResolver/Rule2Literals.php
  Ng
  dײ      T   vendor/composer/composer/src/Composer/DependencyResolver/SolverProblemsException.php  Ng  18M      O   vendor/composer/composer/src/Composer/DependencyResolver/SolverBugException.php  Ng  /d      J   vendor/composer/composer/src/Composer/DependencyResolver/DefaultPolicy.php(  Ng(  
8      J   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchNode.php  Ng  '      D   vendor/composer/composer/src/Composer/DependencyResolver/RuleSet.phpX  NgX  q      A   vendor/composer/composer/src/Composer/DependencyResolver/Pool.php   Ng   ?6lJ      N   vendor/composer/composer/src/Composer/DependencyResolver/MultiConflictRule.phpq  Ngq  S8e      D   vendor/composer/composer/src/Composer/DependencyResolver/Request.php!  Ng!  1      J   vendor/composer/composer/src/Composer/DependencyResolver/PoolOptimizer.phpM  NgM  	zA      M   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetGenerator.php6  Ng6  w      F   vendor/composer/composer/src/Composer/DependencyResolver/Decisions.php  Ng  Q      H   vendor/composer/composer/src/Composer/DependencyResolver/PoolBuilder.php  Ng  	dA"      D   vendor/composer/composer/src/Composer/DependencyResolver/Problem.php-  Ng-  3C      L   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetIterator.phpC
  NgC
  r      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchChain.php  Ng  ]      D   vendor/composer/composer/src/Composer/Autoload/AutoloadGenerator.phpM  NgM  pN      >   vendor/composer/composer/src/Composer/Autoload/ClassLoader.phpg>  Ngg>  v      D   vendor/composer/composer/src/Composer/Autoload/ClassMapGenerator.php  Ng  I%c       A   vendor/composer/composer/src/Composer/Command/SuggestsCommand.php;  Ng;  :&|      ?   vendor/composer/composer/src/Composer/Command/SearchCommand.php  Ng  k^      =   vendor/composer/composer/src/Composer/Command/BumpCommand.php&  Ng&  r      @   vendor/composer/composer/src/Composer/Command/ArchiveCommand.php*!  Ng*!  sM      >   vendor/composer/composer/src/Composer/Command/AuditCommand.php3  Ng3  jl      A   vendor/composer/composer/src/Composer/Command/ValidateCommand.phpm$  Ngm$  撌r      =   vendor/composer/composer/src/Composer/Command/FundCommand.php  Ng  {      G   vendor/composer/composer/src/Composer/Command/PackageDiscoveryTrait.phpO  NgO  G:      D   vendor/composer/composer/src/Composer/Command/ScriptAliasCommand.php
  Ng
  \       F   vendor/composer/composer/src/Composer/Command/CreateProjectCommand.php^  Ng^  4Ѥ      =   vendor/composer/composer/src/Composer/Command/BaseCommand.phpB  NgB  ?a      A   vendor/composer/composer/src/Composer/Command/OutdatedCommand.phpB  NgB  G      E   vendor/composer/composer/src/Composer/Command/DumpAutoloadCommand.php  Ng        =   vendor/composer/composer/src/Composer/Command/HomeCommand.phpC  NgC  rj      B   vendor/composer/composer/src/Composer/Command/ReinstallCommand.php#  Ng#  "       ?   vendor/composer/composer/src/Composer/Command/RemoveCommand.php;  Ng;        =   vendor/composer/composer/src/Composer/Command/ShowCommand.php% Ng% 	EO      @   vendor/composer/composer/src/Composer/Command/InstallCommand.php  Ng  
q      =   vendor/composer/composer/src/Composer/Command/InitCommand.php([  Ng([  (!#ͤ      B   vendor/composer/composer/src/Composer/Command/RunScriptCommand.php  Ng  rm      ?   vendor/composer/composer/src/Composer/Command/ConfigCommand.phpȜ  NgȜ  J瑤      A   vendor/composer/composer/src/Composer/Command/LicensesCommand.php  Ng  8$䂤      ?   vendor/composer/composer/src/Composer/Command/UpdateCommand.phpeN  NgeN  J(      ?   vendor/composer/composer/src/Composer/Command/StatusCommand.php{   Ng{   C      G   vendor/composer/composer/src/Composer/Command/BaseDependencyCommand.php3  Ng3        @   vendor/composer/composer/src/Composer/Command/DependsCommand.php  Ng  vN      B   vendor/composer/composer/src/Composer/Command/ProhibitsCommand.php  Ng   &      J   vendor/composer/composer/src/Composer/Command/CheckPlatformReqsCommand.php  Ng  Yj      C   vendor/composer/composer/src/Composer/Command/SelfUpdateCommand.phpi  Ngi        @   vendor/composer/composer/src/Composer/Command/RequireCommand.phps  Ngs  ^;      A   vendor/composer/composer/src/Composer/Command/CompletionTrait.php#  Ng#  "i      C   vendor/composer/composer/src/Composer/Command/ClearCacheCommand.phpX
  NgX
  (      A   vendor/composer/composer/src/Composer/Command/DiagnoseCommand.phpF  NgF  Þ      ?   vendor/composer/composer/src/Composer/Command/GlobalCommand.php  Ng  ~i      >   vendor/composer/composer/src/Composer/Command/AboutCommand.php  Ng  
      =   vendor/composer/composer/src/Composer/Command/ExecCommand.php>  Ng>  Ƙi      3   vendor/composer/composer/src/Composer/Installer.php  Ng  MI      m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterInterface.php  Ng         m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreAllPlatformRequirementFilter.php  Ng  u      n   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreListPlatformRequirementFilter.php  Ng  f      q   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreNothingPlatformRequirementFilter.php  Ng  u      k   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterFactory.php  Ng  $¤      A   vendor/composer/composer/src/Composer/Installer/PackageEvents.php"  Ng"  ]m      C   vendor/composer/composer/src/Composer/Installer/BinaryInstaller.php8  Ng8  b>      C   vendor/composer/composer/src/Composer/Installer/PluginInstaller.phpw  Ngw  0\      K   vendor/composer/composer/src/Composer/Installer/BinaryPresenceInterface.php  Ng  <P      C   vendor/composer/composer/src/Composer/Installer/InstallerEvents.php  Ng  "e      @   vendor/composer/composer/src/Composer/Installer/PackageEvent.php  Ng  T      B   vendor/composer/composer/src/Composer/Installer/InstallerEvent.php  Ng  r>      D   vendor/composer/composer/src/Composer/Installer/LibraryInstaller.php&,  Ng&,        F   vendor/composer/composer/src/Composer/Installer/InstallerInterface.php1  Ng1  K;      H   vendor/composer/composer/src/Composer/Installer/MetapackageInstaller.php  Ng  ն٤      D   vendor/composer/composer/src/Composer/Installer/ProjectInstaller.php
  Ng
        M   vendor/composer/composer/src/Composer/Installer/SuggestedPackagesReporter.php  Ng  vӤ      G   vendor/composer/composer/src/Composer/Installer/InstallationManager.php`  Ng`  @!      A   vendor/composer/composer/src/Composer/Installer/NoopInstaller.phpY  NgY  ^.      C   vendor/composer/composer/src/Composer/Advisory/SecurityAdvisory.php  Ng  ݭ      J   vendor/composer/composer/src/Composer/Advisory/PartialSecurityAdvisory.php  Ng  u      :   vendor/composer/composer/src/Composer/Advisory/Auditor.php=  Ng=  ̶Ҥ      J   vendor/composer/composer/src/Composer/Advisory/IgnoredSecurityAdvisory.phpk  Ngk  K`      R   vendor/composer/composer/src/Composer/Exception/IrrecoverableDownloadException.php  Ng        B   vendor/composer/composer/src/Composer/Exception/NoSslException.php  Ng  ;P      2   vendor/composer/composer/src/Composer/Compiler.php-  Ng-  zq      9   vendor/composer/composer/src/Composer/Package/Package.phpD  NgD  i?f      6   vendor/composer/composer/src/Composer/Package/Link.php
  Ng
  +H      J   vendor/composer/composer/src/Composer/Package/CompletePackageInterface.php  Ng  }{+      I   vendor/composer/composer/src/Composer/Package/Archiver/ArchiveManager.php$  Ng$        P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFinder.phpq  Ngq  ߶q      G   vendor/composer/composer/src/Composer/Package/Archiver/PharArchiver.php  Ng  ǁM      L   vendor/composer/composer/src/Composer/Package/Archiver/BaseExcludeFilter.php  Ng  @ݤ      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFilter.php  Ng  ߵ      K   vendor/composer/composer/src/Composer/Package/Archiver/GitExcludeFilter.php  Ng  ^      P   vendor/composer/composer/src/Composer/Package/Archiver/ComposerExcludeFilter.php  Ng  ޣ      L   vendor/composer/composer/src/Composer/Package/Archiver/ArchiverInterface.php  Ng  ;w      F   vendor/composer/composer/src/Composer/Package/Archiver/ZipArchiver.php  Ng  L      F   vendor/composer/composer/src/Composer/Package/CompleteAliasPackage.php  Ng  lN(      >   vendor/composer/composer/src/Composer/Package/AliasPackage.phpe'  Nge'  Ҥ      8   vendor/composer/composer/src/Composer/Package/Locker.php/X  Ng/X        B   vendor/composer/composer/src/Composer/Package/PackageInterface.php00  Ng00  "'      G   vendor/composer/composer/src/Composer/Package/Version/VersionBumper.phpS  NgS  p      I   vendor/composer/composer/src/Composer/Package/Version/StabilityFilter.php  Ng  5      H   vendor/composer/composer/src/Composer/Package/Version/VersionGuesser.phpWH  NgWH  kS      I   vendor/composer/composer/src/Composer/Package/Version/VersionSelector.php0  Ng0  
      G   vendor/composer/composer/src/Composer/Package/Version/VersionParser.php  Ng  
?      N   vendor/composer/composer/src/Composer/Package/Loader/ValidatingArrayLoader.phpu  Ngu  _U      P   vendor/composer/composer/src/Composer/Package/Loader/InvalidPackageException.phpo  Ngo  ,Ҥ      D   vendor/composer/composer/src/Composer/Package/Loader/ArrayLoader.phpF  NgF  W
      H   vendor/composer/composer/src/Composer/Package/Loader/LoaderInterface.phpj  Ngj  7      J   vendor/composer/composer/src/Composer/Package/Loader/RootPackageLoader.phpO.  NgO.  pk      C   vendor/composer/composer/src/Composer/Package/Loader/JsonLoader.phpc  Ngc  ܝ@      =   vendor/composer/composer/src/Composer/Package/BasePackage.php  Ng  $8      C   vendor/composer/composer/src/Composer/Package/Comparer/Comparer.php  Ng  fɋ      B   vendor/composer/composer/src/Composer/Package/RootAliasPackage.php  Ng  r      A   vendor/composer/composer/src/Composer/Package/CompletePackage.php@  Ng@  ew      F   vendor/composer/composer/src/Composer/Package/RootPackageInterface.php  Ng  S      =   vendor/composer/composer/src/Composer/Package/RootPackage.phpZ  NgZ  k      D   vendor/composer/composer/src/Composer/Package/Dumper/ArrayDumper.php  Ng  )=      =   vendor/composer/composer/src/Composer/Console/Application.php$  Ng$  d      C   vendor/composer/composer/src/Composer/Console/GithubActionError.phpl  Ngl  g`+      E   vendor/composer/composer/src/Composer/Console/Input/InputArgument.php
  Ng
  &o      C   vendor/composer/composer/src/Composer/Console/Input/InputOption.php  Ng  (C      E   vendor/composer/composer/src/Composer/Console/HtmlOutputFormatter.php1  Ng1  g?Ѥ      *   vendor/composer/composer/src/bootstrap.php7  Ng7  t      (   vendor/composer/ca-bundle/res/cacert.pem/ Ng/ \{      !   vendor/composer/ca-bundle/LICENSE  Ng  *!^`      #   vendor/composer/ca-bundle/README.md1  Ng1  >VuĤ      '   vendor/composer/ca-bundle/composer.json5  Ng5  y:      *   vendor/composer/ca-bundle/src/CaBundle.phpE+  NgE+  &V      !   vendor/composer/autoload_psr4.php  Ng        %   vendor/composer/autoload_classmap.phpE NgE 
f      "   vendor/composer/platform_check.php  Ng        #   vendor/composer/autoload_static.phpm Ngm (GR      !   vendor/composer/autoload_real.php  Ng  `O         vendor/composer/semver/LICENSE  Ng  Bh      #   vendor/composer/semver/CHANGELOG.mdi'  Ngi'  [L          vendor/composer/semver/README.mdH
  NgH
   }Τ      $   vendor/composer/semver/composer.json  Ng  z)      /   vendor/composer/semver/src/CompilingMatcher.php
  Ng
  F      '   vendor/composer/semver/src/Interval.phpu  Ngu         )   vendor/composer/semver/src/Comparator.php<
  Ng<
  <L      (   vendor/composer/semver/src/Intervals.phpLP  NgLP  K.      %   vendor/composer/semver/src/Semver.phpr
  Ngr
  Τ      ,   vendor/composer/semver/src/VersionParser.phpSU  NgSU  <J?F      =   vendor/composer/semver/src/Constraint/ConstraintInterface.php  Ng  겤      9   vendor/composer/semver/src/Constraint/MultiConstraint.php#  Ng#  o      4   vendor/composer/semver/src/Constraint/Constraint.php2  Ng2  *      <   vendor/composer/semver/src/Constraint/MatchAllConstraint.php,  Ng,  [j<      =   vendor/composer/semver/src/Constraint/MatchNoneConstraint.php(  Ng(  h      /   vendor/composer/semver/src/Constraint/Bound.php
  Ng
        "   vendor/composer/autoload_files.phpD  NgD  ̲hѤ      %   vendor/composer/InstalledVersions.phpIB  NgIB   "         vendor/composer/installed.php_  Ng_  Ӄjf         vendor/composer/pcre/LICENSE  Ng  hg^         vendor/composer/pcre/README.md!  Ng!  B      #   vendor/composer/pcre/extension.neon  Ng  &&1      "   vendor/composer/pcre/composer.json  Ng  r7      E   vendor/composer/pcre/src/PHPStan/PregMatchTypeSpecifyingExtension.php  Ng  UJl      L   vendor/composer/pcre/src/PHPStan/PregReplaceCallbackClosureTypeExtension.php`
  Ng`
  |~      G   vendor/composer/pcre/src/PHPStan/PregMatchParameterOutTypeExtension.php  Ng        <   vendor/composer/pcre/src/PHPStan/InvalidRegexPatternRule.phpV  NgV   r      3   vendor/composer/pcre/src/PHPStan/PregMatchFlags.php		  Ng		  wD3B      ?   vendor/composer/pcre/src/PHPStan/UnsafeStrictGroupsCallRule.php
  Ng
  tCs      (   vendor/composer/pcre/src/MatchResult.php  Ng  ڇҤ      "   vendor/composer/pcre/src/Regex.php  Ng  ɤ      6   vendor/composer/pcre/src/MatchAllWithOffsetsResult.php  Ng        3   vendor/composer/pcre/src/MatchWithOffsetsResult.php  Ng  o      7   vendor/composer/pcre/src/MatchAllStrictGroupsResult.phpw  Ngw  Q      9   vendor/composer/pcre/src/UnexpectedNullMatchException.php"  Ng"  _      4   vendor/composer/pcre/src/MatchStrictGroupsResult.php  Ng        +   vendor/composer/pcre/src/MatchAllResult.php  Ng  	Z      *   vendor/composer/pcre/src/ReplaceResult.php  Ng  /      !   vendor/composer/pcre/src/Preg.phpE  NgE  ]G      *   vendor/composer/pcre/src/PcreException.phpw  Ngw  'v      )   vendor/composer/metadata-minifier/LICENSE  Ng  hg^      +   vendor/composer/metadata-minifier/README.mdL  NgL  Mv<      3   vendor/composer/metadata-minifier/phpstan.neon.distB   NgB   #f      /   vendor/composer/metadata-minifier/composer.json  Ng  D0פ      :   vendor/composer/metadata-minifier/src/MetadataMinifier.php
  Ng
         6   vendor/composer/spdx-licenses/res/spdx-exceptions.json  Ng  "m      4   vendor/composer/spdx-licenses/res/spdx-licenses.json  Ng  
x       %   vendor/composer/spdx-licenses/LICENSE  Ng  Bh      *   vendor/composer/spdx-licenses/CHANGELOG.mdS  NgS  p+      '   vendor/composer/spdx-licenses/README.md<  Ng<  se      /   vendor/composer/spdx-licenses/phpstan.neon.dist   Ng   -      +   vendor/composer/spdx-licenses/composer.json  Ng   '      2   vendor/composer/spdx-licenses/src/SpdxLicenses.php%  Ng%  ]H
      .   vendor/phpdocumentor/reflection-common/LICENSE9  Ng9  *2Ȑ      0   vendor/phpdocumentor/reflection-common/README.mdO  NgO  
һ      4   vendor/phpdocumentor/reflection-common/composer.json  Ng  k6      6   vendor/phpdocumentor/reflection-common/src/Element.php  Ng  7      =   vendor/phpdocumentor/reflection-common/src/ProjectFactory.phpf  Ngf        3   vendor/phpdocumentor/reflection-common/src/File.php  Ng  s      6   vendor/phpdocumentor/reflection-common/src/Project.php  Ng  c=      4   vendor/phpdocumentor/reflection-common/src/Fqsen.php  Ng  p      7   vendor/phpdocumentor/reflection-common/src/Location.php  Ng  ;      *   vendor/phpdocumentor/type-resolver/LICENSE8  Ng8  ʤ      2   vendor/phpdocumentor/type-resolver/phpdoc.dist.xml  Ng  DA낤      ,   vendor/phpdocumentor/type-resolver/README.md#  Ng#  ܵ\      0   vendor/phpdocumentor/type-resolver/composer.json  Ng  \[      7   vendor/phpdocumentor/type-resolver/src/TypeResolver.phpc]  Ngc]  v      ;   vendor/phpdocumentor/type-resolver/src/Types/Expression.phpF  NgF  PM      8   vendor/phpdocumentor/type-resolver/src/Types/Boolean.php|  Ng|  M65      8   vendor/phpdocumentor/type-resolver/src/Types/Integer.phpx  Ngx  jJ&      6   vendor/phpdocumentor/type-resolver/src/Types/Self_.php  Ng  SY      6   vendor/phpdocumentor/type-resolver/src/Types/Void_.php  Ng  Dk'٤      6   vendor/phpdocumentor/type-resolver/src/Types/Null_.php  Ng  G      :   vendor/phpdocumentor/type-resolver/src/Types/Resource_.php  Ng  JϤ      7   vendor/phpdocumentor/type-resolver/src/Types/Float_.phpu  Ngu  Hդ      8   vendor/phpdocumentor/type-resolver/src/Types/Object_.php  Ng  "]!      8   vendor/phpdocumentor/type-resolver/src/Types/String_.php  Ng  V̤      9   vendor/phpdocumentor/type-resolver/src/Types/Nullable.php`  Ng`  uy      :   vendor/phpdocumentor/type-resolver/src/Types/Callable_.php  Ng  l      @   vendor/phpdocumentor/type-resolver/src/Types/InterfaceString.php  Ng  >^      :   vendor/phpdocumentor/type-resolver/src/Types/Iterable_.phpF  NgF   'y      B   vendor/phpdocumentor/type-resolver/src/Types/CallableParameter.php  Ng  /      9   vendor/phpdocumentor/type-resolver/src/Types/ArrayKey.php  Ng  ?n)      7   vendor/phpdocumentor/type-resolver/src/Types/Never_.php  Ng  	'      8   vendor/phpdocumentor/type-resolver/src/Types/Static_.php  Ng  {6@      <   vendor/phpdocumentor/type-resolver/src/Types/ClassString.php_  Ng_  g      8   vendor/phpdocumentor/type-resolver/src/Types/Parent_.php  Ng  ip      7   vendor/phpdocumentor/type-resolver/src/Types/Scalar.php  Ng  ؤ      8   vendor/phpdocumentor/type-resolver/src/Types/Context.php  Ng  fYK      =   vendor/phpdocumentor/type-resolver/src/Types/AbstractList.php  Ng  &      ;   vendor/phpdocumentor/type-resolver/src/Types/Collection.php  Ng  䅝      =   vendor/phpdocumentor/type-resolver/src/Types/Intersection.php$  Ng$        ?   vendor/phpdocumentor/type-resolver/src/Types/ContextFactory.php7  Ng7  v#      ?   vendor/phpdocumentor/type-resolver/src/Types/AggregatedType.php
  Ng
  C`      9   vendor/phpdocumentor/type-resolver/src/Types/Compound.php  Ng        5   vendor/phpdocumentor/type-resolver/src/Types/This.phpg  Ngg  ~+6      7   vendor/phpdocumentor/type-resolver/src/Types/Array_.php  Ng   NK      7   vendor/phpdocumentor/type-resolver/src/Types/Mixed_.php  Ng        /   vendor/phpdocumentor/type-resolver/src/Type.php  Ng  q4      8   vendor/phpdocumentor/type-resolver/src/FqsenResolver.php	  Ng	  ͢      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/StringValue.php  Ng  FI      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/List_.php  Ng  O      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyString.php}  Ng}   i      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ShapeItem.php+  Ng+  NG      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerRange.phpA  NgA  ֭Z$      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/CallableString.php|  Ng|        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShapeItem.php   Ng   곤      ?   vendor/phpdocumentor/type-resolver/src/PseudoTypes/Numeric_.php(  Ng(  ^6      =   vendor/phpdocumentor/type-resolver/src/PseudoTypes/False_.php  Ng  /      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShapeItem.php   Ng   IC3      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/TraitString.phpv  Ngv  {      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/FloatValue.php  Ng  4AY      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NumericString.phpz  Ngz  *      H   vendor/phpdocumentor/type-resolver/src/PseudoTypes/HtmlEscapedString.php  Ng  y"Ѥ      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerValue.php  Ng  R4      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LiteralString.phpz  Ngz        C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyList.php  Ng  I      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ConstExpression.php  Ng  oe4      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShape.php  Ng  frd      N   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyLowercaseString.php  Ng        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyArray.php  Ng  ,      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LowercaseString.php~  Ng~  kc      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/True_.php  Ng  W      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShape.php3  Ng3  p      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NegativeInteger.phpw  Ngw  p      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShapeItem.phpe  Nge  7      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShape.phpM  NgM  *9      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/PositiveInteger.phpw  Ngw  .      5   vendor/phpdocumentor/type-resolver/src/PseudoType.php|  Ng|  }      0   vendor/phpdocumentor/reflection-docblock/LICENSE8  Ng8  ʤ      2   vendor/phpdocumentor/reflection-docblock/README.md[  Ng[  \S      6   vendor/phpdocumentor/reflection-docblock/composer.json  Ng        @   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactory.php0  Ng0  O?&      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Serializer.phpH  NgH  gդ      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/ExampleFinder.phpI  NgI  	T      =   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tag.php  Ng  ῤ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/TagFactory.php
  Ng
  ROJ      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/DescriptionFactory.php<  Ng<  FJ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Since.php
  Ng
  ,      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyWrite.php  Ng  ֻ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/MethodParameter.php  Ng  K銤      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Link.php  Ng  j
      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/InvalidTag.php  Ng  _<j      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/BaseTag.php  Ng  y{      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Var_.php  Ng  x֤      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Param.php9  Ng9  ֩      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Mixin.php  Ng        P   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateCovariant.php  Ng  ͤ      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Method.php'  Ng'  ʤ      H   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter.php,  Ng,  <c      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Uses.phpV
  NgV
  .Ѥ      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Return_.php  Ng  }þ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/PassthroughFormatter.php  Ng  ZL      W   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/AlignFormatter.php  Ng  e&A      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateImplements.php  Ng  r      K   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyRead.php  Ng  )r      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Property.php  Ng  q}      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Version.php
  Ng
  .2      B   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/See.php5  Ng5  
      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Extends_.php,  Ng,  gE      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Generic.php	  Ng	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TagWithType.php	  Ng	  _UG      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Source.php  Ng  cM      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Template.phpM	  NgM	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Implements_.php5  Ng5  q      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Author.php	  Ng	  8"      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Throws.php  Ng        X   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ImplementsFactory.php  Ng  5      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/Factory.phpJ  NgJ  \Τ      Z   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyReadFactory.php*  Ng*  )܈      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ExtendsFactory.php  Ng  if      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/StaticMethod.php%  Ng%  cTg      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/AbstractPHPStanFactory.php  Ng  0      [   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyWriteFactory.php.  Ng.  k      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/VarFactory.php  Ng  $      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodFactory.phpC
  NgC
  [<      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateFactory.phpJ  NgJ  !rs      `   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateImplementsFactory.php  Ng  {׮      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ParamFactory.php  Ng  j      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodParameterFactory.phpN	  NgN	  ^E      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PHPStanFactory.php  Ng  gɉ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateExtendsFactory.php  Ng  %?      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyFactory.php  Ng  dB      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ReturnFactory.php  Ng  z      R   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Reference.php  Ng  g      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Url.php  Ng  ޛ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Fqsen.php*  Ng*        N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateExtends.php  Ng        F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Example.php  Ng  c      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Deprecated.php  Ng  v      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Covers.php
  Ng
  
C      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/StandardTagFactory.php4  Ng4  ~      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Description.php<  Ng<  TT|      6   vendor/phpdocumentor/reflection-docblock/src/Utils.php	  Ng	  Ԥ      I   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactoryInterface.php  Ng  δ      9   vendor/phpdocumentor/reflection-docblock/src/DocBlock.php  Ng  Zr      H   vendor/phpdocumentor/reflection-docblock/src/Exception/PcreException.php  Ng  ~	g      1   vendor/paragonie/constant_time_encoding/README.md~
  Ng~
  uLR      3   vendor/paragonie/constant_time_encoding/LICENSE.txte	  Nge	  |[      5   vendor/paragonie/constant_time_encoding/composer.json  Ng  `Zo>      =   vendor/paragonie/constant_time_encoding/src/Base64UrlSafe.phpm  Ngm  W}¤      9   vendor/paragonie/constant_time_encoding/src/Base32Hex.php9
  Ng9
  fm      >   vendor/paragonie/constant_time_encoding/src/Base64DotSlash.php  Ng  %o      8   vendor/paragonie/constant_time_encoding/src/Encoding.php,  Ng,  R2~      @   vendor/paragonie/constant_time_encoding/src/EncoderInterface.php  Ng  s:      6   vendor/paragonie/constant_time_encoding/src/Base32.php<  Ng<  $HC      3   vendor/paragonie/constant_time_encoding/src/Hex.php  Ng  bFǤ      E   vendor/paragonie/constant_time_encoding/src/Base64DotSlashOrdered.php
  Ng
  ?Na      6   vendor/paragonie/constant_time_encoding/src/Binary.php
  Ng
  ތ      7   vendor/paragonie/constant_time_encoding/src/RFC4648.php  Ng        6   vendor/paragonie/constant_time_encoding/src/Base64.phpc$  Ngc$  K      #   vendor/spomky-labs/cbor-php/LICENSE,  Ng,  C      %   vendor/spomky-labs/cbor-php/README.md[+  Ng[+        )   vendor/spomky-labs/cbor-php/composer.json'  Ng'  -k      '   vendor/spomky-labs/cbor-php/SECURITY.md  Ng  Ǥ      0   vendor/spomky-labs/cbor-php/src/StringStream.phpe  Nge  &o      :   vendor/spomky-labs/cbor-php/src/OtherObject/TrueObject.php  Ng  b1F      ;   vendor/spomky-labs/cbor-php/src/OtherObject/BreakObject.phpX  NgX  &c      D   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectInterface.phpt  Ngt  аȤ      J   vendor/spomky-labs/cbor-php/src/OtherObject/SinglePrecisionFloatObject.phpQ  NgQ  t      =   vendor/spomky-labs/cbor-php/src/OtherObject/GenericObject.php  Ng  ku5      ;   vendor/spomky-labs/cbor-php/src/OtherObject/FalseObject.php  Ng  =
      ?   vendor/spomky-labs/cbor-php/src/OtherObject/UndefinedObject.phpd  Ngd  IM(      J   vendor/spomky-labs/cbor-php/src/OtherObject/DoublePrecisionFloatObject.php  Ng  ]      K   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManagerInterface.php   Ng   I      H   vendor/spomky-labs/cbor-php/src/OtherObject/HalfPrecisionFloatObject.phpq  Ngq  WF       <   vendor/spomky-labs/cbor-php/src/OtherObject/SimpleObject.php	  Ng	  :j      :   vendor/spomky-labs/cbor-php/src/OtherObject/NullObject.php  Ng  .      B   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManager.php~  Ng~  =*F      4   vendor/spomky-labs/cbor-php/src/DecoderInterface.php   Ng   \f      4   vendor/spomky-labs/cbor-php/src/ByteStringObject.php  Ng  Bl      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthTextStringObject.php*  Ng*  `갤      '   vendor/spomky-labs/cbor-php/src/Tag.phpc  Ngc  }      +   vendor/spomky-labs/cbor-php/src/Decoder.php#  Ng#  "I      9   vendor/spomky-labs/cbor-php/src/UnsignedIntegerObject.php  Ng  򽩜      6   vendor/spomky-labs/cbor-php/src/AbstractCBORObject.phpY  NgY  @z>      0   vendor/spomky-labs/cbor-php/src/Normalizable.php   Ng   xӤ      4   vendor/spomky-labs/cbor-php/src/LengthCalculator.php|  Ng|  N`      /   vendor/spomky-labs/cbor-php/src/OtherObject.php  Ng  ?73      *   vendor/spomky-labs/cbor-php/src/Stream.php   Ng   $c      4   vendor/spomky-labs/cbor-php/src/TextStringObject.php  Ng  1aM      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthByteStringObject.php3  Ng3  Q      >   vendor/spomky-labs/cbor-php/src/IndefiniteLengthListObject.php  Ng  cR¤      =   vendor/spomky-labs/cbor-php/src/IndefiniteLengthMapObject.php  Ng  y8      +   vendor/spomky-labs/cbor-php/src/MapItem.php  Ng         )   vendor/spomky-labs/cbor-php/src/Utils.phpv  Ngv  p#      .   vendor/spomky-labs/cbor-php/src/ListObject.php  Ng  0S      -   vendor/spomky-labs/cbor-php/src/MapObject.phpg  Ngg  /k      .   vendor/spomky-labs/cbor-php/src/CBORObject.php~  Ng~  4      .   vendor/spomky-labs/cbor-php/src/Tag/UriTag.php  Ng  )      <   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlEncodingTag.php  Ng  ܤ      =   vendor/spomky-labs/cbor-php/src/Tag/NegativeBigIntegerTag.php_  Ng_  [ؠd      :   vendor/spomky-labs/cbor-php/src/Tag/DecimalFractionTag.php
  Ng
        ;   vendor/spomky-labs/cbor-php/src/Tag/TagManagerInterface.php  Ng  cG      4   vendor/spomky-labs/cbor-php/src/Tag/TagInterface.phph  Ngh        4   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlTag.php  Ng  }       3   vendor/spomky-labs/cbor-php/src/Tag/BigFloatTag.php
  Ng
  M@Ǥ      /   vendor/spomky-labs/cbor-php/src/Tag/CBORTag.php}  Ng}  %Ƥ      /   vendor/spomky-labs/cbor-php/src/Tag/MimeTag.php  Ng  <,      3   vendor/spomky-labs/cbor-php/src/Tag/DatetimeTag.php  Ng  bʤ      7   vendor/spomky-labs/cbor-php/src/Tag/CBOREncodingTag.php  Ng   lM      1   vendor/spomky-labs/cbor-php/src/Tag/Base64Tag.php  Ng  |㨤      9   vendor/spomky-labs/cbor-php/src/Tag/Base16EncodingTag.php  Ng  M9      =   vendor/spomky-labs/cbor-php/src/Tag/UnsignedBigIntegerTag.php  Ng  |}      2   vendor/spomky-labs/cbor-php/src/Tag/TagManager.phpE  NgE  a      4   vendor/spomky-labs/cbor-php/src/Tag/TimestampTag.php  Ng  qJ      2   vendor/spomky-labs/cbor-php/src/Tag/GenericTag.php  Ng  22      9   vendor/spomky-labs/cbor-php/src/Tag/Base64EncodingTag.php  Ng   k      9   vendor/spomky-labs/cbor-php/src/NegativeIntegerObject.php  Ng  bx7      (   vendor/spomky-labs/pki-framework/LICENSES  NgS  t      *   vendor/spomky-labs/pki-framework/README.md  Ng  7/V      .   vendor/spomky-labs/pki-framework/composer.json
  Ng
  eD      ,   vendor/spomky-labs/pki-framework/SECURITY.mdI  NgI  ,)      5   vendor/spomky-labs/pki-framework/src/ASN1/Element.php<  Ng<  9t      9   vendor/spomky-labs/pki-framework/src/ASN1/Util/BigInt.php  Ng  `}      8   vendor/spomky-labs/pki-framework/src/ASN1/Util/Flags.php  Ng  
      B   vendor/spomky-labs/pki-framework/src/ASN1/Component/Identifier.php  Ng  J=      >   vendor/spomky-labs/pki-framework/src/ASN1/Component/Length.php  Ng  ri
      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveType.php,  Ng,  SZe2      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseString.php  Ng  M"~      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BMPString.php_  Ng_  .      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Boolean.php9  Ng9  p@      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Integer.phpa  Nga  @n      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/RelativeOID.php  Ng  lb      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VisibleString.php  Ng  wn      C   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Number.php  Ng  zڡ      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTF8String.php  Ng  b      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BitString.php  Ng  +      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/IA5String.php  Ng  c&k      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UniversalString.php  Ng  l0ޤ      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GraphicString.php  Ng  W      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectDescriptor.php  Ng  Y1      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Real.phpQ  NgQ  ~^      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/PrintableString.php  Ng  iTȘ      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/EOC.php  Ng  !¤      E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NullType.php  Ng  o      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectIdentifier.php  Ng  z&      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Enumerated.php:  Ng:  N      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NumericString.php  Ng  y{      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/OctetString.php2  Ng2  y      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralizedTime.php7  Ng7  l
      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTCTime.php:	  Ng:	  3W-N      K   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VideotexString.php  Ng  =đ      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/CharacterString.php>  Ng>         F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/T61String.php  Ng  _      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralString.php  Ng  wӺ      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/TimeType.php;  Ng;  -R
      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitTagging.php  Ng  Wq      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ContextSpecificType.php   Ng   X      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitlyTaggedType.php&  Ng&        E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/PrivateType.php   Ng   4eY      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ApplicationType.php   Ng   CF      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitlyTaggedType.php@  Ng@        G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/DERTaggedType.php  Ng  }LV      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/TaggedTypeWrap.php'  Ng'  :      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitTagging.php  Ng  \      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Sequence.php[  Ng[  x       B   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Set.php$  Ng$  ~      P   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/ConstructedString.php  Ng  2L:      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveString.php  Ng  @$      <   vendor/spomky-labs/pki-framework/src/ASN1/Type/Structure.phpM  NgM  f<      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseTime.php  Ng  CLb      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/UnspecifiedType.php/?  Ng/?  ?qФ      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/TaggedType.php	  Ng	  m      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/StringType.php  Ng  &      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/UniversalClass.php  Ng  o      5   vendor/spomky-labs/pki-framework/src/ASN1/DERData.php  Ng  ($Ĥ      A   vendor/spomky-labs/pki-framework/src/ASN1/Feature/ElementBase.php  Ng  }<t      @   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Stringable.phps  Ngs  FM      ?   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Encodable.php   Ng   ܴ;      G   vendor/spomky-labs/pki-framework/src/ASN1/Exception/DecodeException.php   Ng   }Ӥ      ;   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEM.php  Ng  |f"ˤ      A   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEMBundle.php  Ng  La      J   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto/OpenSSLCrypto.php  Ng        <   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto.php  Ng  @      >   vendor/spomky-labs/pki-framework/src/X509/Certificate/Time.php	  Ng	  n      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CRLDistributionPointsExtension.php
  Ng
  X      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectDirectoryAttributesExtension.php&  Ng&  K+Y      n   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/SubjectAccessDescription.phpw  Ngw  e\      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AccessDescription.php  Ng        p   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AuthorityAccessDescription.phpJ  NgJ  (~s      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NoRevocationAvailableExtension.php  Ng        ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyConstraintsExtension.php  Ng  v!      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityInformationAccessExtension.php
  Ng
        e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectInformationAccessExtension.php'
  Ng'
   .î      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/TargetInformationExtension.phpN
  NgN
  tc(      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/KeyUsageExtension.php  Ng  W).      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetName.php  Ng  HA      R   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Targets.php
  Ng
  `%      Q   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Target.phps  Ngs  G]b      V   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetGroup.php  Ng  1*      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappings/PolicyMapping.phph  Ngh  Ť      \   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraintsExtension.phpp  Ngp  i      X   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/FreshestCRLExtension.phpU  NgU  E      T   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/UnknownExtension.php  Ng  m      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/IssuerAlternativeNameExtension.php  Ng  7@A^      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePoliciesExtension.phpx
  Ngx
        ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/InhibitAnyPolicyExtension.phpf  Ngf  UP      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/RelativeName.phpe  Nge  iwX      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPoint.php  Ng  pӿ      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/FullName.php  Ng  4      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/ReasonFlags.php  Ng  dŤ      k   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPointName.php  Ng  TQ      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtrees.php  Ng  hL\      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtree.php
  Ng
  K      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/ExtendedKeyUsageExtension.php  Ng  WL      W   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AAControlsExtension.php  Ng  er      e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/NoticeReference.phpa  Nga  
      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyQualifierInfo.php  Ng  Dr      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/UserNoticeQualifier.php	  Ng	  4s      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyInformation.phpt  Ngt  ҫ       a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/DisplayText.php6  Ng6  Ť      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/CPSQualifier.phpK  NgK  $vu      [   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappingsExtension.php  Ng  p'i      M   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Extension.php'  Ng'  b      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityKeyIdentifierExtension.php  Ng  pT      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectAlternativeNameExtension.php  Ng  6+      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/BasicConstraintsExtension.php	  Ng	  ?z      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectKeyIdentifierExtension.php  Ng  )VS      E   vendor/spomky-labs/pki-framework/src/X509/Certificate/Certificate.php  Ng  7;      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/UniqueIdentifier.php  Ng  q      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateChain.php  Ng  N8      B   vendor/spomky-labs/pki-framework/src/X509/Certificate/Validity.phpx  Ngx  $Ҥ      K   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateBundle.phpC  NgC        H   vendor/spomky-labs/pki-framework/src/X509/Certificate/TBSCertificate.php8  Ng8  b^      D   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extensions.php$  Ng$  [      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RegisteredID.php  Ng  Z3      G   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DirectoryName.php]  Ng]  ^      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/EDIPartyName.php  Ng  Noߤ      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/OtherName.php  Ng  V$d      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPAddress.php  Ng  ?U      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/X400Address.php  Ng  T      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv4Address.php!  Ng!  #      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralNames.php  Ng  \֤      S   vendor/spomky-labs/pki-framework/src/X509/GeneralName/UniformResourceIdentifier.php  Ng  e      D   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RFC822Name.php  Ng  Mpn      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralName.phpD
  NgD
        E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv6Address.php  Ng   Ip      A   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DNSName.php(  Ng(  Yj      D   vendor/spomky-labs/pki-framework/src/X509/Feature/DateTimeHelper.php  Ng  $u      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationConfig.php  Ng  U\      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationResult.php\  Ng\  c[      ]   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/ValidatorState.php)  Ng)  0p      \   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidator.phpB  NgB  ~i      e   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathBuilding/CertificationPathBuilder.php  Ng  h      _   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathBuildingException.php  Ng  v      a   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathValidationException.phpC  NgC  Wb'      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyNode.phpT  NgT  Rn      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyTree.php+5  Ng+5  1ؤ      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/CertificationPath.php  Ng  s      O   vendor/spomky-labs/pki-framework/src/X509/Exception/X509ValidationException.php   Ng   ?$      i   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AccessIdentityAttributeValue.php5  Ng5  3c      Z   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrValue.php  Ng  f#       Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/SvceAuthInfo.php	  Ng	  Gh      m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AuthenticationInfoAttributeValue.phpN  NgN  ˯Ť      k   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/ChargingIdentityAttributeValue.php  Ng  d      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/GroupAttributeValue.php  Ng  vR      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrSyntax.php  Ng        _   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/RoleAttributeValue.php  Ng  q1      M   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attributes.php   Ng   pr      O   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/IssuerSerial.php  Ng  hU      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Holder.php  Ng  pS      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/V2Form.php  Ng  ~      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificateInfo.phpK&  NgK&  lz      S   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/ObjectDigestInfo.php	  Ng	  >      P   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertIssuer.phpB  NgB  y0      W   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificate.php  Ng        X   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertValidityPeriod.php$  Ng$  t      Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidator.php  Ng        m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/Exception/ACValidationException.php
  Ng
  K      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidationConfig.php  Ng  6      W   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequest.php  Ng  `      b   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attribute/ExtensionRequestValue.phpD  NgD  
      M   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attributes.php  Ng        [   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequestInfo.php  Ng  X      6   vendor/spomky-labs/pki-framework/src/X501/ASN1/RDN.php  Ng  u晤      @   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeType.php@  Ng@  7P      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SequenceOfAttributes.php  Ng  xDc      M   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SetOfAttributes.php2  Ng2  %      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/AttributeCollection.php"  Ng"  ,L      <   vendor/spomky-labs/pki-framework/src/X501/ASN1/Attribute.php#  Ng#  9      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/LocalityNameValue.php  Ng  `      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/GivenNameValue.php  Ng  g      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationNameValue.php  Ng  09      L   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/TitleValue.php  Ng  f2      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SerialNumberValue.php  Ng  G      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/AttributeValue.php  Ng  Sg&      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/DescriptionValue.php  Ng  GϤ      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CountryNameValue.php  Ng  k      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CommonNameValue.php  Ng  40L      N   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SurnameValue.php  Ng  l      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/PseudonymValue.php  Ng        Z   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/StateOrProvinceNameValue.php  Ng  ˤ      ^   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/PrintableStringValue.php  Ng  Rp      Y   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/DirectoryString.php  Ng  W      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/UnknownAttributeValue.php<	  Ng<	  %U      ]   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationalUnitNameValue.php  Ng  6ۺ      K   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/NameValue.php  Ng        H   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeTypeAndValue.phpe  Nge  z\      7   vendor/spomky-labs/pki-framework/src/X501/ASN1/Name.phpP  NgP  :      9   vendor/spomky-labs/pki-framework/src/X501/DN/DNParser.phpd(  Ngd(        G   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/MatchingRule.phpP  NgP  ~j2      J   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseIgnoreMatch.php  Ng   Eʤ      I   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseExactMatch.php  Ng  }      Q   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/StringPrepMatchingRule.php{  Ng{  峿      F   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/BinaryMatch.php  Ng  	r      @   vendor/spomky-labs/pki-framework/src/X501/StringPrep/MapStep.phpn  Ngn  T      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/NormalizeStep.php
  Ng
  q      D   vendor/spomky-labs/pki-framework/src/X501/StringPrep/PrepareStep.php  Ng  o*      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/TranscodeStep.phpA	  NgA	  B      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/CheckBidiStep.php  Ng  tId      G   vendor/spomky-labs/pki-framework/src/X501/StringPrep/StringPreparer.php  Ng  o<I      E   vendor/spomky-labs/pki-framework/src/X501/StringPrep/ProhibitStep.php  Ng        [   vendor/spomky-labs/pki-framework/src/X501/StringPrep/InsignificantNonSubstringSpaceStep.php!  Ng!  Q6|      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed25519Signature.php  Ng        M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed448Signature.php  Ng  Pb      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/GenericSignature.phpB  NgB   ~      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/ECSignature.php  Ng        K   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/RSASignature.phpY  NgY  ފ-      H   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Signature.php  Ng  U(      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/OneAsymmetricKey.php)  Ng)  NM@      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/Attribute/OneAsymmetricKeyAttributes.php  Ng  H      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPublicKey.php
  Ng
  3:      Q   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPrivateKey.phpO  NgO  U      W   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSASSAPSSPrivateKey.phpj  Ngj  f*      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPublicKey.phpm  Ngm  Ҥ      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPrivateKey.php*  Ng*  QOM2      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECConversion.php  Ng  Ғ      I   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKey.php3  Ng3  Zh      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKeyInfo.php  Ng  Ln+      Y   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PrivateKey.phpj
  Ngj
  "      X   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PublicKey.php  Ng  ;.      ^   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PublicKey.php  Ng  O      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PublicKey.php  Ng  +/      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PrivateKey.php  Ng  Q      `   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PrivateKey.php  Ng  	      b   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PublicKey.php  Ng  .)      f   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PublicKey.php  Ng  4I      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PrivateKey.php  Ng  vV      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PrivateKey.php3  Ng3  D3      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PublicKey.php  Ng  ʙ      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PrivateKey.php  Ng  .:      M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKeyInfo.php  Ng  3D      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKey.php0  Ng0  Ix      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/SpecificAlgorithmIdentifier.phpW  NgW  y      \   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifier.phpp  Ngp  %H      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA384WithRSAEncryptionAlgorithmIdentifier.php  Ng  O+      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD2WithRSAEncryptionAlgorithmIdentifier.php  Ng  Qߕޤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA256AlgorithmIdentifier.php  Ng  -      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA224AlgorithmIdentifier.php  Ng  
      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD5WithRSAEncryptionAlgorithmIdentifier.php  Ng  +      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC3279RSASignatureAlgorithmIdentifier.php  Ng  )af      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD4WithRSAEncryptionAlgorithmIdentifier.php  Ng  wl      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC4055RSASignatureAlgorithmIdentifier.phpl  Ngl  _esԤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA512AlgorithmIdentifier.php  Ng  6f{      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RSASignatureAlgorithmIdentifier.php  Ng  |Ǥ      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA256WithRSAEncryptionAlgorithmIdentifier.php  Ng  `%      s   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA1AlgorithmIdentifier.php  Ng  bd      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA384AlgorithmIdentifier.php  Ng  ,P      q   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECSignatureAlgorithmIdentifier.php  Ng  _<      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA512WithRSAEncryptionAlgorithmIdentifier.php  Ng        {   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA1WithRSAEncryptionAlgorithmIdentifier.php  Ng  1      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA224WithRSAEncryptionAlgorithmIdentifier.php  Ng  &n      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA224AlgorithmIdentifier.php  Ng  Ф      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA224AlgorithmIdentifier.php  Ng  1]̤      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA256AlgorithmIdentifier.php  Ng  L      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA256AlgorithmIdentifier.php  Ng  F      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/RFC4231HMACAlgorithmIdentifier.phps  Ngs  TE      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA512AlgorithmIdentifier.php  Ng  N      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA512AlgorithmIdentifier.php  Ng  Iˤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA1AlgorithmIdentifier.php  Ng  l	d      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA2AlgorithmIdentifier.php  Ng  	      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/MD5AlgorithmIdentifier.php  Ng  :      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA1AlgorithmIdentifier.phpy  Ngy        o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA384AlgorithmIdentifier.php  Ng  /4      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA384AlgorithmIdentifier.php  Ng  MaA4      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/RC2CBCAlgorithmIdentifier.php  Ng        m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESEDE3CBCAlgorithmIdentifier.phpg  Ngg  p      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES192CBCAlgorithmIdentifier.php  Ng        i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AESCBCAlgorithmIdentifier.php  Ng  qz      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/CipherAlgorithmIdentifier.php8  Ng8   "¤      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESCBCAlgorithmIdentifier.php  Ng  HY      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/BlockCipherAlgorithmIdentifier.phpd  Ngd  ~      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES128CBCAlgorithmIdentifier.php|  Ng|  Wϸ      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES256CBCAlgorithmIdentifier.php  Ng  |Ĥ      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/ECPublicKeyAlgorithmIdentifier.php/  Ng/  D      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X25519AlgorithmIdentifier.php+  Ng+  0Ŕ      k   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X448AlgorithmIdentifier.php#  Ng#  oœ#      p   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410EdAlgorithmIdentifier.php  Ng   ߎ      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAEncryptionAlgorithmIdentifier.php  Ng  seR      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed448AlgorithmIdentifier.php  Ng  ְ      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410XAlgorithmIdentifier.php  Ng  L~.      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAPSSSSAEncryptionAlgorithmIdentifier.php  Ng  Z      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed25519AlgorithmIdentifier.php  Ng         c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierFactory.php$  Ng$  #ꨤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/SignatureAlgorithmIdentifier.php  Ng  3!      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/PRFAlgorithmIdentifier.php   Ng   !$      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AsymmetricCryptoAlgorithmIdentifier.php
  Ng
  C      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/HashAlgorithmIdentifier.php   Ng   &-      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/EncryptionAlgorithmIdentifier.php   Ng   bO      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AlgorithmIdentifierType.phpy  Ngy  l̤      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierProvider.php  Ng  k\d      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/GenericAlgorithmIdentifier.php  Ng  CI	          vendor/spomky-labs/otphp/LICENSE@  Ng@  xi      "   vendor/spomky-labs/otphp/README.md%  Ng%  z@      &   vendor/spomky-labs/otphp/composer.json  Ng  ;       $   vendor/spomky-labs/otphp/SECURITY.md  Ng  ?	m      %   vendor/spomky-labs/otphp/src/TOTP.php  Ng  >s?      (   vendor/spomky-labs/otphp/src/Factory.php+  Ng+  0$      -   vendor/spomky-labs/otphp/src/OTPInterface.php
  Ng
  zr      .   vendor/spomky-labs/otphp/src/TOTPInterface.php  Ng  *      $   vendor/spomky-labs/otphp/src/OTP.php  Ng  B      %   vendor/spomky-labs/otphp/src/HOTP.php=
  Ng=
  hct      .   vendor/spomky-labs/otphp/src/HOTPInterface.php=  Ng=  ߤ      1   vendor/spomky-labs/otphp/src/FactoryInterface.phpr  Ngr  ¤      /   vendor/spomky-labs/otphp/src/ParameterTrait.php  Ng  da&      $   vendor/spomky-labs/otphp/src/Url.php#
  Ng#
  >쐡      .   vendor/spomky-labs/otphp/src/InternalClock.php5  Ng5  GƤ      $   vendor/doctrine/deprecations/LICENSE)  Ng)  "0      &   vendor/doctrine/deprecations/README.md
  Ng
  {      *   vendor/doctrine/deprecations/composer.json  Ng  x+      ?   vendor/doctrine/deprecations/src/PHPUnit/VerifyDeprecations.php  Ng  V      0   vendor/doctrine/deprecations/src/Deprecation.php$  Ng$  )         vendor/firebase/php-jwt/LICENSE  Ng  #      $   vendor/firebase/php-jwt/CHANGELOG.md'  Ng'  ާ      !   vendor/firebase/php-jwt/README.md4  Ng4        %   vendor/firebase/php-jwt/composer.json  Ng  ܤ      9   vendor/firebase/php-jwt/src/SignatureInvalidException.phpu   Ngu   Ͻ      4   vendor/firebase/php-jwt/src/BeforeValidException.phpt  Ngt  u0      ,   vendor/firebase/php-jwt/src/CachedKeySet.php  Ng   ؤ      #   vendor/firebase/php-jwt/src/Key.php  Ng  lx+      #   vendor/firebase/php-jwt/src/JWK.phpA,  NgA,        @   vendor/firebase/php-jwt/src/JWTExceptionWithPayloadInterface.php  Ng  ky      0   vendor/firebase/php-jwt/src/ExpiredException.phpp  Ngp  7      #   vendor/firebase/php-jwt/src/JWT.php\  Ng\  X
w         vendor/brick/math/LICENSEA  NgA  ݸL         vendor/brick/math/CHANGELOG.mdL  NgL  K/%      $   vendor/brick/math/psalm-baseline.xml	  Ng	           vendor/brick/math/composer.jsonR  NgR  IG      &   vendor/brick/math/src/RoundingMode.php
  Ng
        ;   vendor/brick/math/src/Internal/Calculator/GmpCalculator.php'
  Ng'
  ;0      >   vendor/brick/math/src/Internal/Calculator/BcMathCalculator.php  Ng  ,1      >   vendor/brick/math/src/Internal/Calculator/NativeCalculator.php7  Ng7  #.      -   vendor/brick/math/src/Internal/Calculator.phpI  NgI  }      $   vendor/brick/math/src/BigInteger.php0  Ng0  d2      #   vendor/brick/math/src/BigNumber.php>  Ng>  Eä      $   vendor/brick/math/src/BigDecimal.phpV  NgV  M@Ƥ      1   vendor/brick/math/src/Exception/MathException.php   Ng   E:      9   vendor/brick/math/src/Exception/NumberFormatException.php  Ng  ojQ      ;   vendor/brick/math/src/Exception/NegativeNumberException.php  Ng  +;      ;   vendor/brick/math/src/Exception/DivisionByZeroException.php  Ng  Ɓj      <   vendor/brick/math/src/Exception/IntegerOverflowException.php,  Ng,  1C>*      >   vendor/brick/math/src/Exception/RoundingNecessaryException.php  Ng  A      %   vendor/brick/math/src/BigRational.php.  Ng.  2h      (   vendor/justinrainbow/json-schema/LICENSE   Ng         2   vendor/justinrainbow/json-schema/bin/validate-json  Ng        F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-03.json  Ng  -aߤ      F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-04.json  Ng  Nߤ      *   vendor/justinrainbow/json-schema/README.mdz  Ngz  ˱      .   vendor/justinrainbow/json-schema/composer.json  Ng  7      ;   vendor/justinrainbow/json-schema/src/JsonSchema/Rfc3339.php  Ng  ̤      =   vendor/justinrainbow/json-schema/src/JsonSchema/Validator.php
  Ng
         I   vendor/justinrainbow/json-schema/src/JsonSchema/UriRetrieverInterface.php  Ng  hJ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ObjectConstraint.php{  Ng{  =6      G   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Factory.php  Ng  ߤ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/NumberConstraint.php
  Ng
  Uj      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeConstraint.php  Ng  MY      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/BaseConstraint.php   Ng   ֤      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/EnumConstraint.php  Ng  l$М      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/StringConstraint.php  Ng  ^      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ConstraintInterface.php3  Ng3  9¤      T   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/CollectionConstraint.php  Ng  5q      J   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Constraint.php  Ng  d5      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/FormatConstraint.php.#  Ng.#  '      \   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/TypeCheckInterface.php  Ng  y      Y   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/StrictTypeCheck.php:  Ng:  *9      X   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/LooseTypeCheck.php  Ng  r(      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/UndefinedConstraint.php<  Ng<  U>      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/SchemaConstraint.php!  Ng!        F   vendor/justinrainbow/json-schema/src/JsonSchema/Entity/JsonPointer.php4
  Ng4
        H   vendor/justinrainbow/json-schema/src/JsonSchema/UriResolverInterface.php   Ng   "      K   vendor/justinrainbow/json-schema/src/JsonSchema/Iterator/ObjectIterator.php
  Ng
  hl      A   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorage.php  Ng  Nq      X   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/UriRetrieverInterface.php  Ng  -,      T   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/AbstractRetriever.php  Ng  _Ǥ      G   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/Curl.php  Ng  x(      R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/FileGetContents.php^
  Ng^
        R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/PredefinedArray.php
  Ng
  /8      D   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriRetriever.php$  Ng$  Aq      C   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriResolver.php  Ng  _9<      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ResourceNotFoundException.phpb  Ngb  `      P   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ExceptionInterface.phpX   NgX   [      N   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/RuntimeException.phpo  Ngo  Cr      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSourceUriException.phpj  Ngj  *5      V   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidArgumentException.php  Ng  N      ^   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UnresolvableJsonPointerException.php  Ng  ZHe      Q   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ValidationException.php'  Ng'  Aj      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidConfigException.php_  Ng_  P      S   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/JsonDecodingException.php  Ng  nW      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaException.php\  Ng\  @S6      R   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UriResolverException.phpX  NgX  Ӕ      ]   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaMediaTypeException.phpe  Nge  U3$      J   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorageInterface.php.  Ng.  VԠg      1   vendor/crell/api-problem/docker/php/81/Dockerfile   Ng   D1      1   vendor/crell/api-problem/docker/php/81/xdebug.inil   Ngl   b0      >   vendor/crell/api-problem/docker/php/conf.d/error_reporting.ini   Ng   lc¤      !   vendor/crell/api-problem/Makefile]  Ng]  Zib      *   vendor/crell/api-problem/phpstan.neon.dist0   Ng0   b      +   vendor/crell/api-problem/docker-compose.ymlb  Ngb  Ruv      &   vendor/crell/api-problem/composer.json  Ng  VN+      $   vendor/crell/api-problem/SECURITY.mdw	  Ngw	  _yU      %   vendor/crell/api-problem/default-.env  Ng  ]h	Q      4   vendor/crell/api-problem/src/JsonEncodeException.php   Ng   ewF      .   vendor/crell/api-problem/src/HttpConverter.php6
  Ng6
  1B      3   vendor/crell/api-problem/src/JsonParseException.phpH  NgH  %P(      .   vendor/crell/api-problem/src/JsonException.php  Ng  5-      +   vendor/crell/api-problem/src/ApiProblem.phpdH  NgdH  'M         vendor/psr/cache/CHANGELOG.md  Ng  -	G         vendor/psr/cache/README.md"  Ng"  (AcӤ         vendor/psr/cache/LICENSE.txt8  Ng8  Df         vendor/psr/cache/composer.json4  Ng4  C      /   vendor/psr/cache/src/CacheItemPoolInterface.php  Ng  Y      +   vendor/psr/cache/src/CacheItemInterface.php&  Ng&  =b      1   vendor/psr/cache/src/InvalidArgumentException.php:  Ng:  MY      '   vendor/psr/cache/src/CacheException.php   Ng   BJ      #   vendor/psr/event-dispatcher/LICENSE(  Ng(  }]      %   vendor/psr/event-dispatcher/README.mdE  NgE  S      )   vendor/psr/event-dispatcher/composer.jsonb  Ngb  q      =   vendor/psr/event-dispatcher/src/ListenerProviderInterface.php  Ng  bh      <   vendor/psr/event-dispatcher/src/EventDispatcherInterface.php  Ng        ;   vendor/psr/event-dispatcher/src/StoppableEventInterface.php!  Ng!  T>q         vendor/psr/http-message/LICENSE=  Ng=        $   vendor/psr/http-message/CHANGELOG.md3  Ng3  :\Y      !   vendor/psr/http-message/README.md  Ng        %   vendor/psr/http-message/composer.json  Ng  7      6   vendor/psr/http-message/src/ServerRequestInterface.phpH(  NgH(  #      ,   vendor/psr/http-message/src/UriInterface.php/2  Ng/2  קY      /   vendor/psr/http-message/src/StreamInterface.php  Ng        5   vendor/psr/http-message/src/UploadedFileInterface.php  Ng  	      0   vendor/psr/http-message/src/RequestInterface.phpG  NgG  ir      1   vendor/psr/http-message/src/ResponseInterface.phpZ
  NgZ
  aG      0   vendor/psr/http-message/src/MessageInterface.php  Ng  |C         vendor/psr/container/LICENSEy  Ngy  Op         vendor/psr/container/README.mdB  NgB  g?      "   vendor/psr/container/composer.json  Ng  nY      7   vendor/psr/container/src/NotFoundExceptionInterface.php   Ng   B@      /   vendor/psr/container/src/ContainerInterface.php%  Ng%  )      8   vendor/psr/container/src/ContainerExceptionInterface.php   Ng              vendor/psr/http-client/LICENSE=  Ng=  S      #   vendor/psr/http-client/CHANGELOG.md  Ng  z򪌤          vendor/psr/http-client/README.md%  Ng%  F      $   vendor/psr/http-client/composer.json  Ng  bϤ      8   vendor/psr/http-client/src/NetworkExceptionInterface.php  Ng  6SB      8   vendor/psr/http-client/src/RequestExceptionInterface.phph  Ngh  *c=      .   vendor/psr/http-client/src/ClientInterface.php!  Ng!  {0      7   vendor/psr/http-client/src/ClientExceptionInterface.php   Ng   xz         vendor/psr/log/LICENSE=  Ng=  pO         vendor/psr/log/README.mdB  NgB  '         vendor/psr/log/composer.json`  Ng`  ],      +   vendor/psr/log/src/LoggerAwareInterface.php   Ng   ow         vendor/psr/log/src/LogLevel.phpH  NgH  u      '   vendor/psr/log/src/LoggerAwareTrait.phpj  Ngj  dz      /   vendor/psr/log/src/InvalidArgumentException.phpo   Ngo   MWd      !   vendor/psr/log/src/NullLogger.php  Ng   <      &   vendor/psr/log/src/LoggerInterface.php
  Ng
  c=      "   vendor/psr/log/src/LoggerTrait.php
  Ng
  
      %   vendor/psr/log/src/AbstractLogger.php  Ng  q         vendor/psr/clock/LICENSE8  Ng8  l         vendor/psr/clock/CHANGELOG.md   Ng   <         vendor/psr/clock/README.md  Ng  GL[         vendor/psr/clock/composer.json2  Ng2  $DCM      '   vendor/psr/clock/src/ClockInterface.php   Ng   H%         vendor/psr/http-factory/LICENSE(  Ng(  }]      !   vendor/psr/http-factory/README.md,  Ng,  zwf      %   vendor/psr/http-factory/composer.json8  Ng8        8   vendor/psr/http-factory/src/ResponseFactoryInterface.php2  Ng2  ձ}      6   vendor/psr/http-factory/src/StreamFactoryInterface.php  Ng  e      <   vendor/psr/http-factory/src/UploadedFileFactoryInterface.phpJ  NgJ  nʉ      3   vendor/psr/http-factory/src/UriFactoryInterface.phpU  NgU        =   vendor/psr/http-factory/src/ServerRequestFactoryInterface.php  Ng  w9      7   vendor/psr/http-factory/src/RequestFactoryInterface.php  Ng  4(         vendor/monolog/monolog/LICENSE'  Ng'        #   vendor/monolog/monolog/CHANGELOG.md  Ng  䳑          vendor/monolog/monolog/README.mdA  NgA  o      $   vendor/monolog/monolog/composer.json3
  Ng3
        >   vendor/monolog/monolog/src/Monolog/Handler/SendGridHandler.php  Ng   i      @   vendor/monolog/monolog/src/Monolog/Handler/InsightOpsHandler.php  Ng  &      :   vendor/monolog/monolog/src/Monolog/Handler/TestHandler.php  Ng  )Bs      ;   vendor/monolog/monolog/src/Monolog/Handler/IFTTTHandler.php  Ng  ps      H   vendor/monolog/monolog/src/Monolog/Handler/WebRequestRecognizerTrait.php  Ng  cJ      <   vendor/monolog/monolog/src/Monolog/Handler/SocketHandler.phpY/  NgY/  q]      C   vendor/monolog/monolog/src/Monolog/Handler/SymfonyMailerHandler.phpJ  NgJ  H      :   vendor/monolog/monolog/src/Monolog/Handler/NoopHandler.php  Ng  :      <   vendor/monolog/monolog/src/Monolog/Handler/BufferHandler.php	  Ng	  7q      <   vendor/monolog/monolog/src/Monolog/Handler/SyslogHandler.php  Ng  ~      =   vendor/monolog/monolog/src/Monolog/Handler/RollbarHandler.php
  Ng
  kVʤ      D   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.phpz   Ngz   U6X      >   vendor/monolog/monolog/src/Monolog/Handler/OverflowHandler.php  Ng  8      =   vendor/monolog/monolog/src/Monolog/Handler/HandlerWrapper.phpO
  NgO
        Y   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php  Ng  z.      Z   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.php  Ng         \   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ChannelLevelActivationStrategy.php	  Ng	  ;Ӥ      ;   vendor/monolog/monolog/src/Monolog/Handler/GroupHandler.php  Ng  Y      C   vendor/monolog/monolog/src/Monolog/Handler/ElasticsearchHandler.php  Ng         >   vendor/monolog/monolog/src/Monolog/Handler/SamplingHandler.phpz  Ngz  E^      6   vendor/monolog/monolog/src/Monolog/Handler/Handler.php  Ng  |      >   vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php
  Ng
  7m      >   vendor/monolog/monolog/src/Monolog/Handler/FlowdockHandler.phpG
  NgG
  
B      >   vendor/monolog/monolog/src/Monolog/Handler/PushoverHandler.phpJ  NgJ  1      J   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php  Ng  'W      H   vendor/monolog/monolog/src/Monolog/Handler/MissingExtensionException.php  Ng   
l      D   vendor/monolog/monolog/src/Monolog/Handler/AbstractSyslogHandler.php  Ng  
$      ?   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdpHandler.php4  Ng4        D   vendor/monolog/monolog/src/Monolog/Handler/BrowserConsoleHandler.php$  Ng$   Aߤ      <   vendor/monolog/monolog/src/Monolog/Handler/FilterHandler.php  Ng        9   vendor/monolog/monolog/src/Monolog/Handler/SqsHandler.php  Ng  -
M      B   vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php>  Ng>  ^n      C   vendor/monolog/monolog/src/Monolog/Handler/FallbackGroupHandler.php  Ng  <      B   vendor/monolog/monolog/src/Monolog/Handler/NativeMailerHandler.php  Ng  }      =   vendor/monolog/monolog/src/Monolog/Handler/MongoDBHandler.php	  Ng	  nD      =   vendor/monolog/monolog/src/Monolog/Handler/ProcessHandler.phpU  NgU  ٤      F   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php  Ng  N'x~      :   vendor/monolog/monolog/src/Monolog/Handler/GelfHandler.php  Ng  ca      A   vendor/monolog/monolog/src/Monolog/Handler/ZendMonitorHandler.php  Ng        @   vendor/monolog/monolog/src/Monolog/Handler/PHPConsoleHandler.phpQ0  NgQ0  v֤      >   vendor/monolog/monolog/src/Monolog/Handler/ErrorLogHandler.php
  Ng
  nXk      @   vendor/monolog/monolog/src/Monolog/Handler/LogEntriesHandler.php  Ng  D      >   vendor/monolog/monolog/src/Monolog/Handler/LogmaticHandler.php	  Ng	  go      C   vendor/monolog/monolog/src/Monolog/Handler/DeduplicationHandler.phpY  NgY  h      =   vendor/monolog/monolog/src/Monolog/Handler/FirePHPHandler.php  Ng        8   vendor/monolog/monolog/src/Monolog/Handler/Curl/Util.php  Ng  ɤ      E   vendor/monolog/monolog/src/Monolog/Handler/DoctrineCouchDBHandler.php  Ng  O!֤      >   vendor/monolog/monolog/src/Monolog/Handler/DynamoDbHandler.php  Ng  %Tg      J   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php  Ng        A   vendor/monolog/monolog/src/Monolog/Handler/RedisPubSubHandler.php  Ng  ޤ      :   vendor/monolog/monolog/src/Monolog/Handler/MailHandler.php  Ng  Nv      <   vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php5   Ng5   EW      <   vendor/monolog/monolog/src/Monolog/Handler/LogglyHandler.phpa  Nga  Ӥ      B   vendor/monolog/monolog/src/Monolog/Handler/SlackWebhookHandler.php  Ng  Kdﮤ      >   vendor/monolog/monolog/src/Monolog/Handler/ElasticaHandler.php  Ng        F   vendor/monolog/monolog/src/Monolog/Handler/WhatFailureGroupHandler.php  Ng  f      ?   vendor/monolog/monolog/src/Monolog/Handler/ChromePHPHandler.php/  Ng/  m      @   vendor/monolog/monolog/src/Monolog/Handler/Slack/SlackRecord.php'  Ng'        9   vendor/monolog/monolog/src/Monolog/Handler/PsrHandler.php	  Ng	  |cU      >   vendor/monolog/monolog/src/Monolog/Handler/NewRelicHandler.php)  Ng)  ̤      F   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php  Ng  PK      ?   vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php
  Ng
  2      ;   vendor/monolog/monolog/src/Monolog/Handler/SlackHandler.php  Ng  '      ?   vendor/monolog/monolog/src/Monolog/Handler/FleepHookHandler.phpI
  NgI
   T      :   vendor/monolog/monolog/src/Monolog/Handler/NullHandler.php|  Ng|  Wb      :   vendor/monolog/monolog/src/Monolog/Handler/AmqpHandler.php%  Ng%  paĤ      A   vendor/monolog/monolog/src/Monolog/Handler/TelegramBotHandler.php$  Ng$  39      >   vendor/monolog/monolog/src/Monolog/Handler/MandrillHandler.php
  Ng
  \+w      H   vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php  Ng  cl      =   vendor/monolog/monolog/src/Monolog/Handler/CouchDBHandler.php	  Ng	  (ٌ      ;   vendor/monolog/monolog/src/Monolog/Handler/RedisHandler.php
  Ng
        :   vendor/monolog/monolog/src/Monolog/Handler/CubeHandler.phpF  NgF  !fB      B   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp/UdpSocket.php  Ng  bH      H   vendor/monolog/monolog/src/Monolog/JsonSerializableDateTimeImmutable.php  Ng  kܤ      -   vendor/monolog/monolog/src/Monolog/Logger.php;Y  Ng;Y  {      C   vendor/monolog/monolog/src/Monolog/Attribute/AsMonologProcessor.php  Ng  b      C   vendor/monolog/monolog/src/Monolog/Attribute/WithMonologChannel.php  Ng  GL      8   vendor/monolog/monolog/src/Monolog/DateTimeImmutable.phph  Ngh  x\G      4   vendor/monolog/monolog/src/Monolog/Test/TestCase.php  Ng  Fԧc      /   vendor/monolog/monolog/src/Monolog/Registry.php  Ng  =      B   vendor/monolog/monolog/src/Monolog/Processor/HostnameProcessor.php  Ng  	'1      G   vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.phpI  NgI        =   vendor/monolog/monolog/src/Monolog/Processor/WebProcessor.phpU
  NgU
  8      I   vendor/monolog/monolog/src/Monolog/Processor/MemoryPeakUsageProcessor.php|  Ng|  _`x      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessIdProcessor.php  Ng  +@      E   vendor/monolog/monolog/src/Monolog/Processor/LoadAverageProcessor.php\  Ng\  s      H   vendor/monolog/monolog/src/Monolog/Processor/ClosureContextProcessor.php  Ng  :Eg      C   vendor/monolog/monolog/src/Monolog/Processor/MercurialProcessor.php  Ng  O      =   vendor/monolog/monolog/src/Monolog/Processor/TagProcessor.php  Ng  G?o      =   vendor/monolog/monolog/src/Monolog/Processor/GitProcessor.php  Ng  \@      @   vendor/monolog/monolog/src/Monolog/Processor/MemoryProcessor.php  Ng  )      G   vendor/monolog/monolog/src/Monolog/Processor/IntrospectionProcessor.php\  Ng\  h      =   vendor/monolog/monolog/src/Monolog/Processor/UidProcessor.php  Ng  Hz      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php]  Ng]  l(      E   vendor/monolog/monolog/src/Monolog/Processor/MemoryUsageProcessor.phpi  Ngi  3;w      :   vendor/monolog/monolog/src/Monolog/ResettableInterface.php  Ng  Z̤      4   vendor/monolog/monolog/src/Monolog/SignalHandler.phpZ  NgZ  N      ,   vendor/monolog/monolog/src/Monolog/Level.php  Ng  c#      B   vendor/monolog/monolog/src/Monolog/Formatter/LogmaticFormatter.php;  Ng;  
ؤ      B   vendor/monolog/monolog/src/Monolog/Formatter/ElasticaFormatter.php  Ng  e      >   vendor/monolog/monolog/src/Monolog/Formatter/LineFormatter.php&  Ng&  D;      >   vendor/monolog/monolog/src/Monolog/Formatter/JsonFormatter.phpm  Ngm  l S      B   vendor/monolog/monolog/src/Monolog/Formatter/FlowdockFormatter.phpC	  NgC	  mӼ      C   vendor/monolog/monolog/src/Monolog/Formatter/FormatterInterface.php  Ng  ̍Q      B   vendor/monolog/monolog/src/Monolog/Formatter/LogstashFormatter.phpQ
  NgQ
  n@      @   vendor/monolog/monolog/src/Monolog/Formatter/LogglyFormatter.php  Ng  א      G   vendor/monolog/monolog/src/Monolog/Formatter/ElasticsearchFormatter.phpI  NgI  4      @   vendor/monolog/monolog/src/Monolog/Formatter/ScalarFormatter.php  Ng  Pa      A   vendor/monolog/monolog/src/Monolog/Formatter/MongoDBFormatter.php  Ng  դ      C   vendor/monolog/monolog/src/Monolog/Formatter/ChromePHPFormatter.php  Ng        A   vendor/monolog/monolog/src/Monolog/Formatter/FluentdFormatter.php  Ng  (QG      E   vendor/monolog/monolog/src/Monolog/Formatter/GelfMessageFormatter.phpO  NgO  H      B   vendor/monolog/monolog/src/Monolog/Formatter/WildfireFormatter.php  Ng  :      L   vendor/monolog/monolog/src/Monolog/Formatter/GoogleCloudLoggingFormatter.php  Ng        @   vendor/monolog/monolog/src/Monolog/Formatter/SyslogFormatter.php  Ng  氂      D   vendor/monolog/monolog/src/Monolog/Formatter/NormalizerFormatter.php'  Ng'  6xq      >   vendor/monolog/monolog/src/Monolog/Formatter/HtmlFormatter.php  Ng  x       0   vendor/monolog/monolog/src/Monolog/LogRecord.php
  Ng
  
      3   vendor/monolog/monolog/src/Monolog/ErrorHandler.php'  Ng'  4_      ,   vendor/monolog/monolog/src/Monolog/Utils.phpr"  Ngr"  c      !   vendor/studio24/rotate/LICENSE.md>  Ng>  3ä      "   vendor/studio24/rotate/phpunit.xml   Ng   gE          vendor/studio24/rotate/README.md  Ng  ?/      $   vendor/studio24/rotate/composer.json  Ng  WѤ      .   vendor/studio24/rotate/src/RotateException.php_   Ng_    ;      %   vendor/studio24/rotate/src/Rotate.php#  Ng#  j      -   vendor/studio24/rotate/src/FilenameFormat.php  Ng  =D      -   vendor/studio24/rotate/src/RotateAbstract.php  Ng  D      6   vendor/studio24/rotate/src/FilenameFormatException.phpg   Ngg   ܙ      %   vendor/studio24/rotate/src/Delete.php|#  Ng|#  ؤ      0   vendor/studio24/rotate/src/DirectoryIterator.phpk  Ngk  mA      G   vendor/symfony/framework-bundle/DataCollector/AbstractDataCollector.php  Ng  xϤ      E   vendor/symfony/framework-bundle/DataCollector/RouterDataCollector.phpD  NgD  }      U   vendor/symfony/framework-bundle/DataCollector/TemplateAwareDataCollectorInterface.phpU  NgU  ~suܤ      '   vendor/symfony/framework-bundle/LICENSE,  Ng,  U      7   vendor/symfony/framework-bundle/Test/KernelTestCase.phpA  NgA  R      B   vendor/symfony/framework-bundle/Test/DomCrawlerAssertionsTrait.php  Ng  3      >   vendor/symfony/framework-bundle/Test/MailerAssertionsTrait.phpe  Nge  }w      D   vendor/symfony/framework-bundle/Test/NotificationAssertionsTrait.php$  Ng$  E      B   vendor/symfony/framework-bundle/Test/HttpClientAssertionsTrait.php  Ng  7      B   vendor/symfony/framework-bundle/Test/BrowserKitAssertionsTrait.php!  Ng!  탤      9   vendor/symfony/framework-bundle/Test/TestBrowserToken.php  Ng  ¾      4   vendor/symfony/framework-bundle/Test/WebTestCase.php  Ng  5      ?   vendor/symfony/framework-bundle/Test/WebTestAssertionsTrait.php  Ng  *      6   vendor/symfony/framework-bundle/Test/TestContainer.phpP  NgP  Ԕq      ,   vendor/symfony/framework-bundle/CHANGELOG.md  Ng  ķ      :   vendor/symfony/framework-bundle/Translation/Translator.phpR  NgR  
H      7   vendor/symfony/framework-bundle/Secrets/SodiumVault.phpK#  NgK#  ?/      7   vendor/symfony/framework-bundle/Secrets/DotenvVault.php8  Ng8  U:      9   vendor/symfony/framework-bundle/Secrets/AbstractVault.php  Ng  ~p      I   vendor/symfony/framework-bundle/Resources/bin/check-unused-known-tags.php  Ng  1      A   vendor/symfony/framework-bundle/Resources/config/asset_mapper.php$  Ng$  O)      8   vendor/symfony/framework-bundle/Resources/config/esi.php  Ng        @   vendor/symfony/framework-bundle/Resources/config/translation.phpM   NgM   Tפ      ?   vendor/symfony/framework-bundle/Resources/config/serializer.phpy'  Ngy'  PF      ?   vendor/symfony/framework-bundle/Resources/config/form_debug.php  Ng  "      >   vendor/symfony/framework-bundle/Resources/config/validator.php  Ng  iL6Ǥ      >   vendor/symfony/framework-bundle/Resources/config/semaphore.php  Ng  4.      @   vendor/symfony/framework-bundle/Resources/config/annotations.php
  Ng
  ݋\      >   vendor/symfony/framework-bundle/Resources/config/profiling.php=  Ng=  +      ;   vendor/symfony/framework-bundle/Resources/config/mailer.phpC
  NgC
  l      F   vendor/symfony/framework-bundle/Resources/config/fragment_listener.phpw  Ngw  Vg      F   vendor/symfony/framework-bundle/Resources/config/translation_debug.php  Ng  $      C   vendor/symfony/framework-bundle/Resources/config/notifier_debug.php  Ng  w0      A   vendor/symfony/framework-bundle/Resources/config/rate_limiter.php  Ng  |s      9   vendor/symfony/framework-bundle/Resources/config/lock.php  Ng  z      H   vendor/symfony/framework-bundle/Resources/config/identity_translator.php  Ng  W      @   vendor/symfony/framework-bundle/Resources/config/http_client.phpx
  Ngx
  ^?Ϥ      A   vendor/symfony/framework-bundle/Resources/config/mailer_debug.php  Ng  `܄       =   vendor/symfony/framework-bundle/Resources/config/services.php]#  Ng]#  k      :   vendor/symfony/framework-bundle/Resources/config/cache.php"  Ng"  -l7      <   vendor/symfony/framework-bundle/Resources/config/session.php  Ng  wr      F   vendor/symfony/framework-bundle/Resources/config/mailer_transports.php  Ng  i?
      J   vendor/symfony/framework-bundle/Resources/config/translation_providers.php	  Ng	  ?H      :   vendor/symfony/framework-bundle/Resources/config/debug.php  Ng  L_      E   vendor/symfony/framework-bundle/Resources/config/notifier_webhook.php  Ng  ,      F   vendor/symfony/framework-bundle/Resources/config/fragment_renderer.php	  Ng	         =   vendor/symfony/framework-bundle/Resources/config/web_link.phpZ  NgZ  Oj      <   vendor/symfony/framework-bundle/Resources/config/routing.php  Ng  A      G   vendor/symfony/framework-bundle/Resources/config/schema/symfony-1.0.xsdg  Ngg  #`R      =   vendor/symfony/framework-bundle/Resources/config/notifier.php  Ng  Ec      F   vendor/symfony/framework-bundle/Resources/config/http_client_debug.php  Ng  "5$      <   vendor/symfony/framework-bundle/Resources/config/request.php  Ng  kP?      9   vendor/symfony/framework-bundle/Resources/config/test.php  Ng        <   vendor/symfony/framework-bundle/Resources/config/webhook.php  Ng  P쌤      D   vendor/symfony/framework-bundle/Resources/config/validator_debug.php  Ng  GU      C   vendor/symfony/framework-bundle/Resources/config/error_renderer.php/  Ng/        >   vendor/symfony/framework-bundle/Resources/config/mime_type.php  Ng  H̤      >   vendor/symfony/framework-bundle/Resources/config/messenger.php?#  Ng?#  Y      <   vendor/symfony/framework-bundle/Resources/config/console.php3  Ng3  uҤ      8   vendor/symfony/framework-bundle/Resources/config/uid.php=  Ng=  S      B   vendor/symfony/framework-bundle/Resources/config/property_info.php	  Ng	  j      >   vendor/symfony/framework-bundle/Resources/config/scheduler.php  Ng  1@w      8   vendor/symfony/framework-bundle/Resources/config/ssi.php  Ng  5{      8   vendor/symfony/framework-bundle/Resources/config/web.php  Ng  k?֓      D   vendor/symfony/framework-bundle/Resources/config/messenger_debug.php  Ng  o灤      ?   vendor/symfony/framework-bundle/Resources/config/collectors.phpq  Ngq  %(      C   vendor/symfony/framework-bundle/Resources/config/routing/errors.xml  Ng  >      D   vendor/symfony/framework-bundle/Resources/config/routing/webhook.xml  Ng  Vc      C   vendor/symfony/framework-bundle/Resources/config/html_sanitizer.php  Ng  Pդ      <   vendor/symfony/framework-bundle/Resources/config/secrets.php  Ng  *n      9   vendor/symfony/framework-bundle/Resources/config/form.php  Ng  m17      E   vendor/symfony/framework-bundle/Resources/config/serializer_debug.php  Ng        C   vendor/symfony/framework-bundle/Resources/config/workflow_debug.php  Ng  RRT      C   vendor/symfony/framework-bundle/Resources/config/mailer_webhook.php
  Ng
  dea      >   vendor/symfony/framework-bundle/Resources/config/form_csrf.phpD  NgD  A3U      =   vendor/symfony/framework-bundle/Resources/config/workflow.php  Ng  #m7Y      B   vendor/symfony/framework-bundle/Resources/config/security_csrf.php  Ng  ~ܤ      H   vendor/symfony/framework-bundle/Resources/config/notifier_transports.php^3  Ng^3  |      ?   vendor/symfony/framework-bundle/Resources/config/debug_prod.php  Ng  _Q      D   vendor/symfony/framework-bundle/Resources/config/property_access.php  Ng  Bʤ      ;   vendor/symfony/framework-bundle/Resources/config/assets.php  Ng  v'      @   vendor/symfony/framework-bundle/Resources/config/cache_debug.php  Ng  %]      A   vendor/symfony/framework-bundle/Resources/config/remote_event.php  Ng  
ä      <   vendor/symfony/framework-bundle/Resources/config/process.phpc  Ngc        1   vendor/symfony/framework-bundle/KernelBrowser.php  Ng        D   vendor/symfony/framework-bundle/CacheWarmer/ValidatorCacheWarmer.php^
  Ng^
  hr      H   vendor/symfony/framework-bundle/CacheWarmer/ConfigBuilderCacheWarmer.phpc  Ngc  gp      J   vendor/symfony/framework-bundle/CacheWarmer/AbstractPhpFileCacheWarmer.php
  Ng
  $bΤ      A   vendor/symfony/framework-bundle/CacheWarmer/RouterCacheWarmer.php  Ng  )      G   vendor/symfony/framework-bundle/CacheWarmer/TranslationsCacheWarmer.php  Ng  2e      E   vendor/symfony/framework-bundle/CacheWarmer/SerializerCacheWarmer.php  Ng  ^M      K   vendor/symfony/framework-bundle/CacheWarmer/CachePoolClearerCacheWarmer.php  Ng  ҧ      F   vendor/symfony/framework-bundle/CacheWarmer/AnnotationsCacheWarmer.php  Ng  l      A   vendor/symfony/framework-bundle/Controller/AbstractController.phpH  NgH        A   vendor/symfony/framework-bundle/Controller/TemplateController.php	  Ng	  k      A   vendor/symfony/framework-bundle/Controller/ControllerResolver.php3  Ng3  0      A   vendor/symfony/framework-bundle/Controller/RedirectController.php  Ng  HǤ      )   vendor/symfony/framework-bundle/README.md!  Ng!  q      7   vendor/symfony/framework-bundle/HttpCache/HttpCache.php
  Ng
  R      3   vendor/symfony/framework-bundle/FrameworkBundle.php3  Ng3  ب       >   vendor/symfony/framework-bundle/Command/SecretsListCommand.php
  Ng
  cc4      J   vendor/symfony/framework-bundle/Command/CachePoolInvalidateTagsCommand.phpK  NgK  ,ؤ      @   vendor/symfony/framework-bundle/Command/SecretsRemoveCommand.phpw
  Ngw
  A      =   vendor/symfony/framework-bundle/Command/CacheClearCommand.php(  Ng(  ~      <   vendor/symfony/framework-bundle/Command/XliffLintCommand.php  Ng  vtc      H   vendor/symfony/framework-bundle/Command/SecretsDecryptToLocalCommand.php
  Ng
        A   vendor/symfony/framework-bundle/Command/AbstractConfigCommand.phpi  Ngi  VP      >   vendor/symfony/framework-bundle/Command/RouterDebugCommand.php  Ng  s`i      D   vendor/symfony/framework-bundle/Command/TranslationUpdateCommand.php{D  Ng{D  R      F   vendor/symfony/framework-bundle/Command/ConfigDumpReferenceCommand.php8  Ng8  !      @   vendor/symfony/framework-bundle/Command/AssetsInstallCommand.php'  Ng'  ]3%      A   vendor/symfony/framework-bundle/Command/CachePoolPruneCommand.php  Ng  ~T}      A   vendor/symfony/framework-bundle/Command/CachePoolClearCommand.php  Ng  ZQ~      @   vendor/symfony/framework-bundle/Command/ContainerLintCommand.php\  Ng\  ]6      J   vendor/symfony/framework-bundle/Command/SecretsEncryptFromLocalCommand.php1	  Ng1	  dƃ|      B   vendor/symfony/framework-bundle/Command/DebugAutowiringCommand.php  Ng  \      >   vendor/symfony/framework-bundle/Command/CacheWarmupCommand.php  Ng  :5Τ      ?   vendor/symfony/framework-bundle/Command/WorkflowDumpCommand.phpD  NgD  &      G   vendor/symfony/framework-bundle/Command/EventDispatcherDebugCommand.php  Ng   ّY      A   vendor/symfony/framework-bundle/Command/ContainerDebugCommand.phps<  Ngs<  _ q      C   vendor/symfony/framework-bundle/Command/TranslationDebugCommand.phpa<  Nga<  1g      ;   vendor/symfony/framework-bundle/Command/YamlLintCommand.phpA  NgA  Fs      @   vendor/symfony/framework-bundle/Command/CachePoolListCommand.php  Ng  ;q      F   vendor/symfony/framework-bundle/Command/SecretsGenerateKeysCommand.php  Ng  ֤      B   vendor/symfony/framework-bundle/Command/CachePoolDeleteCommand.php  Ng  yUɤ      D   vendor/symfony/framework-bundle/Command/BuildDebugContainerTrait.php
  Ng
  ҥ      8   vendor/symfony/framework-bundle/Command/AboutCommand.php  Ng  n٤      >   vendor/symfony/framework-bundle/Command/RouterMatchCommand.php7  Ng7  }S      =   vendor/symfony/framework-bundle/Command/SecretsSetCommand.php:  Ng:        >   vendor/symfony/framework-bundle/Command/ConfigDebugCommand.php4)  Ng4)  E^%      J   vendor/symfony/framework-bundle/Routing/RedirectableCompiledUrlMatcher.php!  Ng!  )\      J   vendor/symfony/framework-bundle/Routing/AttributeRouteControllerLoader.php  Ng  v1)      O   vendor/symfony/framework-bundle/Routing/Attribute/AsRoutingConditionService.php  Ng  ny      @   vendor/symfony/framework-bundle/Routing/RouteLoaderInterface.php  Ng  b       2   vendor/symfony/framework-bundle/Routing/Router.php  Ng  ~Un      <   vendor/symfony/framework-bundle/Routing/DelegatingLoader.php
  Ng
  դ      J   vendor/symfony/framework-bundle/Routing/AnnotatedRouteControllerLoader.php
  Ng
  y,      E   vendor/symfony/framework-bundle/DependencyInjection/Configuration.php<A Ng<A       J   vendor/symfony/framework-bundle/DependencyInjection/FrameworkExtension.php Ng &      O   vendor/symfony/framework-bundle/DependencyInjection/VirtualRequestStackPass.php  Ng  
w      ^   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ContainerBuilderDebugDumpPass.phpS  NgS  n>.      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerRealRefPass.php	  Ng	  j(v      c   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.phpW  NgW  W*ͤ      O   vendor/symfony/framework-bundle/DependencyInjection/Compiler/UnusedTagsPass.phpt  Ngt  b"      R   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AssetsContextPass.php  Ng  o      X   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ErrorLoggerCompilerPass.php  Ng  9/      ]   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TranslationUpdateCommandPass.php  Ng        Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/WorkflowGuardListenerPass.php#  Ng#  ,      Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/EnableLoggerDebugModePass.php  Ng  }V      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerWeakRefPass.php@	  Ng@	  y`1      V   vendor/symfony/framework-bundle/DependencyInjection/Compiler/LoggingTranslatorPass.phpY  NgY  Nx      \   vendor/symfony/framework-bundle/DependencyInjection/Compiler/DataCollectorTranslatorPass.phpV  NgV  0#      _   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddAnnotationsCachedReaderPass.php  Ng  ~Y      M   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ProfilerPass.php	  Ng	  &1      j   vendor/symfony/framework-bundle/DependencyInjection/Compiler/RemoveUnusedSessionMarshallingHandlerPass.php   Ng   k)̤      Y   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddDebugLogProcessorPass.php  Ng  `:W      -   vendor/symfony/framework-bundle/composer.json  Ng  cFD
      ;   vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.phpd   Ngd   ٟO      7   vendor/symfony/framework-bundle/Console/Application.phpE   NgE   '23      E   vendor/symfony/framework-bundle/Console/Descriptor/TextDescriptor.phpm  Ngm  JL      D   vendor/symfony/framework-bundle/Console/Descriptor/XmlDescriptor.phpj  Ngj  ksnU      A   vendor/symfony/framework-bundle/Console/Descriptor/Descriptor.php6  Ng6        E   vendor/symfony/framework-bundle/Console/Descriptor/JsonDescriptor.phpD  NgD  vF      I   vendor/symfony/framework-bundle/Console/Descriptor/MarkdownDescriptor.php8I  Ng8I  h      C   vendor/symfony/framework-bundle/Console/Helper/DescriptorHelper.php  Ng  *      I   vendor/symfony/framework-bundle/EventListener/ConsoleProfilerListener.php  Ng  c      Q   vendor/symfony/framework-bundle/EventListener/SuggestMissingPackageSubscriber.php	  Ng	  Su      %   vendor/symfony/monolog-bundle/LICENSE)  Ng)  Ǥ      *   vendor/symfony/monolog-bundle/CHANGELOG.md  Ng  :L      :   vendor/symfony/monolog-bundle/Resources/config/monolog.xml.  Ng.   0yK      E   vendor/symfony/monolog-bundle/Resources/config/schema/monolog-1.0.xsd'  Ng'  )X      <   vendor/symfony/monolog-bundle/SwiftMailer/MessageFactory.php  Ng        '   vendor/symfony/monolog-bundle/README.mdY  NgY        /   vendor/symfony/monolog-bundle/MonologBundle.php  Ng  @g      F   vendor/symfony/monolog-bundle/DependencyInjection/MonologExtension.phpi  Ngi  ve      C   vendor/symfony/monolog-bundle/DependencyInjection/Configuration.php  Ng  vr      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddProcessorsPass.php  Ng  R      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/LoggerChannelPass.php  Ng        O   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/DebugHandlerPass.php
  Ng
  HS      Q   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/FixEmptyLoggerPass.php  Ng  DN      Z   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddSwiftMailerTransportPass.php  Ng   *Q      +   vendor/symfony/monolog-bundle/composer.json  Ng  Ǉ      %   vendor/symfony/polyfill-php73/LICENSE,  Ng,        '   vendor/symfony/polyfill-php73/Php73.phps  Ngs  D\      ?   vendor/symfony/polyfill-php73/Resources/stubs/JsonException.phpE  NgE  8S      +   vendor/symfony/polyfill-php73/bootstrap.php  Ng  |      '   vendor/symfony/polyfill-php73/README.md/  Ng/  m      +   vendor/symfony/polyfill-php73/composer.json  Ng  t      C   vendor/symfony/serializer/DataCollector/SerializerDataCollector.php?  Ng?  8      (   vendor/symfony/serializer/Serializer.phpG  NgG  =у      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.phpu
  Ngu
  5      <   vendor/symfony/serializer/Mapping/ClassMetadataInterface.php3  Ng3  闙      3   vendor/symfony/serializer/Mapping/ClassMetadata.phpV
  NgV
  ŏ=      <   vendor/symfony/serializer/Mapping/Loader/AttributeLoader.php+5  Ng+5  y      7   vendor/symfony/serializer/Mapping/Loader/FileLoader.phpF  NgF  hդ      <   vendor/symfony/serializer/Mapping/Loader/LoaderInterface.phpY  NgY  
lޤ      ;   vendor/symfony/serializer/Mapping/Loader/YamlFileLoader.php  Ng  rF      a   vendor/symfony/serializer/Mapping/Loader/schema/dic/serializer-mapping/serializer-mapping-1.0.xsd  Ng  7      :   vendor/symfony/serializer/Mapping/Loader/XmlFileLoader.php  Ng  W      8   vendor/symfony/serializer/Mapping/Loader/LoaderChain.php  Ng  S*      =   vendor/symfony/serializer/Mapping/Loader/AnnotationLoader.php  Ng  a      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php  Ng  2      @   vendor/symfony/serializer/Mapping/AttributeMetadataInterface.php  Ng  v5      ?   vendor/symfony/serializer/Mapping/ClassDiscriminatorMapping.php  Ng  2q      J   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryCompiler.phpp  Ngp  A
      @   vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php+  Ng+  u鏤      B   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php  Ng  5      G   vendor/symfony/serializer/Mapping/Factory/CacheClassMetadataFactory.php  Ng        J   vendor/symfony/serializer/Mapping/Factory/CompiledClassMetadataFactory.php7  Ng7  @IP      K   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php  Ng  /      7   vendor/symfony/serializer/Mapping/AttributeMetadata.php  Ng  j\      1   vendor/symfony/serializer/SerializerInterface.php}  Ng}  wp      F   vendor/symfony/serializer/Context/Encoder/CsvEncoderContextBuilder.php  Ng  H      F   vendor/symfony/serializer/Context/Encoder/XmlEncoderContextBuilder.php_  Ng_  gdr      G   vendor/symfony/serializer/Context/Encoder/YamlEncoderContextBuilder.php  Ng  \      G   vendor/symfony/serializer/Context/Encoder/JsonEncoderContextBuilder.php  Ng  8      9   vendor/symfony/serializer/Context/ContextBuilderTrait.php  Ng  W6      >   vendor/symfony/serializer/Context/SerializerContextBuilder.php  Ng  ޵R      =   vendor/symfony/serializer/Context/ContextBuilderInterface.php  Ng  n
      O   vendor/symfony/serializer/Context/Normalizer/ObjectNormalizerContextBuilder.php#  Ng#  D      Q   vendor/symfony/serializer/Context/Normalizer/DateTimeNormalizerContextBuilder.php  Ng  ,P      R   vendor/symfony/serializer/Context/Normalizer/FormErrorNormalizerContextBuilder.php  Ng  sڤ      U   vendor/symfony/serializer/Context/Normalizer/GetSetMethodNormalizerContextBuilder.php/  Ng/  gB      Y   vendor/symfony/serializer/Context/Normalizer/JsonSerializableNormalizerContextBuilder.php1  Ng1  z      P   vendor/symfony/serializer/Context/Normalizer/ProblemNormalizerContextBuilder.php  Ng  \oq      W   vendor/symfony/serializer/Context/Normalizer/AbstractObjectNormalizerContextBuilder.phpQ  NgQ  2      S   vendor/symfony/serializer/Context/Normalizer/BackedEnumNormalizerContextBuilder.phpg  Ngg  S      `   vendor/symfony/serializer/Context/Normalizer/ConstraintViolationListNormalizerContextBuilder.php7  Ng7  gO      U   vendor/symfony/serializer/Context/Normalizer/UnwrappingDenormalizerContextBuilder.php!  Ng!  t;9      Q   vendor/symfony/serializer/Context/Normalizer/AbstractNormalizerContextBuilder.php  Ng  r㽤      L   vendor/symfony/serializer/Context/Normalizer/UidNormalizerContextBuilder.php  Ng  B4      Q   vendor/symfony/serializer/Context/Normalizer/PropertyNormalizerContextBuilder.php  Ng  8      U   vendor/symfony/serializer/Context/Normalizer/DateIntervalNormalizerContextBuilder.phpB  NgB  Ѥ      6   vendor/symfony/serializer/Attribute/SerializedName.php  Ng  pl      .   vendor/symfony/serializer/Attribute/Ignore.php  Ng        /   vendor/symfony/serializer/Attribute/Context.php	  Ng	  Oq'      8   vendor/symfony/serializer/Attribute/DiscriminatorMap.php  Ng  Ӥ      6   vendor/symfony/serializer/Attribute/SerializedPath.php  Ng  <      0   vendor/symfony/serializer/Attribute/MaxDepth.php  Ng  [v      .   vendor/symfony/serializer/Attribute/Groups.php  Ng  !x
      !   vendor/symfony/serializer/LICENSE,  Ng,  U      &   vendor/symfony/serializer/CHANGELOG.md6<  Ng6<  qSx      0   vendor/symfony/serializer/Encoder/CsvEncoder.php&  Ng&  .B5&      B   vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php  Ng  o׍      2   vendor/symfony/serializer/Encoder/ChainEncoder.phpg  Ngg  A0      6   vendor/symfony/serializer/Encoder/DecoderInterface.php/  Ng/  
      B   vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php  Ng  Q{N      A   vendor/symfony/serializer/Encoder/NormalizationAwareInterface.phpv  Ngv  
/g      6   vendor/symfony/serializer/Encoder/EncoderInterface.php  Ng  _J      2   vendor/symfony/serializer/Encoder/ChainDecoder.php  Ng  }[      0   vendor/symfony/serializer/Encoder/JsonEncode.php  Ng  ۤ      1   vendor/symfony/serializer/Encoder/JsonEncoder.php  Ng  w      0   vendor/symfony/serializer/Encoder/JsonDecode.php<  Ng<  Dh$      1   vendor/symfony/serializer/Encoder/YamlEncoder.phpq
  Ngq
  !y]      0   vendor/symfony/serializer/Encoder/XmlEncoder.phpH  NgH  pbR      J   vendor/symfony/serializer/CacheWarmer/CompiledClassMetadataCacheWarmer.php7  Ng7  Ƭc      7   vendor/symfony/serializer/Annotation/SerializedName.php[  Ng[  PR      /   vendor/symfony/serializer/Annotation/Ignore.phpC  NgC  𽩤      0   vendor/symfony/serializer/Annotation/Context.php  Ng  ;i*      9   vendor/symfony/serializer/Annotation/DiscriminatorMap.phpB  NgB  R?      7   vendor/symfony/serializer/Annotation/SerializedPath.php[  Ng[  ޢ6X      1   vendor/symfony/serializer/Annotation/MaxDepth.phpI  NgI  BY      /   vendor/symfony/serializer/Annotation/Groups.php^  Ng^  wLN      L   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractorInterface.php^  Ng^  $7      C   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractor.php{  Ng{  E      6   vendor/symfony/serializer/SerializerAwareInterface.php  Ng  M      #   vendor/symfony/serializer/README.mdJ  NgJ  Mc%      B   vendor/symfony/serializer/NameConverter/NameConverterInterface.php  Ng  pvEq      J   vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php  Ng  6      F   vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php  Ng  .]      M   vendor/symfony/serializer/NameConverter/CamelCaseToSnakeCaseNameConverter.php8  Ng8  \Ѥ      2   vendor/symfony/serializer/Command/DebugCommand.phpy  Ngy  2 3      ;   vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php  Ng  aZ      >   vendor/symfony/serializer/Normalizer/MimeMessageNormalizer.phpD  NgD  Br͌      @   vendor/symfony/serializer/Normalizer/DenormalizableInterface.phpv  Ngv        :   vendor/symfony/serializer/Normalizer/ProblemNormalizer.php  Ng  K      I   vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php"  Ng"  Jgɤ      >   vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php-  Ng-  Ґ~}      <   vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php	  Ng	  cI      J   vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php7  Ng7  #      :   vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php  Ng        A   vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.phpו  Ngו  X      ?   vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php  Ng  6Ǥ      ?   vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php}
  Ng}
  /)      =   vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.phpk  Ngk  #      A   vendor/symfony/serializer/Normalizer/NormalizerAwareInterface.php%  Ng%  :]R      C   vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php1
  Ng1
  PC      :   vendor/symfony/serializer/Normalizer/DataUriNormalizer.php  Ng  %      H   vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php  Ng  +      9   vendor/symfony/serializer/Normalizer/CustomNormalizer.phpB  NgB  O(      C   vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php/  Ng/  <ǖ      ?   vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php  Ng  zԋ      ;   vendor/symfony/serializer/Normalizer/PropertyNormalizer.php   Ng   :      9   vendor/symfony/serializer/Normalizer/ObjectNormalizer.php6'  Ng6'  ЯOQ      ;   vendor/symfony/serializer/Normalizer/AbstractNormalizer.phpa  Nga  Pt      ?   vendor/symfony/serializer/Normalizer/TranslatableNormalizer.php  Ng  Z7(G      6   vendor/symfony/serializer/Normalizer/UidNormalizer.php  Ng   ru      >   vendor/symfony/serializer/Normalizer/DenormalizerInterface.php
  Ng
  Vi3      >   vendor/symfony/serializer/Normalizer/NormalizableInterface.php  Ng        ?   vendor/symfony/serializer/Normalizer/GetSetMethodNormalizer.php  Ng  58m      =   vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php,  Ng,  g      J   vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php  Ng  o      <   vendor/symfony/serializer/Normalizer/NormalizerInterface.php  Ng  e      ?   vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php{  Ng{  o      2   vendor/symfony/serializer/SerializerAwareTrait.php`  Ng`  ĝ|      @   vendor/symfony/serializer/DependencyInjection/SerializerPass.php
  Ng
        6   vendor/symfony/serializer/Exception/LogicException.php  Ng  A      :   vendor/symfony/serializer/Exception/ExceptionInterface.php  Ng  Za      L   vendor/symfony/serializer/Exception/MissingConstructorArgumentsException.php  Ng  a      @   vendor/symfony/serializer/Exception/UnexpectedValueException.php  Ng  rǤ      8   vendor/symfony/serializer/Exception/RuntimeException.php  Ng  VX      E   vendor/symfony/serializer/Exception/NotNormalizableValueException.phpc  Ngc  N͜      @   vendor/symfony/serializer/Exception/InvalidArgumentException.php  Ng  n      B   vendor/symfony/serializer/Exception/CircularReferenceException.php  Ng  s5      >   vendor/symfony/serializer/Exception/BadMethodCallException.php  Ng  }
      8   vendor/symfony/serializer/Exception/MappingException.php  Ng  Ǡۤ      <   vendor/symfony/serializer/Exception/UnsupportedException.php  Ng         B   vendor/symfony/serializer/Exception/NotEncodableValueException.php  Ng  \53      G   vendor/symfony/serializer/Exception/PartialDenormalizationException.phpM  NgM  D      B   vendor/symfony/serializer/Exception/UnsupportedFormatException.php  Ng  G`k      @   vendor/symfony/serializer/Exception/ExtraAttributesException.php  Ng  3ٌ      '   vendor/symfony/serializer/composer.json	  Ng	  ɮ      4   vendor/symfony/serializer/Debug/TraceableEncoder.php'  Ng'  hͤ      7   vendor/symfony/serializer/Debug/TraceableSerializer.php  Ng  &Ix      7   vendor/symfony/serializer/Debug/TraceableNormalizer.phpa  Nga  ;ݤ      *   vendor/symfony/polyfill-php80/PhpToken.php  Ng  s`      %   vendor/symfony/polyfill-php80/LICENSE,  Ng,  K      :   vendor/symfony/polyfill-php80/Resources/stubs/PhpToken.phpw  Ngw  =7T8      <   vendor/symfony/polyfill-php80/Resources/stubs/ValueError.php>  Ng>  g      ;   vendor/symfony/polyfill-php80/Resources/stubs/Attribute.php  Ng  MK<      E   vendor/symfony/polyfill-php80/Resources/stubs/UnhandledMatchError.phpG  NgG  ֈ+      <   vendor/symfony/polyfill-php80/Resources/stubs/Stringable.php  Ng  t]\ڤ      +   vendor/symfony/polyfill-php80/bootstrap.php  Ng  .Ĥ      '   vendor/symfony/polyfill-php80/README.md  Ng  "tF      '   vendor/symfony/polyfill-php80/Php80.php  Ng  H      +   vendor/symfony/polyfill-php80/composer.jsonb  Ngb  F      7   vendor/symfony/monolog-bridge/Handler/MailerHandler.php  Ng  1d      H   vendor/symfony/monolog-bridge/Handler/CompatibilityProcessingHandler.php  Ng        8   vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php  Ng  Ѻ	      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php  Ng  c      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/NotFoundActivationStrategy.phpT  NgT  s      :   vendor/symfony/monolog-bridge/Handler/ServerLogHandler.php  Ng  \~      >   vendor/symfony/monolog-bridge/Handler/CompatibilityHandler.php  Ng  !E      9   vendor/symfony/monolog-bridge/Handler/NotifierHandler.php	  Ng	  %ˤ      8   vendor/symfony/monolog-bridge/Handler/FirePHPHandler.php  Ng  J      :   vendor/symfony/monolog-bridge/Handler/ChromePhpHandler.php0  Ng0  ݤ      F   vendor/symfony/monolog-bridge/Handler/ElasticsearchLogstashHandler.php  Ng  I6      (   vendor/symfony/monolog-bridge/Logger.php-
  Ng-
  y      %   vendor/symfony/monolog-bridge/LICENSE,  Ng,  U      *   vendor/symfony/monolog-bridge/CHANGELOG.md
  Ng
  `s      :   vendor/symfony/monolog-bridge/Processor/TokenProcessor.php<  Ng<  ]      D   vendor/symfony/monolog-bridge/Processor/SwitchUserTokenProcessor.php  Ng  A܊      8   vendor/symfony/monolog-bridge/Processor/WebProcessor.php  Ng        B   vendor/symfony/monolog-bridge/Processor/CompatibilityProcessor.php!  Ng!  6$      :   vendor/symfony/monolog-bridge/Processor/RouteProcessor.php	  Ng	  <      C   vendor/symfony/monolog-bridge/Processor/ConsoleCommandProcessor.phpJ  NgJ  ZU      B   vendor/symfony/monolog-bridge/Processor/AbstractTokenProcessor.php  Ng  dC      :   vendor/symfony/monolog-bridge/Processor/DebugProcessor.php  Ng  c4      '   vendor/symfony/monolog-bridge/README.md  Ng  =~      <   vendor/symfony/monolog-bridge/Formatter/ConsoleFormatter.php  Ng  Pp      >   vendor/symfony/monolog-bridge/Formatter/VarDumperFormatter.php0  Ng0  r~ݤ      B   vendor/symfony/monolog-bridge/Formatter/CompatibilityFormatter.php  Ng  ˦k      :   vendor/symfony/monolog-bridge/Command/ServerLogCommand.php  Ng        +   vendor/symfony/monolog-bridge/composer.json  Ng  -}b      9   vendor/symfony/cache/DataCollector/CacheDataCollector.php  Ng  b:XP      "   vendor/symfony/cache/CacheItem.php  Ng  g9      #   vendor/symfony/cache/Psr16Cache.php=  Ng=  8`c         vendor/symfony/cache/LICENSE,  Ng,  X      +   vendor/symfony/cache/PruneableInterface.php  Ng  a]      !   vendor/symfony/cache/CHANGELOG.mdo  Ngo  ʗXJ      5   vendor/symfony/cache/Traits/RedisClusterNodeProxy.php  Ng  &yF      /   vendor/symfony/cache/Traits/RelayProxyTrait.php  Ng  R      *   vendor/symfony/cache/Traits/RedisTrait.phpBu  NgBu  pU      +   vendor/symfony/cache/Traits/Redis5Proxy.php׷  Ng׷  \٤      2   vendor/symfony/cache/Traits/RedisCluster6Proxy.phps  Ngs  Q      *   vendor/symfony/cache/Traits/ProxyTrait.php%  Ng%  P      5   vendor/symfony/cache/Traits/FilesystemCommonTrait.php9  Ng9        1   vendor/symfony/cache/Traits/RedisClusterProxy.php  Ng  `"      *   vendor/symfony/cache/Traits/RedisProxy.php  Ng  G.r      .   vendor/symfony/cache/Traits/ContractsTrait.php&  Ng&  .M=      *   vendor/symfony/cache/Traits/RelayProxy.php  Ng  Vz"      0   vendor/symfony/cache/Traits/Redis6ProxyTrait.php  Ng  P      ,   vendor/symfony/cache/Traits/ValueWrapper.phpE  NgE  i7      2   vendor/symfony/cache/Traits/RedisCluster5Proxy.php\  Ng\  UҤ      /   vendor/symfony/cache/Traits/FilesystemTrait.php  Ng  7      +   vendor/symfony/cache/Traits/Redis6Proxy.php  Ng  X      4   vendor/symfony/cache/Traits/Relay/GeosearchTrait.php'  Ng'  7      /   vendor/symfony/cache/Traits/Relay/MoveTrait.php  Ng  b      2   vendor/symfony/cache/Traits/Relay/PfcountTrait.php  Ng  D      /   vendor/symfony/cache/Traits/Relay/CopyTrait.php  Ng  ѽ      9   vendor/symfony/cache/Traits/Relay/NullableReturnTrait.phpZ  NgZ  *zʤ      /   vendor/symfony/cache/Traits/Relay/HsetTrait.php  Ng  E      3   vendor/symfony/cache/Traits/Relay/GetrangeTrait.php  Ng  XԖ      4   vendor/symfony/cache/Traits/AbstractAdapterTrait.php\0  Ng\0  1Ť      7   vendor/symfony/cache/Traits/RedisCluster6ProxyTrait.php  Ng  Xm      -   vendor/symfony/cache/Adapter/ProxyAdapter.php_  Ng_  <      ,   vendor/symfony/cache/Adapter/ApcuAdapter.phpX  NgX  S      ;   vendor/symfony/cache/Adapter/CouchbaseCollectionAdapter.php  Ng  ƫ}      1   vendor/symfony/cache/Adapter/TraceableAdapter.php  Ng  
bJ6      +   vendor/symfony/cache/Adapter/PdoAdapter.phpA  NgA        -   vendor/symfony/cache/Adapter/ArrayAdapter.php,  Ng,  4      5   vendor/symfony/cache/Adapter/RedisTagAwareAdapter.php0  Ng0  1      7   vendor/symfony/cache/Adapter/CouchbaseBucketAdapter.php  Ng  <^      ,   vendor/symfony/cache/Adapter/NullAdapter.php  Ng  :@      4   vendor/symfony/cache/Adapter/ParameterNormalizer.php  Ng  +      0   vendor/symfony/cache/Adapter/TagAwareAdapter.php,  Ng,  mX      0   vendor/symfony/cache/Adapter/PhpFilesAdapter.php(  Ng(   &      4   vendor/symfony/cache/Adapter/DoctrineDbalAdapter.phpA  NgA  nƬq      9   vendor/symfony/cache/Adapter/TagAwareAdapterInterface.php	  Ng	  ?      1   vendor/symfony/cache/Adapter/MemcachedAdapter.php4  Ng4  l9
      -   vendor/symfony/cache/Adapter/RedisAdapter.php/  Ng/  -U=$      1   vendor/symfony/cache/Adapter/AdapterInterface.php  Ng  $B      :   vendor/symfony/cache/Adapter/FilesystemTagAwareAdapter.php#  Ng#  ˤ      9   vendor/symfony/cache/Adapter/TraceableTagAwareAdapter.php  Ng  6s:      -   vendor/symfony/cache/Adapter/Psr16Adapter.php*  Ng*  $\      -   vendor/symfony/cache/Adapter/ChainAdapter.php]"  Ng]"  x      2   vendor/symfony/cache/Adapter/FilesystemAdapter.php  Ng  (Acb      0   vendor/symfony/cache/Adapter/AbstractAdapter.php2  Ng2  @2      8   vendor/symfony/cache/Adapter/AbstractTagAwareAdapter.php1  Ng1  ;,      0   vendor/symfony/cache/Adapter/PhpArrayAdapter.php/  Ng/   Ť      %   vendor/symfony/cache/LockRegistry.php  Ng  )?Ӥ      ,   vendor/symfony/cache/ResettableInterface.php  Ng  NR         vendor/symfony/cache/README.md  Ng  `t:      9   vendor/symfony/cache/Messenger/EarlyExpirationHandler.php7
  Ng7
  r      9   vendor/symfony/cache/Messenger/EarlyExpirationMessage.php
  Ng
  %      <   vendor/symfony/cache/Messenger/EarlyExpirationDispatcher.php	  Ng	  q      5   vendor/symfony/cache/Marshaller/DefaultMarshaller.phpK  NgK  h&      5   vendor/symfony/cache/Marshaller/DeflateMarshaller.php  Ng  C      7   vendor/symfony/cache/Marshaller/MarshallerInterface.php3  Ng3  Ǚ      6   vendor/symfony/cache/Marshaller/TagAwareMarshaller.php  Ng  t      4   vendor/symfony/cache/Marshaller/SodiumMarshaller.php`	  Ng`	  F      :   vendor/symfony/cache/DependencyInjection/CachePoolPass.php,'  Ng,'  VM      @   vendor/symfony/cache/DependencyInjection/CachePoolPrunerPass.php  Ng  m}      ?   vendor/symfony/cache/DependencyInjection/CacheCollectorPass.php  Ng  t      A   vendor/symfony/cache/DependencyInjection/CachePoolClearerPass.php  Ng  Ł:      1   vendor/symfony/cache/Exception/LogicException.php  Ng  9d      ;   vendor/symfony/cache/Exception/InvalidArgumentException.php  Ng  j      1   vendor/symfony/cache/Exception/CacheException.php  Ng  Q4      "   vendor/symfony/cache/composer.json  Ng  Fw      -   vendor/symfony/polyfill-ctype/bootstrap80.phpr  Ngr  F)      %   vendor/symfony/polyfill-ctype/LICENSE,  Ng,        +   vendor/symfony/polyfill-ctype/bootstrap.php@  Ng@  jQ9      '   vendor/symfony/polyfill-ctype/README.md^  Ng^  lHk      '   vendor/symfony/polyfill-ctype/Ctype.php  Ng   /      +   vendor/symfony/polyfill-ctype/composer.json  Ng  9      %   vendor/symfony/polyfill-php81/LICENSE,  Ng,  0      F   vendor/symfony/polyfill-php81/Resources/stubs/ReturnTypeWillChange.php  Ng  5+      @   vendor/symfony/polyfill-php81/Resources/stubs/CURLStringFile.php  Ng  JT      +   vendor/symfony/polyfill-php81/bootstrap.php  Ng  <P      '   vendor/symfony/polyfill-php81/README.md  Ng        '   vendor/symfony/polyfill-php81/Php81.php  Ng  3E      +   vendor/symfony/polyfill-php81/composer.json  Ng  #@      F   vendor/symfony/security-bundle/DataCollector/SecurityDataCollector.php>.  Ng>.  n      &   vendor/symfony/security-bundle/LICENSE,  Ng,  U      +   vendor/symfony/security-bundle/CHANGELOG.mdCD  NgCD  ;      ?   vendor/symfony/security-bundle/Security/LazyFirewallContext.php	  Ng	  Ӈ      =   vendor/symfony/security-bundle/Security/UserAuthenticator.php>  Ng>  @      ;   vendor/symfony/security-bundle/Security/FirewallContext.phpC  NgC  7{Ȥ      7   vendor/symfony/security-bundle/Security/FirewallMap.php;	  Ng;	  5r\      :   vendor/symfony/security-bundle/Security/FirewallConfig.php	  Ng	  `9p      >   vendor/symfony/security-bundle/Security/FirewallAwareTrait.php  Ng  s      W   vendor/symfony/security-bundle/Resources/config/security_authenticator_access_token.php  Ng  43MU      C   vendor/symfony/security-bundle/Resources/config/templating_twig.php  Ng  @']      F   vendor/symfony/security-bundle/Resources/config/security_listeners.php  Ng  Ne      U   vendor/symfony/security-bundle/Resources/config/security_authenticator_login_link.php	  Ng	  +      B   vendor/symfony/security-bundle/Resources/config/security_debug.php3  Ng3  6!H!      A   vendor/symfony/security-bundle/Resources/config/debug_console.php   Ng         G   vendor/symfony/security-bundle/Resources/config/schema/security-1.0.xsdX  NgX  f#      ;   vendor/symfony/security-bundle/Resources/config/console.php  Ng  ,      C   vendor/symfony/security-bundle/Resources/config/password_hasher.php  Ng  J      >   vendor/symfony/security-bundle/Resources/config/collectors.php  Ng  u|      J   vendor/symfony/security-bundle/Resources/config/security_authenticator.php  Ng  VQ      <   vendor/symfony/security-bundle/Resources/config/security.php	.  Ng	.  អ      V   vendor/symfony/security-bundle/Resources/config/security_authenticator_remember_me.php  Ng  K      A   vendor/symfony/security-bundle/Resources/views/Collector/icon.svg  Ng  0צ      K   vendor/symfony/security-bundle/Resources/views/Collector/security.html.twige  Nge  Y      D   vendor/symfony/security-bundle/CacheWarmer/ExpressionCacheWarmer.phpq  Ngq  50      1   vendor/symfony/security-bundle/SecurityBundle.php  Ng  7-X      (   vendor/symfony/security-bundle/README.md  Ng  [A      H   vendor/symfony/security-bundle/RememberMe/DecoratedRememberMeHandler.php^  Ng^  H:y      L   vendor/symfony/security-bundle/RememberMe/FirewallAwareRememberMeHandler.php@  Ng@  G٤      ?   vendor/symfony/security-bundle/Command/DebugFirewallCommand.php"  Ng"  ž&x      <   vendor/symfony/security-bundle/Routing/LogoutRouteLoader.php=  Ng=  פ      +   vendor/symfony/security-bundle/Security.php%  Ng%        J   vendor/symfony/security-bundle/LoginLink/FirewallAwareLoginLinkHandler.php	  Ng	  ߡ      H   vendor/symfony/security-bundle/DependencyInjection/MainConfiguration.phpS9  NgS9  |      c   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcTokenHandlerFactory.php3  Ng3  V      k   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcUserInfoTokenHandlerFactory.php
  Ng
  ~G      f   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/ServiceTokenHandlerFactory.php  Ng  CWߤ      h   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/TokenHandlerFactoryInterface.php  Ng  w(      X   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/LdapFactory.php	  Ng	  HX      \   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/InMemoryFactory.php  Ng  bHq      i   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/UserProviderFactoryInterface.php  Ng  vi      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginLinkFactory.phpm  Ngm  pSʤ      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicLdapFactory.php  Ng  (腊      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginLdapFactory.php  Ng  Rz      Z   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AccessTokenFactory.php  Ng  AY      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginFactory.phpv  Ngv  zä      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginLdapFactory.phpK  NgK  pR      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/CustomAuthenticatorFactory.php  Ng  Xi      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RemoteUserFactory.php  Ng  :Pդ      e   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AuthenticatorFactoryInterface.phpG  NgG  3S      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RememberMeFactory.php*  Ng*  隤      W   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AbstractFactory.php  Ng  p      S   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/X509Factory.php  Ng  Vr@      a   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/SignatureAlgorithmFactory.phpf  Ngf  P      h   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FirewallListenerFactoryInterface.php  Ng  }/      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginFactory.php  Ng  
      n   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/StatelessAuthenticatorFactoryInterface.php	  Ng	  9̤      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicFactory.php  Ng  soF      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LdapFactoryTrait.phpm	  Ngm	  盤      ^   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginThrottlingFactory.php  Ng  .b      H   vendor/symfony/security-bundle/DependencyInjection/SecurityExtension.php  Ng  =2W[      b   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.php  Ng  ߐ*7      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterTokenUsageTrackingPass.php	  Ng	  І;      W   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterLdapLocatorPass.phpW  NgW  9k      h   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterGlobalSecurityEventListenersPass.php 
  Ng 
  Ǔ      Y   vendor/symfony/security-bundle/DependencyInjection/Compiler/SortFirewallListenersPass.phpO  NgO  դ      e   vendor/symfony/security-bundle/DependencyInjection/Compiler/ReplaceDecoratedRememberMeHandlerPass.php	  Ng	  >y      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSessionDomainConstraintPass.php  Ng  x      U   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSecurityVotersPass.php
  Ng
  rҤ      V   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterEntryPointPass.php  Ng  d%      i   vendor/symfony/security-bundle/DependencyInjection/Compiler/MakeFirewallsEventDispatcherTraceablePass.php`
  Ng`
  U
p3      [   vendor/symfony/security-bundle/DependencyInjection/Compiler/CleanRememberMeVerifierPass.php  Ng  "*A      X   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfFeaturesPass.php	  Ng	  8I      ,   vendor/symfony/security-bundle/composer.json  Ng  ֛      B   vendor/symfony/security-bundle/Debug/TraceableFirewallListener.phpN  NgN  Z.      8   vendor/symfony/security-bundle/Debug/WrappedListener.php  Ng  D      ?   vendor/symfony/security-bundle/Debug/TraceableListenerTrait.phpj  Ngj  qU      <   vendor/symfony/security-bundle/Debug/WrappedLazyListener.php  Ng  
9      A   vendor/symfony/security-bundle/EventListener/FirewallListener.php  Ng  +C      =   vendor/symfony/security-bundle/EventListener/VoteListener.phpB  NgB  <ˊϤ      4   vendor/symfony/config/ResourceCheckerConfigCache.php~  Ng~  p         vendor/symfony/config/LICENSE,  Ng,  U      '   vendor/symfony/config/Util/XmlUtils.php$  Ng$  U6      <   vendor/symfony/config/Util/Exception/XmlParsingException.php  Ng  䢗      <   vendor/symfony/config/Util/Exception/InvalidXmlException.php4  Ng4        "   vendor/symfony/config/CHANGELOG.mde  Nge  (,      .   vendor/symfony/config/ConfigCacheInterface.php  Ng  	1      .   vendor/symfony/config/FileLocatorInterface.php  Ng        %   vendor/symfony/config/ConfigCache.php  Ng  S      5   vendor/symfony/config/ConfigCacheFactoryInterface.php  Ng  ^&      %   vendor/symfony/config/FileLocator.php4
  Ng4
  =      2   vendor/symfony/config/ResourceCheckerInterface.php  Ng  åؤ         vendor/symfony/config/README.mdT  NgT        '   vendor/symfony/config/Loader/Loader.php  Ng  IѤ      >   vendor/symfony/config/Loader/DirectoryAwareLoaderInterface.php  Ng  j=      +   vendor/symfony/config/Loader/FileLoader.php  Ng  bUL      2   vendor/symfony/config/Loader/ParamConfigurator.phpq  Ngq  n݁      0   vendor/symfony/config/Loader/LoaderInterface.phpy  Ngy  ঽ      8   vendor/symfony/config/Loader/LoaderResolverInterface.php  Ng  G/3      /   vendor/symfony/config/Loader/LoaderResolver.phpF  NgF  )%%      1   vendor/symfony/config/Loader/DelegatingLoader.php  Ng  Κ%      /   vendor/symfony/config/Loader/GlobFileLoader.php  Ng  [      .   vendor/symfony/config/Definition/FloatNode.php  Ng  Ť      -   vendor/symfony/config/Definition/BaseNode.php:  Ng:  qY6      0   vendor/symfony/config/Definition/NumericNode.php)  Ng)  	ä      :   vendor/symfony/config/Definition/ConfigurableInterface.phpo  Ngo  jש,      0   vendor/symfony/config/Definition/IntegerNode.phpV  NgV  (      ;   vendor/symfony/config/Definition/PrototypeNodeInterface.phpp  Ngp  <5@      2   vendor/symfony/config/Definition/Configuration.php  Ng  j      8   vendor/symfony/config/Definition/PrototypedArrayNode.php,  Ng,  d#      .   vendor/symfony/config/Definition/Processor.php	  Ng	   \      @   vendor/symfony/config/Definition/Loader/DefinitionFileLoader.php  Ng   "      2   vendor/symfony/config/Definition/NodeInterface.phpL  NgL  Q      -   vendor/symfony/config/Definition/EnumNode.php
  Ng
  |      0   vendor/symfony/config/Definition/BooleanNode.php  Ng  
B      H   vendor/symfony/config/Definition/Configurator/DefinitionConfigurator.phpy  Ngy  =      .   vendor/symfony/config/Definition/ArrayNode.php.  Ng.  ͤ      /   vendor/symfony/config/Definition/ScalarNode.php}  Ng}  GrI      ;   vendor/symfony/config/Definition/ConfigurationInterface.php  Ng  _+      8   vendor/symfony/config/Definition/Builder/ExprBuilder.phpL  NgL  :^      ?   vendor/symfony/config/Definition/Builder/EnumNodeDefinition.php  Ng  <      9   vendor/symfony/config/Definition/Builder/MergeBuilder.php  Ng  |      B   vendor/symfony/config/Definition/Builder/NumericNodeDefinition.phpm  Ngm  Mg      8   vendor/symfony/config/Definition/Builder/NodeBuilder.php  Ng  |פ      C   vendor/symfony/config/Definition/Builder/VariableNodeDefinition.phpg  Ngg  ?      @   vendor/symfony/config/Definition/Builder/ArrayNodeDefinition.php=  Ng=  M}      B   vendor/symfony/config/Definition/Builder/BuilderAwareInterface.phpl  Ngl  %      >   vendor/symfony/config/Definition/Builder/ValidationBuilder.php  Ng  ]
      8   vendor/symfony/config/Definition/Builder/TreeBuilder.phpE  NgE  O      B   vendor/symfony/config/Definition/Builder/IntegerNodeDefinition.php  Ng  \+F}      @   vendor/symfony/config/Definition/Builder/NodeParentInterface.php  Ng  ʤ      A   vendor/symfony/config/Definition/Builder/NormalizationBuilder.php  Ng  Xä      B   vendor/symfony/config/Definition/Builder/BooleanNodeDefinition.php  Ng  YDq      J   vendor/symfony/config/Definition/Builder/ParentNodeDefinitionInterface.php  Ng  Σ      A   vendor/symfony/config/Definition/Builder/ScalarNodeDefinition.php  Ng  *@      @   vendor/symfony/config/Definition/Builder/FloatNodeDefinition.php  Ng  ю      ;   vendor/symfony/config/Definition/Builder/NodeDefinition.phpf  Ngf  3Ԥ      D   vendor/symfony/config/Definition/Exception/DuplicateKeyException.phpS  NgS  g      I   vendor/symfony/config/Definition/Exception/InvalidDefinitionException.php  Ng  re      C   vendor/symfony/config/Definition/Exception/InvalidTypeException.php  Ng  2      @   vendor/symfony/config/Definition/Exception/UnsetKeyException.php*  Ng*  %2d      L   vendor/symfony/config/Definition/Exception/InvalidConfigurationException.php  Ng  i      J   vendor/symfony/config/Definition/Exception/ForbiddenOverwriteException.php_  Ng_  :      8   vendor/symfony/config/Definition/Exception/Exception.php  Ng  RrO      1   vendor/symfony/config/Definition/VariableNode.php
  Ng
  o      ?   vendor/symfony/config/Definition/Dumper/YamlReferenceDumper.php   Ng   0      >   vendor/symfony/config/Definition/Dumper/XmlReferenceDumper.php'  Ng'        @   vendor/symfony/config/Resource/SelfCheckingResourceInterface.php  Ng  2Ф      /   vendor/symfony/config/Resource/FileResource.php  Ng  a      :   vendor/symfony/config/Resource/ReflectionClassResource.php  Ng  h[      >   vendor/symfony/config/Resource/SelfCheckingResourceChecker.php}  Ng}  r      3   vendor/symfony/config/Resource/ComposerResource.php2  Ng2  3Pu      8   vendor/symfony/config/Resource/FileExistenceResource.php  Ng  w}      4   vendor/symfony/config/Resource/ResourceInterface.php  Ng  8I      9   vendor/symfony/config/Resource/ClassExistenceResource.php   Ng   T$      4   vendor/symfony/config/Resource/DirectoryResource.php
  Ng
  C      /   vendor/symfony/config/Resource/GlobResource.phpW!  NgW!  ׏3      8   vendor/symfony/config/Builder/ConfigBuilderInterface.php  Ng  {O      (   vendor/symfony/config/Builder/Method.php  Ng  @֤      .   vendor/symfony/config/Builder/ClassBuilder.php  Ng        *   vendor/symfony/config/Builder/Property.php,  Ng,  _      A   vendor/symfony/config/Builder/ConfigBuilderGeneratorInterface.php  Ng        8   vendor/symfony/config/Builder/ConfigBuilderGenerator.phpR  NgR  &	      7   vendor/symfony/config/Exception/LoaderLoadException.php  Ng  /z      N   vendor/symfony/config/Exception/FileLoaderImportCircularReferenceException.php[  Ng[  `ܤ      D   vendor/symfony/config/Exception/FileLocatorFileNotFoundException.phpK  NgK  f      #   vendor/symfony/config/composer.json   Ng   M      ,   vendor/symfony/config/ConfigCacheFactory.phpS  NgS  cġ      ;   vendor/symfony/config/ResourceCheckerConfigCacheFactory.php5  Ng5  Yb      D   vendor/symfony/security-http/RateLimiter/DefaultLoginRateLimiter.php  Ng  b      4   vendor/symfony/security-http/Attribute/IsGranted.php  Ng  `A      6   vendor/symfony/security-http/Attribute/CurrentUser.php!  Ng!  C      $   vendor/symfony/security-http/LICENSE,  Ng,  U      5   vendor/symfony/security-http/Util/TargetPathTrait.phpb  Ngb  6=Y      )   vendor/symfony/security-http/CHANGELOG.md  Ng  k      ,   vendor/symfony/security-http/FirewallMap.phpf  Ngf  r      )   vendor/symfony/security-http/Firewall.php]  Ng]        J   vendor/symfony/security-http/AccessToken/AccessTokenExtractorInterface.phpf  Ngf  }P      H   vendor/symfony/security-http/AccessToken/AccessTokenHandlerInterface.php  Ng  msl      G   vendor/symfony/security-http/AccessToken/HeaderAccessTokenExtractor.php8  Ng8  h      F   vendor/symfony/security-http/AccessToken/ChainAccessTokenExtractor.php'  Ng'  g
      J   vendor/symfony/security-http/AccessToken/Oidc/OidcUserInfoTokenHandler.php  Ng  mɤ      ;   vendor/symfony/security-http/AccessToken/Oidc/OidcTrait.php  Ng  ̤      B   vendor/symfony/security-http/AccessToken/Oidc/OidcTokenHandler.php  Ng  !]6      U   vendor/symfony/security-http/AccessToken/Oidc/Exception/InvalidSignatureException.php  Ng  +FL      Q   vendor/symfony/security-http/AccessToken/Oidc/Exception/MissingClaimException.php  Ng  	      E   vendor/symfony/security-http/AccessToken/FormEncodedBodyExtractor.phpm  Ngm  }      F   vendor/symfony/security-http/AccessToken/QueryAccessTokenExtractor.php  Ng  w      :   vendor/symfony/security-http/Logout/LogoutUrlGenerator.phpv  Ngv  +      /   vendor/symfony/security-http/SecurityEvents.php  Ng  7      8   vendor/symfony/security-http/Firewall/AccessListener.php
  Ng
  8ä      9   vendor/symfony/security-http/Firewall/ContextListener.php5  Ng5  M-      :   vendor/symfony/security-http/Firewall/AbstractListener.phpq  Ngq        F   vendor/symfony/security-http/Firewall/AuthenticatorManagerListener.phpj  Ngj  ʯ      ;   vendor/symfony/security-http/Firewall/ExceptionListener.phpf(  Ngf(  ti      C   vendor/symfony/security-http/Firewall/FirewallListenerInterface.php=  Ng=  9      9   vendor/symfony/security-http/Firewall/ChannelListener.php  Ng  2      <   vendor/symfony/security-http/Firewall/SwitchUserListener.phpE$  NgE$  hް      8   vendor/symfony/security-http/Firewall/LogoutListener.php  Ng  (3\      F   vendor/symfony/security-http/Controller/SecurityTokenValueResolver.php  Ng  J;Y      =   vendor/symfony/security-http/Controller/UserValueResolver.php  Ng  ؉M      &   vendor/symfony/security-http/README.md  Ng  k      <   vendor/symfony/security-http/RememberMe/ResponseListener.php  Ng         G   vendor/symfony/security-http/RememberMe/PersistentRememberMeHandler.phpc  Ngc  TKљ      F   vendor/symfony/security-http/RememberMe/RememberMeHandlerInterface.php
  Ng
  	~¤      =   vendor/symfony/security-http/RememberMe/RememberMeDetails.phpQ  NgQ  Gk<[      E   vendor/symfony/security-http/RememberMe/AbstractRememberMeHandler.phpX  NgX  a*      F   vendor/symfony/security-http/RememberMe/SignatureRememberMeHandler.php
  Ng
  xo$f      M   vendor/symfony/security-http/EntryPoint/AuthenticationEntryPointInterface.php  Ng  3i      N   vendor/symfony/security-http/EntryPoint/Exception/NotAnEntryPointException.php  Ng  (6      *   vendor/symfony/security-http/HttpUtils.php  Ng  e      5   vendor/symfony/security-http/FirewallMapInterface.php  Ng  9J      L   vendor/symfony/security-http/Authenticator/Token/PostAuthenticationToken.phpT  NgT  H      P   vendor/symfony/security-http/Authenticator/InteractiveAuthenticatorInterface.phpj  Ngj  9      M   vendor/symfony/security-http/Authenticator/AbstractLoginFormAuthenticator.php	  Ng	  e      E   vendor/symfony/security-http/Authenticator/AuthenticatorInterface.phpS
  NgS
  v
      A   vendor/symfony/security-http/Authenticator/FallbackUserLoader.php  Ng  ٤      D   vendor/symfony/security-http/Authenticator/AbstractAuthenticator.php  Ng   R      E   vendor/symfony/security-http/Authenticator/HttpBasicAuthenticator.phpe  Nge  Z      E   vendor/symfony/security-http/Authenticator/LoginLinkAuthenticator.php?  Ng?  !6      E   vendor/symfony/security-http/Authenticator/JsonLoginAuthenticator.php  Ng  7$;      N   vendor/symfony/security-http/Authenticator/Passport/SelfValidatingPassport.php  Ng  YWW      @   vendor/symfony/security-http/Authenticator/Passport/Passport.php$  Ng$   ;!2      X   vendor/symfony/security-http/Authenticator/Passport/Credentials/CredentialsInterface.php  Ng  P      U   vendor/symfony/security-http/Authenticator/Passport/Credentials/CustomCredentials.php  Ng  @1      W   vendor/symfony/security-http/Authenticator/Passport/Credentials/PasswordCredentials.phpV  NgV  R      W   vendor/symfony/security-http/Authenticator/Passport/Badge/PreAuthenticatedUserBadge.php  Ng  yΤ      L   vendor/symfony/security-http/Authenticator/Passport/Badge/CsrfTokenBadge.phpi  Ngi  $      R   vendor/symfony/security-http/Authenticator/Passport/Badge/PasswordUpgradeBadge.phpV  NgV  Ĥ      G   vendor/symfony/security-http/Authenticator/Passport/Badge/UserBadge.php  Ng  V5פ      M   vendor/symfony/security-http/Authenticator/Passport/Badge/RememberMeBadge.phpK  NgK  p"      L   vendor/symfony/security-http/Authenticator/Passport/Badge/BadgeInterface.php  Ng  ˙Au      @   vendor/symfony/security-http/Authenticator/X509Authenticator.php	  Ng	  }      G   vendor/symfony/security-http/Authenticator/AccessTokenAuthenticator.php  Ng  YTS      F   vendor/symfony/security-http/Authenticator/RemoteUserAuthenticator.php  Ng  _]z      E   vendor/symfony/security-http/Authenticator/FormLoginAuthenticator.phpS  NgS  eQ8      T   vendor/symfony/security-http/Authenticator/AbstractPreAuthenticatedAuthenticator.php  Ng  hʆ`      K   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticator.phpO  NgO  ӊ2      Z   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticatorManagerListener.phpg  Ngg        F   vendor/symfony/security-http/Authenticator/RememberMeAuthenticator.php  Ng  Au      K   vendor/symfony/security-http/Authorization/AccessDeniedHandlerInterface.phpz  Ngz  (      3   vendor/symfony/security-http/AccessMapInterface.phpi  Ngi  HY%      ;   vendor/symfony/security-http/LoginLink/LoginLinkDetails.phpe  Nge  Z/      ;   vendor/symfony/security-http/LoginLink/LoginLinkHandler.php  Ng  ̸      @   vendor/symfony/security-http/LoginLink/LoginLinkNotification.php
  Ng
  ֽ      D   vendor/symfony/security-http/LoginLink/LoginLinkHandlerInterface.php  Ng  \S      W   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkExceptionInterface.php  Ng  HF      N   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkException.php  Ng        \   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkAuthenticationException.php  Ng  <Yķ      N   vendor/symfony/security-http/LoginLink/Exception/ExpiredLoginLinkException.phpI  NgI  Z      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationFailureHandler.phph  Ngh  [)-G      M   vendor/symfony/security-http/Authentication/AuthenticatorManagerInterface.php  Ng  1      R   vendor/symfony/security-http/Authentication/CustomAuthenticationSuccessHandler.php  Ng  W"¤      U   vendor/symfony/security-http/Authentication/AuthenticationFailureHandlerInterface.php>  Ng>        C   vendor/symfony/security-http/Authentication/AuthenticationUtils.php	  Ng	  ج      R   vendor/symfony/security-http/Authentication/CustomAuthenticationFailureHandler.php  Ng  c      U   vendor/symfony/security-http/Authentication/AuthenticationSuccessHandlerInterface.phpI  NgI  &4Q      J   vendor/symfony/security-http/Authentication/UserAuthenticatorInterface.php  Ng  
>      D   vendor/symfony/security-http/Authentication/AuthenticatorManager.php6  Ng6  c
9      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationSuccessHandler.php  Ng  N"      *   vendor/symfony/security-http/AccessMap.php~  Ng~  t<y      8   vendor/symfony/security-http/Event/LoginFailureEvent.php;
  Ng;
  (Ϥ      8   vendor/symfony/security-http/Event/LoginSuccessEvent.php<  Ng<  .      8   vendor/symfony/security-http/Event/LazyResponseEvent.php  Ng  /H
      6   vendor/symfony/security-http/Event/SwitchUserEvent.php  Ng  U      F   vendor/symfony/security-http/Event/AuthenticationTokenCreatedEvent.phpW  NgW  c|      9   vendor/symfony/security-http/Event/CheckPassportEvent.php  Ng  g      <   vendor/symfony/security-http/Event/InteractiveLoginEvent.phpG  NgG  <KB      2   vendor/symfony/security-http/Event/LogoutEvent.php  Ng        @   vendor/symfony/security-http/Event/TokenDeauthenticatedEvent.php  Ng  X2      D   vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php%  Ng%  ./ U      2   vendor/symfony/security-http/ParameterBagUtils.php  Ng  [7b      *   vendor/symfony/security-http/composer.json\  Ng\  7      :   vendor/symfony/security-http/SecurityRequestAttributes.php  Ng  J      J   vendor/symfony/security-http/EventListener/ClearSiteDataLogoutListener.php  Ng  jͤ      D   vendor/symfony/security-http/EventListener/SessionLogoutListener.php  Ng  t      D   vendor/symfony/security-http/EventListener/DefaultLogoutListener.phpm  Ngm        H   vendor/symfony/security-http/EventListener/PasswordMigratingListener.php  Ng  £פ      A   vendor/symfony/security-http/EventListener/RememberMeListener.php  Ng  vx.ʤ      F   vendor/symfony/security-http/EventListener/LoginThrottlingListener.php
  Ng
  L      C   vendor/symfony/security-http/EventListener/UserProviderListener.phpf  Ngf  6i      K   vendor/symfony/security-http/EventListener/CookieClearingLogoutListener.php  Ng  o[      G   vendor/symfony/security-http/EventListener/CheckCredentialsListener.php  Ng  );L      F   vendor/symfony/security-http/EventListener/SessionStrategyListener.php  Ng  Yؤ      N   vendor/symfony/security-http/EventListener/CsrfTokenClearingLogoutListener.phpp  Ngp  u      B   vendor/symfony/security-http/EventListener/UserCheckerListener.phpi  Ngi  g%      I   vendor/symfony/security-http/EventListener/IsGrantedAttributeListener.php  Ng  5D      E   vendor/symfony/security-http/EventListener/CsrfProtectionListener.php  Ng        P   vendor/symfony/security-http/EventListener/CheckRememberMeConditionsListener.php
  Ng
  wj      O   vendor/symfony/security-http/Session/SessionAuthenticationStrategyInterface.phpC  NgC  'ʤ      F   vendor/symfony/security-http/Session/SessionAuthenticationStrategy.php]  Ng]  Q         vendor/symfony/uid/UuidV8.phpK  NgK  {dL      !   vendor/symfony/uid/BinaryUtil.php-  Ng-   Ҥ         vendor/symfony/uid/NilUuid.php  Ng  MzĤ         vendor/symfony/uid/LICENSE,  Ng,  K         vendor/symfony/uid/NilUlid.php  Ng  [         vendor/symfony/uid/CHANGELOG.md  Ng        "   vendor/symfony/uid/AbstractUid.php[  Ng[  boO         vendor/symfony/uid/Ulid.phpP  NgP  ݤ         vendor/symfony/uid/Uuid.php  Ng  t0[O         vendor/symfony/uid/MaxUlid.php  Ng  >Z         vendor/symfony/uid/MaxUuid.php  Ng  Sw4         vendor/symfony/uid/README.md\  Ng\        2   vendor/symfony/uid/Command/GenerateUuidCommand.php(  Ng(  vF@      2   vendor/symfony/uid/Command/GenerateUlidCommand.php  Ng  ->      1   vendor/symfony/uid/Command/InspectUuidCommand.php
  Ng
  +}      1   vendor/symfony/uid/Command/InspectUlidCommand.php  Ng  0>Ȉ         vendor/symfony/uid/UuidV1.phpV  NgV  ʤ         vendor/symfony/uid/UuidV3.php^  Ng^  (L         vendor/symfony/uid/UuidV6.phpN  NgN  ͤ         vendor/symfony/uid/UuidV7.php  Ng  ,aä      3   vendor/symfony/uid/Factory/TimeBasedUuidFactory.php-  Ng-  i`mU      *   vendor/symfony/uid/Factory/UuidFactory.php>
  Ng>
   Xw      5   vendor/symfony/uid/Factory/RandomBasedUuidFactory.php[  Ng[  \(R      *   vendor/symfony/uid/Factory/UlidFactory.php  Ng  )ݿ      3   vendor/symfony/uid/Factory/NameBasedUuidFactory.php  Ng  0 A          vendor/symfony/uid/composer.json  Ng  s	ۤ      ,   vendor/symfony/uid/TimeBasedUidInterface.php  Ng  Q         vendor/symfony/uid/UuidV5.php^  Ng^  A         vendor/symfony/uid/UuidV4.php  Ng  <      <   vendor/symfony/event-dispatcher/EventDispatcherInterface.php  Ng  a      =   vendor/symfony/event-dispatcher/Attribute/AsEventListener.php  Ng  $      '   vendor/symfony/event-dispatcher/LICENSE,  Ng,  U      ,   vendor/symfony/event-dispatcher/CHANGELOG.md]  Ng]  uE~      3   vendor/symfony/event-dispatcher/EventDispatcher.php9#  Ng9#  ή&      )   vendor/symfony/event-dispatcher/README.mdW  NgW  ,fB      <   vendor/symfony/event-dispatcher/EventSubscriberInterface.php  Ng  A{)      <   vendor/symfony/event-dispatcher/ImmutableEventDispatcher.php  Ng  w      0   vendor/symfony/event-dispatcher/GenericEvent.php
  Ng
  d      M   vendor/symfony/event-dispatcher/DependencyInjection/RegisterListenersPass.php   Ng   i٤      K   vendor/symfony/event-dispatcher/DependencyInjection/AddEventAliasesPass.php  Ng  &{      -   vendor/symfony/event-dispatcher/composer.json  Ng  R      B   vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php0  Ng0  U*u      9   vendor/symfony/event-dispatcher/Debug/WrappedListener.php  Ng  okŤ      +   vendor/symfony/var-dumper/Cloner/Cursor.phpH  NgH  cq      .   vendor/symfony/var-dumper/Cloner/VarCloner.php)  Ng)  
      4   vendor/symfony/var-dumper/Cloner/ClonerInterface.php  Ng  ze      7   vendor/symfony/var-dumper/Cloner/Internal/NoDefault.php4  Ng4  ߞ      4   vendor/symfony/var-dumper/Cloner/DumperInterface.phpo  Ngo  k      3   vendor/symfony/var-dumper/Cloner/AbstractCloner.php]  Ng]  $^      )   vendor/symfony/var-dumper/Cloner/Data.php5  Ng5  G      )   vendor/symfony/var-dumper/Cloner/Stub.phpk  Ngk  Xܤ      !   vendor/symfony/var-dumper/LICENSE,  Ng,  .z      5   vendor/symfony/var-dumper/Test/VarDumperTestTrait.phpV
  NgV
  F      &   vendor/symfony/var-dumper/CHANGELOG.md	  Ng	  "D      .   vendor/symfony/var-dumper/Caster/GmpCaster.php
  Ng
  "       5   vendor/symfony/var-dumper/Caster/ReflectionCaster.php;  Ng;  -,      /   vendor/symfony/var-dumper/Caster/StubCaster.php	  Ng	  @v      2   vendor/symfony/var-dumper/Caster/SymfonyCaster.php
  Ng
  Ҥ      .   vendor/symfony/var-dumper/Caster/FrameStub.php  Ng  aa      7   vendor/symfony/var-dumper/Caster/ProxyManagerCaster.php#  Ng#  DJ      .   vendor/symfony/var-dumper/Caster/FFICaster.php  Ng  ь      /   vendor/symfony/var-dumper/Caster/DateCaster.php;  Ng;  C7>      .   vendor/symfony/var-dumper/Caster/PdoCaster.php  Ng  ɤ      6   vendor/symfony/var-dumper/Caster/XmlResourceCaster.php|	  Ng|	        3   vendor/symfony/var-dumper/Caster/ResourceCaster.php  Ng  ~      4   vendor/symfony/var-dumper/Caster/ExceptionCaster.phpmA  NgmA  SL      6   vendor/symfony/var-dumper/Caster/UninitializedStub.phpy  Ngy  0:      -   vendor/symfony/var-dumper/Caster/DsCaster.phpS  NgS  c      -   vendor/symfony/var-dumper/Caster/LinkStub.phpH
  NgH
  ϼ      4   vendor/symfony/var-dumper/Caster/MemcachedCaster.php  Ng  Y#g	      3   vendor/symfony/var-dumper/Caster/DoctrineCaster.phpG  NgG  55      2   vendor/symfony/var-dumper/Caster/RdKafkaCaster.php  Ng  9#      1   vendor/symfony/var-dumper/Caster/MysqliCaster.php  Ng        ,   vendor/symfony/var-dumper/Caster/ImgStub.php  Ng  ͤ      .   vendor/symfony/var-dumper/Caster/ClassStub.php?  Ng?  7V      .   vendor/symfony/var-dumper/Caster/TraceStub.php  Ng  _      1   vendor/symfony/var-dumper/Caster/CutArrayStub.php  Ng  QG      0   vendor/symfony/var-dumper/Caster/PgSqlCaster.phpj  Ngj  'K4      +   vendor/symfony/var-dumper/Caster/Caster.php*  Ng*  n      .   vendor/symfony/var-dumper/Caster/SplCaster.php]  Ng]  4Dӻ      .   vendor/symfony/var-dumper/Caster/ConstStub.php   Ng   3Ôk      /   vendor/symfony/var-dumper/Caster/ScalarStub.phpF  NgF  fA      /   vendor/symfony/var-dumper/Caster/DsPairStub.phpn  Ngn  0
      /   vendor/symfony/var-dumper/Caster/IntlCaster.php  Ng        0   vendor/symfony/var-dumper/Caster/RedisCaster.php  Ng  $OP      0   vendor/symfony/var-dumper/Caster/FiberCaster.phpf  Ngf  K      2   vendor/symfony/var-dumper/Caster/ImagineCaster.php  Ng  |gdߤ      /   vendor/symfony/var-dumper/Caster/AmqpCaster.phpH  NgH        .   vendor/symfony/var-dumper/Caster/DOMCaster.phpN  NgN  t      /   vendor/symfony/var-dumper/Caster/UuidCaster.php  Ng  E7      4   vendor/symfony/var-dumper/Caster/XmlReaderCaster.php  Ng  5      -   vendor/symfony/var-dumper/Caster/ArgsStub.php	  Ng	  O      -   vendor/symfony/var-dumper/Caster/EnumStub.php  Ng  `"      ,   vendor/symfony/var-dumper/Caster/CutStub.php  Ng        7   vendor/symfony/var-dumper/Resources/bin/var-dump-server  Ng  '      :   vendor/symfony/var-dumper/Resources/css/htmlDescriptor.css  Ng  Dva      8   vendor/symfony/var-dumper/Resources/js/htmlDescriptor.jsb  Ngb  h|      6   vendor/symfony/var-dumper/Resources/functions/dump.phpU  NgU  <      /   vendor/symfony/var-dumper/Server/Connection.php
  Ng
  xΤ      /   vendor/symfony/var-dumper/Server/DumpServer.php  Ng  U駤      #   vendor/symfony/var-dumper/README.md_  Ng_  Fq      7   vendor/symfony/var-dumper/Command/ServerDumpCommand.php  Ng  S+      H   vendor/symfony/var-dumper/Command/Descriptor/DumpDescriptorInterface.php  Ng  a*      >   vendor/symfony/var-dumper/Command/Descriptor/CliDescriptor.php
  Ng
  d      ?   vendor/symfony/var-dumper/Command/Descriptor/HtmlDescriptor.php  Ng  	      ?   vendor/symfony/var-dumper/Exception/ThrowingCasterException.php  Ng  ä      1   vendor/symfony/var-dumper/Dumper/ServerDumper.php  Ng  DZ      8   vendor/symfony/var-dumper/Dumper/DataDumperInterface.php@  Ng@  o/      M   vendor/symfony/var-dumper/Dumper/ContextProvider/ContextProviderInterface.php(  Ng(  EFf      K   vendor/symfony/var-dumper/Dumper/ContextProvider/RequestContextProvider.php  Ng  oꭤ      G   vendor/symfony/var-dumper/Dumper/ContextProvider/CliContextProvider.php  Ng  y9.L      J   vendor/symfony/var-dumper/Dumper/ContextProvider/SourceContextProvider.php  Ng  u      3   vendor/symfony/var-dumper/Dumper/AbstractDumper.php0  Ng0        .   vendor/symfony/var-dumper/Dumper/CliDumper.phpZ  NgZ  '      9   vendor/symfony/var-dumper/Dumper/ContextualizedDumper.php  Ng  U      /   vendor/symfony/var-dumper/Dumper/HtmlDumper.php<  Ng<   F      '   vendor/symfony/var-dumper/composer.jsonw  Ngw  %E      '   vendor/symfony/var-dumper/VarDumper.php  Ng  Ϥ      !   vendor/symfony/filesystem/LICENSE,  Ng,  U      &   vendor/symfony/filesystem/CHANGELOG.md  Ng  I      (   vendor/symfony/filesystem/Filesystem.phpt  Ngt  1      "   vendor/symfony/filesystem/Path.php
f  Ng
f  ׀s      #   vendor/symfony/filesystem/README.md  Ng        <   vendor/symfony/filesystem/Exception/IOExceptionInterface.php  Ng        :   vendor/symfony/filesystem/Exception/ExceptionInterface.php  Ng  (l`Ф      8   vendor/symfony/filesystem/Exception/RuntimeException.php  Ng  A      3   vendor/symfony/filesystem/Exception/IOException.php  Ng  0      @   vendor/symfony/filesystem/Exception/InvalidArgumentException.php  Ng  $
      =   vendor/symfony/filesystem/Exception/FileNotFoundException.php  Ng   [:      '   vendor/symfony/filesystem/composer.json{  Ng{  zq      G   vendor/symfony/security-csrf/TokenStorage/NativeSessionTokenStorage.php
  Ng
  .פ      A   vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.phpK  NgK  <_      L   vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php3  Ng3        C   vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php  Ng  7䭤      $   vendor/symfony/security-csrf/LICENSE,  Ng,  U      )   vendor/symfony/security-csrf/CHANGELOG.md  Ng  >*      *   vendor/symfony/security-csrf/CsrfToken.php  Ng  3      &   vendor/symfony/security-csrf/README.md  Ng        :   vendor/symfony/security-csrf/CsrfTokenManagerInterface.php  Ng  yɤ      E   vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php  Ng  1      G   vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php  Ng  <xx      1   vendor/symfony/security-csrf/CsrfTokenManager.php  Ng  Zؤ      A   vendor/symfony/security-csrf/Exception/TokenNotFoundException.php  Ng   U      *   vendor/symfony/security-csrf/composer.json  Ng  -      ,   vendor/symfony/polyfill-uuid/bootstrap80.php  Ng  jx      $   vendor/symfony/polyfill-uuid/LICENSE,  Ng,        %   vendor/symfony/polyfill-uuid/Uuid.phpqB  NgqB  E      *   vendor/symfony/polyfill-uuid/bootstrap.php#  Ng#  )      &   vendor/symfony/polyfill-uuid/README.md[  Ng[  Ƥ      *   vendor/symfony/polyfill-uuid/composer.json  Ng  {Ĥ      7   vendor/symfony/polyfill-intl-normalizer/bootstrap80.php  Ng  ,      /   vendor/symfony/polyfill-intl-normalizer/LICENSE,  Ng,  H      6   vendor/symfony/polyfill-intl-normalizer/Normalizer.php8$  Ng8$  &(C      F   vendor/symfony/polyfill-intl-normalizer/Resources/stubs/Normalizer.php  Ng  %      L   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/combiningClass.php.  Ng.  Cb      T   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalDecomposition.phpx  Ngx        R   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalComposition.php=  Ng=  V{      X   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/compatibilityDecomposition.php  Ng  [
+      5   vendor/symfony/polyfill-intl-normalizer/bootstrap.php  Ng  #p      1   vendor/symfony/polyfill-intl-normalizer/README.md  Ng  +tK      5   vendor/symfony/polyfill-intl-normalizer/composer.jsonx  Ngx        F   vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php,  Ng,  ۃf      3   vendor/symfony/event-dispatcher-contracts/Event.php  Ng  +Vg      1   vendor/symfony/event-dispatcher-contracts/LICENSE,  Ng,        6   vendor/symfony/event-dispatcher-contracts/CHANGELOG.md   Ng   h{#      3   vendor/symfony/event-dispatcher-contracts/README.mdZ  NgZ  9{Am      7   vendor/symfony/event-dispatcher-contracts/composer.json?  Ng?  O*      8   vendor/symfony/property-access/PropertyPathInterface.php  Ng  z      7   vendor/symfony/property-access/PropertyPathIterator.php  Ng  ax      &   vendor/symfony/property-access/LICENSE,  Ng,  U      @   vendor/symfony/property-access/PropertyPathIteratorInterface.php  Ng  
M      +   vendor/symfony/property-access/CHANGELOG.md
  Ng
  <4      <   vendor/symfony/property-access/PropertyAccessorInterface.php  Ng  {Q      /   vendor/symfony/property-access/PropertyPath.php  Ng  cA      :   vendor/symfony/property-access/PropertyAccessorBuilder.php  Ng  0l      (   vendor/symfony/property-access/README.md1  Ng1  !Q      3   vendor/symfony/property-access/PropertyAccessor.phpq{  Ngq{  UBp      1   vendor/symfony/property-access/PropertyAccess.php  Ng        6   vendor/symfony/property-access/PropertyPathBuilder.php!  Ng!  2{      <   vendor/symfony/property-access/Exception/AccessException.php  Ng  KW      K   vendor/symfony/property-access/Exception/UninitializedPropertyException.php  Ng  ,      ?   vendor/symfony/property-access/Exception/ExceptionInterface.php  Ng  l      A   vendor/symfony/property-access/Exception/OutOfBoundsException.php  Ng  ؤ      =   vendor/symfony/property-access/Exception/RuntimeException.php  Ng  Cn      E   vendor/symfony/property-access/Exception/InvalidArgumentException.php  Ng  IF[3      I   vendor/symfony/property-access/Exception/InvalidPropertyPathException.php  Ng  zޤ      D   vendor/symfony/property-access/Exception/UnexpectedTypeException.phpy  Ngy  bR      A   vendor/symfony/property-access/Exception/NoSuchIndexException.php  Ng  NQp      D   vendor/symfony/property-access/Exception/NoSuchPropertyException.php  Ng  ?      ,   vendor/symfony/property-access/composer.json~  Ng~        %   vendor/symfony/finder/SplFileInfo.php  Ng  9$̤      5   vendor/symfony/finder/Comparator/NumberComparator.php
  Ng
        /   vendor/symfony/finder/Comparator/Comparator.php  Ng  @x      3   vendor/symfony/finder/Comparator/DateComparator.php  Ng  ~Q          vendor/symfony/finder/Finder.phpc  Ngc  v>         vendor/symfony/finder/LICENSE,  Ng,  U      "   vendor/symfony/finder/CHANGELOG.md
  Ng
  3g         vendor/symfony/finder/Glob.php2  Ng2  A         vendor/symfony/finder/README.md  Ng  C      /   vendor/symfony/finder/Iterator/LazyIterator.php  Ng  Wđ      ;   vendor/symfony/finder/Iterator/VcsIgnoredFilterIterator.php'  Ng'  n!      <   vendor/symfony/finder/Iterator/FilecontentFilterIterator.php  Ng  \v:c      =   vendor/symfony/finder/Iterator/MultiplePcreFilterIterator.php  Ng  N      :   vendor/symfony/finder/Iterator/SizeRangeFilterIterator.phpk  Ngk  4-      9   vendor/symfony/finder/Iterator/FilenameFilterIterator.phpn  Ngn  MNQ      :   vendor/symfony/finder/Iterator/DateRangeFilterIterator.php  Ng  9z֤      7   vendor/symfony/finder/Iterator/CustomFilterIterator.php  Ng  	ʤ      =   vendor/symfony/finder/Iterator/RecursiveDirectoryIterator.phpO  NgO        A   vendor/symfony/finder/Iterator/ExcludeDirectoryFilterIterator.php5
  Ng5
  `      3   vendor/symfony/finder/Iterator/SortableIterator.php3  Ng3  뛽       ;   vendor/symfony/finder/Iterator/DepthRangeFilterIterator.phpn  Ngn  O      9   vendor/symfony/finder/Iterator/FileTypeFilterIterator.php|  Ng|  Aj      5   vendor/symfony/finder/Iterator/PathFilterIterator.php  Ng  (      #   vendor/symfony/finder/Gitignore.php  Ng  Q)      9   vendor/symfony/finder/Exception/AccessDeniedException.php  Ng        >   vendor/symfony/finder/Exception/DirectoryNotFoundException.php  Ng  )      #   vendor/symfony/finder/composer.json*  Ng*  _      -   vendor/symfony/polyfill-php83/bootstrap81.php  Ng  p$      %   vendor/symfony/polyfill-php83/LICENSE,  Ng,  t=      B   vendor/symfony/polyfill-php83/Resources/stubs/SQLite3Exception.phpH  NgH  <ܐ      ;   vendor/symfony/polyfill-php83/Resources/stubs/DateError.php=  Ng=  ˤ      :   vendor/symfony/polyfill-php83/Resources/stubs/Override.php  Ng  NsE      ?   vendor/symfony/polyfill-php83/Resources/stubs/DateException.phpE  NgE        O   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidOperationException.phpY  NgY  Mߤ      A   vendor/symfony/polyfill-php83/Resources/stubs/DateObjectError.phpG  NgG  
.I      T   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedPeriodStringException.php^  Ng^  K      N   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedStringException.phpX  NgX  Wߤ      @   vendor/symfony/polyfill-php83/Resources/stubs/DateRangeError.phpF  NgF  L;      N   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidTimeZoneException.phpX  NgX  g      V   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedIntervalStringException.php`  Ng`  6      +   vendor/symfony/polyfill-php83/bootstrap.php  Ng  {Jc      '   vendor/symfony/polyfill-php83/README.md  Ng  }      '   vendor/symfony/polyfill-php83/Php83.php
  Ng
  \9>      +   vendor/symfony/polyfill-php83/composer.json  Ng  {V      >   vendor/symfony/http-kernel/DataCollector/DumpDataCollector.php%+  Ng%+  p	q      @   vendor/symfony/http-kernel/DataCollector/MemoryDataCollector.php  Ng  ]%      G   vendor/symfony/http-kernel/DataCollector/LateDataCollectorInterface.php/  Ng/  D
      @   vendor/symfony/http-kernel/DataCollector/RouterDataCollector.php	  Ng	  W}}      >   vendor/symfony/http-kernel/DataCollector/TimeDataCollector.php
  Ng
  R       C   vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php  Ng        A   vendor/symfony/http-kernel/DataCollector/RequestDataCollector.phpo>  Ngo>  se      >   vendor/symfony/http-kernel/DataCollector/AjaxDataCollector.phpl  Ngl  kD      :   vendor/symfony/http-kernel/DataCollector/DataCollector.phpB  NgB  r      @   vendor/symfony/http-kernel/DataCollector/LoggerDataCollector.phpV)  NgV)  >W      @   vendor/symfony/http-kernel/DataCollector/ConfigDataCollector.php<  Ng<        ?   vendor/symfony/http-kernel/DataCollector/EventDataCollector.phpG  NgG  Jݤ      C   vendor/symfony/http-kernel/DataCollector/ExceptionDataCollector.phpU  NgU  	      5   vendor/symfony/http-kernel/Attribute/AsController.php  Ng  UT      @   vendor/symfony/http-kernel/Attribute/AsTargetedValueResolver.php
  Ng
  w      .   vendor/symfony/http-kernel/Attribute/Cache.phpX
  NgX
  LҌ      7   vendor/symfony/http-kernel/Attribute/MapQueryString.php  Ng  u~      7   vendor/symfony/http-kernel/Attribute/WithHttpStatus.php^  Ng^  
      4   vendor/symfony/http-kernel/Attribute/MapDateTime.php   Ng   j      :   vendor/symfony/http-kernel/Attribute/MapRequestPayload.php)  Ng)  -"y      5   vendor/symfony/http-kernel/Attribute/WithLogLevel.php  Ng  FH      6   vendor/symfony/http-kernel/Attribute/ValueResolver.php  Ng  \      :   vendor/symfony/http-kernel/Attribute/MapQueryParameter.php\  Ng\  %      "   vendor/symfony/http-kernel/LICENSE,  Ng,  U      R   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php  Ng  ͞1      B   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadata.php  Ng  S      I   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php  Ng  D{\Ǥ      '   vendor/symfony/http-kernel/CHANGELOG.mdQ  NgQ        1   vendor/symfony/http-kernel/Config/FileLocator.phpw  Ngw        /   vendor/symfony/http-kernel/HttpClientKernel.php  Ng  u*D      2   vendor/symfony/http-kernel/TerminableInterface.php  Ng        A   vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php*  Ng*  雗      =   vendor/symfony/http-kernel/CacheClearer/ChainCacheClearer.phpJ  NgJ  7      <   vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php  Ng  r2      5   vendor/symfony/http-kernel/Resources/welcome.html.php  Ng  i      )   vendor/symfony/http-kernel/HttpKernel.php-  Ng-  ¤      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerAggregate.php  Ng  Q      6   vendor/symfony/http-kernel/CacheWarmer/CacheWarmer.php  Ng  QĤ      <   vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php3  Ng3  P@ˤ      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerInterface.php  Ng  {w]b      ,   vendor/symfony/http-kernel/Bundle/Bundle.php  Ng  ~o      5   vendor/symfony/http-kernel/Bundle/BundleInterface.php  Ng  "z      4   vendor/symfony/http-kernel/Bundle/AbstractBundle.php  Ng  |`      5   vendor/symfony/http-kernel/Bundle/BundleExtension.php	  Ng	  Y]=      .   vendor/symfony/http-kernel/KernelInterface.php  Ng  J:      :   vendor/symfony/http-kernel/Controller/ArgumentResolver.php  Ng  <n      =   vendor/symfony/http-kernel/Controller/ControllerReference.php5  Ng5  Ul      9   vendor/symfony/http-kernel/Controller/ErrorController.php>  Ng>  B      E   vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php  Ng  f      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/VariadicValueResolver.php@  Ng@  S      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/ServiceValueResolver.php|  Ng|  wS      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/DefaultValueResolver.php  Ng  ^(2      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/QueryParameterValueResolver.php  Ng  g,      K   vendor/symfony/http-kernel/Controller/ArgumentResolver/UidValueResolver.php  Ng  ybޤ      R   vendor/symfony/http-kernel/Controller/ArgumentResolver/BackedEnumValueResolver.php0  Ng0  Ns      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestPayloadValueResolver.phpD"  NgD"  rn      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/DateTimeValueResolver.php
  Ng
  7      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestValueResolver.php  Ng  05      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/SessionValueResolver.php  Ng  o      X   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestAttributeValueResolver.php  Ng  q?柤      [   vendor/symfony/http-kernel/Controller/ArgumentResolver/NotTaggedControllerValueResolver.php:
  Ng:
  <      Q   vendor/symfony/http-kernel/Controller/ArgumentResolver/TraceableValueResolver.php3  Ng3  8?      C   vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.phpt  Ngt  q/m      E   vendor/symfony/http-kernel/Controller/ControllerResolverInterface.phpy  Ngy  5ݰʤ      C   vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.php  Ng  D      @   vendor/symfony/http-kernel/Controller/ValueResolverInterface.php  Ng  @9      <   vendor/symfony/http-kernel/Controller/ControllerResolver.php0(  Ng0(  7nl      E   vendor/symfony/http-kernel/Controller/TraceableControllerResolver.phpJ  NgJ  #@      H   vendor/symfony/http-kernel/Controller/ArgumentValueResolverInterface.php  Ng  %      $   vendor/symfony/http-kernel/README.md  Ng  7      E   vendor/symfony/http-kernel/Fragment/FragmentUriGeneratorInterface.php:  Ng:  Ze      >   vendor/symfony/http-kernel/Fragment/InlineFragmentRenderer.php  Ng  b^b      ;   vendor/symfony/http-kernel/Fragment/SsiFragmentRenderer.php%  Ng%  	      I   vendor/symfony/http-kernel/Fragment/AbstractSurrogateFragmentRenderer.php  Ng  ,J      A   vendor/symfony/http-kernel/Fragment/FragmentRendererInterface.php  Ng  Ǜ<      <   vendor/symfony/http-kernel/Fragment/FragmentUriGenerator.php$  Ng$        ;   vendor/symfony/http-kernel/Fragment/EsiFragmentRenderer.php%  Ng%  p      @   vendor/symfony/http-kernel/Fragment/HIncludeFragmentRenderer.php/
  Ng/
  r0      7   vendor/symfony/http-kernel/Fragment/FragmentHandler.php  Ng  <̤      @   vendor/symfony/http-kernel/Fragment/RoutableFragmentRenderer.php+  Ng+  rT      +   vendor/symfony/http-kernel/KernelEvents.phpd  Ngd  Z$      ,   vendor/symfony/http-kernel/HttpCache/Esi.php
  Ng
  
K\      2   vendor/symfony/http-kernel/HttpCache/HttpCache.phpk  Ngk  J      .   vendor/symfony/http-kernel/HttpCache/Store.php9  Ng9  j=      ;   vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php  Ng  r      G   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategyInterface.php:  Ng:  )Ou      >   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategy.php!  Ng!  t      7   vendor/symfony/http-kernel/HttpCache/StoreInterface.php  Ng  +      ,   vendor/symfony/http-kernel/HttpCache/Ssi.phpR
  NgR
  Y      :   vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php  Ng  ڄ      :   vendor/symfony/http-kernel/HttpCache/SubRequestHandler.php1  Ng1  イ      2   vendor/symfony/http-kernel/HttpKernelInterface.php  Ng   Z      )   vendor/symfony/http-kernel/Log/Logger.php2  Ng2  Y8X      7   vendor/symfony/http-kernel/Log/DebugLoggerInterface.phpD  NgD  'V      :   vendor/symfony/http-kernel/Log/DebugLoggerConfigurator.phpH  NgH  ,      ;   vendor/symfony/http-kernel/Profiler/FileProfilerStorage.php(  Ng(  |r      /   vendor/symfony/http-kernel/Profiler/Profile.phpo  Ngo   #      0   vendor/symfony/http-kernel/Profiler/Profiler.php  Ng  27ya      @   vendor/symfony/http-kernel/Profiler/ProfilerStorageInterface.php  Ng  0Ĥ      G   vendor/symfony/http-kernel/DependencyInjection/FragmentRendererPass.php  Ng  P      C   vendor/symfony/http-kernel/DependencyInjection/ServicesResetter.php  Ng  /v      R   vendor/symfony/http-kernel/DependencyInjection/RegisterLocaleAwareServicesPass.php  Ng  2@      H   vendor/symfony/http-kernel/DependencyInjection/ResettableServicePass.php  Ng  &ˏ      R   vendor/symfony/http-kernel/DependencyInjection/MergeExtensionConfigurationPass.php  Ng  T
      Q   vendor/symfony/http-kernel/DependencyInjection/AddAnnotatedClassesToCachePass.php  Ng  :      H   vendor/symfony/http-kernel/DependencyInjection/ConfigurableExtension.php  Ng  6v      =   vendor/symfony/http-kernel/DependencyInjection/LoggerPass.php)  Ng)  Q*      <   vendor/symfony/http-kernel/DependencyInjection/Extension.php_  Ng_  ʍ/      V   vendor/symfony/http-kernel/DependencyInjection/ControllerArgumentValueResolverPass.phpY  NgY  FT      Y   vendor/symfony/http-kernel/DependencyInjection/RegisterControllerArgumentLocatorsPass.php.  Ng.  zM      \   vendor/symfony/http-kernel/DependencyInjection/RemoveEmptyControllerArgumentLocatorsPass.php
  Ng
  5
դ      M   vendor/symfony/http-kernel/DependencyInjection/LazyLoadingFragmentHandler.php  Ng        E   vendor/symfony/http-kernel/Exception/TooManyRequestsHttpException.php  Ng  <      >   vendor/symfony/http-kernel/Exception/ConflictHttpException.phpc  Ngc        6   vendor/symfony/http-kernel/Exception/HttpException.phpN  NgN  դ      B   vendor/symfony/http-kernel/Exception/UnauthorizedHttpException.php  Ng  8      A   vendor/symfony/http-kernel/Exception/InvalidMetadataException.phpj  Ngj  ;녤      D   vendor/symfony/http-kernel/Exception/LengthRequiredHttpException.phpi  Ngi  
l      I   vendor/symfony/http-kernel/Exception/UnprocessableEntityHttpException.phpw  Ngw  3      H   vendor/symfony/http-kernel/Exception/PreconditionFailedHttpException.phpm  Ngm  m%      :   vendor/symfony/http-kernel/Exception/GoneHttpException.php_  Ng_  ey      J   vendor/symfony/http-kernel/Exception/UnsupportedMediaTypeHttpException.phpo  Ngo  aM}      H   vendor/symfony/http-kernel/Exception/UnexpectedSessionUsageException.php  Ng  Zis      <   vendor/symfony/http-kernel/Exception/LockedHttpException.phpe  Nge  peh      H   vendor/symfony/http-kernel/Exception/ServiceUnavailableHttpException.phpm  Ngm  =      ?   vendor/symfony/http-kernel/Exception/HttpExceptionInterface.php}  Ng}  ֚5      B   vendor/symfony/http-kernel/Exception/AccessDeniedHttpException.php  Ng  6HHg      @   vendor/symfony/http-kernel/Exception/BadRequestHttpException.phpe  Nge  Ց      Q   vendor/symfony/http-kernel/Exception/ControllerDoesNotReturnResponseException.php  Ng  t<
e      C   vendor/symfony/http-kernel/Exception/NotAcceptableHttpException.phph  Ngh  (ޤ      J   vendor/symfony/http-kernel/Exception/PreconditionRequiredHttpException.php  Ng  cԤ      >   vendor/symfony/http-kernel/Exception/NotFoundHttpException.phpj  Ngj  Vz      F   vendor/symfony/http-kernel/Exception/MethodNotAllowedHttpException.php  Ng  iנ      B   vendor/symfony/http-kernel/Exception/ResolverNotFoundException.php  Ng  y	+      4   vendor/symfony/http-kernel/Event/ControllerEvent.phpj  Ngj  w.Ƥ      3   vendor/symfony/http-kernel/Event/ExceptionEvent.php  Ng  p-      7   vendor/symfony/http-kernel/Event/FinishRequestEvent.php  Ng  TY      2   vendor/symfony/http-kernel/Event/ResponseEvent.php  Ng  ,7      3   vendor/symfony/http-kernel/Event/TerminateEvent.php  Ng  VC      =   vendor/symfony/http-kernel/Event/ControllerArgumentsEvent.php  Ng  nT      0   vendor/symfony/http-kernel/Event/KernelEvent.php  Ng  DBc      1   vendor/symfony/http-kernel/Event/RequestEvent.php  Ng  ׁ      .   vendor/symfony/http-kernel/Event/ViewEvent.php  Ng        (   vendor/symfony/http-kernel/composer.jsonm  Ngm  -m      2   vendor/symfony/http-kernel/RebootableInterface.php<  Ng<  pLX1      %   vendor/symfony/http-kernel/Kernel.phpw  Ngw  >      (   vendor/symfony/http-kernel/UriSigner.php  Ng  2[{      8   vendor/symfony/http-kernel/Debug/VirtualRequestStack.phpI  NgI  U&      =   vendor/symfony/http-kernel/Debug/ErrorHandlerConfigurator.php  Ng  P      =   vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.phps
  Ngs
  |      6   vendor/symfony/http-kernel/Debug/FileLinkFormatter.php  Ng        0   vendor/symfony/http-kernel/HttpKernelBrowser.php  Ng  i\      E   vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php  Ng  }>Ť      =   vendor/symfony/http-kernel/EventListener/ResponseListener.php  Ng  PUȤ      ;   vendor/symfony/http-kernel/EventListener/LocaleListener.php  Ng  7)<      =   vendor/symfony/http-kernel/EventListener/FragmentListener.php8  Ng8  v      C   vendor/symfony/http-kernel/EventListener/CacheAttributeListener.php1  Ng1  ۤ      D   vendor/symfony/http-kernel/EventListener/AbstractSessionListener.phpd0  Ngd0  o!      D   vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php  Ng  x      K   vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.phpo  Ngo  >JȤ      F   vendor/symfony/http-kernel/EventListener/AddRequestFormatsListener.php  Ng  q       =   vendor/symfony/http-kernel/EventListener/ProfilerListener.php<  Ng<  <3W      >   vendor/symfony/http-kernel/EventListener/SurrogateListener.phpU  NgU  M      B   vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php  Ng  n      @   vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php	  Ng	        9   vendor/symfony/http-kernel/EventListener/DumpListener.php%  Ng%  ۤ      :   vendor/symfony/http-kernel/EventListener/ErrorListener.php!  Ng!  	O      <   vendor/symfony/http-kernel/EventListener/SessionListener.php  Ng        ;   vendor/symfony/http-kernel/EventListener/RouterListener.php  Ng  G]9         vendor/symfony/yaml/LICENSE,  Ng,  U         vendor/symfony/yaml/Parser.phpI  NgI  qŤ          vendor/symfony/yaml/CHANGELOG.md  Ng  Ĥ         vendor/symfony/yaml/Escaper.php  Ng  
      +   vendor/symfony/yaml/Resources/bin/yaml-lint  Ng  3VԈ         vendor/symfony/yaml/README.md  Ng  ـT      !   vendor/symfony/yaml/Unescaper.phpK  NgK   脱         vendor/symfony/yaml/Dumper.php  Ng  h         vendor/symfony/yaml/Inline.php  Ng  Xwt         vendor/symfony/yaml/Yaml.php  Ng  LϽ      +   vendor/symfony/yaml/Command/LintCommand.php'  Ng'  te      /   vendor/symfony/yaml/Exception/DumpException.php  Ng  ?<̤      4   vendor/symfony/yaml/Exception/ExceptionInterface.php  Ng  ,P      2   vendor/symfony/yaml/Exception/RuntimeException.php  Ng  #OU      0   vendor/symfony/yaml/Exception/ParseException.php  Ng  mFB      '   vendor/symfony/yaml/Tag/TaggedValue.php  Ng  s$      !   vendor/symfony/yaml/composer.json  Ng   Zܦ      )   vendor/symfony/string/CodePointString.phpN  NgN  J         vendor/symfony/string/LICENSE,  Ng,  զ_Ϥ      "   vendor/symfony/string/CHANGELOG.mdz  Ngz  ub      (   vendor/symfony/string/AbstractString.phpI  NgI  k      -   vendor/symfony/string/Resources/functions.phpc  Ngc  Ȥ      <   vendor/symfony/string/Resources/data/wcswidth_table_zero.phpF  NgF  MI      <   vendor/symfony/string/Resources/data/wcswidth_table_wide.phpk  Ngk  /      3   vendor/symfony/string/Inflector/FrenchInflector.php  Ng  Q      6   vendor/symfony/string/Inflector/InflectorInterface.phpR  NgR  _      4   vendor/symfony/string/Inflector/EnglishInflector.phpC  NgC  Q~         vendor/symfony/string/README.md+  Ng+  L      /   vendor/symfony/string/AbstractUnicodeString.phppb  Ngpb  c|Q      $   vendor/symfony/string/LazyString.php  Ng        $   vendor/symfony/string/ByteString.phpv9  Ngv9  }      '   vendor/symfony/string/UnicodeString.php1  Ng1        6   vendor/symfony/string/Exception/ExceptionInterface.php_  Ng_  :      4   vendor/symfony/string/Exception/RuntimeException.php~  Ng~  )Ʉ      <   vendor/symfony/string/Exception/InvalidArgumentException.php  Ng  B;8      #   vendor/symfony/string/composer.json  Ng  #      2   vendor/symfony/string/Slugger/SluggerInterface.php  Ng        .   vendor/symfony/string/Slugger/AsciiSlugger.php  Ng  [=M      4   vendor/symfony/security-core/Role/SwitchUserRole.php  Ng  'v      <   vendor/symfony/security-core/Role/RoleHierarchyInterface.php]  Ng]  Բ'      *   vendor/symfony/security-core/Role/Role.php  Ng  i֜      3   vendor/symfony/security-core/Role/RoleHierarchy.php  Ng  UՈ      C   vendor/symfony/security-core/Validator/Constraints/UserPassword.php"  Ng"  <0      L   vendor/symfony/security-core/Validator/Constraints/UserPasswordValidator.php~
  Ng~
  ^      $   vendor/symfony/security-core/LICENSE,  Ng,  U      D   vendor/symfony/security-core/Test/AccessDecisionStrategyTestCase.php	  Ng	  A      B   vendor/symfony/security-core/Signature/ExpiredSignatureStorage.php  Ng  `5      N   vendor/symfony/security-core/Signature/Exception/InvalidSignatureException.php  Ng  [.ܤ      N   vendor/symfony/security-core/Signature/Exception/ExpiredSignatureException.php  Ng  (:      :   vendor/symfony/security-core/Signature/SignatureHasher.php  Ng  d5A      )   vendor/symfony/security-core/CHANGELOG.md  Ng  &      C   vendor/symfony/security-core/Resources/translations/security.sq.xlfS  NgS  B&^      C   vendor/symfony/security-core/Resources/translations/security.ru.xlf  Ng  m      C   vendor/symfony/security-core/Resources/translations/security.hy.xlf  Ng  B      C   vendor/symfony/security-core/Resources/translations/security.fr.xlfU  NgU  $      C   vendor/symfony/security-core/Resources/translations/security.fa.xlf  Ng  IѤ      C   vendor/symfony/security-core/Resources/translations/security.pl.xlf  Ng  u      C   vendor/symfony/security-core/Resources/translations/security.sv.xlf  Ng  cn      C   vendor/symfony/security-core/Resources/translations/security.el.xlf8  Ng8  yva      H   vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf  Ng        C   vendor/symfony/security-core/Resources/translations/security.en.xlfl  Ngl  gBZ      C   vendor/symfony/security-core/Resources/translations/security.ja.xlf  Ng  H      F   vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf  Ng  iH!      C   vendor/symfony/security-core/Resources/translations/security.no.xlf  Ng  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.vi.xlf,  Ng,  a      C   vendor/symfony/security-core/Resources/translations/security.ur.xlf  Ng  g      C   vendor/symfony/security-core/Resources/translations/security.nn.xlf  Ng  l      C   vendor/symfony/security-core/Resources/translations/security.nl.xlf  Ng  "֤      C   vendor/symfony/security-core/Resources/translations/security.cy.xlfv  Ngv  FŤ      C   vendor/symfony/security-core/Resources/translations/security.af.xlf  Ng  ojo      C   vendor/symfony/security-core/Resources/translations/security.lv.xlfc  Ngc  @ۤ      C   vendor/symfony/security-core/Resources/translations/security.ar.xlf  Ng  OD      C   vendor/symfony/security-core/Resources/translations/security.lb.xlf)  Ng)  z7      C   vendor/symfony/security-core/Resources/translations/security.tr.xlf  Ng  0˵      C   vendor/symfony/security-core/Resources/translations/security.lt.xlfv  Ngv  @Ȥ      F   vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf  Ng  D      C   vendor/symfony/security-core/Resources/translations/security.ca.xlf  Ng  
      C   vendor/symfony/security-core/Resources/translations/security.be.xlf.  Ng.  
ZZ      C   vendor/symfony/security-core/Resources/translations/security.th.xlf  Ng  x=ݤ      C   vendor/symfony/security-core/Resources/translations/security.uz.xlfl  Ngl  M      C   vendor/symfony/security-core/Resources/translations/security.mk.xlf  Ng  ڞ      C   vendor/symfony/security-core/Resources/translations/security.bs.xlf  Ng  %}o      C   vendor/symfony/security-core/Resources/translations/security.bg.xlf  Ng  d캤      H   vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf6  Ng6  dξ      C   vendor/symfony/security-core/Resources/translations/security.uk.xlf  Ng  6V      F   vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf  Ng  Ȉf      C   vendor/symfony/security-core/Resources/translations/security.cs.xlf  Ng  S0k3      C   vendor/symfony/security-core/Resources/translations/security.tl.xlf  Ng  %$      C   vendor/symfony/security-core/Resources/translations/security.my.xlf  Ng  [v      C   vendor/symfony/security-core/Resources/translations/security.nb.xlf  Ng  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.mn.xlf  Ng  އ      C   vendor/symfony/security-core/Resources/translations/security.az.xlf^  Ng^  9      C   vendor/symfony/security-core/Resources/translations/security.eu.xlf  Ng  bs`      C   vendor/symfony/security-core/Resources/translations/security.he.xlfh  Ngh  u      C   vendor/symfony/security-core/Resources/translations/security.hr.xlf[  Ng[        C   vendor/symfony/security-core/Resources/translations/security.pt.xlf  Ng  5>      C   vendor/symfony/security-core/Resources/translations/security.et.xlf  Ng  s      C   vendor/symfony/security-core/Resources/translations/security.de.xlfV  NgV  :      C   vendor/symfony/security-core/Resources/translations/security.sl.xlf  Ng  A      C   vendor/symfony/security-core/Resources/translations/security.it.xlf  Ng  a      C   vendor/symfony/security-core/Resources/translations/security.gl.xlf8  Ng8  Ϗ      C   vendor/symfony/security-core/Resources/translations/security.es.xlfQ  NgQ  cP)      C   vendor/symfony/security-core/Resources/translations/security.hu.xlf:  Ng:  KY      C   vendor/symfony/security-core/Resources/translations/security.da.xlf  Ng  mm      C   vendor/symfony/security-core/Resources/translations/security.fi.xlf  Ng   T      C   vendor/symfony/security-core/Resources/translations/security.id.xlf  Ng  x"      C   vendor/symfony/security-core/Resources/translations/security.sk.xlf  Ng  ^P      C   vendor/symfony/security-core/Resources/translations/security.ro.xlfy  Ngy  Aze      J   vendor/symfony/security-core/User/AttributesBasedUserProviderInterface.phpN  NgN  u      .   vendor/symfony/security-core/User/OidcUser.php  Ng        9   vendor/symfony/security-core/User/InMemoryUserChecker.php  Ng  l      3   vendor/symfony/security-core/User/UserInterface.php<  Ng<  l      ;   vendor/symfony/security-core/User/UserProviderInterface.phpI	  NgI	  ̤      9   vendor/symfony/security-core/User/MissingUserProvider.php  Ng  E      6   vendor/symfony/security-core/User/ChainUserChecker.phpd  Ngd  OϤ      N   vendor/symfony/security-core/User/LegacyPasswordAuthenticatedUserInterface.php1  Ng1  ,      ?   vendor/symfony/security-core/User/PasswordUpgraderInterface.php  Ng  }m      2   vendor/symfony/security-core/User/InMemoryUser.phpX  NgX  H      :   vendor/symfony/security-core/User/InMemoryUserProvider.php  Ng  ,aR      8   vendor/symfony/security-core/User/EquatableInterface.phpm  Ngm  C      H   vendor/symfony/security-core/User/PasswordAuthenticatedUserInterface.php  Ng  hΤ      :   vendor/symfony/security-core/User/UserCheckerInterface.phpb  Ngb  P      7   vendor/symfony/security-core/User/ChainUserProvider.php	  Ng	         &   vendor/symfony/security-core/README.md  Ng  {u!      L   vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php2  Ng2  O      I   vendor/symfony/security-core/Authorization/ExpressionLanguageProvider.phpV  NgV  @)5      M   vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php
  Ng
  T(      D   vendor/symfony/security-core/Authorization/AccessDecisionManager.phpl  Ngl  0ո      M   vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php}  Ng}  ,t      C   vendor/symfony/security-core/Authorization/Voter/VoterInterface.php  Ng  ])      L   vendor/symfony/security-core/Authorization/Voter/CacheableVoterInterface.php~  Ng~  9      D   vendor/symfony/security-core/Authorization/Voter/ExpressionVoter.php3
  Ng3
        G   vendor/symfony/security-core/Authorization/Voter/RoleHierarchyVoter.phpl  Ngl  H??      C   vendor/symfony/security-core/Authorization/Voter/TraceableVoter.php)  Ng)  'J      :   vendor/symfony/security-core/Authorization/Voter/Voter.phpf  Ngf  5~      >   vendor/symfony/security-core/Authorization/Voter/RoleVoter.php  Ng  Pj^      G   vendor/symfony/security-core/Authorization/Voter/AuthenticatedVoter.phpC  NgC  A      A   vendor/symfony/security-core/Authorization/ExpressionLanguage.php  Ng  8Cy      C   vendor/symfony/security-core/Authorization/AuthorizationChecker.php  Ng  w      H   vendor/symfony/security-core/Authorization/Strategy/PriorityStrategy.php  Ng   7^      I   vendor/symfony/security-core/Authorization/Strategy/UnanimousStrategy.php/  Ng/        K   vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php  Ng  
م      I   vendor/symfony/security-core/Authorization/Strategy/ConsensusStrategy.php  Ng  դ      W   vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php]  Ng]  pf      )   vendor/symfony/security-core/Security.php
	  Ng
	        @   vendor/symfony/security-core/Exception/AccessDeniedException.phpZ  NgZ  pth      D   vendor/symfony/security-core/Exception/InvalidCsrfTokenException.php}  Ng}  O      :   vendor/symfony/security-core/Exception/LogoutException.php  Ng  y'פ      9   vendor/symfony/security-core/Exception/LogicException.php  Ng  $2      @   vendor/symfony/security-core/Exception/LazyResponseException.php  Ng  .'      S   vendor/symfony/security-core/Exception/CustomUserMessageAuthenticationException.php	  Ng	  qHV      =   vendor/symfony/security-core/Exception/ExceptionInterface.php  Ng  ^      B   vendor/symfony/security-core/Exception/BadCredentialsException.php  Ng  h	      ;   vendor/symfony/security-core/Exception/RuntimeException.php  Ng  >
      <   vendor/symfony/security-core/Exception/DisabledException.phpv  Ngv  Ϥֽ      A   vendor/symfony/security-core/Exception/TokenNotFoundException.php  Ng  (      D   vendor/symfony/security-core/Exception/ProviderNotFoundException.php  Ng  R      F   vendor/symfony/security-core/Exception/SessionUnavailableException.phpz  Ngz  {Y      C   vendor/symfony/security-core/Exception/InvalidArgumentException.php  Ng  W.      B   vendor/symfony/security-core/Exception/AccountExpiredException.php  Ng  O
      I   vendor/symfony/security-core/Exception/AuthenticationExpiredException.phpG  NgG  %.D      V   vendor/symfony/security-core/Exception/TooManyLoginAttemptsAuthenticationException.php}  Ng}  j      ?   vendor/symfony/security-core/Exception/CookieTheftException.php  Ng  m	      I   vendor/symfony/security-core/Exception/AuthenticationServiceException.php  Ng  t%      C   vendor/symfony/security-core/Exception/UnsupportedUserException.phpJ  NgJ  jۤ      A   vendor/symfony/security-core/Exception/AccountStatusException.php  Ng  c%      R   vendor/symfony/security-core/Exception/CustomUserMessageAccountStatusException.php  Ng  *
      N   vendor/symfony/security-core/Exception/InsufficientAuthenticationException.php&  Ng&  [d      :   vendor/symfony/security-core/Exception/LockedException.phpl  Ngl  0믤      B   vendor/symfony/security-core/Exception/AuthenticationException.php+  Ng+  l      @   vendor/symfony/security-core/Exception/UserNotFoundException.php@  Ng@  򼓤      U   vendor/symfony/security-core/Exception/AuthenticationCredentialsNotFoundException.php  Ng  bb      F   vendor/symfony/security-core/Exception/CredentialsExpiredException.php  Ng  8h      C   vendor/symfony/security-core/Authentication/Token/AbstractToken.phpb  Ngb  ߤ7	      ?   vendor/symfony/security-core/Authentication/Token/NullToken.php   Ng   iƤ      W   vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php	  Ng	  l	      J   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php4  Ng4  g      S   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php  Ng  %N      E   vendor/symfony/security-core/Authentication/Token/RememberMeToken.php  Ng  
5Lq      E   vendor/symfony/security-core/Authentication/Token/SwitchUserToken.phpm  Ngm  8      K   vendor/symfony/security-core/Authentication/Token/PreAuthenticatedToken.php  Ng  .      D   vendor/symfony/security-core/Authentication/Token/TokenInterface.php1	  Ng1	  =N*ݤ      K   vendor/symfony/security-core/Authentication/Token/UsernamePasswordToken.php  Ng  z      T   vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php`  Ng`  J      K   vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.phpw  Ngw  4
      S   vendor/symfony/security-core/Authentication/RememberMe/PersistentTokenInterface.php  Ng        P   vendor/symfony/security-core/Authentication/RememberMe/InMemoryTokenProvider.php'  Ng'  =      M   vendor/symfony/security-core/Authentication/RememberMe/CacheTokenVerifier.php	  Ng	  -Lu      J   vendor/symfony/security-core/Authentication/RememberMe/PersistentToken.php  Ng  Ij       Q   vendor/symfony/security-core/Authentication/RememberMe/TokenVerifierInterface.php  Ng  Ҥ      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenProviderInterface.php  Ng  ܪ      A   vendor/symfony/security-core/Event/AuthenticationSuccessEvent.phpu  Ngu        :   vendor/symfony/security-core/Event/AuthenticationEvent.php  Ng  :7x      0   vendor/symfony/security-core/Event/VoteEvent.php-  Ng-        *   vendor/symfony/security-core/composer.json  Ng  x4      5   vendor/symfony/security-core/AuthenticationEvents.php  Ng  "a䚤      ,   vendor/symfony/deprecation-contracts/LICENSE,  Ng,  K      1   vendor/symfony/deprecation-contracts/CHANGELOG.md   Ng   h{#      1   vendor/symfony/deprecation-contracts/function.php  Ng  Oݤ      .   vendor/symfony/deprecation-contracts/README.md  Ng  X      2   vendor/symfony/deprecation-contracts/composer.jsonS  NgS  =6      (   vendor/symfony/routing/CompiledRoute.php6  Ng6  k栤      *   vendor/symfony/routing/Attribute/Route.php  Ng  MT|         vendor/symfony/routing/LICENSE,  Ng,  U      (   vendor/symfony/routing/RouteCompiler.php8  Ng8  u      #   vendor/symfony/routing/CHANGELOG.md6  Ng6  V^      )   vendor/symfony/routing/RequestContext.php`  Ng`  )-ͤ      +   vendor/symfony/routing/Annotation/Route.php  Ng  m\      :   vendor/symfony/routing/Matcher/RequestMatcherInterface.php+  Ng+  <      =   vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php  Ng  ~      -   vendor/symfony/routing/Matcher/UrlMatcher.php'  Ng'  #Ф      B   vendor/symfony/routing/Matcher/RedirectableUrlMatcherInterface.phpo  Ngo  0
H      6   vendor/symfony/routing/Matcher/UrlMatcherInterface.php  Ng  P-2Ȥ      5   vendor/symfony/routing/Matcher/CompiledUrlMatcher.php  Ng  *g      6   vendor/symfony/routing/Matcher/TraceableUrlMatcher.phpJ  NgJ  @      B   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherDumper.phpJ  NgJ   3I      7   vendor/symfony/routing/Matcher/Dumper/MatcherDumper.php  Ng  \Pܤ      @   vendor/symfony/routing/Matcher/Dumper/MatcherDumperInterface.phpg  Ngg  xI{$      A   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherTrait.php  Ng  kR      @   vendor/symfony/routing/Matcher/Dumper/StaticPrefixCollection.php  Ng  ˥      9   vendor/symfony/routing/Matcher/RedirectableUrlMatcher.php<  Ng<  ðKʤ          vendor/symfony/routing/README.md  Ng  rɤ      9   vendor/symfony/routing/Generator/CompiledUrlGenerator.php
  Ng
  XA~      1   vendor/symfony/routing/Generator/UrlGenerator.php;  Ng;  Yn'      F   vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php  Ng  dfФ      :   vendor/symfony/routing/Generator/UrlGeneratorInterface.php
  Ng
  Y3
8      D   vendor/symfony/routing/Generator/Dumper/GeneratorDumperInterface.phpi  Ngi  fE      F   vendor/symfony/routing/Generator/Dumper/CompiledUrlGeneratorDumper.php  Ng        ;   vendor/symfony/routing/Generator/Dumper/GeneratorDumper.php$  Ng$  αh      *   vendor/symfony/routing/RouteCollection.phpO+  NgO+  u      6   vendor/symfony/routing/Requirement/EnumRequirement.php  Ng        2   vendor/symfony/routing/Requirement/Requirement.phpR  NgR  1$      7   vendor/symfony/routing/RequestContextAwareInterface.php6  Ng6  t      7   vendor/symfony/routing/Loader/AnnotationClassLoader.php  Ng  tD0      :   vendor/symfony/routing/Loader/AttributeDirectoryLoader.php  Ng  Tst      5   vendor/symfony/routing/Loader/AttributeFileLoader.php  Ng  MKI      0   vendor/symfony/routing/Loader/YamlFileLoader.php/  Ng/  14%      6   vendor/symfony/routing/Loader/AnnotationFileLoader.php  Ng        <   vendor/symfony/routing/Loader/schema/routing/routing-1.0.xsd9  Ng9  *#      /   vendor/symfony/routing/Loader/PhpFileLoader.php  Ng  @      5   vendor/symfony/routing/Loader/Psr4DirectoryLoader.php  Ng  *>      /   vendor/symfony/routing/Loader/XmlFileLoader.phpF  NgF  =k      .   vendor/symfony/routing/Loader/ObjectLoader.phpq  Ngq  !v|      ?   vendor/symfony/routing/Loader/Configurator/Traits/HostTrait.php!  Ng!        A   vendor/symfony/routing/Loader/Configurator/Traits/PrefixTrait.php
  Ng
  (      I   vendor/symfony/routing/Loader/Configurator/Traits/LocalizedRouteTrait.php3
  Ng3
  }2       @   vendor/symfony/routing/Loader/Configurator/Traits/RouteTrait.php9  Ng9  ,s      >   vendor/symfony/routing/Loader/Configurator/Traits/AddTrait.phpS  NgS  Ӥ      @   vendor/symfony/routing/Loader/Configurator/RouteConfigurator.php  Ng  {      E   vendor/symfony/routing/Loader/Configurator/CollectionConfigurator.php  Ng  ֠P      @   vendor/symfony/routing/Loader/Configurator/AliasConfigurator.php  Ng        B   vendor/symfony/routing/Loader/Configurator/RoutingConfigurator.php  Ng  a      A   vendor/symfony/routing/Loader/Configurator/ImportConfigurator.php  Ng  O      6   vendor/symfony/routing/Loader/AttributeClassLoader.php>  Ng>  K      1   vendor/symfony/routing/Loader/ContainerLoader.php  Ng  :      1   vendor/symfony/routing/Loader/DirectoryLoader.php  Ng  ]/      0   vendor/symfony/routing/Loader/GlobFileLoader.php  Ng  .]      /   vendor/symfony/routing/Loader/ClosureLoader.php  Ng  
       ;   vendor/symfony/routing/Loader/AnnotationDirectoryLoader.php  Ng  7
h          vendor/symfony/routing/Route.php/  Ng/  _      *   vendor/symfony/routing/RouterInterface.php"  Ng"  WF      !   vendor/symfony/routing/Router.phpt/  Ngt/  -X      1   vendor/symfony/routing/RouteCompilerInterface.php  Ng  T          vendor/symfony/routing/Alias.php	  Ng	  ä      Q   vendor/symfony/routing/DependencyInjection/AddExpressionLanguageProvidersPass.php  Ng  Tw      B   vendor/symfony/routing/DependencyInjection/RoutingResolverPass.php"  Ng"  K˶      >   vendor/symfony/routing/Exception/ResourceNotFoundException.php2  Ng2  FL"1      7   vendor/symfony/routing/Exception/ExceptionInterface.php  Ng  &      ;   vendor/symfony/routing/Exception/RouteNotFoundException.php  Ng  	C      5   vendor/symfony/routing/Exception/RuntimeException.php  Ng  $>G      H   vendor/symfony/routing/Exception/MissingMandatoryParametersException.phpC  NgC  jYKФ      =   vendor/symfony/routing/Exception/InvalidArgumentException.php  Ng  ֤      >   vendor/symfony/routing/Exception/MethodNotAllowedException.phpp  Ngp  .ִ      =   vendor/symfony/routing/Exception/NoConfigurationException.php  Ng  r      D   vendor/symfony/routing/Exception/RouteCircularReferenceException.php>  Ng>  \T      >   vendor/symfony/routing/Exception/InvalidParameterException.php  Ng  !N      $   vendor/symfony/routing/composer.jsony  Ngy  P      ?   vendor/symfony/service-contracts/ServiceSubscriberInterface.php
  Ng
  }uP      ?   vendor/symfony/service-contracts/ServiceCollectionInterface.php  Ng  }V      @   vendor/symfony/service-contracts/Attribute/SubscribedService.php  Ng  i      7   vendor/symfony/service-contracts/Attribute/Required.php  Ng  `e      (   vendor/symfony/service-contracts/LICENSE,  Ng,        @   vendor/symfony/service-contracts/Test/ServiceLocatorTestCase.phpH  NgH  5#!1      <   vendor/symfony/service-contracts/Test/ServiceLocatorTest.php  Ng  ]1C      -   vendor/symfony/service-contracts/CHANGELOG.md   Ng   h{#      *   vendor/symfony/service-contracts/README.mdJ  NgJ  Г      3   vendor/symfony/service-contracts/ResetInterface.php  Ng  B4      =   vendor/symfony/service-contracts/ServiceProviderInterface.php  Ng  B쯇      ;   vendor/symfony/service-contracts/ServiceSubscriberTrait.php
  Ng
  F      B   vendor/symfony/service-contracts/ServiceMethodsSubscriberTrait.php&  Ng&        8   vendor/symfony/service-contracts/ServiceLocatorTrait.php  Ng  ?      .   vendor/symfony/service-contracts/composer.json  Ng  3'      9   vendor/symfony/property-info/PhpStan/NameScopeFactory.php  Ng  r      2   vendor/symfony/property-info/PhpStan/NameScope.php  Ng  d)ݤ      ?   vendor/symfony/property-info/PropertyInfoExtractorInterface.php  Ng  U-R      %   vendor/symfony/property-info/Type.php  Ng  1ɤ      $   vendor/symfony/property-info/LICENSE,  Ng,  H      6   vendor/symfony/property-info/Util/PhpDocTypeHelper.php  Ng  0Ƥ      7   vendor/symfony/property-info/Util/PhpStanTypeHelper.php#  Ng#  >       )   vendor/symfony/property-info/CHANGELOG.md  Ng  .      ;   vendor/symfony/property-info/PropertyInfoCacheExtractor.phpE  NgE  ؍      D   vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php  Ng  xBy\      A   vendor/symfony/property-info/PropertyAccessExtractorInterface.php  Ng  2$C      ?   vendor/symfony/property-info/PropertyTypeExtractorInterface.phpQ  NgQ        1   vendor/symfony/property-info/PropertyReadInfo.php  Ng  
      ;   vendor/symfony/property-info/Extractor/PhpStanExtractor.php.  Ng.  G      >   vendor/symfony/property-info/Extractor/SerializerExtractor.php  Ng        ?   vendor/symfony/property-info/Extractor/ConstructorExtractor.php  Ng  -U      T   vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php  Ng  jv\      >   vendor/symfony/property-info/Extractor/ReflectionExtractor.php  Ng        :   vendor/symfony/property-info/Extractor/PhpDocExtractor.php&0  Ng&0  dd      F   vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php   Ng   
8      2   vendor/symfony/property-info/PropertyWriteInfo.php  Ng  C      &   vendor/symfony/property-info/README.md  Ng  '7      C   vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php  Ng  :|`դ      H   vendor/symfony/property-info/PropertyInitializableExtractorInterface.php  Ng  OW      6   vendor/symfony/property-info/PropertyInfoExtractor.php  Ng  yh      ?   vendor/symfony/property-info/PropertyListExtractorInterface.php  Ng  J$      P   vendor/symfony/property-info/DependencyInjection/PropertyInfoConstructorPass.phpY  NgY  [c      E   vendor/symfony/property-info/DependencyInjection/PropertyInfoPass.php)  Ng)         *   vendor/symfony/property-info/composer.json  Ng  j      3   vendor/symfony/http-foundation/StreamedResponse.php  Ng  <      :   vendor/symfony/http-foundation/RequestMatcherInterface.php|  Ng|  3Q      5   vendor/symfony/http-foundation/BinaryFileResponse.php2  Ng2  އ      +   vendor/symfony/http-foundation/InputBag.php7  Ng7  sĤ      I   vendor/symfony/http-foundation/RateLimiter/AbstractRequestRateLimiter.php	  Ng	  -3      J   vendor/symfony/http-foundation/RateLimiter/RequestRateLimiterInterface.php
  Ng
  ¤      R   vendor/symfony/http-foundation/RateLimiter/PeekableRequestRateLimiterInterface.php  Ng  U      &   vendor/symfony/http-foundation/LICENSE,  Ng,  U      J   vendor/symfony/http-foundation/Test/Constraint/ResponseCookieValueSame.phpL  NgL  f_      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasCookie.phpJ  NgJ  Z^      M   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderLocationSame.php  Ng  U      I   vendor/symfony/http-foundation/Test/Constraint/ResponseStatusCodeSame.php  Ng  I[x`      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsSuccessful.php.  Ng.  P      J   vendor/symfony/http-foundation/Test/Constraint/ResponseIsUnprocessable.phpE  NgE  K¤      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsRedirected.php,  Ng,        D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasHeader.php<  Ng<  &      L   vendor/symfony/http-foundation/Test/Constraint/RequestAttributeValueSame.php  Ng  '`7      E   vendor/symfony/http-foundation/Test/Constraint/ResponseFormatSame.php  Ng  ^)      E   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderSame.php  Ng  <پJ      ,   vendor/symfony/http-foundation/ServerBag.php  Ng        +   vendor/symfony/http-foundation/CHANGELOG.mduL  NguL  M      ,   vendor/symfony/http-foundation/File/File.php  Ng  ޯԤ      .   vendor/symfony/http-foundation/File/Stream.php  Ng  x      4   vendor/symfony/http-foundation/File/UploadedFile.php^'  Ng^'  b[      G   vendor/symfony/http-foundation/File/Exception/AccessDeniedException.phpi  Ngi  Y      A   vendor/symfony/http-foundation/File/Exception/NoFileException.php  Ng  -A      F   vendor/symfony/http-foundation/File/Exception/IniSizeFileException.php  Ng  I      J   vendor/symfony/http-foundation/File/Exception/CannotWriteFileException.php  Ng  :ݤ      H   vendor/symfony/http-foundation/File/Exception/ExtensionFileException.php  Ng  )      ?   vendor/symfony/http-foundation/File/Exception/FileException.php  Ng  j2      A   vendor/symfony/http-foundation/File/Exception/UploadException.php  Ng  S      I   vendor/symfony/http-foundation/File/Exception/UnexpectedTypeException.php9  Ng9  d-      G   vendor/symfony/http-foundation/File/Exception/FormSizeFileException.php  Ng  m;      G   vendor/symfony/http-foundation/File/Exception/FileNotFoundException.phpY  NgY  {WɈ      F   vendor/symfony/http-foundation/File/Exception/PartialFileException.php  Ng  *      G   vendor/symfony/http-foundation/File/Exception/NoTmpDirFileException.php  Ng  n      +   vendor/symfony/http-foundation/Response.php  Ng  u      )   vendor/symfony/http-foundation/Cookie.phpJ/  NgJ/  "f      /   vendor/symfony/http-foundation/AcceptHeader.php{
  Ng{
  G      1   vendor/symfony/http-foundation/RequestMatcher.php  Ng  յnҤ      4   vendor/symfony/http-foundation/ResponseHeaderBag.php  Ng  4֭      .   vendor/symfony/http-foundation/HeaderUtils.php$  Ng$  4      F   vendor/symfony/http-foundation/RequestMatcher/MethodRequestMatcher.php>  Ng>        D   vendor/symfony/http-foundation/RequestMatcher/PathRequestMatcher.phpd  Ngd  w|      F   vendor/symfony/http-foundation/RequestMatcher/IsJsonRequestMatcher.php  Ng  TK      D   vendor/symfony/http-foundation/RequestMatcher/PortRequestMatcher.php  Ng  2      D   vendor/symfony/http-foundation/RequestMatcher/HostRequestMatcher.phpR  NgR  s      J   vendor/symfony/http-foundation/RequestMatcher/AttributesRequestMatcher.php  Ng  d      J   vendor/symfony/http-foundation/RequestMatcher/ExpressionRequestMatcher.php  Ng  Q̤      F   vendor/symfony/http-foundation/RequestMatcher/SchemeRequestMatcher.php,  Ng,  s>M      C   vendor/symfony/http-foundation/RequestMatcher/IpsRequestMatcher.php2  Ng2  ti      /   vendor/symfony/http-foundation/RequestStack.php  Ng   J      3   vendor/symfony/http-foundation/RedirectResponse.php9
  Ng9
  V      /   vendor/symfony/http-foundation/JsonResponse.phpj  Ngj  OP/      (   vendor/symfony/http-foundation/README.md  Ng  &      *   vendor/symfony/http-foundation/Request.php Ng BFF      ;   vendor/symfony/http-foundation/ExpressionRequestMatcher.php  Ng  |*      /   vendor/symfony/http-foundation/ParameterBag.php  Ng  6      *   vendor/symfony/http-foundation/IpUtils.php   Ng   Rz^      3   vendor/symfony/http-foundation/AcceptHeaderItem.php  Ng  :6      7   vendor/symfony/http-foundation/StreamedJsonResponse.php  Ng  ؕSҤ      ,   vendor/symfony/http-foundation/UrlHelper.phpq  Ngq  `Kl      6   vendor/symfony/http-foundation/ChainRequestMatcher.phpx  Ngx  X!      ,   vendor/symfony/http-foundation/HeaderBag.php  Ng  ZdL      *   vendor/symfony/http-foundation/FileBag.php  Ng  "4Ϥ      H   vendor/symfony/http-foundation/Exception/ConflictingHeadersException.php  Ng  ,Ň      E   vendor/symfony/http-foundation/Exception/UnexpectedValueException.phpx  Ngx   ȕ      F   vendor/symfony/http-foundation/Exception/RequestExceptionInterface.php  Ng  R      @   vendor/symfony/http-foundation/Exception/BadRequestException.php  Ng  Uڤ      I   vendor/symfony/http-foundation/Exception/SuspiciousOperationException.php  Ng  '      :   vendor/symfony/http-foundation/Exception/JsonException.php  Ng        E   vendor/symfony/http-foundation/Exception/SessionNotFoundException.phpY  NgY  1      ,   vendor/symfony/http-foundation/composer.jsonv  Ngv  ^D      ,   vendor/symfony/http-foundation/UriSigner.php!
  Ng!
         J   vendor/symfony/http-foundation/Session/Attribute/AttributeBagInterface.php  Ng  Gf=      A   vendor/symfony/http-foundation/Session/Attribute/AttributeBag.php
  Ng
        H   vendor/symfony/http-foundation/Session/FlashBagAwareSessionInterface.php4  Ng4        B   vendor/symfony/http-foundation/Session/SessionFactoryInterface.php  Ng  f*      2   vendor/symfony/http-foundation/Session/Session.php  Ng  <)      7   vendor/symfony/http-foundation/Session/SessionUtils.php  Ng  '      M   vendor/symfony/http-foundation/Session/Storage/Handler/NullSessionHandler.php  Ng  r@      Q   vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php  Ng  դ      P   vendor/symfony/http-foundation/Session/Storage/Handler/SessionHandlerFactory.php)  Ng)  o      L   vendor/symfony/http-foundation/Session/Storage/Handler/PdoSessionHandler.php  Ng  AS      T   vendor/symfony/http-foundation/Session/Storage/Handler/MarshallingSessionHandler.php~  Ng~  |%      S   vendor/symfony/http-foundation/Session/Storage/Handler/NativeFileSessionHandler.php  Ng  wb      R   vendor/symfony/http-foundation/Session/Storage/Handler/MigratingSessionHandler.php  Ng  Dt|      M   vendor/symfony/http-foundation/Session/Storage/Handler/IdentityMarshaller.php  Ng  Gҭq      P   vendor/symfony/http-foundation/Session/Storage/Handler/MongoDbSessionHandler.phpG  NgG  $      N   vendor/symfony/http-foundation/Session/Storage/Handler/RedisSessionHandler.php  Ng  G      O   vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php	  Ng	  mI      R   vendor/symfony/http-foundation/Session/Storage/Handler/MemcachedSessionHandler.php  Ng  oڤ      G   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorage.php7  Ng7  w`      J   vendor/symfony/http-foundation/Session/Storage/SessionStorageInterface.php/  Ng/  {      P   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorageFactory.php  Ng  YPZ      L   vendor/symfony/http-foundation/Session/Storage/Proxy/SessionHandlerProxy.phpB	  NgB	        F   vendor/symfony/http-foundation/Session/Storage/Proxy/AbstractProxy.php  Ng  <      N   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.php!  Ng!  	      J   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorage.php  Ng  f      Q   vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.phpw  Ngw  ]n      I   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorage.php  Ng  *8      Q   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorageFactory.php  Ng  ɤ      >   vendor/symfony/http-foundation/Session/Storage/MetadataBag.php
  Ng
        J   vendor/symfony/http-foundation/Session/Storage/MockArraySessionStorage.php	  Ng	  Q3U      ;   vendor/symfony/http-foundation/Session/SessionInterface.php  Ng  OY>      C   vendor/symfony/http-foundation/Session/Flash/AutoExpireFlashBag.php  Ng  Ԗޤ      B   vendor/symfony/http-foundation/Session/Flash/FlashBagInterface.php  Ng  u1Ф      9   vendor/symfony/http-foundation/Session/Flash/FlashBag.php	  Ng	  vɅ      9   vendor/symfony/http-foundation/Session/SessionFactory.phpG  NgG  
      :   vendor/symfony/http-foundation/Session/SessionBagProxy.php  Ng  
      >   vendor/symfony/http-foundation/Session/SessionBagInterface.phpW  NgW  #9      ,   vendor/symfony/var-exporter/Instantiator.php	  Ng	  
      +   vendor/symfony/var-exporter/ProxyHelper.php'W  Ng'W  eF      #   vendor/symfony/var-exporter/LICENSE,  Ng,        (   vendor/symfony/var-exporter/CHANGELOG.md  Ng  t?      (   vendor/symfony/var-exporter/Hydrator.php  Ng  aZ(      8   vendor/symfony/var-exporter/Internal/LazyObjectState.php  Ng  7!4      ;   vendor/symfony/var-exporter/Internal/LazyObjectRegistry.php4  Ng4  Őܤ      /   vendor/symfony/var-exporter/Internal/Values.php  Ng  `ǿ      8   vendor/symfony/var-exporter/Internal/LazyObjectTrait.php)  Ng)  ;ޣ      1   vendor/symfony/var-exporter/Internal/Hydrator.php*  Ng*  bj%      1   vendor/symfony/var-exporter/Internal/Registry.php@  Ng@  #      2   vendor/symfony/var-exporter/Internal/Reference.php
  Ng
  #Jn      1   vendor/symfony/var-exporter/Internal/Exporter.phpyA  NgyA  GUS      .   vendor/symfony/var-exporter/LazyGhostTrait.php";  Ng";  SԤ      %   vendor/symfony/var-exporter/README.md-  Ng-  "      .   vendor/symfony/var-exporter/LazyProxyTrait.php1  Ng1  !      +   vendor/symfony/var-exporter/VarExporter.phpR  NgR  eH      3   vendor/symfony/var-exporter/LazyObjectInterface.phpa  Nga  @#      8   vendor/symfony/var-exporter/Exception/LogicException.php  Ng  -ʤ      <   vendor/symfony/var-exporter/Exception/ExceptionInterface.phpd  Ngd        @   vendor/symfony/var-exporter/Exception/ClassNotFoundException.php1  Ng1  w w      F   vendor/symfony/var-exporter/Exception/NotInstantiableTypeException.php>  Ng>  }      )   vendor/symfony/var-exporter/composer.jsonr  Ngr  ~j      E   vendor/symfony/error-handler/ErrorEnhancer/ErrorEnhancerInterface.php	  Ng	  ޺      I   vendor/symfony/error-handler/ErrorEnhancer/ClassNotFoundErrorEnhancer.phpR  NgR        M   vendor/symfony/error-handler/ErrorEnhancer/UndefinedFunctionErrorEnhancer.php*  Ng*  ^z      K   vendor/symfony/error-handler/ErrorEnhancer/UndefinedMethodErrorEnhancer.php  Ng  1'      $   vendor/symfony/error-handler/LICENSE,  Ng,  զ_Ϥ      )   vendor/symfony/error-handler/CHANGELOG.md  Ng  D9      B   vendor/symfony/error-handler/Resources/bin/patch-type-declarations
  Ng
  d"m      M   vendor/symfony/error-handler/Resources/bin/extract-tentative-return-types.php   Ng   mE      ?   vendor/symfony/error-handler/Resources/views/exception.html.php/  Ng/        <   vendor/symfony/error-handler/Resources/views/traces.html.php
  Ng
  n       A   vendor/symfony/error-handler/Resources/views/traces_text.html.php  Ng  j+2      :   vendor/symfony/error-handler/Resources/views/logs.html.php)	  Ng)	  _&      ;   vendor/symfony/error-handler/Resources/views/trace.html.php`  Ng`  39      ;   vendor/symfony/error-handler/Resources/views/error.html.phpd  Ngd  x      D   vendor/symfony/error-handler/Resources/views/exception_full.html.php  Ng  Eޤ      ?   vendor/symfony/error-handler/Resources/assets/css/exception.css	B  Ng	B  R      D   vendor/symfony/error-handler/Resources/assets/css/exception_full.css
  Ng
  *bc      ;   vendor/symfony/error-handler/Resources/assets/css/error.css  Ng  %7      J   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square.svgQ  NgQ  p      B   vendor/symfony/error-handler/Resources/assets/images/icon-book.svg  Ng        E   vendor/symfony/error-handler/Resources/assets/images/icon-support.svgz  Ngz  S̤      F   vendor/symfony/error-handler/Resources/assets/images/chevron-right.svg  Ng        J   vendor/symfony/error-handler/Resources/assets/images/symfony-ghost.svg.php   Ng   9꒤      I   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square.svg  Ng  U      E   vendor/symfony/error-handler/Resources/assets/images/symfony-logo.svg  Ng  %0ɤ      B   vendor/symfony/error-handler/Resources/assets/images/icon-copy.svg	  Ng	  "Ȗ      G   vendor/symfony/error-handler/Resources/assets/images/favicon.png.base64  Ng  "i^      K   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square-o.svg  Ng  -      L   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square-o.svg  Ng  s0      =   vendor/symfony/error-handler/Resources/assets/js/exception.js4  Ng4  C#      8   vendor/symfony/error-handler/Internal/TentativeTypes.php  Ng        &   vendor/symfony/error-handler/Debug.phpH  NgH  s
ߤ      F   vendor/symfony/error-handler/ErrorRenderer/SerializerErrorRenderer.php
  Ng
  <      ?   vendor/symfony/error-handler/ErrorRenderer/CliErrorRenderer.php  Ng  
+2      E   vendor/symfony/error-handler/ErrorRenderer/ErrorRendererInterface.php  Ng  sۤ      @   vendor/symfony/error-handler/ErrorRenderer/HtmlErrorRenderer.php]  Ng]  Yc      @   vendor/symfony/error-handler/ErrorRenderer/FileLinkFormatter.phpP  NgP  Y      &   vendor/symfony/error-handler/README.md=  Ng=  \      1   vendor/symfony/error-handler/DebugClassLoader.php#  Ng#  qY      0   vendor/symfony/error-handler/BufferingLogger.phpA  NgA  Z      -   vendor/symfony/error-handler/ErrorHandler.phpuk  Nguk  w)      /   vendor/symfony/error-handler/ThrowableUtils.php{  Ng{  -F      7   vendor/symfony/error-handler/Error/OutOfMemoryError.php[  Ng[  N      ;   vendor/symfony/error-handler/Error/UndefinedMethodError.php  Ng  V[      1   vendor/symfony/error-handler/Error/FatalError.php
  Ng
  Ff      =   vendor/symfony/error-handler/Error/UndefinedFunctionError.php  Ng  lnB      9   vendor/symfony/error-handler/Error/ClassNotFoundError.php  Ng  Ep      ;   vendor/symfony/error-handler/Exception/FlattenException.phpI.  NgI.  ޱњ      ?   vendor/symfony/error-handler/Exception/SilencedErrorContext.phpr  Ngr  +      *   vendor/symfony/error-handler/composer.json  Ng  ny&      4   vendor/symfony/cache-contracts/CallbackInterface.php]  Ng]  oW$      0   vendor/symfony/cache-contracts/ItemInterface.php6  Ng6  #
      &   vendor/symfony/cache-contracts/LICENSE,  Ng,        +   vendor/symfony/cache-contracts/CHANGELOG.md   Ng   h{#      1   vendor/symfony/cache-contracts/CacheInterface.php2	  Ng2	  5      (   vendor/symfony/cache-contracts/README.mdF  NgF  _      -   vendor/symfony/cache-contracts/CacheTrait.php	  Ng	  iW      9   vendor/symfony/cache-contracts/TagAwareCacheInterface.php  Ng  1swc      ,   vendor/symfony/cache-contracts/composer.json  Ng  Av      7   vendor/symfony/dependency-injection/EnvVarProcessor.php2  Ng2  sF      ;   vendor/symfony/dependency-injection/ContainerAwareTrait.phpO  NgO  4rS      B   vendor/symfony/dependency-injection/ExpressionLanguageProvider.php\  Ng\  lD      1   vendor/symfony/dependency-injection/Container.php6  Ng6  S      8   vendor/symfony/dependency-injection/ReverseContainer.php	  Ng	  4)Ȥ      0   vendor/symfony/dependency-injection/Variable.php  Ng  hp      P   vendor/symfony/dependency-injection/Extension/ConfigurableExtensionInterface.php#  Ng#  ᅋ~      D   vendor/symfony/dependency-injection/Extension/ExtensionInterface.php`  Ng`  ^
N      C   vendor/symfony/dependency-injection/Extension/AbstractExtension.php  Ng  W$      @   vendor/symfony/dependency-injection/Extension/ExtensionTrait.php  Ng  V      ;   vendor/symfony/dependency-injection/Extension/Extension.php  Ng  0B      K   vendor/symfony/dependency-injection/Extension/PrependExtensionInterface.phpS  NgS  NC6      Q   vendor/symfony/dependency-injection/Extension/ConfigurationExtensionInterface.phpS  NgS  )      ?   vendor/symfony/dependency-injection/Attribute/Autoconfigure.php  Ng  ZӤ      B   vendor/symfony/dependency-injection/Attribute/AutowireIterator.php  Ng  o      =   vendor/symfony/dependency-injection/Attribute/AsDecorator.phpo  Ngo  Y|      H   vendor/symfony/dependency-injection/Attribute/AutowireServiceClosure.php  Ng  ^#5      >   vendor/symfony/dependency-injection/Attribute/AsTaggedItem.php  Ng  k      8   vendor/symfony/dependency-injection/Attribute/Target.php  Ng  A      6   vendor/symfony/dependency-injection/Attribute/When.php  Ng  Xˤ      C   vendor/symfony/dependency-injection/Attribute/AutowireDecorated.php  Ng  +h      @   vendor/symfony/dependency-injection/Attribute/TaggedIterator.php  Ng  u      A   vendor/symfony/dependency-injection/Attribute/AutowireLocator.phpe
  Nge
        B   vendor/symfony/dependency-injection/Attribute/AutowireCallable.phpT  NgT  鼎`      :   vendor/symfony/dependency-injection/Attribute/Autowire.php]
  Ng]
  sO      B   vendor/symfony/dependency-injection/Attribute/AutoconfigureTag.php  Ng  	       ?   vendor/symfony/dependency-injection/Attribute/TaggedLocator.php  Ng  鱞      >   vendor/symfony/dependency-injection/Attribute/MapDecorated.phpb  Ngb  \      9   vendor/symfony/dependency-injection/Attribute/Exclude.php  Ng  a)      9   vendor/symfony/dependency-injection/Attribute/AsAlias.php  Ng        +   vendor/symfony/dependency-injection/LICENSE,  Ng,  U      0   vendor/symfony/dependency-injection/CHANGELOG.mdhI  NghI  Z[      Q   vendor/symfony/dependency-injection/Config/ContainerParametersResourceChecker.php)  Ng)  }~      J   vendor/symfony/dependency-injection/Config/ContainerParametersResource.php  Ng  5      J   vendor/symfony/dependency-injection/Argument/ReferenceSetArgumentTrait.php	  Ng	  /      A   vendor/symfony/dependency-injection/Argument/AbstractArgument.php  Ng  1i      D   vendor/symfony/dependency-injection/Argument/RewindableGenerator.php  Ng  s      G   vendor/symfony/dependency-injection/Argument/ServiceLocatorArgument.php  Ng  /c=      >   vendor/symfony/dependency-injection/Argument/BoundArgument.php  Ng  >))      A   vendor/symfony/dependency-injection/Argument/IteratorArgument.php6  Ng6  2Ҥ      <   vendor/symfony/dependency-injection/Argument/LazyClosure.php_
  Ng_
  a5Ѥ      G   vendor/symfony/dependency-injection/Argument/TaggedIteratorArgument.phpu
  Ngu
        B   vendor/symfony/dependency-injection/Argument/ArgumentInterface.phpN  NgN        ?   vendor/symfony/dependency-injection/Argument/ServiceLocator.php#  Ng#  ěs@      G   vendor/symfony/dependency-injection/Argument/ServiceClosureArgument.php*  Ng*  k      8   vendor/symfony/dependency-injection/ContainerBuilder.php  Ng  AcZ      7   vendor/symfony/dependency-injection/ChildDefinition.phpp
  Ngp
  /o      1   vendor/symfony/dependency-injection/Reference.php  Ng  ͯ      J   vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php	  Ng	  U]      O   vendor/symfony/dependency-injection/ParameterBag/EnvPlaceholderParameterBag.php  Ng  !      A   vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php$  Ng$  AҤ      J   vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php  Ng        A   vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php  Ng  #O      G   vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php  Ng  0P      2   vendor/symfony/dependency-injection/Definition.phpP  NgP  D      @   vendor/symfony/dependency-injection/EnvVarProcessorInterface.php  Ng  90      -   vendor/symfony/dependency-injection/README.mdC  NgC  <      :   vendor/symfony/dependency-injection/ContainerInterface.phpd	  Ngd	  ʤ      9   vendor/symfony/dependency-injection/Loader/FileLoader.php<  Ng<  (٤      =   vendor/symfony/dependency-injection/Loader/YamlFileLoader.php
  Ng
  Qd2      O   vendor/symfony/dependency-injection/Loader/schema/dic/services/services-1.0.xsdB  NgB  o      <   vendor/symfony/dependency-injection/Loader/PhpFileLoader.php!  Ng!  g      <   vendor/symfony/dependency-injection/Loader/XmlFileLoader.php  Ng  Bd      <   vendor/symfony/dependency-injection/Loader/IniFileLoader.php  Ng  j}      P   vendor/symfony/dependency-injection/Loader/Configurator/ServicesConfigurator.php4  Ng4  g      P   vendor/symfony/dependency-injection/Loader/Configurator/DefaultsConfigurator.php9	  Ng9	  Ca      Q   vendor/symfony/dependency-injection/Loader/Configurator/ReferenceConfigurator.php  Ng  w      T   vendor/symfony/dependency-injection/Loader/Configurator/FromCallableConfigurator.php  Ng  6n      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ClassTrait.php1  Ng1  D      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/CallTrait.phpN  NgN  X_^      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/SyntheticTrait.php  Ng  .      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PropertyTrait.phpl  Ngl  
s_      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ArgumentTrait.php  Ng  
      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConfiguratorTrait.php  Ng  M      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ParentTrait.php  Ng  (      O   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FactoryTrait.phpd  Ngd  'D      K   vendor/symfony/dependency-injection/Loader/Configurator/Traits/TagTrait.php  Ng  p       N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PublicTrait.php  Ng        P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DecorateTrait.php{  Ng{  2Ѥ      U   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutoconfigureTrait.phpE  NgE  ^7      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FromCallableTrait.php	  Ng	  \      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DeprecateTrait.phpb  Ngb  *'Ѥ      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/BindTrait.php[  Ng[  Bf      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/LazyTrait.phpD  NgD  5R      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FileTrait.phpG  NgG  F8      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AbstractTrait.php  Ng  ge      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ShareTrait.phpL  NgL  b      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutowireTrait.phpM  NgM  P      S   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConstructorTrait.phpU  NgU  86$      P   vendor/symfony/dependency-injection/Loader/Configurator/AbstractConfigurator.php  Ng  ԏ)      X   vendor/symfony/dependency-injection/Loader/Configurator/ClosureReferenceConfigurator.php  Ng  #y      K   vendor/symfony/dependency-injection/Loader/Configurator/EnvConfigurator.phpj  Ngj        W   vendor/symfony/dependency-injection/Loader/Configurator/AbstractServiceConfigurator.php  Ng  fۤ      R   vendor/symfony/dependency-injection/Loader/Configurator/InstanceofConfigurator.php  Ng  !R      Q   vendor/symfony/dependency-injection/Loader/Configurator/ContainerConfigurator.php  Ng  4      M   vendor/symfony/dependency-injection/Loader/Configurator/AliasConfigurator.php  Ng  RF,b      U   vendor/symfony/dependency-injection/Loader/Configurator/InlineServiceConfigurator.phpR  NgR  <      Q   vendor/symfony/dependency-injection/Loader/Configurator/PrototypeConfigurator.php
  Ng
  o      R   vendor/symfony/dependency-injection/Loader/Configurator/ParametersConfigurator.php  Ng  "      O   vendor/symfony/dependency-injection/Loader/Configurator/ServiceConfigurator.php  Ng  A[_v      >   vendor/symfony/dependency-injection/Loader/DirectoryLoader.php2  Ng2  	      =   vendor/symfony/dependency-injection/Loader/GlobFileLoader.php`  Ng`        <   vendor/symfony/dependency-injection/Loader/ClosureLoader.php  Ng  5      =   vendor/symfony/dependency-injection/LazyProxy/ProxyHelper.php  Ng  Ğ}      K   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/DumperInterface.php  Ng  5=      M   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/LazyServiceDumper.php  Ng  p<      F   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/NullDumper.php  Ng  vOΤ      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/LazyServiceInstantiator.php  Ng  (d      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/RealServiceInstantiator.phpd  Ngd  翓      T   vendor/symfony/dependency-injection/LazyProxy/Instantiator/InstantiatorInterface.php~  Ng~  0ND      :   vendor/symfony/dependency-injection/ExpressionLanguage.phpb  Ngb  !UO      6   vendor/symfony/dependency-injection/ServiceLocator.php  Ng  9x"D      6   vendor/symfony/dependency-injection/TypedReference.php3  Ng3  adt      -   vendor/symfony/dependency-injection/Alias.php  Ng  nZԤ      U   vendor/symfony/dependency-injection/Exception/ParameterCircularReferenceException.php  Ng  t9      @   vendor/symfony/dependency-injection/Exception/LogicException.php  Ng  }|Ȥ      F   vendor/symfony/dependency-injection/Exception/EnvNotFoundException.php  Ng  &      L   vendor/symfony/dependency-injection/Exception/ParameterNotFoundException.php"  Ng"  
      D   vendor/symfony/dependency-injection/Exception/ExceptionInterface.php~  Ng~        F   vendor/symfony/dependency-injection/Exception/OutOfBoundsException.php  Ng  On      S   vendor/symfony/dependency-injection/Exception/ServiceCircularReferenceException.php_  Ng_  Ke&      J   vendor/symfony/dependency-injection/Exception/ServiceNotFoundException.php  Ng  Ф      B   vendor/symfony/dependency-injection/Exception/RuntimeException.php	  Ng	  
      J   vendor/symfony/dependency-injection/Exception/InvalidArgumentException.php'  Ng'        H   vendor/symfony/dependency-injection/Exception/BadMethodCallException.php  Ng  ,w      K   vendor/symfony/dependency-injection/Exception/AutowiringFailedException.php  Ng  M      O   vendor/symfony/dependency-injection/Exception/InvalidParameterTypeException.php0  Ng0  I      G   vendor/symfony/dependency-injection/Exception/EnvParameterException.php  Ng  =&)      @   vendor/symfony/dependency-injection/TaggedContainerInterface.php  Ng  J.      1   vendor/symfony/dependency-injection/Parameter.phpf  Ngf  sD      E   vendor/symfony/dependency-injection/Compiler/DecoratorServicePass.php  Ng  'f      M   vendor/symfony/dependency-injection/Compiler/ResolveInvalidReferencesPass.php  Ng  ]      L   vendor/symfony/dependency-injection/Compiler/ValidateEnvPlaceholdersPass.php  Ng        M   vendor/symfony/dependency-injection/Compiler/RegisterEnvVarProcessorsPass.php@  Ng@  p脤      T   vendor/symfony/dependency-injection/Compiler/RegisterAutoconfigureAttributesPass.php  Ng        L   vendor/symfony/dependency-injection/Compiler/CheckDefinitionValidityPass.php!  Ng!  gPK      ;   vendor/symfony/dependency-injection/Compiler/PassConfig.phpm  Ngm  1&      F   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraph.php
  Ng
  j      E   vendor/symfony/dependency-injection/Compiler/ResolveNoPreloadPass.phpK  NgK  7ɤ      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphNode.php  Ng        J   vendor/symfony/dependency-injection/Compiler/CheckTypeDeclarationsPass.php1  Ng1  W       M   vendor/symfony/dependency-injection/Compiler/InlineServiceDefinitionsPass.php  Ng        H   vendor/symfony/dependency-injection/Compiler/ResolveFactoryClassPass.php   Ng   %d      D   vendor/symfony/dependency-injection/Compiler/ResolveBindingsPass.php$*  Ng$*  
B      H   vendor/symfony/dependency-injection/Compiler/AutowireAsDecoratorPass.php  Ng  3      K   vendor/symfony/dependency-injection/Compiler/PriorityTaggedServiceTrait.php  Ng  v3      M   vendor/symfony/dependency-injection/Compiler/RegisterReverseContainerPass.php  Ng  QY      F   vendor/symfony/dependency-injection/Compiler/AbstractRecursivePass.php8*  Ng8*  c3      R   vendor/symfony/dependency-injection/Compiler/AliasDeprecatedPublicServicesPass.php  Ng  Hl      R   vendor/symfony/dependency-injection/Compiler/ResolveInstanceofConditionalsPass.php8  Ng8  y      O   vendor/symfony/dependency-injection/Compiler/ResolveReferencesToAliasesPass.php  Ng  cW      K   vendor/symfony/dependency-injection/Compiler/CheckArgumentsValidityPass.php3  Ng3  췤      O   vendor/symfony/dependency-injection/Compiler/AttributeAutoconfigurationPass.php  Ng  1x      O   vendor/symfony/dependency-injection/Compiler/AutowireRequiredPropertiesPass.php-
  Ng-
  zh      J   vendor/symfony/dependency-injection/Compiler/ResolveNamedArgumentsPass.php'  Ng'  $      I   vendor/symfony/dependency-injection/Compiler/RemovePrivateAliasesPass.php  Ng  XB      P   vendor/symfony/dependency-injection/Compiler/MergeExtensionConfigurationPass.php!  Ng!  ?      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphEdge.phpi  Ngi  ^n      M   vendor/symfony/dependency-injection/Compiler/DefinitionErrorExceptionPass.phpB
  NgB
  B      L   vendor/symfony/dependency-injection/Compiler/RemoveUnusedDefinitionsPass.php  Ng  xp      =   vendor/symfony/dependency-injection/Compiler/AutowirePass.php8{  Ng8{  an+      F   vendor/symfony/dependency-injection/Compiler/ServiceLocatorTagPass.php  Ng  J      R   vendor/symfony/dependency-injection/Compiler/ResolveTaggedIteratorArgumentPass.phpq  Ngq  ?      K   vendor/symfony/dependency-injection/Compiler/ResolveEnvPlaceholdersPass.php  Ng  ]      L   vendor/symfony/dependency-injection/Compiler/CheckCircularReferencesPass.php  Ng  gG      ]   vendor/symfony/dependency-injection/Compiler/CheckExceptionOnInvalidReferenceBehaviorPass.php  Ng  Lפ      J   vendor/symfony/dependency-injection/Compiler/RemoveBuildParametersPass.php  Ng  vg      E   vendor/symfony/dependency-injection/Compiler/AutoAliasServicePass.php  Ng  zp
      Q   vendor/symfony/dependency-injection/Compiler/ResolveParameterPlaceHoldersPass.php  Ng  F0      A   vendor/symfony/dependency-injection/Compiler/ResolveClassPass.php]  Ng]  v`      N   vendor/symfony/dependency-injection/Compiler/RemoveAbstractDefinitionsPass.php  Ng  Q      K   vendor/symfony/dependency-injection/Compiler/CheckReferenceValidityPass.php6  Ng6  YB      O   vendor/symfony/dependency-injection/Compiler/RegisterServiceSubscribersPass.php  Ng  a%      C   vendor/symfony/dependency-injection/Compiler/ResolveHotPathPass.php<	  Ng<	  sY[      J   vendor/symfony/dependency-injection/Compiler/ResolveDecoratorStackPass.php  Ng  lD      N   vendor/symfony/dependency-injection/Compiler/ResolveServiceSubscribersPass.php  Ng  ٭v      F   vendor/symfony/dependency-injection/Compiler/CompilerPassInterface.php  Ng  &      S   vendor/symfony/dependency-injection/Compiler/ReplaceAliasByActualDefinitionPass.phpa  Nga  p6      L   vendor/symfony/dependency-injection/Compiler/ResolveChildDefinitionsPass.php&  Ng&  W      9   vendor/symfony/dependency-injection/Compiler/Compiler.php
  Ng
  ˤ      F   vendor/symfony/dependency-injection/Compiler/ExtensionCompilerPass.php  Ng        M   vendor/symfony/dependency-injection/Compiler/AnalyzeServiceReferencesPass.php  Ng  ^0      L   vendor/symfony/dependency-injection/Compiler/AutowireRequiredMethodsPass.php  Ng  `#{      =   vendor/symfony/dependency-injection/Dumper/GraphvizDumper.php#  Ng#  sO      9   vendor/symfony/dependency-injection/Dumper/YamlDumper.php"8  Ng"8  Oˤ      8   vendor/symfony/dependency-injection/Dumper/Preloader.php  Ng  v{      8   vendor/symfony/dependency-injection/Dumper/XmlDumper.phpH  NgH  ]߸      >   vendor/symfony/dependency-injection/Dumper/DumperInterface.phpV  NgV  s#      5   vendor/symfony/dependency-injection/Dumper/Dumper.php  Ng  U;a      8   vendor/symfony/dependency-injection/Dumper/PhpDumper.php Ng 6      1   vendor/symfony/dependency-injection/composer.json  Ng  2      =   vendor/symfony/dependency-injection/EnvVarLoaderInterface.php  Ng  bkr      ?   vendor/symfony/dependency-injection/ContainerAwareInterface.php  Ng  =>         vendor/symfony/clock/LICENSE,  Ng,  t=      1   vendor/symfony/clock/Test/ClockSensitiveTrait.php  Ng  I      !   vendor/symfony/clock/CHANGELOG.md  Ng  CJ      &   vendor/symfony/clock/Resources/now.php  Ng  5䏤      (   vendor/symfony/clock/ClockAwareTrait.php  Ng  3         vendor/symfony/clock/README.md  Ng  I      "   vendor/symfony/clock/MockClock.php  Ng  $i         vendor/symfony/clock/Clock.phpS	  NgS	  *R'      '   vendor/symfony/clock/MonotonicClock.php
  Ng
  }Z      '   vendor/symfony/clock/ClockInterface.phpL  NgL  z֚&      "   vendor/symfony/clock/DatePoint.php  Ng  Ф      "   vendor/symfony/clock/composer.json  Ng  GPҤ      $   vendor/symfony/clock/NativeClock.php/  Ng/  ur+      :   vendor/symfony/password-hasher/PasswordHasherInterface.php  Ng  -<      >   vendor/symfony/password-hasher/Hasher/SodiumPasswordHasher.php  Ng  ^~      B   vendor/symfony/password-hasher/Hasher/CheckPasswordLengthTrait.php  Ng  B+.      <   vendor/symfony/password-hasher/Hasher/UserPasswordHasher.phpK  NgK  r,Ф      >   vendor/symfony/password-hasher/Hasher/Pbkdf2PasswordHasher.php  Ng  S8      F   vendor/symfony/password-hasher/Hasher/PasswordHasherAwareInterface.php  Ng  ϡ*      >   vendor/symfony/password-hasher/Hasher/NativePasswordHasher.php  Ng  Q      E   vendor/symfony/password-hasher/Hasher/MessageDigestPasswordHasher.php 
  Ng 
  r6k      E   vendor/symfony/password-hasher/Hasher/UserPasswordHasherInterface.phpr  Ngr  4Τ      A   vendor/symfony/password-hasher/Hasher/PlaintextPasswordHasher.php[	  Ng[	        H   vendor/symfony/password-hasher/Hasher/PasswordHasherFactoryInterface.php  Ng  @      A   vendor/symfony/password-hasher/Hasher/MigratingPasswordHasher.php  Ng  rG      ?   vendor/symfony/password-hasher/Hasher/PasswordHasherFactory.php&!  Ng&!  FA      &   vendor/symfony/password-hasher/LICENSE,  Ng,  U      +   vendor/symfony/password-hasher/CHANGELOG.md   Ng   ڰ      @   vendor/symfony/password-hasher/LegacyPasswordHasherInterface.php  Ng  t      (   vendor/symfony/password-hasher/README.md  Ng  !      B   vendor/symfony/password-hasher/Command/UserPasswordHashCommand.php'  Ng'  8      ;   vendor/symfony/password-hasher/Exception/LogicException.php  Ng  A      ?   vendor/symfony/password-hasher/Exception/ExceptionInterface.php  Ng  EWL      E   vendor/symfony/password-hasher/Exception/InvalidPasswordException.php  Ng  L      ,   vendor/symfony/password-hasher/composer.json  Ng           vendor/symfony/process/LICENSE,  Ng,  U      +   vendor/symfony/process/ExecutableFinder.php
  Ng
  wt      #   vendor/symfony/process/CHANGELOG.md  Ng   %8          vendor/symfony/process/README.md  Ng  \3$Ϥ      *   vendor/symfony/process/Pipes/UnixPipes.php  Ng  Q\      -   vendor/symfony/process/Pipes/WindowsPipes.php  Ng  Q      .   vendor/symfony/process/Pipes/AbstractPipes.php  Ng  e      /   vendor/symfony/process/Pipes/PipesInterface.php  Ng        &   vendor/symfony/process/InputStream.php	  Ng	  6ee      6   vendor/symfony/process/Messenger/RunProcessContext.php|  Ng|  ɔ      6   vendor/symfony/process/Messenger/RunProcessMessage.php  Ng  2$      =   vendor/symfony/process/Messenger/RunProcessMessageHandler.php%  Ng%  0      %   vendor/symfony/process/PhpProcess.php	  Ng	  3x      (   vendor/symfony/process/PhpSubprocess.php  Ng  :1      .   vendor/symfony/process/PhpExecutableFinder.php%	  Ng%	  ޏx      =   vendor/symfony/process/Exception/ProcessSignaledException.php  Ng  -n_      3   vendor/symfony/process/Exception/LogicException.php  Ng  iUQ      7   vendor/symfony/process/Exception/ExceptionInterface.php  Ng  
j%W      ;   vendor/symfony/process/Exception/ProcessFailedException.phpp  Ngp   ۋ      5   vendor/symfony/process/Exception/RuntimeException.php  Ng  P      =   vendor/symfony/process/Exception/ProcessTimedOutException.php  Ng  8^Q      =   vendor/symfony/process/Exception/InvalidArgumentException.php  Ng  ڴ      >   vendor/symfony/process/Exception/RunProcessFailedException.php  Ng  ؤ      $   vendor/symfony/process/composer.json  Ng  S.t      '   vendor/symfony/process/ProcessUtils.php  Ng  a鍤      "   vendor/symfony/process/Process.php  Ng  8      =   vendor/symfony/console/DataCollector/CommandDataCollector.php  Ng  &      (   vendor/symfony/console/ConsoleEvents.php  Ng  .
      !   vendor/symfony/console/Cursor.php  Ng  \Fä      &   vendor/symfony/console/Application.php  Ng  !(      /   vendor/symfony/console/Logger/ConsoleLogger.phpY  NgY  Ġ      .   vendor/symfony/console/Attribute/AsCommand.phpJ  NgJ  c         vendor/symfony/console/LICENSE,  Ng,  U      #   vendor/symfony/console/CHANGELOG.md)  Ng)   b_e      9   vendor/symfony/console/Input/StreamableInputInterface.php  Ng  3y-      +   vendor/symfony/console/Input/ArrayInput.phpH  NgH  ůx      *   vendor/symfony/console/Input/ArgvInput.php0  Ng0  #      .   vendor/symfony/console/Input/InputArgument.php:  Ng:  ț      4   vendor/symfony/console/Input/InputAwareInterface.phpc  Ngc  Q      ,   vendor/symfony/console/Input/InputOption.php!  Ng!  !1g=      0   vendor/symfony/console/Input/InputDefinition.phpU.  NgU.  )ͤ      ,   vendor/symfony/console/Input/StringInput.php
  Ng
  G      &   vendor/symfony/console/Input/Input.phpl  Ngl  ;      /   vendor/symfony/console/Input/InputInterface.php|  Ng|  kx'      #   vendor/symfony/console/Terminal.php  Ng  `HN      2   vendor/symfony/console/CI/GithubActionReporter.php+  Ng+  @      0   vendor/symfony/console/Resources/completion.bash  Ng  %}      4   vendor/symfony/console/Resources/bin/hiddeninput.exe $  Ng $  v      /   vendor/symfony/console/Resources/completion.zsh  Ng  ʤ      0   vendor/symfony/console/Resources/completion.fish  Ng  Keդ      5   vendor/symfony/console/Output/TrimmedBufferOutput.phpY  NgY  G>d      8   vendor/symfony/console/Output/ConsoleOutputInterface.php=  Ng=  B:      0   vendor/symfony/console/Output/BufferedOutput.phpQ  NgQ  *AS      1   vendor/symfony/console/Output/OutputInterface.php6  Ng6  j8q      /   vendor/symfony/console/Output/AnsiColorMode.php
  Ng
  oi+      (   vendor/symfony/console/Output/Output.php  Ng  \Τ      6   vendor/symfony/console/Output/ConsoleSectionOutput.php9!  Ng9!         /   vendor/symfony/console/Output/ConsoleOutput.php  Ng  :*      ,   vendor/symfony/console/Output/NullOutput.phpO  NgO  p       .   vendor/symfony/console/Output/StreamOutput.php  Ng  +%ؤ      A   vendor/symfony/console/Completion/Output/FishCompletionOutput.php  Ng  `      A   vendor/symfony/console/Completion/Output/BashCompletionOutput.php	  Ng	  Q2      F   vendor/symfony/console/Completion/Output/CompletionOutputInterface.php  Ng  :]      @   vendor/symfony/console/Completion/Output/ZshCompletionOutput.php1  Ng1        0   vendor/symfony/console/Completion/Suggestion.php7  Ng7  /)	Ϥ      ;   vendor/symfony/console/Completion/CompletionSuggestions.php^  Ng^  lx      5   vendor/symfony/console/Completion/CompletionInput.php   Ng   jfO      ,   vendor/symfony/console/Style/OutputStyle.php  Ng  Vy      -   vendor/symfony/console/Style/SymfonyStyle.php;  Ng;  
&ˤ      /   vendor/symfony/console/Style/StyleInterface.php
  Ng
  .      2   vendor/symfony/console/Question/ChoiceQuestion.php1  Ng1  JY      ,   vendor/symfony/console/Question/Question.php>  Ng>  o[դ      8   vendor/symfony/console/Question/ConfirmationQuestion.php,  Ng,  %          vendor/symfony/console/README.md  Ng  Æf      9   vendor/symfony/console/Formatter/OutputFormatterStyle.php  Ng  yM      B   vendor/symfony/console/Formatter/OutputFormatterStyleInterface.php  Ng  ǡ      =   vendor/symfony/console/Formatter/NullOutputFormatterStyle.phpl  Ngl        =   vendor/symfony/console/Formatter/OutputFormatterInterface.php"  Ng"  7V6_      4   vendor/symfony/console/Formatter/OutputFormatter.phpM   NgM   =b      8   vendor/symfony/console/Formatter/NullOutputFormatter.php  Ng  B[      F   vendor/symfony/console/Formatter/WrappableOutputFormatterInterface.php  Ng  *
      >   vendor/symfony/console/Formatter/OutputFormatterStyleStack.php?
  Ng?
  :;      6   vendor/symfony/console/Messenger/RunCommandMessage.php  Ng  
M      6   vendor/symfony/console/Messenger/RunCommandContext.php  Ng  !B      =   vendor/symfony/console/Messenger/RunCommandMessageHandler.php  Ng  yzo          vendor/symfony/console/Color.php(  Ng(  -      8   vendor/symfony/console/SignalRegistry/SignalRegistry.php  Ng  G,eͤ      3   vendor/symfony/console/SignalRegistry/SignalMap.php  Ng  (      3   vendor/symfony/console/SingleCommandApplication.php>  Ng>  OA      ?   vendor/symfony/console/CommandLoader/CommandLoaderInterface.phpV  NgV  X2      ?   vendor/symfony/console/CommandLoader/ContainerCommandLoader.php  Ng  ƒ      =   vendor/symfony/console/CommandLoader/FactoryCommandLoader.phpK  NgK  <      4   vendor/symfony/console/Descriptor/TextDescriptor.php0  Ng0  f      <   vendor/symfony/console/Descriptor/ApplicationDescription.php(  Ng(  #1      3   vendor/symfony/console/Descriptor/XmlDescriptor.php&  Ng&  ,Eb      9   vendor/symfony/console/Descriptor/DescriptorInterface.phpm  Ngm  B      0   vendor/symfony/console/Descriptor/Descriptor.php
  Ng
  j      @   vendor/symfony/console/Descriptor/ReStructuredTextDescriptor.php')  Ng')  Ǿ4      4   vendor/symfony/console/Descriptor/JsonDescriptor.php%  Ng%  
֤      8   vendor/symfony/console/Descriptor/MarkdownDescriptor.php  Ng  4Qj      /   vendor/symfony/console/Tester/CommandTester.phpL	  NgL	  5Ykؤ      -   vendor/symfony/console/Tester/TesterTrait.phpr  Ngr  Ƥ      3   vendor/symfony/console/Tester/ApplicationTester.php
  Ng
  Z3      9   vendor/symfony/console/Tester/CommandCompletionTester.phpD  NgD  T      @   vendor/symfony/console/Tester/Constraint/CommandIsSuccessful.php+  Ng+  1      3   vendor/symfony/console/Command/TraceableCommand.php](  Ng](         .   vendor/symfony/console/Command/LazyCommand.php  Ng  oͤ      0   vendor/symfony/console/Command/LockableTrait.php3  Ng3        .   vendor/symfony/console/Command/HelpCommand.php	  Ng	  6_3      2   vendor/symfony/console/Command/CompleteCommand.php#  Ng#  sJ!      .   vendor/symfony/console/Command/ListCommand.php	  Ng	  e\{      8   vendor/symfony/console/Command/DumpCompletionCommand.php  Ng  +CQ      =   vendor/symfony/console/Command/SignalableCommandInterface.phpE  NgE  bO      *   vendor/symfony/console/Command/Command.php!Z  Ng!Z  a 啤      ,   vendor/symfony/console/Helper/TableStyle.php!1  Ng!1  'p,      +   vendor/symfony/console/Helper/TableRows.php[  Ng[  {m֤      7   vendor/symfony/console/Helper/SymfonyQuestionHelper.php)
  Ng)
  7N      1   vendor/symfony/console/Helper/HelperInterface.phpV  NgV  ̊      +   vendor/symfony/console/Helper/TableCell.php  Ng  e9S      /   vendor/symfony/console/Helper/ProcessHelper.php  Ng  e      0   vendor/symfony/console/Helper/TableSeparator.php!  Ng!  n2      /   vendor/symfony/console/Helper/OutputWrapper.php  Ng  lؤ      1   vendor/symfony/console/Helper/FormatterHelper.php  Ng  0ɤ      0   vendor/symfony/console/Helper/TableCellStyle.php)  Ng)  KӘ      -   vendor/symfony/console/Helper/ProgressBar.phpL  NgL  r      6   vendor/symfony/console/Helper/DebugFormatterHelper.php

  Ng

  &      +   vendor/symfony/console/Helper/HelperSet.phpc  Ngc  V.      (   vendor/symfony/console/Helper/Dumper.phpz  Ngz  `      2   vendor/symfony/console/Helper/InputAwareHelper.php  Ng  pc      0   vendor/symfony/console/Helper/QuestionHelper.phpXL  NgXL  ʱbܤ      (   vendor/symfony/console/Helper/Helper.php  Ng  +u      '   vendor/symfony/console/Helper/Table.php6{  Ng6{  De      3   vendor/symfony/console/Helper/ProgressIndicator.php  Ng  bN&      2   vendor/symfony/console/Helper/DescriptorHelper.phpd
  Ngd
        D   vendor/symfony/console/DependencyInjection/AddConsoleCommandPass.php  Ng  4      3   vendor/symfony/console/Exception/LogicException.php  Ng  5      ;   vendor/symfony/console/Exception/InvalidOptionException.php  Ng  %:      >   vendor/symfony/console/Exception/RunCommandFailedException.php>  Ng>  ~      7   vendor/symfony/console/Exception/ExceptionInterface.php  Ng  oOȤ      5   vendor/symfony/console/Exception/RuntimeException.php  Ng        ?   vendor/symfony/console/Exception/NamespaceNotFoundException.php  Ng  xD      =   vendor/symfony/console/Exception/InvalidArgumentException.php  Ng  x
Τ      :   vendor/symfony/console/Exception/MissingInputException.php  Ng  L      =   vendor/symfony/console/Exception/CommandNotFoundException.php  Ng  ͆Ť      6   vendor/symfony/console/Event/ConsoleTerminateEvent.php  Ng  [5Ť      2   vendor/symfony/console/Event/ConsoleErrorEvent.php  Ng  z      4   vendor/symfony/console/Event/ConsoleCommandEvent.php>  Ng>  y      -   vendor/symfony/console/Event/ConsoleEvent.php  Ng  8(M      3   vendor/symfony/console/Event/ConsoleSignalEvent.php  Ng  =|Ѯ      $   vendor/symfony/console/composer.jsonH  NgH  +      +   vendor/symfony/console/Debug/CliRequest.phpq  Ngq  ekX      6   vendor/symfony/console/EventListener/ErrorListener.php  Ng  h
      0   vendor/symfony/polyfill-mbstring/bootstrap80.php'  Ng'  L#\M      (   vendor/symfony/polyfill-mbstring/LICENSE,  Ng,  H      B   vendor/symfony/polyfill-mbstring/Resources/unidata/caseFolding.php  Ng  ]SC      @   vendor/symfony/polyfill-mbstring/Resources/unidata/lowerCase.phpU  NgU  D׎      F   vendor/symfony/polyfill-mbstring/Resources/unidata/titleCaseRegexp.php  Ng  oቤ      @   vendor/symfony/polyfill-mbstring/Resources/unidata/upperCase.phpO[  NgO[  (      -   vendor/symfony/polyfill-mbstring/Mbstring.php  Ng  g_      .   vendor/symfony/polyfill-mbstring/bootstrap.php!  Ng!  d      *   vendor/symfony/polyfill-mbstring/README.mdr  Ngr  A`      .   vendor/symfony/polyfill-mbstring/composer.json8  Ng8        5   vendor/symfony/polyfill-intl-grapheme/bootstrap80.phpg
  Ngg
  E{      -   vendor/symfony/polyfill-intl-grapheme/LICENSE,  Ng,  H      2   vendor/symfony/polyfill-intl-grapheme/Grapheme.php&  Ng&  8      3   vendor/symfony/polyfill-intl-grapheme/bootstrap.php  Ng        /   vendor/symfony/polyfill-intl-grapheme/README.mdK  NgK  C>      3   vendor/symfony/polyfill-intl-grapheme/composer.json   Ng   +          vendor/ramsey/collection/LICENSE7  Ng7  ŸԤ      "   vendor/ramsey/collection/README.md  Ng  3 Ӥ      &   vendor/ramsey/collection/composer.json|  Ng|   v֤      $   vendor/ramsey/collection/SECURITY.md  Ng        1   vendor/ramsey/collection/src/DoubleEndedQueue.php  Ng  e      ,   vendor/ramsey/collection/src/AbstractSet.php  Ng  <!      /   vendor/ramsey/collection/src/QueueInterface.php  Ng  *      3   vendor/ramsey/collection/src/AbstractCollection.phpa+  Nga+  d?      .   vendor/ramsey/collection/src/AbstractArray.php  Ng  z P      &   vendor/ramsey/collection/src/Queue.php3  Ng3  D      $   vendor/ramsey/collection/src/Set.php0  Ng0  H      :   vendor/ramsey/collection/src/DoubleEndedQueueInterface.php(  Ng(  6'&      6   vendor/ramsey/collection/src/Map/TypedMapInterface.php2  Ng2  z      5   vendor/ramsey/collection/src/Map/AbstractTypedMap.phpc  Ngc  cͤ      1   vendor/ramsey/collection/src/Map/MapInterface.php  Ng  OA      -   vendor/ramsey/collection/src/Map/TypedMap.php
  Ng
  >)      8   vendor/ramsey/collection/src/Map/AssociativeArrayMap.php0  Ng0  PǤ      6   vendor/ramsey/collection/src/Map/NamedParameterMap.php   Ng   `@Q      0   vendor/ramsey/collection/src/Map/AbstractMap.php  Ng  I?      -   vendor/ramsey/collection/src/GenericArray.php  Ng        /   vendor/ramsey/collection/src/ArrayInterface.php'  Ng'  5a      %   vendor/ramsey/collection/src/Sort.php{  Ng{  Ȥ      +   vendor/ramsey/collection/src/Collection.php	  Ng	  0       4   vendor/ramsey/collection/src/CollectionInterface.php$  Ng$  r      H   vendor/ramsey/collection/src/Exception/UnsupportedOperationException.phpL  NgL  ff      ?   vendor/ramsey/collection/src/Exception/OutOfBoundsException.phpw  Ngw        >   vendor/ramsey/collection/src/Exception/CollectionException.php  Ng  Ĵ@      C   vendor/ramsey/collection/src/Exception/InvalidArgumentException.phps  Ngs  ڤ      A   vendor/ramsey/collection/src/Exception/NoSuchElementException.phpD  NgD  	Ln      B   vendor/ramsey/collection/src/Exception/InvalidPropertyOrMethod.php  Ng        F   vendor/ramsey/collection/src/Exception/CollectionMismatchException.phpM  NgM  \ć      8   vendor/ramsey/collection/src/Tool/ValueToStringTrait.php	  Ng	  ;5      /   vendor/ramsey/collection/src/Tool/TypeTrait.phpD  NgD  e      9   vendor/ramsey/collection/src/Tool/ValueExtractorTrait.php  Ng  q          vendor/ramsey/uuid/LICENSE7  Ng7  T̤         vendor/ramsey/uuid/README.md  Ng  $          vendor/ramsey/uuid/composer.json  Ng  VҤ      $   vendor/ramsey/uuid/src/functions.php5  Ng5  	oj      5   vendor/ramsey/uuid/src/Validator/GenericValidator.php  Ng  )      7   vendor/ramsey/uuid/src/Validator/ValidatorInterface.php  Ng  B$o      >   vendor/ramsey/uuid/src/Converter/Time/GenericTimeConverter.php
  Ng
  .V      ;   vendor/ramsey/uuid/src/Converter/Time/UnixTimeConverter.php	  Ng	  Q53Τ      :   vendor/ramsey/uuid/src/Converter/Time/PhpTimeConverter.phpg  Ngg  ;Q
      ?   vendor/ramsey/uuid/src/Converter/Time/DegradedTimeConverter.phpu  Ngu  ?      @   vendor/ramsey/uuid/src/Converter/Time/BigNumberTimeConverter.phpt  Ngt  ,      C   vendor/ramsey/uuid/src/Converter/Number/DegradedNumberConverter.php|  Ng|  7@s&      >   vendor/ramsey/uuid/src/Converter/Number/BigNumberConverter.php0  Ng0  Ǥ      B   vendor/ramsey/uuid/src/Converter/Number/GenericNumberConverter.php  Ng  =0N      ;   vendor/ramsey/uuid/src/Converter/TimeConverterInterface.php?  Ng?  t      =   vendor/ramsey/uuid/src/Converter/NumberConverterInterface.php9  Ng9  z      5   vendor/ramsey/uuid/src/DeprecatedUuidMethodsTrait.php5  Ng5  TE      8   vendor/ramsey/uuid/src/Codec/TimestampFirstCombCodec.php#
  Ng#
  &      1   vendor/ramsey/uuid/src/Codec/OrderedTimeCodec.php
  Ng
  7|o      /   vendor/ramsey/uuid/src/Codec/CodecInterface.php/  Ng/  T|      0   vendor/ramsey/uuid/src/Codec/GuidStringCodec.php   Ng   @+      ,   vendor/ramsey/uuid/src/Codec/StringCodec.php  Ng  Ǟ      7   vendor/ramsey/uuid/src/Codec/TimestampLastCombCodec.php\  Ng\  l         vendor/ramsey/uuid/src/Uuid.phpd  Ngd  b      @   vendor/ramsey/uuid/src/Provider/DceSecurityProviderInterface.php  Ng  }      A   vendor/ramsey/uuid/src/Provider/Dce/SystemDceSecurityProvider.php{  Ng{  #~٣      9   vendor/ramsey/uuid/src/Provider/NodeProviderInterface.php  Ng  	"      ;   vendor/ramsey/uuid/src/Provider/Time/SystemTimeProvider.php   Ng   a      :   vendor/ramsey/uuid/src/Provider/Time/FixedTimeProvider.php  Ng  SVۤ      9   vendor/ramsey/uuid/src/Provider/TimeProviderInterface.phpS  NgS  m+      ;   vendor/ramsey/uuid/src/Provider/Node/RandomNodeProvider.php  Ng  o>O      =   vendor/ramsey/uuid/src/Provider/Node/FallbackNodeProvider.phpj  Ngj  u}      ;   vendor/ramsey/uuid/src/Provider/Node/SystemNodeProvider.php  Ng  p      ?   vendor/ramsey/uuid/src/Provider/Node/NodeProviderCollection.php  Ng   60      ;   vendor/ramsey/uuid/src/Provider/Node/StaticNodeProvider.php4  Ng4  L      %   vendor/ramsey/uuid/src/FeatureSet.php 2  Ng 2  wP      2   vendor/ramsey/uuid/src/Rfc4122/FieldsInterface.phpO  NgO  `      )   vendor/ramsey/uuid/src/Rfc4122/UuidV8.php;	  Ng;	  `$      ,   vendor/ramsey/uuid/src/Rfc4122/Validator.php  Ng  YB      +   vendor/ramsey/uuid/src/Rfc4122/MaxTrait.php"  Ng"  Ypg      /   vendor/ramsey/uuid/src/Rfc4122/VersionTrait.php  Ng  ",      +   vendor/ramsey/uuid/src/Rfc4122/NilTrait.php  Ng  P      )   vendor/ramsey/uuid/src/Rfc4122/Fields.php  Ng  28      *   vendor/ramsey/uuid/src/Rfc4122/NilUuid.php[  Ng[  :      *   vendor/ramsey/uuid/src/Rfc4122/MaxUuid.phpZ  NgZ  ;
T      0   vendor/ramsey/uuid/src/Rfc4122/UuidInterface.php  Ng  )B      ,   vendor/ramsey/uuid/src/Rfc4122/TimeTrait.phpY  NgY  V      /   vendor/ramsey/uuid/src/Rfc4122/VariantTrait.phpb
  Ngb
  f6      .   vendor/ramsey/uuid/src/Rfc4122/UuidBuilder.php@  Ng@  ̤      )   vendor/ramsey/uuid/src/Rfc4122/UuidV1.php  Ng  _t      )   vendor/ramsey/uuid/src/Rfc4122/UuidV3.php  Ng  |O$      )   vendor/ramsey/uuid/src/Rfc4122/UuidV2.php  Ng  a /      )   vendor/ramsey/uuid/src/Rfc4122/UuidV6.php)  Ng)  |x{      )   vendor/ramsey/uuid/src/Rfc4122/UuidV7.phpP  NgP  &Fo      )   vendor/ramsey/uuid/src/Rfc4122/UuidV5.php  Ng  s      )   vendor/ramsey/uuid/src/Rfc4122/UuidV4.php  Ng  %      (   vendor/ramsey/uuid/src/UuidInterface.php:  Ng:  ƌ      ,   vendor/ramsey/uuid/src/Math/RoundingMode.php  Ng        3   vendor/ramsey/uuid/src/Math/CalculatorInterface.php  Ng  ɤ      3   vendor/ramsey/uuid/src/Math/BrickMathCalculator.php  Ng  u#      /   vendor/ramsey/uuid/src/UuidFactoryInterface.php  Ng  Gg      9   vendor/ramsey/uuid/src/Generator/RandomBytesGenerator.phpX  NgX  5*5      9   vendor/ramsey/uuid/src/Generator/NameGeneratorFactory.php  Ng  -Z5      6   vendor/ramsey/uuid/src/Generator/UnixTimeGenerator.phpD  NgD  ׺Z      ;   vendor/ramsey/uuid/src/Generator/NameGeneratorInterface.phpG  NgG  Lդ      ;   vendor/ramsey/uuid/src/Generator/RandomGeneratorFactory.php  Ng        9   vendor/ramsey/uuid/src/Generator/DceSecurityGenerator.php  Ng  +>      B   vendor/ramsey/uuid/src/Generator/DceSecurityGeneratorInterface.php  Ng        9   vendor/ramsey/uuid/src/Generator/TimeGeneratorFactory.php{  Ng{  k      9   vendor/ramsey/uuid/src/Generator/DefaultNameGenerator.php  Ng  g$5      9   vendor/ramsey/uuid/src/Generator/DefaultTimeGenerator.php  Ng  0      5   vendor/ramsey/uuid/src/Generator/RandomLibAdapter.php?  Ng?  hi^      ;   vendor/ramsey/uuid/src/Generator/TimeGeneratorInterface.php  Ng  >1      2   vendor/ramsey/uuid/src/Generator/CombGenerator.php  Ng  MO      =   vendor/ramsey/uuid/src/Generator/RandomGeneratorInterface.php  Ng  >59
      <   vendor/ramsey/uuid/src/Generator/PeclUuidRandomGenerator.php3  Ng3  r䍤      :   vendor/ramsey/uuid/src/Generator/PeclUuidNameGenerator.php  Ng  +qZ      :   vendor/ramsey/uuid/src/Generator/PeclUuidTimeGenerator.phpu  Ngu   H9      &   vendor/ramsey/uuid/src/BinaryUtils.php  Ng  /      &   vendor/ramsey/uuid/src/UuidFactory.php=  Ng=        '   vendor/ramsey/uuid/src/Type/Integer.php  Ng  ޤ      $   vendor/ramsey/uuid/src/Type/Time.php
  Ng
  mlU      +   vendor/ramsey/uuid/src/Type/Hexadecimal.php
  Ng
  q

      /   vendor/ramsey/uuid/src/Type/NumberInterface.php  Ng  L      -   vendor/ramsey/uuid/src/Type/TypeInterface.php  Ng  w*      '   vendor/ramsey/uuid/src/Type/Decimal.php  Ng  |Lf      $   vendor/ramsey/uuid/src/Guid/Guid.php&	  Ng&	  rR      &   vendor/ramsey/uuid/src/Guid/Fields.php'  Ng'  ُq      +   vendor/ramsey/uuid/src/Guid/GuidBuilder.php  Ng  '      2   vendor/ramsey/uuid/src/Lazy/LazyUuidFromString.phpB  NgB  G      '   vendor/ramsey/uuid/src/DegradedUuid.phpD  NgD        1   vendor/ramsey/uuid/src/Fields/FieldsInterface.php  Ng  m5h      9   vendor/ramsey/uuid/src/Fields/SerializableFieldsTrait.php  Ng  s"      2   vendor/ramsey/uuid/src/DeprecatedUuidInterface.phpJ  NgJ  
¤      6   vendor/ramsey/uuid/src/Builder/DegradedUuidBuilder.phpu  Ngu  2      7   vendor/ramsey/uuid/src/Builder/UuidBuilderInterface.php;  Ng;  -3      4   vendor/ramsey/uuid/src/Builder/BuilderCollection.php
  Ng
  %;      2   vendor/ramsey/uuid/src/Builder/FallbackBuilder.php  Ng  S/Y      5   vendor/ramsey/uuid/src/Builder/DefaultUuidBuilder.phpT  NgT  Vy      :   vendor/ramsey/uuid/src/Exception/RandomSourceException.php  Ng  ^E      2   vendor/ramsey/uuid/src/Exception/NodeException.php`  Ng`  ]      6   vendor/ramsey/uuid/src/Exception/DateTimeException.phpa  Nga  \      8   vendor/ramsey/uuid/src/Exception/TimeSourceException.phpQ  NgQ        B   vendor/ramsey/uuid/src/Exception/UnsupportedOperationException.phpV  NgV  JN      :   vendor/ramsey/uuid/src/Exception/InvalidBytesException.php_  Ng_  /٤      9   vendor/ramsey/uuid/src/Exception/DceSecurityException.phpp  Ngp  
      2   vendor/ramsey/uuid/src/Exception/NameException.phpf  Ngf  v fY      =   vendor/ramsey/uuid/src/Exception/InvalidArgumentException.phpi  Ngi  v'ä      =   vendor/ramsey/uuid/src/Exception/BuilderNotFoundException.phpQ  NgQ  @c      ?   vendor/ramsey/uuid/src/Exception/UnableToBuildUuidException.phpO  NgO  Ro      ;   vendor/ramsey/uuid/src/Exception/UuidExceptionInterface.php  Ng  K;Ҥ      ?   vendor/ramsey/uuid/src/Exception/InvalidUuidStringException.php  Ng  KI      -   vendor/ramsey/uuid/src/Nonstandard/Fields.php
  Ng
  a      +   vendor/ramsey/uuid/src/Nonstandard/Uuid.php  Ng  s      2   vendor/ramsey/uuid/src/Nonstandard/UuidBuilder.php  Ng  N      -   vendor/ramsey/uuid/src/Nonstandard/UuidV6.phpT
  NgT
  qѤ         vendor/webmozart/assert/LICENSE<  Ng<  t}      $   vendor/webmozart/assert/CHANGELOG.md  Ng        !   vendor/webmozart/assert/README.md>  Ng>  |Ϥ      %   vendor/webmozart/assert/composer.json  Ng  3p      %   vendor/webmozart/assert/src/Mixin.php5 Ng5 9(      8   vendor/webmozart/assert/src/InvalidArgumentException.phpi  Ngi  {Lä      &   vendor/webmozart/assert/src/Assert.php  Ng  =         vendor/react/promise/LICENSEg  Ngg  F      !   vendor/react/promise/CHANGELOG.md9  Ng9  OT:         vendor/react/promise/README.mdQY  NgQY  1      "   vendor/react/promise/composer.json  Ng  NjB      -   vendor/react/promise/src/PromiseInterface.php  Ng  MFx8      &   vendor/react/promise/src/functions.php1-  Ng1-  t      .   vendor/react/promise/src/functions_include.php   Ng   dx\      $   vendor/react/promise/src/Promise.php(  Ng(  s;6      %   vendor/react/promise/src/Deferred.php0  Ng0        5   vendor/react/promise/src/Internal/RejectedPromise.php
  Ng
  |      6   vendor/react/promise/src/Internal/FulfilledPromise.php3	  Ng3	  *      7   vendor/react/promise/src/Internal/CancellationQueue.php  Ng  r2      6   vendor/react/promise/src/Exception/LengthException.php^   Ng^   ?q      9   vendor/react/promise/src/Exception/CompositeException.phpa  Nga  '      <?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

require __DIR__ . '/../vendor/autoload.php';
if (\false === \in_array(\PHP_SAPI, array('cli', 'phpdbg', 'embed'), \true)) {
    echo \PHP_EOL . 'The application may only be invoked from a command line, got "' . \PHP_SAPI . '"' . \PHP_EOL;
    exit(1);
}
if ((\false === isset($_SERVER['BOX_REQUIREMENT_CHECKER']) || \true === (bool) $_SERVER['BOX_REQUIREMENT_CHECKER']) && \false === Checker::checkRequirements()) {
    exit(1);
}
<?php

return array (
  0 => 
  array (
    'type' => 'php',
    'condition' => '^8.1',
    'message' => 'The application requires the version "^8.1" or greater.',
    'helpMessage' => 'The application requires the version "^8.1" or greater.',
  ),
  1 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The application requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "json".',
  ),
  2 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "ramsey/uuid" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "ramsey/uuid" requires the extension "json".',
  ),
  3 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/cose-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "json".',
  ),
  4 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "json".',
  ),
  5 => 
  array (
    'type' => 'extension',
    'condition' => 'session',
    'message' => 'The application requires the extension "session". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "session".',
  ),
  6 => 
  array (
    'type' => 'extension',
    'condition' => 'zip',
    'message' => 'The application requires the extension "zip". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "zip".',
  ),
  7 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "composer/ca-bundle" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "openssl".',
  ),
  8 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/cose-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "openssl".',
  ),
  9 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "openssl".',
  ),
  10 => 
  array (
    'type' => 'extension',
    'condition' => 'pcre',
    'message' => 'The package "composer/ca-bundle" requires the extension "pcre". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "pcre".',
  ),
  11 => 
  array (
    'type' => 'extension',
    'condition' => 'filter',
    'message' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter". Enable it or install a polyfill.',
    'helpMessage' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter".',
  ),
  12 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/framework-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/framework-bundle" requires the extension "xml".',
  ),
  13 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/security-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/security-bundle" requires the extension "xml".',
  ),
);<?php

// autoload.php @generated by Composer

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893::getLoader();
<?php

// autoload_namespaces.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
);

Copyright (c) Nils Adermann, Jordi Boggiano

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished
to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

<?php

/*
 * This file is part of Composer.
 *
 * (c) Nils Adermann <naderman@naderman.de>
 *     Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Composer\Autoload;

/**
 * ClassLoader implements a PSR-0, PSR-4 and classmap class loader.
 *
 *     $loader = new \Composer\Autoload\ClassLoader();
 *
 *     // register classes with namespaces
 *     $loader->add('Symfony\Component', __DIR__.'/component');
 *     $loader->add('Symfony',           __DIR__.'/framework');
 *
 *     // activate the autoloader
 *     $loader->register();
 *
 *     // to enable searching the include path (eg. for PEAR packages)
 *     $loader->setUseIncludePath(true);
 *
 * In this example, if you try to use a class in the Symfony\Component
 * namespace or one of its children (Symfony\Component\Console for instance),
 * the autoloader will first look for the class under the component/
 * directory, and it will then fallback to the framework/ directory if not
 * found before giving up.
 *
 * This class is loosely based on the Symfony UniversalClassLoader.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 * @author Jordi Boggiano <j.boggiano@seld.be>
 * @see    https://www.php-fig.org/psr/psr-0/
 * @see    https://www.php-fig.org/psr/psr-4/
 */
class ClassLoader
{
    /** @var ?string */
    private $vendorDir;

    // PSR-4
    /**
     * @var array[]
     * @psalm-var array<string, array<string, int>>
     */
    private $prefixLengthsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, array<int, string>>
     */
    private $prefixDirsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr4 = array();

    // PSR-0
    /**
     * @var array[]
     * @psalm-var array<string, array<string, string[]>>
     */
    private $prefixesPsr0 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr0 = array();

    /** @var bool */
    private $useIncludePath = false;

    /**
     * @var string[]
     * @psalm-var array<string, string>
     */
    private $classMap = array();

    /** @var bool */
    private $classMapAuthoritative = false;

    /**
     * @var bool[]
     * @psalm-var array<string, bool>
     */
    private $missingClasses = array();

    /** @var ?string */
    private $apcuPrefix;

    /**
     * @var self[]
     */
    private static $registeredLoaders = array();

    /**
     * @param ?string $vendorDir
     */
    public function __construct($vendorDir = null)
    {
        $this->vendorDir = $vendorDir;
    }

    /**
     * @return string[]
     */
    public function getPrefixes()
    {
        if (!empty($this->prefixesPsr0)) {
            return call_user_func_array('array_merge', array_values($this->prefixesPsr0));
        }

        return array();
    }

    /**
     * @return array[]
     * @psalm-return array<string, array<int, string>>
     */
    public function getPrefixesPsr4()
    {
        return $this->prefixDirsPsr4;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirs()
    {
        return $this->fallbackDirsPsr0;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirsPsr4()
    {
        return $this->fallbackDirsPsr4;
    }

    /**
     * @return string[] Array of classname => path
     * @psalm-return array<string, string>
     */
    public function getClassMap()
    {
        return $this->classMap;
    }

    /**
     * @param string[] $classMap Class to filename map
     * @psalm-param array<string, string> $classMap
     *
     * @return void
     */
    public function addClassMap(array $classMap)
    {
        if ($this->classMap) {
            $this->classMap = array_merge($this->classMap, $classMap);
        } else {
            $this->classMap = $classMap;
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix, either
     * appending or prepending to the ones previously set for this prefix.
     *
     * @param string          $prefix  The prefix
     * @param string[]|string $paths   The PSR-0 root directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @return void
     */
    public function add($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            if ($prepend) {
                $this->fallbackDirsPsr0 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr0
                );
            } else {
                $this->fallbackDirsPsr0 = array_merge(
                    $this->fallbackDirsPsr0,
                    (array) $paths
                );
            }

            return;
        }

        $first = $prefix[0];
        if (!isset($this->prefixesPsr0[$first][$prefix])) {
            $this->prefixesPsr0[$first][$prefix] = (array) $paths;

            return;
        }
        if ($prepend) {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                (array) $paths,
                $this->prefixesPsr0[$first][$prefix]
            );
        } else {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                $this->prefixesPsr0[$first][$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace, either
     * appending or prepending to the ones previously set for this namespace.
     *
     * @param string          $prefix  The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths   The PSR-4 base directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function addPsr4($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            // Register directories for the root namespace.
            if ($prepend) {
                $this->fallbackDirsPsr4 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr4
                );
            } else {
                $this->fallbackDirsPsr4 = array_merge(
                    $this->fallbackDirsPsr4,
                    (array) $paths
                );
            }
        } elseif (!isset($this->prefixDirsPsr4[$prefix])) {
            // Register directories for a new namespace.
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        } elseif ($prepend) {
            // Prepend directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                (array) $paths,
                $this->prefixDirsPsr4[$prefix]
            );
        } else {
            // Append directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                $this->prefixDirsPsr4[$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix,
     * replacing any others previously set for this prefix.
     *
     * @param string          $prefix The prefix
     * @param string[]|string $paths  The PSR-0 base directories
     *
     * @return void
     */
    public function set($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr0 = (array) $paths;
        } else {
            $this->prefixesPsr0[$prefix[0]][$prefix] = (array) $paths;
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace,
     * replacing any others previously set for this namespace.
     *
     * @param string          $prefix The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths  The PSR-4 base directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function setPsr4($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr4 = (array) $paths;
        } else {
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        }
    }

    /**
     * Turns on searching the include path for class files.
     *
     * @param bool $useIncludePath
     *
     * @return void
     */
    public function setUseIncludePath($useIncludePath)
    {
        $this->useIncludePath = $useIncludePath;
    }

    /**
     * Can be used to check if the autoloader uses the include path to check
     * for classes.
     *
     * @return bool
     */
    public function getUseIncludePath()
    {
        return $this->useIncludePath;
    }

    /**
     * Turns off searching the prefix and fallback directories for classes
     * that have not been registered with the class map.
     *
     * @param bool $classMapAuthoritative
     *
     * @return void
     */
    public function setClassMapAuthoritative($classMapAuthoritative)
    {
        $this->classMapAuthoritative = $classMapAuthoritative;
    }

    /**
     * Should class lookup fail if not found in the current class map?
     *
     * @return bool
     */
    public function isClassMapAuthoritative()
    {
        return $this->classMapAuthoritative;
    }

    /**
     * APCu prefix to use to cache found/not-found classes, if the extension is enabled.
     *
     * @param string|null $apcuPrefix
     *
     * @return void
     */
    public function setApcuPrefix($apcuPrefix)
    {
        $this->apcuPrefix = function_exists('apcu_fetch') && filter_var(ini_get('apc.enabled'), FILTER_VALIDATE_BOOLEAN) ? $apcuPrefix : null;
    }

    /**
     * The APCu prefix in use, or null if APCu caching is not enabled.
     *
     * @return string|null
     */
    public function getApcuPrefix()
    {
        return $this->apcuPrefix;
    }

    /**
     * Registers this instance as an autoloader.
     *
     * @param bool $prepend Whether to prepend the autoloader or not
     *
     * @return void
     */
    public function register($prepend = false)
    {
        spl_autoload_register(array($this, 'loadClass'), true, $prepend);

        if (null === $this->vendorDir) {
            return;
        }

        if ($prepend) {
            self::$registeredLoaders = array($this->vendorDir => $this) + self::$registeredLoaders;
        } else {
            unset(self::$registeredLoaders[$this->vendorDir]);
            self::$registeredLoaders[$this->vendorDir] = $this;
        }
    }

    /**
     * Unregisters this instance as an autoloader.
     *
     * @return void
     */
    public function unregister()
    {
        spl_autoload_unregister(array($this, 'loadClass'));

        if (null !== $this->vendorDir) {
            unset(self::$registeredLoaders[$this->vendorDir]);
        }
    }

    /**
     * Loads the given class or interface.
     *
     * @param  string    $class The name of the class
     * @return true|null True if loaded, null otherwise
     */
    public function loadClass($class)
    {
        if ($file = $this->findFile($class)) {
            includeFile($file);

            return true;
        }

        return null;
    }

    /**
     * Finds the path to the file where the class is defined.
     *
     * @param string $class The name of the class
     *
     * @return string|false The path if found, false otherwise
     */
    public function findFile($class)
    {
        // class map lookup
        if (isset($this->classMap[$class])) {
            return $this->classMap[$class];
        }
        if ($this->classMapAuthoritative || isset($this->missingClasses[$class])) {
            return false;
        }
        if (null !== $this->apcuPrefix) {
            $file = apcu_fetch($this->apcuPrefix.$class, $hit);
            if ($hit) {
                return $file;
            }
        }

        $file = $this->findFileWithExtension($class, '.php');

        // Search for Hack files if we are running on HHVM
        if (false === $file && defined('HHVM_VERSION')) {
            $file = $this->findFileWithExtension($class, '.hh');
        }

        if (null !== $this->apcuPrefix) {
            apcu_add($this->apcuPrefix.$class, $file);
        }

        if (false === $file) {
            // Remember that this class does not exist.
            $this->missingClasses[$class] = true;
        }

        return $file;
    }

    /**
     * Returns the currently registered loaders indexed by their corresponding vendor directories.
     *
     * @return self[]
     */
    public static function getRegisteredLoaders()
    {
        return self::$registeredLoaders;
    }

    /**
     * @param  string       $class
     * @param  string       $ext
     * @return string|false
     */
    private function findFileWithExtension($class, $ext)
    {
        // PSR-4 lookup
        $logicalPathPsr4 = strtr($class, '\\', DIRECTORY_SEPARATOR) . $ext;

        $first = $class[0];
        if (isset($this->prefixLengthsPsr4[$first])) {
            $subPath = $class;
            while (false !== $lastPos = strrpos($subPath, '\\')) {
                $subPath = substr($subPath, 0, $lastPos);
                $search = $subPath . '\\';
                if (isset($this->prefixDirsPsr4[$search])) {
                    $pathEnd = DIRECTORY_SEPARATOR . substr($logicalPathPsr4, $lastPos + 1);
                    foreach ($this->prefixDirsPsr4[$search] as $dir) {
                        if (file_exists($file = $dir . $pathEnd)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-4 fallback dirs
        foreach ($this->fallbackDirsPsr4 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr4)) {
                return $file;
            }
        }

        // PSR-0 lookup
        if (false !== $pos = strrpos($class, '\\')) {
            // namespaced class name
            $logicalPathPsr0 = substr($logicalPathPsr4, 0, $pos + 1)
                . strtr(substr($logicalPathPsr4, $pos + 1), '_', DIRECTORY_SEPARATOR);
        } else {
            // PEAR-like class name
            $logicalPathPsr0 = strtr($class, '_', DIRECTORY_SEPARATOR) . $ext;
        }

        if (isset($this->prefixesPsr0[$first])) {
            foreach ($this->prefixesPsr0[$first] as $prefix => $dirs) {
                if (0 === strpos($class, $prefix)) {
                    foreach ($dirs as $dir) {
                        if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-0 fallback dirs
        foreach ($this->fallbackDirsPsr0 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                return $file;
            }
        }

        // PSR-0 include paths.
        if ($this->useIncludePath && $file = stream_resolve_include_path($logicalPathPsr0)) {
            return $file;
        }

        return false;
    }
}

/**
 * Scope isolated include.
 *
 * Prevents access to $this/self from included files.
 *
 * @param  string $file
 * @return void
 * @private
 */
function includeFile($file)
{
    include $file;
}
<?php

// autoload_psr4.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'HumbugBox3150\\KevinGH\\RequirementChecker\\' => array($baseDir . '/src'),
    'HumbugBox3150\\Composer\\Semver\\' => array($vendorDir . '/composer/semver/src'),
);
<?php

// autoload_classmap.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'Composer\\InstalledVersions' => $vendorDir . '/composer/InstalledVersions.php',
    'HumbugBox3150\\Composer\\Semver\\Comparator' => $vendorDir . '/composer/semver/src/Comparator.php',
    'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => $vendorDir . '/composer/semver/src/CompilingMatcher.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => $vendorDir . '/composer/semver/src/Constraint/Bound.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => $vendorDir . '/composer/semver/src/Constraint/Constraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => $vendorDir . '/composer/semver/src/Constraint/ConstraintInterface.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchAllConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => $vendorDir . '/composer/semver/src/Constraint/MultiConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Interval' => $vendorDir . '/composer/semver/src/Interval.php',
    'HumbugBox3150\\Composer\\Semver\\Intervals' => $vendorDir . '/composer/semver/src/Intervals.php',
    'HumbugBox3150\\Composer\\Semver\\Semver' => $vendorDir . '/composer/semver/src/Semver.php',
    'HumbugBox3150\\Composer\\Semver\\VersionParser' => $vendorDir . '/composer/semver/src/VersionParser.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => $baseDir . '/src/Checker.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => $baseDir . '/src/IO.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => $baseDir . '/src/IsExtensionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => $baseDir . '/src/IsFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => $baseDir . '/src/IsPhpVersionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => $baseDir . '/src/Printer.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => $baseDir . '/src/Requirement.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => $baseDir . '/src/RequirementCollection.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => $baseDir . '/src/Terminal.php',
);
<?php

// autoload_static.php @generated by Composer

namespace Composer\Autoload;

class ComposerStaticInit7b1918d23e69dc64db20ca1f98396893
{
    public static $prefixLengthsPsr4 = array (
        'H' => 
        array (
            'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 41,
            'HumbugBox3150\\Composer\\Semver\\' => 30,
        ),
    );

    public static $prefixDirsPsr4 = array (
        'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 
        array (
            0 => __DIR__ . '/../..' . '/src',
        ),
        'HumbugBox3150\\Composer\\Semver\\' => 
        array (
            0 => __DIR__ . '/..' . '/composer/semver/src',
        ),
    );

    public static $classMap = array (
        'Composer\\InstalledVersions' => __DIR__ . '/..' . '/composer/InstalledVersions.php',
        'HumbugBox3150\\Composer\\Semver\\Comparator' => __DIR__ . '/..' . '/composer/semver/src/Comparator.php',
        'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => __DIR__ . '/..' . '/composer/semver/src/CompilingMatcher.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Bound.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Constraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => __DIR__ . '/..' . '/composer/semver/src/Constraint/ConstraintInterface.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchAllConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MultiConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Interval' => __DIR__ . '/..' . '/composer/semver/src/Interval.php',
        'HumbugBox3150\\Composer\\Semver\\Intervals' => __DIR__ . '/..' . '/composer/semver/src/Intervals.php',
        'HumbugBox3150\\Composer\\Semver\\Semver' => __DIR__ . '/..' . '/composer/semver/src/Semver.php',
        'HumbugBox3150\\Composer\\Semver\\VersionParser' => __DIR__ . '/..' . '/composer/semver/src/VersionParser.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => __DIR__ . '/../..' . '/src/Checker.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => __DIR__ . '/../..' . '/src/IO.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => __DIR__ . '/../..' . '/src/IsExtensionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => __DIR__ . '/../..' . '/src/IsFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => __DIR__ . '/../..' . '/src/IsPhpVersionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => __DIR__ . '/../..' . '/src/Printer.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => __DIR__ . '/../..' . '/src/Requirement.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => __DIR__ . '/../..' . '/src/RequirementCollection.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => __DIR__ . '/../..' . '/src/Terminal.php',
    );

    public static function getInitializer(ClassLoader $loader)
    {
        return \Closure::bind(function () use ($loader) {
            $loader->prefixLengthsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixLengthsPsr4;
            $loader->prefixDirsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixDirsPsr4;
            $loader->classMap = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$classMap;

        }, null, ClassLoader::class);
    }
}
<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(\dirname(__FILE__)));
        spl_autoload_unregister(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::getInitializer($loader));
        } else {
            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->setClassMapAuthoritative(true);
        $loader->register(true);

        return $loader;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Comparator
{
    public static function greaterThan($version1, $version2)
    {
        return self::compare($version1, '>', $version2);
    }
    public static function greaterThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '>=', $version2);
    }
    public static function lessThan($version1, $version2)
    {
        return self::compare($version1, '<', $version2);
    }
    public static function lessThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '<=', $version2);
    }
    public static function equalTo($version1, $version2)
    {
        return self::compare($version1, '==', $version2);
    }
    public static function notEqualTo($version1, $version2)
    {
        return self::compare($version1, '!=', $version2);
    }
    public static function compare($version1, $operator, $version2)
    {
        $constraint = new Constraint($operator, $version2);
        return $constraint->matchSpecific(new Constraint('==', $version1), \true);
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Semver
{
    const SORT_ASC = 1;
    const SORT_DESC = -1;
    private static $versionParser;
    public static function satisfies($version, $constraints)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $provider = new Constraint('==', $versionParser->normalize($version));
        $parsedConstraints = $versionParser->parseConstraints($constraints);
        return $parsedConstraints->matches($provider);
    }
    public static function satisfiedBy(array $versions, $constraints)
    {
        $versions = \array_filter($versions, function ($version) use($constraints) {
            return Semver::satisfies($version, $constraints);
        });
        return \array_values($versions);
    }
    public static function sort(array $versions)
    {
        return self::usort($versions, self::SORT_ASC);
    }
    public static function rsort(array $versions)
    {
        return self::usort($versions, self::SORT_DESC);
    }
    private static function usort(array $versions, $direction)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $normalized = array();
        foreach ($versions as $key => $version) {
            $normalizedVersion = $versionParser->normalize($version);
            $normalizedVersion = $versionParser->normalizeDefaultBranch($normalizedVersion);
            $normalized[] = array($normalizedVersion, $key);
        }
        \usort($normalized, function (array $left, array $right) use($direction) {
            if ($left[0] === $right[0]) {
                return 0;
            }
            if (Comparator::lessThan($left[0], $right[0])) {
                return -$direction;
            }
            return $direction;
        });
        $sorted = array();
        foreach ($normalized as $item) {
            $sorted[] = $versions[$item[1]];
        }
        return $sorted;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\ConstraintInterface;
use HumbugBox3150\Composer\Semver\Constraint\MatchAllConstraint;
use HumbugBox3150\Composer\Semver\Constraint\MultiConstraint;
use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class VersionParser
{
    private static $modifierRegex = '[._-]?(?:(stable|beta|b|RC|alpha|a|patch|pl|p)((?:[.-]?\\d+)*+)?)?([.-]?dev)?';
    private static $stabilitiesRegex = 'stable|RC|beta|alpha|dev';
    public static function parseStability($version)
    {
        $version = \preg_replace('{#.+$}i', '', $version);
        if (\strpos($version, 'dev-') === 0 || '-dev' === \substr($version, -4)) {
            return 'dev';
        }
        \preg_match('{' . self::$modifierRegex . '(?:\\+.*)?$}i', \strtolower($version), $match);
        if (!empty($match[3])) {
            return 'dev';
        }
        if (!empty($match[1])) {
            if ('beta' === $match[1] || 'b' === $match[1]) {
                return 'beta';
            }
            if ('alpha' === $match[1] || 'a' === $match[1]) {
                return 'alpha';
            }
            if ('rc' === $match[1]) {
                return 'RC';
            }
        }
        return 'stable';
    }
    public static function normalizeStability($stability)
    {
        $stability = \strtolower($stability);
        return $stability === 'rc' ? 'RC' : $stability;
    }
    public function normalize($version, $fullVersion = null)
    {
        $version = \trim($version);
        $origVersion = $version;
        if (null === $fullVersion) {
            $fullVersion = $version;
        }
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{@(?:' . self::$stabilitiesRegex . ')$}i', $version, $match)) {
            $version = \substr($version, 0, \strlen($version) - \strlen($match[0]));
        }
        if (\in_array($version, array('master', 'trunk', 'default'), \true)) {
            $version = 'dev-' . $version;
        }
        if (\stripos($version, 'dev-') === 0) {
            return 'dev-' . \substr($version, 4);
        }
        if (\preg_match('{^([^,\\s+]++)\\+[^\\s]++$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{^v?(\\d{1,5})(\\.\\d++)?(\\.\\d++)?(\\.\\d++)?' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = $matches[1] . (!empty($matches[2]) ? $matches[2] : '.0') . (!empty($matches[3]) ? $matches[3] : '.0') . (!empty($matches[4]) ? $matches[4] : '.0');
            $index = 5;
        } elseif (\preg_match('{^v?(\\d{4}(?:[.:-]?\\d{2}){1,6}(?:[.:-]?\\d{1,3})?)' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = \preg_replace('{\\D}', '.', $matches[1]);
            $index = 2;
        }
        if (isset($index)) {
            if (!empty($matches[$index])) {
                if ('stable' === $matches[$index]) {
                    return $version;
                }
                $version .= '-' . $this->expandStability($matches[$index]) . (!empty($matches[$index + 1]) ? \ltrim($matches[$index + 1], '.-') : '');
            }
            if (!empty($matches[$index + 2])) {
                $version .= '-dev';
            }
            return $version;
        }
        if (\preg_match('{(.*?)[.-]?dev$}i', $version, $match)) {
            try {
                $normalized = $this->normalizeBranch($match[1]);
                if (\strpos($normalized, 'dev-') === \false) {
                    return $normalized;
                }
            } catch (\Exception $e) {
            }
        }
        $extraMessage = '';
        if (\preg_match('{ +as +' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))?$}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias must be an exact version';
        } elseif (\preg_match('{^' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))? +as +}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias source must be an exact version, if it is a branch name you should prefix it with dev-';
        }
        throw new \UnexpectedValueException('Invalid version string "' . $origVersion . '"' . $extraMessage);
    }
    public function parseNumericAliasPrefix($branch)
    {
        if (\preg_match('{^(?P<version>(\\d++\\.)*\\d++)(?:\\.x)?-dev$}i', $branch, $matches)) {
            return $matches['version'] . '.';
        }
        return \false;
    }
    public function normalizeBranch($name)
    {
        $name = \trim($name);
        if (\preg_match('{^v?(\\d++)(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?$}i', $name, $matches)) {
            $version = '';
            for ($i = 1; $i < 5; ++$i) {
                $version .= isset($matches[$i]) ? \str_replace(array('*', 'X'), 'x', $matches[$i]) : '.x';
            }
            return \str_replace('x', '9999999', $version) . '-dev';
        }
        return 'dev-' . $name;
    }
    public function normalizeDefaultBranch($name)
    {
        if ($name === 'dev-master' || $name === 'dev-default' || $name === 'dev-trunk') {
            return '9999999-dev';
        }
        return $name;
    }
    public function parseConstraints($constraints)
    {
        $prettyConstraint = $constraints;
        $orConstraints = \preg_split('{\\s*\\|\\|?\\s*}', \trim($constraints));
        $orGroups = array();
        foreach ($orConstraints as $constraints) {
            $andConstraints = \preg_split('{(?<!^|as|[=>< ,]) *(?<!-)[, ](?!-) *(?!,|as|$)}', $constraints);
            if (\count($andConstraints) > 1) {
                $constraintObjects = array();
                foreach ($andConstraints as $constraint) {
                    foreach ($this->parseConstraint($constraint) as $parsedConstraint) {
                        $constraintObjects[] = $parsedConstraint;
                    }
                }
            } else {
                $constraintObjects = $this->parseConstraint($andConstraints[0]);
            }
            if (1 === \count($constraintObjects)) {
                $constraint = $constraintObjects[0];
            } else {
                $constraint = new MultiConstraint($constraintObjects);
            }
            $orGroups[] = $constraint;
        }
        $constraint = MultiConstraint::create($orGroups, \false);
        $constraint->setPrettyString($prettyConstraint);
        return $constraint;
    }
    private function parseConstraint($constraint)
    {
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^([^,\\s]*?)@(' . self::$stabilitiesRegex . ')$}i', $constraint, $match)) {
            $constraint = '' !== $match[1] ? $match[1] : '*';
            if ($match[2] !== 'stable') {
                $stabilityModifier = $match[2];
            }
        }
        if (\preg_match('{^(dev-[^,\\s@]+?|[^,\\s@]+?\\.x-dev)#.+$}i', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^(v)?[xX*](\\.[xX*])*$}i', $constraint, $match)) {
            if (!empty($match[1]) || !empty($match[2])) {
                return array(new Constraint('>=', '0.0.0.0-dev'));
            }
            return array(new MatchAllConstraint());
        }
        $versionRegex = 'v?(\\d++)(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?' . self::$modifierRegex . '(?:\\+[^\\s]+)?';
        if (\preg_match('{^~>?' . $versionRegex . '$}i', $constraint, $matches)) {
            if (\strpos($constraint, '~>') === 0) {
                throw new \UnexpectedValueException('Could not parse version constraint ' . $constraint . ': ' . 'Invalid operator "~>", you probably meant to use the "~" operator');
            }
            if (isset($matches[4]) && '' !== $matches[4] && null !== $matches[4]) {
                $position = 4;
            } elseif (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            for ($i = $position; $i >= 0; $i--) {
                if ($matches[$i] === 'x' || $matches[$i] === 'X' || $matches[$i] === '*') {
                    $matches[$i] = '9999999';
                }
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highPosition = \max(1, $position - 1);
            $highVersion = $this->manipulateVersionString($matches, $highPosition, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^\\^' . $versionRegex . '($)}i', $constraint, $matches)) {
            if ('0' !== $matches[1] || '' === $matches[2] || null === $matches[2]) {
                $position = 1;
            } elseif ('0' !== $matches[2] || '' === $matches[3] || null === $matches[3]) {
                $position = 2;
            } else {
                $position = 3;
            }
            if ($position === 2 && ($matches[2] === 'x' || $matches[2] === 'X' || $matches[2] === '*')) {
                $position = 1;
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^v?(\\d++)(?:\\.(\\d++))?(?:\\.(\\d++))?(?:\\.[xX*])++$}', $constraint, $matches)) {
            if (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            $lowVersion = $this->manipulateVersionString($matches, $position) . '-dev';
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            if ($lowVersion === '0.0.0.0-dev') {
                return array(new Constraint('<', $highVersion));
            }
            return array(new Constraint('>=', $lowVersion), new Constraint('<', $highVersion));
        }
        if (\preg_match('{^(?P<from>' . $versionRegex . ') +- +(?P<to>' . $versionRegex . ')($)}i', $constraint, $matches)) {
            $lowStabilitySuffix = '';
            if (empty($matches[6]) && empty($matches[8])) {
                $lowStabilitySuffix = '-dev';
            }
            $lowVersion = $this->normalize($matches['from']);
            $lowerBound = new Constraint('>=', $lowVersion . $lowStabilitySuffix);
            $empty = function ($x) {
                return $x === 0 || $x === '0' ? \false : empty($x);
            };
            if (!$empty($matches[11]) && !$empty($matches[12]) || !empty($matches[14]) || !empty($matches[16])) {
                $highVersion = $this->normalize($matches['to']);
                $upperBound = new Constraint('<=', $highVersion);
            } else {
                $highMatch = array('', $matches[10], $matches[11], $matches[12], $matches[13]);
                $this->normalize($matches['to']);
                $highVersion = $this->manipulateVersionString($highMatch, $empty($matches[11]) ? 1 : 2, 1) . '-dev';
                $upperBound = new Constraint('<', $highVersion);
            }
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^(<>|!=|>=?|<=?|==?)?\\s*(.*)}', $constraint, $matches)) {
            try {
                try {
                    $version = $this->normalize($matches[2]);
                } catch (\UnexpectedValueException $e) {
                    if (\substr($matches[2], -4) === '-dev') {
                        $version = $this->normalize('dev-' . \substr($matches[2], 0, -4));
                    } else {
                        throw $e;
                    }
                }
                $op = $matches[1] ?: '=';
                if ($op !== '==' && $op !== '=' && !empty($stabilityModifier) && self::parseStability($version) === 'stable') {
                    $version .= '-' . $stabilityModifier;
                } elseif ('<' === $op || '>=' === $op) {
                    if (!\preg_match('/-' . self::$modifierRegex . '$/', \strtolower($matches[2]))) {
                        if (\strpos($matches[2], 'dev-') !== 0) {
                            $version .= '-dev';
                        }
                    }
                }
                return array(new Constraint($matches[1] ?: '=', $version));
            } catch (\Exception $e) {
            }
        }
        $message = 'Could not parse version constraint ' . $constraint;
        if (isset($e)) {
            $message .= ': ' . $e->getMessage();
        }
        throw new \UnexpectedValueException($message);
    }
    private function manipulateVersionString($matches, $position, $increment = 0, $pad = '0')
    {
        for ($i = 4; $i > 0; --$i) {
            if ($i > $position) {
                $matches[$i] = $pad;
            } elseif ($i === $position && $increment) {
                $matches[$i] += $increment;
                if ($matches[$i] < 0) {
                    $matches[$i] = $pad;
                    --$position;
                    if ($i === 1) {
                        return null;
                    }
                }
            }
        }
        return $matches[1] . '.' . $matches[2] . '.' . $matches[3] . '.' . $matches[4];
    }
    private function expandStability($stability)
    {
        $stability = \strtolower($stability);
        switch ($stability) {
            case 'a':
                return 'alpha';
            case 'b':
                return 'beta';
            case 'p':
            case 'pl':
                return 'patch';
            case 'rc':
                return 'RC';
            default:
                return $stability;
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

interface ConstraintInterface
{
    public function matches(ConstraintInterface $provider);
    public function compile($operator);
    public function getUpperBound();
    public function getLowerBound();
    public function getPrettyString();
    public function setPrettyString($prettyString);
    public function __toString();
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class MultiConstraint implements ConstraintInterface
{
    protected $constraints;
    protected $prettyString;
    protected $string;
    protected $conjunctive;
    protected $lowerBound;
    protected $upperBound;
    public function __construct(array $constraints, $conjunctive = \true)
    {
        if (\count($constraints) < 2) {
            throw new \InvalidArgumentException('Must provide at least two constraints for a MultiConstraint. Use ' . 'the regular Constraint class for one constraint only or MatchAllConstraint for none. You may use ' . 'MultiConstraint::create() which optimizes and handles those cases automatically.');
        }
        $this->constraints = $constraints;
        $this->conjunctive = $conjunctive;
    }
    public function getConstraints()
    {
        return $this->constraints;
    }
    public function isConjunctive()
    {
        return $this->conjunctive;
    }
    public function isDisjunctive()
    {
        return !$this->conjunctive;
    }
    public function compile($otherOperator)
    {
        $parts = array();
        foreach ($this->constraints as $constraint) {
            $code = $constraint->compile($otherOperator);
            if ($code === 'true') {
                if (!$this->conjunctive) {
                    return 'true';
                }
            } elseif ($code === 'false') {
                if ($this->conjunctive) {
                    return 'false';
                }
            } else {
                $parts[] = '(' . $code . ')';
            }
        }
        if (!$parts) {
            return $this->conjunctive ? 'true' : 'false';
        }
        return $this->conjunctive ? \implode('&&', $parts) : \implode('||', $parts);
    }
    public function matches(ConstraintInterface $provider)
    {
        if (\false === $this->conjunctive) {
            foreach ($this->constraints as $constraint) {
                if ($provider->matches($constraint)) {
                    return \true;
                }
            }
            return \false;
        }
        foreach ($this->constraints as $constraint) {
            if (!$provider->matches($constraint)) {
                return \false;
            }
        }
        return \true;
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return (string) $this;
    }
    public function __toString()
    {
        if ($this->string !== null) {
            return $this->string;
        }
        $constraints = array();
        foreach ($this->constraints as $constraint) {
            $constraints[] = (string) $constraint;
        }
        return $this->string = '[' . \implode($this->conjunctive ? ' ' : ' || ', $constraints) . ']';
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    public static function create(array $constraints, $conjunctive = \true)
    {
        if (0 === \count($constraints)) {
            return new MatchAllConstraint();
        }
        if (1 === \count($constraints)) {
            return $constraints[0];
        }
        $optimized = self::optimizeConstraints($constraints, $conjunctive);
        if ($optimized !== null) {
            list($constraints, $conjunctive) = $optimized;
            if (\count($constraints) === 1) {
                return $constraints[0];
            }
        }
        return new self($constraints, $conjunctive);
    }
    private static function optimizeConstraints(array $constraints, $conjunctive)
    {
        if (!$conjunctive) {
            $left = $constraints[0];
            $mergedConstraints = array();
            $optimized = \false;
            for ($i = 1, $l = \count($constraints); $i < $l; $i++) {
                $right = $constraints[$i];
                if ($left instanceof MultiConstraint && $left->conjunctive && $right instanceof MultiConstraint && $right->conjunctive && ($left0 = (string) $left->constraints[0]) && $left0[0] === '>' && $left0[1] === '=' && ($left1 = (string) $left->constraints[1]) && $left1[0] === '<' && ($right0 = (string) $right->constraints[0]) && $right0[0] === '>' && $right0[1] === '=' && ($right1 = (string) $right->constraints[1]) && $right1[0] === '<' && \substr($left1, 2) === \substr($right0, 3)) {
                    $optimized = \true;
                    $left = new MultiConstraint(\array_merge(array($left->constraints[0], $right->constraints[1]), \array_slice($left->constraints, 2), \array_slice($right->constraints, 2)), \true);
                } else {
                    $mergedConstraints[] = $left;
                    $left = $right;
                }
            }
            if ($optimized) {
                $mergedConstraints[] = $left;
                return array($mergedConstraints, \false);
            }
        }
        return null;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        foreach ($this->constraints as $constraint) {
            if (null === $this->lowerBound && null === $this->upperBound) {
                $this->lowerBound = $constraint->getLowerBound();
                $this->upperBound = $constraint->getUpperBound();
                continue;
            }
            if ($constraint->getLowerBound()->compareTo($this->lowerBound, $this->isConjunctive() ? '>' : '<')) {
                $this->lowerBound = $constraint->getLowerBound();
            }
            if ($constraint->getUpperBound()->compareTo($this->upperBound, $this->isConjunctive() ? '<' : '>')) {
                $this->upperBound = $constraint->getUpperBound();
            }
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class Constraint implements ConstraintInterface
{
    const OP_EQ = 0;
    const OP_LT = 1;
    const OP_LE = 2;
    const OP_GT = 3;
    const OP_GE = 4;
    const OP_NE = 5;
    /**
    @phpstan-var
    */
    private static $transOpStr = array('=' => self::OP_EQ, '==' => self::OP_EQ, '<' => self::OP_LT, '<=' => self::OP_LE, '>' => self::OP_GT, '>=' => self::OP_GE, '<>' => self::OP_NE, '!=' => self::OP_NE);
    /**
    @phpstan-var
    */
    private static $transOpInt = array(self::OP_EQ => '==', self::OP_LT => '<', self::OP_LE => '<=', self::OP_GT => '>', self::OP_GE => '>=', self::OP_NE => '!=');
    /**
    @phpstan-var
    */
    protected $operator;
    protected $version;
    protected $prettyString;
    protected $lowerBound;
    protected $upperBound;
    public function __construct($operator, $version)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $this->operator = self::$transOpStr[$operator];
        $this->version = $version;
    }
    public function getVersion()
    {
        return $this->version;
    }
    public function getOperator()
    {
        return self::$transOpInt[$this->operator];
    }
    public function matches(ConstraintInterface $provider)
    {
        if ($provider instanceof self) {
            return $this->matchSpecific($provider);
        }
        return $provider->matches($this);
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return $this->__toString();
    }
    public static function getSupportedOperators()
    {
        return \array_keys(self::$transOpStr);
    }
    /**
    @phpstan-return
    */
    public static function getOperatorConstant($operator)
    {
        return self::$transOpStr[$operator];
    }
    public function versionCompare($a, $b, $operator, $compareBranches = \false)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $aIsBranch = 'dev-' === \substr($a, 0, 4);
        $bIsBranch = 'dev-' === \substr($b, 0, 4);
        if ($operator === '!=' && ($aIsBranch || $bIsBranch)) {
            return $a !== $b;
        }
        if ($aIsBranch && $bIsBranch) {
            return $operator === '==' && $a === $b;
        }
        if (!$compareBranches && ($aIsBranch || $bIsBranch)) {
            return \false;
        }
        return \version_compare($a, $b, $operator);
    }
    public function compile($otherOperator)
    {
        if ($this->version[0] === 'd' && 'dev-' === \substr($this->version, 0, 4)) {
            if (self::OP_EQ === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('$b && $v === %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                return 'false';
            }
            if (self::OP_NE === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return 'true';
                }
                return '!$b';
            }
            return 'false';
        }
        if (self::OP_EQ === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('\\version_compare($v, %s, \'==\')', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return \sprintf('$b || \\version_compare($v, %s, \'!=\')', \var_export($this->version, \true));
            }
            return \sprintf('!$b && \\version_compare(%s, $v, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$otherOperator]);
        }
        if (self::OP_NE === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('$b || (!$b && \\version_compare($v, %s, \'!=\'))', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return 'true';
            }
            return '!$b';
        }
        if (self::OP_LT === $this->operator || self::OP_LE === $this->operator) {
            if (self::OP_LT === $otherOperator || self::OP_LE === $otherOperator) {
                return '!$b';
            }
        } elseif (self::OP_GT === $this->operator || self::OP_GE === $this->operator) {
            if (self::OP_GT === $otherOperator || self::OP_GE === $otherOperator) {
                return '!$b';
            }
        }
        if (self::OP_NE === $otherOperator) {
            return 'true';
        }
        $codeComparison = \sprintf('\\version_compare($v, %s, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$this->operator]);
        if ($this->operator === self::OP_LE) {
            if ($otherOperator === self::OP_GT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        } elseif ($this->operator === self::OP_GE) {
            if ($otherOperator === self::OP_LT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        }
        return \sprintf('!$b && %s', $codeComparison);
    }
    public function matchSpecific(Constraint $provider, $compareBranches = \false)
    {
        $noEqualOp = \str_replace('=', '', self::$transOpInt[$this->operator]);
        $providerNoEqualOp = \str_replace('=', '', self::$transOpInt[$provider->operator]);
        $isEqualOp = self::OP_EQ === $this->operator;
        $isNonEqualOp = self::OP_NE === $this->operator;
        $isProviderEqualOp = self::OP_EQ === $provider->operator;
        $isProviderNonEqualOp = self::OP_NE === $provider->operator;
        if ($isNonEqualOp || $isProviderNonEqualOp) {
            if ($isNonEqualOp && !$isProviderNonEqualOp && !$isProviderEqualOp && 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            if ($isProviderNonEqualOp && !$isNonEqualOp && !$isEqualOp && 'dev-' === \substr($this->version, 0, 4)) {
                return \false;
            }
            if (!$isEqualOp && !$isProviderEqualOp) {
                return \true;
            }
            return $this->versionCompare($provider->version, $this->version, '!=', $compareBranches);
        }
        if ($this->operator !== self::OP_EQ && $noEqualOp === $providerNoEqualOp) {
            if ('dev-' === \substr($this->version, 0, 4) || 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            return \true;
        }
        $version1 = $isEqualOp ? $this->version : $provider->version;
        $version2 = $isEqualOp ? $provider->version : $this->version;
        $operator = $isEqualOp ? $provider->operator : $this->operator;
        if ($this->versionCompare($version1, $version2, self::$transOpInt[$operator], $compareBranches)) {
            return !(self::$transOpInt[$provider->operator] === $providerNoEqualOp && self::$transOpInt[$this->operator] !== $noEqualOp && \version_compare($provider->version, $this->version, '=='));
        }
        return \false;
    }
    public function __toString()
    {
        return self::$transOpInt[$this->operator] . ' ' . $this->version;
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        if (\strpos($this->version, 'dev-') === 0) {
            $this->lowerBound = Bound::zero();
            $this->upperBound = Bound::positiveInfinity();
            return;
        }
        switch ($this->operator) {
            case self::OP_EQ:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_LT:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \false);
                break;
            case self::OP_LE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_GT:
                $this->lowerBound = new Bound($this->version, \false);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_GE:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_NE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = Bound::positiveInfinity();
                break;
        }
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

class Terminal
{
    private static $width;
    private static $height;
    private static $stty;
    public function getWidth()
    {
        $width = \getenv('COLUMNS');
        if (\false !== $width) {
            return (int) \trim($width);
        }
        if (null === self::$width) {
            self::initDimensions();
        }
        return self::$width ?: 80;
    }
    public function getHeight()
    {
        $height = \getenv('LINES');
        if (\false !== $height) {
            return (int) \trim($height);
        }
        if (null === self::$height) {
            self::initDimensions();
        }
        return self::$height ?: 50;
    }
    public static function hasSttyAvailable()
    {
        if (null !== self::$stty) {
            return self::$stty;
        }
        if (!\function_exists('exec')) {
            return \false;
        }
        \exec('stty 2>&1', $output, $exitcode);
        return self::$stty = 0 === $exitcode;
    }
    private static function initDimensions()
    {
        if ('\\' === \DIRECTORY_SEPARATOR) {
            if (\preg_match('/^(\\d+)x(\\d+)(?: \\((\\d+)x(\\d+)\\))?$/', \trim(\getenv('ANSICON')), $matches)) {
                self::$width = (int) $matches[1];
                self::$height = isset($matches[4]) ? (int) $matches[4] : (int) $matches[2];
            } elseif (!self::hasVt100Support() && self::hasSttyAvailable()) {
                self::initDimensionsUsingStty();
            } elseif (null !== ($dimensions = self::getConsoleMode())) {
                self::$width = (int) $dimensions[0];
                self::$height = (int) $dimensions[1];
            }
        } else {
            self::initDimensionsUsingStty();
        }
    }
    private static function hasVt100Support()
    {
        return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\fopen('php://stdout', 'wb'));
    }
    private static function initDimensionsUsingStty()
    {
        if ($sttyString = self::getSttyColumns()) {
            if (\preg_match('/rows.(\\d+);.columns.(\\d+);/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            } elseif (\preg_match('/;.(\\d+).rows;.(\\d+).columns/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            }
        }
    }
    private static function getConsoleMode()
    {
        $info = self::readFromProcess('mode CON');
        if (null === $info || !\preg_match('/--------+\\r?\\n.+?(\\d+)\\r?\\n.+?(\\d+)\\r?\\n/', $info, $matches)) {
            return null;
        }
        return array((int) $matches[2], (int) $matches[1]);
    }
    private static function getSttyColumns()
    {
        return self::readFromProcess('stty -a | grep columns');
    }
    private static function readFromProcess($command)
    {
        if (!\function_exists('proc_open')) {
            return null;
        }
        $descriptorspec = array(1 => array('pipe', 'w'), 2 => array('pipe', 'w'));
        $process = \proc_open($command, $descriptorspec, $pipes, null, null, array('suppress_errors' => \true));
        if (!\is_resource($process)) {
            return null;
        }
        $info = \stream_get_contents($pipes[1]);
        \fclose($pipes[1]);
        \fclose($pipes[2]);
        \proc_close($process);
        return $info;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IO
{
    const VERBOSITY_QUIET = 16;
    const VERBOSITY_NORMAL = 32;
    const VERBOSITY_VERBOSE = 64;
    const VERBOSITY_VERY_VERBOSE = 128;
    const VERBOSITY_DEBUG = 256;
    private $interactive;
    private $verbosity = self::VERBOSITY_NORMAL;
    private $colorSupport;
    private $options;
    public function __construct()
    {
        $this->options = \implode(' ', $_SERVER['argv']);
        $shellVerbosity = $this->configureVerbosity();
        $this->interactive = $this->checkInteractivity($shellVerbosity);
        $this->colorSupport = $this->checkColorSupport();
    }
    public function isInteractive()
    {
        return $this->interactive;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function hasColorSupport()
    {
        return $this->colorSupport;
    }
    public function hasParameter($values)
    {
        $values = (array) $values;
        foreach ($values as $value) {
            $regexp = \sprintf('/\\s%s\\b/', \str_replace(' ', '\\s+', \preg_quote($value, '/')));
            if (1 === \preg_match($regexp, $this->options)) {
                return \true;
            }
        }
        return \false;
    }
    private function checkInteractivity($shellVerbosity)
    {
        if (-1 === $shellVerbosity) {
            return \false;
        }
        if (\true === $this->hasParameter(array('--no-interaction', '-n'))) {
            return \false;
        }
        if (\function_exists('posix_isatty') && !@\posix_isatty(\STDOUT) && \false === \getenv('SHELL_INTERACTIVE')) {
            return \false;
        }
        return \true;
    }
    private function configureVerbosity()
    {
        switch ($shellVerbosity = (int) \getenv('SHELL_VERBOSITY')) {
            case -1:
                $this->verbosity = self::VERBOSITY_QUIET;
                break;
            case 1:
                $this->verbosity = self::VERBOSITY_VERBOSE;
                break;
            case 2:
                $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
                break;
            case 3:
                $this->verbosity = self::VERBOSITY_DEBUG;
                break;
            default:
                $shellVerbosity = 0;
                break;
        }
        if ($this->hasParameter(array('--quiet', '-q'))) {
            $this->verbosity = self::VERBOSITY_QUIET;
            $shellVerbosity = -1;
        } elseif ($this->hasParameter(array('-vvv', '--verbose=3', '--verbose 3'))) {
            $this->verbosity = self::VERBOSITY_DEBUG;
            $shellVerbosity = 3;
        } elseif ($this->hasParameter(array('-vv', '--verbose=2', '--verbose 2'))) {
            $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
            $shellVerbosity = 2;
        } elseif ($this->hasParameter(array('-v', '--verbose=1', '--verbose 1', '--verbose'))) {
            $this->verbosity = self::VERBOSITY_VERBOSE;
            $shellVerbosity = 1;
        }
        return $shellVerbosity;
    }
    private function checkColorSupport()
    {
        if ($this->hasParameter(array('--ansi'))) {
            return \true;
        }
        if ($this->hasParameter(array('--no-ansi'))) {
            return \false;
        }
        if (\DIRECTORY_SEPARATOR === '\\') {
            return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\STDOUT) || \false !== \getenv('ANSICON') || 'ON' === \getenv('ConEmuANSI') || 'xterm' === \getenv('TERM');
        }
        if (\function_exists('stream_isatty')) {
            return \stream_isatty(\STDOUT);
        }
        if (\function_exists('posix_isatty')) {
            return \posix_isatty(\STDOUT);
        }
        $stat = \fstat(\STDOUT);
        return $stat ? 020000 === ($stat['mode'] & 0170000) : \false;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IsExtensionFulfilled implements IsFulfilled
{
    private $requiredExtension;
    public function __construct($requiredExtension)
    {
        $this->requiredExtension = $requiredExtension;
    }
    public function __invoke()
    {
        return \extension_loaded($this->requiredExtension);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Checker
{
    private static $requirementsConfig;
    public static function checkRequirements()
    {
        $requirements = self::retrieveRequirements();
        $checkPassed = $requirements->evaluateRequirements();
        $io = new IO();
        self::printCheck($checkPassed, new Printer($io->getVerbosity(), $io->hasColorSupport()), $requirements);
        return $checkPassed;
    }
    public static function printCheck($checkPassed, Printer $printer, RequirementCollection $requirements)
    {
        if (\false === $checkPassed && IO::VERBOSITY_VERY_VERBOSE > $printer->getVerbosity()) {
            $printer->setVerbosity(IO::VERBOSITY_VERY_VERBOSE);
        }
        $verbosity = IO::VERBOSITY_VERY_VERBOSE;
        $iniPath = $requirements->getPhpIniPath();
        $printer->title('Box Requirements Checker', $verbosity);
        $printer->printv('> Using PHP ', $verbosity);
        $printer->printvln(\PHP_VERSION, $verbosity, 'green');
        $printer->printvln('> PHP is using the following php.ini file:', $verbosity);
        if ($iniPath) {
            $printer->printvln('  ' . $iniPath, $verbosity, 'green');
        } else {
            $printer->printvln('  WARNING: No configuration file (php.ini) used by PHP!', $verbosity, 'yellow');
        }
        $printer->printvln('', $verbosity);
        if (\count($requirements) > 0) {
            $printer->printvln('> Checking Box requirements:', $verbosity);
            $printer->printv('  ', $verbosity);
        } else {
            $printer->printvln('> No requirements found.', $verbosity);
        }
        $errorMessages = array();
        foreach ($requirements->getRequirements() as $requirement) {
            if ($errorMessage = $printer->getRequirementErrorMessage($requirement)) {
                if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                    $printer->printvln('✘ ' . $requirement->getTestMessage(), IO::VERBOSITY_DEBUG, 'red');
                    $printer->printv('  ', IO::VERBOSITY_DEBUG);
                    $errorMessages[] = $errorMessage;
                } else {
                    $printer->printv('E', $verbosity, 'red');
                    $errorMessages[] = $errorMessage;
                }
                continue;
            }
            if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                $printer->printvln('✔ ' . $requirement->getHelpText(), IO::VERBOSITY_DEBUG, 'green');
                $printer->printv('  ', IO::VERBOSITY_DEBUG);
            } else {
                $printer->printv('.', $verbosity, 'green');
            }
        }
        if (IO::VERBOSITY_DEBUG !== $printer->getVerbosity() && \count($requirements) > 0) {
            $printer->printvln('', $verbosity);
        }
        if ($requirements->evaluateRequirements()) {
            $printer->block('OK', 'Your system is ready to run the application.', $verbosity, 'success');
        } else {
            $printer->block('ERROR', 'Your system is not ready to run the application.', $verbosity, 'error');
            $printer->title('Fix the following mandatory requirements:', $verbosity, 'red');
            foreach ($errorMessages as $errorMessage) {
                $printer->printv(' * ' . $errorMessage, $verbosity);
            }
        }
        $printer->printvln('', $verbosity);
    }
    private static function retrieveRequirements()
    {
        if (null === self::$requirementsConfig) {
            self::$requirementsConfig = __DIR__ . '/../.requirements.php';
        }
        $config = (require self::$requirementsConfig);
        $requirements = new RequirementCollection();
        foreach ($config as $constraint) {
            $requirements->addRequirement('php' === $constraint['type'] ? new IsPhpVersionFulfilled($constraint['condition']) : new IsExtensionFulfilled($constraint['condition']), $constraint['message'], $constraint['helpMessage']);
        }
        return $requirements;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use HumbugBox3150\Composer\Semver\Semver;
final class IsPhpVersionFulfilled implements IsFulfilled
{
    private $requiredPhpVersion;
    public function __construct($requiredPhpVersion)
    {
        $this->requiredPhpVersion = $requiredPhpVersion;
    }
    public function __invoke()
    {
        return Semver::satisfies(\sprintf('%d.%d.%d', \PHP_MAJOR_VERSION, \PHP_MINOR_VERSION, \PHP_RELEASE_VERSION), $this->requiredPhpVersion);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use ArrayIterator;
use Countable;
use IteratorAggregate;
use ReturnTypeWillChange;
use Traversable;
final class RequirementCollection implements IteratorAggregate, Countable
{
    private $requirements = array();
    #[\ReturnTypeWillChange]
    public function getIterator()
    {
        return new ArrayIterator($this->requirements);
    }
    #[\ReturnTypeWillChange]
    public function count()
    {
        return \count($this->requirements);
    }
    public function add(Requirement $requirement)
    {
        $this->requirements[] = $requirement;
    }
    public function addRequirement($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->add(new Requirement($checkIsFulfilled, $testMessage, $helpText));
    }
    public function getRequirements()
    {
        return $this->requirements;
    }
    public function getPhpIniPath()
    {
        return \get_cfg_var('cfg_file_path');
    }
    public function evaluateRequirements()
    {
        return \array_reduce($this->requirements, function ($checkPassed, Requirement $requirement) {
            return $checkPassed && $requirement->isFulfilled();
        }, \true);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Printer
{
    private $styles = array('reset' => "\x1b[0m", 'red' => "\x1b[31m", 'green' => "\x1b[32m", 'yellow' => "\x1b[33m", 'title' => "\x1b[33m", 'error' => "\x1b[37;41m", 'success' => "\x1b[30;42m");
    private $verbosity;
    private $supportColors;
    private $width;
    public function __construct($verbosity, $supportColors, $width = null)
    {
        if (null === $width) {
            $terminal = new Terminal();
            $width = $terminal->getWidth();
        }
        $this->verbosity = $verbosity;
        $this->supportColors = $supportColors;
        $this->width = $width ?: 80;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function setVerbosity($verbosity)
    {
        $this->verbosity = $verbosity;
    }
    public function title($title, $verbosity, $style = null)
    {
        if (null === $style) {
            $style = 'title';
        }
        $this->printvln('', $verbosity, $style);
        $this->printvln($title, $verbosity, $style);
        $this->printvln(\str_repeat('=', \min(\strlen($title), $this->width)), $verbosity, $style);
        $this->printvln('', $verbosity, $style);
    }
    public function getRequirementErrorMessage(Requirement $requirement)
    {
        if ($requirement->isFulfilled()) {
            return null;
        }
        $errorMessage = \wordwrap($requirement->getTestMessage(), $this->width - 3, \PHP_EOL . '   ') . \PHP_EOL;
        return $errorMessage;
    }
    public function block($title, $message, $verbosity, $style = null)
    {
        $prefix = ' [' . $title . '] ';
        $lineLength = $this->width - \strlen($prefix) - 1;
        if ($lineLength < 0) {
            $lineLength = 0;
        }
        $message = $prefix . \trim($message);
        $lines = array();
        $remainingMessage = $message;
        $wrapped = \wordwrap($remainingMessage, $lineLength, '¬');
        $wrapped = \explode('¬', $wrapped);
        do {
            $line = \array_shift($wrapped);
            if ($lines && $lineLength > 0) {
                $line = \str_repeat(' ', \strlen($prefix)) . \ltrim($line);
            }
            $lines[] = \str_pad($line, $this->width, ' ', \STR_PAD_RIGHT);
        } while (\count($wrapped));
        $this->printvln('', $verbosity);
        $this->printvln(\str_repeat(' ', $this->width), $verbosity, $style);
        foreach ($lines as $line) {
            $this->printvln($line, $verbosity, $style);
        }
        $this->printv(\str_repeat(' ', $this->width), $verbosity, $style);
        $this->printvln('', $verbosity);
    }
    public function printvln($message, $verbosity, $style = null)
    {
        $this->printv($message, $verbosity, $style);
        $this->printv(\PHP_EOL, $verbosity, null);
    }
    public function printv($message, $verbosity, $style = null)
    {
        if ($verbosity > $this->verbosity) {
            return;
        }
        $message = \wordwrap($message, $this->width);
        $message = \sprintf('%s%s%s', $this->supportColors && isset($this->styles[$style]) ? $this->styles[$style] : '', $message, $this->supportColors ? $this->styles['reset'] : '');
        echo $message;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

interface IsFulfilled
{
    public function __invoke();
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Requirement
{
    private $checkIsFulfilled;
    private $fulfilled;
    private $testMessage;
    private $helpText;
    public function __construct($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->checkIsFulfilled = $checkIsFulfilled;
        $this->testMessage = $testMessage;
        $this->helpText = $helpText;
    }
    public function isFulfilled()
    {
        if (null === $this->fulfilled) {
            $this->fulfilled = $this->checkIsFulfilled->__invoke();
        }
        return (bool) $this->fulfilled;
    }
    public function getIsFullfilledChecker()
    {
        return $this->checkIsFulfilled;
    }
    public function getTestMessage()
    {
        return $this->testMessage;
    }
    public function getHelpText()
    {
        return $this->helpText;
    }
}
                   GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
<!doctype html><html lang="en"><head><meta charset="utf-8"><title>Contao Manager</title><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="description" content=""><meta name="robots" content="noindex,follow"><meta http-equiv="Content-Security-Policy" content="img-src 'self' data: blob: contao.github.io extensions.contao.org; object-src 'none'"/><link rel="icon" type="image/x-icon" href="assets/favicon.ico"><link rel="icon" type="image/png" sizes="16x16" href="assets/favicon-16x16.png"><link rel="icon" type="image/png" sizes="32x32" href="assets/favicon-32x32.png"><link rel="icon" type="image/png" sizes="48x48" href="assets/favicon-48x48.png"><link rel="manifest" href="assets/manifest.webmanifest"><meta name="mobile-web-app-capable" content="yes"><meta name="theme-color" content="#ffffff"><meta name="application-name" content="Contao Manager"><link rel="apple-touch-icon" sizes="57x57" href="assets/apple-touch-icon-57x57.png"><link rel="apple-touch-icon" sizes="60x60" href="assets/apple-touch-icon-60x60.png"><link rel="apple-touch-icon" sizes="72x72" href="assets/apple-touch-icon-72x72.png"><link rel="apple-touch-icon" sizes="76x76" href="assets/apple-touch-icon-76x76.png"><link rel="apple-touch-icon" sizes="114x114" href="assets/apple-touch-icon-114x114.png"><link rel="apple-touch-icon" sizes="120x120" href="assets/apple-touch-icon-120x120.png"><link rel="apple-touch-icon" sizes="144x144" href="assets/apple-touch-icon-144x144.png"><link rel="apple-touch-icon" sizes="152x152" href="assets/apple-touch-icon-152x152.png"><link rel="apple-touch-icon" sizes="167x167" href="assets/apple-touch-icon-167x167.png"><link rel="apple-touch-icon" sizes="180x180" href="assets/apple-touch-icon-180x180.png"><link rel="apple-touch-icon" sizes="1024x1024" href="assets/apple-touch-icon-1024x1024.png"><meta name="apple-mobile-web-app-capable" content="yes"><meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"><meta name="apple-mobile-web-app-title" content="Contao Manager"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-640x1136.png"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1136x640.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-750x1334.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1334x750.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1125x2436.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2436x1125.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1170x2532.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2532x1170.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1179x2556.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2556x1179.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-828x1792.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1792x828.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2688.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2688x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2208.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2208x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1284x2778.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2778x1284.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1290x2796.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2796x1290.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1488x2266.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2266x1488.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1536x2048.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2048x1536.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1620x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1620.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1640x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1640.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2388.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2388x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2224.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2224x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-2048x2732.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2732x2048.png"><meta name="msapplication-TileColor" content="#ffffff"><meta name="msapplication-TileImage" content="assets/mstile-144x144.png"><meta name="msapplication-config" content="assets/browserconfig.xml"><link rel="yandex-tableau-widget" href="assets/yandex-browser-manifest.json"><script defer="defer" src="js/chunk-vendors.752082b1.js"></script><script defer="defer" src="js/app.6815cc76.js"></script><link href="css/chunk-vendors.4e650cae.css" rel="stylesheet"><link href="css/app.4499f9f0.css" rel="stylesheet"></head><body><noscript><strong>We're sorry but the Contao Manager does not work without JavaScript enabled. Please enable it to continue.</strong></noscript></body></html><?php

declare(strict_types=1);

/*
 * This file is part of Contao Manager.
 *
 * (c) Contao Association
 *
 * @license LGPL-3.0-or-later
 */

use Contao\ManagerApi\ApiKernel;
use Contao\ManagerApi\HttpKernel\ApiProblemResponse;
use Symfony\Component\HttpFoundation\Request;

require __DIR__.'/../vendor/autoload.php';

try {
    // @phpstan-ignore identical.alwaysFalse
    $kernel = new ApiKernel('@symfony_env@' === 'prod' ? 'prod' : 'dev');

    $request = Request::createFromGlobals();
    $response = $kernel->handle($request);
    $response->send();
    $kernel->terminate($request, $response);
} catch (Throwable $throwable) {
    ApiProblemResponse::createFromException($throwable, '@symfony_env@' !== 'prod')->send();
}
.view-recovery__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0 10px;text-align:center}.view-recovery__icon{background:var(--contao);border-radius:10px;padding:10px}.view-recovery__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-recovery__content{margin:0 30px 50px}@media(min-width:960px){.view-recovery__content{margin-left:50px;margin-right:50px}}.view-recovery__description{font-weight:600;max-width:600px;margin:0 auto;text-align:center}.view-recovery__console{margin:30px 0 60px}.view-recovery__option{margin:50px 0 0;padding:20px 20px 30px;background:var(--table-odd-bg);text-align:center}.view-recovery__option h3{position:relative;top:-40px;margin-bottom:-25px;font-size:2em;font-weight:300}.view-recovery__option button{margin-top:1.5em}.view-recovery__failed{margin:10px 0;color:var(--btn-alert);font-weight:600}.boot-check{padding:10px}.boot-check:after{display:table;clear:both;content:""}.boot-check__icon{float:left}.boot-check__icon .sk-circle{width:34px;height:34px;margin:3px}.boot-check__icon svg{display:block;width:40px;height:40px}.boot-check__icon--success svg{fill:var(--btn-primary)}.boot-check__icon--info svg,.boot-check__icon--warning svg{fill:var(--btn-warning)}.boot-check__icon--error svg{fill:var(--btn-alert)}.boot-check__label{margin-left:50px}.boot-check__description,.boot-check__detail,.boot-check__title{margin:0;line-height:inherit;overflow:hidden;text-overflow:ellipsis}.boot-check__detail{margin-top:5px;font-size:12px}.boot-check__action{margin-left:50px}.boot-check__action button{margin:15px 0 10px;height:33px;line-height:33px}@media(min-width:960px){.boot-check__label{float:left;width:540px;margin-left:10px}.boot-check__action{float:right;margin:0 0 0 10px;width:140px;text-align:center}.boot-check__action button{margin:3px 0}.boot-check__action a[target=_blank]{display:inline-block;margin:10px 0;padding-left:20px;background:var(--svg--link-blank) left center no-repeat;background-size:16px 16px}}.view-boot__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-boot__icon{background:var(--contao);border-radius:10px;padding:10px}.view-boot__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-boot__description{margin:0;font-weight:600}.view-boot__loading{width:30px;margin:0 auto 40px}.view-boot__loading .sk-circle{width:30px;height:30px}.view-boot__checks{margin:0 16px 50px}.view-boot__checks .boot-check:nth-child(odd){border-radius:var(--border-radius);background:var(--table-odd-bg)}.view-boot__summary{margin:50px 0 0}.view-boot__summary--error svg{width:100%;height:40px;fill:var(--btn-alert)}.view-boot__issue{max-width:60%;margin:10px auto;text-align:center;color:var(--btn-alert);line-height:1.2em}.view-boot__safeMode{margin:2em auto 0}.view-boot__continue,.view-boot__safeMode{clear:both;display:block!important;width:220px!important}.view-boot__continue{margin:0 auto}@media(min-width:960px){.view-boot__checks{margin:0 80px 50px}}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.view-login__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-login__product{margin-top:15px;font-size:38px;font-weight:100;line-height:1}.view-login__form{position:relative;max-width:280px;margin:0 auto 60px}.view-login__form input{padding-right:30px;margin:5px 0 10px}.view-login__locked{max-width:290px;margin:-20px auto 60px;padding:20px;background:var(--btn-alert);color:#fff;text-align:center}.view-login__locked strong{white-space:pre}.view-login__headline{margin-bottom:0}.view-login__description{margin-top:.5em;margin-bottom:20px}.view-login label{position:absolute;text-indent:-999em;pointer-events:none}.view-login label[for=ctrl_username]{top:0;bottom:0;margin:auto;right:13px;width:16px;height:16px;background:url(../img/person.00d78897.svg) 0 0 no-repeat;background-size:16px 16px;z-index:10}.view-login label[for=ctrl_password]{top:0;bottom:0;margin:auto;right:12px;width:16px;height:16px;background:url(../img/lock.3c42a55f.svg) 0 0 no-repeat;background-size:14px 14px;z-index:10}.view-login__password input,.view-login__user input{margin:0}.view-login__user input{border-radius:var(--border-radius) var(--border-radius) 0 0!important}.view-login__password{margin-top:-1px;margin-bottom:10px}.view-login__password input{border-radius:0 0 var(--border-radius) var(--border-radius)!important}.view-login .widget-text--password button{opacity:0}.view-login__link{display:block;margin-top:2em;font-size:12px;text-align:center}.view-login__button{margin:3px 0}.view-login__button .sk-circle{color:#fff;text-align:center}.view-login__or{display:grid;gap:15px;grid-template-columns:1fr auto 1fr;padding:12px}.view-login__or:after,.view-login__or:before{align-self:center;border-top:1px solid var(--border);content:""}.view-login .fragment-footer{display:block}body.nav-active{overflow:hidden!important}#app{transition:transform .4s cubic-bezier(.55,0,.1,1)}.nav-active #app{overflow-y:visible;transform:translateX(-280px)}.nav-active #app .navigation__group--main{visibility:visible}@media(min-width:1024px){.nav-active #app{transform:none}}.navigation__toggle{display:block;float:right;position:relative;margin:5px 15px;padding:0;width:30px;height:30px;background:none;border:none;cursor:pointer;z-index:20}.navigation__toggle span,.navigation__toggle span:after,.navigation__toggle span:before{content:"";display:block;width:100%;height:4px;background:var(--text);border-radius:4px;position:absolute}.navigation__toggle span{transition-duration:75ms;transition-timing-function:cubic-bezier(.215,.61,.355,1);top:50%;margin-top:-2px}.navigation__toggle span:before{top:-10px;transition:top 75ms ease .12s,opacity 75ms ease}.navigation__toggle span:after{bottom:-10px;transition:bottom 75ms ease .12s,transform 75ms cubic-bezier(.55,.055,.675,.19)}.nav-active .navigation__toggle span{transform:rotate(45deg);transition-delay:.12s;transition-timing-function:cubic-bezier(.215,.61,.355,1)}.nav-active .navigation__toggle span:before{top:0;opacity:0;transition:top 75ms ease,opacity 75ms ease .12s}.nav-active .navigation__toggle span:after{transition:bottom 75ms ease,transform 75ms cubic-bezier(.215,.61,.355,1) .12s;bottom:0;transform:rotate(-90deg)}.navigation__group,.navigation__item{list-style-type:none;margin:0;padding:0}.navigation__group--main{position:fixed;top:0;bottom:0;right:-280px;width:280px;visibility:hidden;padding:20px;overflow-y:auto;overflow-scrolling:touch;background:var(--header-main-bg);border-left:1px solid var(--header-bdr);z-index:10}.navigation__item a,.navigation__item button{display:block;margin:0;padding:12px 10px;font-size:16px;color:var(--text);white-space:pre;background:none;border:none}.navigation__item a:hover,.navigation__item button:hover{text-decoration:none}.navigation__item a[href]:hover,.navigation__item button[href]:hover{color:var(--link)}.navigation__item--main>a,.navigation__item--main>button{text-transform:uppercase}.navigation__item--sub>a{margin-left:15px}.navigation__item--icon svg{display:none}.navigation__item-badge{position:relative;top:-2px;margin-left:8px;padding:2px 5px;font-size:10px;color:var(--clr-btn);font-weight:600;background:var(--contao);border-radius:40%}@media(min-width:1024px){.navigation__toggle{display:none}.navigation__group--main{display:flex;visibility:visible;position:inherit;inset:auto;width:auto;padding:0;overflow:visible;background:none;border:none;box-shadow:none;transform:none;transition:none}.navigation__group--sub{position:absolute;left:50%;min-width:180px;margin-top:-3px;text-align:center;background:var(--form-bg);border-top:3px solid var(--link);border-radius:5px;transform:translateX(-50%);z-index:100;box-shadow:0 0 2px var(--shadow);transition:opacity var(--am-close-transition-duration) ease}.navigation__group--sub:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--link) transparent;content:""}.navigation__group--sub.hide{display:none!important}.navigation__group--sub.transitioning{display:block!important;opacity:0}.navigation__group--sub.show{display:block!important;opacity:1;transition:opacity var(--am-open-transition-duration) ease}.navigation__group--right{left:auto;right:7px;transform:translateX(0)}.navigation__group--right:before{left:auto;right:18px}.navigation__item{position:relative;padding:0 8px}.navigation__item.router-link-active>a,.navigation__item:hover>a{color:var(--link)!important;border-bottom:3px solid var(--link)}.navigation__item:hover>.navigation__group--sub{display:block}.navigation__item--sub{display:block;margin:calc(var(--border-radius)/2) 0;padding:0 2px;border-radius:var(--border-radius)}.navigation__item--sub a{margin:0;border:none!important}.navigation__item--sub.router-link-active,.navigation__item--sub:hover{background:var(--focus)}.navigation__item--sub.router-link-active a,.navigation__item--sub:hover a{color:var(--text)!important}.navigation__item--icon>button{padding-top:7px}.navigation__item--icon>button svg{display:inline;position:relative;top:4px;width:22px;height:22px;fill:var(--text)}.navigation__item--icon>button:hover svg{fill:var(--link)}.navigation__item--icon>button span{display:none}.navigation:hover li>a{border:none}.navigation:hover li:hover>a{border-bottom:3px solid var(--link)}.navigation:hover li:hover>a svg{fill:var(--link)}}.logout-warning{text-align:center}.logout-warning__countdown{margin:20px 0;font:600 4em/1.6 SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:var(--btn-warning)}.fragment-footer{width:280px;margin:10px auto 0;padding:15px 0 25px;font-size:12px;text-align:center;border-top:1px solid var(--footer-bdr)}.fragment-footer--main{width:auto;margin-top:52px!important;padding:20px 0}.fragment-footer--boxed{border-color:var(--footer-fragment-bdr)}.fragment-footer__product{font-weight:300}.fragment-footer__links{margin:5px 0 0;padding:0;list-style-type:none}.fragment-footer__links li{display:inline-block}.fragment-footer__links li:not(:first-child):before{content:"|";padding:0 10px 0 8px}.fragment-footer__links a{display:inline!important;color:var(--link-footer)}.fragment-footer__settings{margin-top:10px;display:flex;flex-flow:column;justify-content:center;gap:10px}@media(min-width:960px){.fragment-footer{display:grid;grid-auto-flow:column;grid-auto-columns:minmax(0,1fr);gap:16px;align-content:center}.fragment-footer--boxed .fragment-footer__product,.fragment-footer--main .fragment-footer__product{margin-right:auto}.fragment-footer--boxed .fragment-footer__links,.fragment-footer--main .fragment-footer__links{order:15;margin:0 0 0 auto}.fragment-footer--boxed .fragment-footer__settings,.fragment-footer--main .fragment-footer__settings{flex-flow:row;margin-top:0}.fragment-footer--boxed{width:840px}}.layout-main{overflow:hidden;min-height:100vh}.layout-main__header{display:flex;justify-content:space-between;height:56px;padding:8px;background:var(--header-main-bg)}.layout-main__header--margin{margin-bottom:30px}.layout-main__badge-title{background:var(--border);color:var(--text);padding:2px 5px;position:relative;top:-5px;border-radius:8px;font-size:.75rem;font-weight:600;line-height:1;display:-webkit-box;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;word-break:break-word;overflow:hidden;text-overflow:ellipsis}.layout-main__subheader{margin:0 0 45px;padding:20px 0;background:var(--header-bg);border-bottom:1px solid var(--header-bdr)}.layout-main__subheader-inside{display:flex;justify-content:center;align-items:center;flex-direction:column}.layout-main__news{width:320px;height:50px;margin-bottom:20px}.layout-main__news a,.layout-main__news img{display:block}.layout-main .search-bar{width:100%;margin:0}.layout-main__logo{display:inline;color:var(--text);text-decoration:none;font-weight:100;font-size:27px;line-height:40px}.layout-main__logo img{float:left;margin:0 10px 0 12px}@media(min-width:1024px){.layout-main__logo img{margin-left:0}}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{position:relative;margin:0 20px}.layout-main__has-badge-title{display:flex;justify-content:space-between}.layout-main__has-badge-title .layout-main__logo{display:flex}.layout-main__has-badge-title .layout-main__title{display:flex;flex-wrap:wrap;align-items:center;line-height:1;column-gap:10px;row-gap:5px}@media(max-width:600px){.layout-main__badge-title{max-width:220px}}@media(min-width:700px){.layout-main__subheader-inside{flex-direction:row}.layout-main__news{margin:0 20px 0 0}}@media(min-width:1024px){.layout-main__has-badge-title .navigation__group--main{display:flex}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:960px;margin:0 auto}}@media(min-width:1200px){.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:1180px}}.confirm-button{position:relative}.confirm-button__icon{display:none;position:absolute;opacity:0;z-index:100}.confirm-button__icon--confirm{display:block;animation:confirm_button .5s ease-out 0s}.confirm-button__icon svg{fill:var(--btn-primary);width:100%;height:100%}@keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}.package-tools{position:relative;clear:both;text-align:center}@media(min-width:800px){.package-tools{margin-bottom:40px}}.package-tools__button.widget-button{margin-bottom:10px}@media(min-width:800px){.package-tools{display:flex;justify-content:center;align-items:center}.package-tools__button.widget-button{width:auto;margin:0 15px;padding:0 15px}}.package-actions{position:fixed;left:0;right:0;bottom:0;max-height:0;background:#000;background:rgba(0,0,0,.8);color:#fff;transition:max-height .4s ease;z-index:100}.package-actions--active{max-height:200px}.package-actions__inner{display:flex;flex-wrap:wrap;justify-content:flex-end;align-items:center;margin:0;padding:12px;text-align:right}@media(min-width:1024px){.package-actions__inner{max-width:976px;margin:0 auto;padding-left:0;padding-right:0}}@media(min-width:1200px){.package-actions__inner{max-width:1196px}}.package-actions__text{flex-grow:1;display:initial;margin:0 8px;font-weight:600}.package-actions__button{display:block;padding:0 15px!important;margin:8px}.package-actions__button--dryRun{width:auto!important;flex-grow:1}@media(min-width:600px){.package-actions__button{width:auto!important}.package-actions__button--dryRun{flex-grow:0}}.package-actions__button-group{display:block;width:100%;margin:8px}.package-actions__button-group>.button-group__primary{padding:0 15px!important}@media(min-width:600px){.package-actions__button-group{width:auto!important}}.package{position:relative;margin-bottom:20px;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.package.is--hint{border-color:var(--btn-alert)}.package--contao:not(:last-child){margin-bottom:5em}.package__hint{position:relative;background:var(--hint-bg);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.8;border-radius:14px 14px 0 0;z-index:1}.package__hint p a{display:inline-block;padding-right:10px}.package__hint p a:first-child{margin-left:10px}.package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.package__hint-close{float:right;padding-left:18px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px}.package__inside{position:relative;padding:16px}.package__inside:after{display:table;clear:both;content:""}.package__badge{display:inline-block;margin-bottom:.5em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);border-radius:var(--border-radius);cursor:help}.package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%}.package__icon img,.package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;object-fit:contain}.package__details{min-height:96px}.package__about{margin-bottom:20px}.package__headline{position:relative;margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__title{display:block;margin-right:10px}.package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__additional{margin-top:-5px}.package .package__release{text-align:right;margin-bottom:5px}.package__version--additional{margin-bottom:5px}.package__version--additional strong{margin-right:10px}.package__version--release{display:none}.package__version--release time{display:block}.package__version--missing{padding:4px 8px;background:var(--btn-alert);border-radius:var(--border-radius);color:#fff;font-weight:700}.package__version-update{display:inline-block;margin:0 0 2px;padding:1px 8px;color:#fff;border-radius:var(--border-radius)}.package__version-update--available{background:var(--btn-primary)}.package__version-update--error{background:var(--btn-alert)}.package__version-update--none{background:var(--border)}.package__version-latest{float:right;position:relative;right:-7px;width:24px;height:20px;background:var(--btn-primary) url(../img/button-update.ad79c617.svg) center center/20px 20px no-repeat}.package__actions{display:flex;flex-flow:column;gap:5px}.package__actions .button-group button{margin-bottom:0!important}@media(min-width:600px){.package__description,.package__title{margin-right:0}.package__hint{padding-left:52px;background:rgba(var(--hint-rgb),.9) url(../img/hint.ba2ac97e.svg) 12px 5px no-repeat;background-size:28px 28px}.package__inside{display:flex;align-items:stretch;padding:0}.package__headline--badge{display:flex;gap:6px;align-items:flex-start}.package__headline{margin:0 0 8px}.package__badge{order:1;margin:0 0 0 2px}.package__icon{width:130px;height:auto;min-height:130px;margin:0;border-radius:12px 0 0 12px;position:revert;right:revert}.package__icon img,.package__icon svg{width:110px;height:110px}.is--hint .package__icon{border-top-left-radius:0}.package--contao{overflow:hidden}.package--contao .package__icon{border-radius:0}.package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.package.is--hint .package__icon{border-top-left-radius:0}}@media(min-width:680px){.package .package__release{display:block;float:left;width:33%}.package__actions{float:right;width:64%;flex-flow:row;gap:4%;text-align:right}.package__actions>*{flex:1}}@media(min-width:1024px){.package__version--additional{display:none}.package__version--release{display:block;margin-top:15px;text-align:center}.package__version-update{display:block;margin:2px 0 0}.package__about{float:left;width:396px;margin-bottom:0}.package .package__release{width:180px;margin-left:20px;margin-bottom:0}.package__actions{flex-flow:column;gap:10px;width:180px;margin-left:20px}.package__details{display:flex;align-self:center;align-items:flex-start}}@media(min-width:1200px){.package__about{width:616px}}.progress-bar{position:relative;width:100%;height:30px;background:var(--clr-btn);border:2px solid var(--btn-warning);color:#000;font-weight:600;text-align:center;line-height:26px}.progress-bar__bar{position:absolute;overflow:hidden;left:0;right:0;top:0;bottom:0;background:var(--btn-warning)}.progress-bar__bar span{display:block;color:var(--clr-btn);text-align:center}.feature-package{display:flex;flex-wrap:wrap;padding:6px 16px;border-top:1px solid var(--border--light)}.feature-package__name{font-weight:600;white-space:nowrap}.feature-package__name:after{content:": "}.feature-package__text{flex-grow:1;display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;margin-right:.5em;padding:4px 0;line-height:20px}.feature-package__text--hint{display:inline;-webkit-line-clamp:none;line-clamp:none}.feature-package__badge{margin-left:5px;padding:2px 8px;background:var(--btn-alert);border-radius:var(--border-radius);font-size:12px;font-weight:600;line-height:19px;color:#fff;cursor:help}.feature-package__hint{line-height:1.2;padding:2px 5px;background:var(--hint-bg);font-size:12px}.feature-package__actions{flex-grow:1;display:flex;justify-content:flex-end;margin:0 -4px 0 0}.feature-package__actions>*{margin:0 4px}.feature-package__restore{padding-left:18px;font-size:12px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px;border:none;cursor:pointer}.feature-package__restore:hover{text-decoration:underline}@media(min-width:800px){.feature-package{flex-wrap:nowrap}}@media(min-width:1024px){.feature-package__hint{padding:8px 10px 8px 36px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 5px no-repeat;background-size:20px 20px}.feature-package__actions{margin:0 -4px 0 0}}.package-constraint input[type=text][data-v-7461cf36]{margin-right:2px;background:#fff;border:2px solid var(--btn-warning);color:var(--black);font-weight:600;text-align:center;border-top-right-radius:0;border-bottom-right-radius:0}.package-constraint input[type=text][data-v-7461cf36]::placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-7461cf36]:disabled{color:var(--clr-btn);opacity:1;background:var(--btn-warning);-webkit-text-fill-color:var(--clr-btn)}.package-constraint input[type=text].disabled[data-v-7461cf36]{background:var(--border);border-color:var(--border)}.package-constraint input[type=text].error[data-v-7461cf36]{animation:input-error .15s linear 3}.package-constraint>input[type=text][data-v-7461cf36],.package-constraint>input[type=text][data-v-7461cf36]:disabled{float:left;width:calc(100% - 32px)}.package-constraint button[data-v-7461cf36]{position:relative;width:30px;background:var(--btn-warning);line-height:20px;text-indent:-999em;border-top-left-radius:0;border-bottom-left-radius:0}.package-constraint button[data-v-7461cf36]:hover{background:var(--btn-warning-active);border-color:var(--btn-warning-active)}.package-constraint button[data-v-7461cf36]:before{position:absolute;left:50%;top:50%;margin:-10px 0 0 -10px}.package-constraint button.rotate[data-v-7461cf36]:before{animation:release-validating-7461cf36 2s linear infinite}@keyframes release-validating-7461cf36{to{transform:rotate(1turn)}}@media(min-width:1024px){.package-constraint button[data-v-7461cf36],.package-constraint input[type=text][data-v-7461cf36]{height:30px}}.button-group{display:flex;gap:1px;position:relative}.button-group__primary.widget-button{flex-grow:1;border-top-right-radius:0;border-bottom-right-radius:0}.button-group__more.widget-button{flex-shrink:0;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-group__more.widget-button svg{width:24px;height:24px}.button-group__group{position:absolute;top:39px;width:100%;padding-top:3px;z-index:100}.button-group__group:focus{outline:none}.button-group__group .widget-button{margin-top:1px}.button-group__group .link-menu{margin-top:3px}.button-group__group--top{top:auto;bottom:39px}.button-group__group--top .link-menu{margin-top:0;margin-bottom:3px}.composer-package__stats{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.composer-package__stats--license{padding-left:0}.composer-package__stats--versions{display:inline-flex;flex-wrap:wrap;gap:5px;list-style:none;margin:0 15px 0 0;padding:0}.composer-package__stats--version{padding:3px 5px;line-height:1;border:1px solid var(--border);border-radius:4px}.composer-package__stats--funding{width:16px;background-image:url(../img/funding.cf78a0a0.svg);background-size:16px 16px;background-repeat:no-repeat;text-decoration:none!important}.package-uploads__overlay{top:0;bottom:0;right:0;left:0;position:fixed;z-index:9999;opacity:.6;text-align:center;background:#000}.package-uploads__overlay div{margin:-.5em 0 0;position:absolute;top:50%;left:0;right:0;transform:translateY(-50%);font-size:40px;color:#fff;padding:0}.cloud-status{margin-left:8px;position:relative}.cloud-status__button{margin-left:0;margin-right:0;padding-left:8px;cursor:help!important}.cloud-status__popup{position:absolute;text-align:center;left:0;bottom:54px;margin:0;padding:0 0 15px;outline:none;background:var(--form-bg);color:var(--text);border-bottom:3px solid var(--contao);border-radius:5px;box-shadow:0 0 2px var(--shadow);z-index:100}.cloud-status__popup:after{position:absolute;left:38px;bottom:-6px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:4px 3.5px 0 3.5px;border-color:var(--contao) transparent transparent transparent;content:""}.cloud-status__popup--error{color:var(--clr-btn);background-color:var(--btn-alert);border-color:var(--btn-alert)}.cloud-status__popup--error:after{left:27px;border-color:var(--btn-alert) transparent transparent transparent}.cloud-status__headline{padding:15px 20px 0;font-size:16px;white-space:pre}.cloud-status__version{margin:0 0 8px;font-size:12px}.cloud-status__link{display:inline-block;margin:15px 10px 0}.cloud-status__error{padding:8px 20px 8px;hyphens:auto}.cloud-status table{width:100%;margin-top:12px;text-align:left;border-spacing:0;border-collapse:collapse}.cloud-status th{padding:3px 5px 3px 20px}.cloud-status td{padding:3px 20px 3px 0}.cloud-status tr:nth-child(odd){background:var(--table-odd-bg)}.package-list{position:relative}.package-list__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-list__status .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-list__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.animate-blur-in,.animate-blur-out,.layout-boxed{display:table;width:100%;height:100%}.layout-boxed__cell{display:table-cell;overflow:hidden;vertical-align:middle;padding:10px}.layout-boxed__container{position:relative;max-width:380px;margin:0 auto;background:var(--popup-bg);border-radius:8px}@media(min-width:960px){.layout-boxed__container{margin-top:20px;margin-bottom:20px}.layout-boxed__container--wide{max-width:940px}}.widget-checkbox input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-checkbox label{position:relative;display:block;padding-left:25px;text-align:left}.widget-checkbox label:before{content:"";position:absolute;left:0;width:20px;height:20px;background:url(../img/widget-checkbox--off.73856538.svg) 0 0 no-repeat;background-size:20px 20px}.widget-checkbox input:checked+label:before{background-image:url(../img/widget-checkbox--on.8b830157.svg)}.widget-checkbox input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-checkbox input:disabled+label{opacity:.5}.widget-checkbox .widget__description{padding-left:25px}.widget-checkbox .widget__description--disabled{opacity:.5}.user-scope__label{margin:0;padding:0}.user-scope__item{padding:5px 0 0}.user-scope__item--required label{opacity:1!important}.user-scope__item--required label:before{opacity:.5}.view-oauth__header{max-width:280px;margin:0 auto 40px;padding-top:40px;text-align:center}.view-oauth__icon{background:var(--contao);border-radius:10px;padding:10px}.view-oauth__product{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-oauth__form{position:relative;max-width:280px;margin:0 auto 60px;text-align:center}.view-oauth__form input,.view-oauth__form select{margin:5px 0 10px}.view-oauth__description{margin-top:.5em;margin-bottom:.5em}.view-oauth__client{margin:1em 0;font-size:32px}.view-oauth__scopes{text-align:left}.view-oauth__warning{color:var(--btn-alert);margin-top:2em;margin-bottom:2em}.view-oauth__button{margin-top:1em}.view-oauth__button .sk-circle{color:#fff;text-align:center}.message-overlay{position:relative}.message-overlay__blur{opacity:.75;filter:blur(2px);transition:opacity .5s,filter .5s}.message-overlay__overlay{position:absolute;display:flex;justify-content:center;align-items:center;left:0;right:0;top:0;bottom:0}.message-overlay__message{padding:10px;font-size:2em;font-weight:400;text-align:center}.maintenance{margin-bottom:14px;background:var(--tiles-bg);border-radius:var(--border-radius)}.maintenance__inside{padding:10px 20px 20px}@media(min-width:1024px){.maintenance__inside{display:grid;grid-template:auto/90px auto 300px;column-gap:20px;padding:25px 20px}}.maintenance__image{aspect-ratio:1;display:none}.maintenance__image img{width:100%;height:100%;border-radius:var(--border-radius);overflow:hidden}@media(min-width:1024px){.maintenance__image{display:block}}.maintenance__about{margin-bottom:20px}@media(min-width:1024px){.maintenance__about{margin-bottom:0}}.maintenance__about h1{position:relative;margin-bottom:5px;display:flex;flex-wrap:wrap;column-gap:.5em;align-items:baseline}.maintenance__about p{margin:0 0 1em;display:inline}.maintenance__error,.maintenance__warning{position:relative;top:-2px;padding:4px 8px;font-size:14px;line-height:1em;font-weight:300;background:var(--btn-warning);color:var(--clr-btn);border-radius:var(--border-radius)}.maintenance__error{background:var(--btn-alert)}.maintenance__actions{display:flex;flex-direction:column;row-gap:10px;column-gap:20px}@media(min-width:600px){.maintenance__actions{flex-direction:row-reverse}}@media(min-width:1024px){.maintenance__actions{flex-direction:column;margin-left:20px}}.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}@media(min-width:600px){.maintenance__actions>.button-group,.maintenance__actions>button{width:calc(50% - 10px)}}@media(min-width:1024px){.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}}.maintenance__loader{width:50px;margin:0 auto}.maintenance__loader .sk-circle{width:50px;height:50px}.log-viewer__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.log-viewer__status--empty{padding-top:140px;background:url(../img/warning.9a7cd776.svg) top no-repeat;background-size:100px 100px}.log-viewer__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.log-viewer__status button{margin-top:2em}.log-viewer__loading{width:30px;margin:40px auto}.log-viewer__loading .sk-circle{width:30px;height:30px}.log-viewer__filters{display:flex;justify-content:space-between;flex-wrap:wrap;gap:20px}.log-viewer__filters>div{display:flex;align-items:flex-end;gap:20px}.log-viewer__filters a{flex-shrink:0}.log-viewer__file{flex-shrink:1;display:flex;align-items:flex-end}.log-viewer__file select{border-right:none;border-top-right-radius:0;border-bottom-right-radius:0}.log-viewer__file button{border-top-left-radius:0;border-bottom-left-radius:0}.log-viewer__list{margin-top:2em;padding-bottom:1px;background:var(--form-bg);border-radius:var(--border-radius)}@media(min-width:600px){.log-viewer__list{overflow-y:scroll;max-height:calc(100vh - 300px)}}.log-viewer__line{position:relative;padding:10px 0;border-bottom:1px solid var(--border--light)}@media(min-width:600px){.log-viewer__line{display:flex}}.log-viewer__line:hover{background:var(--focus)}.log-viewer__line:last-child{border-bottom:none}.log-viewer__line--header{display:none}@media(min-width:600px){.log-viewer__line--header{display:flex;position:sticky;top:0;z-index:1;font-weight:600;background:var(--log-header-bg)!important;color:#fff;border-top-left-radius:2px;border-top-right-radius:2px;border-bottom-color:var(--border)}}.log-viewer__line--alert:before,.log-viewer__line--critical:before,.log-viewer__line--emergency:before,.log-viewer__line--error:before,.log-viewer__line--warning:before{content:"";position:absolute;left:0;top:-1px;bottom:-1px;width:4px;background:var(--btn-alert)}.log-viewer__line--warning:before{background:var(--btn-warning)}.log-viewer__line--raw{padding:5px 10px;background:#24292e;border-bottom:none;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;font-size:.8em;line-height:1.5;white-space:pre-wrap}.log-viewer__line--raw:hover{background:#2f363d}.log-viewer__more{display:flex;justify-content:center;padding:20px}.log-viewer__content,.log-viewer__meta{padding:10px 20px}.log-viewer__content--header,.log-viewer__meta--header{padding:0 20px!important}.log-viewer__meta{padding-bottom:0;flex-shrink:0;font-style:italic}.log-viewer__meta--header{font-style:normal}@media(min-width:600px){.log-viewer__meta{width:220px;padding-bottom:10px}}.log-viewer__content{flex-grow:1}.log-viewer__datetime{display:block}@media(min-width:600px){.log-viewer__datetime{margin-bottom:1em}}.log-viewer__badge{display:inline-block;margin-right:10px;padding:1px 4px;background:var(--border);border-radius:var(--border-radius);font-size:.9em;font-weight:400;text-transform:lowercase}.log-viewer__badge--desktop{display:none}@media(min-width:600px){.log-viewer__badge--desktop{display:inline-block}.log-viewer__badge--mobile{display:none}}.log-viewer__badge--channel{padding-top:0;padding-bottom:0;border:1px solid var(--border);background:var(--white)}.log-viewer__badge--level-warning{background:var(--btn-warning);color:#fff}.log-viewer__badge--level-alert,.log-viewer__badge--level-critical,.log-viewer__badge--level-emergency,.log-viewer__badge--level-error{background:var(--btn-alert);color:#fff}.log-viewer__message span:nth-child(2n){font-weight:600;color:var(--black)}.log-viewer__details{display:flex;align-items:center;margin-top:1em}.log-viewer__toggle{margin-right:10px;padding:0;border:none;background:none;color:var(--link);text-decoration:none;cursor:pointer}.log-viewer__toggle:hover{text-decoration:underline}.log-viewer__json{margin:10px 0 0}.invite-user__check{text-align:center}.invite-user__check svg{width:60px;height:60px;fill:var(--btn-primary)}.invite-user__check,.invite-user__text{margin-bottom:1em}.invite-user__url{display:block;margin-top:2em}.invite-user__help{display:block;margin-top:1em;font-size:12px}.invite-user__clipboard{margin:1em 0}.widget-text input::-webkit-inner-spin-button,.widget-text input::-webkit-outer-spin-button{display:none}.widget-text input[type=number]{appearance:textfield!important}.widget-text--password input{padding-right:40px!important}.widget__password-toggle{position:absolute;right:8px;bottom:2px;padding:0;margin:0;background:none;border:none;cursor:pointer}.widget__password-toggle--hidden svg{fill:var(--btn-primary)}.widget__password-toggle--visible svg{fill:var(--btn)}.setup-totp__qr{margin:2em;text-align:center}.setup-totp__qr svg{width:200px;height:200px}.setup-totp__uri{display:block;margin:1em 0;word-break:break-all}.setup-totp .sk-circle{margin:20px auto}.disable-totp__text{margin-bottom:1em}.change-password .widget{margin:1em 0 0}.user-manager__loading{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.user-manager__loading .sk-circle{width:100px;height:100px;margin:0 auto 40px}.user-manager__list{display:grid;grid-template:1fr/1fr;gap:20px}@media(min-width:600px){.user-manager__list{grid-template:1fr/repeat(2,1fr)}}@media(min-width:800px){.user-manager__list{grid-template:1fr/repeat(3,1fr)}}@media(min-width:1200px){.user-manager__list{grid-template:1fr/repeat(4,1fr)}}.user-manager__item{position:relative;overflow:hidden;display:flex;flex-direction:column;padding:16px;background:var(--tiles-bg);border:1px solid 1px solid var(--tiles-bdr);border-radius:14px}.user-manager__ribbon{position:absolute;top:18px;right:-22px;width:100px;font-size:12px;color:#fff;font-weight:600;line-height:1.5;text-align:center;background:var(--btn-info);transform-origin:center center;transform:rotate(45deg)}.user-manager__ribbon--hint{cursor:help}.user-manager__ribbon--primary{background:var(--btn-primary)}.user-manager__ribbon--warning{background:var(--btn-warning)}.user-manager__ribbon--alert{background:var(--btn-alert)}.user-manager__new{margin-top:60px;text-align:center}.user-manager__spacer{flex-grow:1;min-height:1em}.user-manager__username{font-size:18px;font-weight:600}.user-manager__scope{margin-top:1em}.user-manager .widget-button{margin-top:5px}.view-error{position:fixed;left:0;right:0;top:0;bottom:0;padding:10px;color:#e8e8e8;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-size:13px;line-height:1.2;background-color:rgba(0,0,0,.851);background-position:0 0;background-repeat:repeat;z-index:9998}.view-error,.view-error__close{display:flex;justify-content:center;align-items:center}.view-error__close{position:absolute;top:15px;right:10px;width:35px;height:35px;background:none;border:none;cursor:pointer;z-index:10}.view-error__close:hover{border:1px solid #fff}.view-error__content{display:flex;flex-direction:column;align-items:center;max-width:800px;max-height:100vh;line-height:1.5;text-align:center}.view-error__icon{display:block;height:100px;margin:2em 0;fill:#fff}.view-error__status{margin-bottom:1em;padding:2px 4px;background-color:#e36049;border-radius:var(--border-radius)}.view-error__headline{margin:0;font-size:1em;line-height:1.5}.view-error__status a{color:#e8e8e8;text-decoration:underline}.view-error__details{display:block;margin-top:2em;white-space:pre-line}.view-error__debug{align-self:flex-start;max-height:60vh;overflow-y:auto;margin-top:2em;text-align:left;white-space:pre-line}.view-error__actions{margin:4em 0;text-align:center}.view-error__link{margin:10px;padding:10px 20px;border:1px solid #fff;border-radius:4px;color:#fff}.button-menu{position:relative}.button-menu__primary.widget-button{float:left;width:calc(100% - 39px);border-top-right-radius:0;border-bottom-right-radius:0}.button-menu__more.widget-button{float:right;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-menu__more.widget-button svg{width:24px;height:24px}.button-menu__menu{display:flex;flex-direction:column;position:absolute;top:38px;right:0;width:auto;z-index:100;background:var(--form-bg);border-radius:var(--border-radius)}.button-menu__menu:before{content:"";position:absolute;top:-5px;right:15px;width:0;height:0;border-right:none;border-bottom:none;border-left:5px solid transparent;border-right:5px solid transparent;border-bottom:5px solid var(--form-bg)}.button-menu__menu:focus{outline:none}.button-menu__menu button{padding:8px 16px;background:none;border:none;text-align:left;white-space:nowrap;border-bottom:1px solid var(--border);cursor:pointer}.button-menu__menu button:hover{color:var(--text);background:var(--focus)}.button-menu__menu button:first-child{border-top-left-radius:2px;border-top-right-radius:2px}.button-menu__menu button:last-child{border-bottom:none;border-bottom-left-radius:2px;border-bottom-right-radius:2px}.button-menu__menu .link-menu{margin-top:3px}.console-operation{position:relative;padding:0 16px;text-align:left;font-size:12px;color:#959da5}.console-operation__summary{margin-left:13px;padding:8px;box-sizing:border-box}.console-operation__summary--console{margin-left:0}.console-operation summary{cursor:pointer}.console-operation__status{display:inline-block;position:relative;box-sizing:border-box;padding-right:8px;width:24px;height:18px;text-align:center;vertical-align:middle}.console-operation__icon{position:absolute;left:0;top:0}.console-operation__icon--skipped{fill:#666b71}.console-operation__icon--pending{fill:#dbab0a}.console-operation__icon--active{fill:#dbab0a;animation:console-active 1s linear infinite}@keyframes console-active{0%{transform:rotate(0deg)}50%{transform:rotate(180deg)}to{transform:rotate(359deg)}}.console-operation__icon--success{fill:var(--btn-primary)}.console-operation__icon--error{fill:var(--btn-alert)}.console-operation__label{display:inline-block;overflow:hidden;max-width:750px;vertical-align:top}.console-operation__title{display:inline;margin:0;color:#fff}.console-operation__title--disabled{text-decoration:line-through}.console-operation__description{display:inline;margin:0 0 0 10px}.console-operation__console{position:relative;overflow-y:auto;max-height:280px}.console-operation__lines{padding:8px 0 16px;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;line-height:1.5;white-space:pre-wrap;word-break:break-word;overflow-wrap:break-word}.console-operation__line{display:flex}.console-operation__line:hover{background-color:#2f363d}.console-operation__line-number{display:inline-block;overflow:hidden;width:48px;min-width:48px;color:#959da5;text-align:right;text-overflow:ellipsis;white-space:nowrap;vertical-align:middle;user-select:none}.console-operation__line-content{display:inline-block;margin-left:16px;vertical-align:middle}.console-operation__scroll{position:sticky;left:0;right:0;display:flex;justify-content:center;align-items:flex-end;width:100%;height:30px;padding:0;border:none;cursor:pointer}.console-operation__scroll svg{fill:#fff;width:16px;height:16px}.console-operation__scroll--top{top:0;background:linear-gradient(#24292e,rgba(36,41,46,.502) 50%)}.console-operation__scroll--top svg{transform:rotate(180deg)}.console-operation__scroll--bottom{bottom:0;background:linear-gradient(rgba(36,41,46,.502),#24292e 50%)}.console-operation__scroll--bottom svg{transform:rotate(0deg)}.console{background:#24292e;border-radius:8px}.console__header{display:flex;flex-wrap:nowrap;justify-content:space-between;align-items:center;padding:12px 12px 12px 24px;border-bottom:1px solid #444d56}.console__headline{margin:0;font-size:inherit;line-height:1.5;color:#fff}.console__description{color:#959da5;font-size:12px}.console__actions{display:flex;flex-wrap:nowrap;align-items:center}.console__action,.console__action>button{height:30px!important;line-height:30px!important;width:auto!important;min-width:0;margin:0 2px;padding:0 5px!important;border:none!important}.console__action:hover,.console__action>button:hover{background-color:#2f363d!important}.console__action--active,.console__action>button--active{background-color:#586069!important}.console__operations{padding:20px 0}.view-task__header{margin-left:auto;margin-right:auto;padding:40px 20px;text-align:center}.view-task__icon{background:var(--contao);border-radius:10px;padding:10px}.view-task__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-task__description{margin:0;font-weight:600}.view-task__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em}@media(min-width:960px){.view-task__actions{flex-direction:row}}.view-task .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.view-task .widget-button{width:auto}}.view-task__main{margin:0 50px 50px}.view-task__loading{width:30px;margin:40px auto}.view-task__loading .sk-circle{width:30px;height:30px}.view-task__sponsor{margin:-30px 50px 50px;text-align:center}@media(min-width:960px){.view-task__sponsor br{display:none}}.view-task__donate{position:relative;top:5px;margin-left:.5em;line-height:0}:root{--text:#535353;--link:#f47c00;--placeholder:#a9a9a9;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.eb57b3fa.svg);--svg--private:url(../img/private.a1c65662.svg);--svg--updated:url(../img/updated.3b47bebb.svg);--svg--downloads:url(../img/downloads.c1db2a9e.svg);--svg--favers:url(../img/favers.056e2836.svg);--svg--language:url(../img/language.582b2920.svg);--svg--color-scheme:url(../img/color_scheme.d527d153.svg)}html[data-color-scheme=dark]{color-scheme:dark;--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.07eeaee6.svg);--svg--private:url(../img/private--dark.41b90022.svg);--svg--updated:url(../img/updated--dark.c21fdd5b.svg);--svg--downloads:url(../img/downloads--dark.034bf7a3.svg);--svg--favers:url(../img/favers--dark.4765f7d4.svg);--svg--language:url(../img/language--dark.a24e849e.svg);--svg--color-scheme:url(../img/color_scheme--dark.ef0f0aed.svg)}html[data-color-scheme=dark] #contao-network{background:#292c32!important;color:#ddd!important}html{box-sizing:border-box}*,:after,:before{box-sizing:inherit}#app,body,html{height:100%}blockquote,body,figure,form,p{margin:0;padding:0}article,aside,figcaption,figure,footer,header,main,nav,section{display:block}body,div,fieldset,form,h1,h2,h3,h4,h5,h6,html,p{text-size-adjust:none}body{background:var(--body-bg);overflow-y:hidden}#app{overflow-y:scroll}fieldset{border:none;margin:0;padding:0}legend{-webkit-padding-start:0;-webkit-padding-end:0}figure{line-height:0}body,button,input,textarea{font:300 14px/1.4 -apple-system,system-ui,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;color:var(--text)}strong{font-weight:600}code{font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace}input,select,textarea{font-size:99%}input:disabled,select:disabled,textarea:disabled{color:var(--text);-webkit-text-fill-color:var(--text);cursor:text}input::-ms-clear,input::-ms-reveal,select::-ms-clear,select::-ms-reveal,textarea::-ms-clear,textarea::-ms-reveal{display:none}input::placeholder,select::placeholder,textarea::placeholder{color:var(--placeholder);-webkit-text-fill-color:var(--placeholder)}.invisible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.clearfix{*zoom:1}.clearfix:after,.clearfix:before{display:table;content:"";line-height:0}.clearfix:after{clear:both}h1,h2,h3,h4,h5,h6{font-size:inherit;line-height:inherit;font-weight:600;margin:0}a{color:var(--link);text-decoration:none}a:hover{text-decoration:underline}h1{font-size:18px;line-height:30px;margin-bottom:10px}@keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}.widget{position:relative}.widget__error{display:none;position:absolute;left:0;right:0;margin:0;padding:4px 10px;color:var(--clr-btn);background:var(--btn-alert);border-radius:2px;transform:translateY(6px);z-index:10;white-space:pre-line}.widget__error:after,.widget__error:before{bottom:100%;left:30px;border:solid transparent;content:" ";height:0;width:0;position:absolute;pointer-events:none}.widget__error:after{border-bottom-color:var(--btn-alert);border-width:3px;margin-left:-3px}.widget__error:before{border-bottom-color:var(--btn-alert);border-width:5px;margin-left:-5px}input:focus+*+.widget__error,input:focus+.widget__error,input:hover+*+.widget__error,input:hover+.widget__error,select:hover+.widget__error{display:block}.widget__description{margin-top:2px;font-size:12px}input:not([type=checkbox]):not([type=radio]),select{position:relative;width:100%;height:38px;padding:0 20px;background:var(--form-bg);border:1px solid var(--border);border-radius:6px;color:var(--text);appearance:none}input:not([type=checkbox]):not([type=radio]):focus,select:focus{outline:none;background-color:var(--focus)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):valid,.widget--validate select:not(:placeholder-shown):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):invalid,.widget--validate select:not(:placeholder-shown):invalid{border-color:var(--btn-alert)}.widget--error input:not([type=checkbox]):not([type=radio]),.widget--error select{border-color:var(--btn-alert);animation:input-error .15s linear 3}select{padding-right:30px}.widget-select:after{position:absolute;right:12px;bottom:16px;width:0;height:0;border-left:6px solid transparent;border-right:6px solid transparent;border-top:6px solid var(--border);content:"";pointer-events:none}.widget-button{display:inline-block;width:100%;height:38px;padding:0;border:none;background-color:var(--btn);color:var(--clr-btn);font-weight:600;line-height:38px;text-decoration:none;text-align:center;white-space:nowrap;cursor:pointer;border-radius:5px}.widget-button:active,.widget-button:hover{background-color:var(--btn-active)}.widget-button--inline{width:auto!important;min-width:100px;padding:0 20px}.widget-button--transparent{background:transparent}.widget-button--small{height:28px;width:auto!important;min-width:0;padding:0 15px;font-size:13px;line-height:28px;font-weight:300}.widget-button--small:before,.widget-button--small>:before{top:3px!important;width:15px!important;height:15px!important;margin-right:6px!important;background-size:15px 15px!important}.widget-button--primary{--btn:var(--btn-primary);--btn-active:var(--btn-primary-active)}.widget-button--warning{--btn:var(--btn-warning);--btn-active:var(--btn-warning-active)}.widget-button--alert{--btn:var(--btn-alert);--btn-active:var(--btn-alert-active)}.widget-button--info{--btn:var(--btn-info);--btn-active:var(--btn-info-active)}.widget-button--funding{--btn:var(--btn-funding);--btn-active:var(--btn-funding-active)}.widget-button:empty{min-width:auto;padding:0 10px}.widget-button:empty:before{margin-right:0!important}.widget-button:hover{text-decoration:none}.widget-button.disabled,.widget-button:disabled{background-color:var(--btn-disabled)!important;border-color:var(--btn-disabled)!important;cursor:not-allowed;opacity:var(--opacity-disabled,1)}.widget-button.disabled{pointer-events:none}.widget-button--anchor{height:auto;background:none!important;line-height:inherit;font-weight:inherit;color:var(--link);text-decoration:none;cursor:pointer}.widget-button--anchor:hover{text-decoration:underline!important}.widget-button--anchor.disabled,.widget-button--anchor:disabled{background:none!important}label{padding:0}.widget--required label:after{margin-left:2px;content:"*";color:var(--btn-alert)}input:-webkit-autofill,select:-webkit-autofill{-webkit-text-fill-color:var(--text);-webkit-box-shadow:inset 0 0 0 1000px hsla(0,0%,100%,0);transition:background-color 5000s ease-in-out 0s}.widget-button--details:before{background-image:url(../img/button-details.8ce780e9.svg)}.widget-button--link:before{background-image:url(../img/button-link.dd42e161.svg)}.widget-button--search:before{background-image:url(../img/button-search.44ce1d4b.svg)}.widget-button--add:before,.widget-button--check:before,.widget-button--clipboard:before,.widget-button--cloud-off:before,.widget-button--cloud:before,.widget-button--console:before,.widget-button--database:before,.widget-button--details:before,.widget-button--download:before,.widget-button--edit:before,.widget-button--gear:before,.widget-button--hide:before,.widget-button--link:before,.widget-button--lock:before,.widget-button--maintenance:before,.widget-button--more:before,.widget-button--passkey:before,.widget-button--power:before,.widget-button--run:before,.widget-button--save:before,.widget-button--search:before,.widget-button--show:before,.widget-button--trash:before,.widget-button--unlock:before,.widget-button--update:before,.widget-button--upload:before{position:relative;display:inline-block;top:5px;width:20px;height:20px;margin-right:8px;background-position:50%;background-repeat:no-repeat;background-size:18px 18px;content:""}.widget-button--add:empty:before,.widget-button--check:empty:before,.widget-button--clipboard:empty:before,.widget-button--cloud-off:empty:before,.widget-button--cloud:empty:before,.widget-button--console:empty:before,.widget-button--database:empty:before,.widget-button--details:empty:before,.widget-button--download:empty:before,.widget-button--edit:empty:before,.widget-button--gear:empty:before,.widget-button--hide:empty:before,.widget-button--link:empty:before,.widget-button--lock:empty:before,.widget-button--maintenance:empty:before,.widget-button--more:empty:before,.widget-button--passkey:empty:before,.widget-button--power:empty:before,.widget-button--run:empty:before,.widget-button--save:empty:before,.widget-button--search:empty:before,.widget-button--show:empty:before,.widget-button--trash:empty:before,.widget-button--unlock:empty:before,.widget-button--update:empty:before,.widget-button--upload:empty:before{margin-right:0!important}.animate-initializing{animation:initializing 1s linear infinite}@keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}.animate-blur-in{z-index:-1;opacity:.5;filter:blur(4px);transition:opacity .35s,filter .5s}.animate-blur-out{opacity:1;transition:opacity .35s}.animate-fade-enter-active,.animate-fade-leave-active{transition-duration:.2s;transition-property:opacity;transition-timing-function:ease}.animate-fade-enter,.animate-fade-leave-active{opacity:0}.animate-flip-enter-active,.animate-flip-leave-active{transform-style:preserve-3d;backface-visibility:hidden;transition-duration:.5s;transition-property:transform,opacity}.animate-flip-leave-active{transform:perspective(600px) rotateY(0deg);opacity:1}.animate-flip-leave-to{transform:perspective(600px) rotateY(90deg);transition-timing-function:ease-in;opacity:0}.animate-flip-enter-active{transform:perspective(400px) rotateY(270deg);opacity:0}.animate-flip-enter-to{transform:perspective(400px) rotateY(1turn);transition-timing-function:ease-out;opacity:1}:root{--header-main-bg:#fff;--footer-fragment-bdr:#eee;--table-odd-bg:#f5f9fa;--border-radius:6px;--log-header-bg:var(--shadow)}html[data-color-scheme=dark]{--header-main-bg:#292c32;--footer-fragment-bdr:var(--footer-bdr);--table-odd-bg:var(--tiles-bg);--link-footer:#fff;--hint-bg:#151619;--hint-rgb:21,22,25;--log-header-bg:var(--btn)}html[data-color-scheme=dark] .vjs-tree-node:hover{background-color:#2b3439}.color-scheme--light,html[data-color-scheme=dark] .color-scheme--dark{display:initial}.color-scheme--dark,html[data-color-scheme=dark] .color-scheme--light{display:none}.app-hint{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:var(--btn-info);color:#fff;text-align:center;z-index:100}.app-hint--warning{background:var(--btn-warning)}.app-hint--alert{background:var(--btn-alert)}.app-hint__description{display:none}@media(min-width:600px){.app-hint__description{display:inline}}.app-hint__link{margin:0;padding:0;background:none;border:none;color:#fff;text-decoration:underline;cursor:pointer}.app-hint+div{padding-top:25px}.view-init{display:table;width:100%;height:100%}.view-init__cell{display:table-cell;font-size:1.5em;text-align:center;vertical-align:middle}.widget-button--add:before{background-image:url(../img/button-add.759df12e.svg)}.widget-button--check:before{background-image:url(../img/button-check.7a3b5ada.svg)}.widget-button--clipboard:before{background-image:url(../img/button-clipboard.9ef63d39.svg)}.widget-button--cloud:before{background-image:url(../img/button-cloud.bc42f267.svg)}.widget-button--cloud-off:before{background-image:url(../img/button-cloud-off.dd8ba18e.svg)}.widget-button--console:before{background-image:url(../img/button-console.05dcdfc4.svg)}.widget-button--database:before{background-image:url(../img/button-database.5282fc7e.svg)}.widget-button--download:before{background-image:url(../img/button-download.e1ba6f25.svg)}.widget-button--edit:before{background-image:url(../img/button-edit.40a4be06.svg)}.widget-button--gear:before{background-image:url(../img/button-gear.a2dc1f09.svg)}.widget-button--hide:before{background-image:url(../img/button-hide.d23f6533.svg)}.widget-button--lock:before{background-image:url(../img/button-lock.98988f08.svg)}.widget-button--maintenance:before{background-image:url(../img/button-maintenance.93830369.svg)}.widget-button--more:before{background-image:url(../img/button-more.e3eb2622.svg)}.widget-button--passkey:before{background-image:url(../img/button-passkey.3806f98a.svg)}.widget-button--power:before{background-image:url(../img/button-power.298a8072.svg)}.widget-button--run:before{background-image:url(../img/button-run.b6310c5a.svg)}.widget-button--save:before{background-image:url(../img/button-save.3b5224de.svg)}.widget-button--show:before{background-image:url(../img/button-show.2336e1d9.svg)}.widget-button--trash:before{background-image:url(../img/button-trash.855f57fa.svg)}.widget-button--unlock:before{background-image:url(../img/button-unlock.51b76e07.svg)}.widget-button--update:before{background-image:url(../img/button-update.ad79c617.svg)}.widget-button--upload:before{background-image:url(../img/button-upload.ca8e9cfc.svg)}.database-migration__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.database-migration__icon{background:var(--contao);border-radius:10px;padding:10px}.database-migration__headline{margin-top:.5em;margin-bottom:.5em;font-size:36px;font-weight:100;line-height:1}.database-migration__description{margin:0 50px;font-weight:600}.database-migration__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em;padding:0 50px}@media(min-width:960px){.database-migration__actions{flex-direction:row}}.database-migration .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.database-migration .widget-button{width:auto}}.database-migration__main{margin:0 50px 50px;background:#24292e}.database-migration__loading{width:30px;margin:40px auto}.database-migration__loading .sk-circle{width:30px;height:30px}.widget-radio-button legend{margin-bottom:2px}.widget-radio-button>div{position:relative;margin:.25em 0}.widget-radio-button input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-radio-button label{display:block;padding-left:25px;background:url(../img/widget-radio--off.4e93f443.svg) 0 -1px no-repeat;background-size:20px 20px}.widget-radio-button input:checked+label{background-image:url(../img/widget-radio--on.181461b6.svg)}.widget-radio-button input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-radio-button input:disabled+label{opacity:.5}.setup__directories{margin-top:2em}.setup__directories>dt{margin-top:1em;font-weight:600}.setup__directories>dd{margin:0;word-break:break-all}.setup__directories>dd span{background-color:var(--highlight-bg);color:var(--highlight-color);font-weight:400}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.theme-details__constraint{flex-grow:1}.file-tree{margin:0;padding:0;list-style:none}.file-tree__folder{position:relative;padding-left:20px}.file-tree__folder:before{content:"";position:absolute;left:10px;top:6px;width:0;height:0;border-top:5px solid transparent;border-bottom:5px solid transparent;border-left:5px solid var(--text);transition:transform .1s ease-in-out}.file-tree__folder--open:before{transform:rotate(90deg)}.file-tree__file{padding-left:20px}.file-tree button{background:none;border:none;font-weight:400;cursor:pointer}.setup__versions{margin:0;padding:0 0 0 15px}.setup__version{margin:.5em 0;text-align:left}.setup__version--warning{color:var(--btn-alert)}.setup__releaseplan{margin-top:1.5em}.setup__fielddesc--version{margin-bottom:-1em!important}.setup__core-features{margin:5px 0 0 5px;font-size:12px}.setup__theme-image{max-width:100%;height:auto;border:1px solid var(--border)}.setup__theme p{margin:1em 0}.setup__theme-upload{position:absolute!important;visibility:hidden}.setup__themes{padding:0 14px}.setup__themes-results{display:grid;gap:14px}@media(min-width:1024px){.setup__themes-results{grid-template-columns:repeat(2,1fr)}.setup__themes-results-item{flex-basis:calc(50% - 16px);margin-left:8px;margin-right:8px}}.setup__themes-item{border:1px solid var(--tiles-bdr)}.setup__themes-more{margin-top:20px;text-align:center}.setup__theme-search{margin:20px 0 0;text-align:center}.setup__theme-search--empty{padding-top:60px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--offline{padding-top:60px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--loader .sk-circle{width:50px;height:50px;margin:0 auto 20px}.setup__theme-search button{margin-top:2em}.setup__fielddesc--warning{padding:10px 10px 10px 40px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 10px no-repeat}.setup__tabs{margin:1em 0}.setup__tab-controls{display:flex}.setup__tab-control{flex-grow:1;padding:4px 10px;border:none;border-top:1px solid var(--border);border-left:1px solid var(--border);background:none;cursor:pointer}.setup__tab-control:last-child{border-right:1px solid var(--border)}.setup__tab-control--active{border-color:var(--btn);background:var(--btn);color:#fff}.setup__tab{border:1px solid var(--border)}.setup__tab--files{white-space:pre;overflow:scroll;height:200px}.setup__requires{width:100%;border-collapse:collapse}.setup__requires td,.setup__requires th{margin:0;padding:3px 10px;text-align:start;vertical-align:top}.setup__requires th{background:var(--btn);color:#fff}.setup__requires td{border-bottom:1px solid var(--border)}.setup__requires tr:last-child td{border-bottom:none}.setup__requires tr:nth-child(odd) td{background:var(--table-odd-bg)}.setup__or{position:relative;overflow:hidden;margin:1em 0;text-align:center}.setup__or:before{content:"";position:absolute;top:.8em;left:0;right:0;display:block;height:1px;background:var(--border);z-index:1}.setup__or span{position:relative;padding:0 10px;background:var(--popup-bg);z-index:2}.view-setup{padding-top:40px}.view-setup footer{margin-top:40px}.view-setup__steps{padding:0 0 50px 0}.view-setup__steps ul{display:flex;margin:0;padding:0;list-style-type:none}.view-setup__steps li{display:flex;justify-content:center;align-items:center;flex-grow:1;position:relative;height:6px;margin:0;padding:0}.view-setup__steps li:before{content:"";position:absolute;left:-50%;right:50%;background:var(--border);height:5px}.view-setup__steps li:after{content:"";position:absolute;top:-18px;left:50%;margin-left:-21px;width:42px;height:42px;color:#fff;text-indent:0;text-align:center;line-height:35px;background:var(--border);border-radius:50%;z-index:1}.view-setup__steps li:first-child:before{content:none}.view-setup__steps li.active:after,.view-setup__steps li.active:before{background:var(--contao)}.view-setup__steps button{display:flex;justify-content:center;align-items:center;background:transparent;border:none;z-index:10;cursor:pointer}.view-setup__steps button:disabled{cursor:default}.view-setup__steps svg{fill:#fff}.view-setup__main{text-align:center}.view-setup__party{font-size:64px}.view-setup__headline{margin:10px 0 20px;padding:15px 0;font-size:42px;font-weight:100}.view-setup__description{max-width:500px;margin:1em 25px}.view-setup__start.widget-button{height:50px;margin:30px 10px 0;padding:0 50px;font-size:1.2em;line-height:50px}.view-setup__continue.widget-button{width:80%!important;margin:10px 0 0}.view-setup__funding{width:80%;margin:50px auto 0;padding:20px 25px;border:2px solid var(--funding);border-radius:var(--border-radius);background:rgba(var(--funding-rgb),.025);font-weight:400}.view-setup__funding figure{margin-bottom:1em}.view-setup__funding p{margin:0 0 .5em 0}.view-setup__funding-link{margin:1em 0 0}@media(min-width:960px){.view-setup{padding-top:80px}.view-setup footer{margin-top:80px}.view-setup__steps{padding-bottom:80px}.view-setup__headline{margin:20px 0 40px;font-size:64px}.view-setup__continue.widget-button{width:auto!important;margin:25px 10px 0;padding:0 20px}.view-setup__description{max-width:550px;margin:1em auto;font-size:1.2em}.view-setup__funding{display:flex;margin:60px auto -20px;text-align:left}.view-setup__funding figure{margin-right:25px}}.setup__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.setup__header .widget-button{margin-top:1em}.setup__icon{background:var(--contao);border-radius:10px;padding:10px}.setup__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.setup__description,.setup__warning{margin:1em 0;text-align:justify}.setup__warning{color:var(--btn-alert);font-weight:600}.setup__form{position:relative;max-width:280px;margin:0 auto 50px;opacity:1}.setup__form svg.setup__check{display:block;width:80px;height:80px;margin:0 auto 2em;fill:var(--btn-primary)}.setup__form .widget-select,.setup__form .widget-text{margin-top:10px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.setup__form .widget-checkbox{margin-top:20px;font-weight:400}.setup__form .widget-radio-button{margin-top:20px}.setup__fields{margin-bottom:2em}.setup__fields--center{text-align:center}.setup__fields .button-group .widget-button{margin-bottom:1px}.setup__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.setup__fielddesc{margin-bottom:1em;text-align:left}.setup__fielddesc code{word-break:break-word}.setup__actions{display:flex;flex-wrap:wrap;gap:10px}.setup__actions--center{justify-content:center}.setup__actions .button-group,.setup__actions .widget-button{flex-grow:1}.setup__actions .button-group--inline,.setup__actions .widget-button--inline{flex-grow:0}@media(min-width:960px){.setup{padding-top:100px}.setup__header{float:left;width:470px;max-width:none;padding:0 60px 50px}.setup__form{float:left;width:370px;max-width:none;margin:0 50px 50px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}.setup__form .widget-select input,.setup__form .widget-select select,.setup__form .widget-text input,.setup__form .widget-text select{width:250px!important}}.view-account__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-account__product{margin-top:15px;margin-bottom:40px;font-weight:600}.view-account__product strong{display:block;margin-bottom:10px;font-size:54px;font-weight:100;line-height:1}.view-account__headline{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.view-account__description{margin-bottom:1em;text-align:justify}.view-account__form,.view-account__totp{position:relative;max-width:280px;margin:0 auto}.view-account__form .widget-button,.view-account__totp .widget-button{margin-top:1.5em}.view-account__form .widget-text{margin-top:10px}.view-account__form .widget-text label{display:block;padding-bottom:5px}.view-account__contribute{max-width:280px;margin:60px auto 0;font-size:12px;text-align:center}.view-account__contribute br{display:none}@media(min-width:960px){.view-account{display:flex;flex-flow:row wrap;align-items:center;padding-top:50px}.view-account__form,.view-account__header,.view-account__totp{padding:50px;width:50%;max-width:none}.view-account__form .widget-text label{float:left;width:120px;padding-top:10px;font-weight:400}.view-account__form input[type=password],.view-account__form input[type=text],.view-account__form select{width:250px!important}.view-account__form .button-group,.view-account__form .widget-button--anchor{width:250px;margin-left:120px}.view-account__contribute{max-width:840px}.view-account__contribute br{display:block}}.popup-overlay{position:fixed;inset:0;z-index:1000;background:var(--popup-overlay-bg)}@media(min-width:960px){.popup-overlay{padding:20px 0;overflow-y:auto}}.popup-overlay__popup{position:fixed;display:block;top:50%;left:50%;width:500px;max-width:90%;background:var(--popup-bg);z-index:10;opacity:1;transform:translate(-50%,-50%);border-radius:var(--border-radius);overflow:hidden}.popup-overlay__headline{position:relative;margin-bottom:0;padding:7px 30px 6px;background:var(--popup-hl-bg);font-size:18px;color:#fff;font-weight:300;line-height:1.5em;text-align:center}.popup-overlay__headline--primary{background-color:var(--btn-primary)}.popup-overlay__headline--alert{background-color:var(--btn-alert)}.popup-overlay__content{padding:2em 20px}.popup-overlay__actions{display:flex;justify-content:center;gap:10px;flex-wrap:wrap;padding:0 20px 2em}.popup-overlay__actions .widget-button{width:auto;height:35px;padding:0 30px;line-height:35px}@media(min-width:550px){.popup-overlay__actions,.popup-overlay__content{padding-left:40px;padding-right:40px}}.loader__item{float:left;width:16px;height:16px;margin-right:1px;background-color:var(--contao);animation:loading 1.4s ease-in-out infinite both}.loader__item--20{animation-delay:-.64s}.loader__item--40{animation-delay:-.48s}.loader__item--60{animation-delay:-.32s}.loader__item--80{animation-delay:-.16s}@keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}.loader__text{float:left;width:40px}.sk-circle{width:25px;height:25px;position:relative}.sk-circle .sk-child{width:100%;height:100%;position:absolute;left:0;top:0}.sk-circle .sk-child:before{content:"";display:block;margin:0 auto;width:15%;height:15%;background-color:var(--text);border-radius:100%;animation:sk-circleBounceDelay 1.2s ease-in-out infinite both}.sk-circle .sk-circle2{transform:rotate(30deg)}.sk-circle .sk-circle3{transform:rotate(60deg)}.sk-circle .sk-circle4{transform:rotate(90deg)}.sk-circle .sk-circle5{transform:rotate(120deg)}.sk-circle .sk-circle6{transform:rotate(150deg)}.sk-circle .sk-circle7{transform:rotate(180deg)}.sk-circle .sk-circle8{transform:rotate(210deg)}.sk-circle .sk-circle9{transform:rotate(240deg)}.sk-circle .sk-circle10{transform:rotate(270deg)}.sk-circle .sk-circle11{transform:rotate(300deg)}.sk-circle .sk-circle12{transform:rotate(330deg)}.sk-circle .sk-circle2:before{animation-delay:-1.1s}.sk-circle .sk-circle3:before{animation-delay:-1s}.sk-circle .sk-circle4:before{animation-delay:-.9s}.sk-circle .sk-circle5:before{animation-delay:-.8s}.sk-circle .sk-circle6:before{animation-delay:-.7s}.sk-circle .sk-circle7:before{animation-delay:-.6s}.sk-circle .sk-circle8:before{animation-delay:-.5s}.sk-circle .sk-circle9:before{animation-delay:-.4s}.sk-circle .sk-circle10:before{animation-delay:-.3s}.sk-circle .sk-circle11:before{animation-delay:-.2s}.sk-circle .sk-circle12:before{animation-delay:-.1s}@keyframes sk-circleBounceDelay{0%,80%,to{transform:scale(0)}40%{transform:scale(1)}}.widget-button .loader{width:25px;margin:0 auto}.widget-button .sk-circle .sk-child:before{background-color:#fff}.loading-button{position:relative}.loading-button>.loader{position:absolute;left:calc(50% - 12.5px);top:calc(50% - 12.5px)}.loading-button>.loading{visibility:hidden}.link-menu{position:absolute;display:grid;grid-template:1fr/1fr;left:50%;gap:2px;margin:0;padding:2px;text-align:center;list-style-type:none;white-space:nowrap;background:var(--form-bg);border-top:3px solid var(--text);border-radius:5px;z-index:100;box-shadow:0 0 1px var(--shadow);outline:none}.link-menu:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--text) transparent;content:""}.link-menu--align-left{left:0;right:auto}.link-menu--align-left:before{left:17px;right:auto}.link-menu--align-right{left:auto;right:0}.link-menu--align-right:before{left:auto;right:17px}.link-menu--valign-top{bottom:0;border-top:none;border-bottom:3px solid var(--text);box-shadow:0 0 2px var(--shadow)}.link-menu--valign-top:before{top:auto;bottom:-7px;border-width:4px 3.5px 0 3.5px;border-color:var(--text) transparent transparent transparent}.link-menu--contao{border-color:var(--contao)}.link-menu--contao:before{border-bottom-color:var(--contao)}.link-menu--contao.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--contao)}.link-menu--primary{border-color:var(--btn-primary)}.link-menu--primary:before{border-bottom-color:var(--btn-primary)}.link-menu--primary.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-primary)}.link-menu--warning{border-color:var(--btn-warning)}.link-menu--warning:before{border-bottom-color:var(--btn-warning)}.link-menu--warning.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-warning)}.link-menu--alert{border-color:var(--btn-alert)}.link-menu--alert:before{border-bottom-color:var(--btn-alert)}.link-menu--alert.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-alert)}.link-menu__item{margin:0;padding:0;display:block}.link-menu__action{display:block;width:100%;border-radius:5px;padding:8px 16px;color:var(--text);font-size:inherit;text-align:center;background:none;border:none;cursor:pointer}.link-menu__action:hover{color:var(--text);background:var(--focus);text-decoration:none}.link-menu__action--active{font-weight:600;background:var(--focus)}.footer-languages{position:relative;display:inline-block}.footer-languages__toggle{width:auto;height:auto;padding:0 0 0 25px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--language) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.footer-languages__toggle:hover{color:var(--black)}.footer-languages__menu{display:grid;grid-template:auto/1fr 1fr;bottom:25px;white-space:nowrap;transform:translateX(-50%)}.footer-languages__menu button{margin:0;padding:6px;text-align:left;font-size:inherit}.theme-switch{position:relative;display:inline-block}.theme-switch button{width:auto;height:auto;padding:0 0 0 24px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--color-scheme) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.theme-switch button:hover{color:var(--black)}.package-logo--fallback[data-v-9c1c5f6c]{display:flex;justify-content:center;align-items:center}svg[data-v-9c1c5f6c]{width:80px;height:80px;fill:#ccc}.discover-package{display:flex;flex-direction:column;position:relative;overflow:hidden;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.discover-package.is--hint{border-color:var(--border--light)}.discover-package.is--hint .discover-package__inside>*{opacity:.65}.discover-package__hint{position:relative;background:var(--border--light);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.2;z-index:1}.discover-package__hint p a{display:inline-block;padding-right:10px}.discover-package__hint p a:first-child{margin-left:10px}.discover-package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.discover-package__inside{flex-grow:1;padding:16px}.discover-package__abandoned{display:inline-block;margin-bottom:1em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);cursor:help;z-index:10}@media(min-width:600px){.discover-package__abandoned{position:absolute;top:20px;left:-25px;padding:2px 30px;border-top:1px solid var(--btn-alert-active);transform:rotate(-45deg)}}.discover-package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.discover-package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%;max-height:140px}.discover-package__icon img,.discover-package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;object-fit:contain}.discover-package__details{display:flex;flex-direction:column;justify-content:space-between;min-height:96px}.discover-package__headline{margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.discover-package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__versions{display:flex;flex-wrap:wrap;gap:5px;list-style:none;margin:5px 0;padding:0}.discover-package__version{display:inline-flex;justify-content:center;padding:3px 5px;border-radius:4px;line-height:1;min-width:40px;font-size:13px;color:#fff;background:var(--badge-bg);pointer-events:none}.discover-package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.discover-package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__more{display:flex;flex-flow:row wrap;align-items:flex-end;flex-grow:1;gap:4px;line-height:28px}.discover-package__counts{flex-grow:1;justify-content:flex-start}.discover-package__count{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.discover-package__count--private{background-image:var(--svg--private)}.discover-package__count--updated{background-image:var(--svg--updated)}.discover-package__count--downloads{background-image:var(--svg--downloads)}.discover-package__count--favers{background-image:var(--svg--favers)}.discover-package__actions{flex-grow:1;display:flex;justify-content:flex-end;gap:8px}@media(max-width:599.98px){.discover-package__headline-container{display:flex;flex-direction:column-reverse}}@media(min-width:600px){.discover-package__inside{text-align:initial;display:flex;padding:0}.discover-package__icon{width:130px;height:100%;min-height:130px;margin:0;border-radius:0;position:revert;right:revert}.discover-package__icon img{width:100px;height:100px}.discover-package__icon svg{width:90px;height:90px}.discover-package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.discover-package__versions{float:right;margin:-3px 0 0 16px}.discover-package__description,.discover-package__headline{margin-right:0}.discover-package__more{flex-direction:row}.discover-package__actions{justify-content:end}}.vueperslide{white-space:normal;background-size:cover;flex-shrink:0;display:block;width:100%;position:relative}.vueperslide--clone-1{position:absolute;top:0;bottom:0;right:100%}.vueperslides--rtl .vueperslide--clone-1{right:auto;left:100%}.vueperslide[href]{-webkit-user-drag:none}.vueperslide__image{background-size:cover}.vueperslide__image,.vueperslide__loader{position:absolute;top:0;left:0;right:0;bottom:0}.vueperslide__loader{display:flex;flex-direction:column;align-items:center;justify-content:center}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){height:100%;margin:auto}.vueperslides--fade .vueperslide{position:absolute;top:0;left:0;right:0;bottom:0;opacity:0;transition:opacity ease-in-out;transition-duration:inherit}.vueperslides--fade .vueperslide--active,.vueperslides--fade .vueperslide--visible{z-index:1;opacity:1}.vueperslides--slide-image-inside .vueperslide{overflow:hidden}.vueperslides--3d .vueperslide{position:absolute;z-index:-1;height:100%}.vueperslides--3d .vueperslide--active,.vueperslides--3d .vueperslide--next-slide,.vueperslides--3d .vueperslide--previous-slide{z-index:0}.vueperslides--3d .vueperslide--active{z-index:1}.vueperslides--3d .vueperslide[face=front]{transform:rotateY(90deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=right]{transform:rotateY(90deg) translate(50%);transform-origin:100% 0}.vueperslides--3d .vueperslide[face=back]{transform:rotateY(270deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=left]{transform:rotateY(270deg) translate(-50%);transform-origin:0 0}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after,.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:before{content:"";position:absolute;bottom:100%;left:-1em;right:-1em;height:2em;box-shadow:0 0 20px #00000040;z-index:2}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after{top:100%;bottom:auto}.vueperslides__arrows{color:#fff}.vueperslides__arrows--outside{color:currentColor}.vueperslides__arrow{top:50%;background-color:transparent;border:none;opacity:.7}.vueperslides--rtl .vueperslides__arrow--next,.vueperslides__arrow--prev{right:auto;left:.5em}.vueperslides--rtl .vueperslides__arrow--prev,.vueperslides__arrow--next{left:auto;right:.5em}.vueperslides__arrow:hover{opacity:1}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--next,.vueperslides__arrows--outside .vueperslides__arrow--prev{right:auto;left:-3.5em}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--prev,.vueperslides__arrows--outside .vueperslides__arrow--next{left:auto;right:-3.5em}.vueperslides__paused{top:.7em;right:.7em;opacity:0;text-shadow:0 0 3px rgba(0,0,0,.4);z-index:1}.vueperslides:hover .vueperslides__paused{opacity:1}.vueperslides__bullets:not(.vueperslides__bullets--outside){color:#fff}.vueperslides__bullet{margin:1.5em .6em;padding:0;border:none;background:none}.vueperslides__bullet .default{width:12px;height:12px;border-radius:12px;border:1px solid currentColor;background-color:transparent;box-shadow:0 0 1px #00000080,0 0 3px #0000004d;transition:.4s ease-in-out;box-sizing:border-box}.vueperslides__bullet .default span{display:none}.vueperslides__bullet--active .default{border-width:6px}.vueperslide,.vueperslide__image{background-position:50%}.vueperslide__video{outline:none}.vueperslide--no-pointer-events:before{content:"";position:absolute;top:0;bottom:0;left:0;right:0}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){display:flex;flex:1 1 auto;flex-direction:column;align-items:center;justify-content:center;text-align:center}.vueperslide--has-image-inside .vueperslide__content-wrapper,.vueperslide--has-video .vueperslide__content-wrapper,.vueperslide__content-wrapper.parallax-fixed-content{position:absolute;z-index:2;top:0;bottom:0;left:0;right:0;display:flex;flex-direction:column;justify-content:center;align-items:center;pointer-events:none}.vueperslides{position:relative}.vueperslides--fixed-height .vueperslide,.vueperslides--fixed-height .vueperslides__inner,.vueperslides--fixed-height .vueperslides__parallax-wrapper{height:inherit}.vueperslides--fixed-height .vueperslides__parallax-wrapper{padding-bottom:0!important}.vueperslides--fixed-height.vueperslides--bullets-outside{margin-bottom:4em}.vueperslides__inner{position:relative;-webkit-user-select:none;-moz-user-select:none;user-select:none}.vueperslides__parallax-wrapper{position:relative;overflow:hidden}.vueperslides--3d .vueperslides__parallax-wrapper{overflow:visible}.vueperslides__track{position:absolute;top:0;height:100%;left:0;right:0;overflow:hidden;z-index:1}.vueperslides--parallax .vueperslides__track{height:200%;transform:translateY(0)}.vueperslides--touchable .vueperslides__track{cursor:ew-resize;cursor:grab}.vueperslides--touchable .vueperslides__track--dragging,.vueperslides--touchable .vueperslides__track--mousedown{cursor:grabbing}.vueperslides--3d .vueperslides__track{overflow:visible;perspective:100em}.vueperslides__track-inner{white-space:nowrap;transition:transform .5s ease-in-out;height:100%;display:flex}.vueperslides--no-animation .vueperslides__track-inner{transition-duration:0s!important}.vueperslides--fade .vueperslides__track-inner{white-space:normal;transition:none}.vueperslides--3d .vueperslides__track-inner{transform-style:preserve-3d}.vueperslides__track--mousedown .vueperslides__track-inner{transition:transform .25s ease-in-out!important}.vueperslides__track--dragging .vueperslides__track-inner{transition:none}.vueperslides__arrow{position:absolute;font-size:inherit;color:inherit;text-align:center;transform:translateY(-50%);transition:.3s ease-in-out;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;line-height:1}.vueperslides__arrow svg{vertical-align:middle;stroke:currentColor;fill:none;width:3.5em;padding:1em;stroke-width:1;transition:.3s ease-in-out;box-sizing:border-box}.vueperslides__arrow svg:hover{stroke-width:1.3}.vueperslides__paused{position:absolute;transition:.3s ease-in-out}.vueperslides__bullets{display:flex;justify-content:center;position:absolute;bottom:0;left:0;right:0}.vueperslides__bullets--outside{position:relative}.vueperslides__bullet,.vueperslides__bullets button{cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;display:flex;justify-content:center;align-items:center;color:inherit}.vueperslides__bullet::-moz-focus-inner,.vueperslides__bullets button::-moz-focus-inner{border:0}.vueperslides__fractions{position:absolute;top:.8em;left:.5em;z-index:2;padding:.2em 1em;border:1px solid hsla(0,0%,100%,.5);border-radius:2em;background:#fff3;color:#fff}.vueperslides__progress{position:absolute;top:0;left:0;right:0;z-index:2;height:6px;color:#000000b3}.vueperslides__progress>*{position:absolute;top:0;bottom:0;left:0;background:currentColor;transition:.3s ease-in-out}@media(min-width:1200px){.ads{margin:59px 0 69px}}.ads .link{padding-top:5px;text-align:right}.ads .link a{padding-left:16px;font-size:.8em;color:inherit;background:var(--svg--link-blank) left center no-repeat;background-size:13px 13px}.ads .container{position:relative;background:var(--popup-bg);box-shadow:var(--ad-shadow);border-radius:14px;overflow:hidden}.ads .container a,.ads .container img{display:block}.ads .container img{width:100%;aspect-ratio:2}.vueperslides__arrow:focus-visible{outline:5px auto Highlight!important;outline:5px auto -webkit-focus-ring-color!important}.package-sorting{margin:20px 0 15px;text-align:right}.package-sorting__label{display:inline-block;text-transform:uppercase}.package-sorting__label:after{content:":"}.package-sorting__group{position:relative;display:inline-flex;flex-direction:column;margin:0;padding:0 15px 0 0;list-style-type:none;text-align:left}.package-sorting__group:after{content:"";position:absolute;top:.8em;right:0;width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid #777}.package-sorting__item{display:none;margin:0 0 0 10px;padding:3px 0;border-bottom:2px solid transparent}.package-sorting__item:hover{color:var(--link)}.package-sorting__item--open{display:inline}.package-sorting__item--active{display:inline;color:var(--link);border-bottom:2px solid var(--link)}.package-sorting__item button{margin:0;padding:0;background:none;border:none;text-transform:uppercase;cursor:pointer}@media(min-width:600px){.package-sorting__group{flex-direction:row;justify-content:flex-end;padding:0}.package-sorting__group:after{content:none}.package-sorting__item{display:inline}}.search-bar{position:relative}.search-bar__input{height:50px!important;padding-right:45px!important;border-radius:50px!important}.search-bar__button{position:absolute;top:5px;right:5px;display:flex;align-items:center;width:38px;height:40px;margin:0;padding:7px;line-height:36px;border:none;border-radius:0 50px 50px 0;background:none}.package-search{position:relative}.package-search__input{max-width:400px;margin:0 20px}@media(min-width:1024px){.package-search__input{margin-right:0}}.package-search__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.package-search__results{display:grid;gap:20px;margin-bottom:20px}@media(min-width:1024px){.package-search__results{grid-template-columns:repeat(2,1fr)}}.package-search__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-search__status--empty{padding-top:140px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:100px 100px}.package-search__status--offline{padding-top:140px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:100px 100px}.package-search__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-search__status button{margin-top:2em}.package-search__explain{font-size:16px}.package-search__more{margin:10px 0 30px;text-align:center}.package-search__more-button{display:inline-block;margin:0 auto;padding:0;text-transform:uppercase;background:none;border:none;cursor:pointer}.package-search__more-button:hover{text-decoration:underline}.package-search__algolia{display:block;width:200px;margin:50px auto 0}.vjs-tree-brackets{cursor:pointer}.vjs-tree-brackets:hover{color:#1890ff}.vjs-check-controller{position:absolute;left:0}.vjs-check-controller.is-checked .vjs-check-controller-inner{background-color:#1890ff;border-color:#0076e4}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-checkbox:after{-webkit-transform:rotate(45deg) scaleY(1);transform:rotate(45deg) scaleY(1)}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-radio:after{-webkit-transform:translate(-50%,-50%) scale(1);transform:translate(-50%,-50%) scale(1)}.vjs-check-controller .vjs-check-controller-inner{display:inline-block;position:relative;border:1px solid #bfcbd9;border-radius:2px;vertical-align:middle;-webkit-box-sizing:border-box;box-sizing:border-box;width:16px;height:16px;background-color:#fff;z-index:1;cursor:pointer;-webkit-transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46);transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46)}.vjs-check-controller .vjs-check-controller-inner:after{-webkit-box-sizing:content-box;box-sizing:content-box;content:"";border:2px solid #fff;border-left:0;border-top:0;height:8px;left:4px;position:absolute;top:1px;-webkit-transform:rotate(45deg) scaleY(0);transform:rotate(45deg) scaleY(0);width:4px;-webkit-transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s,-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;-webkit-transform-origin:center;transform-origin:center}.vjs-check-controller .vjs-check-controller-inner.is-radio{border-radius:100%}.vjs-check-controller .vjs-check-controller-inner.is-radio:after{border-radius:100%;height:4px;background-color:#fff;left:50%;top:50%}.vjs-check-controller .vjs-check-controller-original{opacity:0;outline:none;position:absolute;z-index:-1;top:0;left:0;right:0;bottom:0;margin:0}.vjs-carets{position:absolute;right:0;cursor:pointer}.vjs-carets svg{-webkit-transition:-webkit-transform .3s;transition:-webkit-transform .3s;transition:transform .3s;transition:transform .3s,-webkit-transform .3s}.vjs-carets:hover{color:#1890ff}.vjs-carets-close{-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.vjs-tree-node{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative;line-height:20px}.vjs-tree-node.has-carets{padding-left:15px}.vjs-tree-node.has-carets.has-selector,.vjs-tree-node.has-selector{padding-left:30px}.vjs-tree-node.is-highlight,.vjs-tree-node:hover{background-color:#e6f7ff}.vjs-tree-node .vjs-indent{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative}.vjs-tree-node .vjs-indent-unit{width:1em}.vjs-tree-node .vjs-indent-unit.has-line{border-left:1px dashed #bfcbd9}.vjs-tree-node.dark.is-highlight,.vjs-tree-node.dark:hover{background-color:#2e4558}.vjs-node-index{position:absolute;right:100%;margin-right:4px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vjs-colon{white-space:pre}.vjs-comment{color:#bfcbd9}.vjs-value{word-break:break-word}.vjs-value-null,.vjs-value-undefined{color:#d55fde}.vjs-value-boolean,.vjs-value-number{color:#1d8ce0}.vjs-value-string{color:#13ce66}.vjs-tree{font-family:Monaco,Menlo,Consolas,Bitstream Vera Sans Mono,monospace;font-size:14px;text-align:left}.vjs-tree.is-virtual{overflow:auto}.vjs-tree.is-virtual .vjs-tree-node{white-space:nowrap}[data-notivue=promise-resolve],[data-notivue=success]{--nv-bg:var(--nv-success-bg);--nv-fg:var(--nv-success-fg);--nv-accent:var(--nv-success-accent,var(--nv-global-accent));--nv-border:var(--nv-success-border)}[data-notivue=error],[data-notivue=promise-reject]{--nv-bg:var(--nv-error-bg);--nv-fg:var(--nv-error-fg);--nv-accent:var(--nv-error-accent,var(--nv-global-accent));--nv-border:var(--nv-error-border)}[data-notivue=warning]{--nv-bg:var(--nv-warning-bg);--nv-fg:var(--nv-warning-fg);--nv-accent:var(--nv-warning-accent,var(--nv-global-accent));--nv-border:var(--nv-warning-border)}[data-notivue=info]{--nv-bg:var(--nv-info-bg);--nv-fg:var(--nv-info-fg);--nv-accent:var(--nv-info-accent,var(--nv-global-accent));--nv-border:var(--nv-info-border)}[data-notivue=promise]{--nv-bg:var(--nv-promise-bg);--nv-fg:var(--nv-promise-fg);--nv-accent:var(--nv-promise-accent,var(--nv-global-accent));--nv-border:var(--nv-promise-border)}.Notivue__notification{--tip-width:calc(var(--tip-width-fx, 1)*var(--nv-tip-width, 0px));box-sizing:border-box;position:relative;width:var(--nv-min-width,auto);max-width:var(--nv-width,100%);background-color:var(--nv-bg,var(--nv-global-bg));display:flex;align-items:var(--nv-y-align);border-radius:var(--nv-radius,0);border:var(--nv-border-width,0) solid var(--nv-border,var(--nv-global-border));box-shadow:var(--nv-shadow,0 0 transparent),inset var(--tip-width) 0 0 var(--nv-accent)}.Notivue__notification *{box-sizing:border-box;touch-action:manipulation}.Notivue__notification[data-notivue-has-title=true]{align-items:var(--nv-y-align-has-title,var(--nv-y-align))}.Notivue__icon{display:flex;justify-content:center;align-items:center;overflow:visible;min-width:var(--nv-icon-size);width:var(--nv-icon-size);height:var(--nv-icon-size);margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing);color:var(--nv-accent)}.Notivue__content{--nv-content-space:calc(var(--nv-spacing) + var(--nv-spacing)*0.15);display:flex;flex-direction:column;flex-grow:1;text-align:inherit;padding:var(--nv-content-space)}.Notivue__content-title{line-height:1.15;font-weight:700;color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-title-size);margin:0 0 .33em;padding:0}.Notivue__transition-enter-active{--dur-easing:.5s cubic-bezier(.16,1,.3,1);transition:opacity var(--dur-easing),transform var(--dur-easing)}@media (prefers-reduced-motion:reduce){.Notivue__transition-enter-active{transition:none}}.Notivue__transition-enter-from{opacity:0;transform:scale(.8)}.Notivue__transition-enter-to{opacity:1;transform:scale(1)}.Notivue__transition-leave-active{transition:opacity 0ms ease}.Notivue__transition-leave-from,.Notivue__transition-leave-to{opacity:0}.Notivue__content-message{max-height:250px;overflow:auto;line-height:1.375;margin:0;padding:0;white-space:pre-line}.Notivue__close,.Notivue__content-message{color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-message-size)}.Notivue__close{position:relative;cursor:pointer;padding:calc(var(--nv-spacing)/2);margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0;font-weight:700;border:none;background:none;line-height:1;-webkit-tap-highlight-color:rgba(0,0,0,0)}.Notivue__close:after{content:"";position:absolute;top:0;right:0;bottom:0;left:0;width:100%;height:100%;background-color:var(--nv-fg,var(--nv-global-fg));opacity:0;border-radius:calc(var(--nv-radius)/2);transition:opacity .1s ease-out}@media (hover:hover){.Notivue__close:hover{opacity:1}.Notivue__close:hover:after{opacity:.1}.Notivue__close:hover .Notivue__close-icon{opacity:1}}.Notivue__close-icon{width:var(--nv-icon-size);height:var(--nv-icon-size);display:flex;color:var(--nv-fg,var(--nv-global-fg));pointer-events:none;opacity:.65}.Notivue__spinner{transform-origin:center;animation:Notivue__spinner-kf .75s linear infinite}@keyframes Notivue__spinner-kf{to{transform:rotate(1turn)}}@media (prefers-reduced-motion:reduce){.Notivue__duplicate,.Notivue__spinner{animation:none}}[dir=rtl] .Notivue__notification{--tip-width-fx:-1}[dir=rtl] .Notivue__icon{margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0}[dir=rtl] .Notivue__content-message{font-size:calc(var(--nv-message-size) + .1em)}[dir=rtl] .Notivue__content-title{font-size:calc(var(--nv-title-size) + .1em)}[dir=rtl] .Notivue__close{margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing)}.Notivue__duplicate{animation:Notivue__duplicate-kf .3s cubic-bezier(.16,1,.3,1) forwards}@keyframes Notivue__duplicate-kf{0%{transform:scale(1);opacity:1}50%{transform:scale(1.035);opacity:.8}to{transform:scale(1);opacity:1}}[data-notivue-align=top] .Notivue__enter,[data-notivue-align=top] .Notivue__leave{--notivue-ty:-200%}[data-notivue-align=bottom] .Notivue__enter,[data-notivue-align=bottom] .Notivue__leave{--notivue-ty:200%}.Notivue__enter{animation:Notivue__enter-kf .35s cubic-bezier(.5,1,.25,1)}.Notivue__leave{animation:Notivue__leave-kf .35s ease}.Notivue__clearAll{animation:Notivue__clearAll-kf .5s cubic-bezier(.22,1,.36,1)}@keyframes Notivue__enter-kf{0%{transform:translate3d(0,var(--notivue-ty),0) scale(.25);opacity:0}to{transform:translateZ(0) scale(1);opacity:1}}@keyframes Notivue__leave-kf{0%{transform:translateZ(0) scale(1);opacity:.7}to{transform:translate3d(0,var(--notivue-ty),0) scale(0);opacity:0}}@keyframes Notivue__clearAll-kf{0%{opacity:1}to{opacity:0}}.config-check__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.config-check__icon{background:var(--contao);border-radius:10px;padding:10px}.config-check__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.config-check__description{text-align:justify}.config-check__form{position:relative;max-width:280px;margin:0 auto 50px}.config-check__form .widget-select,.config-check__form .widget-text{margin-top:20px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.config-check__fields{margin-bottom:2em}.config-check__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.config-check__fielddesc{margin-bottom:1em}.config-check__issues{margin-bottom:1em;color:var(--btn-alert)}.config-check__issues p{font-weight:600}.config-check__issues ul{margin:0;padding:0}.config-check__issues li{margin:.5em 0 0 25px;padding:0}.config-check .widget-button{margin-bottom:.5em}@media(min-width:960px){.config-check{padding-top:100px}.config-check__header{float:left;width:470px;max-width:none;padding:0 60px 100px}.config-check__form{float:left;width:370px;max-width:none;margin:20px 50px 0;padding-bottom:100px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}}"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[120],{8120:function(e){e.exports=JSON.parse('{"ui.app.title":"Extensions Contao","ui.app.loading":"Chargement de la liste des extensions…","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Publicité dans la liste des extensions","ui.discover.loading":"Chargement…","ui.discover.offline":"Impossible de récupérer des résultats.","ui.discover.offlineExplain":"Vérifiez votre connexion Internet et désactivez les bloqueurs JavaScript dans votre navigateur.","ui.discover.offlineButton":"Réessayer","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"Pas de résultats pour {query}","ui.discover.more":"Plus de résulats","ui.discover.sortBy":"Trier par","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Mis à jour","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Téléchargements","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Note","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Détails","ui.discover.latestPackages":"Extensions les plus récentes et mises à jour","ui.discover.faversPackages":"Extensions les mieux notées","ui.discover.downloadsPackages":"Extensions les plus téléchargées","ui.package.homepage":"Site web du projet","ui.package.private":"Package privé","ui.package.privateTitle":"Les packages privés ne sont disponibles que chez le fournisseur (par exemple sous forme de téléchargement ZIP). Veuillez visiter le site Web pour plus d\'informations","ui.package.abandoned":"abandonné","ui.package.abandonedText":"Ce package est abandonné et n\'est plus maintenu.","ui.package.abandonedReplace":"Ce package est abandonné et n\'est plus maintenu. L\'auteur suggère d\'utiliser le package {replacement} à la place.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Extension précédente","ui.package-details.close":"Fermer les détails","ui.package-details.loading":"Chargement…","ui.package-details.tabDescription":"Description","ui.package-details.tabRequire":"Prérequis","ui.package-details.tabFeatures":"Fonctionnalités","ui.package-details.tabSuggest":"Suggestions","ui.package-details.tabConflict":"Conflits","ui.package-details.tabDependents":"Dépendants","ui.package-details.linkRequires":"nécessite","ui.package-details.linkReplaces":"remplaces","ui.package-details.linkProvides":"fournis","ui.package-details.linkConflicts":"conflits","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Dernière version","ui.package-details.released":"Publié le","ui.package-details.license":"License(s)","ui.package-details.authors":"de","ui.package-details.more":"Plus","ui.package-details.packagist":"Détails du Package","ui.package-details.metadata":"Editer les Metadata","ui.package-details.support_docs":"Documentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Code source","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[523],{523:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Erweiterungen","ui.app.loading":"Lade Erweiterungsliste …","ui.app.language":"Sprache für den Contao Manager wechseln","ui.app.colorDark":"Dunkles Design","ui.app.colorDarkTitle":"Farbschema auf dunkel umstellen","ui.app.colorLight":"Helles Design","ui.app.colorLightTitle":"Farbschema auf hell umstellen","ui.discover.advertisement":"Anzeigen in der Erweiterungsliste","ui.discover.loading":"Laden …","ui.discover.offline":"Konnte keine Ergebnisse laden.","ui.discover.offlineExplain":"Prüfe deine Internet-Verbindung und deaktiviere alle JavaScript-Blocker.","ui.discover.offlineButton":"Erneut versuchen","ui.discover.searchPlaceholder":"{count} Erweiterungen durchsuchen …","ui.discover.empty":"Keine Ergebnisse für {query}","ui.discover.more":"Mehr Resultate","ui.discover.sortBy":"Sortieren nach","ui.discover.sortReleased":"Veröffentlicht","ui.discover.sortReleasedTitle":"Ergebnisse nach der Veröffentlichung sortieren","ui.discover.sortLatest":"Aktualisiert","ui.discover.sortLatestTitle":"Ergebnisse nach der letzten Aktualisierung sortieren","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Ergebnisse nach Anzahl Downloads sortieren","ui.discover.sortFavers":"Bewertung","ui.discover.sortFaversTitle":"Ergebnisse nach Bewertung sortieren","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Neuste und aktualisierte Erweiterungen","ui.discover.faversPackages":"Bestbewertete Erweiterungen","ui.discover.downloadsPackages":"Meistgeladene Erweiterungen","ui.package.homepage":"Projektwebseite","ui.package.private":"Privates Paket","ui.package.privateTitle":"Private Pakete sind nur vom jeweiligen Hersteller verfügbar (z.B. als ZIP-Download). Besuche die Webseite für weitere Informationen.","ui.package.abandoned":"verwaist","ui.package.abandonedText":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt.","ui.package.abandonedReplace":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt. Der Autor empfiehlt stattdessen das Paket {replacement} zu verwenden.","ui.package.contaoVersion":"Verfügbar für Contao","ui.package-details.previous":"Details der vorherigen Erweiterung","ui.package-details.close":"Details der Erweiterung schließen","ui.package-details.loading":"Laden …","ui.package-details.tabDescription":"Beschreibung","ui.package-details.tabRequire":"Abhängigkeiten","ui.package-details.tabFeatures":"Funktionen","ui.package-details.tabSuggest":"Empfehlungen","ui.package-details.tabConflict":"Konflikte","ui.package-details.tabDependents":"Abhängige","ui.package-details.linkRequires":"benötigt","ui.package-details.linkReplaces":"ersetzt","ui.package-details.linkProvides":"liefert","ui.package-details.linkConflicts":"inkompatibel mit","ui.package-details.funding":"Weiterentwicklung finanzieren!","ui.package-details.contaoVersions":"Unterstützte Contao-Version(en)","ui.package-details.latest":"Neuste Version","ui.package-details.released":"veröffentlicht am","ui.package-details.license":"Lizenz(en)","ui.package-details.authors":"von","ui.package-details.more":"Mehr","ui.package-details.packagist":"Paketdetails","ui.package-details.metadata":"Metadaten bearbeiten","ui.package-details.support_docs":"Dokumentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support-Forum","ui.package-details.support_issues":"Fehler melden","ui.package-details.support_source":"Quellcode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS-Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[904],{5523:function(t,e,o){o.r(e),o.d(e,{default:function(){return I}});var s=o(641),a=o(33),n=o(3751),i=o(6894);const u={class:"view-account__header"},r={class:"view-account__product"},l=["href"],c={href:"https://github.com/contao/contao-manager/issues",target:"_blank"},d={key:0,class:"view-account__totp"},p={class:"view-account__headline"},h={class:"view-account__description"},g={key:1,class:"view-account__form"},m={class:"view-account__headline"},b={class:"view-account__description"},w={class:"view-account__fields"},k=["disabled"],_={class:"view-account__contribute"},v={href:"https://to.contao.org/donate",target:"_blank"};function $(t,e,o,$,f,L){const y=(0,s.g2)("i18n-t"),A=(0,s.g2)("text-field"),T=(0,s.g2)("button-group"),C=(0,s.g2)("loading-button"),P=(0,s.g2)("boxed-layout");return(0,s.uX)(),(0,s.Wv)(P,{wide:!0,slotClass:"view-account"},{default:(0,s.k6)((()=>[(0,s.Lk)("header",u,[e[11]||(e[11]=(0,s.Lk)("img",{src:i,width:"100",height:"100",alt:"Contao Logo"},null,-1)),(0,s.Lk)("p",r,[(0,s.Lk)("strong",null,(0,a.v_)(t.$t("ui.account.welcome")),1),e[8]||(e[8]=(0,s.eW)(" Contao Manager 1.9.5 "))]),(0,s.Lk)("p",null,[(0,s.bF)(y,{keypath:"ui.account.intro1"},{readTheManualToGetStarted:(0,s.k6)((()=>[(0,s.bF)(y,{tag:"strong",keypath:"ui.account.introGetStarted"},{readTheManual:(0,s.k6)((()=>[(0,s.Lk)("a",{href:`https://to.contao.org/docs/contao-manager?lang=${t.$i18n.locale}`,target:"_blank"},(0,a.v_)(t.$t("ui.account.introManual")),9,l)])),_:1})])),_:1}),e[9]||(e[9]=(0,s.Lk)("br",null,null,-1)),e[10]||(e[10]=(0,s.Lk)("br",null,null,-1)),(0,s.bF)(y,{keypath:"ui.account.intro2"},{ourGithubIssues:(0,s.k6)((()=>[(0,s.Lk)("a",c,(0,a.v_)(t.$t("ui.account.introIssues")),1)])),_:1})])]),(0,s.bF)(n.eB,{name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,s.k6)((()=>[t.currentUser&&!t.hasTotp?((0,s.uX)(),(0,s.CE)("main",d,[(0,s.Lk)("h1",p,(0,a.v_)(t.$t("ui.account.totpHeadline")),1),(0,s.Lk)("p",h,(0,a.v_)(t.$t("ui.account.totpDescription")),1),(0,s.Lk)("button",{class:"widget-button widget-button--primary",onClick:e[0]||(e[0]=function(){return L.setupTotp&&L.setupTotp(...arguments)})},(0,a.v_)(t.$t("ui.totp.setup")),1),(0,s.Lk)("button",{class:"widget-button widget-button--alert",onClick:e[1]||(e[1]=function(){return L.skipTotp&&L.skipTotp(...arguments)})},(0,a.v_)(t.$t("ui.totp.skip")),1)])):((0,s.uX)(),(0,s.CE)("main",g,[(0,s.Lk)("form",{onSubmit:e[7]||(e[7]=(0,n.D$)((function(){return L.createAccount&&L.createAccount(...arguments)}),["prevent"]))},[(0,s.Lk)("h1",m,(0,a.v_)(t.$t("ui.account.headline")),1),(0,s.Lk)("p",b,(0,a.v_)(t.$t("ui.account.description")),1),(0,s.Lk)("fieldset",w,[(0,s.bF)(A,{ref:"username",name:"username",label:t.$t("ui.account.username"),disabled:t.logging_in,required:"",error:t.errors.username,onBlur:e[2]||(e[2]=e=>t.errors.username=""),modelValue:t.username,"onUpdate:modelValue":e[3]||(e[3]=e=>t.username=e)},null,8,["label","disabled","error","modelValue"]),t.usePassword?((0,s.uX)(),(0,s.Wv)(A,{key:0,ref:"password",name:"password",type:"password",label:t.$t("ui.account.password"),placeholder:t.$t("ui.account.passwordPlaceholder"),disabled:t.logging_in,required:"",pattern:".{8,}",error:t.errors.password,onBlur:L.validatePassword,modelValue:t.password,"onUpdate:modelValue":e[4]||(e[4]=e=>t.password=e)},null,8,["label","placeholder","disabled","error","onBlur","modelValue"])):(0,s.Q3)("",!0),t.supportsWebAuthn?((0,s.uX)(),(0,s.Wv)(T,{key:1,submit:"",color:"primary",disabled:!t.valid,loading:t.logging_in,label:t.$t("ui.account.submit")},{default:(0,s.k6)((()=>[(0,s.Lk)("button",{type:"button",class:"widget-button",disabled:t.logging_in,onClick:e[5]||(e[5]=e=>t.usePassword=!t.usePassword)},(0,a.v_)(t.$t("ui.account."+(t.usePassword?"usePasskey":"usePassword"))),9,k)])),_:1},8,["disabled","loading","label"])):((0,s.uX)(),(0,s.Wv)(C,{key:2,submit:"",color:"primary",disabled:!t.valid,loading:t.logging_in},{default:(0,s.k6)((()=>[(0,s.eW)((0,a.v_)(t.$t("ui.account.submit")),1)])),_:1},8,["disabled","loading"])),L.isInvitation?((0,s.uX)(),(0,s.CE)("button",{key:3,type:"button",class:"widget-button widget-button--anchor",onClick:e[6]||(e[6]=function(){return L.gotoLogin&&L.gotoLogin(...arguments)})},(0,a.v_)(t.$t("ui.account.login")),1)):(0,s.Q3)("",!0)])],32)]))])),_:1}),(0,s.Lk)("aside",_,[(0,s.Lk)("p",null,[(0,s.eW)((0,a.v_)(t.$t("ui.account.contribute1")),1),e[12]||(e[12]=(0,s.Lk)("br",null,null,-1)),(0,s.bF)(y,{keypath:"ui.account.contribute2"},{donate:(0,s.k6)((()=>[(0,s.Lk)("a",v,(0,a.v_)(t.$t("ui.account.contributeDonate")),1)])),_:1})])])])),_:1})}var f=o(6278),L=o(60),y=o(707),A=o(728),T=o(9757),C=o(85),P=o(4676),V=o(9473),W={components:{BoxedLayout:A.A,TextField:T.A,LoadingButton:C.A,ButtonGroup:P.A},data:()=>({username:"",password:"",errors:{username:"",password:""},valid:!1,logging_in:!1,usePassword:!1,supportsWebAuthn:!0}),computed:{...(0,f.aH)("auth",{currentUser:"username",hasTotp:"totpEnabled"}),isInvitation:t=>!!t.$route.query.invitation},methods:{validate(){this.valid=this.$refs.username.checkValidity()&&(!this.usePassword||this.$refs.password.checkValidity())},validatePassword(){this.errors.password=null,""!==this.password&&this.password.length<8&&(this.errors.password=this.$t("ui.account.passwordLength"))},async createAccount(){if(!this.valid)return;this.logging_in=!0;const t={username:this.username};if(this.isInvitation&&(t.invitation=this.$route.query.invitation),this.usePassword)t.password=this.password;else{const o=(await this.$request.post("api/session/options",t)).data;let s;try{s=await(0,L.Ct)({optionsJSON:o})}catch(e){return void(this.logging_in=!1)}if(!s)return void(this.logging_in=!1);t.passkey=JSON.stringify(s)}201!==(await this.$store.dispatch("auth/login",t)).status&&(this.logging_in=!1,this.errors.username=this.$t("ui.account.loginInvalid"),setTimeout((()=>{this.$refs.username.focus()}),0))},setupTotp(){this.$store.commit("modals/open",{id:"setup-totp",component:V.A})},skipTotp(){this.$store.commit("setView",y.A.BOOT)},gotoLogin(){this.$router.replace({name:this.$route.name,query:null}),this.$store.commit("setView",y.A.LOGIN)}},watch:{username(){this.validate()},password(){this.validate()},hasTotp(){this.$store.commit("setView",y.A.BOOT)}},mounted(){this.supportsWebAuthn="https:"===location.protocol&&(0,L.zZ)(),this.usePassword=!this.supportsWebAuthn,this.$refs.username&&this.$refs.username.focus()}},B=o(6262);const F=(0,B.A)(W,[["render",$]]);var I=F}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[669],{9669:function(e){e.exports=JSON.parse('{"ui.app.title":"افزونه‌های کنتائو","ui.app.loading":"بارگذاری لیست افزونه...","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"بارگذاری ...","ui.discover.offline":"Could not fetch any results.","ui.discover.offlineExplain":"Check your internet connection and disable JavaScript blockers in your browser.","ui.discover.offlineButton":"دوباره تلاش کنید","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"هیچ نتیجه‌ای برای {query}","ui.discover.more":"نتایج بیشتر","ui.discover.sortBy":"مرتب‌سازی براساس","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"بروزرسانی شده","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"دانلودها","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"امتیاز","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"جزئیات","ui.discover.latestPackages":"Latest and updated extensions","ui.discover.faversPackages":"افزونه‌های با امتیاز بالا","ui.discover.downloadsPackages":"Most downloaded extensions","ui.package.homepage":"وب‌سایت پروژه","ui.package.private":"بسته اختصاصی","ui.package.privateTitle":"Private packages are only available from the vendor (e.g. as a ZIP download). Please visit the website for more information.","ui.package.abandoned":"منع شده","ui.package.abandonedText":"This package is abandoned and no longer maintained.","ui.package.abandonedReplace":"This package is abandoned and no longer maintained. The author suggests using the {replacement} package instead.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"جزئیات افزونه قبلی","ui.package-details.close":"بستن جزئیات افزونه","ui.package-details.loading":"بارگذاری ...","ui.package-details.tabDescription":"توضیح","ui.package-details.tabRequire":"نیازمندی‌ها","ui.package-details.tabFeatures":"ویژگی‌ها","ui.package-details.tabSuggest":"پیشنهادها","ui.package-details.tabConflict":"ناسازگاری‌ها","ui.package-details.tabDependents":"وابسته‌ها","ui.package-details.linkRequires":"نیاز دارد","ui.package-details.linkReplaces":"جایگزین می‌کند","ui.package-details.linkProvides":"فراهم می‌کند","ui.package-details.linkConflicts":"ناسازگار است","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"آخرین نسخه","ui.package-details.released":"منتشر شده در","ui.package-details.license":"مجوز(ها)","ui.package-details.authors":"از","ui.package-details.more":"بیشتر","ui.package-details.packagist":"جژئیات بسته","ui.package-details.metadata":"ویرایش فرداده","ui.package-details.support_docs":"مستندات","ui.package-details.support_wiki":"ویکی","ui.package-details.support_forum":"انجمن پشتیبانی","ui.package-details.support_issues":"مشکلات / گزارش باگ","ui.package-details.support_source":"کد منبع","ui.package-details.support_irc":"IRC / چت","ui.package-details.support_email":"ایمیل پشتیبانی","ui.package-details.support_rss":"خوراک RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[101,335],{4686:function(e,t){var s=this&&this.__extends||function(){var e=function(t,s){return e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&(e[s]=t[s])},e(t,s)};return function(t,s){if("function"!==typeof s&&null!==s)throw new TypeError("Class extends value "+String(s)+" is not a constructor or null");function i(){this.constructor=t}e(t,s),t.prototype=null===s?Object.create(s):(i.prototype=s.prototype,new i)}}();Object.defineProperty(t,"__esModule",{value:!0}),t.treeifyPaths=t.Node=t.PathTree=void 0;var i=function(){function e(e){void 0===e&&(e=""),this.path=e,this.name="",this.children=[]}return e}();t.PathTree=i;var a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s(t,e),t}(i);function o(e,t,s){void 0===s&&(s={});var a={};t.forEach((function(t){var s=t[0],o=t[1],n=r(s).split("/"),l=n[0];if(!a[l]){var u="".concat(e.path,"/").concat(n[0]);a[l]={paths:[],obj:new i(r(u))}}if(1==n.length)a[l].obj.name=l,a[l].obj.ctx=o;else{n.shift();var c=n.join("/");a[l].paths.push([c,o]),a[l].obj.ctx=o}}));var n=Object.keys(a);return s.caseInsensitive?n.sort((function(e,t){return e.toLocaleLowerCase().localeCompare(t.toLocaleLowerCase())})):n.sort(),n.forEach((function(t){var i=a[t].obj;o(i,a[t].paths,s),(i.name||i.path||i.children.length)&&e.children.push(i)})),s.directoriesFirst?e.children.sort((function(e,t){return e.children.length&&!t.children.length?-1:t.children.length&&!e.children.length?1:0})):s.directoriesLast&&e.children.sort((function(e,t){return e.children.length&&!t.children.length?1:t.children.length&&!e.children.length?-1:0})),e}function n(e,t){void 0===e&&(e=[]),void 0===t&&(t={});var s=l(e)?e.map((function(e){return[e,void 0]})):e;return o(new i,s,t)}t.Node=a,t.treeifyPaths=n,t["default"]=n;var r=function(e){return e.replace(/^\/*/,"").replace(/\/*$/,"")},l=function(e){return"string"===typeof e[0]}},8144:function(e,t,s){s.r(t),s.d(t,{default:function(){return ki}});var i=s(641),a=s(33),o=s(3382),n=s(6894);const r={key:0,class:"view-setup__steps"},l=["onClick","disabled"],u=["src"],c={key:1,class:"view-setup__main"},d={class:"view-setup__headline"},p={class:"view-setup__description"},h={class:"view-setup__description"},m={href:"/contao/install",class:"widget-button widget-button--primary view-setup__continue"},_={class:"view-setup__description"},v={href:"/contao",class:"widget-button widget-button--primary view-setup__continue"},k={class:"view-setup__funding"},b={class:"view-setup__funding-link widget-button widget-button--small widget-button--funding widget-button--link",href:"https://to.contao.org/donate",target:"_blank"},g={key:3,class:"view-setup__main"},f={class:"view-setup__headline"},y={class:"view-setup__description"},w={href:"https://to.contao.org/support",target:"_blank"};function L(e,t,s,L,$,C){const E=(0,i.g2)("i18n-t"),X=(0,i.g2)("boxed-layout");return(0,i.uX)(),(0,i.Wv)(X,{wide:!0,slotClass:"view-setup"},{default:(0,i.k6)((()=>[C.currentStep>0?((0,i.uX)(),(0,i.CE)("section",r,[(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(C.steps,((e,t)=>((0,i.uX)(),(0,i.CE)("li",{class:(0,a.C4)({active:C.currentStep>t}),key:e.name},[(0,i.Lk)("button",{onClick:e=>C.currentStep=t+1,disabled:C.currentStep<=t+1},[(0,i.Lk)("img",{src:e.icon,width:"24",height:"24",alt:""},null,8,u)],8,l)],2)))),128)),(0,i.Lk)("li",{class:(0,a.C4)({active:C.currentStep>C.steps.length})},t[4]||(t[4]=[(0,i.Lk)("button",{disabled:""},[(0,i.Lk)("svg",{xmlns:"http://www.w3.org/2000/svg",height:"24px",viewBox:"0 0 24 24",width:"24px"},[(0,i.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"}),(0,i.Lk)("path",{d:"M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z"})])],-1)]),2)])])):(0,i.Q3)("",!0),C.currentStep>C.steps.length?((0,i.uX)(),(0,i.CE)("main",c,[t[6]||(t[6]=(0,i.Lk)("span",{class:"view-setup__party"},"🎉",-1)),(0,i.Lk)("h1",d,(0,a.v_)(e.$t("ui.setup.complete")),1),(0,i.Lk)("p",p,(0,a.v_)(e.$t("ui.setup.complete1",{version:e.contaoVersion})),1),e.showInstallTool?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.Lk)("p",h,(0,a.v_)(e.$t("ui.setup.complete2")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline",onClick:t[0]||(t[0]=function(){return C.launch&&C.launch(...arguments)})},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("a",m,(0,a.v_)(e.$t("ui.setup.installTool")),1)],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.Lk)("p",_,(0,a.v_)(e.$t("ui.setup.complete3")),1),(0,i.Lk)("button",{class:"widget-button view-setup__continue",onClick:t[1]||(t[1]=function(){return C.launch&&C.launch(...arguments)})},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("a",v,(0,a.v_)(e.$t("ui.setup.login")),1)],64)),(0,i.Lk)("div",k,[t[5]||(t[5]=(0,i.Lk)("figure",null,[(0,i.Lk)("img",{src:o,width:"80",height:"80",alt:""})],-1)),(0,i.Lk)("div",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.$t("ui.setup.funding").split("\n"),((e,t)=>((0,i.uX)(),(0,i.CE)("p",{key:t},(0,a.v_)(e),1)))),128)),(0,i.Lk)("p",null,[(0,i.Lk)("a",b,(0,a.v_)(e.$t("ui.setup.fundingLink")),1)])])])])):C.currentStep>0?((0,i.uX)(),(0,i.Wv)((0,i.$y)(C.steps[C.currentStep-1].component),{key:2,onContinue:t[2]||(t[2]=e=>C.currentStep+=1)},null,32)):((0,i.uX)(),(0,i.CE)("main",g,[t[7]||(t[7]=(0,i.Lk)("img",{src:n,width:"100",height:"100",alt:"Contao Logo",class:"view-setup__icon"},null,-1)),(0,i.Lk)("h1",f,(0,a.v_)(e.$t("ui.setup.welcome")),1),(0,i.Lk)("p",y,(0,a.v_)(e.$t("ui.setup.welcome1")),1),(0,i.bF)(E,{tag:"p",class:"view-setup__description",keypath:"ui.setup.welcome2"},{support:(0,i.k6)((()=>[(0,i.Lk)("a",w,(0,a.v_)(e.$t("ui.setup.support")),1)])),_:1}),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary view-setup__start",onClick:t[3]||(t[3]=e=>C.currentStep=1)},(0,a.v_)(e.$t("ui.setup.start")),1)]))])),_:1})}s(4114);var $=s(707),C=s(6278),E=s(728),X=s(3751),F=s.p+"img/document-root.0e6dd2e4.svg",j=s.p+"img/button-update.ad79c617.svg";const A={class:"setup__header"},V={class:"setup__headline"},U={key:0,class:"setup__warning"},x={class:"setup__description"},D={class:"setup__description"},S=["href"],P={class:"setup__form setup__form--center",key:"updated"},W={class:"setup__fields"},T={class:"setup__fielddesc"},I={class:"setup__directories"},q={key:0},R={key:1},M={key:2},B={key:3},O={key:4},H={key:5},Q={key:6},K={class:"setup__actions setup__actions--center"},J={class:"setup__form",key:"conflicts"},N={class:"setup__fields"},z={class:"setup__fieldtitle"},Z={class:"setup__fielddesc"},Y={key:0},G={class:"setup__actions setup__actions--center"},ee=["disabled"],te={class:"setup__form",key:"setup"},se={class:"setup__fields"},ie={class:"setup__fieldtitle"},ae={class:"setup__fielddesc"},oe={class:"setup__directories"},ne={key:0},re={key:1},le={key:2},ue={key:3},ce={key:4},de={key:5},pe={key:6},he={class:"setup__actions setup__actions--center"},me=["disabled"],_e={class:"setup__form",key:"confirmation"},ve={class:"setup__fields setup__fields--center"},ke={class:"setup__fielddesc"},be={class:"setup__actions setup__actions--center"};function ge(e,t,s,o,n,r){const l=(0,i.g2)("loading-button"),u=(0,i.g2)("check-box"),c=(0,i.g2)("text-field"),d=(0,i.g2)("radio-button"),p=(0,i.g2)("i18n-t");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",A,[t[10]||(t[10]=(0,i.Lk)("img",{src:F,width:"80",height:"80",alt:"",class:"setup__icon"},null,-1)),(0,i.Lk)("h1",V,(0,a.v_)(e.$t("ui.setup.document-root.headline")),1),r.needsFix?((0,i.uX)(),(0,i.CE)("p",U,(0,a.v_)(e.$t("ui.setup.document-root.warning")),1)):(0,i.Q3)("",!0),(0,i.Lk)("p",x,(0,a.v_)(e.$t("ui.setup.document-root.description1")),1),(0,i.Lk)("p",D,(0,a.v_)(e.$t("ui.setup.document-root.description2")),1),(0,i.Lk)("a",{class:"widget-button widget-button--inline widget-button--info widget-button--link",href:`https://to.contao.org/docs/webroot?lang=${e.$i18n.locale}`,target:"_blank"},(0,a.v_)(e.$t("ui.setup.document-root.documentation")),9,S)]),null!==e.projectDir?((0,i.uX)(),(0,i.Wv)(X.eB,{key:0,name:e.forceInstall?"none":"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[r.needsFix||e.wantsFix?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.directoryUpdated?((0,i.uX)(),(0,i.CE)("main",P,[(0,i.Lk)("div",W,[t[13]||(t[13]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",T,(0,a.v_)(e.$t("ui.setup.document-root.confirmation")),1),(0,i.Lk)("dl",I,[(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.currentRoot")),1),e.isWeb?((0,i.uX)(),(0,i.CE)("dd",q,(0,a.v_)(e.projectDir)+"/web",1)):e.isPublic?((0,i.uX)(),(0,i.CE)("dd",R,(0,a.v_)(e.projectDir)+"/public",1)):((0,i.uX)(),(0,i.CE)("dd",M,(0,a.v_)(e.projectDir),1)),(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.newRoot")),1),!e.isEmpty||e.wantsFix&&e.directory||!r.canUsePublicDir||!e.usePublicDir?!e.isEmpty||e.wantsFix&&e.directory?r.canUsePublicDir&&e.usePublicDir?((0,i.uX)(),(0,i.CE)("dd",H,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,"/"+(0,a.v_)(e.directory)+"/public",1)])):((0,i.uX)(),(0,i.CE)("dd",Q,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,"/"+(0,a.v_)(e.directory)+"/web",1)])):((0,i.uX)(),(0,i.CE)("dd",O,[(0,i.eW)((0,a.v_)(e.projectDir),1),t[12]||(t[12]=(0,i.Lk)("span",null,"/web",-1))])):((0,i.uX)(),(0,i.CE)("dd",B,[(0,i.eW)((0,a.v_)(e.projectDir),1),t[11]||(t[11]=(0,i.Lk)("span",null,"/public",-1))]))])]),(0,i.Lk)("div",K,[(0,i.bF)(l,{inline:"",loading:e.processing,color:"primary",icon:"update",onClick:r.reload},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.reload")),1)])),_:1},8,["loading","onClick"])])])):e.conflicts.length?((0,i.uX)(),(0,i.CE)("main",J,[(0,i.Lk)("div",N,[(0,i.Lk)("h2",z,(0,a.v_)(e.$t("ui.setup.document-root.conflictsTitle")),1),(0,i.Lk)("p",Z,(0,a.v_)(e.$t("ui.setup.document-root.conflictsDirectory",{count:e.conflicts.length})),1),(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.conflicts.slice(0,5),(e=>((0,i.uX)(),(0,i.CE)("li",{key:e},(0,a.v_)(e),1)))),128)),e.conflicts.length>5?((0,i.uX)(),(0,i.CE)("li",Y,"...")):(0,i.Q3)("",!0)]),e.isPublic||e.isWeb?((0,i.uX)(),(0,i.Wv)(u,{key:0,name:"ignoreConflicts",label:e.$t("ui.setup.document-root.ignoreConflicts"),disabled:e.processing,modelValue:e.forceInstall,"onUpdate:modelValue":t[0]||(t[0]=t=>e.forceInstall=t)},null,8,["label","disabled","modelValue"])):(0,i.Q3)("",!0)]),(0,i.Lk)("div",G,[e.forceInstall?((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button widget-button--alert widget-button--run",onClick:t[1]||(t[1]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.server.contao.setup")),1)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.bF)(l,{inline:"",icon:"update",loading:e.processing,onClick:t[2]||(t[2]=e=>r.init(!1))},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.check")),1)])),_:1},8,["loading"]),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary widget-button--gear",disabled:e.processing,onClick:t[3]||(t[3]=t=>e.conflicts=[])},(0,a.v_)(e.$t("ui.setup.document-root.create")),9,ee)],64))])])):((0,i.uX)(),(0,i.CE)("main",te,[t[14]||(t[14]=(0,i.Lk)("img",{src:j,class:"invisible",alt:""},null,-1)),(0,i.Lk)("div",se,[(0,i.Lk)("h2",ie,(0,a.v_)(e.$t("ui.setup.document-root.formTitle")),1),(0,i.Lk)("p",ae,[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.formText1"))+" ",1),(0,i.Lk)("u",null,(0,a.v_)(e.$t("ui.setup.document-root.formText2")),1)]),!e.isEmpty||e.wantsFix?((0,i.uX)(),(0,i.Wv)(c,{key:0,ref:"directory",name:"directory",label:e.$t("ui.setup.document-root.directory"),error:r.directoryError,required:!e.isEmpty,pattern:"^[^/]+$",validate:"",modelValue:e.directory,"onUpdate:modelValue":t[4]||(t[4]=t=>e.directory=t)},null,8,["label","error","required","modelValue"])):(0,i.Q3)("",!0),r.canUsePublicDir?((0,i.uX)(),(0,i.Wv)(d,{key:1,name:"usePublicDir",options:r.publicDirOptions,"allow-html":"",modelValue:e.usePublicDir,"onUpdate:modelValue":t[5]||(t[5]=t=>e.usePublicDir=t)},null,8,["options","modelValue"])):(0,i.Q3)("",!0),(0,i.Lk)("dl",oe,[(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.currentRoot")),1),e.isWeb?((0,i.uX)(),(0,i.CE)("dd",ne,(0,a.v_)(e.projectDir)+(0,a.v_)(e.directorySeparator)+"web",1)):e.isPublic?((0,i.uX)(),(0,i.CE)("dd",re,(0,a.v_)(e.projectDir)+(0,a.v_)(e.directorySeparator)+"public",1)):((0,i.uX)(),(0,i.CE)("dd",le,(0,a.v_)(e.projectDir),1)),(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.newRoot")),1),!e.isEmpty||e.wantsFix&&e.directory||!r.canUsePublicDir||!e.usePublicDir?!e.isEmpty||e.wantsFix&&e.directory?r.canUsePublicDir&&e.usePublicDir?((0,i.uX)(),(0,i.CE)("dd",de,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+(0,a.v_)(e.directory)+(0,a.v_)(e.directorySeparator)+"public",1)])):((0,i.uX)(),(0,i.CE)("dd",pe,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+(0,a.v_)(e.directory)+(0,a.v_)(e.directorySeparator)+"web",1)])):((0,i.uX)(),(0,i.CE)("dd",ce,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+"web",1)])):((0,i.uX)(),(0,i.CE)("dd",ue,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+"public",1)]))]),(0,i.bF)(u,{name:"autoconfig",label:e.$t("ui.setup.document-root.autoconfig"),disabled:e.processing,modelValue:e.autoconfig,"onUpdate:modelValue":t[6]||(t[6]=t=>e.autoconfig=t)},null,8,["label","disabled","modelValue"])]),(0,i.Lk)("div",he,[(0,i.bF)(l,{color:"primary",icon:"run",loading:e.processing,disabled:!e.autoconfig||!!r.directoryError||e.wantsFix&&!e.directory&&(e.isPublic&&e.usePublicDir||e.isWeb&&!e.usePublicDir),onClick:r.setupDocroot},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.finish")),1)])),_:1},8,["loading","disabled","onClick"]),e.wantsFix?((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button",disabled:e.processing,onClick:t[7]||(t[7]=function(){return r.init&&r.init(...arguments)})},(0,a.v_)(e.$t("ui.setup.cancel")),9,me)):(0,i.Q3)("",!0)])]))],64)):((0,i.uX)(),(0,i.CE)("main",_e,[(0,i.Lk)("div",ve,[t[15]||(t[15]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",ke,(0,a.v_)(e.$t("ui.setup.document-root.success")),1),(0,i.bF)(p,{tag:"p",class:"setup__fielddesc",keypath:`ui.setup.document-root.${e.contaoVersion?"installed":"installing"}ProjectDir`},{dir:(0,i.k6)((()=>[(0,i.Lk)("code",null,(0,a.v_)(e.projectDir),1)])),_:1},8,["keypath"]),(0,i.bF)(p,{tag:"p",class:"setup__fielddesc",keypath:`ui.setup.document-root.${e.contaoVersion?"installed":"installing"}PublicDir`},{dir:(0,i.k6)((()=>[(0,i.Lk)("code",null,(0,a.v_)(r.publicDir),1)])),_:1},8,["keypath"])]),(0,i.Lk)("div",be,[e.contaoVersion?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button widget-button--inline widget-button--gear",onClick:t[8]||(t[8]=t=>e.wantsFix=!0)},(0,a.v_)(e.$t("ui.setup.document-root.change")),1)),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary",onClick:t[9]||(t[9]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])]))])),_:1},8,["name"])):(0,i.Q3)("",!0)])}var fe=s(9757);const ye={key:0},we=["id","name","disabled","required","checked","onClick"],Le=["for","innerHTML"],$e=["for"];function Ce(e,t,s,o,n,r){return(0,i.uX)(),(0,i.CE)("fieldset",{class:(0,a.C4)(["widget widget-radio-button",{"widget--required":s.required}])},[s.label||e.$slots.label?((0,i.uX)(),(0,i.CE)("legend",ye,[(0,i.RG)(e.$slots,"label",{},(()=>[(0,i.eW)((0,a.v_)(s.label),1)]))])):(0,i.Q3)("",!0),((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(s.options,((e,t)=>((0,i.uX)(),(0,i.CE)("div",{key:t},[(0,i.Lk)("input",{ref_for:!0,ref:"input",type:"radio",id:`ctrl_${s.name}_${e.value}`,name:s.name,disabled:e.disabled,required:s.required,checked:s.modelValue===e.value,onClick:t=>r.input(e.value)},null,8,we),s.allowHtml?((0,i.uX)(),(0,i.CE)("label",{key:0,for:`ctrl_${s.name}_${e.value}`,innerHTML:e.label},null,8,Le)):((0,i.uX)(),(0,i.CE)("label",{key:1,for:`ctrl_${s.name}_${e.value}`},(0,a.v_)(e.label),9,$e))])))),128))],2)}var Ee={emits:["input","update:modelValue"],props:{name:{type:String,required:!0},options:{type:Array,required:!0},label:String,modelValue:{required:!0},disabled:Boolean,required:Boolean,allowHtml:{type:Boolean,default:!1}},methods:{input(e){this.$emit("input"),this.$emit("update:modelValue",e)}}},Xe=s(6262);const Fe=(0,Xe.A)(Ee,[["render",Ce]]);var je=Fe,Ae=s(3480),Ve=s(85),Ue={components:{TextField:fe.A,RadioButton:je,CheckBox:Ae.A,LoadingButton:Ve.A},data:()=>({processing:!1,usePublicDir:!1,wantsFix:!1,conflicts:[],isEmpty:!0,isWeb:!0,isPublic:!1,projectDir:null,autoconfig:!1,forceInstall:!1,directory:"",directoryExists:!1,directoryUpdated:!1,directorySeparator:"/"}),computed:{...(0,C.aH)("server/php-web",["phpVersionId"]),...(0,C.aH)("server/contao",["contaoVersion"]),needsFix:e=>!e.isEmpty||!e.isWeb&&(!e.isPublic||!e.canUsePublicDir),publicDirOptions:e=>[{label:e.$t("ui.setup.document-root.publicDir",{dir:"<code>web</code>",version:"4.9+"}),value:!1},{label:e.$t("ui.setup.document-root.publicDir",{dir:"<code>public</code>",version:"4.13+"}),value:!0}],canUsePublicDir:e=>e.phpVersionId>=70400,publicDir:e=>e.isWeb?`${e.projectDir}${e.directorySeparator}web`:`${e.projectDir}${e.directorySeparator}public`,directoryError(){return this.directoryExists?this.$t("ui.setup.document-root.directoryExists"):this.directory&&!this.directory.match(/^[^/]+$/)?this.$t("ui.setup.document-root.directoryInvalid"):this.wantsFix||this.isEmpty||this.directory?"":this.$t("ui.setup.document-root.directoryInvalid")}},methods:{reload(){this.processing=!0,window.location.reload()},async setupDocroot(){this.processing=!0;const e=await this.$store.dispatch("server/contao/documentRoot",{directory:!this.isEmpty||this.wantsFix?this.directory:null,usePublicDir:this.canUsePublicDir&&this.usePublicDir});if(403===e.status)return this.directoryExists=!0,this.processing=!1,void this.$refs.directory.focus();this.processing=!1,this.directoryUpdated=!0,this.$store.commit("auth/resetCountdown")},async init(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.processing=!0;const t=await this.$store.dispatch("server/contao/get",e);this.projectDir=t.data.project_dir,this.conflicts=t.data.conflicts,this.isEmpty=0===t.data.conflicts.length,this.isWeb="web"===t.data.public_dir,this.isPublic="public"===t.data.public_dir,this.usePublicDir="public"===t.data.public_dir,this.wantsFix=!1,this.directory=this.isEmpty?"":location.hostname,this.directorySeparator=t.data.directory_separator,this.processing=!1}},watch:{directory(){this.directoryExists=!1}},async mounted(){this.init()}};const xe=(0,Xe.A)(Ue,[["render",ge]]);var De=xe,Se=(s(8111),s(1701),s.p+"img/create-project.b22522ee.svg"),Pe=s(7591);const We={class:"setup__header"},Te=["src","alt"],Ie={key:1,src:Se,width:"80",height:"80",alt:"",class:"setup__icon"},qe={class:"setup__headline"},Re={class:"setup__description"},Me={class:"setup__version"},Be={class:"setup__version"},Oe={key:2,class:"setup__version"},He={key:3,class:"setup__version"},Qe={key:4,class:"setup__version"},Ke=["href"],Je={class:"setup__form"},Ne={key:0,class:"setup__fields"},ze={class:"setup__fieldtitle"},Ze={class:"setup__fielddesc"},Ye={class:"setup__tabs"},Ge={class:"setup__tab-controls"},et={key:0,class:"setup__tab"},tt={class:"setup__requires"},st={key:1,class:"setup__tab setup__tab--files"},it={class:"setup__fielddesc setup__fielddesc--warning"},at={class:"setup__actions"},ot=["disabled"],nt={class:"setup__header"},rt={class:"setup__headline"},lt={href:"https://semver.org",target:"_blank",rel:"noreferrer noopener"},ut={class:"setup__versions"},ct={class:"setup__version--warning"},dt=["href"],pt={key:0,class:"setup__form"},ht={class:"setup__fields setup__fields--center"},mt={class:"setup__fielddesc"},_t={class:"setup__actions setup__actions--center"},vt={key:1,class:"setup__form"},kt={class:"setup__fields"},bt={class:"setup__fieldtitle"},gt={class:"setup__fielddesc setup__fielddesc--version"},ft={key:0,class:"setup__theme"},yt={href:"https://themes.contao.org",target:"_blank"},wt={class:"package-uploads__overlay"},Lt={href:"https://themes.contao.org",target:"_blank"},$t={class:"setup__fields"},Ct={class:"setup__or"},Et=["disabled"],Xt=["disabled"],Ft={key:2,class:"setup__themes"},jt={key:1,class:"setup__theme-search setup__theme-search--offline"},At={key:2,class:"setup__theme-search setup__theme-search--empty"},Vt={class:"setup__themes-results"},Ut={class:"setup__themes-more"};function xt(e,t,s,o,n,r){const l=(0,i.g2)("file-upload"),u=(0,i.g2)("file-tree"),c=(0,i.g2)("loading-button"),d=(0,i.g2)("i18n-t"),p=(0,i.g2)("radio-button"),h=(0,i.g2)("check-box"),m=(0,i.g2)("search-input"),_=(0,i.g2)("button-group"),v=(0,i.g2)("loading-spinner"),k=(0,i.g2)("discover-package");return(0,i.uX)(),(0,i.CE)("div",null,[(0,i.bF)(l,{name:"package",ref:"uploader","post-action":"api/packages/uploads",multiple:!0,drop:!0,"drop-directory":!1,"chunk-enabled":!0,chunk:{action:"api/packages/uploads"},onInputFile:r.uploadTheme,onInputFilter:r.filterTheme},null,8,["onInputFile","onInputFilter"]),e.theme?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.Lk)("header",We,[e.themeImage?((0,i.uX)(),(0,i.CE)("img",{key:0,class:"setup__theme-image",src:e.themeImage,alt:e.theme.composerJson.name},null,8,Te)):((0,i.uX)(),(0,i.CE)("img",Ie)),(0,i.Lk)("h1",qe,(0,a.v_)(e.$t("ui.setup.create-project.headline")),1),(0,i.Lk)("p",Re,(0,a.v_)(e.$t("ui.setup.create-project.theme.uploaded")),1),(0,i.Lk)("div",Me,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.packageName"))+":",1),(0,i.eW)(" "+(0,a.v_)(e.theme.composerJson.name),1)]),(0,i.Lk)("div",Be,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.version"))+":",1),(0,i.eW)(" "+(0,a.v_)(e.theme.composerJson.version),1)]),e.theme.composerJson.authors||e.theme.authors?((0,i.uX)(),(0,i.CE)("div",Oe,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.authors"))+":",1),e.theme.composerJson.authors?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.eW)((0,a.v_)(e.theme.composerJson.authors.map((e=>e.name)).join(", ")),1)],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.eW)((0,a.v_)(e.theme.authors),1)],64))])):(0,i.Q3)("",!0),e.theme.composerJson.license?((0,i.uX)(),(0,i.CE)("div",He,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.package-details.license"))+":",1),(0,i.eW)(" "+(0,a.v_)(Array.isArray(e.theme.composerJson.license)?e.theme.composerJson.license.join(", "):e.theme.composerJson.license),1)])):(0,i.Q3)("",!0),e.theme.composerJson.homepage?((0,i.uX)(),(0,i.CE)("div",Qe,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.package.homepage"))+": ",1),(0,i.Lk)("a",{href:e.theme.composerJson.homepage,target:"_blank"},(0,a.v_)(e.theme.composerJson.homepage),9,Ke)])):(0,i.Q3)("",!0),(0,i.Lk)("button",{class:"widget-button widget-button--info widget-button--details",onClick:t[0]||(t[0]=function(){return r.themeDetails&&r.themeDetails(...arguments)})},(0,a.v_)(e.$t("ui.package.detailsButton")),1)]),(0,i.Lk)("main",Je,[e.theme.files?((0,i.uX)(),(0,i.CE)("div",Ne,[(0,i.Lk)("h2",ze,(0,a.v_)(e.$t("ui.setup.create-project.themeTitle")),1),(0,i.Lk)("p",Ze,(0,a.v_)(e.$t("ui.setup.create-project.themeDetails")),1),(0,i.Lk)("div",Ye,[(0,i.Lk)("div",Ge,[(0,i.Lk)("button",{class:(0,a.C4)(["setup__tab-control",{"setup__tab-control--active":"require"===e.view}]),onClick:t[1]||(t[1]=t=>e.view="require")},(0,a.v_)(e.$tc("ui.setup.create-project.themeRequire",Object.keys(e.theme.composerJson.require).length)),3),(0,i.Lk)("button",{class:(0,a.C4)(["setup__tab-control",{"setup__tab-control--active":"files"===e.view}]),onClick:t[2]||(t[2]=t=>e.view="files")},(0,a.v_)(e.$tc("ui.setup.create-project.themeFiles",e.theme.files.length)),3)]),"require"===e.view?((0,i.uX)(),(0,i.CE)("div",et,[(0,i.Lk)("table",tt,[(0,i.Lk)("tbody",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.theme.composerJson.require,((e,t)=>((0,i.uX)(),(0,i.CE)("tr",{key:t},[(0,i.Lk)("td",null,(0,a.v_)(t)+":",1),(0,i.Lk)("td",null,(0,a.v_)(e),1)])))),128))])])])):(0,i.Q3)("",!0),"files"===e.view?((0,i.uX)(),(0,i.CE)("div",st,[(0,i.bF)(u,{files:r.themeFiles},null,8,["files"])])):(0,i.Q3)("",!0)]),(0,i.Lk)("p",it,(0,a.v_)(e.$t("ui.setup.create-project.themeWarning")),1)])):(0,i.Q3)("",!0),(0,i.Lk)("div",at,[(0,i.bF)(c,{color:"primary",icon:"run",loading:e.processing,onClick:r.installTheme},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.install")),1)])),_:1},8,["loading","onClick"]),(0,i.Lk)("button",{class:"widget-button",onClick:t[3]||(t[3]=function(){return r.cancelTheme&&r.cancelTheme(...arguments)}),disabled:e.processing},(0,a.v_)(e.$t("ui.setup.create-project.cancel")),9,ot)])])],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.Lk)("header",nt,[t[14]||(t[14]=(0,i.Lk)("img",{src:Se,width:"80",height:"80",alt:"",class:"setup__icon"},null,-1)),(0,i.Lk)("h1",rt,(0,a.v_)(e.$t("ui.setup.create-project.headline")),1),(0,i.bF)(d,{tag:"p",keypath:"ui.setup.create-project.description",class:"setup__description"},{semver:(0,i.k6)((()=>[(0,i.Lk)("a",lt,(0,a.v_)(e.$t("ui.setup.create-project.semver")),1)])),_:1}),(0,i.Lk)("ul",ut,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(r.versions,(e=>((0,i.uX)(),(0,i.CE)(i.FK,null,[e.description?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.disabled?((0,i.uX)(),(0,i.CE)("li",{class:"setup__version",key:e.value},[(0,i.Lk)("strong",null,(0,a.v_)(e.label),1),t[13]||(t[13]=(0,i.Lk)("br",null,null,-1)),(0,i.Lk)("span",ct,(0,a.v_)(e.problem),1)])):((0,i.uX)(),(0,i.CE)("li",{class:"setup__version",key:e.value},[(0,i.Lk)("strong",null,(0,a.v_)(e.label),1),t[12]||(t[12]=(0,i.Lk)("br",null,null,-1)),(0,i.eW)(" "+(0,a.v_)(e.description),1)]))],64)):(0,i.Q3)("",!0)],64)))),256))]),(0,i.bF)(d,{tag:"p",keypath:"ui.setup.create-project.releaseplan",class:"setup__releaseplan"},{contaoReleasePlan:(0,i.k6)((()=>[(0,i.Lk)("a",{href:`https://to.contao.org/release-plan?lang=${e.$i18n.locale}`,target:"_blank",rel:"noreferrer noopener"},(0,a.v_)(e.$t("ui.setup.create-project.releaseplanLink")),9,dt)])),_:1})]),e.contaoVersion?((0,i.uX)(),(0,i.CE)("main",pt,[(0,i.Lk)("div",ht,[t[15]||(t[15]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",mt,(0,a.v_)(e.$t("ui.setup.create-project.installed",{version:e.contaoVersion})),1)]),(0,i.Lk)("div",_t,[(0,i.Lk)("button",{class:"widget-button widget-button--inline",onClick:t[4]||(t[4]=function(){return r.launch&&r.launch(...arguments)})},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary",onClick:t[5]||(t[5]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("main",vt,[(0,i.Lk)("div",kt,[(0,i.Lk)("h2",bt,(0,a.v_)(e.$t("ui.setup.create-project.formTitle")),1),(0,i.Lk)("p",gt,(0,a.v_)(e.$t("ui.setup.create-project.formText")),1),(0,i.bF)(p,{name:"version",options:r.versions,disabled:e.processing,modelValue:e.version,"onUpdate:modelValue":t[6]||(t[6]=t=>e.version=t)},null,8,["options","disabled","modelValue"]),"theme"===e.version?((0,i.uX)(),(0,i.CE)("div",ft,[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.setup.create-project.themeInstall")),1),(0,i.bF)(d,{keypath:"ui.setup.create-project.themeBuy",tag:"p"},{store:(0,i.k6)((()=>[(0,i.Lk)("a",yt,(0,a.v_)(e.$t("ui.setup.create-project.themeStore")),1)])),_:1}),(0,i.bo)((0,i.Lk)("div",wt,[(0,i.Lk)("div",null,[t[16]||(t[16]=(0,i.Lk)("img",{src:Pe,alt:"",width:"128",height:"128"},null,-1)),(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.packages.uploadOverlay")),1)])],512),[[X.aG,e.$refs.uploader&&e.$refs.uploader.dropActive]])])):((0,i.uX)(),(0,i.Wv)(h,{key:1,name:"demo",label:e.$t("ui.setup.create-project.demo"),disabled:e.processing,modelValue:e.demo,"onUpdate:modelValue":t[7]||(t[7]=t=>e.demo=t)},{description:(0,i.k6)((()=>[(0,i.bF)(d,{tag:"p",keypath:"ui.setup.create-project.demoDescription"},{store:(0,i.k6)((()=>[(0,i.Lk)("a",Lt,(0,a.v_)(e.$t("ui.setup.create-project.themeStore")),1)])),_:1})])),_:1},8,["label","disabled","modelValue"]))]),(0,i.Lk)("div",$t,["theme"===e.version?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.bF)(c,{color:"primary",icon:"upload",loading:e.processing,onClick:r.openFileSelector},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.themeUpload")),1)])),_:1},8,["loading","onClick"]),(0,i.Lk)("div",Ct,[(0,i.Lk)("span",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.or")),1)]),(0,i.bF)(m,{placeholder:e.$t("ui.setup.create-project.theme.search"),disabled:e.processing},null,8,["placeholder","disabled"])],64)):((0,i.uX)(),(0,i.Wv)(_,{key:1,color:"primary",icon:"run",disabled:!e.version,loading:e.processing,onClick:t[10]||(t[10]=()=>r.install()),label:e.$t("ui.setup.create-project.install")},{default:(0,i.k6)((()=>[e.demo?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button",disabled:!e.version||e.processing,onClick:t[8]||(t[8]=function(){return r.installCoreOnly&&r.installCoreOnly(...arguments)})},(0,a.v_)(e.$t("ui.setup.create-project.coreOnly")),9,Et)),(0,i.Lk)("button",{class:"widget-button",disabled:!e.version||e.processing,onClick:t[9]||(t[9]=function(){return r.installNoUpdate&&r.installNoUpdate(...arguments)})},(0,a.v_)(e.$t("ui.setup.create-project.noUpdate")),9,Xt)])),_:1},8,["disabled","loading","label"]))])])),t[17]||(t[17]=(0,i.Lk)("div",{class:"clearfix"},null,-1)),e.searching||e.results||e.offline?((0,i.uX)(),(0,i.CE)("div",Ft,[e.searching&&!e.results?((0,i.uX)(),(0,i.Wv)(v,{key:0,class:"setup__theme-search setup__theme-search--loader"},{default:(0,i.k6)((()=>[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.loading")),1)])),_:1})):e.offline?((0,i.uX)(),(0,i.CE)("div",jt,[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.offline")),1),(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.offlineExplain")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--update",onClick:t[11]||(t[11]=function(){return r.searchThemes&&r.searchThemes(...arguments)})},(0,a.v_)(e.$t("ui.discover.offlineButton")),1)])):e.isSearching&&e.results&&!Object.keys(e.results).length?((0,i.uX)(),(0,i.CE)("div",At,[(0,i.bF)(d,{tag:"p",keypath:"ui.setup.create-project.theme.empty"},{query:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.query),1)])),_:1})])):e.isSearching&&e.results?((0,i.uX)(),(0,i.CE)(i.FK,{key:3},[(0,i.Lk)("div",Vt,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.results,(e=>((0,i.uX)(),(0,i.Wv)(k,{class:"setup__themes-item",data:e,key:e.name},null,8,["data"])))),128))]),(0,i.Lk)("div",Ut,[e.hasMore?((0,i.uX)(),(0,i.Wv)(c,{key:0,inline:"",icon:"search",loading:e.searching,onClick:e.loadMore},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.theme.more")),1)])),_:1},8,["loading","onClick"])):(0,i.Q3)("",!0)])],64)):(0,i.Q3)("",!0)])):(0,i.Q3)("",!0)],64))])}s(2489),s(116),s(7588),s(4603),s(7566),s(8721);var Dt=s(4686),St=s.n(Dt),Pt=s(1881),Wt=s(8568),Tt=s.n(Wt);const It=["href"],qt=["href"],Rt={key:3};function Mt(e,t,s,o,n,r){const l=(0,i.g2)("package-constraint"),u=(0,i.g2)("package-details");return(0,i.uX)(),(0,i.Wv)(u,null,{"package-actions":(0,i.k6)((()=>[!e.isTheme||r.data.uploaded||r.isPrivate?r.data.homepage||e.metadata.homepage?((0,i.uX)(),(0,i.CE)("a",{key:1,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:r.data.homepage||e.metadata.homepage},(0,a.v_)(e.$t("ui.package.homepage")),9,It)):r.isPrivate?((0,i.uX)(),(0,i.CE)("div",Rt)):((0,i.uX)(),(0,i.CE)("a",{key:2,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:`https://packagist.org/packages/${r.data.name}`},(0,a.v_)(e.$t("ui.package-details.packagist")),9,qt)):((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.Lk)("button",{class:"widget-button widget-button--primary widget-button--run",onClick:t[0]||(t[0]=function(){return r.install&&r.install(...arguments)})},(0,a.v_)(e.$t("ui.setup.create-project.install")),1),(0,i.bF)(l,{class:"theme-details__constraint",emit:!0,data:r.data,modelValue:e.version,"onUpdate:modelValue":t[1]||(t[1]=t=>e.version=t)},null,8,["data","modelValue"])],64))])),_:1})}var Bt=s(6904),Ot=s(939),Ht=s(416),Qt=s(8200),Kt={mixins:[Ht.A,Qt.A],components:{PackageConstraint:Ot.A,PackageDetails:Bt["default"]},data:()=>({version:""}),computed:{...(0,C.aH)("packages",{allInstalled:"installed"}),current:e=>e.$route.query.p,data:e=>e.allInstalled&&e.allInstalled[e.current]||{name:e.current},isPrivate:e=>e.metadata&&!!e.metadata.private},methods:{install(){this.$store.commit("contao/installTheme",{package:this.data.name,version:this.version})}}};const Jt=(0,Xe.A)(Kt,[["render",Mt]]);var Nt=Jt,zt=s(791),Zt=s(9045),Yt=s(6435);const Gt={class:"file-tree"},es=["onClick"],ts={key:1,class:"file-tree__file"};function ss(e,t,s,o,n,r){const l=(0,i.g2)("file-tree",!0);return(0,i.uX)(),(0,i.CE)("ul",Gt,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(s.files,((e,t)=>((0,i.uX)(),(0,i.CE)(i.FK,{key:t},[e.children.length?((0,i.uX)(),(0,i.CE)("li",{key:0,class:(0,a.C4)("file-tree__folder"+(r.isOpen(e)?" file-tree__folder--open":""))},[(0,i.Lk)("button",{onClick:t=>r.toggle(e)},(0,a.v_)(r.name(e)),9,es),r.isOpen(e)?((0,i.uX)(),(0,i.Wv)(l,{key:0,files:e.children},null,8,["files"])):(0,i.Q3)("",!0)],2)):((0,i.uX)(),(0,i.CE)("li",ts,[(0,i.Lk)("span",null,(0,a.v_)(r.name(e)),1)]))],64)))),128))])}var is={name:"FileTree",props:{files:{type:Array,required:!0}},data:()=>({open:[]}),computed:{name:()=>e=>e.name?e.name:e.path.substring(e.path.lastIndexOf("/")+1),isOpen:e=>t=>e.open.includes(t)},methods:{toggle(e){this.open.includes(e)?this.open=this.open.filter((t=>t!==e)):this.open.push(e)}}};const as=(0,Xe.A)(is,[["render",ss]]);var os=as,ns=s(4676),rs={mixins:[Pt.A],components:{ButtonGroup:ns.A,FileTree:os,DiscoverPackage:Yt.A,LoadingSpinner:Zt.A,SearchInput:zt.A,FileUpload:Tt(),RadioButton:je,CheckBox:Ae.A,LoadingButton:Ve.A},data:()=>({processing:!1,isWeb:!0,version:"5.5",demo:!1,view:"require",theme:null,themeImage:null,searching:!1,results:null,hasMore:!1,offline:!1}),computed:{...(0,C.aH)("tasks",{taskStatus:"status"}),...(0,C.aH)("server/php-web",["phpVersionId","phpVersion"]),...(0,C.aH)("server/contao",["contaoVersion"]),...(0,C.aH)("contao",{themeName:"package",themeVersion:"version"}),themeFiles:e=>St()(e.theme.files,{directoriesFirst:!0}).children,versions(){const e=[];return e.push({value:"5.5",label:`Contao 5.5 (${this.$t("ui.setup.create-project.latestTitle")})`,disabled:this.phpVersionId<80200,description:this.$t("ui.setup.create-project.latestQ3",{year:"2025"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"8.2.0",current:this.phpVersion})}),e.push({value:"5.3",label:`Contao 5.3 (${this.$t("ui.setup.create-project.ltsTitle")})`,disabled:this.phpVersionId<80100,description:this.$t("ui.setup.create-project.ltsText",{year:"2027"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"8.1.0",current:this.phpVersion})}),e.push({value:"4.13",label:`Contao 4.13 (${this.$t("ui.setup.create-project.ltsTitle")})`,disabled:this.phpVersionId<70400,description:this.$t("ui.setup.create-project.pltsText",{year:"2025"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"7.4.0",current:this.phpVersion})}),e.push({value:"theme",label:this.$t("ui.setup.create-project.theme")}),e}},watch:{version(){this.stopSearch(),this.searching=!1,this.results=null,this.hasMore=!1},sorting(){this.searchThemes()},query(){this.results=null,this.query?this.searchThemes():(this.searching=!1,this.hasMore=!1)},pages(){this.searchThemes()},themeName(){this.closePopup(),this.install({package:this.themeName,version:this.themeVersion})}},methods:{...(0,C.PY)("packages/details",{closePopup:"clearCurrent"}),async searchThemes(){this.searching=!0,this.offline=!1;try{const e={facetFilters:["type:contao-theme"],hitsPerPage:10*this.pages};this.query?e.query=this.query:this.sorting&&(e.sorting=this.sorting);const t=await this.$store.dispatch("algolia/findPackages",e);if(this.hasMore=t.nbPages>1,0===t.nbHits)return void(this.results={});const s={};t.hits.forEach((e=>{s[e.name]=e})),this.results=s}catch(e){this.offline=!0}this.searching=!1},async install(e){let t,s=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;this.processing=!0,t=e||(this.theme?{upload:this.theme.upload.id}:this.demo?{package:"contao/contao-demo",version:this.version,"no-update":"no-update"===s?"1":"0"}:{version:this.version,"core-only":"core-only"===s?"1":"0","no-update":"no-update"===s?"1":"0"}),await this.$store.dispatch("contao/install",t),"complete"===this.taskStatus&&(this.$store.commit("tasks/setDeleting",!0),"no-update"===s?(this.$store.commit("setSafeMode",!0),this.$store.commit("setView",$.A.READY)):(this.isWeb="web"===(await this.$store.dispatch("server/contao/get",!1)).data.public_dir,await Promise.all([this.$store.dispatch("contao/install-tool/fetch",!1),this.$store.dispatch("server/database/get",!1),this.$store.dispatch("contao/backup/fetch",!1)]),this.$store.commit("contao/backup/setRestore",!0),this.$store.commit("setup",3)),this.$store.dispatch("tasks/deleteCurrent"))},installNoUpdate(){this.install(null,"no-update")},installCoreOnly(){this.install(null,"core-only")},launch(){this.$store.commit("setView",$.A.READY)},openFileSelector(){this.$refs.uploader&&this.$refs.uploader.$el.querySelector("input").click()},async filterTheme(e,t,s){if(e&&!t&&!/(\.cto|\.zip)$/i.test(e.name))return console&&console.debug(`${e.name} is not a .zip or .cto`),alert(this.$t("ui.setup.create-project.themeInvalid")),s()},async uploadTheme(e,t){if(e){if(this.processing=!0,this.$refs.uploader.uploaded&&e&&t&&!e.active&&t.active)return this.theme.upload=e.response.data,void(e.success&&this.install());e.url=URL.createObjectURL(e.file);try{const t=new File([e.file],e.name,{type:e.type}),a=(await s.e(710).then(s.t.bind(s,1710,23))).default,o=await a.loadAsync(t),n=o.filter((e=>!["composer.json","theme.xml"].includes(e)&&!e.startsWith("__MACOSX/")&&!e.includes(".DS_Store")&&!e.endsWith("/"))).map((e=>e.name));let r=n[0].substring(0,n[0].indexOf("/")+1);n.find((e=>e.substr(0,r.length)!==r))&&(r="");const l=JSON.parse(await o.file(`${r}composer.json`).async("string")),u=await o.file(`${r}theme.xml`).async("string"),c=new DOMParser,d=c.parseFromString(u,"application/xml");if(this.theme={tstamp:d.querySelector('table[name="tl_theme"] field[name="tstamp"]')?.innerHTML,name:d.querySelector('table[name="tl_theme"] field[name="name"]')?.innerHTML,author:d.querySelector('table[name="tl_theme"] field[name="author"]')?.innerHTML,screenshot:d.querySelector('table[name="tl_theme"] field[name="screenshot"]')?.innerHTML,composerJson:l,files:n},this.theme.screenshot&&"NULL"!==this.theme.screenshot)try{const e=await o.file(`${r}${this.theme.screenshot}`);this.themeImage=e?URL.createObjectURL(await e.async("blob")):null}catch(i){}}catch(i){console&&console.debug(i),alert(this.$t("ui.setup.create-project.themeInvalid")),this.cancelTheme()}this.processing=!1}},cancelTheme(){this.theme=null,this.$refs.uploader.clear()},themeDetails(){this.$store.commit("packages/setInstalled",{local:{[this.theme.composerJson.name]:Object.assign({},this.theme.composerJson,{uploaded:!0})}}),this.$store.commit("packages/details/setCurrent",this.theme.composerJson.name)},installTheme(){this.$refs.uploader.active||(this.processing=!0,this.$refs.uploader.active=!0)}},async mounted(){await this.$router.isReady(),Object.keys(this.$route.query).length&&this.$router.replace({query:null}),await this.$store.dispatch("packages/details/init",{vue:this,component:Nt}),this.$store.commit("packages/setInstalled",{}),this.isWeb="web"===(await this.$store.dispatch("server/contao/get")).data.public_dir,this.version=this.versions.find((e=>!e.disabled)).value}};const ls=(0,Xe.A)(rs,[["render",xt]]);var us=ls,cs=s(9472);const ds={class:"setup__header"},ps={class:"setup__headline"},hs={class:"setup__form",key:"setup"},ms={class:"setup__fields"},_s={class:"setup__fieldtitle"},vs={class:"setup__fielddesc"},ks={key:0,class:"setup__warning"},bs={class:"setup__or"},gs={class:"setup__actions"},fs=["disabled"],ys={class:"setup__form",key:"confirmation"},ws={class:"setup__fields"},Ls={class:"setup__fieldtitle"},$s={key:"migrate"},Cs={class:"setup__fields"},Es={class:"setup__fieldtitle"},Xs={key:0,class:"setup__fielddesc setup__warning"},Fs={key:1,class:"setup__fielddesc"},js={class:"setup__actions setup__actions--center"},As={key:"restored"},Vs={class:"setup__fields"},Us={class:"setup__fieldtitle"},xs={class:"setup__fielddesc"},Ds={class:"setup__actions setup__actions--center"},Ss={key:"backup"},Ps={class:"setup__fields"},Ws={class:"setup__fieldtitle"},Ts={class:"setup__fielddesc"},Is={class:"setup__fielddesc setup__warning"},qs={class:"setup__actions"},Rs=["disabled"];function Ms(e,t,s,o,n,r){const l=(0,i.g2)("i18n-t"),u=(0,i.g2)("text-field"),c=(0,i.g2)("loading-button"),d=(0,i.g2)("radio-button");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",ds,[t[17]||(t[17]=(0,i.Lk)("img",{src:cs,width:"80",height:"80",class:"setup__icon",alt:""},null,-1)),(0,i.Lk)("h1",ps,(0,a.v_)(e.$t("ui.setup.database-connection.headline")),1),(0,i.bF)(l,{tag:"p",keypath:"ui.setup.database-connection.description",class:"setup__description"},{env:(0,i.k6)((()=>t[16]||(t[16]=[(0,i.Lk)("code",null,".env.local",-1)]))),_:1})]),e.currentState?((0,i.uX)(),(0,i.Wv)(X.eB,{key:0,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>["error"===e.currentState||"edit"===e.currentState?((0,i.uX)(),(0,i.CE)("main",hs,[(0,i.Lk)("form",{onSubmit:t[7]||(t[7]=(0,X.D$)((function(){return r.save&&r.save(...arguments)}),["prevent"]))},[(0,i.Lk)("div",ms,[(0,i.Lk)("h2",_s,(0,a.v_)(e.$t("ui.setup.database-connection.formTitle")),1),(0,i.Lk)("p",vs,(0,a.v_)(e.$t("ui.setup.database-connection.formText")),1),"edit"!==e.currentState&&""!==e.currentUrl?((0,i.uX)(),(0,i.CE)("p",ks,(0,a.v_)(e.$t("ui.setup.database-connection.error")),1)):(0,i.Q3)("",!0),(0,i.bF)(u,{ref:"url",name:"url",type:"url",label:e.$t("ui.setup.database-connection.url"),placeholder:"mysql://user:password@server:port/database",required:"",pattern:e.urlPattern,validate:"",disabled:e.processing,modelValue:e.url,"onUpdate:modelValue":t[0]||(t[0]=t=>e.url=t),onKeyup:t[1]||(t[1]=t=>e.validUrl=!0),onBlur:r.parseUrl,error:e.validUrl?void 0:e.$t("ui.setup.database-connection.validUrl")},null,8,["label","pattern","disabled","modelValue","onBlur","error"]),(0,i.Lk)("div",bs,[(0,i.Lk)("span",null,(0,a.v_)(e.$t("ui.setup.database-connection.or")),1)]),(0,i.bF)(u,{name:"user",label:e.$t("ui.setup.database-connection.user"),disabled:e.processing,modelValue:e.user,"onUpdate:modelValue":t[2]||(t[2]=t=>e.user=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"password",type:"password",label:e.$t("ui.setup.database-connection.password"),disabled:e.processing,modelValue:e.password,"onUpdate:modelValue":t[3]||(t[3]=t=>e.password=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"server",label:e.$t("ui.setup.database-connection.server"),disabled:e.processing,required:"",modelValue:e.server,"onUpdate:modelValue":t[4]||(t[4]=t=>e.server=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"database",label:e.$t("ui.setup.database-connection.database"),disabled:e.processing,required:"",modelValue:e.database,"onUpdate:modelValue":t[5]||(t[5]=t=>e.database=t)},null,8,["label","disabled","modelValue"])]),(0,i.Lk)("div",gs,[(0,i.bF)(c,{submit:"",color:"primary",icon:"save",loading:e.processing,disabled:!e.valid},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.database-connection.save")),1)])),_:1},8,["loading","disabled"]),"edit"===e.currentState?((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button",disabled:e.processing,onClick:t[6]||(t[6]=function(){return r.load&&r.load(...arguments)})},(0,a.v_)(e.$t("ui.setup.cancel")),9,fs)):(0,i.Q3)("",!0)])],32)])):((0,i.uX)(),(0,i.CE)("main",ys,[(0,i.Lk)("div",ws,[(0,i.Lk)("h2",Ls,(0,a.v_)(e.$t("ui.setup.database-connection.formTitle")),1),e.url?((0,i.uX)(),(0,i.Wv)(l,{key:0,tag:"p",keypath:"ui.setup.database-connection.connected",class:"setup__fielddesc"},{database:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.database),1)])),server:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.server),1)])),_:1})):(0,i.Q3)("",!0),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--edit widget-button--small",onClick:t[8]||(t[8]=t=>e.currentState="edit")},(0,a.v_)(e.$t("ui.setup.database-connection.change")),1)]),(0,i.bF)(X.eB,{name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[!e.hasDatabaseError&&e.backupRestore&&e.hasBackups?e.backupRestored?((0,i.uX)(),(0,i.CE)("div",As,[(0,i.Lk)("div",Vs,[(0,i.Lk)("h2",Us,(0,a.v_)(e.$t("ui.setup.database-connection.restoreTitle")),1),t[18]||(t[18]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",xs,(0,a.v_)(e.$t("ui.setup.database-connection.restored")),1)]),(0,i.Lk)("div",Ds,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--primary",onClick:t[12]||(t[12]=t=>e.$store.commit("contao/backup/setRestore",!1))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("div",Ss,[(0,i.Lk)("div",Ps,[(0,i.Lk)("h2",Ws,(0,a.v_)(e.$t("ui.setup.database-connection.restoreTitle")),1),(0,i.Lk)("p",Ts,(0,a.v_)(e.$tc("ui.setup.database-connection.restoreText",e.files.length)),1),e.files.length>1?((0,i.uX)(),(0,i.Wv)(d,{key:0,required:"","allow-html":"",options:r.fileOptions,name:"selection",modelValue:e.selection,"onUpdate:modelValue":t[13]||(t[13]=t=>e.selection=t)},null,8,["options","modelValue"])):(0,i.Q3)("",!0),(0,i.Lk)("p",Is,(0,a.v_)(e.$t("ui.setup.database-connection.backupWarning")),1)]),(0,i.Lk)("div",qs,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline",onClick:t[14]||(t[14]=t=>e.$store.commit("contao/backup/setRestore",!1))},(0,a.v_)(e.$t("ui.setup.database-connection.skip")),1),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",disabled:e.files.length>1&&!e.selection,onClick:t[15]||(t[15]=function(){return r.restore&&r.restore(...arguments)})},(0,a.v_)(e.$t("ui.setup.database-connection.restore")),9,Rs)])])):((0,i.uX)(),(0,i.CE)("div",$s,[(0,i.Lk)("div",Cs,[(0,i.Lk)("h2",Es,(0,a.v_)(e.$t("ui.setup.database-connection.schemaTitle")),1),e.status&&e.status.total>0?((0,i.uX)(),(0,i.CE)("p",Xs,(0,a.v_)(e.$tc(`ui.setup.database-connection.${e.currentState}`,e.status.total)),1)):((0,i.uX)(),(0,i.CE)("p",Fs,(0,a.v_)(e.$t("ui.setup.database-connection.noChanges")),1))]),(0,i.Lk)("div",js,[e.status&&e.status.total>0?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.hasDatabaseError?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button widget-button--inline",onClick:t[9]||(t[9]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.database-connection.skip")),1)),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",onClick:t[10]||(t[10]=function(){return r.checkMigrations&&r.checkMigrations(...arguments)})},(0,a.v_)(e.$t("ui.setup.database-connection.check")),1)],64)):((0,i.uX)(),(0,i.CE)("button",{key:1,type:"button",class:"widget-button widget-button--primary",onClick:t[11]||(t[11]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1))])]))])),_:1})]))])),_:1})):(0,i.Q3)("",!0)])}var Bs=s(4210),Os=s(4960),Hs={components:{RadioButton:je,TextField:fe.A,LoadingButton:Ve.A},data:()=>({processing:!1,validUrl:!0,valid:!1,validating:!1,currentState:null,url:"",user:"",password:"",server:"localhost",database:"",backup:!0,selection:null}),computed:{...(0,C.aH)("tasks",{taskStatus:"status"}),...(0,C.aH)("contao/backup",{backupRestored:"restored",backupRestore:"restore"}),...(0,C.aH)("server/database",{currentUrl:"url",urlPattern:"pattern",status:"status"}),...(0,C.aH)("contao/backup",["files"]),...(0,C.L8)("server/database",{hasDatabaseError:"hasError"}),...(0,C.L8)("contao/backup",["hasBackups"]),fileOptions(){return this.files.map((e=>({value:e.name,label:this.$t("ui.setup.database-connection.restoreOption",{date:(0,Bs.A)(e.createdAt),size:(0,Os.A)(e.size)})})))}},methods:{datimFormat(e){return(0,Bs.A)(e,"short","long")},checkMigrations(){this.$store.commit("checkMigrations")},parseUrl(){if(!this.validateUrl())return;this.validating=!0;const e=new RegExp(this.urlPattern,"i").exec(this.url);this.user=e[3]?decodeURIComponent(e[3]):"",this.password=e[5]?decodeURIComponent(e[5]):"",this.server=decodeURIComponent(e[6]),this.database=decodeURIComponent(e[8]),":3306"===this.server.substring(this.server.length-5)?this.server=this.server.substring(0,this.server.length-5):this.server.includes(":")||(this.server=`${this.server}:3306`),this.valid=this.validateUrl(),this.validating=!1},updateUrl(){if(this.validating)return;if(this.valid=!1,!this.server)return;const e=this.server.split(":",2),t=`${encodeURIComponent(e[0])}:${e[1]||"3306"}`;let s="mysql://";this.user&&(s+=encodeURIComponent(this.user),this.password&&(s+=":"+encodeURIComponent(this.password)),s+="@"),s+=t,this.database&&(s+="/"+encodeURIComponent(this.database)),this.url=s,this.valid=this.validateUrl()},validateUrl(){return this.validUrl=!0,this.valid=!1,""!==this.url&&(this.validUrl=new RegExp(this.urlPattern,"i").test(this.url),this.validUrl)},async load(){this.url=(await this.$store.dispatch("server/database/get")).data.url,this.currentState=this.status?.type,this.parseUrl(),"error"===this.currentState&&(this.validUrl=!1,this.valid=!1)},async save(){this.processing=!0;const e=await this.$store.dispatch("server/database/set",this.url);if("error"===e.data.status.type)return this.processing=!1,this.validUrl=!1,void(this.valid=!1);await this.$store.dispatch("server/adminUser/get",!1),this.processing=!1},async restore(){await this.$store.dispatch("tasks/execute",{name:"contao/backup-restore",config:{file:this.files.length>1?this.selection:this.files[0].name,backup:!1}}),"complete"===this.taskStatus&&(this.$store.commit("contao/backup/setRestored"),await this.$store.dispatch("tasks/deleteCurrent"))}},watch:{user(){this.updateUrl()},password(){this.updateUrl()},server(){this.updateUrl()},database(){this.updateUrl()},status(){this.currentState=this.status?.type}},mounted(){this.load(),this.selection=null,this.backup=!0}};const Qs=(0,Xe.A)(Hs,[["render",Ms]]);var Ks=Qs,Js=s.p+"img/user.129e863d.svg";const Ns={class:"setup__header"},zs={class:"setup__headline"},Zs={class:"setup__description"},Ys={key:0,class:"setup__form"},Gs={class:"setup__fields"},ei={class:"setup__warning"},ti={class:"setup__form setup__form--center",key:"confirmation"},si={class:"setup__fields"},ii={class:"setup__fielddesc"},ai={class:"setup__actions setup__actions--center"},oi={class:"setup__form",key:"setup"},ni={class:"setup__fields"},ri={class:"setup__fieldtitle"},li={class:"setup__fielddesc"},ui={class:"setup__actions setup__actions--center"};function ci(e,t,s,o,n,r){const l=(0,i.g2)("console-output"),u=(0,i.g2)("text-field"),c=(0,i.g2)("loading-button");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",Ns,[t[8]||(t[8]=(0,i.Lk)("img",{src:Js,width:"80",height:"80",class:"setup__icon",alt:""},null,-1)),(0,i.Lk)("h1",zs,(0,a.v_)(e.$t("ui.setup.backend-user.headline")),1),(0,i.Lk)("p",Zs,(0,a.v_)(e.$t("ui.setup.backend-user.description")),1)]),null===e.hasUser?((0,i.uX)(),(0,i.CE)("main",Ys,[(0,i.Lk)("div",Gs,[(0,i.Lk)("p",ei,(0,a.v_)(e.$t("ui.setup.backend-user.error")),1),502===e.response.status?((0,i.uX)(),(0,i.Wv)(l,{key:0,class:"view-recovery__console",title:e.$t("ui.recovery.console"),operations:[{status:"error",summary:"vendor/bin/contao-console contao:user:list",console:e.response.data.detail}],"console-output":e.response.data.detail,"show-console":"","force-console":""},null,8,["title","operations","console-output"])):(0,i.Q3)("",!0)])])):((0,i.uX)(),(0,i.Wv)(X.eB,{key:1,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[e.hasUser?((0,i.uX)(),(0,i.CE)("main",ti,[(0,i.Lk)("div",si,[t[9]||(t[9]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",ii,(0,a.v_)(e.$t("ui.setup.backend-user.success")),1)]),(0,i.Lk)("div",ai,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",onClick:t[0]||(t[0]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("main",oi,[(0,i.Lk)("form",{onSubmit:t[7]||(t[7]=(0,X.D$)((function(){return r.save&&r.save(...arguments)}),["prevent"]))},[(0,i.Lk)("div",ni,[(0,i.Lk)("h2",ri,(0,a.v_)(e.$t("ui.setup.backend-user.formTitle")),1),(0,i.Lk)("p",li,(0,a.v_)(e.$t("ui.setup.backend-user.formText")),1),(0,i.bF)(u,{ref:"username",name:"username",label:e.$t("ui.setup.backend-user.username"),disabled:e.processing,required:"",validate:"",modelValue:e.username,"onUpdate:modelValue":t[1]||(t[1]=t=>e.username=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{ref:"name",name:"name",label:e.$t("ui.setup.backend-user.name"),disabled:e.processing,required:"",validate:"",modelValue:e.name,"onUpdate:modelValue":t[2]||(t[2]=t=>e.name=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{ref:"email",name:"email",type:"email",label:e.$t("ui.setup.backend-user.email"),disabled:e.processing,required:"",validate:"",error:e.errors.email,onFocus:t[3]||(t[3]=t=>e.errors.email=""),onBlur:r.validateEmail,modelValue:e.email,"onUpdate:modelValue":t[4]||(t[4]=t=>e.email=t)},null,8,["label","disabled","error","onBlur","modelValue"]),(0,i.bF)(u,{ref:"password",name:"password",type:"password",label:e.$t("ui.setup.backend-user.password"),placeholder:e.$t("ui.setup.backend-user.passwordPlaceholder"),disabled:e.processing,required:"",minlength:"8",validate:"",error:e.errors.password,onFocus:t[5]||(t[5]=t=>e.errors.password=""),onBlur:r.validatePassword,modelValue:e.password,"onUpdate:modelValue":t[6]||(t[6]=t=>e.password=t)},null,8,["label","placeholder","disabled","error","onBlur","modelValue"])]),(0,i.Lk)("div",ui,[(0,i.bF)(c,{submit:"",color:"primary",loading:e.processing,disabled:!e.valid},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.backend-user.create")),1)])),_:1},8,["loading","disabled"])])],32)]))])),_:1}))])}var di=s(2864),pi={components:{TextField:fe.A,LoadingButton:Ve.A,ConsoleOutput:di.A},data:()=>({processing:!1,valid:!1,username:"",name:"",email:"",password:"",errors:{email:"",password:""}}),computed:{...(0,C.aH)("server/adminUser",{hasUser:"hasUser",response:"cache"})},methods:{validate(){this.valid=this.$refs.username.checkValidity()&&this.$refs.name.checkValidity()&&this.$refs.email.checkValidity()&&this.$refs.password.checkValidity()},validateEmail(){this.errors.email=null,""!==this.email&&(this.$refs.email.checkValidity()||(this.errors.email=this.$t("ui.setup.backend-user.emailInvalid")))},validatePassword(){this.errors.password=null,""!==this.password&&this.password.length<8&&(this.errors.password=this.$t("ui.setup.backend-user.passwordLength"))},async save(){this.processing=!0,await this.$store.dispatch("server/adminUser/set",{username:this.username,name:this.name,email:this.email,password:this.password}),this.processing=!1,this.$store.commit("setup",5)}},watch:{username(){this.validate()},name(){this.validate()},email(){this.validate()},password(){this.validate()}}};const hi=(0,Xe.A)(pi,[["render",ci]]);var mi=hi,_i={components:{BoxedLayout:E.A,DocumentRoot:De,CreateProject:us,DatabaseConnection:Ks,BackendUser:mi},computed:{...(0,C.aH)(["setupStep"]),...(0,C.aH)("server/contao",["contaoVersion"]),...(0,C.aH)("server/database",{databaseSupported:"supported"}),...(0,C.aH)("server/adminUser",{userSupported:"supported"}),...(0,C.aH)("contao/install-tool",{showInstallTool:"isSupported"}),currentStep:{get(){return this.setupStep},set(e){this.$store.commit("setup",e)}},steps(){const e=[];return e.push({name:"document-root",icon:F,component:De}),e.push({name:"create-project",icon:Se,component:us}),this.databaseSupported&&e.push({name:"database-connection",icon:cs,component:Ks}),this.userSupported&&e.push({name:"backend-user",icon:Js,component:mi}),e}},methods:{launch(){this.$store.commit("setView",$.A.READY)}},mounted(){this.$store.dispatch("server/adminUser/get"),this.$store.dispatch("contao/backup/fetch")}};const vi=(0,Xe.A)(_i,[["render",L]]);var ki=vi},9472:function(e,t,s){e.exports=s.p+"img/database.7f0a8c49.svg"}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[60],{60:function(e,t,r){function n(e){const t=new Uint8Array(e);let r="";for(const o of t)r+=String.fromCharCode(o);const n=btoa(r);return n.replace(/\+/g,"-").replace(/\//g,"_").replace(/=/g,"")}function o(e){const t=e.replace(/-/g,"+").replace(/_/g,"/"),r=(4-t.length%4)%4,n=t.padEnd(t.length+r,"="),o=atob(n),i=new ArrayBuffer(o.length),a=new Uint8Array(i);for(let s=0;s<o.length;s++)a[s]=o.charCodeAt(s);return i}function i(){return a.stubThis(void 0!==globalThis?.PublicKeyCredential&&"function"===typeof globalThis.PublicKeyCredential)}r.d(t,{zZ:function(){return i},ZF:function(){return w},HS:function(){return m},Ct:function(){return R}});const a={stubThis:e=>e};function s(e){const{id:t}=e;return{...e,id:o(t),transports:e.transports}}function c(e){return"localhost"===e||/^([a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,}$/i.test(e)}class l extends Error{constructor({message:e,code:t,cause:r,name:n}){super(e,{cause:r}),Object.defineProperty(this,"code",{enumerable:!0,configurable:!0,writable:!0,value:void 0}),this.name=n??r.name,this.code=t}}function u({error:e,options:t}){const{publicKey:r}=t;if(!r)throw Error("options was missing required publicKey property");if("AbortError"===e.name){if(t.signal instanceof AbortSignal)return new l({message:"Registration ceremony was sent an abort signal",code:"ERROR_CEREMONY_ABORTED",cause:e})}else if("ConstraintError"===e.name){if(!0===r.authenticatorSelection?.requireResidentKey)return new l({message:"Discoverable credentials were required but no available authenticator supported it",code:"ERROR_AUTHENTICATOR_MISSING_DISCOVERABLE_CREDENTIAL_SUPPORT",cause:e});if("conditional"===t.mediation&&"required"===r.authenticatorSelection?.userVerification)return new l({message:"User verification was required during automatic registration but it could not be performed",code:"ERROR_AUTO_REGISTER_USER_VERIFICATION_FAILURE",cause:e});if("required"===r.authenticatorSelection?.userVerification)return new l({message:"User verification was required but no available authenticator supported it",code:"ERROR_AUTHENTICATOR_MISSING_USER_VERIFICATION_SUPPORT",cause:e})}else{if("InvalidStateError"===e.name)return new l({message:"The authenticator was previously registered",code:"ERROR_AUTHENTICATOR_PREVIOUSLY_REGISTERED",cause:e});if("NotAllowedError"===e.name)return new l({message:e.message,code:"ERROR_PASSTHROUGH_SEE_CAUSE_PROPERTY",cause:e});if("NotSupportedError"===e.name){const t=r.pubKeyCredParams.filter((e=>"public-key"===e.type));return 0===t.length?new l({message:'No entry in pubKeyCredParams was of type "public-key"',code:"ERROR_MALFORMED_PUBKEYCREDPARAMS",cause:e}):new l({message:"No available authenticator supported any of the specified pubKeyCredParams algorithms",code:"ERROR_AUTHENTICATOR_NO_SUPPORTED_PUBKEYCREDPARAMS_ALG",cause:e})}if("SecurityError"===e.name){const t=globalThis.location.hostname;if(!c(t))return new l({message:`${globalThis.location.hostname} is an invalid domain`,code:"ERROR_INVALID_DOMAIN",cause:e});if(r.rp.id!==t)return new l({message:`The RP ID "${r.rp.id}" is invalid for this domain`,code:"ERROR_INVALID_RP_ID",cause:e})}else if("TypeError"===e.name){if(r.user.id.byteLength<1||r.user.id.byteLength>64)return new l({message:"User ID was not between 1 and 64 characters",code:"ERROR_INVALID_USER_ID_LENGTH",cause:e})}else if("UnknownError"===e.name)return new l({message:"The authenticator was unable to process the specified options, or could not create a new credential",code:"ERROR_AUTHENTICATOR_GENERAL_ERROR",cause:e})}return e}class d{constructor(){Object.defineProperty(this,"controller",{enumerable:!0,configurable:!0,writable:!0,value:void 0})}createNewAbortSignal(){if(this.controller){const e=new Error("Cancelling existing WebAuthn API call for new one");e.name="AbortError",this.controller.abort(e)}const e=new AbortController;return this.controller=e,e.signal}cancelCeremony(){if(this.controller){const e=new Error("Manually cancelling existing WebAuthn API call");e.name="AbortError",this.controller.abort(e),this.controller=void 0}}}const h=new d,p=["cross-platform","platform"];function f(e){if(e&&!(p.indexOf(e)<0))return e}async function R(e){!e.optionsJSON&&e.challenge&&(console.warn("startRegistration() was not called correctly. It will try to continue with the provided options, but this call should be refactored to use the expected call structure instead. See https://simplewebauthn.dev/docs/packages/browser#typeerror-cannot-read-properties-of-undefined-reading-challenge for more information."),e={optionsJSON:e});const{optionsJSON:t,useAutoRegister:r=!1}=e;if(!i())throw new Error("WebAuthn is not supported in this browser");const a={...t,challenge:o(t.challenge),user:{...t.user,id:o(t.user.id)},excludeCredentials:t.excludeCredentials?.map(s)},c={};let l;r&&(c.mediation="conditional"),c.publicKey=a,c.signal=h.createNewAbortSignal();try{l=await navigator.credentials.create(c)}catch(y){throw u({error:y,options:c})}if(!l)throw new Error("Registration was not completed");const{id:d,rawId:p,response:R,type:w}=l;let b,E,m,A;if("function"===typeof R.getTransports&&(b=R.getTransports()),"function"===typeof R.getPublicKeyAlgorithm)try{E=R.getPublicKeyAlgorithm()}catch(_){g("getPublicKeyAlgorithm()",_)}if("function"===typeof R.getPublicKey)try{const e=R.getPublicKey();null!==e&&(m=n(e))}catch(_){g("getPublicKey()",_)}if("function"===typeof R.getAuthenticatorData)try{A=n(R.getAuthenticatorData())}catch(_){g("getAuthenticatorData()",_)}return{id:d,rawId:n(p),response:{attestationObject:n(R.attestationObject),clientDataJSON:n(R.clientDataJSON),transports:b,publicKeyAlgorithm:E,publicKey:m,authenticatorData:A},type:w,clientExtensionResults:l.getClientExtensionResults(),authenticatorAttachment:f(l.authenticatorAttachment)}}function g(e,t){console.warn(`The browser extension that intercepted this WebAuthn API call incorrectly implemented ${e}. You should report this error to them.\n`,t)}function w(){if(!i())return b.stubThis(new Promise((e=>e(!1))));const e=globalThis.PublicKeyCredential;return void 0===e?.isConditionalMediationAvailable?b.stubThis(new Promise((e=>e(!1)))):b.stubThis(e.isConditionalMediationAvailable())}const b={stubThis:e=>e};function E({error:e,options:t}){const{publicKey:r}=t;if(!r)throw Error("options was missing required publicKey property");if("AbortError"===e.name){if(t.signal instanceof AbortSignal)return new l({message:"Authentication ceremony was sent an abort signal",code:"ERROR_CEREMONY_ABORTED",cause:e})}else{if("NotAllowedError"===e.name)return new l({message:e.message,code:"ERROR_PASSTHROUGH_SEE_CAUSE_PROPERTY",cause:e});if("SecurityError"===e.name){const t=globalThis.location.hostname;if(!c(t))return new l({message:`${globalThis.location.hostname} is an invalid domain`,code:"ERROR_INVALID_DOMAIN",cause:e});if(r.rpId!==t)return new l({message:`The RP ID "${r.rpId}" is invalid for this domain`,code:"ERROR_INVALID_RP_ID",cause:e})}else if("UnknownError"===e.name)return new l({message:"The authenticator was unable to process the specified options, or could not create a new assertion signature",code:"ERROR_AUTHENTICATOR_GENERAL_ERROR",cause:e})}return e}async function m(e){!e.optionsJSON&&e.challenge&&(console.warn("startAuthentication() was not called correctly. It will try to continue with the provided options, but this call should be refactored to use the expected call structure instead. See https://simplewebauthn.dev/docs/packages/browser#typeerror-cannot-read-properties-of-undefined-reading-challenge for more information."),e={optionsJSON:e});const{optionsJSON:t,useBrowserAutofill:r=!1,verifyBrowserAutofillInput:a=!0}=e;if(!i())throw new Error("WebAuthn is not supported in this browser");let c;0!==t.allowCredentials?.length&&(c=t.allowCredentials?.map(s));const l={...t,challenge:o(t.challenge),allowCredentials:c},u={};if(r){if(!await w())throw Error("Browser does not support WebAuthn autofill");const e=document.querySelectorAll("input[autocomplete$='webauthn']");if(e.length<1&&a)throw Error('No <input> with "webauthn" as the only or last value in its `autocomplete` attribute was detected');u.mediation="conditional",l.allowCredentials=[]}let d;u.publicKey=l,u.signal=h.createNewAbortSignal();try{d=await navigator.credentials.get(u)}catch(A){throw E({error:A,options:u})}if(!d)throw new Error("Authentication was not completed");const{id:p,rawId:R,response:g,type:b}=d;let m;return g.userHandle&&(m=n(g.userHandle)),{id:p,rawId:n(R),response:{authenticatorData:n(g.authenticatorData),clientDataJSON:n(g.clientDataJSON),signature:n(g.signature),userHandle:m},type:b,clientExtensionResults:d.getClientExtensionResults(),authenticatorAttachment:f(d.authenticatorAttachment)}}}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[706],{2706:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Conexión insegura !!","ui.app.httpsDescription":"Sin HTTPS, sus datos confidenciales se transferirán sin cifrar.","ui.app.httpsLink":"Mas información","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"¡Modo seguro habilitado!","ui.app.safeModeDescription":"Algunas funciones de Contao Manager no están disponibles.","ui.app.safeModeExit":"Salida del modo seguro","ui.app.limitedHeadline":"Autenticación remota ","ui.app.limitedDescription":"Tiene permisos limitados debido al inicio de sesión sin contraseña.","ui.app.limitedLogout":"Volver a autenticar","ui.app.totpHeadline":"Aviso de seguridad","ui.app.totpDescription":"Configure la autenticación de dos factores ahora para proteger su cuenta.","ui.app.totpSetup":"Configuración","ui.app.loading":"Cargando Contao Manager ...","ui.app.apiError":"Estado inesperado de la API","ui.app.configSecurity1":"ALERTA DE SEGURIDAD !!! Detectado directorio de configuración desprotegido","ui.app.configSecurity2":"Contao Manager ha detectado que sus archivos de configuración son de acceso público. Todas las operaciones están deshabilitadas hasta que el directorio esté seguro; de lo contrario, un atacante podría acceder a datos confidenciales de su instalación.\\n\\nPara solucionar este problema, asegúrese de evitar el acceso al directorio \\"contao-manager\\" en su servidor. Para saber cómo hacer esto, consulte el manual de su servidor web o póngase en contacto con su proveedor de alojamiento.","ui.account.welcome":"Bienvenido","ui.account.intro1":"Bienvenido a Contao Manager, una herramienta universal para instalar y administrar Contao Open Source CMS. Si es nuevo en esto, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} para comenzar","ui.account.introManual":"lea el manual","ui.account.intro2":"Si encuentra algún problema, consulte {ourGithubIssues} y siéntase libre de crear uno nuevo para cualquier cosa que aún no se haya informado.","ui.account.introIssues":"nuestros problemas de GitHub","ui.account.headline":"Cuenta de usuario","ui.account.description":"Para administrar su instalación, cree una cuenta para Contao Manager. Tenga en cuenta que esta cuenta no está relacionada con el back end o front end de Contao.","ui.account.username":"Nombre de usuario","ui.account.password":"Contraseña","ui.account.passwordPlaceholder":"min. 8 caracteres","ui.account.passwordLength":"Por favor introduzca al menos 8 caracteres.","ui.account.loginInvalid":"Se produjo un error al crear la cuenta. Intente con otro nombre de usuario.","ui.account.submit":"Crear una cuenta","ui.account.usePassword":"Utilice contraseña para iniciar sesión","ui.account.usePasskey":"Utilice la clave de acceso (Passkey) para iniciar sesión","ui.account.totpHeadline":"Autenticación de dos factores","ui.account.totpDescription":"Habilite la autenticación de dos factores, que agrega una capa adicional de seguridad a su cuenta. Además de su nombre de usuario y contraseña, deberá ingresar un código de verificación generado por una aplicación de dos factores como 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator o cualquier otra aplicación TOTP.","ui.account.totpSetup":"Configurar ahora","ui.account.totpSkip":"Configurar más tarde","ui.account.login":"Rechazar invitación","ui.account.contribute1":"Contao y Contao Manager están patrocinados por la Asociación Contao sin fines de lucro.","ui.account.contribute2":"Considere contribuir al código abierto con {donate}.","ui.account.contributeDonate":"hacer una donación","ui.login.headline":"Registrarse","ui.login.description":"Inicie sesión para administrar su instalación.","ui.login.username":"Nombre de usuario","ui.login.password":"Contraseña","ui.login.totpHeadline":"Autenticación de dos factores","ui.login.totpDescription":"Ingrese su código de verificación para completar el proceso de inicio de sesión.","ui.login.totp":"Código de verificación","ui.login.forgotPassword":"¿Ha olvidado su contraseña?","ui.login.button":"Registrarse","ui.login.passkey":"Iniciar sesión con clave de acceso (Passkey)","ui.login.cancel":"Cancelar","ui.login.or":"o","ui.login.locked":"Se ha denegado el acceso porque Contao Manager está bloqueado. Para desbloquear, elimine el archivo {lockFile} en su directorio raíz de Contao.","ui.logout.headline":"Timeout de la sesión","ui.logout.warning":"Ha estado inactivo por más de 25 minutos. Por razones de seguridad, su sesión finalizará en breve.","ui.logout.expired":"Su sesión finalizó automáticamente porque ha estado inactivo durante más de 30 minutos.","ui.logout.renew":"Mantener conectado","ui.logout.logout":"Cerrar sesión","ui.logout.login":"Volver para iniciar sesión","ui.oauth.error":"Intento de OAuth no válido Verifique los parámetros de solicitud.","ui.oauth.https":"El URI de redireccionamiento DEBE usar un protocolo seguro (https :) para evitar que el token de autenticación se transmita en texto sin cifrar. ","ui.oauth.headline":"Autenticación remota ","ui.oauth.description":"La siguiente aplicación o servicio está solicitando acceso remoto a su instancia del Contao Manager.","ui.oauth.domain":"Antes de permitir el acceso, asegúrese de conocer esta URL y confíe en su propietario.","ui.oauth.outOfScope":"Lamentablemente, no tienes los permisos necesarios para otorgar este acceso.","ui.oauth.allow":"Permitir el acceso","ui.oauth.deny":"Acceso denegado","ui.oauth.switchUser":"Cambiar de usuario","ui.scope.admin":"Acceso de administrador, incluida la gestión de usuarios","ui.scope.install":"Instalar nuevos paquetes y cambiar la configuración de Contao","ui.scope.update":"Actualizar paquetes y ejecutar tareas de mantenimiento","ui.scope.read":"Leer paquetes y configuración","ui.boot.headline":"Comprobar sistema","ui.boot.description":"Por favor espere, estamos analizando su servidor ...","ui.boot.issue1":"Se han detectado problemas de instalación","ui.boot.issue2":"Su instalación tiene problemas que deben solucionarse antes de que se pueda utilizar Contao Manager.","ui.boot.run":"Lanzamiento de Contao Manager","ui.boot.safeMode":"Lanzamiento en modo seguro","ui.recovery.headline":"Recuperación del sistema","ui.recovery.description":"El Contao Manager detectó archivos que se parecen a Contao, pero la Interfaz de línea de comandos no funciona como se esperaba.","ui.recovery.console":"Salida de consola","ui.recovery.repairOptions":"Por favor, elija una opción para reparar su instalación.","ui.recovery.repairHeadline":"Reparación automática","ui.recovery.repairDescription":"Intenta reparar automáticamente la instalación reconstruyendo el caché de la aplicación y reinstalando los paquetes de Composer.","ui.recovery.repairWarning":"¡Cualquier modificación de los archivos del proveedor podría ser eliminada en el proceso!","ui.recovery.repairFailed":"La reparación automática no tuvo éxito. Pruebe el Modo seguro para reparar manualmente la instalación.","ui.recovery.repairButton":"Ejecutar la reparación del sistema","ui.recovery.safeModeHeadline":"Modo seguro","ui.recovery.safeModeDescription":"Iniciar el Contao Manager en Modo seguro permite administrar paquetes y ejecutar ciertas tareas de mantenimiento, pero las funciones que dependen de una instalación de Contao que funcione no estarán disponibles.","ui.recovery.safeModeButton":"Lanzamiento en modo seguro","ui.server.pending":"Esperando …","ui.server.running":"Analizando ...","ui.server.error":"La comprobación falló debido a una respuesta inesperada del servidor.","ui.server.details":"Detalles","ui.server.prerequisite":"Verificación cancelada debido a un prerrequisito faltante.","ui.server.selfUpdate.title":"Actualizaciones del Contao Manager","ui.server.selfUpdate.update":"Una nueva versión {latest} de Contao Manager está disponible.","ui.server.selfUpdate.manualUpdate":"Hay disponible una nueva versión {latest} de Contao Manager. Su servidor no admite actualizaciones automáticas, descargue la nueva versión de {download}.","ui.server.selfUpdate.latest":"Estás utilizando la última versión {current}.","ui.server.selfUpdate.dev":"Las compilaciones de desarrollo no admiten actualizaciones automáticas.","ui.server.selfUpdate.unsupported":"Hay una nueva versión disponible pero no es compatible con su versión de PHP.","ui.server.selfUpdate.button":"Ejecutar autoactualización","ui.server.selfUpdate.continue":"Continuar","ui.server.config.title":"Configuración del servidor","ui.server.config.setup":"Configurar","ui.server.config.change":"Cambiar","ui.server.config.save":"Guardar","ui.server.config.cancel":"Cancelar","ui.server.config.customOption":"Otros ...","ui.server.config.description":"Para ejecutar correctamente las tareas en segundo plano, Contao Manager necesita saber dónde encontrar el binario de la línea de comandos PHP y cómo ejecutar comandos separados del proceso web.","ui.server.config.formTitle":"Configuración del servidor","ui.server.config.formText":"Por favor ingrese la ruta a su binario de PHP. Asegúrese de que el binario sea la misma versión PHP que su proceso web.","ui.server.config.cloudTitle":"Compositor Resolver Cloud","ui.server.config.cloudText":"El Composer Resolver Cloud permite instalar dependencias de Composer incluso si su servidor no proporciona suficiente memoria local. Tenga en cuenta que la información de su paquete se transmitirá a un servidor en la nube operado por la Asociación Contao.","ui.server.config.cloud":"Utilice la nube Composer Resolver Cloud","ui.server.config.cli":"PHP binario","ui.server.config.stateErrorCli":"No se encontró ningún binario PHP válido en el servidor.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud no es compatible.","ui.server.config.stateSuccess":"PHP binario en {php_cli}.","ui.server.php_web.title":"Proceso web de PHP","ui.server.php_web.below7":"Versión PHP encontrada {versión}. ¡Cambie a PHP 7 lo antes posible!","ui.server.php_web.success":"Se encontró la versión PHP {versión}, no se encontraron problemas conocidos.","ui.server.php_cli.title":"Interfaz de línea de comandos de PHP","ui.server.php_cli.success":"Se encontró la versión PHP {versión}, no se encontraron problemas conocidos.","ui.server.composer.title":"Entorno Composer","ui.server.composer.success":"No se encontraron problemas conocidos.","ui.server.composer.install":"Las dependencias del Composer no están instaladas.","ui.server.composer.button":"Instalar","ui.server.contao.title":"Instalación de Contao","ui.server.contao.setup":"Configuración","ui.server.contao.check":"Consultar base de datos","ui.server.contao.empty":"No se ha encontrado una instalación de Contao.","ui.server.contao.old":"La versión de Contao {versión} no es compatible con Contao Manager, actualice su instalación manualmente.","ui.server.contao.found":"Se ha encontrado Contao {version} (API version {api}).","ui.server.contao.connectionError":"No se puede conectar con el servidor de la base de datos.","ui.server.contao.connectionProblem":"Problema de base de datos encontrado.","ui.server.contao.missingUser":"Cuenta de administrador no encontrada.","ui.setup.continue":"Continuar","ui.setup.manager":"Lanzamiento de Contao Manager","ui.setup.cancel":"Cancelar","ui.setup.welcome":"Bienvenido","ui.setup.welcome1":"Este asistente le guiará a través de los pasos necesarios para configurar su instalación de CMS de código abierto de Contao.","ui.setup.welcome2":"Si tiene alguna pregunta, busque documentación, foros, un canal de Slack y más en la página de {support}.","ui.setup.support":"soporte comunitario","ui.setup.start":"Empezar","ui.setup.complete":"¡Enhorabuena!","ui.setup.complete1":"Contao {versión} se ha instalado correctamente.","ui.setup.complete2":"Para finalizar el proceso de configuración, abra la herramienta de instalación para configurar la conexión de la base de datos y crear un usuario final.","ui.setup.complete3":"Ahora puede comenzar a crear su sitio web en el back-end de Contao. Si necesita extensiones adicionales, continúe con Contao Manager.","ui.setup.installTool":"Abra la herramienta de instalación","ui.setup.login":"Iniciar sesión en Contao","ui.setup.funding":"El software libre es \\"libre\\" como en \\"libertad de expresión\\", no como en \\"cerveza gratis\\". Un proyecto de código abierto como Contao requiere cantidades de dinero que no pueden ser recaudadas por una sola persona o empresa.\\nSi tiene un sitio web o vende sitios web creados con Contao, nos encantaría ver que contribuye financieramente al producto del que depende su negocio.","ui.setup.fundingLink":"Aprende más","ui.setup.document-root.headline":"Configuración del servidor web","ui.setup.document-root.warning":"Para instalar Contao a través de Contao Manager, debe arreglar la raíz del documento en el servidor web.","ui.setup.document-root.description1":"Contao usa una carpeta separada para los archivos públicos, los archivos de la aplicación se instalan en su carpeta principal. Contao no se puede instalar si la estructura de carpetas no es correcta o las carpetas no están vacías.","ui.setup.document-root.description2":"Si no sabe cómo configurar la raíz de su documento, lea la documentación de Contao o comuníquese con su proveedor de alojamiento.","ui.setup.document-root.documentation":"Lea la documentación","ui.setup.document-root.conflictsTitle":"El directorio de instalación no está vacío","ui.setup.document-root.conflictsDirectory":"El directorio raíz de su futura instalación de Contao no está vacío, hemos encontrado (un) archivo(s) {count} que podrían sobrescribirse durante el proceso de instalación. Se recomienda crear una estructura de directorios vacía para Contao, pero también puede eliminar los siguientes archivos y verificar nuevamente si está seguro de que no se utilizan.","ui.setup.document-root.ignoreConflicts":"Quiero instalar Contao en el directorio no vacío. Entiendo que esto podría sobrescribir cualquier archivo existente en mi espacio web.","ui.setup.document-root.check":"Revisar otra vez","ui.setup.document-root.create":"Crear directorios","ui.setup.document-root.change":"Cambiar directorios","ui.setup.document-root.formTitle":"Configuración de directorio","ui.setup.document-root.formText1":"Contao Manager puede crear automáticamente una nueva estructura de directorio en el servidor.","ui.setup.document-root.formText2":"Deberá configurar manualmente la nueva raíz del documento (por ejemplo, a través de un panel de administración de alojamiento).","ui.setup.document-root.autoconfig":"Entiendo que tengo que cambiar la configuración de mi servidor. ¡No configurar la raíz del documento romperá el Contao Manager y expondrá los archivos de configuración (incluidos los detalles de la cuenta y las contraseñas)!","ui.setup.document-root.directory":"Nuevo directorio","ui.setup.document-root.currentRoot":"Raíz del documento actual","ui.setup.document-root.newRoot":"Nueva raíz del documento","ui.setup.document-root.finish":"Configurar directorios","ui.setup.document-root.publicDir":"Use {dir} para archivos públicos (para Contao {version})","ui.setup.document-root.directoryInvalid":"Introduzca un nombre de directorio válido.","ui.setup.document-root.directoryExists":"El directorio de destino ya existe. Ingrese un nombre diferente.","ui.setup.document-root.confirmation":"Contao Manager ha creado con éxito el directorio necesario para su instalación de Contao. Ahora debe configurar la raíz del documento en su servidor web. No recargues esta página hasta entonces.","ui.setup.document-root.reload":"Recargar página","ui.setup.document-root.success":"¡La estructura de directorios en su servidor web está configurada correctamente!","ui.setup.document-root.installingProjectDir":"Los archivos de la aplicación se instalarán en {dir}.","ui.setup.document-root.installingPublicDir":"Los archivos públicos se instalarán en {dir}.","ui.setup.document-root.installedProjectDir":"Los archivos de la aplicación se instalan en {dir}.","ui.setup.document-root.installedPublicDir":"Los archivos públicos se instalan en {dir}.","ui.setup.create-project.headline":"Instalación de Contao","ui.setup.create-project.description":"El desarrollo de Contao sigue el principio de {semver}, se lanza una nueva versión secundaria cada seis meses. Las versiones admitidas actualmente son:","ui.setup.create-project.semver":"Versionado semántico","ui.setup.create-project.latestTitle":"Última","ui.setup.create-project.ltsTitle":"Soporte a largo plazo","ui.setup.create-project.latestQ1":"Nuestra última versión ofrece la mayoría de las funciones con soporte hasta febrero de {year}.","ui.setup.create-project.latestQ3":"Nuestra última versión ofrece la mayor cantidad de funciones con soporte hasta agosto del {year}.","ui.setup.create-project.ltsText":"Nuestra versión LTS actual, si te enfocas en la estabilidad. Ofrece soporte a largo plazo hasta febrero {year}.","ui.setup.create-project.pltsText":"La versión anterior de LTS todavía tiene soporte a largo plazo hasta febrero de {year}.","ui.setup.create-project.requiresPHP":"Requiere al menos PHP {version}, tiene PHP {current}.","ui.setup.create-project.releaseplan":"Consulte el {contaoReleasePlan} para obtener información detallada.","ui.setup.create-project.releaseplanLink":"Plan de lanzamiento de Contao","ui.setup.create-project.installed":"Contao {version} se instaló correctamente en el servidor. Continúe configurando su base de datos o inicie Contao Manager para instalar una versión diferente.","ui.setup.create-project.formTitle":"Seleccione una distribución","ui.setup.create-project.formText":"Elija qué versión debe instalarse.","ui.setup.create-project.version":"Versión","ui.setup.create-project.demo":"Instale el sitio web de demostración de Contao","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.Instale el sitio web de demostración de Contao","ui.setup.create-project.coreOnly":"Instalación mínima (solo el núcleo)","ui.setup.create-project.noUpdate":"Omitir instalación (¡Solo experto!)","ui.setup.create-project.theme":"Tema Contao","ui.setup.create-project.themeInstall":"Para instalar un tema de Contao, utilice la entrada de búsqueda o cargue un archivo de tema (.cto/.zip) que admita la instalación a través de Contao Manager.","ui.setup.create-project.themeBuy":"Asegúrate de visitar la {store} oficial.","ui.setup.create-project.themeStore":"Tienda de temas Contao","ui.setup.create-project.themeUpload":"Cargar archivo de tema (.cto/.zip)","ui.setup.create-project.themeInvalid":"El archivo cargado no es un tema de Contao o no es compatible con Contao Manager.","ui.setup.create-project.themeWarning":"El Contao Manager no puede saber si este tema es compatible con su servidor. Consulte con el proveedor del tema si tiene alguna pregunta.","ui.setup.create-project.themeTitle":"Revisar los detalles del tema","ui.setup.create-project.themeDetails":"Las siguientes dependencias y archivos se instalarán con este tema.","ui.setup.create-project.themeRequire":"{count} Dependencias | {count} Dependencias","ui.setup.create-project.themeFiles":"{count} Archivo | {count} Archivos","ui.setup.create-project.theme.or":"o buscar temas públicos","ui.setup.create-project.theme.search":"Buscar temas","ui.setup.create-project.theme.more":"Más temas","ui.setup.create-project.theme.empty":"No hay temas que coincidan con {query}","ui.setup.create-project.theme.uploaded":"El archivo del tema se cargó correctamente.","ui.setup.create-project.theme.packageName":"Nombre del paquete","ui.setup.create-project.theme.version":"Versión","ui.setup.create-project.theme.authors":"Autor(es)","ui.setup.create-project.install":"Instalar","ui.setup.create-project.cancel":"Cancelar","ui.setup.database-connection.headline":"Conexión de base de datos","ui.setup.database-connection.description":"Contao requiere una base de datos MySQL (o una bifurcación compatible como MariaDB) para almacenar páginas, contenido, usuarios y otros datos relacionales. Los parámetros de conexión se almacenan en el archivo {env} en la raíz del proyecto de su instalación de Contao.","ui.setup.database-connection.formTitle":"Parámetros de conexión","ui.setup.database-connection.formText":"Ingrese una URL de base de datos o complete los campos de nombre de usuario, contraseña, servidor y base de datos por separado.","ui.setup.database-connection.url":"URL de la base de datos","ui.setup.database-connection.validUrl":"La URL de la base de datos no es válida o la conexión con el servidor falló.","ui.setup.database-connection.or":"o","ui.setup.database-connection.user":"Nombre de usuario","ui.setup.database-connection.password":"Contraseña","ui.setup.database-connection.server":"Servidor (:Port)","ui.setup.database-connection.database":"Nombre de la base de datos","ui.setup.database-connection.connected":"Conexión exitosa a la base de datos {database} en {server}.","ui.setup.database-connection.error":"Error al conectarse a la base de datos.","ui.setup.database-connection.problem":"Contao ha detectado un problema con su servidor de base de datos.","ui.setup.database-connection.schemaTitle":"Esquema de base de datos","ui.setup.database-connection.migration":"Hay una migración pendiente. | Hay {count} migraciones pendientes.","ui.setup.database-connection.schema":"Hay una actualización de esquema pendiente. | Hay {count} actualizaciones de esquema pendientes.","ui.setup.database-connection.noChanges":"El esquema de su base de datos está actualizado.","ui.setup.database-connection.check":"Consultar base de datos","ui.setup.database-connection.skip":"Saltar","ui.setup.database-connection.save":"Guardar","ui.setup.database-connection.change":"Cambiar credenciales","ui.setup.database-connection.restoreTitle":"Importar base de datos","ui.setup.database-connection.restoreText":"El tema que acaba de instalar contiene una copia de seguridad de la base de datos. Restaure la base de datos para importar datos del tema u omita este paso para comenzar con una instalación de Contao en blanco. | El tema que acaba de instalar contiene múltiples copias de seguridad de bases de datos. Seleccione un archivo de respaldo para importar datos del tema u omita este paso para comenzar con una instalación de Contao en blanco.","ui.setup.database-connection.backup":"Copia de seguridad de la base de datos actual antes de importar","ui.setup.database-connection.backupWarning":"¡Todos los datos de la base de datos se sobrescribirán al importar! Primero cree una copia de seguridad si la base de datos no está vacía.","ui.setup.database-connection.restore":"Importar base de datos de temas","ui.setup.database-connection.restoreOption":"Copia de seguridad de {date} ({size})","ui.setup.database-connection.restored":"Su base de datos de temas se importó correctamente. Continúe validando el esquema de su base de datos.","ui.setup.backend-user.success":"Se encontró una cuenta de administrador para el back-end de Contao en su base de datos. Use el back-end de Contao para agregar más usuarios.","ui.setup.backend-user.error":"No se puede recuperar la lista de usuarios. Consulte la salida de la consola para obtener más detalles.","ui.setup.backend-user.headline":"Cuenta back-end","ui.setup.backend-user.description":"Para administrar su sitio web, debe tener al menos una cuenta de administrador para el back-end de Contao. Tenga en cuenta que esta cuenta no está relacionada con Contao Manager.","ui.setup.backend-user.formTitle":"Crear una cuenta","ui.setup.backend-user.formText":"Introduzca los detalles de la nueva cuenta back-end.","ui.setup.backend-user.username":"Nombre de usuario","ui.setup.backend-user.name":"Nombre","ui.setup.backend-user.email":"Dirección de correo electrónico","ui.setup.backend-user.emailInvalid":"Por favor, introduzca una dirección de correo electrónico válida","ui.setup.backend-user.password":"Contraseña","ui.setup.backend-user.passwordPlaceholder":"min. 8 caracteres","ui.setup.backend-user.passwordLength":"Por favor introduzca al menos 8 caracteres.","ui.setup.backend-user.create":"Añadir cuenta","ui.task.headline":"Tarea de fondo","ui.task.loading":"Cargando detalles…","ui.task.created":"Cargando detalles…","ui.task.active":"Espere mientras Contao Manager ejecuta las operaciones de tareas en segundo plano.","ui.task.complete":"Todas las operaciones se completan con éxito. Consulte la salida de la consola para obtener más detalles.","ui.task.paused":"Una operación en segundo plano se detuvo inesperadamente. Compruebe la salida de la consola.","ui.task.aborting":"Espere mientras se cancelan las operaciones en segundo plano.","ui.task.stopped":"Se cancelaron algunas operaciones en segundo plano. Compruebe la salida de la consola.","ui.task.error":"Una operación en segundo plano se detuvo inesperadamente. Compruebe la salida de la consola.","ui.task.failed":"¡El Contao Manager no pudo iniciar una tarea en segundo plano!","ui.task.failedDescription1":"Algo salió mal al intentar ejecutar operaciones en segundo plano.","ui.task.failedDescription2":"Si esto vuelve a suceder, es posible que su servidor no sea compatible.","ui.task.reportProblem":"Informar de un problema","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud patrocinado por {sponsor}","ui.task.buttonAudit":"Actualizar base de datos","ui.task.buttonClose":"Cerrar","ui.task.buttonConfirm":"Confirmar y cerrar","ui.task.buttonContinue":"Continuar","ui.task.buttonCancel":"Cancelar","ui.task.confirmCancel":"¿Está seguro de cancelar esta tarea? ¡Esto podría dejar su instalación de Contao en un estado roto!","ui.task.autoclose":"Cerrar los detalles de la tarea en caso de éxito","ui.console.toggle":"Mostrar / Ocultar salida de consola","ui.console.showLog":"Mostrar registro completo de la consola","ui.console.copyLog":"Copiar registro al portapapeles","ui.migrate.headline":"Actualizaciones de la base de datos","ui.migrate.migrationsOnly":"(solo migraciones)","ui.migrate.schemaOnly":"(solo esquema)","ui.migrate.loading":"Por favor espere, estamos revisando su base de datos...","ui.migrate.empty":"No se encontraron migraciones pendientes ni actualizaciones de esquema. Su base de datos está actualizada.","ui.migrate.emptyMigrations":"No se encontraron migraciones pendientes. Asegúrese de verificar también las actualizaciones del esquema.","ui.migrate.emptySchema":"No se encontraron actualizaciones de esquema pendientes. Asegúrese de verificar también las migraciones.","ui.migrate.pending":"Su base de datos no está actualizada. Revise la salida de la consola a continuación y ejecute los cambios.","ui.migrate.previousChanges":"No se confirmó una migración de base de datos anterior.\\nRevise el resultado de la consola a continuación, luego continúe para ver los próximos cambios.","ui.migrate.previousComplete":"No se confirmó una migración de base de datos anterior, revise el resultado de la consola a continuación.\\nNo hay más cambios pendientes.","ui.migrate.appliedChanges":"Se han aplicado actualizaciones de la base de datos.\\nRevise el resultado de la consola a continuación, luego continúe para ver los próximos cambios.","ui.migrate.appliedComplete":"Se han aplicado actualizaciones de la base de datos.\\nNo hay más migraciones pendientes ni actualizaciones de esquemas. Su base de datos está actualizada.","ui.migrate.problem":"Contao ha detectado un problema con su servidor de base de datos.\\nRevise la salida de la consola a continuación para averiguar qué debe corregirse. | Contao ha detectado problemas con su servidor de base de datos.\\nRevise la salida de la consola a continuación para averiguar qué debe corregirse.","ui.migrate.warning":"Contao ha detectado una configuración incorrecta de su servidor de base de datos.\\nLas advertencias se pueden omitir temporalmente, pero se deben corregir para lograr un rendimiento y una integridad de los datos óptimos.","ui.migrate.error":"No se pudieron aplicar los cambios. Es posible que su base de datos haya cambiado, verifique nuevamente para volver a intentarlo.","ui.migrate.execute":"Ejecutar","ui.migrate.close":"Cerrar","ui.migrate.confirm":"Confirmar y cerrar","ui.migrate.cancel":"Cancelar","ui.migrate.continue":"Continuar","ui.migrate.setup":"Configuración","ui.migrate.skip":"Saltar","ui.migrate.retry":"Revisar otra vez","ui.migrate.retryAll":"Comprobar todo","ui.migrate.withDeletes":"Ejecute todos los cambios de la base de datos, incluidas las consultas DROP.","ui.migrate.migrationTitle":"Migraciones de bases de datos","ui.migrate.schemaTitle":"Actualizaciones de esquema","ui.migrate.problemTitle":"Problemas de base de datos","ui.migrate.warningTitle":"Advertencias de la base de datos","ui.migrate.addTable":"Añadir tabla {table}","ui.migrate.dropTable":"Soltar tabla {table}","ui.migrate.addField":"Añadir campo {table}.{field}","ui.migrate.changeField":"Cambiar campo {table}.{field}","ui.migrate.dropField":"Soltar campo {table}.{field}","ui.migrate.createIndex":"Crear índice \\"{name}\\" en {table}","ui.migrate.dropIndex":"Coloque el índice \\"{name}\\" en {table}","ui.widget.mandatory":"Este campo no debe estar vacío.","ui.widget.blankOption":"Por favor seleccione","ui.widget.showPassword":"Mostrar contraseña","ui.widget.hidePassword":"Ocultar contraseña","ui.error.title":"Error en la solicitud HTTP para \\"{method} {url}\\".","ui.error.server500":"Parece que ocurrió un error inesperado en su servidor. Consulte los archivos de registro de su servidor web (Apache/Nginx) y los registros de Contao Manager en \\"contao-manager/logs\\".","ui.error.response":"El servidor devolvió una respuesta con el código de estado {status}.","ui.error.moreLink":"Más información","ui.error.support":"Soporte Contao","ui.error.permission":"No tiene permiso para utilizar esta función.","ui.footer.help":"Ayuda","ui.footer.reportProblem":"Informar de un problema","ui.navigation.discover":"Descubrir","ui.navigation.packages":"Paquetes","ui.navigation.tools":"Herramientas","ui.navigation.installTool":"Herramienta de instalación","ui.navigation.backend":"Backend de Contao","ui.navigation.debug":"Modo Contao Debug","ui.navigation.logViewer":"Visor de registros","ui.navigation.phpinfo":"Información PHP","ui.navigation.phpinfoLoading":"Cargando información de PHP…","ui.navigation.maintenance":"Mantenimiento","ui.navigation.rebuildCache":"Reconstruir caché","ui.navigation.users":"Cuentas","ui.navigation.systemCheck":"Comprobar sistema","ui.navigation.advanced":"Avanzado","ui.navigation.logout":"Cerrar sesión","ui.maintenance.database.title":"Migraciones y copias de seguridad de bases de datos","ui.maintenance.database.description":"Las migraciones de bases de datos garantizan esquemas de tablas y datos coherentes.","ui.maintenance.database.migrations":"Una migración de base de datos pendiente | {count} migraciones de bases de datos pendientes","ui.maintenance.database.schemaUpdates":"Una actualización de esquema pendiente | {count} actualizaciones de esquema pendientes","ui.maintenance.database.error":"Problema de base de datos encontrado.","ui.maintenance.database.warning":"Se encontraron advertencias de la base de datos.","ui.maintenance.database.button":"Consultar base de datos","ui.maintenance.database.migrationOnly":"Comprobar solo migraciones","ui.maintenance.database.schemaOnly":"Comprobar solamente esquema ","ui.maintenance.database.installTool":"Abrir herramienta de instalación","ui.maintenance.database.createBackup":"Crear copia de seguridad","ui.maintenance.database.backupUnsupported":"Las copias de seguridad de bases de datos no son compatibles con su versión de Contao.","ui.maintenance.database.backupList":"Tiene una copia de seguridad de la base de datos, creada el {fecha}. | Tiene {count} copias de seguridad de la base de datos; la última se creó el {fecha}.","ui.maintenance.database.backupEmpty":"Actualmente no tiene copias de seguridad de la base de datos.","ui.maintenance.rebuildCache.title":"Caché de la aplicación","ui.maintenance.rebuildCache.description":"Es necesario volver a generar la caché de la aplicación después de modificar cualquiera de los archivos de configuración.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruir caché de producción","ui.maintenance.rebuildCache.rebuildDev":"Reconstruir caché de desarrollo","ui.maintenance.rebuildCache.clearProd":"Borrar caché de producción","ui.maintenance.rebuildCache.clearDev":"Borrar caché de desarrollo","ui.maintenance.installTool.title":"Herramienta de Instalación Contao","ui.maintenance.installTool.description":"La herramienta de instalación de Contao se bloquea automáticamente si introduce una contraseña incorrecta tres veces seguidas.","ui.maintenance.installTool.unlock":"Desbloquear herramienta de instalación","ui.maintenance.installTool.lock":"Bloquear herramienta de instalación","ui.maintenance.dumpAutoload.title":"Cargador Composer Class","ui.maintenance.dumpAutoload.description":"El autocargador Composer es responsable de la carga de la clase PHP. El autocargador debe volcarse después de agregar espacios de nombres personalizados a la raíz composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dependencias Composer","ui.maintenance.composerInstall.description":"Las dependencias de Composer se encuentran en la carpeta {vendor} en la raíz de su aplicación. Puede ser necesario reinstalar las dependencias después de la manipulación o de cargar manualmente el archivo {composerLock}.","ui.maintenance.composerInstall.button":"Ejecutar instalador","ui.maintenance.composerInstall.update":"Ejecutar actualización de Composer","ui.maintenance.composerCache.title":"Caché del Composer","ui.maintenance.composerCache.description":"El Composer almacena en el caché los paquetes descargados para un mejor rendimiento. Si tiene problemas como archivos rotos, intente eliminar el caché de Composer para forzar una nueva descarga.","ui.maintenance.composerCache.button":"Limpiar cache","ui.maintenance.maintenanceMode.title":"Modo de mantenimiento","ui.maintenance.maintenanceMode.description":"Poner a Contao en modo de mantenimiento mostrará una plantilla \\"503 Servicio no disponible\\" para el sitio web.","ui.maintenance.maintenanceMode.enable":"Habilitar","ui.maintenance.maintenanceMode.disable":"Deshabilitar","ui.maintenance.debugMode.title":"Modo Debug","ui.maintenance.debugMode.description":"Active el modo de depuración configurando un usuario y una contraseña para el punto de entrada {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Active el modo de depuración configurando la cookie de depuración para el dominio actual.","ui.maintenance.debugMode.activate":"Activar","ui.maintenance.debugMode.deactivate":"Desactivar","ui.maintenance.debugMode.credentials":"Credenciales","ui.maintenance.debugMode.user":"Introduzca un nombre de usuario para el modo Debug.","ui.maintenance.debugMode.password":"Introduzca una contraseña de usuario para el modo Debug.","ui.maintenance.opcodeCache.title":"Caché Opcode","ui.maintenance.opcodeCache.description":"Opcode guarda en caché los archivos PHP en el proceso web para una ejecución más rápida. Debe borrarse bajo ciertas circunstancias si los archivos no son reconocidos después de cambiarlos.","ui.maintenance.opcodeCache.button":"Truncar caché","ui.maintenance.safeMode":"No disponible en modo seguro","ui.maintenance.unsupported":"No es compatible con su versión de Contao","ui.packages.updateButton":"Paquetes de actualización","ui.packages.searchButton":"Buscar paquetes","ui.packages.searchPlaceholder":"Buscando paquetes ...","ui.packages.uploadOverlay":"Arrastra y suelta archivos para subir","ui.packages.uploadButton":"Subir paquetes","ui.packages.uploadMessage":"Tiene una carga sin confirmar. | Tienes {count} cargas sin confirmar.","ui.packages.uploadApply":"Confirmar subidas","ui.packages.uploadReset":"Eliminar subidas","ui.packages.uploadIncomplete":"Este archivo no se cargó por completo. Elimínelo e intente nuevamente.","ui.packages.uploadDuplicate":"Este archivo parece haberse cargado varias veces. Por favor, elimine los duplicados.","ui.packages.uploadInstalled":"Este archivo ya está instalado. Por favor, elimine los duplicados.","ui.packages.uploadUnsupported":"Las cargas no son compatibles con su instalación. Asegúrese de que la extensión PHP ZIP esté instalada y actualice sus dependencias.","ui.packages.changesMessage":"Tiene un cambio sin confirmar. | Tiene {count} cambios sin confirmar.","ui.packages.changesDryrun":"Funcionamiento en seco","ui.packages.changesApply":"Aplicar cambios","ui.packages.changesApplyAll":"Actualizar todos los paquetes ","ui.packages.changesDryrunAll":"Ejecutar en seco todos los paquetes","ui.packages.changesReset":"Restablecer cambios","ui.packages.changesReview":"Revisar cambios","ui.packagelist.loading":"Cargando ...","ui.packagelist.uploads":"Subidas","ui.packagelist.added":"Neuvos paquetes","ui.packagelist.installed":"paquetes instalados","ui.package.hintRevert":"Revertir cambios","ui.package.hintNoupdate":"No actualice","ui.package.hintConstraint":"Este paquete se instalará con restricción {constraint} al aplicar los cambios.","ui.package.hintConstraintBest":"Este paquete se instalará en la mejor versión disponible cuando aplique los cambios.","ui.package.hintConstraintChange":"La restricción para este paquete cambiará de \\"{from}\\" a \\"{to}\\" cuando aplique los cambios.","ui.package.hintConstraintUpdate":"Este paquete se actualizará cuando aplique los cambios.","ui.package.hintAdded":"Este paquete se instalará cuando aplique los cambios.","ui.package.hintRemoved":"Este paquete se eliminará cuando aplique los cambios.","ui.package.requiredTitle":"agregado manualmente","ui.package.requiredText":"Este paquete es obligatorio en su composer.json pero no está instalado.","ui.package.removedTitle":"Eliminado manualmente","ui.package.removedText":"Este paquete se eliminó de su composer.json.","ui.package.installed":"Actualmente instalado:","ui.package.version":"Versión {version}","ui.package.additionalDownloads":"{count} Descargar | {count} Descargas","ui.package.additionalStars":"{count} estrella | {count} estrellas","ui.package.editConstraint":"Editar","ui.package.uploadConstraint":"Esta restricción está definida por el paquete cargado.","ui.package.updateButton":"Actualizar","ui.package.removeButton":"Eliminar","ui.package.installButton":"Agregar paquete","ui.package.installButtonShort":"Añadir","ui.package.detailsButton":"Detalles","ui.package.latestConstraint":"Última versión","ui.package.update":"Actualización disponible ","ui.package.updateLatest":"Última versión","ui.package.updateAvailable":"{version} disponible","ui.package.updateUnknown":"versión desconocida ","ui.package.updateConstraint":"Hay disponible una versión más nueva fuera de su restricción de versión.","ui.package.incompatible":"{package} no funciona con Contao {constraint}.","ui.cloudStatus.headline":"Compositor Resolver Cloud","ui.cloudStatus.version":"Versión {version}","ui.cloudStatus.waitingTime":"Tiempo de espera","ui.cloudStatus.jobs":"Trabajos actuales","ui.cloudStatus.workers":"Trabajadores","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"ninguno","ui.cloudStatus.short":"aprox. {minutes} min","ui.cloudStatus.long":"aprox. {minutes} min {seconds} seg","ui.cloudStatus.error":"No se puede obtener el estado del Composer Resolver Cloud. Puede haber una ventana de mantenimiento o problemas del sistema.","ui.cloudStatus.button":"Cloud-Status ","ui.cloudStatus.refresh":"Actualizar el Cloud-Status","ui.log-viewer.loading":"Cargando ...","ui.log-viewer.empty":"No hay archivos de registro en su servidor.","ui.log-viewer.reload":"Recargar","ui.log-viewer.file":"Archivo de registro","ui.log-viewer.channel":"Canal","ui.log-viewer.channelTitle":"El canal en el que se registró este mensaje.","ui.log-viewer.level":"Nivel","ui.log-viewer.levelTitle":"Gravedad del mensaje de registro.","ui.log-viewer.timeHeader":"Tiempo","ui.log-viewer.messageHeader":"Mensaje","ui.log-viewer.showContext":"Mostrar contenido","ui.log-viewer.hideContext":"Ocultar contenido","ui.log-viewer.showExtra":"Mostrar Extra","ui.log-viewer.hideExtra":"Ocultar Extra","ui.log-viewer.more":"Cargar más ...","ui.log-viewer.download":"Descargar","ui.log-viewer.downloadTitle":"Descargar archivo \\"{file}\\"","ui.log-viewer.prodEnvironment":"Entorno de producción","ui.log-viewer.devEnvironment":"Entorno de desarrollo (Debug Mode)","ui.user-manager.loading":"Cargando usuarios…","ui.user-manager.changePassword":"Cambiar contraseña","ui.user-manager.setupTotp":"Configurar la autenticación de dos factores","ui.user-manager.disableTotp":"Deshabilitar la autenticación de dos factores","ui.user-manager.invite":"Invitar usuario","ui.user-manager.delete":"Borrar","ui.user-manager.deleteConfirm":"¿Está seguro de que desea eliminar el usuario \\"{username}\\"?","ui.user-manager.deleted":"El usuario {username} fue eliminado exitosamente","ui.user-manager.passwordHeadline":"Cambiar contraseña","ui.user-manager.passwordText":"Para cambiar su contraseña, ingrese la contraseña actual y la nueva en los campos respectivos.","ui.user-manager.currentPassword":"Contraseña actual","ui.user-manager.newPassword":"Nueva contraseña","ui.user-manager.passwordPlaceholder":"min. 8 caracteres","ui.user-manager.submitPassword":"Enviar","ui.user-manager.passwordChanged":"Su contraseña ha sido cambiada exitosamente","ui.user-manager.passwordError":"Esta contraseña es incorrecta.","ui.user-manager.inviteHeadline":"Invitar usuario","ui.user-manager.inviteText":"Si necesita varios inicios de sesión para Contao Manager, puede crear un enlace de invitación aquí. Comparta este enlace con alguien o úselo en otro dispositivo para crear una nueva cuenta con los permisos otorgados.","ui.user-manager.inviteSuccess1":"Se ha creado un nuevo enlace de invitación. La URL que aparece a continuación se puede utilizar para crear una nueva cuenta de usuario para este administrador de cuentas. La invitación vence el {expires} (dentro de una semana).","ui.user-manager.inviteSuccess2":"Copie el enlace en su portapapeles. Solo funcionará una vez y no podra verlo nuevamente luego de cerrar este cuadro de diálogo.","ui.user-manager.createInvitation":"Crear enlace de invitación","ui.user-manager.clipboard":"Copiar al portapapeles","ui.user-manager.permissions":"Obtenga más información sobre los permisos","ui.user-manager.cancel":"Cancelar","ui.user-manager.close":"Cerrar","ui.user-manager.you":"Usted","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Autenticación de dos factores","ui.totp.setupQr":"Escanee el código QR con su aplicación 2FA/TOTP.","ui.totp.setupCode":"Si no puede escanear el código QR, ingrese esta clave en su lugar:","ui.totp.codeLabel":"Código de verificación","ui.totp.codeDescription":"Ingrese el código de verificación generado por su aplicación 2FA/TOTP.","ui.totp.disableText":"Ingrese el código de verificación para desactivar la autenticación de dos factores.","ui.totp.invalid":"El código de verificación no es válido.","ui.totp.enable":"Habilitar","ui.totp.disable":"Deshabilitar","ui.totp.cancel":"Cancelar","ui.totp.enabled":"La autenticación de dos factores se habilitó correctamente.","ui.totp.disabled":"La autenticación de dos factores se deshabilitó correctamente.","ui.totp.setup":"Configurar la autenticación de dos factores","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[518],{2518:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Extensies","ui.app.loading":"Extensie Lijst laden …","ui.app.language":"Wijzig de taal voor de Contao Manager","ui.app.colorDark":"Donkere modus","ui.app.colorDarkTitle":"Verander het kleurenschema naar donker","ui.app.colorLight":"Lichte modus","ui.app.colorLightTitle":"Verander het kleurenschema naar licht","ui.discover.advertisement":"Advertentie in de extensielijst","ui.discover.loading":"Bezig met laden ...","ui.discover.offline":"Kon geen resultaten ophalen.","ui.discover.offlineExplain":"Controleer uw internetverbinding en schakel JavaScript blokkers uit in uw browser.","ui.discover.offlineButton":"Probeer opnieuw","ui.discover.searchPlaceholder":"Zoeken in {count} extensies…","ui.discover.empty":"Geen resultaten voor {query}","ui.discover.more":"Meer resultaten","ui.discover.sortBy":"Sorteren op","ui.discover.sortReleased":"Uitgebracht","ui.discover.sortReleasedTitle":"Sorteer de resultaten op releasedatum","ui.discover.sortLatest":"Updated","ui.discover.sortLatestTitle":"Sorteer de resultaten op laatst bijgewerkt","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Sorteer resultaten op aantal downloads","ui.discover.sortFavers":"Beoordeling","ui.discover.sortFaversTitle":"Sorteer de resultaten op beoordeling","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Nieuwste en bijgewerkte extensies","ui.discover.faversPackages":"Best beoordeelde extensies","ui.discover.downloadsPackages":"Meest gedownloade extensies","ui.package.homepage":"Project Website","ui.package.private":"Privépakket","ui.package.privateTitle":"Privépakketten zijn alleen verkrijgbaar bij de leverancier (bijvoorbeeld als ZIP-download). Bezoek de website voor meer informatie.","ui.package.abandoned":"niet meer ondersteund","ui.package.abandonedText":"Dit pakket wordt niet langer ondersteund en onderhouden.","ui.package.abandonedReplace":"Dit pakket wordt niet langer ondersteund en onderhouden. De auteur stelt voor om in plaats daarvan het {vervangend} pakket te gebruiken.","ui.package.contaoVersion":"Beschikbaar voor Contao","ui.package-details.previous":"Vorige Extensie Details","ui.package-details.close":"Sluit Extensie Details","ui.package-details.loading":"Bezig met laden ...","ui.package-details.tabDescription":"Beschrijving","ui.package-details.tabRequire":"Vereisten","ui.package-details.tabFeatures":"Kenmerken","ui.package-details.tabSuggest":"Suggesties","ui.package-details.tabConflict":"Conflicten","ui.package-details.tabDependents":"Afhankelijkheden","ui.package-details.linkRequires":"vereist","ui.package-details.linkReplaces":"vervangt","ui.package-details.linkProvides":"biedt","ui.package-details.linkConflicts":"conflicten","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Ondersteunde Contao versie(s)","ui.package-details.latest":"Laatste versie","ui.package-details.released":"uitgebracht op","ui.package-details.license":"Licentie(s)","ui.package-details.authors":"van","ui.package-details.more":"Meer","ui.package-details.packagist":"Details bundel","ui.package-details.metadata":"Bewerk Metadata","ui.package-details.support_docs":"Documentatie","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support Forum","ui.package-details.support_issues":"Problemen / Foutrapport","ui.package-details.support_source":"Broncode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[851],{6851:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Connessione non sicura !!","ui.app.httpsDescription":"Senza protocollo HTTPS i tuoi dati riservati saranno trasferiti in chiaro.","ui.app.httpsLink":"Maggiori informazioni","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode abilitato!!","ui.app.safeModeDescription":"Alcune funzionalità di Contao Manager non sono disponibili.","ui.app.safeModeExit":"Esci da Safe Mode","ui.app.limitedHeadline":"Autenticazione remota","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Setup","ui.app.loading":"Caricamento Contao Manager ....","ui.app.apiError":"Stato API inaspettato","ui.app.configSecurity1":"ALLARME DI SICUREZZA! La cartella di configurazione non è protetta","ui.app.configSecurity2":"Contao Manager ha rilevato che i tuoi file di configurazione sono accessibili al pubblico. Tutte le operazioni sono disabilitate fino a quando la cartella non viene protetta e messa in sicurezza, altrimenti un malintenzionato potrebbe accedere ai dati sensibili della tua installazione.\\n\\nPer risolvere questo problema, assicurati di impedire l\'accesso alla cartella \\"contao-manager\\" sul tuo server. Per sapere come farlo, fai riferimento al manuale del tuo webserver o contatta il tuo fornitore di hosting.","ui.account.welcome":"Benvenuto","ui.account.intro1":"Benvenuto in Contao Manager, uno strumento universale per installare e gestire CMS Open Source di Contao 4. Se sei nuovo, per favore {leggiTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} per iniziare","ui.account.introManual":"leggi il manuale","ui.account.intro2":"In caso di problemi, controlla {ourGithubIssues}. Nel caso sentiti libero di creare un nuovo problema per tutto ciò che non è stato ancora segnalato.","ui.account.introIssues":"segnalazioni in GitHub","ui.account.headline":"Account utente","ui.account.description":"Per gestire l\'installazione, crea un account specifico per Contao Manager. Tieni presente che questo account non è correlato al back end o al front end di Contao.","ui.account.username":"Nome utente","ui.account.password":"Password","ui.account.passwordPlaceholder":"min. 8 caratteri","ui.account.passwordLength":"Inserisci almeno 8 caratteri.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Crea account","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao e il Contao Manager sono sponsorizzati dalla Contao Association senza scopo di lucro.","ui.account.contribute2":"Si prega di considerare di contribuire all\'open source con {donate}.","ui.account.contributeDonate":"Fare una donazione","ui.login.headline":"Registrati","ui.login.description":"Accedi per gestire la tua installazione","ui.login.username":"Nome utente","ui.login.password":"Password","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Password dimenticata?","ui.login.button":"Registrati","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Annulla","ui.login.or":"oppure","ui.login.locked":"L\'accesso è stato negato perché il Contao Manager è bloccato. Per sbloccare, cancella il file {lockFile} nella directory principale di Contao.","ui.logout.headline":"Timeout sessione","ui.logout.warning":"Sei stato inattivo per più di 25 minuti. Per motivi di sicurezza, la sessione verrà chiusa a breve.","ui.logout.expired":"La sessione è stata chiusa automaticamente perché sei stato inattivo per più di 30 minuti.","ui.logout.renew":"Mantieni il login","ui.logout.logout":"Logout","ui.logout.login":"Torna al login","ui.oauth.error":"Tentativo di OAuth non valido. Controllare i parametri della richiesta.","ui.oauth.https":"L\'URI di reindirizzamento DEVE usare un protocollo sicuro (https:) per evitare che il token di autenticazione sia trasmesso in chiaro.","ui.oauth.headline":"Autenticazione remota","ui.oauth.description":"La seguente applicazione o servizio richiede l\'accesso remoto all\'istanza di Contao Manager.","ui.oauth.domain":"Prima di permettere l\'accesso, assicurati di conoscere questo URL e di fidarti del suo proprietario!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Consenti accesso","ui.oauth.deny":"Accesso negato","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Verifica del sistema","ui.boot.description":"Per favore attendi, stiamo analizzando il tuo server...","ui.boot.issue1":"Problemi di installazione rilevati","ui.boot.issue2":"L\'installazione presenta problemi che devono essere risolti prima di poter utilizzare Contao Manager.","ui.boot.run":"Avvia Contao Manager","ui.boot.safeMode":"Avvio in modalità sicura","ui.recovery.headline":"Sistema di recupero","ui.recovery.description":"Contao Manager ha rilevato file che assomigliano a Contao, ma l\'interfaccia della riga di comando non funziona come previsto.","ui.recovery.console":"Uscita console","ui.recovery.repairOptions":"Scegliere un\'opzione per riparare l\'installazione.","ui.recovery.repairHeadline":"Riparazione automatica","ui.recovery.repairDescription":"Tentativi di riparare automaticamente l\'installazione ricostruendo la cache dell\'applicazione e reinstallando i pacchetti Composer.","ui.recovery.repairWarning":"Qualsiasi modifica ai file del fornitore potrebbe essere cancellata durante il processo!","ui.recovery.repairFailed":"La riparazione automatica non ha avuto successo. Provare la modalità provvisoria per riparare manualmente l\'installazione.","ui.recovery.repairButton":"Esegui la riparazione del sistema","ui.recovery.safeModeHeadline":"Modalità Sicura","ui.recovery.safeModeDescription":"L\'avvio di Contao Manager in modalità provvisoria consente di gestire i pacchetti ed eseguire alcune operazioni di manutenzione, ma le funzioni che si basano su un\'installazione di Contao funzionante non saranno disponibili.","ui.recovery.safeModeButton":"Avvio in modalità sicura","ui.server.pending":"In attesa ...","ui.server.running":"Analizzando ...","ui.server.error":"Verifica non riuscita a causa di una risposta imprevista dal server.","ui.server.details":"Dettagli","ui.server.prerequisite":"Verifica annullata a causa di un prerequisito mancante.","ui.server.selfUpdate.title":"Aggiornamenti di Contao Manager","ui.server.selfUpdate.update":"È disponibile una nuova versione, la {latest} di Contao Manager.","ui.server.selfUpdate.manualUpdate":"È disponibile una nuova versione di Contao Manager {latest}. Il tuo server non supporta gli aggiornamenti automatici, scarica la nuova versione da {download}.","ui.server.selfUpdate.latest":"Stai usando l\'ultima versione disponibile {current}.","ui.server.selfUpdate.dev":"Il build di sviluppo non supportano gli aggiornamenti automatici.","ui.server.selfUpdate.unsupported":"Una nuova versione è disponibile ma non supporta la versione di PHP.","ui.server.selfUpdate.button":"Eseguire l\'auto-aggiornamento","ui.server.selfUpdate.continue":"Continuare","ui.server.config.title":"Configurazione del server","ui.server.config.setup":"Configura","ui.server.config.change":"Cambiamento","ui.server.config.save":"Salva","ui.server.config.cancel":"Annulla","ui.server.config.customOption":"Altri ...","ui.server.config.description":"Per eseguire correttamente le attività in background, Contao Manager deve sapere dove trovare il binario della riga di comando PHP e come eseguire i comandi separati dal processo web.","ui.server.config.formTitle":"Configurazione del server","ui.server.config.formText":"Inserisci il percorso del file binario PHP. Assicurati che il file binario PHP sia la stessa versione del processo del web server.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud consente di installare le dipendenze di Composer anche se il server non fornisce memoria locale sufficiente. Si noti che le informazioni del pacchetto verranno trasmesse a un server cloud gestito dalla Contao Association.","ui.server.config.cloud":"Utilizza Composer Resolver Cloud","ui.server.config.cli":"PHP binario","ui.server.config.stateErrorCli":"Nessun binario PHP valido è stato trovato sul server.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud  non è supportato.","ui.server.config.stateSuccess":"Binario PHP in {php_cli}.","ui.server.php_web.title":"Processo Web PHP","ui.server.php_web.below7":"Trovata la versione di PHP {version}. Si prega di passare a PHP 7 il più presto possibile!","ui.server.php_web.success":"Trovata la versione di PHP {version}, non sono stati trovati problemi noti.","ui.server.php_cli.title":"Interfaccia a riga di comando PHP","ui.server.php_cli.success":"Trovata la versione di PHP {version}, non sono stati trovati problemi noti.","ui.server.composer.title":"Ambiente Composer","ui.server.composer.success":"Non sono stati trovati problemi noti.","ui.server.composer.install":"Le dipendenze del Composer non sono installate.","ui.server.composer.button":"Installa","ui.server.contao.title":"Installazione Contao","ui.server.contao.setup":"Setup","ui.server.contao.check":"Verifica il database","ui.server.contao.empty":"Non è stata trovata alcuna installazione di Contao.","ui.server.contao.old":"La versione {version} di Contao non è compatibile con Contao Manager, aggiorna manualmente l\'installazione.","ui.server.contao.found":"Trovato Contao {version} (versione API {api}).","ui.server.contao.connectionError":"Impossibile connettersi al server del database.","ui.server.contao.connectionProblem":"È stato trovato problema con il database.","ui.server.contao.missingUser":"Account amministratore non trovato.","ui.setup.continue":"Continuare","ui.setup.manager":"Avvia Contao Manager","ui.setup.cancel":"Annulla","ui.setup.welcome":"Benvenuto","ui.setup.welcome1":"Questa procedura guidata ti guiderà attraverso i passaggi necessari per configurare l\'installazione del tuo Contao CMS Open Source.","ui.setup.welcome2":"In caso di domande, puoi consultare la documentazione, forum, un canale Slack e altro nella pagina {support}.","ui.setup.support":"Supporto dalla comunità","ui.setup.start":"Iniziamo","ui.setup.complete":"Congratulazioni!","ui.setup.complete1":"Contao {version} è stato installato correttamente.","ui.setup.complete2":"Per completare il processo d\'installazione, apri lo strumento di installazione per configurare la connessione al database e creare un utente back-end.","ui.setup.complete3":"Ora puoi iniziare a creare il tuo sito web nel back-end di Contao. Se hai bisogno di ulteriori estensioni, vai su Contao Manager.","ui.setup.installTool":"Apri l\'Install Tool","ui.setup.login":"Effettua il login in Contao","ui.setup.funding":"Il software libero è \\"libero\\" come in \\"libertà di parola\\", non come in \\"birra gratis\\". Un progetto Open Source come Contao richiede somme di denaro che non possono essere raccolte da una singola persona o azienda.\\nSe hai un sito web o vendi siti web realizzati con Contao, ci piacerebbe vederti contribuire finanziariamente al prodotto su cui fa affidamento la tua attività.","ui.setup.fundingLink":"Scopri di più","ui.setup.document-root.headline":"Setup Webserver ","ui.setup.document-root.warning":"Per installare Contao tramite Contao Manager, è necessario correggere la document root sul server Web.","ui.setup.document-root.description1":"Contao utilizza una cartella separata per i file pubblici, i file dell\'applicazione vengono installati nella sua cartella principale. Contao non può essere installato se la struttura delle cartelle non è corretta o le cartelle non sono vuote.","ui.setup.document-root.description2":"Se non sai come configurare la document root, leggi la documentazione Contao o contatta il tuo provider di hosting.","ui.setup.document-root.documentation":"Leggi la documentazione","ui.setup.document-root.conflictsTitle":"La directory di installazione non è vuota","ui.setup.document-root.conflictsDirectory":"La directory principale della tua futura installazione di Contao non è vuota, abbiamo trovato {count} files che potrebbero essere sovrascritti dal processo di installazione. Si consiglia di creare una struttura di directory vuota per Contao, ma puoi anche rimuovere i seguenti file e ricontrollare se sei sicuro che non siano utilizzati.","ui.setup.document-root.ignoreConflicts":"Voglio installare Contao nella directory non vuota. Capisco che questo potrebbe sovrascrivere qualsiasi file esistente sul mio spazio web.","ui.setup.document-root.check":"Controlla nuovamente","ui.setup.document-root.create":"Creare elenchi","ui.setup.document-root.change":"Cambia directory","ui.setup.document-root.formTitle":"Setup cartella","ui.setup.document-root.formText1":"Contao Manager può creare automaticamente una nuova struttura di directory sul server.","ui.setup.document-root.formText2":"Dovrai configurare manualmente la nuova root document (ad es. Tramite un pannello di amministrazione di hosting).","ui.setup.document-root.autoconfig":"Comprendo che devo modificare la configurazione del mio server. La mancata configurazione della document root  interromperà Contao Manager ed esporrà i file di configurazione (inclusi i dettagli dell\'account e le password)!","ui.setup.document-root.directory":"Nuova directory","ui.setup.document-root.currentRoot":"Document root corrente","ui.setup.document-root.newRoot":"Nuova document root","ui.setup.document-root.finish":"Cartella di installazione","ui.setup.document-root.publicDir":"Usare {dir} per i file pubblici (per Contao {versione})","ui.setup.document-root.directoryInvalid":"Inserisci un nome di directory valido.","ui.setup.document-root.directoryExists":"La cartella di destinazione esiste già. Per favore, inserisci un nome diverso.","ui.setup.document-root.confirmation":"Contao Manager ha creato correttamente la cartella necessaria per l\'installazione di Contao. Ora devi configurare la radice del documento sul tuo server web. Non ricaricare questa pagina fino ad allora.","ui.setup.document-root.reload":"Ricarica pagina","ui.setup.document-root.success":"La struttura delle directory sul tuo server web è impostata correttamente!","ui.setup.document-root.installingProjectDir":"I file dell\'applicazione verranno installati in {dir}.","ui.setup.document-root.installingPublicDir":"I file pubblici verranno installati in {dir}.","ui.setup.document-root.installedProjectDir":"I file dell\'applicazione vengono installati in {dir}.","ui.setup.document-root.installedPublicDir":"I file pubblici vengono installati in {dir}.","ui.setup.create-project.headline":"Installazione Contao","ui.setup.create-project.description":"Lo sviluppo di Contao segue il principio di {semver}, una nuova versione minore viene rilasciata ogni sei mesi. Le versioni attualmente supportate sono:","ui.setup.create-project.semver":"Versione semantica","ui.setup.create-project.latestTitle":"Più recente","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"La nostra ultima versione offre la maggior parte delle funzionalità con supporto fino a febbraio {anno}.","ui.setup.create-project.latestQ3":"La nostra ultima versione offre la maggior parte delle funzionalità con supporto fino ad agosto {year}.","ui.setup.create-project.ltsText":"La nostra attuale versione LTS, è focalizzata al mantenimento della stabilità. Offre supporto a lungo termine fino a febbraio {year}.","ui.setup.create-project.pltsText":"La precedente versione LTS ha ancora il supporto a lungo termine fino a febbraio {year}.","ui.setup.create-project.requiresPHP":"Richiede almeno PHP {version}, tu hai PHP {current}.","ui.setup.create-project.releaseplan":"Vedi {contaoReleasePlan} per informazioni dettagliate.","ui.setup.create-project.releaseplanLink":"Piano di rilascio Contao","ui.setup.create-project.installed":"Contao  {version}  è stato installato correttamente sul server. Continua a configurare il tuo database o avvia Contao Manager per installare una versione diversa.","ui.setup.create-project.formTitle":"Seleziona una distribuzione","ui.setup.create-project.formText":"Scegliere quale versione deve essere installata.","ui.setup.create-project.version":"Versione","ui.setup.create-project.demo":"Installa il sito Web demo di Contao","ui.setup.create-project.demoDescription":"Il sito Web demo ti aiuta a familiarizzare con Contao e tutte le sue funzionalità principali. Altri temi possono essere trovati in {store}.","ui.setup.create-project.coreOnly":"Installazione minima (solo core)","ui.setup.create-project.noUpdate":"Salta l\'installazione (soltanto per esperti!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"Per installare un tema Contao, utilizza l\'input di ricerca o carica un file del tema (.cto/.zip) che supporti l\'installazione tramite Contao Manager.","ui.setup.create-project.themeBuy":"Assicurati di visitare lo {store} ufficiale.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"Il file caricato non è un tema Contao o non supporta Contao Manager.","ui.setup.create-project.themeWarning":"Contao Manager non è in grado di stabilire se questo tema è compatibile con il tuo server. Per eventuali domande, contatta il fornitore del tema.","ui.setup.create-project.themeTitle":"Esamina i dettagli del tema","ui.setup.create-project.themeDetails":"Con questo tema verranno installati le seguenti dipendenze e file.","ui.setup.create-project.themeRequire":"{count} Dipendenze | {count} Dipendenze","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"oppure cerca dei temi pubblici","ui.setup.create-project.theme.search":"Cerca un tema","ui.setup.create-project.theme.more":"Più temi","ui.setup.create-project.theme.empty":"Nessun tema corrispondente {query}","ui.setup.create-project.theme.uploaded":"Il file del tema è stato caricato correttamente.","ui.setup.create-project.theme.packageName":"Nome Package","ui.setup.create-project.theme.version":"Versione","ui.setup.create-project.theme.authors":"Autore/i","ui.setup.create-project.install":"Installa","ui.setup.create-project.cancel":"Annulla","ui.setup.database-connection.headline":"Connessione al database","ui.setup.database-connection.description":"Contao richiede un database MySQL (o un fork compatibile come MariaDB) per memorizzare pagine, contenuti, utenti e altri dati relazionali. I parametri di connessione sono memorizzati nel file {env} nella radice del progetto dell\'installazione di Contao.","ui.setup.database-connection.formTitle":"Parametri connessione","ui.setup.database-connection.formText":"Immettere l\'URL di un database o compilare separatamente i campi nome utente, password, server e database.","ui.setup.database-connection.url":"URL Database","ui.setup.database-connection.validUrl":"URL Database non valido o connessione al server fallita.","ui.setup.database-connection.or":"oppure","ui.setup.database-connection.user":"Nome utente","ui.setup.database-connection.password":"Password","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Nome del database","ui.setup.database-connection.connected":"Connessione riuscita al database {database} sul {server}.","ui.setup.database-connection.error":"Errore di connessione al database","ui.setup.database-connection.problem":"Contao ha rilevato un problema con il database server.","ui.setup.database-connection.schemaTitle":"Schema Database ","ui.setup.database-connection.migration":"C\'è una migrazione in sospeso. | Ci sono {count} migrazioni in sospeso.","ui.setup.database-connection.schema":"È presente un aggiornamento dello schema in sospeso. | Ci sono {count} aggiornamenti dello schema in sospeso.","ui.setup.database-connection.noChanges":"Lo schema del database è aggiornato.","ui.setup.database-connection.check":"Verifica il database","ui.setup.database-connection.skip":"Salta","ui.setup.database-connection.save":"Salva","ui.setup.database-connection.change":"Modifica le credenziali","ui.setup.database-connection.restoreTitle":"Importazione del database","ui.setup.database-connection.restoreText":"Il tema che hai appena installato contiene un backup del database. Ripristina il database per importare i dati del tema o salta questo passaggio per iniziare con un\'installazione vuota di Contao. | Il tema che hai appena installato contiene più backup di database. Seleziona un file di backup per importare i dati del tema o salta questo passaggio per iniziare con un\'installazione vuota di Contao.","ui.setup.database-connection.backup":"Eseguire il backup del database corrente prima dell\'importazione","ui.setup.database-connection.backupWarning":"Tutti i dati nel database verranno sovrascritti durante l\'importazione! Creare prima un backup se il database non è vuoto.","ui.setup.database-connection.restore":"Importa il database dei temi","ui.setup.database-connection.restoreOption":"Backup del {date} ({size})","ui.setup.database-connection.restored":"Il database del tuo tema è stato importato con successo. Continua con la convalida dello schema del database.","ui.setup.backend-user.success":"Nel tuo database è stato trovato un account amministratore per il back-end Contao. Usa il back-end Contao per aggiungere più utenti.","ui.setup.backend-user.error":"Impossibile recuperare l\'elenco degli utenti. Controlla l\'output della console per i dettagli.","ui.setup.backend-user.headline":"Utente di backend ","ui.setup.backend-user.description":"Per gestire il tuo sito web, devi avere almeno un account amministratore per il back-end di Contao. Tieni presente che questo account non è correlato a Contao Manager.","ui.setup.backend-user.formTitle":"Crea account","ui.setup.backend-user.formText":"Inserisci i dettagli per il nuovo account back-end.","ui.setup.backend-user.username":"Nome utente","ui.setup.backend-user.name":"Nome","ui.setup.backend-user.email":"Indirizzo e-mail","ui.setup.backend-user.emailInvalid":"Inserisci un indirizzo email valido","ui.setup.backend-user.password":"Password","ui.setup.backend-user.passwordPlaceholder":"min. 8 caratteri","ui.setup.backend-user.passwordLength":"Inserisci almeno 8 caratteri.","ui.setup.backend-user.create":"Aggiungi account","ui.task.headline":"Task in background ","ui.task.loading":"Caricamento dettagli…","ui.task.created":"Caricamento dettagli…","ui.task.active":"Attendere che Contao Manager esegua operazioni in background.","ui.task.complete":"Tutte le operazioni sono state completate correttamente. Controllare l\'output della console per i dettagli.","ui.task.paused":"Un\'operazione in background si è interrotta inaspettatamente. Controlla l\'output della console.","ui.task.aborting":"Attendi mentre le operazioni in background vengono annullate.","ui.task.stopped":"Alcune operazioni in background sono state annullate. Controlla l\'output della console.","ui.task.error":"Un\'operazione in background si è interrotta inaspettatamente. Controlla l\'output della console.","ui.task.failed":"Il Contao Manager non è riuscito ad avviare un\'attività in background!","ui.task.failedDescription1":"Qualcosa è andato storto durante il tentativo di eseguire operazioni in background.","ui.task.failedDescription2":"In questo caso, il tuo server potrebbe non essere supportato.","ui.task.reportProblem":"Segnala un problema","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsorizzato da {sponsor}","ui.task.buttonAudit":"Aggiorna il database","ui.task.buttonClose":"Chiudi","ui.task.buttonConfirm":"Conferma e chiudi","ui.task.buttonContinue":"Continuare","ui.task.buttonCancel":"Annulla","ui.task.confirmCancel":"Sei sicuro di annullare questo compito? Questo potrebbe lasciare l\'installazione di Contao in uno stato danneggiato!","ui.task.autoclose":"Chiudi i dettagli dell\'attività in caso di successo","ui.console.toggle":"Visualizza/nasconde l\'uscita console","ui.console.showLog":"Mostra il registro completo della console","ui.console.copyLog":"Copia il registro negli appunti","ui.migrate.headline":"Aggiornamenti del database","ui.migrate.migrationsOnly":"(solo migrazioni)","ui.migrate.schemaOnly":"(solo schema)","ui.migrate.loading":"Attendi, stiamo controllando il database...","ui.migrate.empty":"Non è stato trovato nessuna migrazione in sospeso o aggiornamento dello schema. Il tuo database è aggiornato.","ui.migrate.emptyMigrations":"Non è stata trovata nessuna migrazione in sospeso. Controlla anche gli aggiornamenti dello schema.","ui.migrate.emptySchema":"Non è stato trovato nessun aggiornamento dello schema in sospeso. Assicurati di controllare anche le migrazioni.","ui.migrate.pending":"Il tuo database non è aggiornato. Si prega di rivedere l\'output della console di seguito ed eseguire le modifiche.","ui.migrate.previousChanges":"Una precedente migrazione del database non è stata confermata.\\nRivedi l\'output della console di seguito, quindi continua per vedere le modifiche successive.","ui.migrate.previousComplete":"Una precedente migrazione del database non è stata confermata, controlla l\'output della console di seguito.\\nNon ci sono più modifiche in sospeso.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Gli aggiornamenti del database sono stati applicati.\\nNon ci sono più migrazioni in sospeso o aggiornamenti dello schema. Il tuo database è aggiornato.","ui.migrate.problem":"Contao ha rilevato un problema con il database server.\\nSi prega di rivedere l\'output della console di seguito per scoprire cosa deve essere risolto. | Contao ha rilevato problemi con il database server.\\nSi prega di rivedere l\'output della console di seguito per scoprire cosa deve essere risolto.","ui.migrate.warning":"Contao ha rilevato una configurazione errata del database server.\\nGli avvisi possono essere ignorati temporaneamente, ma dovrebbero essere corretti per prestazioni e integrità dei dati ottimali.","ui.migrate.error":"Impossibile applicare le modifiche. Il tuo database potrebbe essere stato modificato, controlla di nuovo per riprovare.","ui.migrate.execute":"Esegui","ui.migrate.close":"Chiudi","ui.migrate.confirm":"Conferma e chiudi","ui.migrate.cancel":"Annulla","ui.migrate.continue":"Continuare","ui.migrate.setup":"Setup","ui.migrate.skip":"Salta","ui.migrate.retry":"Controlla nuovamente","ui.migrate.retryAll":"Seleziona tutto","ui.migrate.withDeletes":"Esegui tutte le modifiche al database comprese le query DROP.","ui.migrate.migrationTitle":"Migrazioni del database","ui.migrate.schemaTitle":"Aggiornamenti dello schema","ui.migrate.problemTitle":"Problemi al database","ui.migrate.warningTitle":"Avvisi sul database","ui.migrate.addTable":"Aggiungi tabella {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Aggiungi campo {table}.{field}","ui.migrate.changeField":"Cambia campo  {table}.{field}","ui.migrate.dropField":"Elimina campo {table}.{field}","ui.migrate.createIndex":"Crea indice \\"{name}\\" in {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" in {table}","ui.widget.mandatory":"Questo campo non deve essere vuoto.","ui.widget.blankOption":"Selezionare ...","ui.widget.showPassword":"Mostra password","ui.widget.hidePassword":"Nascondi password","ui.error.title":"Richiesta HTTP per \\"{metodo} {url}\\" fallita.","ui.error.server500":"Sembra che si sia verificato un errore imprevisto sul server. Controllare i file di log del proprio server web (Apache/Nginx) e i log di Contao Manager in \\"contao-manager/logs\\".","ui.error.response":"Il server ha restituito una risposta con il codice di stato {status}.","ui.error.moreLink":"Maggiori informazioni","ui.error.support":"Supporto Contao ","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Supporto","ui.footer.reportProblem":"Segnala un problema","ui.navigation.discover":"Scopri","ui.navigation.packages":"Pacchetti","ui.navigation.tools":"Strumenti","ui.navigation.installTool":"Strumento di installazione","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Modalità Debug Contao","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informazioni PHP","ui.navigation.phpinfoLoading":"Caricamento informazioni PHP","ui.navigation.maintenance":"Manutenzione","ui.navigation.rebuildCache":"Ricostruisci la cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Verifica del sistema","ui.navigation.advanced":"Avanzato","ui.navigation.logout":"Logout","ui.maintenance.database.title":"Database Migrations e Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"Una migrazione del database in sospeso | {count} migrazioni database in sospeso","ui.maintenance.database.schemaUpdates":"Un aggiornamento dello schema in sospeso | {count} aggiornamenti dello schema in attesa","ui.maintenance.database.error":"È stato trovato problema con il database.","ui.maintenance.database.warning":"Sono stati trovati degli avvisi del database","ui.maintenance.database.button":"Verifica il database","ui.maintenance.database.migrationOnly":"Controlla solo le migrazioni","ui.maintenance.database.schemaOnly":"Controlla solo lo schema","ui.maintenance.database.installTool":"Apri l\'Install Tool","ui.maintenance.database.createBackup":"Creare il backup","ui.maintenance.database.backupUnsupported":"I backup del database non sono supportati dalla tua versione di Contao.","ui.maintenance.database.backupList":"Hai un backup del database, creato il {date}. | Hai {count} backup del database, l\'ultimo è stato creato il {date}.","ui.maintenance.database.backupEmpty":"Al momento non hai backup del database.","ui.maintenance.rebuildCache.title":"Cache applicazione ","ui.maintenance.rebuildCache.description":"La ricostruzione della cache dell\'applicazione è necessaria dopo aver modificato uno qualsiasi dei file di configurazione.","ui.maintenance.rebuildCache.rebuildProd":"Ricostruire la cache di produzione","ui.maintenance.rebuildCache.rebuildDev":"Ricostruire la cache di sviluppo","ui.maintenance.rebuildCache.clearProd":"Cancella cache di produzione","ui.maintenance.rebuildCache.clearDev":"Cancella cache di sviluppo","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"Lo strumento di installazione Contao viene bloccato automaticamente se si immette una password errata per tre volte di seguito.","ui.maintenance.installTool.unlock":"Sblocca Install Tool","ui.maintenance.installTool.lock":"Blocca Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Il Composer autoloader è responsabile del caricamento della classe PHP. L\'autoloader deve essere scaricato solo dopo aver aggiunto i namespaces personalizzati nella root del composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dipendenze Composer","ui.maintenance.composerInstall.description":"Le dipendenze del Composer si trovano nella cartella {vendor} nella radice dell\'applicazione. La reinstallazione delle dipendenze può essere necessaria dopo la modifica o il caricamento manuale del file {composerLock}.","ui.maintenance.composerInstall.button":"Esegui Installer","ui.maintenance.composerInstall.update":"Esegui l\'aggiornamento Composer","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer mette in cache i pacchetti scaricati per migliorare le prestazioni. Se hai problemi con i file rotti, prova a cancellare la cache del Composer per forzare un nuovo download.","ui.maintenance.composerCache.button":"Cancella cache","ui.maintenance.maintenanceMode.title":"Modalità di manutenzione","ui.maintenance.maintenanceMode.description":"Mettendo Contao in modalità manutenzione, verrà visualizzato un modello \\"503 Service Unavailable\\" per il sito web.","ui.maintenance.maintenanceMode.enable":"Attiva","ui.maintenance.maintenanceMode.disable":"Disattiva","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Attiva la modalità debug impostando un utente e una password per il punto di ingresso {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Attiva la modalità debug impostando il cookie di debug per il dominio corrente.","ui.maintenance.debugMode.activate":"Attivare","ui.maintenance.debugMode.deactivate":"Disattiva","ui.maintenance.debugMode.credentials":"Credenziali","ui.maintenance.debugMode.user":"Inserisci un nome utente per la modalità di debug.","ui.maintenance.debugMode.password":"Inserisci una password per la modalità di debug.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"Opcode mette in cache i file PHP sul processo web per un\'esecuzione più veloce. Deve essere cancellato in determinate circostanze se i file non vengono riconosciuti dopo la modifica.","ui.maintenance.opcodeCache.button":"Troncare la cache","ui.maintenance.safeMode":"Non disponibile in modalità Safe Mode","ui.maintenance.unsupported":"Non supportato dalla tua versione di Contao","ui.packages.updateButton":"Aggiorna pacchetti","ui.packages.searchButton":"Cerca pacchetti","ui.packages.searchPlaceholder":"Cerca pacchetti...","ui.packages.uploadOverlay":"Drag & drop files per caricarli","ui.packages.uploadButton":"Carica pacchetti","ui.packages.uploadMessage":"Hai una modifica non confermata. | Hai {count} modifiche non confermate.","ui.packages.uploadApply":"Conferma uploads","ui.packages.uploadReset":"Elimina Uploads","ui.packages.uploadIncomplete":"Questo file non è stato caricato completamente. Rimuovilo e riprova.","ui.packages.uploadDuplicate":"Questo file sembra essere caricato più volte. Rimuovi i duplicati.","ui.packages.uploadInstalled":"Questo file è già installato. Rimuovi i duplicati.","ui.packages.uploadUnsupported":"I caricamenti non sono supportati nella tua installazione. Assicurati che l\'estensione PHP ZIP sia installata e aggiorna le dipendenze.","ui.packages.changesMessage":"Hai una modifica non confermata. | Hai {count} modifiche non confermate.","ui.packages.changesDryrun":"Esecuzione a prova","ui.packages.changesApply":"Applicare le modifiche","ui.packages.changesApplyAll":"Aggiornare tutti i pacchetti","ui.packages.changesDryrunAll":"Esecuzione a prova di tutti i pacchetti","ui.packages.changesReset":"Ripristina modifiche","ui.packages.changesReview":"Revisione dei cambiamenti","ui.packagelist.loading":"Caricamento in corso ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Pacchetti nuovi","ui.packagelist.installed":"Pacchetti installati","ui.package.hintRevert":"Ripristina le modifiche","ui.package.hintNoupdate":"Non aggiornare","ui.package.hintConstraint":"Questo pacchetto sarà installato con vincolo {constraint} quando si applicano le modifiche.","ui.package.hintConstraintBest":"Questo pacchetto sarà installato nella migliore versione disponibile quando si applicano le modifiche.","ui.package.hintConstraintChange":"Il vincolo per questo pacchetto sarà cambiato da \\"{from}\\" a \\"{to}\\" quando si applicano le modifiche.","ui.package.hintConstraintUpdate":"Questo pacchetto sarà aggiornato quando si applicano le modifiche.","ui.package.hintAdded":"Questo pacchetto sarà aggiornato quando si applicano le modifiche.","ui.package.hintRemoved":"Questo pacchetto verrà rimosso quando si applicano le modifiche. ","ui.package.requiredTitle":"aggiunto manualmente","ui.package.requiredText":"Questo pacchetto è richiesto nel tuo composer.json ma non è installato.","ui.package.removedTitle":"rimosso manualmente","ui.package.removedText":"Questo pacchetto è stato rimosso dal tuo composer.json.","ui.package.installed":"Attualmente installato:","ui.package.version":"Versione {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Stella | {count} Stelle","ui.package.editConstraint":"Modifica","ui.package.uploadConstraint":"Questo vincolo è definito dal pacchetto caricato.","ui.package.updateButton":"Aggiorna","ui.package.removeButton":"Rimuovi","ui.package.installButton":"Aggiungi pacchetto","ui.package.installButtonShort":"Aggiungi","ui.package.detailsButton":"Dettagli","ui.package.latestConstraint":"ultima versione","ui.package.update":"Aggiornamento disponibile","ui.package.updateLatest":"ultima versione","ui.package.updateAvailable":"{versione} disponibile","ui.package.updateUnknown":"versione sconosciuta","ui.package.updateConstraint":"È disponibile una versione più recente al di fuori del vincolo di versione.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versione {version}","ui.cloudStatus.waitingTime":"Tempo di attesa","ui.cloudStatus.jobs":"Lavori correnti","ui.cloudStatus.workers":"Lavoratori","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nessuna","ui.cloudStatus.short":"circa {minutes} min","ui.cloudStatus.long":"circa {minutes} min {seconds} sec","ui.cloudStatus.error":"Impossibile ottenere lo stato del Composer Resolver Cloud. Potrebbe essere inattivo per problemi di manutenzione o di esercizio.","ui.cloudStatus.button":"Stato Cloud","ui.cloudStatus.refresh":"Aggiorna lo stato del cloud","ui.log-viewer.loading":"Caricamento in corso ...","ui.log-viewer.empty":"Non ci sono file di registro sul tuo server.","ui.log-viewer.reload":"Ricarica","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Canale","ui.log-viewer.channelTitle":"Il canale su cui è stato registrato questo messaggio.","ui.log-viewer.level":"Livello","ui.log-viewer.levelTitle":"Gravità del messaggio di log.","ui.log-viewer.timeHeader":"Tempo","ui.log-viewer.messageHeader":"Messaggio","ui.log-viewer.showContext":"Mostra contesto","ui.log-viewer.hideContext":"Nascondi contesto","ui.log-viewer.showExtra":"Mostra extra","ui.log-viewer.hideExtra":"Nascondi extra","ui.log-viewer.more":"Carica di più…","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Ambiente di produzione","ui.log-viewer.devEnvironment":"Ambiente di sviluppo (Modalità Debug)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 caratteri","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Annulla","ui.user-manager.close":"Chiudi","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Attiva","ui.totp.disable":"Disattiva","ui.totp.cancel":"Annulla","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[909],{3909:function(e,i,o){o.r(i),o.d(i,{default:function(){return C}});var t=o(641),n=o(3751),s=o(33),l=o(6894);const a={key:0,class:"view-login__locked"},r={key:0,class:"view-login__form"},g={class:"view-login__headline"},d={class:"view-login__description"},u={class:"view-login__or"},p=["href"],c={key:1,class:"view-login__form"},_={class:"view-login__headline"},h={class:"view-login__description"};function m(e,i,o,m,k,w){const b=(0,t.g2)("i18n-t"),f=(0,t.g2)("text-field"),v=(0,t.g2)("loading-button"),y=(0,t.g2)("boxed-layout");return(0,t.uX)(),(0,t.Wv)(y,{slotClass:"view-login"},{default:(0,t.k6)((()=>[i[7]||(i[7]=(0,t.Lk)("header",{class:"view-login__header"},[(0,t.Lk)("img",{src:l,width:"80",height:"80",alt:"Contao Logo"}),(0,t.Lk)("p",{class:"view-login__product"},"Contao Manager")],-1)),e.locked?((0,t.uX)(),(0,t.CE)("main",a,[(0,t.bF)(b,{tag:"p",keypath:"ui.login.locked"},{lockFile:(0,t.k6)((()=>i[6]||(i[6]=[(0,t.Lk)("strong",null,"contao-manager/login.lock",-1),(0,t.Lk)("br",null,null,-1)]))),_:1})])):((0,t.uX)(),(0,t.Wv)(n.eB,{key:1,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,t.k6)((()=>[e.requires_totp?((0,t.uX)(),(0,t.CE)("main",c,[(0,t.Lk)("form",{onSubmit:i[5]||(i[5]=(0,n.D$)((function(){return w.login&&w.login(...arguments)}),["prevent"]))},[(0,t.Lk)("h1",_,(0,s.v_)(e.$t("ui.login.totpHeadline")),1),(0,t.Lk)("p",h,(0,s.v_)(e.$t("ui.login.totpDescription")),1),(0,t.bF)(f,{name:"totp",required:"",minlength:"6",maxlength:"6",autocomplete:"one-time-code",label:e.$t("ui.login.totp"),placeholder:e.$t("ui.login.totp"),class:(0,s.C4)(["view-login__totp",e.login_failed?"widget--error":""]),disabled:e.logging_in,modelValue:e.totp,"onUpdate:modelValue":i[3]||(i[3]=i=>e.totp=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(v,{submit:"",class:"view-login__button",color:"primary",disabled:!w.totpValid||e.login_failed,loading:e.logging_in},{default:(0,t.k6)((()=>[(0,t.eW)((0,s.v_)(e.$t("ui.login.button")),1)])),_:1},8,["disabled","loading"]),(0,t.Lk)("button",{class:"widget-button view-login__button",onClick:i[4]||(i[4]=function(){return w.cancelTotp&&w.cancelTotp(...arguments)})},(0,s.v_)(e.$t("ui.login.cancel")),1)],32)])):((0,t.uX)(),(0,t.CE)("main",r,[(0,t.Lk)("form",{onSubmit:i[2]||(i[2]=(0,n.D$)((function(){return w.login&&w.login(...arguments)}),["prevent"]))},[(0,t.Lk)("h1",g,(0,s.v_)(e.$t("ui.login.headline")),1),(0,t.Lk)("p",d,(0,s.v_)(e.$t("ui.login.description")),1),(0,t.bF)(f,{ref:"username",name:"username",autocomplete:"username webauthn",label:e.$t("ui.login.username"),placeholder:e.$t("ui.login.username"),class:(0,s.C4)(["view-login__user",e.login_failed?"widget--error":""]),disabled:e.logging_in||e.passkey_login,modelValue:e.username,"onUpdate:modelValue":i[0]||(i[0]=i=>e.username=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(f,{type:"password",name:"password",autocomplete:"current-password",label:e.$t("ui.login.password"),placeholder:e.$t("ui.login.password"),minlength:"8",class:(0,s.C4)(["view-login__password",e.login_failed?"widget--error":""]),disabled:e.logging_in||e.passkey_login,modelValue:e.password,"onUpdate:modelValue":i[1]||(i[1]=i=>e.password=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(v,{submit:"",class:"view-login__button",color:"primary",disabled:!w.inputValid||e.login_failed||e.passkey_login,loading:e.logging_in&&!e.passkey_login},{default:(0,t.k6)((()=>[(0,t.eW)((0,s.v_)(e.$t("ui.login.button")),1)])),_:1},8,["disabled","loading"]),(0,t.Lk)("p",u,(0,s.v_)(e.$t("ui.login.or")),1),e.showPasskey?((0,t.uX)(),(0,t.Wv)(v,{key:0,class:"view-login__button",icon:"passkey",color:"primary",loading:e.passkey_login,disabled:e.logging_in,onClick:(0,n.D$)(w.passkeyLogin,["prevent"])},{default:(0,t.k6)((()=>[(0,t.eW)((0,s.v_)(e.$t("ui.login.passkey")),1)])),_:1},8,["loading","disabled","onClick"])):(0,t.Q3)("",!0),(0,t.Lk)("a",{href:`https://to.contao.org/docs/manager-password?lang=${e.$i18n.locale}`,target:"_blank",class:"view-login__link"},(0,s.v_)(e.$t("ui.login.forgotPassword")),9,p)],32)]))])),_:1}))])),_:1})}var k=o(6278),w=o(60),b=o(707),f=o(728),v=o(9757),y=o(85),$={components:{BoxedLayout:f.A,TextField:v.A,LoadingButton:y.A},data:()=>({username:"",password:"",totp:"",logging_in:!1,passkey_login:!1,requires_totp:!1,login_failed:!1,showPasskey:!1}),computed:{...(0,k.aH)(["locked"]),inputValid(){return""!==this.username&&""!==this.password&&this.password.length>=8},totpValid(){return""!==this.totp&&/^\d{6}$/.test(this.totp)}},methods:{async login(){this.inputValid&&this.doLogin({username:this.username,password:this.password,totp:this.totp})},async passkeyLogin(e){let{useBrowserAutofill:i}=e;this.passkey_login=!i;const o=(await this.$request.get("api/session/options")).data;try{const e=await(0,w.HS)({optionsJSON:o,useBrowserAutofill:!!i});await this.doLogin({passkey:JSON.stringify(e)})}catch(t){}this.passkey_login=!1},async doLogin(e){this.logging_in=!0;const i=await this.$store.dispatch("auth/login",e);201===i.status?this.$store.commit("setView",b.A.BOOT):401===i.status&&i.data.totp_enabled?(this.logging_in=!1,this.requires_totp=!0,this.login_failed=!!this.totp):(this.logging_in=!1,this.login_failed=!0)},reset(){this.login_failed=!1},cancelTotp(){this.username="",this.password="",this.totp="",this.logging_in=!1,this.requires_totp=!1,this.login_failed=!1}},async mounted(){if(this.$store.commit("setError",null),this.locked)return;if(this.$refs.username&&this.$refs.username.focus(),"https:"!==location.protocol)return void(this.showPasskey=!1);const e=(0,w.zZ)(),i=await(0,w.ZF)();this.showPasskey=e,e&&i&&this.passkeyLogin({useBrowserAutofill:!0})}},L=o(6262);const V=(0,L.A)($,[["render",m]]);var C=V}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[553],{5553:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Insecure Connection !!","ui.app.httpsDescription":"Without HTTPS your confidential data will be transferred unencrypted.","ui.app.httpsLink":"More Info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.limitedHeadline":"Remote Authentication","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Setup","ui.app.loading":"Loading Contao Manager …","ui.app.apiError":"Unexpected API status","ui.app.configSecurity1":"SECURITY ALERT !!! Unprotected config directory detected","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Welcome","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"User Account","ui.account.description":"To manage your installation, please create an account for the Contao Manager. Be aware that this account is not related to the Contao back end or front end.","ui.account.username":"Username","ui.account.password":"Password","ui.account.passwordPlaceholder":"min. 8 characters","ui.account.passwordLength":"Please enter at least 8 characters.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Create Account","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"Sign In","ui.login.description":"Login to manage your installation.","ui.login.username":"Username","ui.login.password":"Password","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Forgot your password?","ui.login.button":"Sign In","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Cancel","ui.login.or":"or","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Session Timeout","ui.logout.warning":"Your have been inactive for more than 25 minutes. For security reasons your session will be terminated shortly.","ui.logout.expired":"Your session was automatically terminated because you have been inactive for more than 30 minutes.","ui.logout.renew":"Keep Logged In","ui.logout.logout":"Logout","ui.logout.login":"Back To Login","ui.oauth.error":"Invalid OAuth attempt. Check the request parameters.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"The following application or service is requesting remote access to your Contao Manager instance.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Allow Access","ui.oauth.deny":"Deny Access","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"System Check","ui.boot.description":"Please wait, we are analyzing your server …","ui.boot.issue1":"Installation Issues Detected","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"Launch Contao Manager","ui.boot.safeMode":"Launch in Safe Mode","ui.recovery.headline":"System Recovery","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"Automatic Repair","ui.recovery.repairDescription":"Attempts to automatically repair the installation by rebuilding the application cache and re-installing the Composer packages.","ui.recovery.repairWarning":"Any modifications to the vendor files might be deleted in the process!","ui.recovery.repairFailed":"Automatic repair was not successful. Try the Safe Mode to manually repair the installation.","ui.recovery.repairButton":"Run System Repair","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Launching the Contao Manager in Safe Mode allows to manage packages and run certain maintenance tasks, but features that rely on a working Contao installation will not be available.","ui.recovery.safeModeButton":"Launch in Safe Mode","ui.server.pending":"Waiting …","ui.server.running":"Analyzing …","ui.server.error":"Check failed due to an unexpected response from the server.","ui.server.details":"Details","ui.server.prerequisite":"Check cancelled due to a missing prerequisite.","ui.server.selfUpdate.title":"Updates of Contao Manager","ui.server.selfUpdate.update":"A new Contao Manager version {latest} is available.","ui.server.selfUpdate.manualUpdate":"A new Contao Manager version {latest} is available. Your server does not support automatic updates, please download the new version from {download}.","ui.server.selfUpdate.latest":"You are using the latest version {current}.","ui.server.selfUpdate.dev":"Development builds do not support automatic updates.","ui.server.selfUpdate.unsupported":"A new version is available but it does not support your PHP version.","ui.server.selfUpdate.button":"Run Self-Update","ui.server.selfUpdate.continue":"Continue","ui.server.config.title":"Server Configuration","ui.server.config.setup":"Configure","ui.server.config.change":"Change","ui.server.config.save":"Save","ui.server.config.cancel":"Cancel","ui.server.config.customOption":"Other …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Server Configuration","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Use the Composer Resolver Cloud","ui.server.config.cli":"PHP Binary","ui.server.config.stateErrorCli":"No valid PHP binary was found on the server.","ui.server.config.stateErrorCloud":"The Composer Resolver Cloud is not supported.","ui.server.config.stateSuccess":"PHP binary at {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Found PHP version {version}. Please switch to PHP 7 as soon as possible!","ui.server.php_web.success":"Found PHP version {version}, no known issues found.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Found PHP version {version}, no known issues found.","ui.server.composer.title":"Composer Environment","ui.server.composer.success":"No known issues found.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Install","ui.server.contao.title":"Contao Installation","ui.server.contao.setup":"Setup","ui.server.contao.check":"Check database","ui.server.contao.empty":"No Contao installation has been found.","ui.server.contao.old":"Contao version {version} is not compatible with the Contao Manager, please update your installation manually.","ui.server.contao.found":"Found Contao {version} (API version {api}).","ui.server.contao.connectionError":"Unable to connect to the database server.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"Continue","ui.setup.manager":"Launch Contao Manager","ui.setup.cancel":"Cancel","ui.setup.welcome":"Welcome","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Webserver Setup","ui.setup.document-root.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.setup.document-root.documentation":"Read the Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Directory Setup","ui.setup.document-root.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.setup.document-root.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.setup.document-root.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.setup.document-root.directory":"New Directory","ui.setup.document-root.currentRoot":"Current Document Root","ui.setup.document-root.newRoot":"New Document Root","ui.setup.document-root.finish":"Setup Directories","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Please enter a valid directory name.","ui.setup.document-root.directoryExists":"The target directory already exists. Please enter a different name.","ui.setup.document-root.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.setup.document-root.reload":"Reload Page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Contao Installation","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Latest","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimal Installation (Core only)","ui.setup.create-project.noUpdate":"Skip Installation (Expert Only!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Install","ui.setup.create-project.cancel":"Cancel","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Username","ui.setup.database-connection.password":"Password","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Save","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Create Account","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Username","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Password","ui.setup.backend-user.passwordPlaceholder":"min. 8 characters","ui.setup.backend-user.passwordLength":"Please enter at least 8 characters.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.paused":"A background operation stopped unexpectedly. Please check the console output.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"Report a Problem","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"Close","ui.task.buttonConfirm":"Confirm & Close","ui.task.buttonContinue":"Continue","ui.task.buttonCancel":"Cancel","ui.task.confirmCancel":"Are you sure to cancel this task? This might leave your Contao installation in a broken state!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"Show/Hide Console Output","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Close","ui.migrate.confirm":"Confirm & Close","ui.migrate.cancel":"Cancel","ui.migrate.continue":"Continue","ui.migrate.setup":"Setup","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"This field must not be empty.","ui.widget.blankOption":"Please select …","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"More Information","ui.error.support":"Contao Support","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Help","ui.footer.reportProblem":"Report a Problem","ui.navigation.discover":"Discover","ui.navigation.packages":"Packages","ui.navigation.tools":"Tools","ui.navigation.installTool":"Install Tool","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP Information","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"Maintenance","ui.navigation.rebuildCache":"Rebuild Cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"System Check","ui.navigation.advanced":"Advanced","ui.navigation.logout":"Logout","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Application Cache","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Rebuild Production Cache","ui.maintenance.rebuildCache.rebuildDev":"Rebuild Development Cache","ui.maintenance.rebuildCache.clearProd":"Clear Production Cache","ui.maintenance.rebuildCache.clearDev":"Clear Development Cache","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"The Contao Install Tool is automatically locked if you enter a wrong password three times in a row.","ui.maintenance.installTool.unlock":"Unlock Install Tool","ui.maintenance.installTool.lock":"Lock Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Run Installer","ui.maintenance.composerInstall.update":"Run Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Clear Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Activate","ui.maintenance.debugMode.deactivate":"Deactivate","ui.maintenance.debugMode.credentials":"Credentials","ui.maintenance.debugMode.user":"Please enter a username for the debug mode.","ui.maintenance.debugMode.password":"Please enter a password for the debug mode.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Truncate Cache","ui.maintenance.safeMode":"Not available in Safe Mode","ui.maintenance.unsupported":"Not supported by your Contao version","ui.packages.updateButton":"Update Packages","ui.packages.searchButton":"Search Packages","ui.packages.searchPlaceholder":"Search Packages …","ui.packages.uploadOverlay":"Drag & drop files to upload","ui.packages.uploadButton":"Upload Packages","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"Confirm Uploads","ui.packages.uploadReset":"Delete Uploads","ui.packages.uploadIncomplete":"This file was not uploaded completely. Please remove it and try again.","ui.packages.uploadDuplicate":"This file seems to be uploaded multiple times. Please remove the duplicates.","ui.packages.uploadInstalled":"This file is already installed. Please remove the duplicates.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Apply Changes","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Reset Changes","ui.packages.changesReview":"Review Changes","ui.packagelist.loading":"Loading …","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"New packages","ui.packagelist.installed":"Installed packages","ui.package.hintRevert":"Revert Changes","ui.package.hintNoupdate":"Do not update","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"This package will be updated when you apply the changes.","ui.package.hintAdded":"This package will be installed when you apply the changes.","ui.package.hintRemoved":"This package will be removed when you apply the changes.","ui.package.requiredTitle":"manually added","ui.package.requiredText":"This package is required in your composer.json but not installed.","ui.package.removedTitle":"manually removed","ui.package.removedText":"This package was removed from your composer.json.","ui.package.installed":"Currently installed:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Edit","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Update","ui.package.removeButton":"Remove","ui.package.installButton":"Add Package","ui.package.installButtonShort":"Add","ui.package.detailsButton":"Details","ui.package.latestConstraint":"latest version","ui.package.update":"Update available","ui.package.updateLatest":"latest version","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Waiting Time","ui.cloudStatus.jobs":"Current Jobs","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"none","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"Loading …","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 characters","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Cancel","ui.user-manager.close":"Close","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Enable","ui.totp.disable":"Disable","ui.totp.cancel":"Cancel","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[142],{6904:function(a,e,t){t.r(e),t.d(e,{default:function(){return Ba}});var s=t(641),n=t(33);const i={class:"package-popup__installed"},l=["dateTime","title"],o=["href"],p={key:3},c={class:"package-popup__update"},r={class:"package-popup__incompatible"};function u(a,e,t,u,d,k){const g=(0,s.g2)("package-constraint"),m=(0,s.g2)("install-button"),h=(0,s.g2)("package-details",!0);return(0,s.uX)(),(0,s.Wv)(h,{local:k.data,dependents:k.dependents},(0,s.eX)({"package-actions":(0,s.k6)((()=>[(0,s.RG)(a.$slots,"package-actions",{},(()=>[a.isInstalled?((0,s.uX)(),(0,s.CE)(s.FK,{key:0},[!a.isFeature&&a.isVisible?((0,s.uX)(),(0,s.Wv)(g,{key:0,data:k.data},null,8,["data"])):(0,s.Q3)("",!0),(0,s.Lk)("p",i,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package.installed")),1),a.installedTime?((0,s.uX)(),(0,s.CE)("time",{key:0,dateTime:a.installedTime,title:k.datimFormat(a.installedTime)},(0,n.v_)(a.$t("ui.package.version",{version:a.installedVersion})),9,l)):((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.eW)((0,n.v_)(a.$t("ui.package.version",{version:a.installedVersion})),1)],64))])],64)):a.canBeInstalled||a.isRequired?((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.bF)(m,{data:k.data},null,8,["data"]),a.isAdded||a.isRequired?((0,s.uX)(),(0,s.Wv)(g,{key:0,data:k.data},null,8,["data"])):(0,s.Q3)("",!0)],64)):a.isPrivate?((0,s.uX)(),(0,s.CE)("a",{key:2,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:a.metadata.homepage},(0,n.v_)(a.$t("ui.package.homepage")),9,o)):((0,s.uX)(),(0,s.CE)("div",p))]))])),"suggest-actions":(0,s.k6)((e=>{let{name:t}=e;return[a.packageSuggested(t)?((0,s.uX)(),(0,s.Wv)(m,{key:0,inline:"",small:"",data:{name:t}},null,8,["data"])):(0,s.Q3)("",!0)]})),"features-actions":(0,s.k6)((e=>{let{name:t}=e;return[!a.hasRoot||a.packageInstalled(t)||a.packageRoot(t)?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.Wv)(m,{key:0,inline:"",small:"",data:{name:t}},null,8,["data"]))]})),_:2},[a.metadata.update&&a.metadata.update.valid&&!a.metadata.update.latest?{name:"package-update",fn:(0,s.k6)((()=>[(0,s.Lk)("p",c,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package.update"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.$t("ui.package.version",{version:a.metadata.update.version}))+" ("+(0,n.v_)(a.$t("ui.package-details.released"))+" "+(0,n.v_)(k.datimFormat(a.metadata.update.time,"short","long"))+") ",1)])])),key:"0"}:a.isCompatible?void 0:{name:"package-update",fn:(0,s.k6)((()=>[(0,s.Lk)("p",r,(0,n.v_)(a.$t("ui.package.incompatible",{package:k.data.name,constraint:a.packageConstraint("contao/manager-bundle")})),1)])),key:"1"}]),1032,["local","dependents"])}t(8111),t(7588);var d=t(6278),k=t(4210),g=t(8200);const m={class:"package-popup__headline"},h=["title"],_=["title"],v={key:0,class:"package-popup__loader"},b={class:"package-popup__summary"},f={class:"package-popup__text"},y={class:"package-popup__title"},$={key:0,class:"package-popup__authors"},C=["href"],X={class:"package-popup__statistics"},E=["title"],L={key:1,class:"package-popup__stats package-popup__stats--updated"},w={key:2,class:"package-popup__stats package-popup__stats--downloads"},F={key:3,class:"package-popup__stats package-popup__stats--favers"},A={class:"package-popup__actions"},W=["href"],Q=["href"],T={class:"package-popup__tabs"},x={class:"package-popup__tabs-list"},P={key:0,class:"package-popup__abandoned"},R={key:2},q={key:3},B={key:4},I={class:"package-popup__description"};function G(a,e,t,i,l,o){const p=(0,s.g2)("loading-spinner"),c=(0,s.g2)("package-logo"),r=(0,s.g2)("more-links"),u=(0,s.g2)("details-tab"),d=(0,s.g2)("router-link"),k=(0,s.g2)("i18n-t"),g=(0,s.g2)("package-funding"),G=(0,s.g2)("details-content"),O=(0,s.g2)("popup-overlay");return(0,s.uX)(),(0,s.Wv)(O,{fixed:!0,"popup-class":"package-popup",tabindex:"-1",onClear:e[8]||(e[8]=e=>a.clearCurrent())},{content:(0,s.k6)((()=>[(0,s.Lk)("div",m,[a.hasPrevious?((0,s.uX)(),(0,s.CE)("button",{key:0,class:"package-popup__button package-popup__button--previous",title:a.$t("ui.package-details.previous"),onClick:e[0]||(e[0]=e=>a.$router.go(-1))},e[9]||(e[9]=[(0,s.Lk)("svg",{xmlns:"http://www.w3.org/2000/svg",fill:"#fff",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"}),(0,s.Lk)("path",{d:"M21 11H6.83l3.58-3.59L9 6l-6 6 6 6 1.41-1.41L6.83 13H21z"})],-1)]),8,h)):(0,s.Q3)("",!0),(0,s.eW)(" "+(0,n.v_)(o.data.name)+" ",1),(0,s.Lk)("button",{class:"package-popup__button package-popup__button--close",title:a.$t("ui.package-details.close"),onClick:e[1]||(e[1]=e=>a.clearCurrent())},e[10]||(e[10]=[(0,s.Lk)("svg",{height:"24",viewBox:"0 0 24 24",width:"24",fill:"#fff",xmlns:"http://www.w3.org/2000/svg"},[(0,s.Lk)("path",{d:"M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"}),(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"})],-1)]),8,_)]),a.metadata&&a.metadata.hasOwnProperty("name")?((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.Lk)("div",b,[(0,s.bF)(c,{class:"package-popup__logo","component-class":"package-popup__icon",src:a.metadata.logo},null,8,["src"]),(0,s.Lk)("div",f,[(0,s.Lk)("h1",y,(0,n.v_)(a.metadata.title||o.data.name),1),o.authors?((0,s.uX)(),(0,s.CE)("p",$,[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.authors"))+" ",1),((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(o.authors,((a,e)=>((0,s.uX)(),(0,s.CE)(s.FK,null,[a.homepage?((0,s.uX)(),(0,s.CE)("a",{class:"package-popup__author",key:e,href:a.homepage,target:"_blank",rel:"noreferrer noopener"},(0,n.v_)(a.name),9,C)):((0,s.uX)(),(0,s.CE)("span",{class:"package-popup__author",key:e},(0,n.v_)(a.name),1))],64)))),256))])):(0,s.Q3)("",!0),(0,s.Lk)("p",X,[a.metadata.private?((0,s.uX)(),(0,s.CE)("span",{key:0,class:"package-popup__stats package-popup__stats--private",title:a.$t("ui.package.privateTitle")},(0,n.v_)(a.$t("ui.package.private")),9,E)):(0,s.Q3)("",!0),a.metadata.updated?((0,s.uX)(),(0,s.CE)("span",L,(0,n.v_)(o.datimFormat(a.metadata.updated,!1)),1)):(0,s.Q3)("",!0),a.metadata.downloads>0?((0,s.uX)(),(0,s.CE)("span",w,(0,n.v_)(o.numberFormat(a.metadata.downloads)),1)):(0,s.Q3)("",!0),a.metadata.favers>0?((0,s.uX)(),(0,s.CE)("span",F,(0,n.v_)(o.numberFormat(a.metadata.favers)),1)):(0,s.Q3)("",!0),(0,s.bF)(r,{name:a.metadata.name,homepage:a.metadata.homepage,support:Object.assign({},a.metadata.support),metadata:a.metadata.metadata,"hide-packagist":a.metadata.private},null,8,["name","homepage","support","metadata","hide-packagist"])])]),(0,s.Lk)("div",A,[(0,s.RG)(a.$slots,"package-actions",(0,n._B)((0,s.Ng)({data:a.metadata})),(()=>[a.metadata&&a.metadata.homepage?((0,s.uX)(),(0,s.CE)("a",{key:0,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:a.metadata.homepage},(0,n.v_)(a.$t("ui.package.homepage")),9,W)):a.metadata.private?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.CE)("a",{key:1,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:`https://packagist.org/packages/${o.data.name}`},(0,n.v_)(a.$t("ui.package-details.packagist")),9,Q))]))])]),(0,s.Lk)("div",T,[(0,s.Lk)("ul",x,[(0,s.bF)(u,{"show-empty":"",links:!1,active:""===o.tab,onClick:e[2]||(e[2]=a=>o.setTab(""))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabDescription")),1)])),_:1},8,["active"]),a.metadata.features?((0,s.uX)(),(0,s.Wv)(u,{key:0,highlight:"",links:a.metadata.features,active:"features"===o.tab,onClick:e[3]||(e[3]=a=>o.setTab("features"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabFeatures")),1)])),_:1},8,["links","active"])):(0,s.Q3)("",!0),(0,s.bF)(u,{highlight:"",active:"suggest"===o.tab,links:a.metadata.suggest,onClick:e[4]||(e[4]=a=>o.setTab("suggest"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabSuggest")),1)])),_:1},8,["active","links"]),(0,s.bF)(u,{"show-empty":"",active:"require"===o.tab,links:a.metadata.require,onClick:e[5]||(e[5]=a=>o.setTab("require"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabRequire")),1)])),_:1},8,["active","links"]),(0,s.bF)(u,{"show-empty":"",active:"conflict"===o.tab,links:a.metadata.conflict,onClick:e[6]||(e[6]=a=>o.setTab("conflict"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabConflict")),1)])),_:1},8,["active","links"]),t.dependents?((0,s.uX)(),(0,s.Wv)(u,{key:1,active:"dependents"===o.tab,links:t.dependents,onClick:e[7]||(e[7]=a=>o.setTab("dependents"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabDependents")),1)])),_:1},8,["active","links"])):(0,s.Q3)("",!0)])]),(0,s.bF)(G,{active:""===o.tab},{default:(0,s.k6)((()=>[a.metadata.abandoned?((0,s.uX)(),(0,s.CE)("div",P,[!0===a.metadata.abandoned?((0,s.uX)(),(0,s.CE)(s.FK,{key:0},[(0,s.eW)((0,n.v_)(a.$t("ui.package.abandonedText")),1)],64)):((0,s.uX)(),(0,s.Wv)(k,{key:1,keypath:"ui.package.abandonedReplace"},{replacement:(0,s.k6)((()=>[(0,s.bF)(d,{to:{query:{p:a.metadata.abandoned}}},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.metadata.abandoned),1)])),_:1},8,["to"])])),_:1}))])):(0,s.Q3)("",!0),a.metadata.funding?((0,s.uX)(),(0,s.Wv)(g,{key:1,class:"package-popup__funding",items:a.metadata.funding},null,8,["items"])):(0,s.Q3)("",!0),(0,s.RG)(a.$slots,"package-update"),a.metadata.contaoVersions?((0,s.uX)(),(0,s.CE)("p",R,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.contaoVersions"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.metadata.contaoVersions.join(", ")),1)])):(0,s.Q3)("",!0),a.metadata.latest?((0,s.uX)(),(0,s.CE)("p",q,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.latest"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.metadata.latest.version)+" ("+(0,n.v_)(a.$t("ui.package-details.released"))+" "+(0,n.v_)(o.datimFormat(a.metadata.latest.time,"short","long"))+")",1)])):(0,s.Q3)("",!0),a.metadata.license?((0,s.uX)(),(0,s.CE)("p",B,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.license"))+":",1),(0,s.eW)(" "+(0,n.v_)(o.license),1)])):(0,s.Q3)("",!0),(0,s.Lk)("p",I,(0,n.v_)(a.metadata.description),1)])),_:3},8,["active"]),a.metadata.features?((0,s.uX)(),(0,s.Wv)(G,{key:0,active:"features"===o.tab,links:a.metadata.features},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"features-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"])):(0,s.Q3)("",!0),(0,s.bF)(G,{active:"suggest"===o.tab,links:a.metadata.suggest},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"suggest-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),(0,s.bF)(G,{active:"require"===o.tab,links:a.metadata.require},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"require-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),(0,s.bF)(G,{active:"conflict"===o.tab,links:a.metadata.conflict},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"conflict-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),t.dependents?((0,s.uX)(),(0,s.Wv)(G,{key:1,active:"dependents"===o.tab,links:t.dependents},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"dependents-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"])):(0,s.Q3)("",!0)],64)):((0,s.uX)(),(0,s.CE)("div",v,[(0,s.bF)(p,{horizontal:""}),(0,s.Lk)("p",null,(0,n.v_)(a.$t("ui.package-details.loading")),1)]))])),_:3})}var O=t(9376),S=t(416),j=t(266),K=t(7423),V=t(9045);const D={key:0,class:"link-more"};function H(a,e,t,i,l,o){const p=(0,s.g2)("link-menu");return o.linkItems.length?((0,s.uX)(),(0,s.CE)("div",D,[(0,s.Lk)("button",{onClick:e[0]||(e[0]=(...a)=>o.toggle&&o.toggle(...a))},(0,n.v_)(a.$t("ui.package-details.more")),1),a.visible?((0,s.uX)(),(0,s.CE)("div",{key:0,ref:"menu",class:"link-more__menu",tabindex:"-1",onFocusout:e[1]||(e[1]=(...a)=>o.close&&o.close(...a)),onClick:e[2]||(e[2]=(...a)=>o.close&&o.close(...a))},[(0,s.bF)(p,{items:o.linkItems,color:"contao"},null,8,["items"])],544)):(0,s.Q3)("",!0)])):(0,s.Q3)("",!0)}var M=t(4758),N={components:{LinkMenu:M.A},props:{name:String,homepage:String,support:Object,metadata:String,hidePackagist:Boolean},data:()=>({visible:!1}),computed:{linkItems(){const a=[];return this.homepage&&a.push({label:this.$t("ui.package.homepage"),href:this.homepage,target:"_blank"}),this.name&&!this.hidePackagist&&a.push({label:this.$t("ui.package-details.packagist"),href:`https://packagist.org/packages/${this.name}`,target:"_blank"}),this.support&&Object.keys(this.support).forEach((e=>{const t=`ui.package-details.support_${e}`;let s=this.$t(`ui.package-details.support_${e}`);s===t&&(s=e),"email"===e?a.push({label:s,href:`mailto:${this.support[e]}`}):a.push({label:s,href:this.support[e],target:"_blank"})})),this.metadata&&a.push({label:this.$t("ui.package-details.metadata"),href:this.metadata,target:"_blank"}),a}},methods:{open(){this.visible=!0,setTimeout((()=>this.$refs.menu?.focus()),0)},close(a){a&&this.$refs.menu?.contains(a.relatedTarget)||(this.$refs.menu.blur(),setTimeout((()=>{this.visible=!1}),100))},toggle(){this.visible?this.close():this.open()}}},z=t(6262);const U=(0,z.A)(N,[["render",H]]);var Y=U;const J=["disabled"];function Z(a,e,t,i,l,o){return t.showEmpty||o.count>0?((0,s.uX)(),(0,s.CE)("li",{key:0,class:(0,n.C4)(["package-popup__tab",{"package-popup__tab--active":t.active}])},[(0,s.Lk)("button",{onClick:e[0]||(e[0]=e=>a.$emit("click")),disabled:0===o.count&&!1!==t.links},[(0,s.RG)(a.$slots,"default"),!1!==t.links?((0,s.uX)(),(0,s.CE)("span",{key:0,class:(0,n.C4)({"package-popup__pill":!0,"package-popup__pill--highlight":t.highlight&&o.count>0})},(0,n.v_)(o.count),3)):(0,s.Q3)("",!0)],8,J)],2)):(0,s.Q3)("",!0)}var aa={emits:["click"],props:{active:Boolean,showEmpty:Boolean,highlight:Boolean,links:[Object,Array,Boolean]},computed:{count(){return this.links?this.links instanceof Array?this.links.length:Object.values(this.links).length:0}}};const ea=(0,z.A)(aa,[["render",Z]]);var ta=ea,sa=t(3751);const na={class:"package-popup__tabcontent",tabindex:"-1"},ia={key:0,class:"package-popup__packagelist"};function la(a,e,t,n,i,l){const o=(0,s.g2)("package-link");return(0,s.bo)(((0,s.uX)(),(0,s.CE)("div",na,[(0,s.RG)(a.$slots,"default",{},(()=>[t.links?((0,s.uX)(),(0,s.CE)("div",ia,[((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(l.iterableLinks,((e,t)=>(0,s.RG)(a.$slots,"links",(0,s.v6)({ref_for:!0},{name:t,text:e}),(()=>[((0,s.uX)(),(0,s.Wv)(o,{name:t,key:t,text:e},{default:(0,s.k6)((()=>[(0,s.RG)(a.$slots,"actions",(0,s.v6)({ref_for:!0},{name:t}))])),_:2},1032,["name","text"]))])))),256))])):(0,s.Q3)("",!0)]))],512)),[[sa.aG,t.active]])}const oa={class:"package-link__details"},pa=["title"],ca={class:"package-link__text"},ra={class:"package-link__actions"};function ua(a,e,t,i,l,o){const p=(0,s.g2)("details-button");return(0,s.uX)(),(0,s.CE)("article",{class:(0,n.C4)(["package-link",{"package-link--limit":!t.text}])},[(0,s.Lk)("div",oa,[(0,s.Lk)("p",{class:"package-link__name",title:t.name},(0,n.v_)(a.metadata&&a.metadata.title||t.name),9,pa),(0,s.Lk)("p",ca,(0,n.v_)(t.text||a.metadata&&a.metadata.description),1)]),(0,s.Lk)("div",ra,[(0,s.RG)(a.$slots,"default"),(0,s.bF)(p,{small:"",name:t.name},null,8,["name"])])],2)}var da=t(9071),ka={mixins:[S.A],components:{DetailsButton:da.A},props:{name:String,text:String},computed:{data:a=>({name:a.name})}};const ga=(0,z.A)(ka,[["render",ua]]);var ma=ga,ha={components:{PackageLink:ma},props:{active:Boolean,links:[Object,Array]},computed:{iterableLinks(){if(this.links instanceof Array){const a={};return this.links.forEach((e=>{a[e]=null})),a}return this.links}},watch:{active(){setTimeout((()=>{this.$el.focus()}),0)}}};const _a=(0,z.A)(ha,[["render",la]]);var va=_a,ba=t(5187);const fa={key:0,class:"package-funding"},ya=["href"],$a=["href"],Ca=["href"],Xa=["href"],Ea=["href"];function La(a,e,t,i,l,o){return t.items&&t.items.length?((0,s.uX)(),(0,s.CE)("div",fa,[(0,s.Lk)("div",null,[(0,s.Lk)("span",null,(0,n.v_)(a.$t("ui.package-details.funding")),1),((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(t.items,((a,e)=>((0,s.uX)(),(0,s.CE)(s.FK,null,["github"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:o.githubUrl(a),target:"_blank",rel:"noreferrer noopener",key:e},"GitHub",8,ya)):"tidelift"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"Tidelift",8,$a)):"patreon"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"Patreon",8,Ca)):"opencollective"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"OpenCollective",8,Xa)):((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},(0,n.v_)(a.url.replace(/^https?:\/\/(www.)?([^/]+).*$/,"$2")),9,Ea))],64)))),256))])])):(0,s.Q3)("",!0)}var wa={name:"PackageFunding",props:{items:{type:Array,required:!0}},computed:{githubUrl:()=>a=>a.url.replace(/^https:\/\/github.com\/([^/]+)$/,"https://github.com/sponsors/$1")}};const Fa=(0,z.A)(wa,[["render",La],["__scopeId","data-v-5a8fd14b"]]);var Aa=Fa,Wa={mixins:[S.A],components:{PopupOverlay:ba.A,MoreLinks:Y,LoadingSpinner:V.A,PackageLogo:K.A,PackageFunding:Aa,DetailsTab:ta,DetailsContent:va},props:{local:{type:Object},dependents:{type:Object}},data:()=>({appTitle:"",links:[],hasPrevious:!1}),computed:{current:a=>a.$route.query.p,tab:a=>String(a.$route.hash).substring(1),exists:a=>a.metadata,data:a=>a.local||{name:a.current},authors:a=>a.metadata.authors&&a.metadata.authors.length?a.metadata.authors.filter((a=>!!a.name)):null,license:a=>a.metadata.license?a.metadata.license instanceof Array?a.metadata.license.join(", "):a.metadata.license:"–",contaoVersions:a=>a.metadata.contaoVersions||null},methods:{datimFormat:k.A,numberFormat:j.A,...(0,d.PY)("packages/details",["clearCurrent"]),setTab(a){this.$router.replace({query:this.$route.query,hash:`#${a}`,append:!0})},updatePage(){let a=`${this.current} - ${this.appTitle}`,e="";this.metadata&&(this.metadata.title&&(a=`${this.metadata.title} (${this.current}) - ${this.appTitle}`),e=this.metadata.description||""),document.title=a,document.head.querySelector('meta[name="description"]').setAttribute("content",e)},addLink(a,e,t=null){const s=new URL(location.pathname,location);s.search=a;const n=document.createElement("link");n.setAttribute("rel",e),n.setAttribute("href",s.toString()),t&&n.setAttribute("hrefLang",t),document.head.appendChild(n),this.links.push(n)}},watch:{current(){this.updatePage(),this.hasPrevious=/[?&]p=/.test(window.history.state?.back)},exists(a){a||this.clearCurrent()},metadata(){this.updatePage()}},created(){this.appTitle=document.title},mounted(){document.head.querySelector('meta[name="robots"]').setAttribute("content","index,follow"),this.updatePage(),this.addLink(`?p=${this.current}&_locale=${this.$i18n.locale}`,"canonical"),Object.keys(O.A).forEach((a=>{this.addLink(`?p=${this.current}&_locale=${a}`,"alternate",a)}))},beforeUnmount(){document.title=this.appTitle,document.head.querySelector('meta[name="description"]').setAttribute("content",""),this.links.forEach((a=>{document.head.removeChild(a)}))}};const Qa=(0,z.A)(Wa,[["render",G]]);var Ta=Qa,xa=t(8386),Pa=t(939),Ra={mixins:[g.A],components:{PackageConstraint:Pa.A,PackageDetails:Ta,InstallButton:xa.A},computed:{...(0,d.aH)("packages",{allInstalled:"installed"}),...(0,d.L8)("packages",["packageConstraint"]),current:a=>a.$route.query.p,data:a=>a.add[a.current]||a.allInstalled&&a.allInstalled[a.current]||{name:a.current},dependents(){if(!this.allInstalled[this.data.name]?.dependents)return null;const a={},e=["requires","replaces","provides","conflicts"];return Object.values(this.allInstalled[this.data.name].dependents).forEach((t=>{if("__root__"===t.source||!e.includes(t.description)||t.source===this.data.name&&"replaces"===t.description)return;const s=this.$t(`ui.package-details.link${t.description[0].toUpperCase()}${t.description.slice(1)}`);let n=t.target;n===this.data.name&&this.metadata&&this.metadata.title&&(n=this.metadata.title),a[t.source]=`${s} ${n} ${t.constraint}`})),a}},methods:{datimFormat:k.A}};const qa=(0,z.A)(Ra,[["render",u]]);var Ba=qa}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[44],{44:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Bağlantı güvenli değil !!","ui.app.httpsDescription":"HTTPS olmadan verileriniz şifrelenmeden aktarılır ve başkaları tarafından görülebilir.","ui.app.httpsLink":"Ayrıntılı bilgi alın","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Güvenli kip etkin !!","ui.app.safeModeDescription":"Bazı Contao Manager özellikleri kullanılamaz.","ui.app.safeModeExit":"Güvenli kipten çık","ui.app.limitedHeadline":"Uzaktan kimlik doğrulama","ui.app.limitedDescription":"Parolasız oturum açma kullandığınızdan izinleriniz sınırlı.","ui.app.limitedLogout":"Kimliği yeniden doğrula","ui.app.totpHeadline":"Güvenlik bildirimi","ui.app.totpDescription":"Hesabınızın güvenliğini sağlamak için iki adımlı doğrulamayı yapılandırın.","ui.app.totpSetup":"Kurulum","ui.app.loading":"Contao Manager yükleniyor…","ui.app.apiError":"Beklenmeyen API durumu","ui.app.configSecurity1":"GÜVENLİK UYARISI !!! Yapılandırma klasörünün korunmadığı algılandı","ui.app.configSecurity2":"Contao Manager, yapılandırma dosyalarının herkese açık olduğunu algıladı. Klasörün güvenliği sağlanana kadar tüm işlemler etkisizleştirilecek. Yoksa bir saldırgan kurulumunuzun hassas verilerine erişebilir.\\n\\nBu sorunu gidermek için sunucunuzdaki \\"contao-manager\\" klasörüne erişimi engellediğinizden emin olun. Bunu nasıl yapacağınızı öğrenmek için site sunucunuzun belgelerine bakın veya barındırma hizmeti sağlayıcınızla görüşün.","ui.account.welcome":"Hoş geldiniz","ui.account.intro1":"Contao açık kaynaklı içerik yönetimi sistemini kurmak ve yönetmek için kullanılan Contao Manager uygulamasına hoş geldiniz. İlk kez kullanıyorsanız {readTheManualToGetStarted}.","ui.account.introGetStarted":"Başlamak için {readTheManualToGetStarted}.","ui.account.introManual":"rehberi okuyun","ui.account.intro2":"Herhangi bir sorunla karşılaşırsanız,  {ourGithubIssues} bakın ve henüz bildirilmemiş bir sorunu bildirmekten çekinmeyin.","ui.account.introIssues":"GitHub sorunlarımıza","ui.account.headline":"Kullanıcı hesabı","ui.account.description":"Kuurlumunuzu yönetmek için bir Contao Manager hesabı açın. Bu hesabın Contao ön yüzü ve yönetim bölümü ile ilgili olmadığını unutmayın. ","ui.account.username":"Kullanıcı adı","ui.account.password":"Parola","ui.account.passwordPlaceholder":"en az 8 karakter","ui.account.passwordLength":"Lütfen en az 8 karakter yazın.","ui.account.loginInvalid":"Hesap açılırken bir sorun çıktı. Başka bir kullanıcı adı deneyin.","ui.account.submit":"Hesap aç","ui.account.usePassword":"Parola ile oturum aç","ui.account.usePasskey":"Geçiş anahtarı ile oturum aç","ui.account.totpHeadline":"İki adımlı doğrulama","ui.account.totpDescription":"Hesabınıza ek bir güvenlik katmanı ekleyen iki adımlı doğrulamayı açın. Kullanıcı adınız ve parolanıza ek olarak, 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator veya başka herhangi bir tek kullanımlık parola uygulaması gibi bir iki adımlı doğrulama uygulaması tarafından oluşturulan bir kodu yazmanız gerekir.","ui.account.totpSetup":"Şimdi yapılandır","ui.account.totpSkip":"Sonra yapılandır","ui.account.login":"Daveti reddet","ui.account.contribute1":"Contao ve Contao Manager kar amacı gütmeyen Contao Association tarafından desteklenmektedir.","ui.account.contribute2":"Lütfen {donate} açık kaynak dünyasına destek vermeyi değerlendirin.","ui.account.contributeDonate":"bir bağış yaparak","ui.login.headline":"Oturum aç","ui.login.description":"Kurulumunuzu yönetmek için oturum açın.","ui.login.username":"Kullanıcı adı","ui.login.password":"Parola","ui.login.totpHeadline":"İki adımlı doğrulama","ui.login.totpDescription":"Oturum açmak için lütfen doğrulama kodunuzu yazın.","ui.login.totp":"Doğrulama kodu","ui.login.forgotPassword":"Parolamı unuttum","ui.login.button":"Oturum aç","ui.login.passkey":"Geçiş anahtarı ile oturum aç","ui.login.cancel":"İptal","ui.login.or":"ya da","ui.login.locked":"Contao Manager kilitlenmiş olduğundan erişim reddedildi. Kilidi açmak için Contao kök klasöründeki {lockFile} dosyasını silin.","ui.logout.headline":"Oturum zaman aşımına uğradı","ui.logout.warning":"25 dakikadan uzun süredir işlem yapmadınız. Güvenlik nedeniyle oturumunuz kısa bir süre içinde sonlandırılacak.","ui.logout.expired":"30 dakikadan uzun süredir işlem yapmadığınız için oturumunuz otomatik olarak sonlandırıldı.","ui.logout.renew":"Oturumu açık tut","ui.logout.logout":"Oturumu kapat","ui.logout.login":"Oturum açmaya dön","ui.oauth.error":"OAuth girişimi geçersiz. İstek parametrelerini denetleyin.","ui.oauth.https":"Yönlendirme adresi, kimlik doğrulama belirtecinin düz metin olarak iletilmesini önlemek için güvenli bir iletişim kuralı (https:) kullanmalıdır.","ui.oauth.headline":"Uzaktan kimlik doğrulama","ui.oauth.description":"Şu uygulama ya da hizmet Contao Manager kopyanıza uzaktan erişmek istiyor.","ui.oauth.domain":"Erişim izni vermeden önce bu adresi bildiğinizden ve sahibine güvendiğinizden emin olun!","ui.oauth.outOfScope":"Ne yazık ki, bu izni vermek için yeterli izinleriniz yok.","ui.oauth.allow":"Erişme izni ver","ui.oauth.deny":"Erişimi reddet","ui.oauth.switchUser":"Kullanıcıyı değiştir","ui.scope.admin":"Yönetici erişiminde kullanıcı yönetimi bulunur","ui.scope.install":"Yeni paketleri kurun ve Contao yapılandırmasını değiştirin","ui.scope.update":"Paketleri güncelleyin ve bakım görevlerini yürütün","ui.scope.read":"Paketleri ve yapılandırmayı okuyun","ui.boot.headline":"Sistem denetimi","ui.boot.description":"Lütfen sunucunuz incelenirken bekleyin…","ui.boot.issue1":"Kurulum sorunları algılandı","ui.boot.issue2":"Kurulumunuzda Contao Manager kullanabilmek için düzeltmeniz gereken sorunlar var.","ui.boot.run":"Contao Manager uygulamasını başlat","ui.boot.safeMode":"Güvenli kipte başlat","ui.recovery.headline":"Sistem kurtarma","ui.recovery.description":"Contao Manager, Contao kurulumuna benzeyen dosyalar algıladı, ancak komut satırı arabirimi beklendiği gibi çalışmıyor.","ui.recovery.console":"Konsol çıktısı","ui.recovery.repairOptions":"Lütfen kurulumunuzu onarmak için bir seçim yapın.","ui.recovery.repairHeadline":"Otomatik onarım","ui.recovery.repairDescription":"Uygulama ön belleğini yeniden oluşturup Composer paketlerini yeniden kurarak kurulumu otomatik olarak onarmayı dener.","ui.recovery.repairWarning":"İşlem sırasında üretici dosyalarında yapılmış herhangi bir değişiklik silinebilir!","ui.recovery.repairFailed":"Otomatik onarım başarılı olmadı. Kurulumu el ile onarmak için güvenli kipi deneyin.","ui.recovery.repairButton":"Sistem onarımını başlat","ui.recovery.safeModeHeadline":"Güvenli kip","ui.recovery.safeModeDescription":"Contao Manager güvenli kipte çalıştırıldığında, paketlerin yönetimine ve belirli bakım işlemlerine izin verir. Ancak çalışan bir Contao kurulumu ile ilgili özellikleri kullanılamaz.","ui.recovery.safeModeButton":"Güvenli kipte başlat","ui.server.pending":"Bekleniyor…","ui.server.running":"İnceleniyor…","ui.server.error":"Sunucudan alınan beklenmeyen bir yanıt nedeniyle denetim tamamlanamadı.","ui.server.details":"Ayrıntılar","ui.server.prerequisite":"Eksik bir ön koşul nedeniyle denetim iptal edildi.","ui.server.selfUpdate.title":"Contao Manager güncellemeleri","ui.server.selfUpdate.update":"Yeni Contao Manager {latest} sürümü yayınlanmış.","ui.server.selfUpdate.manualUpdate":"Yeni Contao Manager {latest} sürümü yayınlanmış. Sunucunuz otomatik güncellemeleri desteklemiyor. Lütfen {download} adresinden yeni sürümü indirin.","ui.server.selfUpdate.latest":"Güncel {current} sürümünü kullanıyorsunuz.","ui.server.selfUpdate.dev":"Geliştirme yapımları otomatik güncellemeleri desteklemez.","ui.server.selfUpdate.unsupported":"Yeni bir sürüm yayınlanmış ancak PHP sürümünüzü desteklemiyor.","ui.server.selfUpdate.button":"Otomatik güncelle","ui.server.selfUpdate.continue":"İlerle","ui.server.config.title":"Sunucu yapılandırması","ui.server.config.setup":"Yapılandır","ui.server.config.change":"Değiştir","ui.server.config.save":"Kaydet","ui.server.config.cancel":"İptal","ui.server.config.customOption":"Diğer…","ui.server.config.description":"Arka plan görevlerini doğru bir şekilde çalıştırmak için Contao Manager uygulamasının, PHP komut satırı binary dosyasını nerede bulacağını ve site sürecinden ayrı olarak komutları nasıl çalıştıracağını bilmesi gerekir.","ui.server.config.formTitle":"Sunucu yapılandırması","ui.server.config.formText":"Lütfen PHP binary dosyanızın yolunu yazın. Binary programın PHP sürümünün site işleminizle aynı olduğundan emin olun.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud, sunucunuz yeterli yerel bellek sunmasa bile Composer bağımlılıklarının kurulmasını sağlar. Paket bilgilerinizin Contao Association tarafından işletilen bir bulut sunucusuna aktarılacağını unutmayın.","ui.server.config.cloud":"Composer Resolver Cloud kullanılsın","ui.server.config.cli":"PHP binary dosyası","ui.server.config.stateErrorCli":"Sunucuda geçerli bir PHP binary dosyası bulunamadı.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud desteklenmiyor.","ui.server.config.stateSuccess":"PHP binary dosyası {php_cli} konumunda.","ui.server.php_web.title":"PHP site işlemi","ui.server.php_web.below7":"PHP {version} sürümü bulundu. Lütfen en kısa sürede PHP 7 sürümüne geçin!","ui.server.php_web.success":"PHP {version} sürümü bulundu. Bilinen bir sorun bulunamadı.","ui.server.php_cli.title":"PHP komut satırı arayüzü","ui.server.php_cli.success":"PHP {version} sürümü bulundu. Bilinen bir sorun bulunamadı.","ui.server.composer.title":"Composer ortamı","ui.server.composer.success":"Bilinen bir sorun bulunamadı.","ui.server.composer.install":"Composer bağımlılıkları kurulmamış.","ui.server.composer.button":"Kur","ui.server.contao.title":"Contao kurulumu","ui.server.contao.setup":"Kurulum","ui.server.contao.check":"Veri tabanını denetle","ui.server.contao.empty":"Herhangi bir Contao sürümünü bulunamadı.","ui.server.contao.old":"Contao {version} sürümü Contao Manager ile uyumlu değil. Lütfen kurulumunuzu el ile güncelleyin.","ui.server.contao.found":"Contao {version} sürümü bulundu (API sürümü {api}).","ui.server.contao.connectionError":"Veri tabanı sunucusu ile bağlantı kurulamadı.","ui.server.contao.connectionProblem":"Veri tabanı sorunu bulundu.","ui.server.contao.missingUser":"Yönetici hesabı bulunamadı.","ui.setup.continue":"İlerle","ui.setup.manager":"Contao Manager uygulamasını başlat","ui.setup.cancel":"İptal","ui.setup.welcome":"Hoş geldiniz","ui.setup.welcome1":"Bu yardımcı, açık kaynaklı Contao içerik yönetimi sistemi kurulumunu yapmanız için gerekli adımlarda size yol gösterecek.","ui.setup.welcome2":"Herhangi bir sorunuz varsa belgelere, forumlara, Slack kanalına ve {destek} sayfasına bakabilirsiniz.","ui.setup.support":"topluluk desteği","ui.setup.start":"Başlayalım","ui.setup.complete":"Tebrikler!","ui.setup.complete1":"Contao {version} kuruldu.","ui.setup.complete2":"Kurulum işlemini tamamlamak için gereken veri tabanı bağlantısını yapılandırmak ve yönetim bölümü kullanıcısı oluşturacak kurulum aracını açın.","ui.setup.complete3":"Artık Contao yönetim bölümüne giderek sitenizi oluşturmaya başlayabilirsiniz. Çeşitli eklentilere gerek duyuyorsanız Contao Manager ile ilerleyin.","ui.setup.installTool":"Kurulum aracını açın","ui.setup.login":"Contao oturumu açın","ui.setup.funding":"Özgür yazılım, \\"konuşma özgürlüğü\\" ifadesindeki gibi \\"özgürdür\\". \\"Ücretsiz\\" olmasına rağmen o anlama gelmez. Contao gibi bir açık kaynaklı proje, tek bir kişi veya şirket tarafından toplanamayacak miktarda para gerektirir.\\nContao ile oluşturulmuş bir siteniz varsa veya böyle siteler satıyorsanız, işinizin destekleyen ürüne mali katkıda bulunduğunuzu görmek isteriz.","ui.setup.fundingLink":"Ayrıntılı bilgi alın","ui.setup.document-root.headline":"Site sunucusu kurulumu","ui.setup.document-root.warning":"Contao Manager ile Contao kurmak için site sunucusunun belge kök klasörünü düzeltmeniz gerekir.","ui.setup.document-root.description1":"Contao, herkese açık dosyalar için ayrı bir klasör kullanır. Uygulama dosyaları bu klasörün üst klasörüne kurulur. Klasör yapısı doğru değilse veya klasörler boş değilse Contao kurulamaz.","ui.setup.document-root.description2":"Belge kök klasörünüzü nasıl yapılandıracağınızı bilmiyorsanız, Contao belgelerini okuyun ya da barındırma hizmeti sağlayıcınızla görüşün.","ui.setup.document-root.documentation":"Belgeleri okuyun","ui.setup.document-root.conflictsTitle":"Kurulum klasörü boş değil","ui.setup.document-root.conflictsDirectory":"Gelecekteki Contao kurulumunuzun kök klasörü boş değil. Kurulum işlemi tarafından üzerine yazılabilecek {count} dosya bulundu. Contao için boş bir klasör yapısı oluşturmanız önerilir. Ancak kullanılmadıklarından eminseniz aşağıdaki dosyaları silerek yeniden denetleyebilirsiniz.","ui.setup.document-root.ignoreConflicts":"Boş olmayan bir klasöre Contao kurmak istiyorum. Bu işlemin site alanımdaki var olabilecek dosyaların üzerine yazabileceğini anlıyorum.","ui.setup.document-root.check":"Yeniden denetle","ui.setup.document-root.create":"Klasörleri oluştur","ui.setup.document-root.change":"Klasörleri değiştir","ui.setup.document-root.formTitle":"Klasör kurulumu","ui.setup.document-root.formText1":"Contao Manager, otomatik olarak sunucuda yeni bir klasör yapısı oluşturabilir.","ui.setup.document-root.formText2":"Yeni belge kök klasörünü el ile yapılandırmanız gerekir (örneğin, bir barındırma hizmeti yönetim panosu üzerinden).","ui.setup.document-root.autoconfig":"Sunucu yapılandırmamı değiştirmem gerektiğini anlıyorum. Belge kök klasörünü yapılandırmamak Contao Manager uygulamasını bozacak ve yapılandırma dosyalarını (hesap bilgileri ve parolalar ile birlikte) açığa çıkaracak!","ui.setup.document-root.directory":"Yeni klasör","ui.setup.document-root.currentRoot":"Geçerli belge kök klasörü","ui.setup.document-root.newRoot":"Yeni belge kök klasörü","ui.setup.document-root.finish":"Klasörleri kur","ui.setup.document-root.publicDir":"Herkese açık dosyalar için {dir} klasörünü kullanın (Contao {version} için)","ui.setup.document-root.directoryInvalid":"Lütfen geçerli bir klasör adı yazın.","ui.setup.document-root.directoryExists":"Hedef klasör zaten var. Lütfen farklı bir ad yazın.","ui.setup.document-root.confirmation":"Contao Manager, Contao kurulumunuz için gerekli klasörü oluşturdu. Şimdi site sunucunuzda belge kök klasörünü yapılandırmanız gerekiyor. Bu işlemi yapana kadar bu sayfayı yeniden yüklemeyin.","ui.setup.document-root.reload":"Sayfayı yeniden yükle","ui.setup.document-root.success":"Site sunucunuzdaki klasör yapısı doğru şekilde hazırlanmış!","ui.setup.document-root.installingProjectDir":"Uygulama dosyaları {dir} klasörüne kurulacak.","ui.setup.document-root.installingPublicDir":"Herkese açık dosyalar {dir} klasörüne kurulacak.","ui.setup.document-root.installedProjectDir":"Uygulama dosyaları {dir} klasörüne kuruldu.","ui.setup.document-root.installedPublicDir":"Herkese açık dosyalar {dir} klasörüne kuruldu.","ui.setup.create-project.headline":"Contao kurulumu","ui.setup.create-project.description":"Contao geliştirmesi {semver} ilkesini izler. Her altı ayda bir yeni bir küçük sürüm yayınlanır. Şu anda desteklenen sürümler şunlardır:","ui.setup.create-project.semver":"Anlamsal sürümleme","ui.setup.create-project.latestTitle":"Güncel","ui.setup.create-project.ltsTitle":"Uzun dönemli destek","ui.setup.create-project.latestQ1":"Güncel sürümümüz en fazla özelliği sunar ve {year} Şubat ayına kadar desteklenir.","ui.setup.create-project.latestQ3":"Güncel sürümümüz en fazla özelliği sunar ve {year} Ağustos ayına kadar desteklenir.","ui.setup.create-project.ltsText":"Güncel uzun dönem desteklenen sürümümümüz, kararlılık isteyenler içindir. {year} Şubat ayına kadar uzun dönem desteği sunar.","ui.setup.create-project.pltsText":"Önceki uzun dönem desteklenen sürümümüz. Hala {year} Şubat ayına kadar uzun dönem desteği sunuyor.","ui.setup.create-project.requiresPHP":"En az PHP {version} sürümü gereklidir. Sizin sürümünüz PHP {current}.","ui.setup.create-project.releaseplan":"Ayrıntılı bilgi almak için {contaoReleasePlan} bölümüne bakabilirsiniz.","ui.setup.create-project.releaseplanLink":"Contao yayınlanma planı","ui.setup.create-project.installed":"Contao {version} sunucuya kuruldu. Veri tabanınızı kurmaya geçin ya da farklı bir sürüm kurmak için Contao Manager uygulamasını başlatın.","ui.setup.create-project.formTitle":"Bir dağıtım seçin","ui.setup.create-project.formText":"Lütfen kurmak istediğiniz sürümü seçin.","ui.setup.create-project.version":"Sürüm","ui.setup.create-project.demo":"Contao tanıtım sitesini kur","ui.setup.create-project.demoDescription":"Tanıtım sitesi Contao ve onun tüm temel özelliklerini tanımanıza yardımcı olur. Daha fazla temayı {store} üzerinde bulabilirsiniz.","ui.setup.create-project.coreOnly":"En küçük kurulum (yalnızca çekirdek)","ui.setup.create-project.noUpdate":"Kurulumu atla (yalnızca uzmanlar)","ui.setup.create-project.theme":"Contao teması","ui.setup.create-project.themeInstall":"Bir Contao teması kurmak için arama girişini kullanın ya da Contao Manager ile kurulabilen bir tema dosyası (.cto/.zip) yükleyin.","ui.setup.create-project.themeBuy":"Resmi {store} adresini açtığınızdan emin olun.","ui.setup.create-project.themeStore":"Contao tema mağazası","ui.setup.create-project.themeUpload":"Tema dosyasını yükle (.cto/.zip)","ui.setup.create-project.themeInvalid":"Yüklenen dosya bir Contao teması değil ya da Contao Manager uygulamasını desteklemiyor.","ui.setup.create-project.themeWarning":"Contao Manager bu temanın sunucunuzla uyumlu olup olmadığını söyleyemez. Sorularınız varsa lütfen tema satıcısına sorun.","ui.setup.create-project.themeTitle":"Tema bilgilerini gözden geçir","ui.setup.create-project.themeDetails":"Bu temayla birlikte şu bağımlılıklar ve dosyalar yüklenecek.","ui.setup.create-project.themeRequire":"{count} bağımlılık | {count} bağımlılık","ui.setup.create-project.themeFiles":"{count} dosya | {count} dosya","ui.setup.create-project.theme.or":"ya da herkese açık temalar arayın","ui.setup.create-project.theme.search":"Tema ara","ui.setup.create-project.theme.more":"Diğer temalar","ui.setup.create-project.theme.empty":"{query} ile eşleşen bir tema yok","ui.setup.create-project.theme.uploaded":"Tema dosyası yüklendi.","ui.setup.create-project.theme.packageName":"Paket adı","ui.setup.create-project.theme.version":"Sürüm","ui.setup.create-project.theme.authors":"Geliştirici(ler)","ui.setup.create-project.install":"Kur","ui.setup.create-project.cancel":"İptal","ui.setup.database-connection.headline":"Veri tabanı bağlantısı","ui.setup.database-connection.description":"Contao, sayfaları, içerikleri, kullanıcıları ve diğer ilişkisel verileri depolamak için bir MySQL veri tabanı (ya da MariaDB gibi uyumlu bir dalı) kullanır. Bağlantı parametreleri, Contao kurulumunuzun proje kök klasöründeki {env} dosyasında bulunur.","ui.setup.database-connection.formTitle":"Bağlantı parametreleri","ui.setup.database-connection.formText":"Bir veri tabanı adresi yazın ya da tek tek kullanıcı adı, parola, sunucu ve veri tabanı alanlarını doldurun.","ui.setup.database-connection.url":"Veri tabanı adresi","ui.setup.database-connection.validUrl":"Veri tabanı adresi geçersiz ya da sunucu bağlantısı kurulamadı.","ui.setup.database-connection.or":"ya da","ui.setup.database-connection.user":"Kullanıcı adı","ui.setup.database-connection.password":"Parola","ui.setup.database-connection.server":"Sunucu (:bağlantı noktası)","ui.setup.database-connection.database":"Veri tabanı adı","ui.setup.database-connection.connected":"{server} üzerindeki {database} veri tabanı ile bağlantı kuruldu.","ui.setup.database-connection.error":"Veri tabanı bağlantısı kurulurken sorun çıktı.","ui.setup.database-connection.problem":"Contao veri tabanı sunucunuzda bir sorunla karşılaştı.","ui.setup.database-connection.schemaTitle":"Veri tabanı şeması","ui.setup.database-connection.migration":"Bekleyen bir aktarım var. | Bekleyen {count} aktarım var.","ui.setup.database-connection.schema":"Bekleyen bir şema güncellemesi var. | Bekleyen {count} şema güncellemesi var.","ui.setup.database-connection.noChanges":"Veri tabanı şemanız güncel","ui.setup.database-connection.check":"Veri tabanını denetle","ui.setup.database-connection.skip":"Atla","ui.setup.database-connection.save":"Kaydet","ui.setup.database-connection.change":"Kimlik doğrulama bilgilerini değiştir","ui.setup.database-connection.restoreTitle":"Veri tabanı içe aktarma","ui.setup.database-connection.restoreText":"Yeni kurduğunuz temada bir veri tabanı yedeği var. Tema verilerini içe aktarmak için veri tabanını geri yükleyin ya da boş bir Contao kurulumuyla başlamak için bu adımı atlayın. | Yeni kurduğunuz temada birkaç veri tabanı yedeği var. Tema verilerini içe aktarmak için bir yedekleme dosyası seçin ya da boş bir Contao kurulumuyla başlamak için bu adımı atlayın.","ui.setup.database-connection.backup":"İçe aktarma işleminden önce geçerli veri tabanının yedeğini alın","ui.setup.database-connection.backupWarning":"İçe aktarım işlemi sırasında veri tabanındaki tüm verilerin üzerine yazılır! Veri tabanı boş değilse öncelikle bir yedeğini alın.","ui.setup.database-connection.restore":"Tema veri tabanını içe aktar","ui.setup.database-connection.restoreOption":"{date} yedeği ({size})","ui.setup.database-connection.restored":"Tema veri tabanınız içe aktarıldı. Veri tabanı şemanızı doğrulamak için ilerleyin.","ui.setup.backend-user.success":"Veri tabanınızda Contao yönetim bölümü için bir yönetici hesabı bulundu. Daha fazla kullanıcı eklemek için Contao yönetim bölümünü kullanın.","ui.setup.backend-user.error":"Kullanıcı listesi alınamadı. Ayrıntılar için konsol çıktısına bakın.","ui.setup.backend-user.headline":"Yönetim bölümü hesabı","ui.setup.backend-user.description":"Sitenizi yönetmek için Contao yönetim bölümüne erişebilecek en az bir yönetici hesabınızın olması gerekir. Bu hesabın Contao Manager ile ilgili olmadığını unutmayın.","ui.setup.backend-user.formTitle":"Hesap aç","ui.setup.backend-user.formText":"Yeni yönetim bölümü hesabının ayrıntılarını yazın.","ui.setup.backend-user.username":"Kullanıcı adı","ui.setup.backend-user.name":"Ad","ui.setup.backend-user.email":"E-posta adresi","ui.setup.backend-user.emailInvalid":"Lütfen geçerli bir e-posta adresi yazın","ui.setup.backend-user.password":"Parola","ui.setup.backend-user.passwordPlaceholder":"en az 8 karakter","ui.setup.backend-user.passwordLength":"Lütfen en az 8 karakter yazın.","ui.setup.backend-user.create":"Hesap ekle","ui.task.headline":"Arka plan görevi","ui.task.loading":"Ayrıntılar yükleniyor…","ui.task.created":"Ayrıntılar yükleniyor…","ui.task.active":"Lütfen Contao Manager arka planda görev işlemlerini yürütürken bekleyin.","ui.task.complete":"Tüm işlemler tamamlandı. Ayrıntılı bilgi almak için konsol çıktısına bakın.","ui.task.paused":"Bir arka plan görevi beklenmedik şekilde durdu. Lütfen konsol çıktısını denetleyin.","ui.task.aborting":"Lütfen arka plan işlemleri iptal edilirken bekleyin.","ui.task.stopped":"Bazı arka plan görevleri iptal edildi. Lütfen konsol çıktısını denetleyin.","ui.task.error":"Bir arka plan görevi beklenmedik şekilde durdu. Lütfen konsol çıktısını denetleyin.","ui.task.failed":"Contao Manager bir arka plan görevini başlatamadı!","ui.task.failedDescription1":"İşlemler arka planda yürütülmeye çalışılırken bir sorun çıktı.","ui.task.failedDescription2":"Bu sorun yeniden yaşanırsa sunucunuz desteklenmiyor olabilir.","ui.task.reportProblem":"Sorun bildir","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud {sponsor} tarafından destekleniyor","ui.task.buttonAudit":"Veri tabanını güncelle","ui.task.buttonClose":"Kapat","ui.task.buttonConfirm":"Onaylayıp kapat","ui.task.buttonContinue":"İlerle","ui.task.buttonCancel":"İptal","ui.task.confirmCancel":"Bu görevi iptal etmek istediğinize emin misiniz? Bu durum Contoa kurulumunuzu bozuk bir durumda bırakabilir!","ui.task.autoclose":"Başarılı işlemlerin görev ayrıntıları kapatılsın","ui.console.toggle":"Konsol çıktısını görüntüle/gizle","ui.console.showLog":"Tüm konsol günlüğünü görüntüle","ui.console.copyLog":"Günlüğü panoya kopyala","ui.migrate.headline":"Veri tabanı güncellemeleri","ui.migrate.migrationsOnly":"(yalnızca aktarımlar)","ui.migrate.schemaOnly":"(yalnızca şema)","ui.migrate.loading":"Lütfen veri tabanınız incelenirken bekleyin…","ui.migrate.empty":"Bekleyen bir aktarım ya da şema güncellemesi bulunamadı. Veri tabanınız güncel.","ui.migrate.emptyMigrations":"Bekleyen bir aktarım bulunamadı. Şema güncellemelerini de denetlediğinizden emin olun.","ui.migrate.emptySchema":"Bekleyen bir şema güncellemesi bulunamadı. Aktarımları da denetlediğinizden emin olun.","ui.migrate.pending":"Veri tabanınız güncel değil. Lütfen aşağıdaki konsol çıktısını denetleyip istenilen değişiklikleri yapın.","ui.migrate.previousChanges":"Daha önceki bir veri tabanı aktarma işlemi onaylanmamış.\\nLütfen aşağıdaki konsol çıktısını denetleyip sonraki değişiklikleri görmek için ilerleyin.","ui.migrate.previousComplete":"Daha önceki bir veri tabanı aktarma işlemi onaylanmamış. Lütfen aşağıdaki konsol çıktısını denetleyin. Bekleyen başka bir değişiklik yok.","ui.migrate.appliedChanges":"Veri tabanı güncellemeleri yapıldı.\\nLütfen aşağıdaki konsol çıktısını denetleyip sonraki değişiklikleri görmek için ilerleyin.","ui.migrate.appliedComplete":"Veri tabanı güncellemeleri yapıldı.\\nBekleyen başka bir aktarım ya da şema güncellemesi yok. Veri tabanınız güncel.","ui.migrate.problem":"Contao, veri tabanı sunucunuzda bazı sorunlarla karşılaştı.\\nNeyin düzeltilmesi gerektiğini öğrenmek için aşağıdaki konsol çıktısını inceleyin. | Contao, veri tabanı sunucunuzda bazı sorunlarla karşılaştı.\\nNeyin düzeltilmesi gerektiğini öğrenmek için aşağıdaki konsol çıktısını inceleyin.","ui.migrate.warning":"Contao, veri tabanı sunucunuzun yanlış yapılandırıldığını algıladı.\\nUyarıları geçici olarak atlayabilirsiniz. Ancak en iyi başarım ve veri bütünlüğü için bu sorunları düzeltmelisiniz.","ui.migrate.error":"Değişiklikler uygulanamadı. Veri tabanınız değişmiş olabilir. Lütfen yeniden denetleyin.","ui.migrate.execute":"Yürüt","ui.migrate.close":"Kapat","ui.migrate.confirm":"Onaylayıp kapat","ui.migrate.cancel":"İptal","ui.migrate.continue":"İlerle","ui.migrate.setup":"Kurulum","ui.migrate.skip":"Atla","ui.migrate.retry":"Yeniden denetle","ui.migrate.retryAll":"Tümünü denetle","ui.migrate.withDeletes":"DROP sorguları ile birlikte tüm veri tabanı değişikliklerini yürütür.","ui.migrate.migrationTitle":"Veri tabanı aktarımları","ui.migrate.schemaTitle":"Şema güncellemeleri","ui.migrate.problemTitle":"Veri tabanı sorunları","ui.migrate.warningTitle":"Veri tabanı uyarıları","ui.migrate.addTable":"{table} tablosunu ekle","ui.migrate.dropTable":"{table} tablosunu sil","ui.migrate.addField":"{table}.{field} alanını ekle","ui.migrate.changeField":"{table}.{field} alanını değiştir","ui.migrate.dropField":"{table}.{field} alanını sil","ui.migrate.createIndex":"{table} tablosuna \\"{name}\\" dizinini ekle ","ui.migrate.dropIndex":"{table} tablosundan \\"{name}\\" dizinini kaldır","ui.widget.mandatory":"Bu alan boş bırakılamaz.","ui.widget.blankOption":"Lütfen seçin…","ui.widget.showPassword":"Parolayı görüntüle","ui.widget.hidePassword":"Parolayı gizle","ui.error.title":"\\"{method} {url}\\" için HTTP isteği başarısız oldu.","ui.error.server500":"Sunucunuzda beklenmeyen bir sorun çıkmış gibi görünüyor. Lütfen site sunucunuzun (Apache/Nginx) günlük dosyalarını ve \\"contao-manager/logs\\" konumundaki Contao Manager günlüklerini denetleyin.","ui.error.response":"Sunucu, {status} durum koduyla bir yanıt verdi.","ui.error.moreLink":"Ayrıntılı bilgiler","ui.error.support":"Contao desteği","ui.error.permission":"Bu özelliği kullanma izniniz yok.","ui.footer.help":"Yardım","ui.footer.reportProblem":"Sorun bildir","ui.navigation.discover":"Keşfet","ui.navigation.packages":"Paketler","ui.navigation.tools":"Araçlar","ui.navigation.installTool":"Kurulum aracı","ui.navigation.backend":"Contao yönetim bölümü","ui.navigation.debug":"Contao hata ayıklama kipi","ui.navigation.logViewer":"Günlük görüntüleyici","ui.navigation.phpinfo":"PHP bilgileri","ui.navigation.phpinfoLoading":"PHP bilgileri yükleniyor…","ui.navigation.maintenance":"Bakım","ui.navigation.rebuildCache":"Ön belleği yeniden oluştur","ui.navigation.users":"Hesaplar","ui.navigation.systemCheck":"Sistem denetimi","ui.navigation.advanced":"Gelişmiş","ui.navigation.logout":"Oturumu kapat","ui.maintenance.database.title":"Veri tabanı aktarımları ve yedekler","ui.maintenance.database.description":"Veri tabanı aktarımları verilerin ve tablo şemalarının tutarlı olduğundan emin olur.","ui.maintenance.database.migrations":"Bekleyen bir veri tabanı aktarımı var | Bekleyen {count} veri tabanı aktarımı var","ui.maintenance.database.schemaUpdates":"Bekleyen bir şema güncellemesi var. | Bekleyen {count} şema güncellemesi var","ui.maintenance.database.error":"Veri tabanı sorunu bulundu.","ui.maintenance.database.warning":"Veri tabanı uyarıları bulundu.","ui.maintenance.database.button":"Veri tabanını denetle","ui.maintenance.database.migrationOnly":"Yalnızca aktarımları denetle","ui.maintenance.database.schemaOnly":"Yalnızca şemayı denetle","ui.maintenance.database.installTool":"Kurulum aracını aç","ui.maintenance.database.createBackup":"Yedek oluştur","ui.maintenance.database.backupUnsupported":"Contao sürümünüzde veri tabanı yedekleri desteklenmiyor.","ui.maintenance.database.backupList":"{date} tarihinde oluşturulmuş bir veri tabanı yedeğiniz var. | {count} veri tabanı yedeğiniz var. En sonuncusu {date} tarihinde oluşturulmuş.","ui.maintenance.database.backupEmpty":"Şu anda herhangi bir veri tabanı yedeğiniz yok.","ui.maintenance.rebuildCache.title":"Uygulama ön belleği","ui.maintenance.rebuildCache.description":"Yapılandırma dosyalarında bir değişiklik yapıldığında uygulama ön belleğinin yeniden oluşturulması gerekir.","ui.maintenance.rebuildCache.rebuildProd":"Üretim ön belleğini yeniden oluştur","ui.maintenance.rebuildCache.rebuildDev":"Geliştirme ön belleğini yeniden oluştur","ui.maintenance.rebuildCache.clearProd":"Üretim ön belleğini temizle","ui.maintenance.rebuildCache.clearDev":"Geliştirme ön belleğini temizle","ui.maintenance.installTool.title":"Contao kurulum aracı","ui.maintenance.installTool.description":"Arka arkaya üç kez yanlış parola yazarsanız Contao kurulum aracı otomatik olarak kilitlenir.","ui.maintenance.installTool.unlock":"Kurulum aracının kilidini aç","ui.maintenance.installTool.lock":"Kurulum aracını kilitle","ui.maintenance.dumpAutoload.title":"Composer sınıf yükleyicisi","ui.maintenance.dumpAutoload.description":"Composer otomatik yükleyici, PHP sınıfının yüklenmesinden sorumludur. Kök klasördeki composer.json dıosyasına özel ad alanları eklendikten sonra otomatik yükleyici indirilmelidir.","ui.maintenance.dumpAutoload.button":"Otomatik yükleyiciyi indir","ui.maintenance.composerInstall.title":"Composer bağımlılıkları","ui.maintenance.composerInstall.description":"Composer bağımlılıkları uygulama kök klasörünüzün altındaki [vendor] klasöründe bulunur. [composerLock] dosyası değiştirildikten ya da el ile yüklendikten sonra bağımlılıkları yeniden kurmak gerekebilir.","ui.maintenance.composerInstall.button":"Kurucuyu başlat","ui.maintenance.composerInstall.update":"Composer güncellemesini başlat","ui.maintenance.composerCache.title":"Composer ön belleği","ui.maintenance.composerCache.description":"Composer, daha iyi başarım sağlamak için indirilen paketleri ön belleğe alır. Ön bellekte bozuk dosyalar gibi sorunlarınız varsa, paketlerin yeniden indirilmesini dayatmak için Composer ön belleğini silmeyi deneyin.","ui.maintenance.composerCache.button":"Ön belleği temizle","ui.maintenance.maintenanceMode.title":"Bakım kipi","ui.maintenance.maintenanceMode.description":"Contao bakım kipine geçirildiğinde, sitede \\"503 Hizmet Kullanılamıyor\\" kalıbı görüntülenir.","ui.maintenance.maintenanceMode.enable":"Etkinleştir","ui.maintenance.maintenanceMode.disable":"Etkisizleştir","ui.maintenance.debugMode.title":"Hata ayıklama kipi","ui.maintenance.debugMode.description":"[appDevPhp] giriş noktası için bir kullanıcı adı ve parola ayarlayarak hata ayıklama kipini etkinleştirin.","ui.maintenance.debugMode.descriptionJwt":"Geçerli etki alanı için hata ayıklama çerezini ayarlayarak hata ayıklama kipini etkinleştirin.","ui.maintenance.debugMode.activate":"Etkinleştir","ui.maintenance.debugMode.deactivate":"Etkisizleştir","ui.maintenance.debugMode.credentials":"Kimlik doğrulama bilgileri","ui.maintenance.debugMode.user":"Lütfen hata ayıklama kipi için bir kullanıcı adı yazın.","ui.maintenance.debugMode.password":"Lütfen hata ayıklama kipi için bir parola yazın.","ui.maintenance.opcodeCache.title":"Opcode ön belleği","ui.maintenance.opcodeCache.description":"Opcode, daha hızlı işlem yapmak için PHP dosyalarını site işleminde ön belleğe alır. Dosyaların değiştirildikten sonra tanınmaması gibi belirli durumlarda silinmelidir.","ui.maintenance.opcodeCache.button":"Ön belleği buda","ui.maintenance.safeMode":"Güvenli kipte kullanılamaz","ui.maintenance.unsupported":"Contao sürümünüz tarafından desteklenmiyor","ui.packages.updateButton":"Paketleri güncelle","ui.packages.searchButton":"Paket arama","ui.packages.searchPlaceholder":"Paketleri ara…","ui.packages.uploadOverlay":"Yüklemek için dosyaları sürükleyip buraya bırakın","ui.packages.uploadButton":"Paketleri yükle","ui.packages.uploadMessage":"Bir onaylanmamış yüklemeniz var. | {count} onaylanmamış yüklemeniz var.","ui.packages.uploadApply":"Yüklemeleri onayla","ui.packages.uploadReset":"Yüklemeleri sil","ui.packages.uploadIncomplete":"Bu dosya tam olarak yüklenmedi. Lütfen kaldırıp yeniden deneyin.","ui.packages.uploadDuplicate":"Bu dosya birden çok kez yüklenmiş gibi görünüyor. Lütfen kopyaları kaldırın.","ui.packages.uploadInstalled":"Bu dosya zaten kurulmuş. Lütfen kopyaları kaldırın.","ui.packages.uploadUnsupported":"Kurulumunuzda yükleme özelliği desteklenmiyor. Lütfen PHP ZIP eklentisinin kurulmuş olduğundan ve bağımlılıklarınızı güncellediğinizden emin olun.","ui.packages.changesMessage":"Bir onaylanmamış değişikliğiniz var. | {count} onaylanmamış değişikliğiniz var.","ui.packages.changesDryrun":"Değişiklik yapmadan dene","ui.packages.changesApply":"Değişiklikleri uygula","ui.packages.changesApplyAll":"Tüm paketleri güncelle","ui.packages.changesDryrunAll":"Tüm paketleri değişiklik yapmadan dene","ui.packages.changesReset":"Değişiklikleri sıfırla","ui.packages.changesReview":"Değişiklikleri gözden geçir","ui.packagelist.loading":"Yükleniyor…","ui.packagelist.uploads":"Yüklemeler","ui.packagelist.added":"Yeni paketler","ui.packagelist.installed":"Kurulmuş paketler","ui.package.hintRevert":"Değişiklikleri geri al","ui.package.hintNoupdate":"Güncelleme","ui.package.hintConstraint":"Değişiklikleri uyguladığınızda, bu paket {constraint} kısıtlaması ile kurulacak.","ui.package.hintConstraintBest":"Değişiklikleri uyguladığınızda, bu paket kullanılabilecek en iyi sürüm ile kurulacak.","ui.package.hintConstraintChange":"Değişiklikleri uyguladığınızda, bu paketin kısıtlamaları \\"{from}\\" yerine \\"{to}\\" olarak değiştirilecek.","ui.package.hintConstraintUpdate":"Değişiklikleri uyguladığınızda, bu paket güncellenecek.","ui.package.hintAdded":"Değişiklikleri uyguladığınızda, bu paket kurulacak.","ui.package.hintRemoved":"Değişiklikleri uyguladığınızda, bu paket kaldırılacak.","ui.package.requiredTitle":"el ile eklendi","ui.package.requiredText":"Bu paket composer.json dosyanızda gerekli olarak belirtilmiş ancak kurulmamış.","ui.package.removedTitle":"el ile kaldırıldı","ui.package.removedText":"Bu paket composer.json dosyanızdan kaldırılmış.","ui.package.installed":"Şu anda kurulu olan:","ui.package.version":"{version} sürümü","ui.package.additionalDownloads":"{count} indirme | {count} indirme","ui.package.additionalStars":"{count} yıldız | {count} yıldız","ui.package.editConstraint":"Düzenle","ui.package.uploadConstraint":"Bu kısıtlama yüklenen paket tarafından tanımlandı.","ui.package.updateButton":"Güncelle","ui.package.removeButton":"Kaldır","ui.package.installButton":"Paket ekle","ui.package.installButtonShort":"Ekle","ui.package.detailsButton":"Ayrıntılar","ui.package.latestConstraint":"güncel sürüm","ui.package.update":"Güncelleme yayınlanmış","ui.package.updateLatest":"güncel sürüm","ui.package.updateAvailable":"{version} yayınlanmış","ui.package.updateUnknown":"sürüm bilinmiyor","ui.package.updateConstraint":"Sürüm kısıtlamanızın dışında yeni bir sürüm yayınlanmış.","ui.package.incompatible":"{package} Contao {constraint} ile çalışmayacak.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"{version} sürümü","ui.cloudStatus.waitingTime":"Bekleme zamanı","ui.cloudStatus.jobs":"Geçerli görevler","ui.cloudStatus.workers":"İşlemler","ui.cloudStatus.approx":"{minutes} dakika","ui.cloudStatus.none":"yok","ui.cloudStatus.short":"ca. {minutes} dakika","ui.cloudStatus.long":"ca. {minutes} dakika {seconds} saniye","ui.cloudStatus.error":"Composer Resolver Cloud durumu alınamıyor. Kaynak bakım yüzünden kapalı ya da sorunlar nedeniyle erişilemiyor olabilir.","ui.cloudStatus.button":"Cloud durumu","ui.cloudStatus.refresh":"Cloud durumunu yenile","ui.log-viewer.loading":"Yükleniyor…","ui.log-viewer.empty":"Sunucunuzda herhangi bir günlük dosyası yok.","ui.log-viewer.reload":"Yeniden yükle","ui.log-viewer.file":"Günlük dosyası","ui.log-viewer.channel":"Kanal","ui.log-viewer.channelTitle":"Bu iletinin günlüğe kaydedileceği kanal.","ui.log-viewer.level":"Düzey","ui.log-viewer.levelTitle":"Günlük iletisinin önem düzeyi.","ui.log-viewer.timeHeader":"Zaman","ui.log-viewer.messageHeader":"İleti","ui.log-viewer.showContext":"Bağlamı görüntüle","ui.log-viewer.hideContext":"Bağlamı gizle","ui.log-viewer.showExtra":"Ekleri görüntüle","ui.log-viewer.hideExtra":"Ekleri gizle","ui.log-viewer.more":"Sonrakileri yükle…","ui.log-viewer.download":"İndir","ui.log-viewer.downloadTitle":"\\"{file}\\" dosyasını indir","ui.log-viewer.prodEnvironment":"Üretim ortamı","ui.log-viewer.devEnvironment":"Geliştirme ortamı (hata ayıklama kipi)","ui.user-manager.loading":"Kullanıcılar yükleniyor…","ui.user-manager.changePassword":"Parolayı değiştir","ui.user-manager.setupTotp":"İki adımlı doğrulamayı kur","ui.user-manager.disableTotp":"İki adımlı doğrulamayı kapat","ui.user-manager.invite":"Kullanıcı davet et","ui.user-manager.delete":"Sil","ui.user-manager.deleteConfirm":"\\"{username}\\" kullanıcısını silmek istediğinize emin misiniz?","ui.user-manager.deleted":"{username} kullanıcı adı silindi","ui.user-manager.passwordHeadline":"Parolayı değiştir","ui.user-manager.passwordText":"Parolanızı değiştirmek için, ilgili alanlara geçerli ve yeni parolayı yazın.","ui.user-manager.currentPassword":"Geçerli parola","ui.user-manager.newPassword":"Yeni parola","ui.user-manager.passwordPlaceholder":"en az 8 karakter","ui.user-manager.submitPassword":"Gönder","ui.user-manager.passwordChanged":"Parolanız değiştirildi.","ui.user-manager.passwordError":"Parola yanlış.","ui.user-manager.inviteHeadline":"Kullanıcı davet et","ui.user-manager.inviteText":"Contao Manager için birden fazla oturum açmaya gerek duyuyorsanız, buradan bir davet bağlantısı oluşturabilirsiniz. Bu bağlantıyı biriyle paylaşın veya verilen izinlerle yeni bir hesap açmak için başka bir aygıt üzerinde kullanın.","ui.user-manager.inviteSuccess1":"Yeni bir davet bağlantısı oluşturuldu. Aşağıdaki adres, bu Contao Manager üzerinde yeni bir kullanıcı hesabı oluşturmak için kullanılabilir. Davetiyenin geçerliliği {expires} tarihinde sona erecek (bir hafta sonra).","ui.user-manager.inviteSuccess2":"Lütfen bağlantıyı panonuza kopyalayın. Yalnızca bir kez çalışacak ve bu pencereyi kapattıktan sonra yeniden göremeyeceksiniz.","ui.user-manager.createInvitation":"Davet bağlantısı oluştur","ui.user-manager.clipboard":"Panoya kopyala","ui.user-manager.permissions":"İzinler hakkında bilgi alın","ui.user-manager.cancel":"İptal","ui.user-manager.close":"Kapat","ui.user-manager.you":"Siz","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"İki adımlı doğrulama","ui.totp.setupQr":"Lütfen kare kodu iki adımlı doğrulama uygulamanızla tarayın.","ui.totp.setupCode":"Kare kodu tarayamıyorsanız şu anahtarı yazabilirsiniz:","ui.totp.codeLabel":"Doğrulama kodu","ui.totp.codeDescription":"Lütfen iki adımlı doğrulama uygulamanızın ürettiği doğrulama kodunu yazın.","ui.totp.disableText":"İki adımlı doğrulamayı kapatmak için lütfen doğrulama kodunu yazın.","ui.totp.invalid":"Doğrulama kodu geçersiz.","ui.totp.enable":"Etkinleştir","ui.totp.disable":"Etkisizleştir","ui.totp.cancel":"İptal","ui.totp.enabled":"İki adımlı doğrulama açıldı.","ui.totp.disabled":"İki adımlı doğrulama kapatıldı.","ui.totp.setup":"İki adımlı doğrulamayı kur","ui.totp.skip":"İki adımlı doğrulamayı atla"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[953],{3953:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Extensions","ui.app.loading":"Laddar tilläggslista …","ui.app.language":"Byt språk för Contao Manager","ui.app.colorDark":"Mörkt läge","ui.app.colorDarkTitle":"Byt färgschema till mörkt","ui.app.colorLight":"Ljusläge","ui.app.colorLightTitle":"Byt färgschema till ljus","ui.discover.advertisement":"Annons i tilläggslistan","ui.discover.loading":"Laddning ...","ui.discover.offline":"Det gick inte att hämta några resultat.","ui.discover.offlineExplain":"Kontrollera din internetanslutning och inaktivera JavaScript-blockerare i din webbläsare.","ui.discover.offlineButton":"Försök igen","ui.discover.searchPlaceholder":"Sök i {count} tillägg …","ui.discover.empty":"Inga resultat för {query}","ui.discover.more":"Fler resultat","ui.discover.sortBy":"Sortera efter","ui.discover.sortReleased":"Släppte","ui.discover.sortReleasedTitle":"Sortera resultat efter releasedatum","ui.discover.sortLatest":"Uppdaterad","ui.discover.sortLatestTitle":"Sortera resultat efter senast uppdaterade","ui.discover.sortDownloads":"Nedladdningar","ui.discover.sortDownloadsTitle":"Sortera resultat efter antal nedladdningar","ui.discover.sortFavers":"Betyg","ui.discover.sortFaversTitle":"Sortera resultat efter betyg","ui.discover.detailsButton":"Detaljer","ui.discover.latestPackages":"Senaste och uppdaterade tillägg","ui.discover.faversPackages":"Högst rankade tillägg","ui.discover.downloadsPackages":"Mest nedladdade tillägg","ui.package.homepage":"Projektets hemsida","ui.package.private":"Privat paket","ui.package.privateTitle":"Privata paket är endast tillgängliga från leverantören (t.ex. som en ZIP-nedladdning). Besök gärna webbplatsen för mer information.","ui.package.abandoned":"övergiven","ui.package.abandonedText":"Detta paket är övergivet och underhålls inte längre.","ui.package.abandonedReplace":"Detta paket är övergivet och underhålls inte längre. Författaren föreslår att du istället använder paketet {replacement}.","ui.package.contaoVersion":"Tillgänglig för Contao","ui.package-details.previous":"Tidigare tilläggsinformation","ui.package-details.close":"Stäng tilläggsinformation","ui.package-details.loading":"Laddning ...","ui.package-details.tabDescription":"Beskrivning","ui.package-details.tabRequire":"Krav","ui.package-details.tabFeatures":"Funktioner","ui.package-details.tabSuggest":"Förslag","ui.package-details.tabConflict":"Konflikter","ui.package-details.tabDependents":"Anhöriga","ui.package-details.linkRequires":"kräver","ui.package-details.linkReplaces":"ersätter","ui.package-details.linkProvides":"tillhandahåller","ui.package-details.linkConflicts":"konflikter","ui.package-details.funding":"Underhåll av fondpaket!","ui.package-details.contaoVersions":"Stödd Contao version(er)","ui.package-details.latest":"Senaste versionen","ui.package-details.released":"släppt på","ui.package-details.license":"Licens(er)","ui.package-details.authors":"från","ui.package-details.more":"Mer","ui.package-details.packagist":"Paketdetaljer","ui.package-details.metadata":"Redigera metadata","ui.package-details.support_docs":"Dokumentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Supportforum","ui.package-details.support_issues":"Problem/felrapport","ui.package-details.support_source":"Källkod","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-post","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[958],{2958:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Kevreadur diasur !!","ui.app.httpsDescription":"Hep HTTPS ho roadennoù kuzhut a vo treuzkaset dirinegañ.","ui.app.httpsLink":"Muioc\'h a ditouroù","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.loading":"O kargañ Contao Manager ...","ui.app.apiError":"Statud API dic\'hortoz","ui.app.configSecurity1":"SECURITY ALERT !!! Unprotected config directory detected","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Degemer mat","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"Kont implijer","ui.account.description":"Da verañ ho staliadur, krouit ur gont mar plij evit Contao Manager. Deoc\'h da c\'houzout n\'eo ket liammet d\'ar c\'hontoù Contao back end pe front end.","ui.account.username":"Anv-implijer","ui.account.password":"Ger-tremen","ui.account.passwordConfirm":"Adskrivit ar ger-tremen","ui.account.passwordPlaceholder":"min. 8 arouezenn","ui.account.passwortLength":"Ebarzhit da vihanañ 8 arouezenn.","ui.account.passwortDifferent":"Ar ger-tremen na glot ket gant ar c\'hadarnadur.","ui.account.submit":"Krouiñ ur gont","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"Kevreañ","ui.login.description":"Kevreit evit merañ ho staliadur.","ui.login.username":"Anv-implijer","ui.login.password":"Ger-tremen","ui.login.forgotPassword":"Ankouaet ho ker-tremen?","ui.login.button":"Kevreañ","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Session Timeout","ui.logout.warning":"Your have been inactive for more than 25 minutes. For security reasons your session will be terminated shortly.","ui.logout.expired":"Your session was automatically terminated because you have been inactive for more than 30 minutes.","ui.logout.renew":"Keep Logged In","ui.logout.logout":"Digevreañ","ui.logout.login":"Back To Login","ui.oauth.error":"Invalid OAuth attempt. Check the request parameters.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"The following application or service is requesting remote access to your Contao Manager instance.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.allow":"Allow Access","ui.oauth.deny":"Deny Access","ui.boot.headline":"Gwiriadur ar reizhad","ui.boot.description":"Please wait, we are analyzing your server …","ui.boot.issue1":"Kudennoù diguzhet en ur staliañ","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"Loc\'hañ Contao Manager","ui.recovery.headline":"System Recovery","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"Automatic Repair","ui.recovery.repairDescription":"Attempts to automatically repair the installation by rebuilding the application cache and re-installing the Composer packages.","ui.recovery.repairWarning":"Any modifications to the vendor files might be deleted in the process!","ui.recovery.repairFailed":"Automatic repair was not successful. Try the Safe Mode to manually repair the installation.","ui.recovery.repairButton":"Run System Repair","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Launching the Contao Manager in Safe Mode allows to manage packages and run certain maintenance tasks, but features that rely on a working Contao installation will not be available.","ui.recovery.safeModeButton":"Launch in Safe Mode","ui.server.pending":"Waiting …","ui.server.running":"Oc\'h analizañ ...","ui.server.error":"Check failed due to an unexpected response from the server.","ui.server.details":"Munudoù","ui.server.prerequisite":"Check cancelled due to a missing prerequisite.","ui.server.selfUpdate.title":"Hizivadurioù Contao Manager","ui.server.selfUpdate.update":"Ur stumm nevez eus Contao Managaer a zo hegerz: {latest}.","ui.server.selfUpdate.manualUpdate":"A new Contao Manager version {latest} is available. Your server does not support automatic updates, please download the new version from {download}.","ui.server.selfUpdate.latest":"You are using the latest version {current}.","ui.server.selfUpdate.dev":"Development builds do not support automatic updates.","ui.server.selfUpdate.unsupported":"A new version is available but it does not support your PHP version.","ui.server.selfUpdate.button":"Seveniñ an em-hizivaat","ui.server.selfUpdate.continue":"Continue","ui.server.config.title":"Kefluniadur ar servijer","ui.server.config.setup":"Kefluniañ","ui.server.config.change":"Cheñch","ui.server.config.save":"Enrollañ","ui.server.config.blankOption":"Diuzit mar plij ...","ui.server.config.customOption":"Traoù all ...","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Kefluniadur ar servijer","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Use the Composer Resolver Cloud","ui.server.config.cli":"PHP daouel","ui.server.config.stateErrorCli":"No valid PHP binary was found on the server.","ui.server.config.stateErrorCloud":"The Composer Resolver Cloud is not supported.","ui.server.config.stateSuccess":"PHP binary at {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Found PHP version {version}. Please switch to PHP 7 as soon as possible!","ui.server.php_web.success":"Found PHP version {version}, no known issues found.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Found PHP version {version}, no known issues found.","ui.server.composer.title":"Endro kompozer","ui.server.composer.success":"N\'eus bet kavet kudenn ebet.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Run Composer","ui.server.composer.safeMode":"Run Safe Mode","ui.server.contao.title":"Staliadur Contao","ui.server.contao.setup":"Setup","ui.server.contao.empty":"Staliadur Contao ebet bet kavet","ui.server.contao.old":"Contao version {version} is not compatible with the Contao Manager, please update your installation manually.","ui.server.contao.found":"Kavet Contao {version} (API stumm {api}).","ui.server.contao.headline":"Kefluniadur Contao","ui.server.contao.description":"Welcome to the setup process of your Contao Open Source CMS. You can choose between two versions to install.","ui.server.contao.publicDir":"Use {dir} for public files (for Contao {version})","ui.server.contao.ltsTitle":"Skor war hir amzer","ui.server.contao.ltsText":"The LTS version has an extended support period of up to four years.","ui.server.contao.latestTitle":"Diwezhatañ","ui.server.contao.latestText":"A new latest version is released every six months in February and August.","ui.server.contao.noLatest":"Requires at least PHP {version}.","ui.server.contao.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.server.contao.releaseplanLink":"Contao Release Plan","ui.server.contao.formTitle":"Staliadur Contao","ui.server.contao.formText":"Select the Contao version to install.","ui.server.contao.version":"Stumm","ui.server.contao.coreOnly":"Initial Setup","ui.server.contao.coreOnlyNo":"Full Installation (News, Calendar, etc.)","ui.server.contao.coreOnlyYes":"Minimal Installation (Core only)","ui.server.contao.coreOnlyFeatures":"What\'s the difference?","ui.server.contao.noUpdate":"Skip Installation (Expert Only!)","ui.server.contao.install":"Finish","ui.server.docroot.headline":"Webserver Setup","ui.server.docroot.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.server.docroot.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed right now, because your folder structure is not correct or the folders are not empty.","ui.server.docroot.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.server.docroot.documentation":"Read the Documentation","ui.server.docroot.conflictsTitle":"Installation directory not empty","ui.server.docroot.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and reload the page if you are sure they are unused.","ui.server.docroot.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.server.docroot.create":"Create directories","ui.server.docroot.formTitle":"Directory Setup","ui.server.docroot.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.server.docroot.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.server.docroot.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.server.docroot.directory":"New Directory","ui.server.docroot.currentRoot":"Current Document Root","ui.server.docroot.newRoot":"New Document Root","ui.server.docroot.finish":"Setup Directories","ui.server.docroot.directoryInvalid":"Please enter a valid directory name.","ui.server.docroot.directoryExists":"The target directory already exists. Please enter a different name.","ui.server.docroot.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.server.docroot.reload":"Reload Page","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"Danevelliñ ur gudenn","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"Serriñ","ui.task.buttonConfirm":"Kadarnaat & ha serriñ","ui.task.buttonCancel":"Nullañ","ui.task.confirmCancel":"Are you sure to cancel this task? This might leave your Contao installation in a broken state!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"Show/Hide Console Output","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.widget.mandatory":"Ar vaezienn-mañ n\'hall ket bezañ goullo.","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"Muioc\'h a ditouroù","ui.error.support":"Contao Support","ui.footer.help":"Skoazell","ui.footer.reportProblem":"Danevelliñ ur gudenn","ui.navigation.discover":"Discover","ui.navigation.packages":"Pakadoù","ui.navigation.tools":"Ostilhoù","ui.navigation.installTool":"Staliañ an ostilh","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode","ui.navigation.phpinfo":"PHP Information","ui.navigation.maintenance":"Trezalc\'h","ui.navigation.rebuildCache":"Adsevel ar c\'hrubuilh","ui.navigation.systemCheck":"Gwiriadur ar reizhad","ui.navigation.advanced":"Araokaet","ui.navigation.logout":"Digevreañ","ui.maintenance.rebuildCache.title":"Application Cache","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Rebuild Production Cache","ui.maintenance.rebuildCache.rebuildDev":"Rebuild Development Cache","ui.maintenance.rebuildCache.clearProd":"Clear Production Cache","ui.maintenance.rebuildCache.clearDev":"Clear Development Cache","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"The Contao Install Tool is automatically locked if you enter a wrong password three times in a row.","ui.maintenance.installTool.unlock":"Unlock Install Tool","ui.maintenance.installTool.lock":"Lock Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Run Installer","ui.maintenance.composerInstall.update":"Run Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Clear Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Activate","ui.maintenance.debugMode.deactivate":"Deactivate","ui.maintenance.debugMode.credentials":"Credentials","ui.maintenance.debugMode.user":"Please enter a username for the debug mode.","ui.maintenance.debugMode.password":"Please enter a password for the debug mode.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Truncate Cache","ui.maintenance.safeMode":"Not available in Safe Mode","ui.maintenance.unsupported":"Not supported by your Contao version","ui.packages.updateButton":"Hizivaat ar pakadoù","ui.packages.searchButton":"Search Packages","ui.packages.searchPlaceholder":"Klask war-lerc\'h pakadoù ...","ui.packages.uploadOverlay":"Drag & drop files to upload","ui.packages.uploadButton":"Upload Packages","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"Confirm Uploads","ui.packages.uploadReset":"Delete Uploads","ui.packages.uploadIncomplete":"This file was not uploaded completely. Please remove it and try again.","ui.packages.uploadDuplicate":"This file seems to be uploaded multiple times. Please remove the duplicates.","ui.packages.uploadInstalled":"This file is already installed. Please remove the duplicates.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure to update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Arloañ ar c\'hemmoù","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Adderaouekaat ar cheñchamantoù","ui.packages.changesReview":"Review Changes","ui.packagelist.loading":"O kargañ ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"New packages","ui.packagelist.installed":"Installed packages","ui.package.hintRevert":"Adlakaat ar cheñchamantoù","ui.package.hintNoupdate":"Do not update","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"This package will be updated when you apply the changes.","ui.package.hintAdded":"This package will be installed when you apply the changes.","ui.package.hintRemoved":"This package will be removed when you apply the changes.","ui.package.requiredTitle":"manually added","ui.package.requiredText":"This package is required in your composer.json but not installed.","ui.package.removedTitle":"manually removed","ui.package.removedText":"This package was removed from your composer.json.","ui.package.installed":"Currently installed:","ui.package.version":"Stumm {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Kemm","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Update","ui.package.removeButton":"Dilemel","ui.package.installButton":"Add Package","ui.package.installButtonShort":"Add","ui.package.detailsButton":"Munudoù","ui.package.latestConstraint":"stumm diwezhañ","ui.package.update":"Update available","ui.package.updateLatest":"stumm diwezhañ","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Stumm {version}","ui.cloudStatus.waitingTime":"Waiting Time","ui.cloudStatus.jobs":"Current Jobs","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"none","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[542],{7542:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao 扩展","ui.app.loading":"扩展列表加载中 …","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"加载 …","ui.discover.offline":"无法获取任何结果","ui.discover.offlineExplain":"检查网络连接并在浏览器中禁用JavaScript拦截器。","ui.discover.offlineButton":"重试","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"No results for {query}","ui.discover.more":"更多","ui.discover.sortBy":"排序","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"已更新","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"下载","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"评级","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"详情","ui.discover.latestPackages":"最新和已更新扩展","ui.discover.faversPackages":"最高评级扩展","ui.discover.downloadsPackages":"下载最多扩展","ui.package.homepage":"项目网站","ui.package.private":"私有包","ui.package.privateTitle":"私有包仅可从提供商获取 (e.g. ZIP 下载)。请访问网站获取更多信息。","ui.package.abandoned":"放弃","ui.package.abandonedText":"该程序包已放弃不再维护。","ui.package.abandonedReplace":"该程序包已放弃不再维护。作者建议使用 {replacement} 包替代.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"以前的扩展详细信息","ui.package-details.close":"关闭扩展详情","ui.package-details.loading":"加载 …","ui.package-details.tabDescription":"描述","ui.package-details.tabRequire":"需求","ui.package-details.tabFeatures":"特征","ui.package-details.tabSuggest":"建议","ui.package-details.tabConflict":"冲突","ui.package-details.tabDependents":"依赖","ui.package-details.linkRequires":"需要","ui.package-details.linkReplaces":"替换","ui.package-details.linkProvides":"提供","ui.package-details.linkConflicts":"冲突","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"最新版","ui.package-details.released":"发布于","ui.package-details.license":"许可(s)","ui.package-details.authors":"from","ui.package-details.more":"更多","ui.package-details.packagist":"包详情","ui.package-details.metadata":"编辑元数据","ui.package-details.support_docs":"文档","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"支持论坛","ui.package-details.support_issues":"问题 / 错误 报告","ui.package-details.support_source":"源代码","ui.package-details.support_irc":"IRC / 聊天","ui.package-details.support_email":"支持 E-Mail","ui.package-details.support_rss":"RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[164],{6164:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Onveilige Verbinding !!","ui.app.httpsDescription":"Zonder HTTPS worden vertrouwelijke gegevens ongecodeerd overgedragen. ","ui.app.httpsLink":"Meer info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Veilige modus ingeschakeld !!","ui.app.safeModeDescription":"Sommige functies van de Contao Manager zijn niet beschikbaar.","ui.app.safeModeExit":"Verlaat veilige modus","ui.app.limitedHeadline":"Verificatie op afstand","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Setup","ui.app.loading":"Contao Manager laden","ui.app.apiError":"Onverwachte API status","ui.app.configSecurity1":"VEILIGHEIDSWAARSCHUWING !!! De configuratie-map is niet beveiligd","ui.app.configSecurity2":"Contao Manager heeft vastgesteld dat de configuratiebestanden openbaar toegankelijk zijn. Alle bewerkingen zijn geblokkeerd totdat de map is beveiligd, anders zou een aanvaller toegang kunnen krijgen tot gevoelige gegevens van uw installatie.\\n\\nOm dit probleem op te lossen, moet u ervoor zorgen dat er geen toegang tot de map \\"contao-manager\\" is op uw server. Raadpleeg de handleiding van uw webserver voor meer informatie of neem contact op met uw hostingprovider.","ui.account.welcome":"Welkom","ui.account.intro1":"Welkom bij de Contao Manager, een universeel hulpmiddel om Contao Open Source CMS te installeren en te beheren. Bent u hier nieuw? {ReadthemanualTogetStarted}.","ui.account.introGetStarted":"{ReadTheManual} om te beginnen","ui.account.introManual":"lees de handleiding","ui.account.intro2":"Als u problemen ondervindt, kijk dan op {ourGithubIssues} en voel je vrij om nieuwe te maken voor iets dat nog niet is gemeld.","ui.account.introIssues":"Onze GitHub issues","ui.account.headline":"Gebruikers Account","ui.account.description":"Om uw installatie te beheren maakt u een account aan voor de Contao Manager. Houd er rekening mee dat dit account niet gerelateerd is aan het Contao-backend of frontend.","ui.account.username":"Gebruikersnaam","ui.account.password":"Wachtwoord","ui.account.passwordPlaceholder":"min. 8 tekens","ui.account.passwordLength":"Vul minstens 8 tekens in.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Maak een Account","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao en de Contao Manager worden gesponsord door de non-profit Contao Association.","ui.account.contribute2":"Overweeg om bij te dragen aan Open Source door te {donate}.","ui.account.contributeDonate":"een donatie doen","ui.login.headline":"Aanmelden","ui.login.description":"Log in om uw installatie te beheren.","ui.login.username":"Gebruikersnaam","ui.login.password":"Wachtwoord","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Wachtwoord vergeten?","ui.login.button":"Aanmelden","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Annuleer","ui.login.or":"of","ui.login.locked":"Toegang is geweigerd omdat de Contao Manager is vergrendeld. Om te ontgrendelen, verwijdert u het {LockFile} -bestand in uw Contao Root map.","ui.logout.headline":"Time-out sessie","ui.logout.warning":"U bent meer dan 25 minuten inactief geweest. Om veiligheidsredenen wordt uw sessie binnenkort beëindigd.","ui.logout.expired":"Uw sessie is automatisch beëindigd omdat u meer dan 30 minuten inactief bent geweest.","ui.logout.renew":"Ingelogd blijven","ui.logout.logout":"Uitloggen","ui.logout.login":"Terug naar inloggen","ui.oauth.error":"Ongeldige OAuth-poging. Controleer de request parameters.","ui.oauth.https":"De omleidings-URI MOET een beveiligd protocol gebruiken (HTTPS :) om te voorkomen dat het authenticatie-token in duidelijke tekst wordt verzonden.","ui.oauth.headline":"Verificatie op afstand","ui.oauth.description":"De volgende toepassing of service vraagt om externe toegang tot uw Contao Manager.","ui.oauth.domain":"Zorg ervoor dat u deze URL en eigenaar vertrouwt, voordat u toegang toestaat!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Toegang verlenen","ui.oauth.deny":"Toegang ontzeggen","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Systeem Controle","ui.boot.description":"Even geduld we analyseren uw server ...","ui.boot.issue1":"Installatieproblemen gedetecteerd","ui.boot.issue2":"Uw installatie heeft problemen die moeten worden opgelost voordat de Contao Manager kan worden gebruikt.","ui.boot.run":"Contao Manager Starten","ui.boot.safeMode":"Start in Veilige Modus","ui.recovery.headline":"Systeemherstel","ui.recovery.description":"De Contao Manager heeft bestanden gevonden die op Contao lijken, maar de opdrachtregel interface werkt niet zoals verwacht.","ui.recovery.console":"Console Uitvoer","ui.recovery.repairOptions":"Kies een optie om de installatie te repareren.","ui.recovery.repairHeadline":"Automatisch herstel","ui.recovery.repairDescription":"Pogingen om de installatie automatisch te herstellen door de cache van de toepassing opnieuw op te bouwen en de Composer-pakketten te herinstalleren.","ui.recovery.repairWarning":"Handmatige wijzigingen aan de vendor bestanden kunnen verloren gaan!","ui.recovery.repairFailed":"Automatisch herstel is mislukt. Probeer de Veilige Modus om de installatie handmatig te repareren.","ui.recovery.repairButton":"Voer systeemreparatie uit","ui.recovery.safeModeHeadline":"Veilige Modus","ui.recovery.safeModeDescription":"Door de Contao Manager te starten in de veilige modus kunnen pakketten worden beheerd en bepaalde onderhoudstaken worden uitgevoerd, maar functies die afhankelijk zijn van een werkende Contao-installatie zijn niet beschikbaar.","ui.recovery.safeModeButton":"Start in Veilige Modus","ui.server.pending":"Wachtend …","ui.server.running":"Analyseren …","ui.server.error":"Controle mislukt vanwege een onverwachte reactie van de server.","ui.server.details":"Details","ui.server.prerequisite":"Controle geannuleerd als gevolg van een ontbrekende voorwaarde.","ui.server.selfUpdate.title":"Updates van de Contao Manager","ui.server.selfUpdate.update":"Een nieuwe versie van Contao Manager {latest} is beschikbaar.","ui.server.selfUpdate.manualUpdate":"Er is een nieuwe Contao Manager-versie {latest} beschikbaar. Uw server ondersteunt geen automatische updates, download de nieuwe versie van {download}.","ui.server.selfUpdate.latest":"U gebruikt de laatste versie {huidige}.","ui.server.selfUpdate.dev":"Ontwikkelingsversies ondersteunen geen automatische updates.","ui.server.selfUpdate.unsupported":"Een nieuwe versie is beschikbaar, maar deze ondersteunt uw PHP-versie niet.","ui.server.selfUpdate.button":"Voer Zelf-Update uit","ui.server.selfUpdate.continue":"Ga verder","ui.server.config.title":"Server Configuratie","ui.server.config.setup":"Configureer","ui.server.config.change":"Wijzig","ui.server.config.save":"Bewaar","ui.server.config.cancel":"Annuleer","ui.server.config.customOption":"Ander ...","ui.server.config.description":"Om achtergrondtaken correct uit te voeren, moet de Contao Manager weten waar hij de PHP -opdrachtregel binair kan vinden en hoe de opdrachten uit te voeren die zijn gescheiden van het web proces.","ui.server.config.formTitle":"Server Configuratie","ui.server.config.formText":"Voer het pad naar uw PHP-binair bestand in. Zorg ervoor dat het binaire bestand dezelfde PHP-versie is als gebruikt in het web proces.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Met de Composer Cloud Resolver kunt u Composer-afhankelijkheden installeren, zelfs als uw server niet voldoende lokaal geheugen heeft. Houd er rekening mee dat uw pakketinformatie wordt verzonden naar een cloudserver die wordt beheerd door de Contao Association.","ui.server.config.cloud":"De Composer Cloud Resolver gebruiken","ui.server.config.cli":"PHP Binary","ui.server.config.stateErrorCli":"Ongeldige PHP binary gevonden op de server.","ui.server.config.stateErrorCloud":"De Composer Cloud Resolver wordt niet ondersteund.","ui.server.config.stateSuccess":"PHP binary in {php_cli}.","ui.server.php_web.title":"PHP Web Proces","ui.server.php_web.below7":"PHP versie gevonden {version}, stap zo spoedig mogelijk over op PHP 7.","ui.server.php_web.success":"PHP versie gevonden {version}, geen bekende problemen gevonden.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"PHP versie gevonden {version}, geen bekende problemen gevonden.","ui.server.composer.title":"Composer Omgeving","ui.server.composer.success":"Geen bekende problemen gevonden.","ui.server.composer.install":"Afhankelijkheden van Composer zijn niet geïnstalleerd.","ui.server.composer.button":"Installeren","ui.server.contao.title":"Contao Installatie","ui.server.contao.setup":"Setup","ui.server.contao.check":"Controleer database","ui.server.contao.empty":"Er is geen Contao installatie gevonden.","ui.server.contao.old":"Contao versie {version} is niet compatibel met de Contao Manager, installatie handmatig updaten.","ui.server.contao.found":"Gevonden Contao {version} (API versie {api}).","ui.server.contao.connectionError":"Kan geen verbinding maken met de databaseserver.","ui.server.contao.connectionProblem":"Databaseprobleem gevonden.","ui.server.contao.missingUser":"Beheerdersaccount niet gevonden.","ui.setup.continue":"Ga verder","ui.setup.manager":"Contao Manager Starten","ui.setup.cancel":"Annuleer","ui.setup.welcome":"Welkom","ui.setup.welcome1":"Deze wizard leidt u door de nodige stappen om uw Contao Open Source CMS-installatie in te stellen.","ui.setup.welcome2":"Als je vragen hebt, vind je documentatie, forums, een Slack-kanaal en meer op de {support}-pagina.","ui.setup.support":"Community ondersteuning","ui.setup.start":"Begin","ui.setup.complete":"Gefeliciteerd!","ui.setup.complete1":"Contao {version} is succesvol geïnstalleerd.","ui.setup.complete2":"Om het installatieproces te voltooien, opent u de installatietool om de databaseverbinding te configureren en een back-endgebruiker aan te maken.","ui.setup.complete3":"U kunt nu beginnen met het maken van uw website in de backend van Contao. Als u extra extensies nodig heeft, gaat u verder naar de Contao Manager.","ui.setup.installTool":"Open de installatietool","ui.setup.login":"Log in op Contao","ui.setup.funding":"Gratis software is \\"gratis\\" zoals in \\"aardig zijn voor iemand\\", niet zoals in \\"gratis bier\\". Voor een Open Source-project als Contao zijn bedragen nodig die niet door één persoon of bedrijf kunnen worden bijeengebracht.\\nAls u een website heeft of websites verkoopt die met Contao zijn gebouwd, zouden we graag zien dat u een financiële bijdrage levert aan het product waar uw bedrijf van afhankelijk is.","ui.setup.fundingLink":"Kom meer te weten","ui.setup.document-root.headline":"Webserver Instellingen","ui.setup.document-root.warning":"Om Contao via de Contao Manager te installeren, moet u de documentroot op de webserver repareren.","ui.setup.document-root.description1":"Contao gebruikt een aparte map voor openbare bestanden, toepassingsbestanden worden in de bovenliggende map geïnstalleerd. Contao kan niet worden geïnstalleerd als de mappenstructuur niet correct is of als de mappen niet leeg zijn.","ui.setup.document-root.description2":"Als u niet weet hoe u uw document root moet configureren, lees dan de Contao documentatie of neem contact op met uw hostingprovider.","ui.setup.document-root.documentation":"Lees de Documentatie","ui.setup.document-root.conflictsTitle":"Installatiemap niet leeg","ui.setup.document-root.conflictsDirectory":"De hoofdmap van uw toekomstige Contao-installatie is niet leeg, we hebben {count} bestand(en) gevonden die mogelijk worden overschreven door het installatieproces. Het wordt aanbevolen om een lege mappenstructuur voor Contao aan te maken, maar u kunt ook de volgende bestanden verwijderen en opnieuw controleren of u zeker weet dat ze niet worden gebruikt.","ui.setup.document-root.ignoreConflicts":"Ik wil Contao installeren in de niet-lege map. Ik begrijp dat dit alle bestaande bestanden op mijn webruimte kan overschrijven.","ui.setup.document-root.check":"Opnieuw controleren","ui.setup.document-root.create":"Maak mappen","ui.setup.document-root.change":"Wijzig mappen","ui.setup.document-root.formTitle":"Mapinstellingen","ui.setup.document-root.formText1":"De Contao Manager kan automatisch een nieuwe mappen structuur op de server maken.","ui.setup.document-root.formText2":"U moet de nieuwe document root handmatig configureren (bijv. via een hosting admin paneel).","ui.setup.document-root.autoconfig":"Ik begrijp dat ik mijn serverconfiguratie moet wijzigen. Het niet configureren van de document root zal de Contao Manager stuk maken en configuratiebestanden openbaar maken (inclusief accountgegevens en wachtwoorden)!","ui.setup.document-root.directory":"Nieuwe Map","ui.setup.document-root.currentRoot":"Huidig Document Root","ui.setup.document-root.newRoot":"Nieuwe Document Root","ui.setup.document-root.finish":"Stel Mappen In","ui.setup.document-root.publicDir":"Gebruik {dir} voor publieke bestanden (voor Contao {version})","ui.setup.document-root.directoryInvalid":"Voer een geldige mapnaam in.","ui.setup.document-root.directoryExists":"De doelmap bestaat al. Voer een andere naam in.","ui.setup.document-root.confirmation":"De Contao Manager heeft met succes de benodigde map gemaakt voor uw Contao installatie. U moet nu de document root configureren op uw webserver. Laad deze pagina niet opnieuw.","ui.setup.document-root.reload":"Pagina herladen","ui.setup.document-root.success":"De mappenstructuur op uw webserver is correct ingesteld!","ui.setup.document-root.installingProjectDir":"Applicatiebestanden worden geïnstalleerd in {dir}.","ui.setup.document-root.installingPublicDir":"Openbare bestanden worden geïnstalleerd in {dir}.","ui.setup.document-root.installedProjectDir":"Applicatiebestanden zijn geïnstalleerd in {dir}.","ui.setup.document-root.installedPublicDir":"Openbare bestanden zijn geïnstalleerd in {dir}.","ui.setup.create-project.headline":"Contao Installatie","ui.setup.create-project.description":"De ontwikkeling van Contao volgt het principe van {semver}, er wordt elke zes maanden een nieuwe secundaire versie uitgebracht. De momenteel ondersteunde releases zijn:","ui.setup.create-project.semver":"Semantische versiebeheer","ui.setup.create-project.latestTitle":"Nieuwste","ui.setup.create-project.ltsTitle":"Lange Termijn Support","ui.setup.create-project.latestQ1":"Onze nieuwste versie biedt de meeste functies met ondersteuning tot februari {jaar}.","ui.setup.create-project.latestQ3":"Onze nieuwste versie biedt de meeste functies met ondersteuning tot augustus {jaar}.","ui.setup.create-project.ltsText":"Onze huidige LTS-versie, als je focust op stabiliteit. Biedt langdurige ondersteuning tot februari {jaar}.","ui.setup.create-project.pltsText":"De vorige LTS-versie heeft nog steeds ondersteuning op lange termijn tot februari {jaar}.","ui.setup.create-project.requiresPHP":"Vereist minimaal PHP {version}, je hebt PHP {current}.","ui.setup.create-project.releaseplan":"Bekijk het {ContaoReleasePlan} voor gedetailleerde informatie.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.installed":"Contao {version} is succesvol op de server geïnstalleerd. Ga door met het instellen van uw database of start de Contao Manager om een andere versie te installeren.","ui.setup.create-project.formTitle":"Selecteer een distributie","ui.setup.create-project.formText":"Kies welke versie moet worden geïnstalleerd.","ui.setup.create-project.version":"Versie","ui.setup.create-project.demo":"Installeer de Contao demo website","ui.setup.create-project.demoDescription":"De demowebsite helpt u vertrouwd te raken met Contao en alle kernfuncties ervan. Meer thema\'s zijn te vinden in de {store}.","ui.setup.create-project.coreOnly":"Minimale installatie (alleen de kern)","ui.setup.create-project.noUpdate":"Installatie overslaan (alleen expert!)","ui.setup.create-project.theme":"Contao Thema","ui.setup.create-project.themeInstall":"Om een Contao-thema te installeren, gebruikt u de zoekinvoer of uploadt u een themabestand (.cto/.zip) dat installatie via Contao Manager ondersteunt.","ui.setup.create-project.themeBuy":"Zorg ervoor dat je de officiële {store} bezoekt.","ui.setup.create-project.themeStore":"Contao Thema\'s Winkel","ui.setup.create-project.themeUpload":"Themabestand uploaden (.cto/.zip)","ui.setup.create-project.themeInvalid":"Het geüploade bestand is geen Contao-thema of ondersteunt de Contao Manager niet.","ui.setup.create-project.themeWarning":"De Contao Manager weet niet of dit thema compatibel is met uw server. Als u vragen heeft, neem dan contact op met de themaleverancier.","ui.setup.create-project.themeTitle":"Themadetails bekijken","ui.setup.create-project.themeDetails":"De volgende afhankelijkheden en bestanden worden met dit thema geïnstalleerd.","ui.setup.create-project.themeRequire":"{count} Afhankelijkheden | {count} Afhankelijkheden","ui.setup.create-project.themeFiles":"{count} Bestand | {count} Bestanden","ui.setup.create-project.theme.or":"of zoek naar openbare thema\'s","ui.setup.create-project.theme.search":"Thema\'s zoeken","ui.setup.create-project.theme.more":"Meer thema\'s","ui.setup.create-project.theme.empty":"Geen thema\'s die overeenkomen met {query}","ui.setup.create-project.theme.uploaded":"Het themabestand is succesvol geüpload.","ui.setup.create-project.theme.packageName":"Pakketnaam","ui.setup.create-project.theme.version":"Versie","ui.setup.create-project.theme.authors":"Auteur(s)","ui.setup.create-project.install":"Installeren","ui.setup.create-project.cancel":"Annuleer","ui.setup.database-connection.headline":"Database verbinding","ui.setup.database-connection.description":"Contao vereist een MySQL-database (of een compatibele fork zoals MariaDB) om pagina\'s, inhoud, gebruikers en andere relationele gegevens op te slaan. Verbindingsparameters worden opgeslagen in het bestand {env} in de projectroot van uw Contao-installatie.","ui.setup.database-connection.formTitle":"Verbindingsparameters","ui.setup.database-connection.formText":"Voer een database-URL in of vul de velden gebruikersnaam, wachtwoord, server en database apart in.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database-URL is ongeldig of verbinding met de server is mislukt.","ui.setup.database-connection.or":"of","ui.setup.database-connection.user":"Gebruikersnaam","ui.setup.database-connection.password":"Wachtwoord","ui.setup.database-connection.server":"Server (:Port) ","ui.setup.database-connection.database":"Database Naam","ui.setup.database-connection.connected":"Succesvol verbonden met database {database} op {server}.","ui.setup.database-connection.error":"Fout bij het verbinden met de database.","ui.setup.database-connection.problem":"Contao heeft een probleem gedetecteerd met uw database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"Er is één migratie in behandeling. | Er zijn {count} migraties in behandeling.","ui.setup.database-connection.schema":"Er is één schema-update in behandeling. | Er zijn {count} schema-updates in behandeling.","ui.setup.database-connection.noChanges":"Uw databaseschema is up-to-date.","ui.setup.database-connection.check":"Controleer database","ui.setup.database-connection.skip":"Overslaan","ui.setup.database-connection.save":"Bewaar","ui.setup.database-connection.change":"Inloggegevens wijzigen","ui.setup.database-connection.restoreTitle":"Database importeren","ui.setup.database-connection.restoreText":"Het thema dat u zojuist hebt geïnstalleerd, bevat een databaseback-up. Herstel de database om themagegevens te importeren of sla deze stap over om te beginnen met een lege Contao-installatie. | Het thema dat u zojuist hebt geïnstalleerd, bevat meerdere databaseback-ups. Selecteer een back-upbestand om themagegevens te importeren of sla deze stap over om te beginnen met een lege Contao-installatie.","ui.setup.database-connection.backup":"Maak een back-up van de huidige database vóór het importeren","ui.setup.database-connection.backupWarning":"Alle gegevens in de database worden bij het importeren overschreven! Maak eerst een back-up als de database niet leeg is.","ui.setup.database-connection.restore":"Themadatabase importeren","ui.setup.database-connection.restoreOption":"Back-up van {date} ({size})","ui.setup.database-connection.restored":"Uw themadatabase is succesvol geïmporteerd. Ga door met het valideren van uw databaseschema.","ui.setup.backend-user.success":"Er is een beheerdersaccount voor de Contao-backend gevonden in uw database. Gebruik de Contao-backend om meer gebruikers toe te voegen.","ui.setup.backend-user.error":"Kan gebruikerslijst niet ophalen. Controleer de console-uitvoer voor details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"Om uw website te beheren, moet u ten minste één beheerdersaccount hebben voor de Contao-backend. Houd er rekening mee dat dit account niet gerelateerd is aan de Contao Manager.","ui.setup.backend-user.formTitle":"Maak een Account","ui.setup.backend-user.formText":"Voer de gegevens in voor het nieuwe backend-account.","ui.setup.backend-user.username":"Gebruikersnaam","ui.setup.backend-user.name":"Naam","ui.setup.backend-user.email":"Emailadres","ui.setup.backend-user.emailInvalid":"Vul a.u.b. een geldig e-mailadres in","ui.setup.backend-user.password":"Wachtwoord","ui.setup.backend-user.passwordPlaceholder":"min. 8 tekens","ui.setup.backend-user.passwordLength":"Vul minstens 8 tekens in.","ui.setup.backend-user.create":"Account toevoegen","ui.task.headline":"Achtergrond taak","ui.task.loading":"Details laden ...","ui.task.created":"Details laden ...","ui.task.active":"Wacht terwijl de Contao Manager taakbewerkingen op de achtergrond uitvoert.","ui.task.complete":"Alle bewerkingen zijn met succes voltooid. Controleer de console uitvoer voor meer informatie.","ui.task.paused":"Een achtergrondbewerking stopte onverwacht. Controleer de console -uitvoer.","ui.task.aborting":"Wacht terwijl de achtergrondbewerkingen worden geannuleerd.","ui.task.stopped":"Sommige achtergrondbewerkingen werden geannuleerd. Controleer de console -uitvoer.","ui.task.error":"Een achtergrondbewerking stopte onverwacht. Controleer de console -uitvoer.","ui.task.failed":"De Contao -manager kon geen achtergrondtaak starten!","ui.task.failedDescription1":"Er ging iets mis bij het uitvoeren van bewerkingen op de achtergrond.","ui.task.failedDescription2":"Als dit opnieuw gebeurt, wordt uw server mogelijk niet ondersteund.","ui.task.reportProblem":"Een probleem melden","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud gesponsord door {sponsor}","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"Sluit","ui.task.buttonConfirm":"Bevestig & Sluit","ui.task.buttonContinue":"Ga verder","ui.task.buttonCancel":"Annuleer","ui.task.confirmCancel":"Weet u zeker om deze taak te annuleren? Dit kan uw Contao-installatie in een niet werkende staat achterlaten!","ui.task.autoclose":"Sluit taakdetails bij succes","ui.console.toggle":"Toon/Verberg Console Output","ui.console.showLog":"Toon volledig consolelogboek","ui.console.copyLog":"Kopieer logboek naar klembord","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(alleen migraties)","ui.migrate.schemaOnly":"(alleen schema)","ui.migrate.loading":"Even geduld a.u.b., we controleren uw database …","ui.migrate.empty":"Geen lopende migraties of schema-updates gevonden. Uw database is up-to-date.","ui.migrate.emptyMigrations":"Geen lopende migraties gevonden. Zorg ervoor dat u ook controleert op schema-updates.","ui.migrate.emptySchema":"Geen lopende schema-updates gevonden. Zorg ervoor dat u ook controleert op migraties.","ui.migrate.pending":"Uw database is niet up-to-date. Bekijk de console-uitvoer hieronder en voer de wijzigingen door.","ui.migrate.previousChanges":"Een eerdere databasemigratie is niet bevestigd.\\nBekijk de console-uitvoer hieronder en ga verder met het bekijken van de volgende wijzigingen.","ui.migrate.previousComplete":"Een eerdere databasemigratie is niet bevestigd. Bekijk de console-uitvoer hieronder.\\nEr zijn geen wijzigingen meer in behandeling.","ui.migrate.appliedChanges":"Database-updates zijn toegepast.\\nBekijk de console-uitvoer hieronder en ga verder met het bekijken van de volgende wijzigingen.","ui.migrate.appliedComplete":"Database-updates zijn toegepast.\\nEr zijn geen lopende migraties of schema-updates meer. Uw database is up-to-date.","ui.migrate.problem":"Contao heeft een probleem gedetecteerd met uw database server.\\nBekijk de console-uitvoer hieronder om erachter te komen wat er moet worden opgelost. | Contao heeft problemen met uw database server gedetecteerd.\\nBekijk de console-uitvoer hieronder om erachter te komen wat er moet worden opgelost.","ui.migrate.warning":"Contao heeft een verkeerde configuratie van uw database server gedetecteerd.\\nWaarschuwingen kunnen tijdelijk worden overgeslagen, maar moeten worden opgelost voor optimale prestaties en gegevensintegriteit.","ui.migrate.error":"De wijzigingen kunnen niet worden toegepast. Uw database is mogelijk gewijzigd. Controleer het nogmaals om het opnieuw te proberen.","ui.migrate.execute":"Uitvoeren","ui.migrate.close":"Sluit","ui.migrate.confirm":"Bevestig & Sluit","ui.migrate.cancel":"Annuleer","ui.migrate.continue":"Ga verder","ui.migrate.setup":"Setup","ui.migrate.skip":"Overslaan","ui.migrate.retry":"Opnieuw controleren","ui.migrate.retryAll":"Alles controleren","ui.migrate.withDeletes":"Voer alle database wijzigingen uit, inclusief DROP-query\'s.","ui.migrate.migrationTitle":"Database Migraties","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problemen","ui.migrate.warningTitle":"Database Waarschuwingen","ui.migrate.addTable":"Tabel {tabel} toevoegen","ui.migrate.dropTable":"Drop tabel {table}","ui.migrate.addField":"Veld {tabel}.{field} toevoegen","ui.migrate.changeField":"Veld {table}.{field} wijzigen","ui.migrate.dropField":"Drop veld {table}.{field}","ui.migrate.createIndex":"Maak index \\"{name}\\" op {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" op {table}","ui.widget.mandatory":"Dit veld mag niet leeg zijn.","ui.widget.blankOption":"Selecteer ...","ui.widget.showPassword":"Toon wachtwoord","ui.widget.hidePassword":"Verberg wachtwoord","ui.error.title":"HTTP verzoek voor \\"{method} {url}\\" mislukt.","ui.error.server500":"Het lijkt erop dat er een onverwachte fout is gebeurd op uw server. Controleer de logbestanden van uw webserver (Apache/Nginx) en de Contao Manager-logboeken in \\"contao-manager/logs\\".","ui.error.response":"De server heeft een antwoord geretourneerd met statuscode {status}.","ui.error.moreLink":"Meer informatie","ui.error.support":"Contao Ondersteuning","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Help","ui.footer.reportProblem":"Een probleem melden","ui.navigation.discover":"Ontdekken","ui.navigation.packages":"Pakketten","ui.navigation.tools":"Hulpmiddelen","ui.navigation.installTool":"Installatie Tool","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao foutopsporingsmodus","ui.navigation.logViewer":"Log viewer","ui.navigation.phpinfo":"PHP Informatie","ui.navigation.phpinfoLoading":"PHP informatie laden","ui.navigation.maintenance":"Onderhoud","ui.navigation.rebuildCache":"Cache opnieuw opbouwen","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Systeem Controle","ui.navigation.advanced":"Gevorderd","ui.navigation.logout":"Uitloggen","ui.maintenance.database.title":"Databasemigraties en back-ups","ui.maintenance.database.description":"Databasemigraties zorgen voor consistente gegevens en tabelschema\'s.","ui.maintenance.database.migrations":"Eén databasemigratie in behandeling | {count} lopende databasemigraties","ui.maintenance.database.schemaUpdates":"Eén schema update in behandeling | {count} schema updates in behandeling","ui.maintenance.database.error":"Databaseprobleem gevonden.","ui.maintenance.database.warning":"Database waarschuwingen gevonden.","ui.maintenance.database.button":"Controleer database","ui.maintenance.database.migrationOnly":"Controleer alleen migraties","ui.maintenance.database.schemaOnly":"Alleen schema controleren","ui.maintenance.database.installTool":"Open de installatietool","ui.maintenance.database.createBackup":"Een backup maken","ui.maintenance.database.backupUnsupported":"Databaseback-ups worden niet ondersteund door uw Contao-versie.","ui.maintenance.database.backupList":"U heeft één databaseback-up, gemaakt op {date}. | U heeft {count} databaseback-ups, de laatste is gemaakt op {date}.","ui.maintenance.database.backupEmpty":"U heeft momenteel geen databaseback-ups.","ui.maintenance.rebuildCache.title":"Applicatie Cache","ui.maintenance.rebuildCache.description":"Het opnieuw opbouwen van de applicatie-cache is vereist na het wijzigen van een van de configuratiebestanden.","ui.maintenance.rebuildCache.rebuildProd":"Produktieomgeving Cache opnieuw opbouwen","ui.maintenance.rebuildCache.rebuildDev":"Cache ontwikkelingsomgeving opnieuw opbouwen","ui.maintenance.rebuildCache.clearProd":"Cache van de productieomgeving leegmaken","ui.maintenance.rebuildCache.clearDev":"Cache ontwikkelingsomgeving legen","ui.maintenance.installTool.title":"Contao Installatie Programma","ui.maintenance.installTool.description":"Het Contao-installatie programma wordt automatisch vergrendeld als u een wachtwoord drie keer achter elkaar verkeerd invoert.","ui.maintenance.installTool.unlock":"Installatie Programma Ontgrendelen","ui.maintenance.installTool.lock":"Installatie Programma Vergrendelen","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"De autoloader van Composer is verantwoordelijk voor PHP class loading. De autoloader moet worden gedumpt nadat aangepaste namespaces zijn toegevoegd aan de root van composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Afhankelijkheden","ui.maintenance.composerInstall.description":"Composerafhankelijkheden bevinden zich in de map {vendor} in uw applicatie root. Het opnieuw installeren van de afhankelijkheden kan nodig zijn na manipulatie of het handmatig uploaden van het {composerLock} bestand.","ui.maintenance.composerInstall.button":"Installatieprogramma Uitvoeren","ui.maintenance.composerInstall.update":"Start Composer update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer cached gedownloade pakketten voor betere prestaties. Als u problemen hebt zoals onvolledige bestanden, probeer dan de Composer-cache te verwijderen om een nieuwe download te forceren.","ui.maintenance.composerCache.button":"Cache Wissen","ui.maintenance.maintenanceMode.title":"Onderhoudsmodus","ui.maintenance.maintenanceMode.description":"Contao in de onderhoudsmodus zetten toont een \\"503 service niet beschikbaar\\" -template voor de website.","ui.maintenance.maintenanceMode.enable":"Inschakelen","ui.maintenance.maintenanceMode.disable":"Uitschakelen","ui.maintenance.debugMode.title":"Foutopsporingsmodus","ui.maintenance.debugMode.description":"Activeer de foutopsporingsmodus door een gebruiker en wachtwoord in te stellen voor het ingangspunt {AppDevphp}.","ui.maintenance.debugMode.descriptionJwt":"Schakelt foutopsporingsmodus in door een cookie in te stellen voor het huidige domein.","ui.maintenance.debugMode.activate":"Activeren","ui.maintenance.debugMode.deactivate":"Deactiveren","ui.maintenance.debugMode.credentials":"Aanmeldgegevens","ui.maintenance.debugMode.user":"Geef een gebruikersnaam op voor de foutopsporingsmodus.","ui.maintenance.debugMode.password":"Geef een wachtwoord op voor de foutopsporingsmodus.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode slaat PHP-bestanden op in het web-proces voor snellere uitvoering. Het moet onder bepaalde omstandigheden worden verwijderd als bestanden niet worden herkend na wijziging.","ui.maintenance.opcodeCache.button":"Wis Cache","ui.maintenance.safeMode":"Niet beschikbaar in Veilige Modus","ui.maintenance.unsupported":"Wordt niet ondersteund door uw Contao versie","ui.packages.updateButton":"Pakketten Updaten","ui.packages.searchButton":"Pakketten zoeken","ui.packages.searchPlaceholder":"Zoek pakketten...","ui.packages.uploadOverlay":"Sleep bestanden om ze te uploaden","ui.packages.uploadButton":"Pakketten uploaden","ui.packages.uploadMessage":"U heeft één onbevestigde upload. | U heeft {count} onbevestigde uploads.","ui.packages.uploadApply":"Bevestig Uploads","ui.packages.uploadReset":"Verwijder Uploads","ui.packages.uploadIncomplete":"Dit bestand is niet volledig geüpload. Verwijder het en probeer opnieuw.","ui.packages.uploadDuplicate":"Dit bestand lijkt meerdere keren te zijn geüpload. Verwijder de duplicaten.","ui.packages.uploadInstalled":"Dit bestand is al geïnstalleerd. Verwijder de duplicaten.","ui.packages.uploadUnsupported":"Uploads worden niet ondersteund in uw installatie. Zorg ervoor dat de PHP ZIP-extensie is geïnstalleerd en werk uw afhankelijkheden bij.","ui.packages.changesMessage":"U heeft één onbevestigde wijziging. | U heeft {count} onbevestigde wijzigingen.","ui.packages.changesDryrun":"Testloop","ui.packages.changesApply":"Wijzigingen toepassen","ui.packages.changesApplyAll":"Update alle pakketten","ui.packages.changesDryrunAll":"Dry Run alle pakketten","ui.packages.changesReset":"Reset wijzigingen","ui.packages.changesReview":"Wijzigingen controleren","ui.packagelist.loading":"Bezig met laden ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Nieuwe pakketten","ui.packagelist.installed":"Geïnstalleerde pakketten","ui.package.hintRevert":"Wijzigingen terugdraaien","ui.package.hintNoupdate":"Niet updaten","ui.package.hintConstraint":"Dit pakket wordt geïnstalleerd met beperkingen {constraint} wanneer u de wijzigingen toepast.","ui.package.hintConstraintBest":"Dit pakket wordt geïnstalleerd in de best beschikbare versie wanneer u de wijzigingen toepast.","ui.package.hintConstraintChange":"De beperking voor dit pakket wordt gewijzigd van \\"{from}\\" naar \\"{to}\\" wanneer u de wijzigingen toepast.","ui.package.hintConstraintUpdate":"Dit pakket wordt bijgewerkt wanneer u de wijzigingen toepast.","ui.package.hintAdded":"Dit pakket wordt geïnstalleerd wanneer u de wijzigingen toepast.","ui.package.hintRemoved":"Dit pakket wordt verwijderd wanneer u de wijzigingen toepast.","ui.package.requiredTitle":"handmatig toegevoegd","ui.package.requiredText":"Dit pakket is vereist in composer.json maar is niet geïnstalleerd.","ui.package.removedTitle":"handmatig verwijderd","ui.package.removedText":"Dit pakket is verwijderd van uw composer.json.","ui.package.installed":"Momenteel geïnstalleerd:","ui.package.version":"Versie {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Ster | {count} Sterren","ui.package.editConstraint":"Bewerk","ui.package.uploadConstraint":"Deze beperking wordt bepaald door het geüploade pakket.","ui.package.updateButton":"Update","ui.package.removeButton":"Verwijder","ui.package.installButton":"Pakket toevoegen","ui.package.installButtonShort":"Toevoegen","ui.package.detailsButton":"Details","ui.package.latestConstraint":"laatste versie","ui.package.update":"Update beschikbaar","ui.package.updateLatest":"laatste versie","ui.package.updateAvailable":"{version} beschikbaar","ui.package.updateUnknown":"Onbekende versie","ui.package.updateConstraint":"Er is een nieuwere versie beschikbaar buiten uw versiebeperking.","ui.package.incompatible":"{package} werkt niet met Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versie {version}","ui.cloudStatus.waitingTime":"Wacht Tijd","ui.cloudStatus.jobs":"Huidige Taken","ui.cloudStatus.workers":"Werkers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"geen","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ong. {minutes} min {seconds} sec","ui.cloudStatus.error":"Niet in staat om de status van de Composer Resolver Cloud op te halen. Het kan down zijn voor onderhouds- of ervaringsproblemen.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Vernieuw de Cloud Status","ui.log-viewer.loading":"Bezig met laden ...","ui.log-viewer.empty":"Er zijn geen logbestanden op uw server.","ui.log-viewer.reload":"Herladen","ui.log-viewer.file":"Logbestand","ui.log-viewer.channel":"Kanaal","ui.log-viewer.channelTitle":"Het kanaal waarop dit bericht is geregistreerd.","ui.log-viewer.level":"Niveau","ui.log-viewer.levelTitle":"Ernst van het logbericht.","ui.log-viewer.timeHeader":"Tijd","ui.log-viewer.messageHeader":"Bericht","ui.log-viewer.showContext":"Context tonen","ui.log-viewer.hideContext":"Context verbergen","ui.log-viewer.showExtra":"Extra tonen","ui.log-viewer.hideExtra":"Extra verbergen","ui.log-viewer.more":"Meer laden …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download bestand \\"{file}\\"","ui.log-viewer.prodEnvironment":"Productieomgeving","ui.log-viewer.devEnvironment":"Ontwikkelomgeving (foutopsporingsmodus)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 tekens","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Annuleer","ui.user-manager.close":"Sluit","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Inschakelen","ui.totp.disable":"Uitschakelen","ui.totp.cancel":"Annuleer","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[606],{2225:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Ligação Insegura !!","ui.app.httpsDescription":"Sem recurso a HTTPS os seus dados confidenciais serão transferidos sem encriptação.","ui.app.httpsLink":"Mais info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Modo Guardar activado !!","ui.app.safeModeDescription":"Algumas características do Gestor de Contacto não estão disponíveis.","ui.app.safeModeExit":"Sair do modo seguro","ui.app.limitedHeadline":"Autenticação remota","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Configuração","ui.app.loading":"A iniciar o Contao Manager ...","ui.app.apiError":"API status não esperado -erro","ui.app.configSecurity1":"ALERTA DE SEGURANÇA!!! Directório de configuração sem protecção detectado","ui.app.configSecurity2":"O Contao Manager detetou que os seus ficheiros de configuração estão acessíveis publicamente. Todas as operações estão desativadas até que o directório esteja seguro, caso contrário um atacante poderá aceder a informações sensíveis sobre a sua instalação.\\n\\nPara corrigir esta situação, certifique-se que previne o acesso ao directório \\"contao-manager\\" no seu servidor. Para saber como o fazer, consulte o manual do seu webserver ou contacte o fornecedor de alojamento web.","ui.account.welcome":"Bem Vindo","ui.account.intro1":"Bem-vindo ao Contao Manager, uma ferramenta universal para instalar e gerir o Contao Open Source CMS. Se é novo nele, por favor {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} para começar","ui.account.introManual":"ler o manual","ui.account.intro2":"Se encontrar algum problema, verifique {ourGithubIssues} e sinta-se à vontade para criar um novo para qualquer coisa que ainda não tenha sido relatada.","ui.account.introIssues":"as nossas edições GitHub","ui.account.headline":"Utilizador","ui.account.description":"Para gerir a sua instalação, por favor crie uma conta para utilizar no Contao Manager. Certifique-se que é distinta da conta utilizada no Contao back e front end.","ui.account.username":"Utilizador","ui.account.password":"Senha","ui.account.passwordPlaceholder":"min. 8 caracteres","ui.account.passwordLength":"Por favor utilize o minimo de 8 caracteres.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Criar Conta","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"O Contao e o Contao Manager são patrocinados pela Associação Contao sem fins lucrativos.","ui.account.contribute2":"Por favor, considere contribuir para o código aberto por {donate}.","ui.account.contributeDonate":"fazer um donativo","ui.login.headline":"Iniciar sessão","ui.login.description":"Iniciar sessão para gerir a sua instalação.","ui.login.username":"Utilizador","ui.login.password":"Senha","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Esqueceu a sua senha?","ui.login.button":"Iniciar sessão","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Cancelar","ui.login.or":"or","ui.login.locked":"O acesso foi negado porque o Gestor de Contacto está bloqueado. Para desbloquear, apagar o ficheiro {lockFile} no directório raiz do seu Contao.","ui.logout.headline":"Tempo de Sessão expirado.","ui.logout.warning":"Esteve inactivo por mais de 25 minutos. Por razões de segurança a sua sessão será terminada em breve.","ui.logout.expired":"A sua sessão foi terminada automaticamente porque esteve inactivo por mais de 30 minutos.","ui.logout.renew":"Manter sessão ativa","ui.logout.logout":"Terminar Sessão","ui.logout.login":"Voltar para inicio de sessão","ui.oauth.error":"Tentativa OAuth inválida. Verifique os parâmetros pedidos.","ui.oauth.https":"O redireccionamento do URI DEVE utilizar um protocolo seguro (https:) para evitar que o símbolo de autenticação seja transmitido em texto claro.","ui.oauth.headline":"Autenticação remota","ui.oauth.description":"A seguinte aplicação ou serviço está a solicitar acesso remoto ao Contao Manager.","ui.oauth.domain":"Antes de permitir o acesso, certifique-se de que conhece este URL e confie no seu proprietário!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Permitir Acesso","ui.oauth.deny":"Negar Acesso","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Verificar Sistema","ui.boot.description":"Por favor espere, estamos a analisar o seu servidor...","ui.boot.issue1":"Problemas com a instalação detectados","ui.boot.issue2":"A sua instalação tem problemas que têm de ser resolvidos antes que o Gestor de Contacto possa ser utilizado.","ui.boot.run":"Iniciar o Contao Manager","ui.boot.safeMode":"Executar em Modo de Segurança","ui.recovery.headline":"Recuperação de Sistema","ui.recovery.description":"O Contao Manager detectou ficheiros que podem pertencer ao Contao, mas a linha de comandos não funciona como previsto.","ui.recovery.console":"Saída da Consola","ui.recovery.repairOptions":"Por favor escolha uma opção para reparar a sua instalação.","ui.recovery.repairHeadline":"Reparação Automática","ui.recovery.repairDescription":"Efectua uma tentativa de reparar automaticamente a instalação ao reconstruir a cache da aplicação e reinstalando os pacotes Composer.","ui.recovery.repairWarning":"Quaisquer modificações aos ficheiros vendor poderão ser apagadas durante o processo!","ui.recovery.repairFailed":"A reparação automática não teve sucesso. Usar o modo de segurança para reparar manualmente a instalação poderá resolver o problema.","ui.recovery.repairButton":"Executar Reparação de Sistema","ui.recovery.safeModeHeadline":"Modo de Segurança ","ui.recovery.safeModeDescription":"Executar o Contao Manager em Modo de Segurança permite gerir pacotes e correr tarefas de manutenção específicas, mas implementações que dependam de uma instalação Contao funcional não estarão disponíveis.","ui.recovery.safeModeButton":"Executar em Modo de Segurança","ui.server.pending":"Aguarde ...","ui.server.running":"A analisar ...","ui.server.error":"A verificação falhou devido a uma resposta inesperada do servidor.","ui.server.details":"Detalhes","ui.server.prerequisite":"A verificação falhou devido a um pré-requisito em falta.","ui.server.selfUpdate.title":"Actualizações Contao Manager","ui.server.selfUpdate.update":"Uma nova versão do Contao Manager {latest} está disponivel.","ui.server.selfUpdate.manualUpdate":"Está disponível uma nova versão do Contao Manager {latest}. O seu servidor não suporta actualizações automáticas, por favor descarregue a nova versão a partir de {download}.","ui.server.selfUpdate.latest":"Está a usar a versão mais recente {current}.","ui.server.selfUpdate.dev":"Versões de testes não suportam actualizações automáticas.","ui.server.selfUpdate.unsupported":"Uma nova versão está disponível mas não é  compatível com a sua versão de PHP.","ui.server.selfUpdate.button":"Executar Auto-Update","ui.server.selfUpdate.continue":"Continuar","ui.server.config.title":"Configuração do Servidor","ui.server.config.setup":"Configurar","ui.server.config.change":"Alterar","ui.server.config.save":"Guardar","ui.server.config.cancel":"Cancelar","ui.server.config.customOption":"Outros ...","ui.server.config.description":"Para executar correctamente as tarefas de fundo, o Gestor de Contacto precisa de saber onde encontrar o binário de linha de comando PHP e como executar comandos separados do processo web.","ui.server.config.formTitle":"Configuração do Servidor","ui.server.config.formText":"Por favor introduza o caminho para o seu binário PHP. Certifique-se que o seu binário usa a mesma versao PHP que o seu processo web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"A Composer Resolver Cloud permite instalar dependências Composer mesmo se o seu servidor não possuir memória local suficiente. Tenha em consideração que a sua informação de pacotes será transmitida para um servidor em nuvem mantido pela Contao Association.","ui.server.config.cloud":"Usar a Composer Resolver Cloud","ui.server.config.cli":"Binário PHP","ui.server.config.stateErrorCli":"Nenhum binário PHP válido foi encontrado no servidor. ","ui.server.config.stateErrorCloud":"A Composer Resolver Cloud não é suportada.","ui.server.config.stateSuccess":"Binário PHP em {php_cli}.","ui.server.php_web.title":"Processo Web PHP","ui.server.php_web.below7":"Encontrada a versão {version} PHP. Actualize para a versão PHP 7 assim que possivel!","ui.server.php_web.success":"Encontrada a versão PHP {version}, nenhum problema a reportar.","ui.server.php_cli.title":"Interface PHP Linha de Comandos","ui.server.php_cli.success":"Encontrada a versão PHP {version}, nenhum problema a reportar.","ui.server.composer.title":"Ambiente Composer","ui.server.composer.success":"Nenhum problema encontrado.","ui.server.composer.install":"Dependências Composer não instaladas.","ui.server.composer.button":"Instalar","ui.server.contao.title":"Instalação Contao","ui.server.contao.setup":"Configuração","ui.server.contao.check":"Check database","ui.server.contao.empty":"Nenhuma instalação Contao foi encontrada.","ui.server.contao.old":"A versão {version} do Contao não é compatível com o Contao Manager,  actualize a sua instalação manualmente.","ui.server.contao.found":"Encontrado Contao com versão {version} (Versão API {api}).","ui.server.contao.connectionError":"Incapaz de se ligar ao servidor da base de dados.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Conta administrativa não encontrada.","ui.setup.continue":"Continuar","ui.setup.manager":"Iniciar o Contao Manager","ui.setup.cancel":"Cancelar","ui.setup.welcome":"Bem Vindo","ui.setup.welcome1":"Este assistente irá levá-lo através dos passos necessários para configurar a sua instalação do CMS Contao Open Source.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"Apoio à Comunidade","ui.setup.start":"ComeceComece","ui.setup.complete":"Parabéns!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Configuração do Webserver","ui.setup.document-root.warning":"Para instalar o Contao através do Contao Manager, é necessário fixar a raiz do documento no servidor web.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Se não souber como configurar a raiz do seu documento, leia a documentação do Contacto ou contacte o seu fornecedor de alojamento.","ui.setup.document-root.documentation":"Ler a Documentação","ui.setup.document-root.conflictsTitle":"Directório de instalação não vazio","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"Quero instalar o Contao no directório dos não vazios. Compreendo que isto pode substituir quaisquer ficheiros existentes no meu espaço web.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Criar directórios","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Configuração de directório","ui.setup.document-root.formText1":"O Contao Manager pode criar automaticamente uma nova estrutura de directório no servidor.","ui.setup.document-root.formText2":"Será necessário configurar manualmente a raiz do novo documento (por exemplo, através de um painel de administração de alojamento).","ui.setup.document-root.autoconfig":"Compreendo que tenho de alterar a configuração do meu servidor. Não configurar a raiz do documento irá quebrar o Contao Manager e expor os ficheiros de configuração (incluindo detalhes de conta e palavras-passe)!","ui.setup.document-root.directory":"Novo Directório","ui.setup.document-root.currentRoot":"Raiz do documento actual","ui.setup.document-root.newRoot":"Novo Documento Raiz","ui.setup.document-root.finish":"Directórios de configuração","ui.setup.document-root.publicDir":"Utilizar {dir} para ficheiros públicos (para Contao {version})","ui.setup.document-root.directoryInvalid":"Por favor, introduza um nome de directório válido.","ui.setup.document-root.directoryExists":"O directório alvo já existe. Por favor, introduza um nome diferente.","ui.setup.document-root.confirmation":"O Contao Manager criou com sucesso o directório necessário para a sua instalação de Contao. Tem agora de configurar a raiz do documento no seu servidor web. Não volte a carregar esta página até lá.","ui.setup.document-root.reload":"Recarregar Página","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Instalação Contao","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Mais Recente","ui.setup.create-project.ltsTitle":"Suporte a Longo Prazo (LTS)","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"Ver o {contaoReleasePlan} para informações detalhadas.","ui.setup.create-project.releaseplanLink":"Plano de lançamento do Contao","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Versão","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Instalação Mínima ( Apenas o \\"core\\")","ui.setup.create-project.noUpdate":"Ignorar Instalação (Utilizador avançado!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versão","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Instalar","ui.setup.create-project.cancel":"Cancelar","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Utilizador","ui.setup.database-connection.password":"Senha","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Guardar","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Criar Conta","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Utilizador","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Senha","ui.setup.backend-user.passwordPlaceholder":"min. 8 caracteres","ui.setup.backend-user.passwordLength":"Por favor utilize o minimo de 8 caracteres.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Tarefa de fundo","ui.task.loading":"Carregamento de detalhes ...","ui.task.created":"Carregamento de detalhes ...","ui.task.active":"Por favor aguarde enquanto o Gestor de Contacto está a executar operações de tarefas em segundo plano.","ui.task.complete":"Todas as operações são concluídas com sucesso. Verifique a saída da consola para mais detalhes.","ui.task.paused":"Uma operação de fundo parou inesperadamente. Por favor, verifique a saída da consola.","ui.task.aborting":"Por favor aguarde enquanto as operações de fundo estão a ser canceladas.","ui.task.stopped":"Algumas operações de fundo foram canceladas. Por favor, verifique a saída da consola.","ui.task.error":"Uma operação de fundo parou inesperadamente. Por favor, verifique a saída da consola.","ui.task.failed":"O Gestor de Contao não conseguiu iniciar uma tarefa de fundo!","ui.task.failedDescription1":"Alguma coisa correu mal ao tentar executar operações em segundo plano.","ui.task.failedDescription2":"Se isto acontecer novamente, o seu servidor poderá não ser suportado.","ui.task.reportProblem":"Reportar um Problema","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Actualizar base de dados ","ui.task.buttonClose":"Fechar","ui.task.buttonConfirm":"Confirmar e Fechar","ui.task.buttonContinue":"Continuar","ui.task.buttonCancel":"Cancelar","ui.task.confirmCancel":"Tem a certeza que pretende interromper esta tarefa? Poderá afectar a instalação do Contao negativamente!","ui.task.autoclose":"Detalhes sobre o sucesso da tarefa","ui.console.toggle":"Mostrar/Esconder saída de Consola","ui.console.showLog":"Mostrar registo completo da consola","ui.console.copyLog":"Copiar log para prancheta","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Fechar","ui.migrate.confirm":"Confirmar e Fechar","ui.migrate.cancel":"Cancelar","ui.migrate.continue":"Continuar","ui.migrate.setup":"Configuração","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"Este campo não pode estar vazio.","ui.widget.blankOption":"Por favor seleccione ...","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"O pedido HTTP de \\"{method} {url}\\" falhou.","ui.error.server500":"Parece que ocorreu um erro inesperado no seu servidor. Por favor verifique os ficheiros de registo do seu servidor web (Apache/Nginx) e os registos do Contao Manager em \\"Contao-manager/logs\\".","ui.error.response":"O servidor devolveu uma resposta com o código de estado {status}.","ui.error.moreLink":"Mais informação ","ui.error.support":"Contao Support","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Ajuda","ui.footer.reportProblem":"Reportar um Problema","ui.navigation.discover":"Descubra","ui.navigation.packages":"Pacotes","ui.navigation.tools":"Ferramentas","ui.navigation.installTool":"Ferramenta de Instalação","ui.navigation.backend":"Backend Contao","ui.navigation.debug":"Depuração Contao","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informação PHP","ui.navigation.phpinfoLoading":"Carregamento de informação PHP","ui.navigation.maintenance":"Manutenção","ui.navigation.rebuildCache":"Reconstruir Cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Verificar Sistema","ui.navigation.advanced":"Avançado","ui.navigation.logout":"Terminar Sessão","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Cache de Aplicação","ui.maintenance.rebuildCache.description":"Reconstruir a cache da aplicação é necessário após modificar quaisquer dos ficheiros de configuração.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruir Cache de Produção","ui.maintenance.rebuildCache.rebuildDev":"Reconstruir Cache Desenvolvimento","ui.maintenance.rebuildCache.clearProd":"Limpar Cache Produção","ui.maintenance.rebuildCache.clearDev":"Limpar Cache Desenvolvimento","ui.maintenance.installTool.title":"Ferramenta de Instalação do Contao","ui.maintenance.installTool.description":"A Ferramenta de Instalação do Contao bloqueia automaticamente caso a senha seja introduzida erradamente três vezes.","ui.maintenance.installTool.unlock":"Desbloquear ferramenta de instalação","ui.maintenance.installTool.lock":"Bloquear ferramenta de instalação","ui.maintenance.dumpAutoload.title":"Carregador de Classes Composer","ui.maintenance.dumpAutoload.description":"O Composer autoloader é responsável por carregar classes PHP. O autoloader tem que ser \\"dumped\\" após adicionar namespaces personalizados ao root compser.json .","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dependências Composer ","ui.maintenance.composerInstall.description":"As dependências dos Composer estão localizadas na pasta {vendor} na raiz da sua aplicação. A reinstalação das dependências pode ser necessária após manipulação ou carregamento manual do ficheiro {composerLock}.","ui.maintenance.composerInstall.button":"Executar Instalador","ui.maintenance.composerInstall.update":"Executar Actualizador Composer","ui.maintenance.composerCache.title":"Cache Composer","ui.maintenance.composerCache.description":"O Composer guarda cache de pacotes provenientes de download para melhor performance. Caso tenha problemas com ficheiros não funcionais, apagar a Composer cache para forçar um novo download poderá resolver o problema.","ui.maintenance.composerCache.button":"Apagar Cache","ui.maintenance.maintenanceMode.title":"Modo Manutenção","ui.maintenance.maintenanceMode.description":"Colocar o Contao em modo de manutenção exibirá um modelo \\"503 Serviço Indisponível\\" para o website.","ui.maintenance.maintenanceMode.enable":"Activar","ui.maintenance.maintenanceMode.disable":"Desactivar","ui.maintenance.debugMode.title":"Modo Depuração","ui.maintenance.debugMode.description":"Activar o modo de depuração definindo um utilizador e uma palavra-passe para o ponto de entrada {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Active o modo de depuração ao definir o cookie de depuração para o domínio corrente.","ui.maintenance.debugMode.activate":"Activar","ui.maintenance.debugMode.deactivate":"Desactivar","ui.maintenance.debugMode.credentials":"Credenciais","ui.maintenance.debugMode.user":"Por favor introduza um nome de utilizador para o modo de depuração.","ui.maintenance.debugMode.password":"Por favor introduza uma senha para o modo de depuração.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"O Opcode efectua cache de ficheiros PHP no processo web para mais rápida execução. Deverá ser apagado dentro de certas  circunstâncias caso ficheiros não sejam reconhecidos após edição.","ui.maintenance.opcodeCache.button":"Truncar Cache","ui.maintenance.safeMode":"Nao disponível em Modo Segurança","ui.maintenance.unsupported":"Não suportado pela sua versão Contao","ui.packages.updateButton":"Actualizar Pacotes","ui.packages.searchButton":"Procurar Pacotes","ui.packages.searchPlaceholder":"Procurar Pacotes ...","ui.packages.uploadOverlay":"Arrastar e largar ficheiros para upload","ui.packages.uploadButton":"Carregar Packages","ui.packages.uploadMessage":"Tem um carregamento não confirmado. | Tem {count} uploads não confirmados.","ui.packages.uploadApply":"Confirmar Uploads","ui.packages.uploadReset":"Apagar Uploads","ui.packages.uploadIncomplete":"Este ficheiro não foi uploaded completamente. Por favor remova-o e tente novamente.","ui.packages.uploadDuplicate":"Este ficheiro aparenta ter sido uploaded  várias vezes. Por favor remova os duplicados.","ui.packages.uploadInstalled":"Este ficheiro já se encontra instalado. Por favor remova os duplicados.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"Tem uma alteração não confirmada. | Tem {count} alterações não confirmadas.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Aplicar Alterações","ui.packages.changesApplyAll":"Actualizar todos os pacotes","ui.packages.changesDryrunAll":"Funcionamento a seco todos os pacotes","ui.packages.changesReset":"Reverter Alterações","ui.packages.changesReview":"Rever Alterações","ui.packagelist.loading":"A Carregar ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Novos pacotes","ui.packagelist.installed":"Pacotes instalados","ui.package.hintRevert":"Reverter Alterações","ui.package.hintNoupdate":"Não actualizar","ui.package.hintConstraint":" Este pacote será instalado com limitações de entrada {constraint} quando aplicar alterações.","ui.package.hintConstraintBest":"Este pacote será instalado com a melhor versão disponível quando aplicar alterações.","ui.package.hintConstraintChange":"As limitações de entrada para este pacote serão alteradas de \\"{from}\\" para \\"{to}\\" quando  aplicar alterações.","ui.package.hintConstraintUpdate":"Este pacote será actualizado quando aplicar alterações. ","ui.package.hintAdded":"Este pacote vai ser instalado quando aplicar as alterações.","ui.package.hintRemoved":"Este pacote será removido quando aplicar alterações.","ui.package.requiredTitle":"manualmente adicionado","ui.package.requiredText":"Este pacote é requerido pelo seu composer.json mas não está instalado.","ui.package.removedTitle":"manualmente removido","ui.package.removedText":"Este pacote vai ser removido do seu composer.json.","ui.package.installed":"Actualmente instalado:","ui.package.version":"Versão {version}","ui.package.additionalDownloads":"{count} Descarregar | {count} Descarregar","ui.package.additionalStars":"{count} Estrela | {count} Estrelas","ui.package.editConstraint":"Editar","ui.package.uploadConstraint":"Esta restrição está definida pelo pacote que foi uploaded.","ui.package.updateButton":"Actualizar","ui.package.removeButton":"Remover","ui.package.installButton":"Adicionar Pacote","ui.package.installButtonShort":"Adicionar","ui.package.detailsButton":"Detalhes","ui.package.latestConstraint":"versão mais recente","ui.package.update":"Actualização disponível","ui.package.updateLatest":"versão mais recente","ui.package.updateAvailable":"{version} disponível","ui.package.updateUnknown":"versão desconhecida","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versão {version}","ui.cloudStatus.waitingTime":"Tempo de Espera","ui.cloudStatus.jobs":"Tarefas Actuais","ui.cloudStatus.workers":"Trabalhadores","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nenhum","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} seg","ui.cloudStatus.error":"Incapaz de obter o estatuto de Composer Resolver Cloud. Pode ser para questões de manutenção ou de experiência.","ui.cloudStatus.button":"Estado das nuvens","ui.cloudStatus.refresh":"Actualizar o estado das nuvens","ui.log-viewer.loading":"A Carregar ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 caracteres","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Cancelar","ui.user-manager.close":"Fechar","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Activar","ui.totp.disable":"Desactivar","ui.totp.cancel":"Cancelar","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[180],{2180:function(e){e.exports=JSON.parse('{"ui.app.title":"Extensiones Contao","ui.app.loading":"Cargando lista de extensiones ...","ui.app.language":"Cambiar idioma para el Contao Manager","ui.app.colorDark":"Modo oscuro","ui.app.colorDarkTitle":"Cambiar el esquema de color a oscuro","ui.app.colorLight":"Modo claro","ui.app.colorLightTitle":"Cambiar el esquema de color a claro","ui.discover.advertisement":"Aviso en la lista de extensiones","ui.discover.loading":"Cargando ...","ui.discover.offline":"No se pudo obtener ningún resultado.","ui.discover.offlineExplain":"Verifique su conexión a Internet y desactive los bloqueadores de JavaScript en su navegador.","ui.discover.offlineButton":"Inténtelo de nuevo","ui.discover.searchPlaceholder":"Buscar en {count} extensiones…","ui.discover.empty":"No hay resultados para {query}","ui.discover.more":"Más resultados","ui.discover.sortBy":"Ordenar por","ui.discover.sortReleased":"Publicado","ui.discover.sortReleasedTitle":"Ordenar resultados por fecha de lanzamiento","ui.discover.sortLatest":"Actualizado","ui.discover.sortLatestTitle":"Ordenar resultados por última actualización","ui.discover.sortDownloads":"Descargas","ui.discover.sortDownloadsTitle":"Ordenar resultados por número de descargas","ui.discover.sortFavers":"Clasificación","ui.discover.sortFaversTitle":"Ordenar resultados por calificación","ui.discover.detailsButton":"Detalles","ui.discover.latestPackages":"Extensiones más recientes y actualizadas","ui.discover.faversPackages":"Extensiones mejor calificadas","ui.discover.downloadsPackages":"Extensiones más descargadas","ui.package.homepage":"Sitio web del proyecto","ui.package.private":"Paquete privado","ui.package.privateTitle":"Los paquetes privados solo están disponibles por parte del proveedor (por ejemplo, como descarga ZIP). Por favor, visite el sitio web para más información.","ui.package.abandoned":"abandonado","ui.package.abandonedText":"Este paquete está abandonado y ya no se mantiene.","ui.package.abandonedReplace":"su paquete es abandonado y ya no se mantiene. El autor sugiere usar el paquete {replacement} en su lugar.","ui.package.contaoVersion":"Disponible para Contao","ui.package-details.previous":"Detalles de extensiones anteriores","ui.package-details.close":"Cerrar detalles de extensión","ui.package-details.loading":"Cargando ...","ui.package-details.tabDescription":"Descripción","ui.package-details.tabRequire":"Requisitos","ui.package-details.tabFeatures":"Caracteristicas","ui.package-details.tabSuggest":"Sugerencias","ui.package-details.tabConflict":"Conflictos","ui.package-details.tabDependents":"Dependientes","ui.package-details.linkRequires":"requiere","ui.package-details.linkReplaces":"reemplaza","ui.package-details.linkProvides":"provee","ui.package-details.linkConflicts":"conflictos","ui.package-details.funding":"Mantenimiento del Fund Package!","ui.package-details.contaoVersions":"Version(es) compatible(s) de Contao","ui.package-details.latest":"Última versión","ui.package-details.released":"publicado el","ui.package-details.license":"Licencia(s)","ui.package-details.authors":"de","ui.package-details.more":"Más","ui.package-details.packagist":"Detalles del paquete","ui.package-details.metadata":"Editar metadatos","ui.package-details.support_docs":"Documentación","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Foro de sopporte","ui.package-details.support_issues":"Problemas / Informe de error","ui.package-details.support_source":"Código fuente","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Email del soporte ","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[874],{2874:function(e){e.exports=JSON.parse('{"ui.app.title":"Rozšíření Contaa","ui.app.loading":"Načítání seznamu rozšíření...","ui.app.language":"Změnit jazyk Správce Contaa","ui.app.colorDark":"Tmavé zobrazení","ui.app.colorDarkTitle":"Změnit na tmavé prostředí","ui.app.colorLight":"Světlé zobrazení","ui.app.colorLightTitle":"Změnit na světlé prostředí","ui.discover.advertisement":"Reklama v seznamu rozšíření","ui.discover.loading":"Spouštění…","ui.discover.offline":"Nemůžu načíst žádné výsledky.","ui.discover.offlineExplain":"Zkontrolujte prosím Vaše internetové připojení a deaktivujte blokování JavaScriptu ve Vašem prohlížeči.","ui.discover.offlineButton":"Zkusit znovu","ui.discover.searchPlaceholder":"Prohledat {count} rozšíření...","ui.discover.empty":"Žádné výsledky pro {query}","ui.discover.more":"Více výsledků","ui.discover.sortBy":"Seřadit podle","ui.discover.sortReleased":"Zveřejněno","ui.discover.sortReleasedTitle":"Seřadit výsledky podle zveřejnění","ui.discover.sortLatest":"Zaktualizované","ui.discover.sortLatestTitle":"Seřadit výsledky podle naposledy zaktualizovaných","ui.discover.sortDownloads":"Stažení","ui.discover.sortDownloadsTitle":"Seřadit výsledky podle počtu stažení","ui.discover.sortFavers":"Hodnocení","ui.discover.sortFaversTitle":"Seřadit výsledky podle hodnocení","ui.discover.detailsButton":"Podrobnosti","ui.discover.latestPackages":"Poslední a naposledy zaktualizovaná rozšíření","ui.discover.faversPackages":"Nejlépe hodnocená rozšíření","ui.discover.downloadsPackages":"Nejvíce stahovaná rozšíření","ui.package.homepage":"Stránka projektu","ui.package.private":"Soukromý balíček","ui.package.privateTitle":"Soukromé balíčky jsou dostupné pouze z vendoru (např. jako soubor ZIP). Více informací získáte na následujícím webu. ","ui.package.abandoned":"nepřijatý","ui.package.abandonedText":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí.","ui.package.abandonedReplace":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí. Autor místo něho doporučuje použít {replacement}. ","ui.package.contaoVersion":"Dostupné pro Contao","ui.package-details.previous":"Předešlé podrobné informace k rozšíření","ui.package-details.close":"Zavřít podrobné informace k rozšíření","ui.package-details.loading":"Spouštění…","ui.package-details.tabDescription":"Popis","ui.package-details.tabRequire":"Požadavky","ui.package-details.tabFeatures":"Funkce","ui.package-details.tabSuggest":"Doporučení","ui.package-details.tabConflict":"Konflikty","ui.package-details.tabDependents":"Závislosti","ui.package-details.linkRequires":"vyžaduje","ui.package-details.linkReplaces":"nahrazuje","ui.package-details.linkProvides":"poskytuje","ui.package-details.linkConflicts":"konflikty","ui.package-details.funding":"Nalezen vyvíjený balíček!","ui.package-details.contaoVersions":"Podporováno verzí Contaa","ui.package-details.latest":"Poslední verze","ui.package-details.released":"Zveřejněno","ui.package-details.license":"Licence","ui.package-details.authors":"od","ui.package-details.more":"Více","ui.package-details.packagist":"Podrobnosti k balíčku","ui.package-details.metadata":"Upravit meta informace","ui.package-details.support_docs":"Dokumentace","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Podpora ve fóru","ui.package-details.support_issues":"Chyby / nahlášení chyb","ui.package-details.support_source":"Zdrojový kód","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Mail podpory","ui.package-details.support_rss":"Kanál RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[748],{8367:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Веза није безбедна !!","ui.app.httpsDescription":"Ако не користите HTTPS ваши поверљиви подаци ће се преносити без енкрипције.","ui.app.httpsLink":"Детаљније","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Сигурни мод је омогућен !!","ui.app.safeModeDescription":"Неке функционалности Contao Manager-a нису доступне.","ui.app.safeModeExit":"Изађи из Сигурног мода","ui.app.limitedHeadline":"Даљинска аутентификација","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Покретање инсталације","ui.app.loading":"Contao Manager се учитава...","ui.app.apiError":"Неочекиван статус API","ui.app.configSecurity1":"УПОЗОРЕЊЕ !!! Пронађен је незаштићен config фолдер","ui.app.configSecurity2":"Contao Manager је открио да су конфигурациони фајлови јавно доступни. Све операције су обустављене док се config фолдер не заштити. У супротном би потенцијални нападач могао да приступи осетљивим подацима о Вашој инсталацији.\\n\\nДа поправите ово, осигурајте да приступ фолдеру \\"contao-manager\\" на Вашем серверу буде спречен. Ако је потребно да прво научите како то да урадите, прочитајте упутство за ваш сервер или контактирајте корисничку подршку Вашег хостинг провајдера.","ui.account.welcome":"Добро дошли","ui.account.intro1":"Добродошли у Contao Manager, универзални алат за инсталацију и управљање са Вашом инсталацијом Contao Open Source CMS. Ако се први пут срећете са њим, погледајте {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} да почнете","ui.account.introManual":"прочитајте приручник","ui.account.intro2":"Ако наиђете на неки проблем, проверите {ourGithubIssues}  и слободно креирајте нову тему за било шта што до сада није пријављено.","ui.account.introIssues":"наши GitHub проблеми","ui.account.headline":"Кориснички налог","ui.account.description":"Да управљате Вашом инсталацијом, потребно је да креирате налог за Contao Manager. Имајте на уму да овај налог није исто што и налог за Contao Фронт- и БекЕнд.","ui.account.username":"Корисничко име","ui.account.password":"Лозинка","ui.account.passwordPlaceholder":"мин. 8 знакова","ui.account.passwordLength":"Унесите барем 8 знакова.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Креирај налог","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao и Contao Manager су под покровитељством непрофитне организације Contao Association.","ui.account.contribute2":"Молимо Вас да размислите о томе да помогнете отвореном пројекту својом {donate}.","ui.account.contributeDonate":"донирање","ui.login.headline":"Пријава","ui.login.description":"Пријави се ради управљања инсталацијом.","ui.login.username":"Корисничко име","ui.login.password":"Лозинка","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Заборавили сте лозинку?","ui.login.button":"Пријава","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Откажи","ui.login.or":"или","ui.login.locked":"Приступ је одбијен јер је Contao Manager закључан. Да бисте га откључали, обришите {lockFile} у почетном директоријуму ваше Contao инсталације.","ui.logout.headline":"Сесија је истекла","ui.logout.warning":"Нисте били активни дуже од 25 минута. Из безбедносних разлога ваша сесија ће бити ускоро прекинута.","ui.logout.expired":"Ваша сесија је аутоматски прекинута јер сте били неактивни дуже од 30 минута.","ui.logout.renew":"Остани пријављен","ui.logout.logout":"Одјава","ui.logout.login":"Назад на пријаву","ui.oauth.error":"Неисправан OAuth покушај. Проверите параметре.","ui.oauth.https":"URI за редирекцију МОРА да користи сигурни протокол (https:) чиме се спречава да се аутентификациони токен преноси као обични текст.","ui.oauth.headline":"Даљинска аутентификација","ui.oauth.description":"Следеће апликације или сервиси захтевају удаљени приступ Вашој инстанци Contao Manager-а.","ui.oauth.domain":"Пре него што дозволите приступ, будите сигурни да познајете овај URL и имате поверење у власника!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this acce